/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;

public class DenseColumnFloatMatrix2DTest
extends FloatMatrix2DTest {
    public DenseColumnFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseColumnFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseColumnFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseColumnFloatMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testAssignFloatArray() {
        float[] fArray = new float[(int)this.A.size()];
        int n = 0;
        while ((long)n < this.A.size()) {
            fArray[n] = (float)Math.random();
            ++n;
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(fArray[n++] - this.A.getQuick(j, i)), (float)this.TOL);
            }
        }
    }

    public void testDct2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dct2(true);
        ((DenseColumnFloatMatrix2D)this.A).idct2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dctColumns(true);
        ((DenseColumnFloatMatrix2D)this.A).idctColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dctRows(true);
        ((DenseColumnFloatMatrix2D)this.A).idctRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDht2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dht2();
        ((DenseColumnFloatMatrix2D)this.A).idht2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dhtColumns();
        ((DenseColumnFloatMatrix2D)this.A).idhtColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dhtRows();
        ((DenseColumnFloatMatrix2D)this.A).idhtRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDst2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dst2(true);
        ((DenseColumnFloatMatrix2D)this.A).idst2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dstColumns(true);
        ((DenseColumnFloatMatrix2D)this.A).idstColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColumnFloatMatrix2D)this.A).dstRows(true);
        ((DenseColumnFloatMatrix2D)this.A).idstRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testFft2() {
        int n = 64;
        int n2 = 128;
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = new DenseColumnFloatMatrix2D(n, n2);
        FloatMatrix2D floatMatrix2D = denseColumnFloatMatrix2D.copy();
        denseColumnFloatMatrix2D.fft2();
        denseColumnFloatMatrix2D.ifft2(true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)((FloatMatrix2D)denseColumnFloatMatrix2D).getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testGetFft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseFComplexMatrix2D denseFComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getFft2();
        denseFComplexMatrix2D.ifft2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getIfft2(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fft2();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseFComplexMatrix2D denseFComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getFftColumns();
        denseFComplexMatrix2D.ifftColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getIfftColumns(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fftColumns();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseFComplexMatrix2D denseFComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getFftRows();
        denseFComplexMatrix2D.ifftRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColumnFloatMatrix2D)this.A).getIfftRows(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fftRows();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColumnFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColumnFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }
}

