/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DProcedure;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatFactory3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class FComplexMatrix3DTest
extends TestCase {
    protected FComplexMatrix3D A;
    protected FComplexMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected float TOL = 0.001f;

    public FComplexMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    this.A.setQuick(n3, n2, n, new float[]{(float)Math.random(), (float)Math.random()});
                }
            }
        }
        for (n3 = 0; n3 < this.B.slices(); ++n3) {
            for (n2 = 0; n2 < this.B.rows(); ++n2) {
                for (n = 0; n < this.B.columns(); ++n) {
                    this.B.setQuick(n3, n2, n, new float[]{(float)Math.random(), (float)Math.random()});
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    protected void assertEquals(float[] fArray, float[] fArray2, float f) {
        for (int i = 0; i < fArray2.length; ++i) {
            FComplexMatrix3DTest.assertEquals((float)fArray[i], (float)fArray2[i], (float)f);
        }
    }

    public void testAggregateComplexComplexComplexFunctionComplexComplexFunction() {
        float[] fArray = this.A.aggregate(FComplexFunctions.plus, FComplexFunctions.sqrt);
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    fArray2 = FComplex.plus(fArray2, FComplex.sqrt(this.A.getQuick(i, j, k)));
                }
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testAggregateComplexMatrix3FComplexComplexComplexFunctionComplexComplexComplexFunction() {
        float[] fArray = this.A.aggregate(this.B, FComplexFunctions.plus, FComplexFunctions.mult);
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i, j, k), this.B.getQuick(i, j, k)));
                }
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        this.A.assign(FComplexFunctions.acos);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(FComplex.acos(fComplexMatrix3D.getQuick(i, j, k)), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.B.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexMatrix3FComplexComplexComplexFunction() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        this.A.assign(this.B, FComplexFunctions.div);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(FComplex.div(fComplexMatrix3D.getQuick(i, j, k), this.B.getQuick(i, j, k)), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        this.A.assign(new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return FComplex.abs(fArray) > 3.0f;
            }
        }, FComplexFunctions.tan);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (FComplex.abs(fComplexMatrix3D.getQuick(i, j, k)) > 3.0f) {
                        FComplexMatrix3DTest.assertEquals((float)FComplex.abs(fComplexMatrix3D.getQuick(i, j, k)), (float)this.A.getQuick(i, j, k)[0], (float)this.TOL);
                        FComplexMatrix3DTest.assertEquals((float)0.0f, (float)this.A.getQuick(i, j, k)[1], (float)this.TOL);
                        continue;
                    }
                    this.assertEquals(fComplexMatrix3D.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexProcedureFloatArray() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return FComplex.abs(fArray) > 3.0f;
            }
        }, fArray);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (FComplex.abs(fComplexMatrix3D.getQuick(i, j, k)) > 3.0f) {
                        this.assertEquals(fArray, this.A.getQuick(i, j, k), this.TOL);
                        continue;
                    }
                    this.assertEquals(fComplexMatrix3D.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexRealFunction() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        this.A.assign(FComplexFunctions.abs);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)FComplex.abs(this.A.getQuick(i, j, k)), (float)this.A.getQuick(i, j, k)[0], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)0.0f, (float)this.A.getQuick(i, j, k)[1], (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatArray() {
        float[] fArray = new float[2 * (int)this.A.size()];
        int n = 0;
        while ((long)n < 2L * this.A.size()) {
            fArray[n] = (float)Math.random();
            ++n;
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)fArray[n], (float)this.A.getQuick(i, j, k)[0], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)fArray[n + 1], (float)this.A.getQuick(i, j, k)[1], (float)this.TOL);
                    n += 2;
                }
            }
        }
    }

    public void testAssignFloatArrayArrayArray() {
        int n;
        int n2;
        int n3;
        float[][][] fArray = new float[this.A.slices()][this.A.rows()][2 * this.A.columns()];
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < 2 * this.A.columns(); ++n) {
                    fArray[n3][n2][n] = (float)Math.random();
                }
            }
        }
        this.A.assign(fArray);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            FComplexMatrix3DTest.assertTrue((this.A.rows() == fArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                FComplexMatrix3DTest.assertTrue((2 * this.A.columns() == fArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.A.columns(); ++n) {
                    FComplexMatrix3DTest.assertEquals((float)fArray[n3][n2][2 * n], (float)this.A.getQuick(n3, n2, n)[0], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)fArray[n3][n2][2 * n + 1], (float)this.A.getQuick(n3, n2, n)[1], (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatFloat() {
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(fArray[0], fArray[1]);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(fArray, this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignImaginary() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        FloatMatrix3D floatMatrix3D = FloatFactory3D.dense.random(this.A.slices(), this.A.rows(), this.A.columns());
        this.A.assignImaginary(floatMatrix3D);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k)[1], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)fComplexMatrix3D.getQuick(i, j, k)[0], (float)this.A.getQuick(i, j, k)[0], (float)this.TOL);
                }
            }
        }
    }

    public void testAssignReal() {
        FComplexMatrix3D fComplexMatrix3D = this.A.copy();
        FloatMatrix3D floatMatrix3D = FloatFactory3D.dense.random(this.A.slices(), this.A.rows(), this.A.columns());
        this.A.assignReal(floatMatrix3D);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k)[0], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)fComplexMatrix3D.getQuick(i, j, k)[1], (float)this.A.getQuick(i, j, k)[1], (float)this.TOL);
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)n);
    }

    public void testEqualsFloatArray() {
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(fArray[0], fArray[1]);
        boolean bl = this.A.equals(fArray);
        FComplexMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(new float[]{fArray[0] + 1.0f, fArray[1] + 1.0f});
        FComplexMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FComplexMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        FComplexMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testGetImaginaryPart() {
        FloatMatrix3D floatMatrix3D = this.A.getImaginaryPart();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k)[1], (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testGetRealPart() {
        FloatMatrix3D floatMatrix3D = this.A.getRealPart();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k)[0], (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testGetNonZeros() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList.size());
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList2.size());
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList3.size());
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)arrayList.size());
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(intArrayList.get(n), intArrayList2.get(n), intArrayList3.get(n)), arrayList.get(n), this.TOL);
                    ++n;
                }
            }
        }
    }

    public void testToArray() {
        float[][][] fArray = this.A.toArray();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    FComplexMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k)[0], (float)fArray[i][j][2 * k], (float)this.TOL);
                    FComplexMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k)[1], (float)fArray[i][j][2 * k + 1], (float)this.TOL);
                }
            }
        }
    }

    public void testVectorize() {
        FComplexMatrix1D fComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                for (int k = 0; k < this.A.rows(); ++k) {
                    this.assertEquals(this.A.getQuick(i, k, j), fComplexMatrix1D.getQuick(n++), this.TOL);
                }
            }
        }
    }

    public void testViewColumn() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewColumn(this.A.columns() / 2);
        FComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)fComplexMatrix2D.rows());
        FComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                this.assertEquals(this.A.getQuick(i, j, this.A.columns() / 2), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewColumnFlip() {
        FComplexMatrix3D fComplexMatrix3D = this.A.viewColumnFlip();
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)fComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, j, this.A.columns() - 1 - k), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewDice() {
        FComplexMatrix3D fComplexMatrix3D = this.A.viewDice(2, 1, 0);
        FComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)fComplexMatrix3D.columns());
        FComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix3D.rows());
        FComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix3D.slices());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, j, k), fComplexMatrix3D.getQuick(k, j, i), this.TOL);
                }
            }
        }
    }

    public void testViewPart() {
        FComplexMatrix3D fComplexMatrix3D = this.A.viewPart(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3);
        for (int i = 0; i < this.A.slices() / 3; ++i) {
            for (int j = 0; j < this.A.rows() / 3; ++j) {
                for (int k = 0; k < this.A.columns() / 3; ++k) {
                    this.assertEquals(this.A.getQuick(this.A.slices() / 2 + i, this.A.rows() / 2 + j, this.A.columns() / 2 + k), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewRow() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewRow(this.A.rows() / 2);
        FComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)fComplexMatrix2D.rows());
        FComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i, this.A.rows() / 2, j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRowFlip() {
        FComplexMatrix3D fComplexMatrix3D = this.A.viewRowFlip();
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)fComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, this.A.rows() - 1 - j, k), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewSelectionComplexMatrix2DProcedure() {
        final float[] fArray = new float[]{2.0f, 3.0f};
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, 0, fArray);
        FComplexMatrix3D fComplexMatrix3D = this.A.viewSelection(new FComplexMatrix2DProcedure(){

            public boolean apply(FComplexMatrix2D fComplexMatrix2D) {
                return FComplex.isEqual(fComplexMatrix2D.getQuick(FComplexMatrix3DTest.this.A.rows() / 2, 0), fArray, FComplexMatrix3DTest.this.TOL);
            }
        });
        FComplexMatrix3DTest.assertEquals((int)1, (int)fComplexMatrix3D.slices());
        FComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix3D.rows());
        FComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix3D.columns());
        this.assertEquals(this.A.getQuick(this.A.slices() / 2, this.A.rows() / 2, 0), fComplexMatrix3D.getQuick(0, this.A.rows() / 2, 0), this.TOL);
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.A.slices() / 2, this.A.slices() / 3};
        int[] nArray2 = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray3 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        FComplexMatrix3D fComplexMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        FComplexMatrix3DTest.assertEquals((int)nArray.length, (int)fComplexMatrix3D.slices());
        FComplexMatrix3DTest.assertEquals((int)nArray2.length, (int)fComplexMatrix3D.rows());
        FComplexMatrix3DTest.assertEquals((int)nArray3.length, (int)fComplexMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    this.assertEquals(this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewSlice() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewSlice(this.A.slices() / 2);
        FComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix2D.rows());
        FComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix2D.columns());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(this.A.getQuick(this.A.slices() / 2, i, j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSliceFlip() {
        FComplexMatrix3D fComplexMatrix3D = this.A.viewSliceFlip();
        FComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)fComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(this.A.slices() - 1 - i, j, k), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        FComplexMatrix3D fComplexMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < fComplexMatrix3D.slices(); ++i) {
            for (int j = 0; j < fComplexMatrix3D.rows(); ++j) {
                for (int k = 0; k < fComplexMatrix3D.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i * n, j * n2, k * n3), fComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testZSum() {
        float[] fArray = this.A.zSum();
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    fArray2 = FComplex.plus(fArray2, this.A.getQuick(i, j, k));
                }
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }
}

