/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class DefaultDoubleIterationMonitor
extends AbstractDoubleIterationMonitor {
    double initR;
    double rtol;
    double atol;
    double dtol;
    int maxIter;

    public DefaultDoubleIterationMonitor(int n, double d, double d2, double d3) {
        this.maxIter = n;
        this.rtol = d;
        this.atol = d2;
        this.dtol = d3;
    }

    public DefaultDoubleIterationMonitor() {
        this.maxIter = 100000;
        this.rtol = 1.0E-5;
        this.atol = 1.0E-50;
        this.dtol = 100000.0;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setRelativeTolerance(double d) {
        this.rtol = d;
    }

    public double getRelativeTolerance() {
        return this.rtol;
    }

    public void setAbsoluteTolerance(double d) {
        this.atol = d;
    }

    public double getAbsoluteTolerance() {
        return this.atol;
    }

    public void setDivergenceTolerance(double d) {
        this.dtol = d;
    }

    public double getDivergenceTolerance() {
        return this.dtol;
    }

    protected boolean convergedI(double d) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = d;
        }
        if (d < Math.max(this.rtol * this.initR, this.atol)) {
            return true;
        }
        if (d > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(d)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(double d, DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(d);
    }
}

