/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.DefaultDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class CGLSDoubleIterationMonitor
extends DefaultDoubleIterationMonitor {
    protected boolean convergedI(double d) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = d;
        }
        if (d <= this.rtol) {
            return true;
        }
        if (d > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(d)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(double d, DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(d);
    }
}

