/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultFirst;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected double[] values;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseRCDComplexMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCDComplexMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new double[2 * n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCDComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double d, double d2, boolean bl) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new double[2 * n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var12_12] = nArray2[n3];
            this.values[2 * var12_12] = d;
            this.values[2 * var12_12 + 1] = d2;
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseRCDComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * nArray.length != dArray.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new double[2 * n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var10_12] = nArray2[n3];
            this.values[2 * var10_12] = dArray[2 * n3];
            this.values[2 * var10_12 + 1] = dArray[2 * n3 + 1];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseRCDComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        if (2 * nArray2.length != dArray.length) {
            throw new IllegalArgumentException("2 * columnIndexes.length != values.length");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = dArray;
    }

    public DComplexMatrix2D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        if (dComplexDComplexFunction instanceof DComplexMult) {
            double[] dArray = ((DComplexMult)dComplexDComplexFunction).multiplicator;
            if (dArray[0] == 1.0 && dArray[1] == 0.0) {
                return this;
            }
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                return this.assign(dArray);
            }
            if (dArray[0] != dArray[0] || dArray[1] != dArray[1]) {
                return this.assign(dArray);
            }
            int n = this.cardinality();
            double[] dArray2 = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray2[0] = this.values[2 * i];
                dArray2[1] = this.values[2 * i + 1];
                dArray2 = DComplex.mult(dArray2, dArray);
                this.values[2 * i] = dArray2[0];
                this.values[2 * i + 1] = dArray2[1];
            }
        } else {
            this.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray) {
                    return dComplexDComplexFunction.apply(dArray);
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[2 * i] = d;
                this.values[2 * i + 1] = d2;
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof SparseRCDComplexMatrix2D) {
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = (SparseRCDComplexMatrix2D)dComplexMatrix2D;
            System.arraycopy(sparseRCDComplexMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCDComplexMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new double[2 * n];
            }
            System.arraycopy(sparseRCDComplexMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCDComplexMatrix2D.values, 0, this.values, 0, sparseRCDComplexMatrix2D.values.length);
        } else if (dComplexMatrix2D instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = ((SparseCCDComplexMatrix2D)dComplexMatrix2D).getConjugateTranspose();
            this.rowPointers = sparseCCDComplexMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCDComplexMatrix2D.getRowIndexes();
            this.values = sparseCCDComplexMatrix2D.getValues();
        } else {
            this.assign(0.0, 0.0);
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray) {
                    SparseRCDComplexMatrix2D.this.setQuick(n, n2, dArray);
                    return dArray;
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        Object object;
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof SparseRCDComplexMatrix2D && dComplexDComplexDComplexFunction == DComplexFunctions.plus) {
            object = (SparseRCDComplexMatrix2D)dComplexMatrix2D;
            int[] nArray = ((SparseRCDComplexMatrix2D)object).rowPointers;
            int[] nArray2 = ((SparseRCDComplexMatrix2D)object).columnIndexes;
            double[] dArray = ((SparseRCDComplexMatrix2D)object).values;
            int[] nArray3 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)nArray[this.rows]));
            int[] nArray4 = new int[n];
            double[] dArray2 = new double[2 * n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = n;
            if (dComplexDComplexDComplexFunction == DComplexFunctions.plus) {
                int n5;
                nArray3[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            dArray2[2 * n5] = this.values[2 * n6] + dArray[2 * n7];
                            dArray2[2 * n5 + 1] = this.values[2 * n6 + 1] + dArray[2 * n7 + 1];
                            nArray4[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray4[n5] = n11;
                            dArray2[2 * n5] = this.values[2 * n6];
                            dArray2[2 * n5 + 1] = this.values[2 * n6 + 1];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray4[n5] = n10;
                            dArray2[2 * n5] = dArray[2 * n7];
                            dArray2[2 * n5 + 1] = dArray[2 * n7 + 1];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray3[i + 1] = n5;
                }
                this.rowPointers = nArray3;
                this.columnIndexes = nArray4;
                this.values = dArray2;
                return this;
            }
        }
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond) {
            object = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator;
            if (object[0] == 0.0 && object[1] == 0.0) {
                return this;
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction((double[])object){
                final /* synthetic */ double[] val$alpha;
                {
                    this.val$alpha = dArray;
                }

                public double[] apply(int n, int n2, double[] dArray) {
                    SparseRCDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(SparseRCDComplexMatrix2D.this.getQuick(n, n2), DComplex.mult(this.val$alpha, dArray)));
                    return dArray;
                }
            });
            return this;
        }
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultFirst) {
            object = ((DComplexPlusMultFirst)dComplexDComplexDComplexFunction).multiplicator;
            if (object[0] == 0.0 && object[1] == 0.0) {
                return this.assign(dComplexMatrix2D);
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction((double[])object){
                final /* synthetic */ double[] val$alpha;
                {
                    this.val$alpha = dArray;
                }

                public double[] apply(int n, int n2, double[] dArray) {
                    SparseRCDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(DComplex.mult(this.val$alpha, SparseRCDComplexMatrix2D.this.getQuick(n, n2)), dArray));
                    return dArray;
                }
            });
            return this;
        }
        if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
            object = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                int n = this.rowPointers[i + 1];
                for (int j = this.rowPointers[i]; j < n; ++j) {
                    int n12 = this.columnIndexes[j];
                    object[0] = this.values[2 * j];
                    object[1] = this.values[2 * j + 1];
                    object = DComplex.mult((double[])object, dComplexMatrix2D.getQuick(i, n12));
                    this.values[2 * j] = (double)object[0];
                    this.values[2 * j + 1] = (double)object[1];
                    if (this.values[2 * j] != 0.0 || this.values[2 * j + 1] != 0.0) continue;
                    this.remove(i, n12);
                }
            }
            return this;
        }
        if (dComplexDComplexDComplexFunction == DComplexFunctions.div) {
            object = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                int n = this.rowPointers[i + 1];
                for (int j = this.rowPointers[i]; j < n; ++j) {
                    int n13 = this.columnIndexes[j];
                    object[0] = this.values[2 * j];
                    object[1] = this.values[2 * j + 1];
                    object = DComplex.div((double[])object, dComplexMatrix2D.getQuick(i, n13));
                    this.values[2 * j] = (double)object[0];
                    this.values[2 * j + 1] = (double)object[1];
                    if (this.values[2 * j] != 0.0 || this.values[2 * j + 1] != 0.0) continue;
                    this.remove(i, n13);
                }
            }
            return this;
        }
        return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction intIntDComplexFunction) {
        double[] dArray = new double[2];
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                int n2 = this.columnIndexes[j];
                dArray[0] = this.values[2 * j];
                dArray[1] = this.values[2 * j + 1];
                double[] dArray2 = intIntDComplexFunction.apply(i, n2, dArray);
                if (dArray2[0] == dArray[0] && dArray2[1] == dArray[1]) continue;
                this.values[2 * j] = dArray2[0];
                this.values[2 * j + 1] = dArray2[1];
            }
        }
        return this;
    }

    public SparseCCDComplexMatrix2D getColumnCompressed() {
        SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = this.getConjugateTranspose();
        SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = new SparseCCDComplexMatrix2D(this.rows, this.columns);
        sparseCCDComplexMatrix2D.rowIndexes = sparseRCDComplexMatrix2D.columnIndexes;
        sparseCCDComplexMatrix2D.columnPointers = sparseRCDComplexMatrix2D.rowPointers;
        sparseCCDComplexMatrix2D.values = sparseRCDComplexMatrix2D.values;
        return sparseCCDComplexMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseDComplexMatrix2D getDense() {
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDComplexFunction(){

            public double[] apply(int n, int n2, double[] dArray) {
                denseDComplexMatrix2D.setQuick(n, n2, SparseRCDComplexMatrix2D.this.getQuick(n, n2));
                return dArray;
            }
        });
        return denseDComplexMatrix2D;
    }

    public synchronized double[] getQuick(int n, int n2) {
        int n3 = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        double[] dArray = new double[2];
        if (n3 >= 0) {
            dArray[0] = this.values[2 * n3];
            dArray[1] = this.values[2 * n3 + 1];
        }
        return dArray;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCDComplexMatrix2D getConjugateTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        double[] dArray = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                dArray[2 * i] = this.values[2 * j];
                dArray[2 * i + 1] = -this.values[2 * j + 1];
            }
        }
        SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = new SparseRCDComplexMatrix2D(this.columns, this.rows);
        sparseRCDComplexMatrix2D.rowPointers = nArray2;
        sparseRCDComplexMatrix2D.columnIndexes = nArray3;
        sparseRCDComplexMatrix2D.values = dArray;
        return sparseRCDComplexMatrix2D;
    }

    public double[] getValues() {
        return this.values;
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new SparseRCDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = 2 * nArray[n];
                    this.values[n4] = this.values[n4] + this.values[2 * j];
                    int n5 = 2 * nArray[n] + 1;
                    this.values[n5] = this.values[n5] + this.values[2 * j + 1];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[2 * n2] = this.values[2 * j];
                this.values[2 * n2 + 1] = this.values[2 * j + 1];
                ++n2;
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        double d = Math.pow(2.0, -52.0);
        double[] dArray = new double[2];
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                dArray[0] = this.values[2 * j];
                dArray[1] = this.values[2 * j + 1];
                if (!(DComplex.abs(dArray) > d)) continue;
                this.values[2 * n] = this.values[2 * j];
                this.values[2 * n + 1] = this.values[2 * j + 1];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, double[] dArray) {
        int n3 = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                this.remove(n, n3);
            } else {
                this.values[2 * n3] = dArray[0];
                this.values[2 * n3 + 1] = dArray[1];
            }
            return;
        }
        if (dArray[0] != 0.0 || dArray[1] != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, dArray);
        }
    }

    public synchronized void setQuick(int n, int n2, double d, double d2) {
        int n3 = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0 && d2 == 0.0) {
                this.remove(n, n3);
            } else {
                this.values[2 * n3] = d;
                this.values[2 * n3 + 1] = d2;
            }
            return;
        }
        if (d != 0.0 || d2 != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d, d2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                if (this.values[2 * j + 1] > 0.0) {
                    stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0) {
                    stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2, final double[] dArray, final double[] dArray2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = dComplexMatrix1D2 == null || !bl;
        if (dComplexMatrix1D2 == null) {
            dComplexMatrix1D2 = new DenseDComplexMatrix1D(n);
        }
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D) || !(dComplexMatrix1D2 instanceof DenseDComplexMatrix1D)) {
            return super.zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray, dArray2, bl);
        }
        if ((long)n2 != dComplexMatrix1D.size() || (long)n > dComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + dComplexMatrix1D.toStringShort() + ", " + dComplexMatrix1D2.toStringShort());
        }
        DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D2;
        final double[] dArray3 = denseDComplexMatrix1D.elements;
        final int n3 = denseDComplexMatrix1D.stride();
        final int n4 = (int)dComplexMatrix1D2.index(0);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = (DenseDComplexMatrix1D)dComplexMatrix1D;
        final double[] dArray4 = denseDComplexMatrix1D2.elements;
        final int n5 = denseDComplexMatrix1D2.stride();
        final int n6 = (int)dComplexMatrix1D.index(0);
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!(bl2 || dArray2[0] == 1.0 && dArray2[1] == 0.0)) {
                dComplexMatrix1D2.assign(DComplexFunctions.mult(dArray2));
            }
            if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                n7 = 2;
                Future[] futureArray = new Future[n7];
                final double[] dArray5 = new double[2 * n];
                int n9 = this.rows / n7;
                for (n8 = 0; n8 < n7; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n7 - 1 ? this.rows : n10 + n9;
                    final int n12 = n8;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray6 = new double[2];
                            double[] dArray2 = new double[2];
                            if (n12 == 0) {
                                for (int i = n10; i < n11; ++i) {
                                    int n = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                    dArray6[0] = dArray4[n6 + n5 * i];
                                    dArray6[1] = dArray4[n6 + n5 * i + 1];
                                    dArray6 = DComplex.mult(dArray, dArray6);
                                    for (int j = SparseRCDComplexMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n2 = SparseRCDComplexMatrix2D.this.columnIndexes[j];
                                        dArray2[0] = SparseRCDComplexMatrix2D.this.values[2 * j];
                                        dArray2[1] = -SparseRCDComplexMatrix2D.this.values[2 * j + 1];
                                        dArray2 = DComplex.mult(dArray2, dArray6);
                                        int n32 = n4 + n3 * n2;
                                        dArray3[n32] = dArray3[n32] + dArray2[0];
                                        int n42 = n4 + n3 * n2 + 1;
                                        dArray3[n42] = dArray3[n42] + dArray2[1];
                                    }
                                }
                            } else {
                                for (int i = n10; i < n11; ++i) {
                                    int n = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                    dArray6[0] = dArray4[n6 + n5 * i];
                                    dArray6[1] = dArray4[n6 + n5 * i + 1];
                                    dArray6 = DComplex.mult(dArray, dArray6);
                                    for (int j = SparseRCDComplexMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n52 = SparseRCDComplexMatrix2D.this.columnIndexes[j];
                                        dArray2[0] = SparseRCDComplexMatrix2D.this.values[2 * j];
                                        dArray2[1] = -SparseRCDComplexMatrix2D.this.values[2 * j + 1];
                                        dArray2 = DComplex.mult(dArray2, dArray6);
                                        int n62 = 2 * n52;
                                        dArray5[n62] = dArray5[n62] + dArray2[0];
                                        int n7 = 2 * n52 + 1;
                                        dArray5[n7] = dArray5[n7] + dArray2[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n8 = 0; n8 < n; ++n8) {
                    int n13 = n4 + n8 * n3;
                    dArray3[n13] = dArray3[n13] + dArray5[2 * n8];
                    int n14 = n4 + n8 * n3 + 1;
                    dArray3[n14] = dArray3[n14] + dArray5[2 * n8 + 1];
                }
            } else {
                double[] dArray6 = new double[2];
                double[] dArray7 = new double[2];
                for (int i = 0; i < this.rows; ++i) {
                    int n15 = this.rowPointers[i + 1];
                    dArray6[0] = dArray4[n6 + n5 * i];
                    dArray6[1] = dArray4[n6 + n5 * i + 1];
                    dArray6 = DComplex.mult(dArray, dArray6);
                    for (int j = this.rowPointers[i]; j < n15; ++j) {
                        int n16 = this.columnIndexes[j];
                        dArray7[0] = this.values[2 * j];
                        dArray7[1] = -this.values[2 * j + 1];
                        dArray7 = DComplex.mult(dArray7, dArray6);
                        int n17 = n4 + n3 * n16;
                        dArray3[n17] = dArray3[n17] + dArray7[0];
                        int n18 = n4 + n3 * n16 + 1;
                        dArray3[n18] = dArray3[n18] + dArray7[1];
                    }
                }
            }
            return dComplexMatrix1D2;
        }
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n7 = Math.min(n7, this.rows);
            Future[] futureArray = new Future[n7];
            int n19 = this.rows / n7;
            for (int i = 0; i < n7; ++i) {
                final int n20 = i * n19;
                final int n21 = i == n7 - 1 ? this.rows : n20 + n19;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n20 * n3;
                        double[] dArray6 = new double[2];
                        double[] dArray22 = new double[2];
                        if (dArray2[0] == 0.0 && dArray2[1] == 0.0) {
                            for (int i = n20; i < n21; ++i) {
                                double[] dArray32 = new double[2];
                                int n2 = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                for (int j = SparseRCDComplexMatrix2D.this.rowPointers[i]; j < n2; ++j) {
                                    dArray6[0] = dArray4[n6 + n5 * SparseRCDComplexMatrix2D.this.columnIndexes[j]];
                                    dArray6[1] = dArray4[n6 + n5 * SparseRCDComplexMatrix2D.this.columnIndexes[j] + 1];
                                    dArray22[0] = SparseRCDComplexMatrix2D.this.values[2 * j];
                                    dArray22[1] = SparseRCDComplexMatrix2D.this.values[2 * j + 1];
                                    dArray32 = DComplex.plus(dArray32, DComplex.mult(dArray22, dArray6));
                                }
                                dArray32 = DComplex.mult(dArray, dArray32);
                                dArray3[n] = dArray32[0];
                                dArray3[n + 1] = dArray32[1];
                                n += n3;
                            }
                        } else {
                            double[] dArray42 = new double[2];
                            for (int i = n20; i < n21; ++i) {
                                double[] dArray5 = new double[2];
                                int n32 = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                for (int j = SparseRCDComplexMatrix2D.this.rowPointers[i]; j < n32; ++j) {
                                    dArray6[0] = dArray4[n6 + n5 * SparseRCDComplexMatrix2D.this.columnIndexes[j]];
                                    dArray6[1] = dArray4[n6 + n5 * SparseRCDComplexMatrix2D.this.columnIndexes[j] + 1];
                                    dArray22[0] = SparseRCDComplexMatrix2D.this.values[2 * j];
                                    dArray22[1] = SparseRCDComplexMatrix2D.this.values[2 * j + 1];
                                    dArray5 = DComplex.plus(dArray5, DComplex.mult(dArray22, dArray6));
                                }
                                dArray5 = DComplex.mult(dArray, dArray5);
                                dArray42[0] = dArray3[n];
                                dArray42[1] = dArray3[n + 1];
                                dArray42 = DComplex.mult(dArray2, dArray42);
                                dArray3[n] = dArray5[0] + dArray42[0];
                                dArray3[n + 1] = dArray5[1] + dArray42[1];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n22 = n4;
            double[] dArray8 = new double[2];
            double[] dArray9 = new double[2];
            if (dArray2[0] == 0.0 && dArray2[1] == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray10 = new double[2];
                    int n23 = this.rowPointers[i + 1];
                    for (int j = this.rowPointers[i]; j < n23; ++j) {
                        dArray8[0] = dArray4[n6 + n5 * this.columnIndexes[j]];
                        dArray8[1] = dArray4[n6 + n5 * this.columnIndexes[j] + 1];
                        dArray9[0] = this.values[2 * j];
                        dArray9[1] = this.values[2 * j + 1];
                        dArray10 = DComplex.plus(dArray10, DComplex.mult(dArray9, dArray8));
                    }
                    dArray10 = DComplex.mult(dArray, dArray10);
                    dArray3[n22] = dArray10[0];
                    dArray3[n22 + 1] = dArray10[1];
                    n22 += n3;
                }
            } else {
                double[] dArray11 = new double[2];
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray12 = new double[2];
                    int n24 = this.rowPointers[i + 1];
                    for (int j = this.rowPointers[i]; j < n24; ++j) {
                        dArray8[0] = dArray4[n6 + n5 * this.columnIndexes[j]];
                        dArray8[1] = dArray4[n6 + n5 * this.columnIndexes[j] + 1];
                        dArray9[0] = this.values[2 * j];
                        dArray9[1] = this.values[2 * j + 1];
                        dArray12 = DComplex.plus(dArray12, DComplex.mult(dArray9, dArray8));
                    }
                    dArray12 = DComplex.mult(dArray, dArray12);
                    dArray11[0] = dArray3[n22];
                    dArray11[1] = dArray3[n22 + 1];
                    dArray11 = DComplex.mult(dArray2, dArray11);
                    dArray3[n22] = dArray12[0] + dArray11[0];
                    dArray3[n22 + 1] = dArray12[1] + dArray11[1];
                    n22 += n3;
                }
            }
        }
        return dComplexMatrix1D2;
    }

    public DComplexMatrix2D zMult(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = dComplexMatrix2D.rows();
        int n4 = dComplexMatrix2D.columns();
        if (bl2) {
            n3 = dComplexMatrix2D.columns();
            n4 = dComplexMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = dComplexMatrix2D2 == null;
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = dComplexMatrix2D instanceof SparseRCDComplexMatrix2D ? new SparseRCDComplexMatrix2D(n, n5, n * n5) : new DenseDComplexMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? dComplexMatrix2D.viewDice() : dComplexMatrix2D).toStringShort());
        }
        if (dComplexMatrix2D2.rows() != n || dComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? dComplexMatrix2D.viewDice() : dComplexMatrix2D).toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
        }
        if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(bl3 || dArray2[0] == 1.0 && dArray2[1] == 0.0)) {
            dComplexMatrix2D2.assign(DComplexFunctions.mult(dArray2));
        }
        if (dComplexMatrix2D instanceof DenseDComplexMatrix2D && dComplexMatrix2D2 instanceof DenseDComplexMatrix2D) {
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            DenseDComplexMatrix2D denseDComplexMatrix2D = bl2 ? (DenseDComplexMatrix2D)dComplexMatrix2D.getConjugateTranspose() : (DenseDComplexMatrix2D)dComplexMatrix2D;
            DenseDComplexMatrix2D denseDComplexMatrix2D2 = (DenseDComplexMatrix2D)dComplexMatrix2D2;
            int[] nArray = sparseRCDComplexMatrix2D.rowPointers;
            int[] nArray2 = sparseRCDComplexMatrix2D.columnIndexes;
            double[] dArray3 = sparseRCDComplexMatrix2D.values;
            double[] dArray4 = new double[2];
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i + 1];
                for (int j = nArray[i]; j < n6; ++j) {
                    dArray4[0] = dArray3[2 * j];
                    dArray4[1] = dArray3[2 * j + 1];
                    double[] dArray5 = DComplex.mult(dArray, dArray4);
                    int n7 = nArray2[j];
                    denseDComplexMatrix2D2.viewRow(i).assign(denseDComplexMatrix2D.viewRow(n7), DComplexFunctions.plusMultSecond(dArray5));
                }
            }
        } else if (dComplexMatrix2D instanceof SparseRCDComplexMatrix2D && dComplexMatrix2D2 instanceof SparseRCDComplexMatrix2D) {
            int n8;
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = (SparseRCDComplexMatrix2D)dComplexMatrix2D2;
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D2 = bl ? this.getConjugateTranspose() : this;
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D3 = bl2 ? ((SparseRCDComplexMatrix2D)dComplexMatrix2D).getConjugateTranspose() : (SparseRCDComplexMatrix2D)dComplexMatrix2D;
            int[] nArray = sparseRCDComplexMatrix2D2.rowPointers;
            int[] nArray3 = sparseRCDComplexMatrix2D2.columnIndexes;
            double[] dArray6 = sparseRCDComplexMatrix2D2.values;
            int[] nArray4 = sparseRCDComplexMatrix2D3.rowPointers;
            int[] nArray5 = sparseRCDComplexMatrix2D3.columnIndexes;
            double[] dArray7 = sparseRCDComplexMatrix2D3.values;
            int[] nArray6 = sparseRCDComplexMatrix2D.rowPointers;
            int[] nArray7 = sparseRCDComplexMatrix2D.columnIndexes;
            double[] dArray8 = sparseRCDComplexMatrix2D.values;
            int n9 = nArray7.length;
            int[] nArray8 = new int[n4 + 1];
            for (n8 = 0; n8 < nArray8.length; ++n8) {
                nArray8[n8] = -1;
            }
            n8 = -1;
            double[] dArray9 = new double[2];
            double[] dArray10 = new double[2];
            double[] dArray11 = new double[2];
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11 = nArray[i + 1];
                for (n10 = nArray[i]; n10 < n11; ++n10) {
                    dArray9[0] = dArray6[2 * n10];
                    dArray9[1] = dArray6[2 * n10 + 1];
                    double[] dArray12 = DComplex.mult(dArray, dArray9);
                    int n12 = nArray3[n10];
                    int n13 = nArray4[n12 + 1];
                    for (int j = nArray4[n12]; j < n13; ++j) {
                        int n14 = nArray5[j];
                        int n15 = nArray8[n14];
                        if (n15 == -1) {
                            if (++n8 >= n9) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray7[n8] = n14;
                            nArray8[n14] = n8;
                            dArray10[0] = dArray7[2 * j];
                            dArray10[1] = dArray7[2 * j + 1];
                            dArray10 = DComplex.mult(dArray12, dArray10);
                            dArray8[2 * n8] = dArray10[0];
                            dArray8[2 * n8 + 1] = dArray10[1];
                            continue;
                        }
                        dArray10[0] = dArray7[2 * j];
                        dArray10[1] = dArray7[2 * j + 1];
                        dArray10 = DComplex.mult(dArray12, dArray10);
                        int n16 = 2 * n15;
                        dArray8[n16] = dArray8[n16] + dArray10[0];
                        int n17 = 2 * n15 + 1;
                        dArray8[n17] = dArray8[n17] + dArray10[1];
                    }
                }
                for (n10 = nArray6[i]; n10 < n8 + 1; ++n10) {
                    nArray8[nArray7[n10]] = -1;
                }
                nArray6[i + 1] = n8 + 1;
            }
        } else {
            if (bl2) {
                dComplexMatrix2D = dComplexMatrix2D.getConjugateTranspose();
            }
            DComplexMatrix1D[] dComplexMatrix1DArray = new DComplexMatrix1D[n2];
            int n18 = n2;
            while (--n18 >= 0) {
                dComplexMatrix1DArray[n18] = dComplexMatrix2D.viewRow(n18);
            }
            DComplexMatrix1D[] dComplexMatrix1DArray2 = new DComplexMatrix1D[n];
            int n19 = n;
            while (--n19 >= 0) {
                dComplexMatrix1DArray2[n19] = dComplexMatrix2D2.viewRow(n19);
            }
            DComplexPlusMultSecond dComplexPlusMultSecond = DComplexPlusMultSecond.plusMult(new double[2]);
            int[] nArray = this.columnIndexes;
            double[] dArray13 = this.values;
            double[] dArray14 = new double[2];
            int n20 = this.rows;
            while (--n20 >= 0) {
                int n21 = this.rowPointers[n20];
                int n22 = this.rowPointers[n20 + 1];
                while (--n22 >= n21) {
                    int n23 = nArray[n22];
                    dArray14[0] = dArray13[2 * n22];
                    dArray14[1] = dArray13[2 * n22 + 1];
                    dComplexPlusMultSecond.multiplicator = DComplex.mult(dArray14, dArray);
                    if (!bl) {
                        dComplexMatrix1DArray2[n20].assign(dComplexMatrix1DArray[n23], dComplexPlusMultSecond);
                        continue;
                    }
                    dComplexMatrix1DArray2[n23].assign(dComplexMatrix1DArray[n20], dComplexPlusMultSecond);
                }
            }
        }
        return dComplexMatrix2D2;
    }

    private double cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            d += (double)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return d;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        double[] dArray = new double[2 * n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, dArray, 0, n2);
        this.values = dArray;
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, double[] dArray) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(2 * this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        doubleArrayList.beforeInsert(2 * n3, dArray[0]);
        doubleArrayList.beforeInsert(2 * n3 + 1, dArray[1]);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    protected void insert(int n, int n2, int n3, double d, double d2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(2 * this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        doubleArrayList.beforeInsert(2 * n3, d);
        doubleArrayList.beforeInsert(2 * n3 + 1, d2);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        doubleArrayList.remove(2 * n2);
        doubleArrayList.remove(2 * n2 + 1);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }
}

