/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;

public class SparseCCMDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDComplexMatrix1D[] elements;

    public SparseCCMDComplexMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseDComplexMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseDComplexMatrix1D(n);
        }
    }

    public SparseDComplexMatrix1D[] elements() {
        return this.elements;
    }

    public double[] getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, double[] dArray) {
        this.elements[n2].setQuick(n, dArray);
    }

    public void setQuick(int n, int n2, double d, double d2) {
        this.elements[n2].setQuick(n, d, d2);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseDComplexMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new SparseCCMDComplexMatrix2D(n, n2);
    }
}

