/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;

class SelectedDenseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix3D(double[] dArray, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = dArray;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    public double[] getQuick(int n, int n2, int n3) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        return new double[]{this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]], this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1]};
    }

    public double[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D instanceof SelectedDenseDComplexMatrix3D) {
            SelectedDenseDComplexMatrix3D selectedDenseDComplexMatrix3D = (SelectedDenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == selectedDenseDComplexMatrix3D.elements;
        }
        if (dComplexMatrix3D instanceof DenseDComplexMatrix3D) {
            DenseDComplexMatrix3D denseDComplexMatrix3D = (DenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == denseDComplexMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseDComplexMatrix3D(n, n2, n3);
    }

    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    public DComplexMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, int n3, double[] dArray) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = dArray[0];
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = dArray[1];
    }

    public void setQuick(int n, int n2, int n3, double d, double d2) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = d;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = d2;
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    public DComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDComplexMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }

    public DComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    public DoubleMatrix3D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    public DoubleMatrix3D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

