/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBufferConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer
extends PersistentObject
implements FloatBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected FloatBufferConsumer target;
    protected float[] elements;
    protected FloatArrayList list;
    protected int capacity;
    protected int size;

    public FloatBuffer(FloatBufferConsumer floatBufferConsumer, int n) {
        this.target = floatBufferConsumer;
        this.capacity = n;
        this.elements = new float[n];
        this.list = new FloatArrayList(this.elements);
        this.size = 0;
    }

    public void add(float f) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = f;
    }

    public void addAllOf(FloatArrayList floatArrayList) {
        int n = floatArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(floatArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

