/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBuffer2DConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer2D
extends PersistentObject
implements BooleanBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBuffer2DConsumer target;
    protected boolean[] xElements;
    protected boolean[] yElements;
    protected BooleanArrayList xList;
    protected BooleanArrayList yList;
    protected int capacity;
    protected int size;

    public BooleanBuffer2D(BooleanBuffer2DConsumer booleanBuffer2DConsumer, int n) {
        this.target = booleanBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new boolean[n];
        this.yElements = new boolean[n];
        this.xList = new BooleanArrayList(this.xElements);
        this.yList = new BooleanArrayList(this.yElements);
        this.size = 0;
    }

    public void add(boolean bl, boolean bl2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = bl;
        this.yElements[this.size++] = bl2;
    }

    public void addAllOf(BooleanArrayList booleanArrayList, BooleanArrayList booleanArrayList2) {
        int n = booleanArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(booleanArrayList, booleanArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

