/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.GeoSpatialDistribution;
import java.util.ArrayList;
import java.util.List;

public class MultiRegionGeoSpatialDistribution
extends GeoSpatialDistribution {
    private final List<GeoSpatialDistribution> regions;
    private final boolean union;
    private final boolean fillValue;

    public MultiRegionGeoSpatialDistribution(String string) {
        super(string);
        this.regions = new ArrayList<GeoSpatialDistribution>();
        this.union = false;
        this.fillValue = false;
    }

    public MultiRegionGeoSpatialDistribution(String string, List<GeoSpatialDistribution> list, boolean bl, boolean bl2) {
        super(string);
        this.regions = list;
        this.union = bl;
        this.fillValue = bl2;
    }

    @Override
    public double logPdf(double[] dArray) {
        if (this.fillValue) {
            for (GeoSpatialDistribution geoSpatialDistribution : this.regions) {
                if (Double.isInfinite(geoSpatialDistribution.logPdf(dArray))) continue;
                return geoSpatialDistribution.logPdf(dArray);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (this.union) {
            for (GeoSpatialDistribution geoSpatialDistribution : this.regions) {
                if (geoSpatialDistribution.logPdf(dArray) != 0.0) continue;
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        for (GeoSpatialDistribution geoSpatialDistribution : this.regions) {
            if (geoSpatialDistribution.logPdf(dArray) != Double.NEGATIVE_INFINITY) continue;
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public double[][] getScaleMatrix() {
        return null;
    }

    @Override
    public double[] getMean() {
        return null;
    }

    @Override
    public String getType() {
        return "geoSpatial";
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean getUnion() {
        return this.union;
    }

    public List<GeoSpatialDistribution> getRegions() {
        return this.regions;
    }
}

