/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class GraphMLUtils {
    public static final String GRAPH_NAME = "digraph";
    public static final String SPACE = " ";
    public static final String NEW_LINE = "\n";
    public static final String START_SECTION = "{";
    public static final String END_SECTION = "}";
    public static final String START_ATTRIBUTE = "[";
    public static final String END_ATTRIBUTE = "]";
    public static final String NEXT_ATTRIBUTE = ",";
    public static final String TAB = "\t";
    public static final String END_LINE = ";\n";
    public static final boolean printLengths = false;
    private static TranslationMap translation = new TranslationMap();
    private static IgnoreList ignoreList = new IgnoreList();

    private static void space(StringBuilder stringBuilder) {
        stringBuilder.append(SPACE);
    }

    private static void endLine(StringBuilder stringBuilder) {
        stringBuilder.append(END_LINE);
    }

    private static void newLine(StringBuilder stringBuilder) {
        stringBuilder.append(NEW_LINE);
    }

    private static void tab(StringBuilder stringBuilder) {
        stringBuilder.append(TAB);
    }

    private static void startSection(StringBuilder stringBuilder) {
        stringBuilder.append(START_SECTION);
    }

    private static void endSection(StringBuilder stringBuilder) {
        stringBuilder.append(END_SECTION);
    }

    private static void startAttribute(StringBuilder stringBuilder) {
        stringBuilder.append(START_ATTRIBUTE);
    }

    private static void endAttribute(StringBuilder stringBuilder) {
        stringBuilder.append(END_ATTRIBUTE);
    }

    private static void nextAttribute(StringBuilder stringBuilder) {
        stringBuilder.append(NEXT_ATTRIBUTE);
    }

    public static String dotFormat(Element element) {
        Object object;
        Object object22;
        Iterator iterator2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = element.getAttributeValue("id");
        stringBuilder.append(GRAPH_NAME);
        GraphMLUtils.space(stringBuilder);
        if (string != null) {
            stringBuilder.append(string);
            GraphMLUtils.space(stringBuilder);
        }
        GraphMLUtils.startSection(stringBuilder);
        GraphMLUtils.newLine(stringBuilder);
        GraphMLUtils.tab(stringBuilder);
        stringBuilder.append("size=\"6,6\"");
        GraphMLUtils.endLine(stringBuilder);
        GraphMLUtils.tab(stringBuilder);
        stringBuilder.append("edge[style=\"setlinewidth(2)\",arrowhead=none]");
        GraphMLUtils.endLine(stringBuilder);
        GraphMLUtils.tab(stringBuilder);
        stringBuilder.append("node[shape=plaintext,width=auto,fontname=Helvitica,fontsize=10]");
        GraphMLUtils.endLine(stringBuilder);
        List list = element.getChildren("node");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Iterator iterator2 : list) {
            object22 = ((Element)((Object)iterator2)).getAttributeValue("id");
            GraphMLUtils.tab(stringBuilder);
            stringBuilder.append((String)object22);
            object = ((Element)((Object)iterator2)).getAttributes();
            int n = 1;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = object.size();
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                Attribute attribute = (Attribute)iterator3.next();
                String string2 = attribute.getName();
                if (string2.compareTo("id") == 0) continue;
                if (string2.compareTo("isTip") == 0) {
                    bl2 = true;
                    try {
                        if (attribute.getBooleanValue()) {
                            arrayList.add(object22);
                        }
                    }
                    catch (DataConversionException dataConversionException) {
                        dataConversionException.printStackTrace();
                    }
                    ++n;
                    continue;
                }
                if (GraphMLUtils.ignore(string2)) continue;
                if (!bl) {
                    GraphMLUtils.space(stringBuilder);
                    GraphMLUtils.startAttribute(stringBuilder);
                    bl = true;
                } else {
                    GraphMLUtils.nextAttribute(stringBuilder);
                }
                stringBuilder.append(GraphMLUtils.translate(string2) + "=" + attribute.getValue());
                ++n;
            }
            if (!bl2) {
                if (!bl) {
                    GraphMLUtils.space(stringBuilder);
                    GraphMLUtils.startAttribute(stringBuilder);
                    bl = true;
                } else {
                    GraphMLUtils.nextAttribute(stringBuilder);
                }
                stringBuilder.append("label=\"\",shape=circle,height=0.02,width=0.2,fontsize=1");
            }
            if (bl) {
                GraphMLUtils.endAttribute(stringBuilder);
            }
            GraphMLUtils.endLine(stringBuilder);
        }
        List list2 = element.getChildren("edge");
        iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            String string3;
            object22 = (Element)iterator2.next();
            object = ((Element)object22).getAttributeValue("source");
            String string4 = ((Element)object22).getAttributeValue("target");
            GraphMLUtils.tab(stringBuilder);
            stringBuilder.append((String)object + " -> " + string4);
            String string5 = ((Element)object22).getAttributeValue("len");
            if (string5 != null) {
                // empty if block
            }
            if ((string3 = ((Element)object22).getAttributeValue("edgePartitions")) != null) {
                GraphMLUtils.space(stringBuilder);
                GraphMLUtils.startAttribute(stringBuilder);
                stringBuilder.append("label=\"" + string3 + "\"");
                GraphMLUtils.endAttribute(stringBuilder);
            }
            GraphMLUtils.endLine(stringBuilder);
        }
        if (arrayList.size() > 0) {
            GraphMLUtils.tab(stringBuilder);
            GraphMLUtils.startSection(stringBuilder);
            stringBuilder.append("rank=same;");
            for (Object object22 : arrayList) {
                GraphMLUtils.space(stringBuilder);
                stringBuilder.append((String)object22);
            }
            GraphMLUtils.endSection(stringBuilder);
            GraphMLUtils.newLine(stringBuilder);
        }
        GraphMLUtils.endSection(stringBuilder);
        return stringBuilder.toString();
    }

    private static String translate(String string) {
        String string2 = null;
        string2 = (String)translation.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private static boolean ignore(String string) {
        return ignoreList.contains(string);
    }

    private static class TranslationMap
    extends HashMap<String, String> {
        TranslationMap() {
            this.put("taxonName", "label");
        }
    }

    private static class IgnoreList
    extends ArrayList<String> {
        IgnoreList() {
            this.add("nodeHeight");
            this.add("isRoot");
        }
    }
}

