/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.util.Taxon;
import dr.evomodel.tipstatesmodel.TimeVaryingFrequenciesModel;
import dr.evomodel.treedatalikelihood.TipStateAccessor;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.List;

public class TipStateOperator
extends SimpleMCMCOperator {
    private final Taxon taxon;
    private final List<TipStateAccessor> treeLikelihoods;
    private final TimeVaryingFrequenciesModel frequencies;
    private final int patternCount;
    private static final boolean ONLy_USE_WITH_TIME_VARYING_MODEL = false;
    private int[] previousStates;
    private static final boolean DEBUG = false;

    public TipStateOperator(TimeVaryingFrequenciesModel timeVaryingFrequenciesModel, double d) {
        this.treeLikelihoods = timeVaryingFrequenciesModel.getAccessors();
        this.taxon = timeVaryingFrequenciesModel.getTaxon();
        this.frequencies = timeVaryingFrequenciesModel;
        this.patternCount = this.treeLikelihoods.get(0).getPatternCount();
        this.setWeight(d);
    }

    private void setCurrentStates(int n, int[] nArray) {
        for (TipStateAccessor tipStateAccessor : this.treeLikelihoods) {
            tipStateAccessor.setTipStates(n, nArray);
        }
    }

    private int[] getCurrentStates(int n) {
        int[] nArray = new int[this.patternCount];
        this.treeLikelihoods.get(0).getTipStates(n, nArray);
        if (this.treeLikelihoods.size() > 1) {
            int[] nArray2 = new int[this.patternCount];
            for (int i = 1; i < this.treeLikelihoods.size(); ++i) {
                this.treeLikelihoods.get(i).getTipStates(n, nArray2);
                if (!TipStateOperator.notEqual(nArray, nArray2)) continue;
                throw new RuntimeException("Inconsistent states");
            }
        }
        return nArray;
    }

    private static boolean notEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return true;
        }
        return false;
    }

    private int[] sample(double[] dArray) {
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = MathUtils.randomChoicePDF(dArray);
        }
        return nArray;
    }

    @Override
    public double doOperation() {
        double[] dArray = this.frequencies.getProbabilities(this.taxon);
        int n = this.frequencies.getTipIndex(this.taxon);
        this.previousStates = this.getCurrentStates(n);
        int[] nArray = this.sample(dArray);
        this.setCurrentStates(n, nArray);
        if (TipStateOperator.notEqual(this.previousStates, nArray)) {
            this.frequencies.makeDirty();
        }
        double d = 0.0;
        for (int i = 0; i < this.patternCount; ++i) {
            if (this.previousStates[i] < dArray.length) {
                d += Math.log(dArray[this.previousStates[i]]);
            }
            d -= Math.log(dArray[nArray[i]]);
        }
        return d;
    }

    @Override
    public String getOperatorName() {
        return "tipStateOperator";
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
        int n = this.frequencies.getTipIndex(this.taxon);
        this.setCurrentStates(n, this.previousStates);
    }
}

