/*
 * Decompiled with CFR 0.152.
 */
package sample;

import blbutil.ByteIndexArray;
import blbutil.CharIndexArray;
import blbutil.IntArray;
import blbutil.IntList;
import blbutil.ShiftedByteIndexArray;
import blbutil.WrappedIntArray;
import haplotype.SampleHapPairs;
import java.util.Arrays;
import java.util.stream.IntStream;

public class HaplotypeCoder {
    private final int nRefHaps;
    private final int nHaps;
    private final SampleHapPairs refHapPairs;
    private final SampleHapPairs targetHapPairs;

    public HaplotypeCoder(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2) {
        if (!sampleHapPairs.markers().equals(sampleHapPairs2.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        this.nRefHaps = sampleHapPairs.nHaps();
        this.nHaps = this.nRefHaps + sampleHapPairs2.nHaps();
        this.refHapPairs = sampleHapPairs;
        this.targetHapPairs = sampleHapPairs2;
    }

    public SampleHapPairs refHapPairs() {
        return this.refHapPairs;
    }

    public SampleHapPairs targetHapPairs() {
        return this.targetHapPairs;
    }

    public IntArray[] run(int n, int n2) {
        int n3;
        if (n >= n2) {
            throw new IllegalArgumentException("start > end");
        }
        IntArray[] intArrayArray = new IntArray[2];
        int[] nArray = IntStream.range(0, this.nHaps).toArray();
        int[] nArray2 = new int[this.nHaps];
        IntList intList = new IntList(1);
        intList.add(this.nHaps);
        for (n3 = n; n3 < n2; ++n3) {
            intList = this.partition(n3, nArray2, nArray, intList);
        }
        HaplotypeCoder.setAllelesToHapIndices(nArray2, intList, nArray);
        n3 = intList.size();
        if (n3 <= 128) {
            intArrayArray[0] = new ByteIndexArray(nArray2, 0, this.nRefHaps);
            intArrayArray[1] = new ByteIndexArray(nArray2, this.nRefHaps, this.nHaps);
        } else if (n3 <= 256) {
            intArrayArray[0] = new ShiftedByteIndexArray(nArray2, 0, this.nRefHaps);
            intArrayArray[1] = new ShiftedByteIndexArray(nArray2, this.nRefHaps, this.nHaps);
        } else if (n3 <= 65535) {
            intArrayArray[0] = new CharIndexArray(nArray2, 0, this.nRefHaps);
            intArrayArray[1] = new CharIndexArray(nArray2, this.nRefHaps, this.nHaps);
        } else {
            intArrayArray[0] = new WrappedIntArray(Arrays.copyOfRange(nArray2, 0, this.nRefHaps));
            intArrayArray[1] = new WrappedIntArray(Arrays.copyOfRange(nArray2, this.nRefHaps, this.nHaps));
        }
        return intArrayArray;
    }

    private IntList partition(int n, int[] nArray, int[] nArray2, IntList intList) {
        IntList intList2 = new IntList(4 * intList.size() / 3 + 1);
        this.setAlleles(n, nArray);
        int n2 = this.refHapPairs.marker(n).nAlleles();
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = intList.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = intList.get(i);
            for (int j = 0; j < n3; ++j) {
                int n7 = this.partition(nArray, nArray2, n4, n6, j);
                if (n7 <= n4) continue;
                intList2.add(n7);
                n4 = n7;
            }
            if (n6 > n4) {
                intList2.add(n6);
            }
            n4 = n6;
        }
        return intList2;
    }

    private void setAlleles(int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < this.nRefHaps; ++n2) {
            nArray[n2] = this.refHapPairs.allele(n, n2);
        }
        for (n2 = this.nRefHaps; n2 < this.nHaps; ++n2) {
            nArray[n2] = this.targetHapPairs.allele(n, n2 - this.nRefHaps);
        }
    }

    private int partition(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = n2;
        while (n < n4) {
            int n5 = nArray[nArray2[n]];
            if (n5 == n3) {
                ++n;
                continue;
            }
            int n6 = nArray2[--n4];
            nArray2[n4] = nArray2[n];
            nArray2[n] = n6;
        }
        return n4;
    }

    private static void setAllelesToHapIndices(int[] nArray, IntList intList, int[] nArray2) {
        int n = 0;
        int n2 = intList.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = intList.get(i);
            for (int j = n; j < n3; ++j) {
                nArray[nArray2[j]] = i;
            }
            n = n3;
        }
    }
}

