% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{str_escape}
\alias{str_escape}
\title{Escape regular expression metacharacters}
\usage{
str_escape(string)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}
}
\value{
A character vector the same length as \code{string}.
}
\description{
This function escapes metacharacter, the characters that have special
meaning to the regular expression engine. In most cases you are better
off using \code{\link[=fixed]{fixed()}} since it is faster, but \code{str_escape()} is useful
if you are composing user provided strings into a pattern.
}
\examples{
str_detect(c("a", "."), ".")
str_detect(c("a", "."), str_escape("."))
}
