## -----------------------------------------------------------------------------
library(rigr)

## -----------------------------------------------------------------------------
data(mri)

## -----------------------------------------------------------------------------
ttest(mri$ldl, null.hypoth = 125)

## -----------------------------------------------------------------------------
ttest(mri$ldl, by = mri$sex)

## -----------------------------------------------------------------------------
ttest(mri$ldl, null.hypoth = 125, conf.level = 0.9)
ttest(mri$ldl, by = mri$sex, var.eq = FALSE)

## -----------------------------------------------------------------------------
ttesti(length(mri$weight), mean(mri$weight), sd(mri$weight), null.hypoth = 155)

## -----------------------------------------------------------------------------
proptest(mri$ldl > 128, null.hypoth = 0.5, exact = FALSE)
proptest(mri$ldl > 128, null.hypoth = 0.5, exact = TRUE)

## -----------------------------------------------------------------------------
proptest(mri$ldl > 128, by = mri$sex)

## -----------------------------------------------------------------------------
proptesti(sum(mri$weight > 155), length(mri$weight), exact = FALSE, null.hypoth= 0.6)

## -----------------------------------------------------------------------------
## create the data
cf <- c(1153, 1132, 1165, 1460, 1162, 1493, 1358, 1453, 1185, 1824, 1793, 1930, 2075)
healthy <- c(996, 1080, 1182, 1452, 1634, 1619, 1140, 1123, 1113, 1463, 1632, 1614, 1836)

wilcoxon(cf, healthy, paired = TRUE)

## -----------------------------------------------------------------------------
wilcoxon(cf, healthy, paired = TRUE, conf.int = TRUE)

