/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.constraints;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.variables.IntVar;
import org.restopt.RestoptProblem;
import org.restopt.choco.PropEffectiveMeshSize;
import org.restopt.constraints.AbstractRestoptConstraint;
import org.restopt.exception.RestoptException;

public class EffectiveMeshSizeConstraint
extends AbstractRestoptConstraint {
    public static final String KEY_MESH = "mesh";
    protected int minMESH;
    protected int maxMESH;
    protected int precision;
    protected IntVar mesh;

    public EffectiveMeshSizeConstraint(RestoptProblem restoptProblem, double minMESH, double maxMESH, int precision) throws RestoptException {
        super(restoptProblem);
        this.minMESH = (int)(minMESH * Math.pow(10.0, precision));
        this.maxMESH = (int)(maxMESH * Math.pow(10.0, precision));
        this.precision = precision;
        this.problem.setMeshConstraint(this);
    }

    @Override
    public void post() {
        if (this.problem.getAdditionalVariables().containsKey(KEY_MESH)) {
            this.mesh = this.problem.getAdditionalVariables().get(KEY_MESH);
            this.getModel().arithm(this.mesh, ">=", this.minMESH).post();
            this.getModel().arithm(this.mesh, "<=", this.maxMESH).post();
        } else {
            this.mesh = this.problem.getModel().intVar(this.minMESH, this.maxMESH);
            Constraint meshCons = new Constraint("MESH_constraint", new PropEffectiveMeshSize(this.problem.getHabitatGraphVar(), this.mesh, this.problem.getGrid().getSizeCells(), this.problem.getLandscapeArea(), this.precision, true));
            this.problem.getModel().post(meshCons);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public IntVar getMesh() {
        return this.mesh;
    }
}

