/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.StdSet;
import org.chocosolver.util.objects.setDataStructures.bitset.Set_BitSet;
import org.chocosolver.util.objects.setDataStructures.bitset.Set_Std_BitSet;
import org.chocosolver.util.objects.setDataStructures.constant.Set_CstInterval;
import org.chocosolver.util.objects.setDataStructures.constant.Set_FixedArray;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_LinkedList;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap2;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap2;

public class SetFactory {
    public static boolean HARD_CODED = true;

    public static ISet makeStoredSet(SetType type, int offSet, Model model) {
        IEnvironment environment = model.getEnvironment();
        if (HARD_CODED) {
            if (type == SetType.SMALLBIPARTITESET) {
                return new Set_Std_Swap2(environment);
            }
            if (type == SetType.BIPARTITESET) {
                return new Set_Std_Swap(environment, offSet);
            }
            if (type == SetType.BITSET) {
                return new Set_Std_BitSet(environment, offSet);
            }
        }
        return new StdSet(model, SetFactory.makeSet(type, offSet));
    }

    public static ISet makeSet(SetType type, int offSet) {
        switch (type) {
            case RANGESET: {
                return SetFactory.makeRangeSet();
            }
            case BIPARTITESET: {
                return SetFactory.makeBipartiteSet(offSet);
            }
            case SMALLBIPARTITESET: {
                return SetFactory.makeSmallBipartiteSet();
            }
            case LINKED_LIST: {
                return SetFactory.makeLinkedList();
            }
            case BITSET: {
                return SetFactory.makeBitSet(offSet);
            }
            case FIXED_ARRAY: {
                throw new UnsupportedOperationException("Please use makeConstantSet method to create a " + (Object)((Object)SetType.FIXED_ARRAY) + " set");
            }
            case FIXED_INTERVAL: {
                throw new UnsupportedOperationException("Please use makeConstantSet method to create a " + (Object)((Object)SetType.FIXED_INTERVAL) + " set");
            }
        }
        throw new UnsupportedOperationException("Unsupported SetType " + (Object)((Object)type));
    }

    public static ISet makeRangeSet() {
        return new IntIterableRangeSet();
    }

    public static ISet makeLinkedList() {
        return new Set_LinkedList();
    }

    public static ISet makeBitSet(int offSet) {
        return new Set_BitSet(offSet);
    }

    public static ISet makeBipartiteSet(int offSet) {
        return new Set_Swap(offSet);
    }

    public static ISet makeSmallBipartiteSet() {
        return new Set_Swap2();
    }

    public static ISet makeConstantSet(int[] cst) {
        return new Set_FixedArray(cst);
    }

    public static ISet makeConstantSet(int lb, int ub) {
        return new Set_CstInterval(lb, ub);
    }
}

