/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.chocosolver.solver.variables.IntVar;

public class IntVarValueIterator
implements Iterator<Integer> {
    private final IntVar var;
    private int value;
    private int ub;

    public IntVarValueIterator(IntVar v) {
        this.var = v;
    }

    public void reset() {
        this.value = this.var.getLB() - 1;
        this.ub = this.var.getUB();
    }

    @Override
    public boolean hasNext() {
        return this.var.nextValue(this.value) <= this.ub;
    }

    @Override
    public Integer next() {
        this.value = this.var.nextValue(this.value);
        if (this.value > this.ub) {
            throw new NoSuchElementException("IntVarValueIterator for IntVar " + this.var + " has no more element");
        }
        return this.value;
    }
}

