/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.solver.variables.impl.scheduler.RealEvtScheduler;
import org.chocosolver.solver.variables.view.AbstractView;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.RealInterval;

public class RealView<I extends IntVar>
extends AbstractView<I>
implements RealVar {
    protected final I var;
    protected final double precision;

    public RealView(I var, double precision) {
        super("(real)" + var.getName(), (Variable[])new IntVar[]{var});
        this.var = var;
        this.precision = precision;
    }

    public I getVariable() {
        return this.var;
    }

    protected EvtScheduler createScheduler() {
        return new RealEvtScheduler();
    }

    @Override
    public String toString() {
        return "(real)" + this.var.toString();
    }

    @Override
    public double getLB() {
        return this.var.getLB();
    }

    @Override
    public double getUB() {
        return this.var.getUB();
    }

    @Override
    public void intersect(double l, double u, ICause cause) throws ContradictionException {
        this.var.updateBounds((int)Math.ceil(l), (int)Math.floor(u), cause);
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateLowerBound((int)Math.ceil(value - this.precision), (ICause)this)) {
            super.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateUpperBound((int)Math.floor(value + this.precision), (ICause)this)) {
            super.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        int c = 0;
        c += this.var.updateLowerBound((int)Math.ceil(lowerbound - this.precision), (ICause)this) ? 1 : 0;
        switch (c += this.var.updateUpperBound((int)Math.floor(upperbound + this.precision), (ICause)this) ? 2 : 0) {
            case 3: {
                super.notifyPropagators(RealEventType.BOUND, cause);
                return true;
            }
            case 2: {
                super.notifyPropagators(RealEventType.DECUPP, cause);
                return true;
            }
            case 1: {
                super.notifyPropagators(RealEventType.INCLOW, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void silentlyAssign(RealInterval bounds) {
        this.silentlyAssign(bounds.getLB(), bounds.getUB());
    }

    @Override
    public void silentlyAssign(double l, double u) {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (event != IntEventType.REMOVE) {
            super.notifyPropagators(this.transformEvent((IntEventType)event), this);
        }
    }

    public IEventType transformEvent(IntEventType evt) {
        switch (evt) {
            case REMOVE: {
                throw new UnsupportedOperationException("Cannot transform REMOVE event from int to real");
            }
            case INCLOW: {
                return RealEventType.INCLOW;
            }
            case DECUPP: {
                return RealEventType.DECUPP;
            }
        }
        return RealEventType.BOUND;
    }

    @Override
    public int getTypeAndKind() {
        return 68;
    }

    @Override
    public void tighten() {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public void project(ICause cause) throws ContradictionException {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public void collectVariables(TreeSet<RealVar> set) {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public void subExps(List<CArExpression> list) {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public boolean isolate(RealVar var, List<CArExpression> wx, List<CArExpression> wox) {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }

    @Override
    public void init() {
        throw new UnsupportedOperationException("Consider using a constraint instead of a view. See: model.eq(RealVar, IntVar)");
    }
}

