/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Arrays;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.view.BoolIntView;
import org.chocosolver.solver.variables.view.RealView;
import org.chocosolver.solver.variables.view.bool.BoolEqView;
import org.chocosolver.solver.variables.view.bool.BoolGeqView;
import org.chocosolver.solver.variables.view.bool.BoolNotView;
import org.chocosolver.solver.variables.view.bool.BoolSetView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedEdgeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedGraphUnionView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedNodeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.EdgeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.NodeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.UndirectedGraphUnionView;
import org.chocosolver.solver.variables.view.integer.IntAffineView;
import org.chocosolver.solver.variables.view.set.SetBoolsView;
import org.chocosolver.solver.variables.view.set.SetDifferenceView;
import org.chocosolver.solver.variables.view.set.SetIntersectionView;
import org.chocosolver.solver.variables.view.set.SetIntsView;
import org.chocosolver.solver.variables.view.set.SetNodeGraphView;
import org.chocosolver.solver.variables.view.set.SetPredecessorsGraphView;
import org.chocosolver.solver.variables.view.set.SetSuccessorsGraphView;
import org.chocosolver.solver.variables.view.set.SetUnionView;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.tools.VariableUtils;

public interface IViewFactory
extends ISelf<Model> {
    default public BoolVar boolNotView(BoolVar bool) {
        BoolVar not;
        if (bool.hasNot()) {
            return bool.not();
        }
        if (bool.isInstantiated()) {
            not = bool.getValue() == 1 ? ((Model)this.ref()).boolVar(false) : ((Model)this.ref()).boolVar(true);
        } else {
            if (((Model)this.ref()).getSettings().enableViews()) {
                not = new BoolNotView<BoolVar>(bool);
            } else {
                not = ((Model)this.ref()).boolVar("not(" + bool.getName() + ")");
                ((Model)this.ref()).arithm(not, "!=", bool).post();
            }
            not.setNot(true);
        }
        bool._setNot(not);
        not._setNot(bool);
        return not;
    }

    default public BoolVar setBoolView(SetVar setVar, int v) {
        return new BoolSetView<SetVar>(v, setVar);
    }

    default public BoolVar[] setBoolsView(SetVar setVar, int size, int offset) {
        BoolVar[] bools = new BoolVar[size];
        for (int i = 0; i < size; ++i) {
            bools[i] = this.setBoolView(setVar, i + offset);
        }
        return bools;
    }

    default public IntVar intView(int a, IntVar var, int b) {
        int ub;
        int lb;
        if (a == 1 && b == 0) {
            return var;
        }
        if (a == 0) {
            return ((Model)this.ref()).intVar(b);
        }
        if (var.isInstantiated()) {
            return ((Model)this.ref()).intVar(var.getValue() * a + b);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            for (int i = 0; i < var.getNbViews(); ++i) {
                IntAffineView v;
                if (!(var.getView(i) instanceof IntAffineView) || !(v = (IntAffineView)var.getView(i)).equals(var, a, b)) continue;
                return var.getView(i).asIntVar();
            }
            if (var instanceof IntAffineView) {
                IntAffineView view = (IntAffineView)var;
                int av = (view.p ? 1 : -1) * view.a * a;
                int bv = a * view.b + b;
                if (av == 1 && bv == 0) {
                    return view.getVariable();
                }
                return this.intView(av, (IntVar)view.getVariable(), bv);
            }
            return new IntAffineView<IntVar>(var, a, b);
        }
        if (a > 0) {
            lb = var.getLB() * a + b;
            ub = var.getUB() * a + b;
        } else {
            lb = var.getUB() * a + b;
            ub = var.getLB() * a + b;
        }
        String name = "(" + var.getName() + "*" + a + "+" + b + ")";
        IntVar ov = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, lb, ub, false) : ((Model)this.ref()).intVar(name, lb, ub, true);
        if (a == 1) {
            ((Model)this.ref()).arithm(var, "-", ov, "=", -b).post();
        } else if (a == -1) {
            ((Model)this.ref()).arithm(var, "+", ov, "=", b).post();
        } else if (b == 0) {
            ((Model)this.ref()).scalar(new IntVar[]{var}, new int[]{a}, "=", ov).post();
        } else {
            ((Model)this.ref()).scalar(new IntVar[]{var, ov}, new int[]{a, -1}, "=", -b).post();
        }
        return ov;
    }

    default public IntVar abs(IntVar var) {
        if (var.isInstantiated()) {
            return ((Model)this.ref()).intVar(Math.abs(var.getValue()));
        }
        if (var.getLB() >= 0) {
            return var;
        }
        if (var.getUB() <= 0) {
            return this.intView(-1, var, 0);
        }
        int ub = Math.max(-var.getLB(), var.getUB());
        String name = "|" + var.getName() + "|";
        IntVar abs = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, 0, ub, false) : ((Model)this.ref()).intVar(name, 0, ub, true);
        ((Model)this.ref()).absolute(abs, var).post();
        return abs;
    }

    default public IntVar offset(IntVar var, int b) {
        return this.intView(1, var, b);
    }

    default public BoolVar isEq(IntVar var, int v) {
        if (var.isInstantiatedTo(v)) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (!var.contains(v)) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (VariableUtils.isBool(var)) {
            BoolVar bvar = (BoolVar)var;
            if (v == 0) {
                return bvar.not();
            }
            return bvar;
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(var, v, BoolEqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return var.getView(p).asBoolVar();
            }
            return new BoolEqView<IntVar>(var, v);
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXeqC(var, v, b);
        return b;
    }

    default public BoolVar isGeq(IntVar var, int v) {
        if (var.getLB() >= v) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (var.getUB() < v) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (VariableUtils.isBool(var)) {
            BoolVar bvar = (BoolVar)var;
            if (!1.$assertionsDisabled && v != 1) {
                throw new AssertionError();
            }
            return bvar;
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(var, v, BoolGeqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return var.getView(p).asBoolVar();
            }
            return new BoolGeqView<IntVar>(var, v);
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXgtC(var, v - 1, b);
        return b;
    }

    default public BoolVar isLeq(IntVar var, int v) {
        return this.isGeq(var, v + 1).not();
    }

    default public IntVar mul(IntVar var, int a) {
        return this.intView(a, var, 0);
    }

    default public BoolVar isNeq(IntVar var, int v) {
        if (var.isInstantiatedTo(v)) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (!var.contains(v)) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(var, v, BoolEqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return var.getView(p).asBoolVar().not();
            }
            return new BoolEqView<IntVar>(var, v).not();
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXneC(var, v, b);
        return b;
    }

    default public IntVar neg(IntVar var) {
        return this.intView(-1, var, 0);
    }

    @Deprecated
    default public IntVar intOffsetView(IntVar var, int cste) {
        return this.intView(1, var, cste);
    }

    @Deprecated
    default public IntVar intMinusView(IntVar var) {
        return this.intView(-1, var, 0);
    }

    @Deprecated
    default public IntVar intScaleView(IntVar var, int cste) {
        return this.intView(cste, var, 0);
    }

    @Deprecated
    default public IntVar intAbsView(IntVar var) {
        return this.abs(var);
    }

    @Deprecated
    default public IntVar intAffineView(int a, IntVar x, int b) {
        return this.intView(a, x, b);
    }

    @Deprecated
    default public BoolVar intEqView(IntVar x, int c) {
        return this.isEq(x, c);
    }

    @Deprecated
    default public BoolVar intNeView(IntVar x, int c) {
        return this.isNeq(x, c);
    }

    @Deprecated
    default public BoolVar intLeView(IntVar x, int c) {
        return this.isLeq(x, c);
    }

    @Deprecated
    default public BoolVar intGeView(IntVar x, int c) {
        return this.isGeq(x, c);
    }

    public static int checkDeclaredView(IntVar x, int c, Class clazz, boolean check) {
        for (int i = 0; check && i < x.getNbViews(); ++i) {
            BoolIntView v;
            if (!clazz.isInstance(x.getView(i))) continue;
            if (clazz == BoolEqView.class) {
                v = (BoolEqView)x.getView(i);
                if (v.cste != c) continue;
                return i;
            }
            if (clazz != BoolGeqView.class) continue;
            v = (BoolGeqView)x.getView(i);
            if (((BoolGeqView)v).cste != c) continue;
            return i;
        }
        return -1;
    }

    default public RealVar realIntView(IntVar var, double precision) {
        if (((Model)this.ref()).getSettings().enableViews()) {
            return new RealView<IntVar>(var, precision);
        }
        double lb = var.getLB();
        double ub = var.getUB();
        RealVar rv = ((Model)this.ref()).realVar("(real)" + var.getName(), lb, ub, precision);
        ((Model)this.ref()).realIbexGenericConstraint("{0} = {1}", rv, var).post();
        return rv;
    }

    default public RealVar[] realIntViewArray(IntVar[] ints, double precision) {
        RealVar[] reals = new RealVar[ints.length];
        if (((Model)this.ref()).getSettings().enableViews()) {
            for (int i = 0; i < ints.length; ++i) {
                reals[i] = this.realIntView(ints[i], precision);
            }
        } else {
            for (int i = 0; i < ints.length; ++i) {
                double lb = ints[i].getLB();
                double ub = ints[i].getUB();
                reals[i] = ((Model)this.ref()).realVar("(real)" + ints[i].getName(), lb, ub, precision);
                ((Model)this.ref()).realIbexGenericConstraint("{0} = {1}", reals[i], ints[i]).post();
            }
        }
        return reals;
    }

    default public RealVar[][] realIntViewMatrix(IntVar[][] ints, double precision) {
        RealVar[][] vars = new RealVar[ints.length][ints[0].length];
        for (int i = 0; i < ints.length; ++i) {
            vars[i] = this.realIntViewArray(ints[i], precision);
        }
        return vars;
    }

    default public SetVar boolsSetView(BoolVar[] boolVars, int offset) {
        return new SetBoolsView(offset, boolVars);
    }

    default public SetVar intsSetView(IntVar[] intVars, int[] v, int offset) {
        return new SetIntsView(v, offset, intVars);
    }

    default public SetVar intsSetView(IntVar[] intVars, int v, int offset) {
        int[] vals = new int[intVars.length];
        Arrays.fill(vals, v);
        return this.intsSetView(intVars, vals, offset);
    }

    default public SetVar[] intsSetsView(IntVar[] intVars, int nbSets, int offset1, int offset2) {
        SetVar[] setVars = new SetVar[nbSets];
        for (int i = 0; i < nbSets; ++i) {
            setVars[i] = this.intsSetView(intVars, i + offset1, offset2);
        }
        return setVars;
    }

    default public SetVar setUnionView(SetVar ... sets) {
        return new SetUnionView("setUnion", sets);
    }

    default public SetVar setIntersectionView(SetVar ... sets) {
        return new SetIntersectionView("setIntersection", sets);
    }

    default public SetVar setDifferenceView(SetVar x, SetVar y) {
        return new SetDifferenceView("setDifference", x, y);
    }

    default public SetVar graphNodeSetView(GraphVar<? extends IGraph> g) {
        return new SetNodeGraphView<GraphVar<? extends IGraph>>(g);
    }

    default public SetVar graphSuccessorsSetView(DirectedGraphVar g, int node) {
        return new SetSuccessorsGraphView<DirectedGraphVar>(g, node);
    }

    default public SetVar graphPredecessorsSetView(DirectedGraphVar g, int node) {
        return new SetPredecessorsGraphView<DirectedGraphVar>(g, node);
    }

    default public SetVar graphNeighborsSetView(UndirectedGraphVar g, int node) {
        return new SetSuccessorsGraphView<UndirectedGraphVar>(g, node);
    }

    default public UndirectedGraphVar nodeInducedSubgraphView(UndirectedGraphVar g, ISet nodes, boolean exclude) {
        return new NodeInducedSubgraphView(g.getName() + "[" + nodes.toString() + "]", g, nodes, exclude);
    }

    default public DirectedGraphVar nodeInducedSubgraphView(DirectedGraphVar g, ISet nodes, boolean exclude) {
        return new DirectedNodeInducedSubgraphView(g.getName() + "[" + nodes.toString() + "]", g, nodes, exclude);
    }

    default public UndirectedGraphVar edgeInducedSubgraphView(UndirectedGraphVar g, int[][] edges, boolean exclude) {
        return new EdgeInducedSubgraphView(g.getName() + "{" + Arrays.deepToString((Object[])edges) + "}", g, edges, exclude);
    }

    default public DirectedGraphVar edgeInducedSubgraphView(DirectedGraphVar g, int[][] edges, boolean exclude) {
        return new DirectedEdgeInducedSubgraphView(g.getName() + "{" + Arrays.deepToString((Object[])edges) + "}", g, edges, exclude);
    }

    default public UndirectedGraphVar graphUnionView(UndirectedGraphVar ... graphVars) {
        return new UndirectedGraphUnionView("GraphUnionView", graphVars);
    }

    default public DirectedGraphVar graphUnionView(DirectedGraphVar ... graphVars) {
        return new DirectedGraphUnionView("GraphUnionView", graphVars);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

