/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.PoolManager;

public class GraphDecision<G extends GraphVar<?>>
extends Decision<G> {
    protected GraphDecisionOperator operator;
    protected int from;
    protected int to;
    protected final PoolManager<GraphDecision> poolManager;

    public GraphDecision(PoolManager<GraphDecision> poolManager) {
        super(2);
        this.poolManager = poolManager;
    }

    @Override
    public Object getDecisionValue() {
        if (this.to == -1) {
            return this.from;
        }
        return new int[]{this.from, this.to};
    }

    public void setNode(G variable, int node, GraphDecisionOperator operator) {
        super.set(variable);
        this.from = node;
        this.to = -1;
        this.operator = operator;
    }

    public void setEdge(G variable, int from, int to, GraphDecisionOperator operator) {
        super.set(variable);
        this.from = from;
        this.to = to;
        this.operator = operator;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            if (this.to == -1) {
                this.operator.apply((GraphVar)this.var, this.from, this);
            } else {
                this.operator.apply((GraphVar)this.var, this.from, this.to, this);
            }
        } else if (this.branch == 2) {
            if (this.to == -1) {
                this.operator.unapply((GraphVar)this.var, this.from, this);
            } else {
                this.operator.unapply((GraphVar)this.var, this.from, this.to, this);
            }
        }
    }

    @Override
    public void free() {
        this.poolManager.returnE(this);
    }

    public String toString() {
        if (this.to == -1) {
            return " node " + this.from + this.operator.toString();
        }
        return " edge (" + this.from + "," + this.to + ")" + this.operator.toString();
    }
}

