/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.assignments;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;

public final class DecisionOperatorFactory {
    private DecisionOperatorFactory() {
    }

    public static DecisionOperator<IntVar> makeIntEq() {
        return IntEqDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntNeq() {
        return IntNeqDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntSplit() {
        return IntSplitDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntReverseSplit() {
        return IntReverseSplitDecision.getInstance();
    }

    public static DecisionOperator<SetVar> makeSetForce() {
        return SetForceDecision.getInstance();
    }

    public static DecisionOperator<SetVar> makeSetRemove() {
        return SetRemoveDecision.getInstance();
    }

    public static GraphDecisionOperator makeGraphEnforce() {
        return GraphEnforceDecision.getInstance();
    }

    public static GraphDecisionOperator makeGraphRemove() {
        return GraphRemoveDecision.getInstance();
    }

    private static final class IntEqDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 7293773317776136982L;
        private static final IntEqDecision INSTANCE = new IntEqDecision();

        private IntEqDecision() {
        }

        public static IntEqDecision getInstance() {
            return INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public boolean apply(IntVar var, int value, ICause cause) throws ContradictionException {
            return var.instantiateTo(value, cause);
        }

        @Override
        public boolean unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            return var.removeValue(value, cause);
        }

        @Override
        public String toString() {
            return " == ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntNeq();
        }
    }

    private static final class IntNeqDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 3056222234436601667L;
        private static final IntNeqDecision INSTANCE = new IntNeqDecision();

        private IntNeqDecision() {
        }

        public static IntNeqDecision getInstance() {
            return INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public boolean apply(IntVar var, int value, ICause cause) throws ContradictionException {
            assert (var.hasEnumeratedDomain() || var.getLB() == value || var.getUB() == value) : "branching in the middle of bounded domain ; var :" + var + " val : " + value;
            return var.removeValue(value, cause);
        }

        @Override
        public boolean unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            return var.instantiateTo(value, cause);
        }

        @Override
        public String toString() {
            return " != ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntEq();
        }
    }

    private static final class IntSplitDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 2796498653106384502L;
        private static final IntSplitDecision INSTANCE = new IntSplitDecision();

        public static IntSplitDecision getInstance() {
            return INSTANCE;
        }

        private IntSplitDecision() {
        }

        @Override
        public boolean apply(IntVar var, int value, ICause cause) throws ContradictionException {
            assert (var.getUB() > value) : "Branching value should be < UB; var :" + var + " val : " + value;
            return var.updateUpperBound(value, cause);
        }

        @Override
        public boolean unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            return var.updateLowerBound(value + 1, cause);
        }

        @Override
        public String toString() {
            return " <= ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntReverseSplit();
        }
    }

    private static final class IntReverseSplitDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = -4155926684198463505L;
        private static final IntReverseSplitDecision INSTANCE = new IntReverseSplitDecision();

        public static IntReverseSplitDecision getInstance() {
            return INSTANCE;
        }

        private IntReverseSplitDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public boolean apply(IntVar var, int value, ICause cause) throws ContradictionException {
            assert (var.getLB() < value) : "Branching value should be > LB; var :" + var + " val : " + value;
            return var.updateLowerBound(value, cause);
        }

        @Override
        public boolean unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            return var.updateUpperBound(value - 1, cause);
        }

        @Override
        public String toString() {
            return " >= ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntSplit();
        }
    }

    private static final class SetForceDecision
    implements DecisionOperator<SetVar> {
        private static final long serialVersionUID = -4868225105307378160L;
        private static final SetForceDecision INSTANCE = new SetForceDecision();

        public static SetForceDecision getInstance() {
            return INSTANCE;
        }

        private SetForceDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public boolean apply(SetVar var, int element, ICause cause) throws ContradictionException {
            assert (var.getUB().contains(element) && !var.getLB().contains(element)) : "Invalid branching; var :" + var + " val : " + element;
            return var.force(element, cause);
        }

        @Override
        public boolean unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            return var.remove(element, cause);
        }

        @Override
        public String toString() {
            return " contains ";
        }

        @Override
        public DecisionOperator<SetVar> opposite() {
            return DecisionOperatorFactory.makeSetRemove();
        }
    }

    private static final class SetRemoveDecision
    implements DecisionOperator<SetVar> {
        private static final long serialVersionUID = -580239209082758455L;
        private static final SetRemoveDecision INSTANCE = new SetRemoveDecision();

        public static SetRemoveDecision getInstance() {
            return INSTANCE;
        }

        private SetRemoveDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public boolean apply(SetVar var, int element, ICause cause) throws ContradictionException {
            assert (var.getUB().contains(element) && !var.getLB().contains(element)) : "Invalid branching; var :" + var + " val : " + element;
            return var.remove(element, cause);
        }

        @Override
        public boolean unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            return var.force(element, cause);
        }

        @Override
        public String toString() {
            return " !contains ";
        }

        @Override
        public DecisionOperator<SetVar> opposite() {
            return DecisionOperatorFactory.makeSetForce();
        }
    }

    public static final class GraphEnforceDecision
    implements GraphDecisionOperator {
        private static final GraphEnforceDecision INSTANCE = new GraphEnforceDecision();

        public static GraphEnforceDecision getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean apply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node < var.getNbMaxNodes()) {
                return var.enforceNode(node, cause);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean unapply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node < var.getNbMaxNodes()) {
                return var.removeNode(node, cause);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean apply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            return var.enforceEdge(from, to, cause);
        }

        @Override
        public boolean unapply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            return var.removeEdge(from, to, cause);
        }

        public GraphDecisionOperator opposite() {
            return DecisionOperatorFactory.makeGraphRemove();
        }

        @Override
        public String toString() {
            return " enforcing ";
        }
    }

    public static final class GraphRemoveDecision
    implements GraphDecisionOperator {
        private static final GraphRemoveDecision INSTANCE = new GraphRemoveDecision();

        public static GraphRemoveDecision getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean apply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node < var.getNbMaxNodes()) {
                return var.removeNode(node, cause);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean unapply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node < var.getNbMaxNodes()) {
                return var.enforceNode(node, cause);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean apply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            return var.removeEdge(from, to, cause);
        }

        @Override
        public boolean unapply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            return var.enforceEdge(from, to, cause);
        }

        public GraphDecisionOperator opposite() {
            return DecisionOperatorFactory.makeGraphEnforce();
        }

        @Override
        public String toString() {
            return " removal ";
        }
    }
}

