/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.restart;

import org.chocosolver.solver.search.restart.AbstractCutoff;

public class GeometricalCutoff
extends AbstractCutoff {
    protected final double geometricalFactor;
    protected double geometricalFactorPower;

    public GeometricalCutoff(long s, double g) throws IllegalArgumentException {
        super(s);
        if (g <= 1.0) {
            throw new IllegalArgumentException("The geometrical factor of the restart strategy must be strictly greater than 1.");
        }
        this.geometricalFactor = g;
        this.geometricalFactorPower = 1.0;
    }

    @Override
    public long getNextCutoff() {
        long cutoff = (long)Math.ceil((double)this.scaleFactor * this.geometricalFactorPower) * (long)this.grower.getAsInt();
        this.geometricalFactorPower *= this.geometricalFactor;
        return cutoff;
    }

    @Override
    public void reset() {
        this.geometricalFactorPower = 1.0;
    }

    public String toString() {
        return "GEOMETRICAL(s=" + this.scaleFactor + ", g=" + this.geometricalFactor + ')';
    }
}

