/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.relational;

import java.util.TreeSet;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.expression.continuous.relational.CReExpression;
import org.chocosolver.solver.expression.continuous.relational.PropEquation;
import org.chocosolver.solver.variables.RealVar;

public class BiCReExpression
implements CReExpression {
    private final CReExpression.Operator op;
    private final CArExpression e1;
    private final CArExpression e2;

    public BiCReExpression(CReExpression.Operator op, CArExpression e1, CArExpression e2) {
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public Constraint ibex(double p) {
        RealVar v1 = this.e1.realVar(p);
        RealVar v2 = this.e2.realVar(p);
        Model model = v1.getModel();
        switch (this.op) {
            case LT: {
                return model.realIbexGenericConstraint("{0}<{1}", v1, v2);
            }
            case LE: {
                return model.realIbexGenericConstraint("{0}<={1}", v1, v2);
            }
            case GE: {
                return model.realIbexGenericConstraint("{0}>={1}", v1, v2);
            }
            case GT: {
                return model.realIbexGenericConstraint("{0}>{1}", v1, v2);
            }
            case EQ: {
                return model.realIbexGenericConstraint("{0}={1}", v1, v2);
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public Constraint equation() {
        CArExpression expression = this.e1.sub(this.e2);
        TreeSet<RealVar> vars = new TreeSet<RealVar>();
        expression.collectVariables(vars);
        return new Constraint("Equation", new PropEquation(vars.toArray(new RealVar[0]), expression, this.op));
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2.toString() + ")";
    }
}

