/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIntersection
extends Propagator<SetVar> {
    private final int k;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure intersectionForced;
    private final IntProcedure intersectionRemoved;
    private final IntProcedure setForced;
    private final IntProcedure setRemoved;

    public PropIntersection(SetVar[] sets, SetVar intersection) {
        super((Variable[])ArrayUtils.append(sets, {intersection}), (Priority)PropagatorPriority.LINEAR, true);
        this.k = sets.length;
        this.sdm = new ISetDeltaMonitor[this.k + 1];
        for (int i = 0; i <= this.k; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.intersectionForced = element -> {
            for (int i = 0; i < this.k; ++i) {
                ((SetVar[])this.vars)[i].force(element, this);
            }
        };
        this.intersectionRemoved = element -> {
            int mate = -1;
            for (int i = 0; i < this.k; ++i) {
                if (((SetVar[])this.vars)[i].getUB().contains(element)) {
                    if (((SetVar[])this.vars)[i].getLB().contains(element)) continue;
                    if (mate == -1) {
                        mate = i;
                        continue;
                    }
                    mate = -2;
                    break;
                }
                mate = -2;
                break;
            }
            if (mate == -1) {
                this.fails();
            } else if (mate != -2) {
                ((SetVar[])this.vars)[mate].remove(element, this);
            }
        };
        this.setForced = element -> {
            boolean allKer = true;
            for (int i = 0; i < this.k; ++i) {
                if (!((SetVar[])this.vars)[i].getUB().contains(element)) {
                    ((SetVar[])this.vars)[this.k].remove(element, this);
                    allKer = false;
                    break;
                }
                if (((SetVar[])this.vars)[i].getLB().contains(element)) continue;
                allKer = false;
            }
            if (allKer) {
                ((SetVar[])this.vars)[this.k].force(element, this);
            }
        };
        this.setRemoved = element -> ((SetVar[])this.vars)[this.k].remove(element, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        SetVar intersection = ((SetVar[])this.vars)[this.k];
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int j;
            ISetIterator iter = ((SetVar[])this.vars)[0].getLB().iterator();
            while (iter.hasNext()) {
                j = iter.nextInt();
                boolean all = true;
                for (int i = 1; i < this.k; ++i) {
                    if (((SetVar[])this.vars)[i].getLB().contains(j)) continue;
                    all = false;
                    break;
                }
                if (!all) continue;
                intersection.force(j, this);
            }
            iter = intersection.getUB().iterator();
            block2: while (iter.hasNext()) {
                int i;
                j = iter.nextInt();
                if (intersection.getLB().contains(j)) {
                    for (i = 0; i < this.k; ++i) {
                        ((SetVar[])this.vars)[i].force(j, this);
                    }
                    continue;
                }
                for (i = 0; i < this.k; ++i) {
                    if (((SetVar[])this.vars)[i].getUB().contains(j)) continue;
                    intersection.remove(j, this);
                    continue block2;
                }
            }
            for (int i = 0; i <= this.k; ++i) {
                this.sdm[i].startMonitoring();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.k) {
            this.sdm[idxVarInProp].forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.sdm[idxVarInProp].forEach(this.intersectionForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.intersectionRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
    }

    @Override
    public ESat isEntailed() {
        int j;
        ISetIterator iter = ((SetVar[])this.vars)[this.k].getLB().iterator();
        while (iter.hasNext()) {
            j = iter.nextInt();
            for (int i = 0; i < this.k; ++i) {
                if (((SetVar[])this.vars)[i].getUB().contains(j)) continue;
                return ESat.FALSE;
            }
        }
        iter = ((SetVar[])this.vars)[0].getLB().iterator();
        while (iter.hasNext()) {
            j = iter.nextInt();
            if (((SetVar[])this.vars)[this.k].getUB().contains(j)) continue;
            boolean all = true;
            for (int i = 1; i < this.k; ++i) {
                if (((SetVar[])this.vars)[i].getLB().contains(j)) continue;
                all = false;
                break;
            }
            if (!all) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

