/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolChannel
extends Propagator<Variable> {
    private final int n;
    private final int offSet;
    private final BoolVar[] bools;
    private final SetVar set;
    private final ISetDeltaMonitor sdm;
    private final IntProcedure setForced;
    private final IntProcedure setRemoved;

    public PropBoolChannel(SetVar setVar, BoolVar[] boolVars, int offSet) {
        super(ArrayUtils.append(boolVars, {setVar}), (Priority)PropagatorPriority.UNARY, true);
        this.n = boolVars.length;
        this.bools = new BoolVar[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.bools[i] = (BoolVar)this.vars[i];
        }
        this.set = (SetVar)this.vars[this.n];
        this.sdm = this.set.monitorDelta(this);
        this.offSet = offSet;
        this.setForced = element -> this.bools[element - offSet].setToTrue(this);
        this.setRemoved = element -> this.bools[element - offSet].setToFalse(this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        for (int i = 0; i < this.n; ++i) {
            if (this.bools[i].isInstantiated()) {
                if (this.bools[i].getValue() == 0) {
                    this.set.remove(i + this.offSet, this);
                    continue;
                }
                this.set.force(i + this.offSet, this);
                continue;
            }
            if (this.set.getUB().contains(i + this.offSet)) continue;
            this.bools[i].setToFalse(this);
        }
        ISetIterator iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            j = iter.nextInt();
            if (j >= this.offSet && j < this.n + this.offSet) continue;
            this.set.remove(j, this);
        }
        iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            j = iter.nextInt();
            this.bools[j - this.offSet].setToTrue(this);
        }
        this.sdm.startMonitoring();
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        if (i < this.n) {
            if (this.bools[i].getValue() == 0) {
                this.set.remove(i + this.offSet, this);
            } else {
                this.set.force(i + this.offSet, this);
            }
        } else {
            this.sdm.forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        ISetIterator iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            i = iter.nextInt() - this.offSet;
            if (i >= 0 && i < this.bools.length && !this.bools[i].isInstantiatedTo(0)) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (!this.bools[i].isInstantiatedTo(1) || this.set.getUB().contains(i + this.offSet)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

