/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.among;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

@Explained(ignored=true, comment="Decomposed into count constraints and a sum")
public class PropAmongGAC
extends Propagator<IntVar> {
    private final int nb_vars;
    private final int[] values;
    private final TIntHashSet setValues;
    private final ISet poss;
    private final IStateInt nbSure;

    public PropAmongGAC(IntVar[] variables, int[] values) {
        super((Variable[])variables, (Priority)PropagatorPriority.LINEAR, true);
        this.nb_vars = variables.length - 1;
        IEnvironment environment = this.model.getEnvironment();
        this.setValues = new TIntHashSet(values);
        this.values = this.setValues.toArray();
        Arrays.sort(this.values);
        this.poss = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.nbSure = environment.makeInt(0);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (idx == this.nb_vars) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.poss.clear();
            int nbMandForSure = 0;
            for (int i = 0; i < this.nb_vars; ++i) {
                IntVar var = ((IntVar[])this.vars)[i];
                int nb = 0;
                for (int j : this.values) {
                    if (!var.contains(j)) continue;
                    ++nb;
                }
                if (nb == var.getDomainSize()) {
                    ++nbMandForSure;
                    continue;
                }
                if (nb <= 0) continue;
                this.poss.add(i);
            }
            this.nbSure.set(nbMandForSure);
        }
        this.filter();
    }

    @Override
    public void propagate(int vidx, int evtmask) throws ContradictionException {
        if (vidx != this.nb_vars && this.poss.contains(vidx)) {
            IntVar var = ((IntVar[])this.vars)[vidx];
            int nb = 0;
            for (int j : this.values) {
                if (!var.contains(j)) continue;
                ++nb;
            }
            if (nb == var.getDomainSize()) {
                this.nbSure.add(1);
                this.poss.remove(vidx);
                ((IntVar[])this.vars)[this.nb_vars].updateLowerBound(this.nbSure.get(), (ICause)this);
            } else if (nb == 0) {
                this.poss.remove(vidx);
                ((IntVar[])this.vars)[this.nb_vars].updateUpperBound(this.poss.size() + this.nbSure.get(), (ICause)this);
            }
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    private void filter() throws ContradictionException {
        int lb = this.nbSure.get();
        int ub = this.poss.size() + lb;
        ((IntVar[])this.vars)[this.nb_vars].updateBounds(lb, ub, this);
        if (((IntVar[])this.vars)[this.nb_vars].isInstantiated() && lb < ub) {
            if (((IntVar[])this.vars)[this.nb_vars].getValue() == lb) {
                this.backPropRemPoss();
            } else if (((IntVar[])this.vars)[this.nb_vars].getValue() == ub) {
                this.backPropForcePoss();
            }
        }
    }

    private void backPropRemPoss() throws ContradictionException {
        ISetIterator iter = this.poss.iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            IntVar v = ((IntVar[])this.vars)[i];
            if (v.hasEnumeratedDomain()) {
                for (int value : this.values) {
                    v.removeValue(value, (ICause)this);
                }
                this.poss.remove(i);
                continue;
            }
            int newLB = v.getLB();
            int newUB = v.getUB();
            int val = v.getLB();
            while (val <= newUB && this.setValues.contains(val)) {
                newLB = val + 1;
                val = v.nextValue(val);
            }
            val = newUB;
            while (val >= newLB && this.setValues.contains(val)) {
                newUB = val - 1;
                val = v.previousValue(val);
            }
            v.updateBounds(newLB, newUB, this);
            if (newLB <= this.values[this.values.length - 1] && newUB >= this.values[0]) continue;
            this.poss.remove(i);
        }
    }

    private void backPropForcePoss() throws ContradictionException {
        ISetIterator iter = this.poss.iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            IntVar v = ((IntVar[])this.vars)[i];
            if (v.hasEnumeratedDomain()) {
                int val = v.getLB();
                while (val <= v.getUB()) {
                    if (!this.setValues.contains(val)) {
                        v.removeValue(val, (ICause)this);
                    }
                    val = v.nextValue(val);
                }
                this.poss.remove(i);
                this.nbSure.add(1);
                continue;
            }
            v.updateBounds(this.values[0], this.values[this.values.length - 1], this);
            int newLB = v.getLB();
            int newUB = v.getUB();
            int val = v.getLB();
            while (val <= newUB && !this.setValues.contains(val)) {
                newLB = val + 1;
                val = v.nextValue(val);
            }
            val = newUB;
            while (val >= newLB && !this.setValues.contains(val)) {
                newUB = val - 1;
                val = v.previousValue(val);
            }
            v.updateBounds(newLB, newUB, this);
            if (!v.isInstantiated()) continue;
            this.poss.remove(i);
            this.nbSure.add(1);
        }
    }

    @Override
    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        int nbInst = ((IntVar[])this.vars)[this.nb_vars].isInstantiated() ? 1 : 0;
        for (int i = 0; i < this.nb_vars; ++i) {
            IntVar var = ((IntVar[])this.vars)[i];
            if (var.isInstantiated()) {
                ++nbInst;
                if (!this.setValues.contains(var.getValue())) continue;
                ++min;
                ++max;
                continue;
            }
            int nb = 0;
            for (int j : this.values) {
                if (!var.contains(j)) continue;
                ++nb;
            }
            if (nb == var.getDomainSize()) {
                ++min;
                ++max;
                continue;
            }
            if (nb <= 0) continue;
            ++max;
        }
        if (min > ((IntVar[])this.vars)[this.nb_vars].getUB() || max < ((IntVar[])this.vars)[this.nb_vars].getLB()) {
            return ESat.FALSE;
        }
        if (nbInst == this.nb_vars + 1) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AMONG(");
        sb.append("[");
        for (int i = 0; i < this.nb_vars; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((IntVar[])this.vars)[i].toString());
        }
        sb.append("],{");
        sb.append(Arrays.toString(this.values));
        sb.append("},");
        sb.append(((IntVar[])this.vars)[this.nb_vars].toString()).append(")");
        return sb.toString();
    }
}

