/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.reification.PropImplied;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class ImpliedConstraint
extends Constraint {
    protected final BoolVar bool;
    protected final Constraint trueCons;
    private final int[] indices;
    private final PropImplied propReif;

    protected ImpliedConstraint(BoolVar bVar, Constraint consIfBoolTrue) {
        super("REIFICATIONCONSTRAINT", ImpliedConstraint.createProps(bVar, consIfBoolTrue));
        this.propReif = (PropImplied)this.propagators[0];
        this.propReif.setReifCons(this);
        this.trueCons = consIfBoolTrue;
        this.bool = bVar;
        this.indices = new int[3];
        this.indices[0] = 1;
        this.indices[1] = this.indices[0] + this.trueCons.getPropagators().length;
        for (int p = this.indices[0]; p < this.indices[1]; ++p) {
            this.propagators[p].setReifiedSilent(this.bool);
        }
        this.trueCons.declareAs(Constraint.Status.REIFIED, -1);
    }

    private static Propagator<?>[] createProps(BoolVar bVar, Constraint trueCons) {
        HashSet<Variable> setOfVars = new HashSet<Variable>();
        ImpliedConstraint.prepareConstraint(bVar, trueCons, setOfVars);
        Variable[] allVars = ArrayUtils.append({bVar}, setOfVars.toArray(new Variable[0]));
        PropImplied reifProp = new PropImplied(allVars, trueCons);
        return ArrayUtils.append({reifProp}, (Propagator[])trueCons.getPropagators().clone());
    }

    private static void prepareConstraint(BoolVar bVar, Constraint c, Set<Variable> setOfVars) {
        for (Propagator p : c.getPropagators()) {
            for (Variable v : p.getVars()) {
                if (v == bVar) continue;
                setOfVars.add(v);
            }
        }
    }

    public void activate(int idx) throws ContradictionException {
        Model model = this.propagators[0].getModel();
        assert (this.bool.isInstantiatedTo(1 - idx));
        for (int p = this.indices[idx]; p < this.indices[idx + 1]; ++p) {
            assert (this.propagators[p].isReifiedAndSilent());
            this.propagators[p].setReifiedTrue();
            model.getSolver().getEngine().execute(this.propagators[p]);
            model.getSolver().getEngine().onPropagatorExecution(this.propagators[p]);
        }
    }

    @Override
    public ESat isSatisfied() {
        return this.propReif.isEntailed();
    }

    @Override
    public String toString() {
        return this.bool.toString() + "=>" + this.trueCons.toString();
    }
}

