/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import java.util.Arrays;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.memory.trailing.trail.chunck.World;

public class OperationWorld
implements World {
    private IOperation[] variableStack;
    private int now = 0;
    private final double loadfactor;

    public OperationWorld(int defaultSize, double loadfactor) {
        this.loadfactor = loadfactor;
        this.variableStack = new IOperation[defaultSize];
    }

    public void savePreviousState(IOperation v) {
        this.variableStack[this.now] = v;
        ++this.now;
        if (this.now == this.variableStack.length) {
            int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
            this.variableStack = Arrays.copyOf(this.variableStack, newCapacity);
        }
    }

    @Override
    public void revert() {
        for (int i = this.now - 1; i >= 0; --i) {
            IOperation v = this.variableStack[i];
            v.undo();
        }
    }

    @Override
    public void clear() {
        this.now = 0;
    }

    @Override
    public int allocated() {
        return this.variableStack == null ? 0 : this.variableStack.length;
    }

    @Override
    public int used() {
        return this.now;
    }
}

