## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(rampage)

## -----------------------------------------------------------------------------
gradinv

## -----------------------------------------------------------------------------
set.seed(1)
vals<- rnorm(50000,1,1)

## -----------------------------------------------------------------------------
df <- data.frame(
  z=c(-4, 1,  6),
  color=gradinv(3)
)
df

## -----------------------------------------------------------------------------
ex <- expand(df, n=50)

## ----fig.width=7, fig.height=6------------------------------------------------
hist(vals, breaks=ex$breaks, col=ex$col, border=NA)

## -----------------------------------------------------------------------------
exMore <- expand(df, n=100)

## ----fig.width=7, fig.height=6------------------------------------------------
hist(vals, breaks=exMore$breaks, col=exMore$col, border=NA)

## -----------------------------------------------------------------------------
dfMoreTies <- data.frame(
  z=c(-4, 0.5, 1,  1.5, 6),
  color=gradinv(5)
)
dfMoreTies

## -----------------------------------------------------------------------------
exMoreTies <- rampage::expand(dfMoreTies, n=200)

## ----fig.width=7, fig.height=6------------------------------------------------
hist(vals, breaks=exMoreTies$breaks, col=exMoreTies$col, border=NA)

## -----------------------------------------------------------------------------
dfSkewed <- data.frame(
  z=c(-4, -1, 0,  1, 6),
  color=gradinv(5)
)
dfSkewed

## -----------------------------------------------------------------------------
exSkewed <- rampage::expand(dfSkewed, n=200)

## ----fig.width=7, fig.height=6------------------------------------------------
hist(vals, breaks=exSkewed$breaks, col=exSkewed$col, border=NA)

