/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.rule.extend.ExtendRules;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class History {
    private static final Logger LOGGER = Logger.getLogger(ExtendRules.class.getName());
    private int RID;
    LinkedHashMap<Integer, String[]> history = new LinkedHashMap();

    public History(int RID) {
        this.RID = RID;
    }

    public String[][] toArray() {
        String[][] array = new String[this.history.size() + 1][];
        int i = 0;
        for (Map.Entry<Integer, String[]> e : this.history.entrySet()) {
            array[i] = e.getValue();
            ++i;
        }
        return array;
    }

    public Collection<String[]> toCollection() {
        return this.history.values();
    }

    public History(int RID, int ERID, String[] text) {
        this.RID = RID;
        this.addRuleIdentifiers(ERID, text);
    }

    public History copy() {
        History copy = new History(this.RID);
        for (Map.Entry<Integer, String[]> e : this.history.entrySet()) {
            copy.addRuleIdentifiers(e.getKey(), e.getValue());
        }
        return copy;
    }

    public void addRuleIdentifiers(int ERID, String[] text) {
        this.history.put(ERID, text);
    }

    public String[] historyTableHeader() {
        String[] header = new String[]{"RID", "ERID", "rule", "supp", "conf"};
        return header;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nExtend history for rule: " + this.RID);
        for (Map.Entry<Integer, String[]> e : this.history.entrySet()) {
            sb.append("(ERID=").append(e.getKey()).append(") ->");
        }
        sb.append("current\n");
        sb.append(String.join((CharSequence)",", this.historyTableHeader()));
        sb.append("\n");
        for (Map.Entry<Integer, String[]> e : this.history.entrySet()) {
            sb.append(String.join((CharSequence)",", e.getValue())).append("\n");
        }
        return sb.toString();
    }
}

