## ----echo = FALSE-------------------------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE
)
options(digits=4)

## ----matA---------------------------------------------------------------------
A <- matrix(c(13, -4, 2, -4, 11, -2, 2, -2, 8), 3, 3, byrow=TRUE)
A

## ----eigA---------------------------------------------------------------------
ev <- eigen(A)
# extract components
(values <- ev$values)
(vectors <- ev$vectors)

## ----orthog-------------------------------------------------------------------
crossprod(vectors)
zapsmall(crossprod(vectors))

## ----trace--------------------------------------------------------------------
library(matlib)   # use the matlib package
tr(A)
sum(values)

## ----ssq----------------------------------------------------------------------
sum(A^2)
sum(values^2)

## ----prod---------------------------------------------------------------------
det(A)
prod(values)

## ----rank---------------------------------------------------------------------
R(A)
sum(values != 0)

## ----solve--------------------------------------------------------------------
AI <- solve(A)
AI
eigen(AI)$values
eigen(AI)$vectors

## -----------------------------------------------------------------------------
eigen(A %*% A)
eigen(A %*% A %*% A)$values
eigen(mpower(A, 4))$values


