## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(enaho)

## -----------------------------------------------------------------------------
dir <- system.file("extdata", package = "enaho") # directorio con las bases
leido <- leer.inei(modulo = 37,periodos = 2011,tipo = c("t1"),directorio = dir)
leido

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido, pesos = "FACTRIM")

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "DOMINIO")

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "region")

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "area")

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "area",
                 ruralidad = 7:8)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = c("area","DOMINIO"))

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = c("area","DOMINIO"),
                 combinarestratos = TRUE)

## -----------------------------------------------------------------------------
leido2 <- leer.inei(modulo = 37,periodos = c(2011,2024),tipo = c("t1"),directorio = dir,
                   combinar = TRUE)
class(leido2)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido2, pesos = NULL)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido2, pesos = NULL,
                 forzaretiquetas = TRUE)

## ----error=TRUE---------------------------------------------------------------
try({
proporcion.inei(x = "P7061", base = leido2, pesos = "FACTRIM",
                 forzaretiquetas = TRUE)
})

## ----error=FALSE--------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido2, pesos = c("FACTRIM","FACTOR"),
                 forzaretiquetas = TRUE)

## ----error=FALSE--------------------------------------------------------------
proporcion.inei(x = c("P7061","P7062"), base = leido2, pesos = c("FACTRIM","FACTOR"),
                 estratos = "area", forzaretiquetas = TRUE)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido, pesos = "FACTRIM",
                 formatolargo = TRUE)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido, pesos = "FACTRIM",
                 porcentaje = TRUE)

## -----------------------------------------------------------------------------
proporcion.inei(x = "P7061", base = leido, pesos = "FACTRIM",
                 decimales = 3)

