/**
 *
 * CanvasXpress 57.4 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2025 - license@canvasxpress.org
 *
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is released as open source for personal and
 * educational use with dual licensing for commercial purposes.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please see a copy of the CanvasXpress License at
 * https://www.canvasxpress.org/docs/license.html.
 *
 * Dual licensing:
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission from CanvasXpress.
 *
 */
/**
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function(b,a){if(typeof exports==="object"){a(exports)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}(this,(function(){CanvasXpress=typeof CanvasXpress!="undefined"&&CanvasXpress.ready?CanvasXpress:function(n,h,e,s,d,p,r,l){var k=this;var q=function(){k.init(n,h,e,s,d,p,r,l)};var c=function(i){if(i){k.init(i)}else{k.init(n,h,e,s,d,p,r,l)}};var j=document.styleSheets;var b=false;for(var g=0;g<j.length;g++){if(j[g].href&&j[g].href.indexOf("canvasXpress.css")>-1){b=true;break}}if(e&&typeof e=="string"){e={prompt:e,llmBehaviour:"update",view:"table"}}else{if(n&&n.config&&n.config.prompt&&n.config.isR){n.config.llmBehaviour="update";n.config.view="table"}}if(!b){var o=document.createElement("link");o.rel="stylesheet";o.type="text/css";o.href="https://www.canvasxpress.org/dist/canvasXpress.css";document.getElementsByTagName("head")[0].appendChild(o);o.onload=function(){b=true;new CanvasXpress(n,h,e,s,d,p,r,l)}}else{if((e&&e.fonts)||(n&&n.config&&n.config.fonts)){if(e&&e.fonts){CanvasXpress.loadFonts(e.fonts,q)}else{CanvasXpress.loadFonts(n.config.fonts,q)}}else{if((e&&e.fontsExternal)||(n&&n.config&&n.config.fontsExternal)){if(e&&e.fontsExternal){CanvasXpress.loadFontsExternal(e.fontsExternal,q)}else{CanvasXpress.loadFontsExternal(n.config.fontsExternal,q)}}else{if((e&&e.topoJSON&&typeof e.topoJSON=="string")||(n&&n.config&&n.config.topoJSON&&typeof n.config.topoJSON=="string")||(e&&e.useLeaflet)||(n&&n.config&&n.config.useLeaflet)){if((e&&e.useLeaflet)||(n&&n.config&&n.config.useLeaflet)){var a=function(){if(e&&e.topoJSON){CanvasXpress.loadTopoJSON(e.topoJSON,e.mapId,q)}else{if(n&&n.config&&n.config.topoJSON){CanvasXpress.loadTopoJSON(n.config.topoJSON,n.config.mapId,q)}else{q()}}};CanvasXpress.loadLeaflet(a,k)}else{if(e&&e.topoJSON){CanvasXpress.loadTopoJSON(e.topoJSON,e.mapId,q)}else{CanvasXpress.loadTopoJSON(n.config.topoJSON,n.config.mapId,q)}}}else{if((h&&typeof h=="string")||(n&&n.data&&typeof n.data=="string")){if(h){CanvasXpress.loadRemoteData(n,h,e,s,c)}else{CanvasXpress.loadRemoteData(n.renderTo,n.data,n.config,n.events,c)}}else{if(e&&e.graphType&&e.graphType=="Map"&&e.mapId&&!e.topoJSON){if(CanvasXpress.maps.hasOwnProperty(e.mapId)){e.topoJSON="https://www.canvasxpress.org"+CanvasXpress.maps[e.mapId]}else{if(CanvasXpress.usa.hasOwnProperty(e.mapId)){e.topoJSON="https://www.canvasxpress.org/data/maps/"+e.mapId+".json"}else{if(CanvasXpress.countries.hasOwnProperty(e.mapId)){e.topoJSON="https://www.canvasxpress.org/data/maps/"+e.mapId+".json"}else{var f=e.mapId.toLowerCase();if(!e.topoJSON){for(var g in CanvasXpress.usa){if(CanvasXpress.usa[g][0].toLowerCase()==f){e.mapId=g;e.topoJSON="https://www.canvasxpress.org/data/maps/"+g+".json";break}}}if(!e.topoJSON){for(var g in CanvasXpress.countries){if(CanvasXpress.countries[g][0].toLowerCase()==f){e.mapId=g;e.topoJSON="https://www.canvasxpress.org/data/maps/"+g+".json";break}}}if(!e.topoJSON){e.topoJSON=CanvasXpress.geojson}}}}CanvasXpress.loadTopoJSON(e.topoJSON,e.mapId,q)}else{this.init(n,h,e,s,d,p,r,l)}}}}}}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.cxplot=b.cxplot||{})))}}(this,(function(){cxplot=function(x,y,k,a){if(typeof(x)=="object"&&x.isGGPlot){var n=function(g){if(Array.isArray(g)&&!g.length){return{}}else{var f={};for(var m in g){if(g[m]&&typeof g[m]==="string"){f[m]=g[m].replace(/^"(.+)"$/,"$1")}else{f[m]=g[m]}}return f}};var l=function(){if(x.order){x.aes.meta={};for(var f in x.order){x.aes.meta[f]=x.order[f]}}if(!x.aes.hasOwnProperty("x")||(x.aes.hasOwnProperty("x")&&x.data[0]&&!x.data[0].includes(x.aes.x))){for(var f=0;f<o.length;f++){var m=o[f];if(x.layers[m]&&x.layers[m].hasOwnProperty("x")&&x.data[0].includes(x.layers[m].x)){x.aes.x=x.layers[m].x;break}}}if(!x.aes.hasOwnProperty("y")||(x.aes.hasOwnProperty("y")&&x.data[0]&&!x.data[0].includes(x.aes.y))){for(var f=0;f<o.length;f++){var m=o[f];if(x.layers[m]&&x.layers[m].hasOwnProperty("y")&&x.data[0].includes(x.layers[m].y)){x.aes.y=x.layers[m].y;break}}}if(x.hasOwnProperty("meta")){x.aes.metaData=x.meta}if(x.hasOwnProperty("scales")&&x.scales.hasOwnProperty("sizes")){if(Array.isArray(x.scales.sizes)){x.aes.sizes=x.scales.sizes}}if(x.hasOwnProperty("isGGMatrix")){x.aes.isGGMatrix=x.isGGMatrix}return x.aes};var w=function(f){if(f&&f.hasOwnProperty("hoverTemplate")){f.hoverTemplate+="<br>"}return f};var j=function(f){if(f&&Array.isArray(f)&&f.length==0&&x.scales&&x.scales.hasOwnProperty("setMinX")&&x.scales.hasOwnProperty("setMaxX")&&x.scales.hasOwnProperty("setMinY")&&x.scales.hasOwnProperty("setMaxY")){f=[["min","max"],[x.scales.setMinX,x.scales.setMaxX],[x.scales.setMinY,x.scales.setMaxY]]}return f};delete (x.isGGPlot);var p=JSON.stringify(x);var o=Array.isArray(x.geoms)?x.geoms:[x.geoms];var d=new cxplot(x.renderTo,j(x.data),aes(l()),a);var e={};d.skipGeoms=false;d.meta.config.user.geoms=o;d.meta.config.user.layers=x.layers;d.meta.config.user.cxplot=p;for(var r=0;r<o.length;r++){var s=o[r];var q=e[s]?s+"."+e[s]:s;var t=s.toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges").replace("repel","_repel").replace("npc","_npc").replace("pattern","_pattern");if(d[t]&&!d.skipGeoms){d[t](n(x.layers[q]))}e[s]=e[s]?e[s]+1:1}d.skipGeoms=false;d.Ow(n(x.labels));d.Kd(n(x.scales));d.Od(n(x.coords));d.wK(n(x.theme));d.vS(n(x.facet));d.w5(w(x.config));d.skipRender=false;d.Oj();return d}else{if(k){var b=["x","y"];for(var r=0;r<b.length;r++){if(k[b[r]]&&k[b[r]].match(/\*/)){var h=k[b[r]].split("*");h[0]=h[0].replace(/\s*$/,"");h[1]=Number(h[1].replace(/^\s*/,""));k[b[r]]=h[0];if(!isNaN(h[1])){k[b[r]]=h[0];k[b[r]+"AxisFactorValue"]=h[1]}}if(k[b[r]]&&y&&y[0]&&!y[0].includes(k[b[r]])){delete k[b[r]]}}}var v={aes:(k||{}),remoteTransitionEffect:"none",theme:"GGPlot",widthFactor:1.5,shapes:["circle","equilateral","rect","plus","minus","diamond","hexagon","octagon","star","pentagon"],isCxplot:true,isGGMatrix:(k&&k.isGGMatrix?k.isGGMatrix:false),legendStyleGgplot:true,skipRender:(k&&k.isR?true:false)};if(k&&k.hasOwnProperty("sizes")){if(Array.isArray(k.sizes)){v.sizes=k.sizes;while(v.sizes.length<10){var u=(v.sizes[v.sizes.length-1]-v.sizes[v.sizes.length-2])/2;v.sizes.push(Math.ceil(u+v.sizes[v.sizes.length-1]))}if(v.sizes[0]<4){var u=4-v.sizes[0];for(var r=0;r<v.sizes.length;r++){v.sizes[r]+=u}}}}if(k&&k.hasOwnProperty("metaData")){v.metaData=k.metaData}if(k.hasOwnProperty("xAxisFactorValue")){v.xAxisFactorValue=k.xAxisFactorValue}if(k.hasOwnProperty("yAxisFactorValue")){v.yAxisFactorValue=k.yAxisFactorValue}var c=new CanvasXpress(x,y,v,a);c.meta.ggplot.aes=k||{};c.meta.ggplot.data=y[0];c.meta.ggplot.order=k&&k.order?k.order:{};return c}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.aes=b.aes||{})))}}(this,(function(){aes=function(){var b=arguments;var f={};var e=["x","y","z","fill","color","shape","size","pattern"];var a=function(){if(!f.stringSampleFactors){f.stringSampleFactors=[]}if(!f.stringVariableFactors){f.stringVariableFactors=[]}if(!f.asSampleFactors){f.asSampleFactors=[]}if(!f.asVariableFactors){f.asVariableFactors=[]}};for(var c=0;c<b.length;c++){if(Array.isArray(b[c])&&Array.isArray(b[c][0])){f.data=b[c]}else{if(b[c] instanceof Object){for(var d in b[c]){f[d]=b[c][d];if(d=="factor"){a();f.stringSampleFactors.push(b[c][d]);f.stringVariableFactors.push(b[c][d]);f.asSampleFactors.push(b[c][d]);f.asVariableFactors.push(b[c][d]);if(b.length>1){if(c==0){f.x=b[c][d]}else{if(c==1){f.y=b[c][d]}else{if(c==2){f.z=b[c][d]}}}}}else{if(e.includes(d)){if(b[c][d] instanceof Object&&b[c][d].factor){a();f.stringSampleFactors.push(b[c][d].factor);f.stringVariableFactors.push(b[c][d].factor);f.asSampleFactors.push(b[c][d].factor);f.asVariableFactors.push(b[c][d].factor);f[d]=b[c][d].factor}else{if(b[c][d].toString().match(/^factor\(.+\)/)){f[d]=b[c][d].replace(/^factor\(/,"").replace(/\)$/,"");a();f.stringSampleFactors.push(f[d]);f.stringVariableFactors.push(f[d]);f.asSampleFactors.push(f[d]);f.asVariableFactors.push(f[d])}}}else{if(d=="sample"){f.x=b[c][d]}}}}}else{if(c==0){f.x=b[c]}else{if(c==1){f.y=b[c]}else{if(c==2){f.z=b[c]}}}f[b[c]]=b[c]}}}return f}})));CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){var g=CanvasXpress.instances[0];if(g){g.fo("canvasXpress JS ready");a=true;for(var h=0;h<f.length;h++){f[h].fn.call(window,f[h].ctx)}f=[]}}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadLeaflet=function(c,d){var b=document.createElement("script");b.type="text/javascript";b.src="https://www.canvasxpress.org/assets/leaflet/leaflet.js";b.crossOrigin="anonymous";var a=document.createElement("link");a.type="text/css";a.rel="stylesheet";a.href="https://www.canvasxpress.org/assets/leaflet/leaflet.css";a.crossOrigin="anonymous";if(window.L){if(c){if(typeof(c)=="function"){c.call(d)}}}else{CanvasXpress.loadScripts([a,b],c,d)}};CanvasXpress.loadScripts=function(){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;if(files[i-1]){loadScript(files[i-1],count)}}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.classList.contains("CanvasXpress")&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.classList.contains("CanvasXpress")&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.classList.contains("CanvasXpress")&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress("temp-table-id-"+e.id,f)}}}};CanvasXpress.pivot=function(f){var a=0;var m=1;var k=2;var l={};var h=[];var e=[];for(var g=0;g<f.length;g++){if(!l[f[g][a]]){l[f[g][a]]={}}l[f[g][a]][f[g][m]]=f[g][k];if(e.indexOf(f[g][m])==-1){e.push(f[g][m])}}e.sort();var n=[];n.push("Id");n.push.apply(n,e);h.push(n);for(var g in l){n=[];n.push(g);for(var b=0;b<e.length;b++){n.push(l[g][e[b]]?l[g][e[b]]:null)}h.push(n)}return h};CanvasXpress.getObject=function(f,b){if(f){while(CanvasXpress.chain.hasOwnProperty(f)){f=CanvasXpress.chain[f]}for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.json=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="json";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.csv=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="text";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.svg=function(a,d,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="text";b.onload=function(){var e=b.status;if(e==200){c(b.responseText,d)}else{c(e)}};b.send()};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(b,a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(b,a)}};CanvasXpress.create=function(c,b,a){CanvasXpress.inject(c);return new CanvasXpress(c,b,a)};CanvasXpress.createObject=function(f,d,b,c,e,h,g,a){if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.renderTo){d=f.tracks?{tracks:f.tracks}:f.nodes?{nodes:f.nodes}:f.venn?{venn:f.venn}:f.data?f.data:false;b=f.config||false;if(f.version){b.createVersion=f.version}if(f.factory){b.createFactory=f.factory}c=f.events||false;e=f.info?f.info.replace(/'/g,"'").replace(/"/g,"'"):false;h=f.afterRender||false;g=f.callback||false;a=f.noValidate?f.noValidate:b&&b.noValidate?b.noValidate:false;f=f.renderTo;CanvasXpress.inject(f)}else{if(typeof f==="string"||f instanceof String){CanvasXpress.inject(f)}}}return{target:f,data:d,config:b,events:c,info:e,afterRender:h,callback:g,noValidate:a}};CanvasXpress.inject=function(c){if(typeof c==="string"||c instanceof String){var b=document.getElementById(c);if(b!==null){if(b.tagName.toLowerCase()=="canvas"){if(!b.width){b.width=500}if(!b.height){b.height=500}}else{if(b.tagName.toLowerCase()=="div"){b.id=c+"-div";var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;b.appendChild(a)}}}else{var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;document.body.appendChild(a)}}};CanvasXpress.loadFonts=function(d,c){if(d&&d.length&&c){var b=false;for(var a=0;a<d.length;a++){if(!CanvasXpress.fonts.hasOwnProperty(d[a])){b=true;break}}WebFontConfig={google:{families:d},timeout:2000};if(c){WebFontConfig.active=c}(function(h){if(window.navigator.onLine&&b){var e=h.createElement("script");var g=h.scripts[0];e.src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js";e.async=true;g.parentNode.insertBefore(e,g);for(var f=0;f<d.length;f++){CanvasXpress.fonts[d[f]]=true}}else{c()}})(document)}};CanvasXpress.loadFontsExternal=function(c,b){if(c&&c.length&&b){var a=false;if(!CanvasXpress.fonts.hasOwnProperty(c[0].name)){a=true}(function(f){if(window.navigator.onLine&&a){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){var d=new FontFace(c[0].name,e.response);document.fonts.add(d);CanvasXpress.fonts[c[0].name]=true;b()}}}});e.responseType="arraybuffer";e.open("get",c[0].url);e.send()}else{b()}})(document)}};CanvasXpress.loadTopoJSON=function(a,b,d){if(a&&d){var c=false;if(!b){b="cXMap"}if(!window.hasOwnProperty(b)){c=true}(function(f){if(window.navigator.onLine&&c){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){window[b]=JSON.parse(e.response);d()}}}});e.open("get",a);e.send()}else{d()}})(document)}};CanvasXpress.loadRemoteData=function(j,c,f,m,l){if(c&&l){var n=CanvasXpress.prototype.initIO.apply(CanvasXpress);var d=function(r,s,e){if(!r.hasOwnProperty(s)){if(!r){r={}}if(!r.hasOwnProperty(s)){r[s]={}}r[s]=JSON.parse(JSON.stringify(e))}else{for(var q in e){r[s][q]=e[q]}}};var h=null;var g=window.document.getElementById(c);var o=n.isValidURL(c.replace(/^file:\/\//,""));var k=c.match(/\.pl$/)||c.match(/\.pl\?/)?true:false;if(g&&g.tagName.toLowerCase()=="table"&&g.classList.contains("CanvasXpress")&&g.id){h=n.HTMLTableToCX(g,f);h.renderTo=j||g.id;h.events=m;g.parentNode.removeChild(g);return l(h)}else{if(o){(function(p){if(window.navigator.onLine){if(!j){j="cX-data-url"}if(o==2&&!c.match(/^file:/)){c="file://"+c}var e=new XMLHttpRequest();e.open("get",c,true);e.onreadystatechange=function(){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){if(c.match(/\.json$/)||k){h=n.parseJSON(e.response);if(Array.isArray(h)){var v=h[0][1];var u=[];for(var t=0;t<h.length;t++){u.push(h[t][0])}if(!f){f={}}f.remoteService=c;f.remoteData=h;f.remoteIds=u;CanvasXpress.loadRemoteData(j,v,f,m,l)}else{h.renderTo=j||h.renderTo;h.events=m||h.events;d(h,"config",f);l(h)}}else{if(c.match(/\.parquet$/)){h=n.KQ(e.response,f);h.renderTo=j||h.renderTo;h.events=m||h.events;d(h,"config",f);l(h)}else{if(c.match(/\.png$/)){h=n.PNGtoCX(e.response);h.renderTo=j||h.renderTo;h.events=m||h.events;d(h,"config",f);l(h)}else{if(c.match(/\.txt$/)||c.match(/\.csv$/)||c.match(/\.tsv$/)||c.match(/\.tab$/)){h=n.parseDelimited(e.response);if(f&&f.graphType=="Network"){h=n.arrayToCXNetwork(h,j,f,m)}else{h=n.arrayToCX(h,f,f&&f.isR);h.renderTo=j||h.renderTo;h.events=m||h.events}d(h,"config",f);l(h)}else{if(c.match(/\.svg$/)){h=n.SVGtoCX(e.response);d(h,"config",f);l(h)}else{if(c.match(/ml$/)||c.match(/ml\.bz2$/)||c.match(/\.gexf$/)){var s=c.match(/ml\.bz2$/)?n.parseXML(n.Fp(e.response)):n.parseXML(e.response);var r=s.childNodes[0];var q=s.childNodes[2];if(r.tagName&&r.tagName.toLowerCase()=="gexf"){h=n.gexfToCX(s,j,f,m);l(h)}else{if(r.tagName&&r.tagName.toLowerCase()=="map"){h=n.metabaseToCX(s,j,f,m);l(h)}else{if(r.tagName&&r.tagName.toLowerCase()=="graph"){h=n.cytoscapeToCX(s,j,f,m);l(h)}else{if(r.tagName&&r.tagName.toLowerCase()=="pathway"){h=n.wikipathwayToCX(s,j,f,m);l(h)}else{if(q&&q.tagName&&q.tagName.toLowerCase()=="pathway"){n.keggToCX(s,j,f,m,l)}}}}}}else{l()}}}}}}}}}};if(c.match(/\.png$/)||c.match(/\.parquet$/)){e.responseType="arraybuffer"}else{if(c.match(/ml\.bz2$/)){e.responseType="binary"}else{e.responseType="text"}}e.send()}})(document)}else{try{h=JSON.parse(c);return l(h)}catch(i){h=null}var h=n.parseDelimited(c)||null;if(h){if(f&&f.graphType=="Network"){h=n.arrayToCXNetwork(h,j,f,m)}else{h=n.arrayToCX(h,f)}return l(h)}if(window.DOMParser){try{h=(new DOMParser()).parseFromString(c,"text/xml")}catch(i){h=null}}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){try{h=new window.ActiveXObject("Microsoft.XMLDOM");h.async="false"}catch(i){h=null}}}if(h!=null&&h.getElementsByTagName("parsererror").length==0){var b=h.childNodes[0];var a=h.childNodes[2]||h.childNodes[1];if(b.tagName&&b.tagName.toLowerCase()=="gexf"){return l(n.gexfToCX(h,j,f,m))}else{if(b.tagName&&b.tagName.toLowerCase()=="map"){return l(n.metabaseToCX(h,j,f,m))}else{if(b.tagName&&b.tagName.toLowerCase()=="graph"){return l(n.cytoscapeToCX(h,j,f,m))}else{if(b.tagName&&b.tagName.toLowerCase()=="pathway"){return l(n.wikipathwayToCX(h,j,f,m))}else{if(a&&a.tagName&&a.tagName.toLowerCase()=="pathway"){return n.keggToCX(h,j,f,m,l)}}}}}}return null}}}};CanvasXpress.callbackPass=function(a){};CanvasXpress.callbackRDataset=function(d){event.stopPropagation();event.preventDefault();var f=d.split("/");var e=f[8];var b=f[9];var g=f[10].split(".")[0];var a=event.target.parentNode.parentNode.id.split("-cX-DataTable")[0];var c=CanvasXpress.getObject(a);if(e=="csv"){c.z9(d);c.Rdataset={library:b,dataset:g,url:c.RdatasetsURL+"json/"+b+"/"+g+"Info.json",info:false}}else{var h=function(k){var j={width:"500px",height:"500px",overflow:"auto",textWrap:"auto",position:"relative",zIndex:1000000,fontSize:"small"};var m="";for(var l in k.parameters){m+="<b>"+l+"</b>: "+k.parameters[l]+"<br><br>"}c.RT({ac:{x:100,y:100}},m,a,j)};c.hG(d,false,h,"json")}return false};CanvasXpress.parametersLLM=["llmServiceURL","llmModel","llmTopp","llmTemperature","llmPresencePenalty","llmFrequencyPenalty","llmMaxNewTokens","llmBehaviour","llmIconTransparency","llmIconSize","llmPrompt","llmUseDev","llmStack","llmHeader","llmUseCopilot","llmCodeExamples","loadLLMDatasets","llmCodeExamples","llmCodeMaxSentences","disableChat"];CanvasXpress.callbackRateLLM=function(b){var c=function(){var d=document.getElementById(b.target+"-cX-ChatInterfaceRateScript");if(d){document.body.removeChild(d)}};if(b&&b.success){var a=CanvasXpress.getObject(b.target);if(a){a.SJ(100,100,b.text,3000)}else{alert("CanvasXpress Object: "+b.target+" - not found");c()}}else{alert(b.text)}};CanvasXpress.callbackLLM=function(a){var c=function(n,d){var h=document.createElement("canvas");h.width=n;h.height=d;h.id="cX-LLM-"+Date.now();return h};var k=function(w){var z=document.createElement("div");z.style.width=w+"px";z.style.height="100px";z.style.clear="both";z.style.position="relative";z.style.margin="auto";var n=document.createElement("span");n.innerHTML=a.datetime;n.style.cssFloat="right";var d=document.createElement("span");d.innerHTML=a.prompt;d.style.cssFloat="left";d.style.fontWeight="bold";var y=document.createElement("span");y.innerHTML=a.client;y.style.cssFloat="left";var x=document.createElement("br");var v=document.createElement("br");var h=document.createElement("br");z.appendChild(x);z.appendChild(y);z.appendChild(n);z.appendChild(v);z.appendChild(d);z.appendChild(h);return z};var e=function(h,d){var n=document.createElement("div");if(d){n.className=d}n.appendChild(h);return n};var j=function(w,h){var x=CanvasXpress.parametersLLM;h.s5();var n=h.meta.config.user;var d={graphOrientation:true,graphType:true,isR:true,prompt:true};for(var v=0;v<x.length;v++){w.config[x[v]]=h[x[v]]}return;for(var v in n){if(!d[v]||w.config.hasOwnProperty(v)){w.config[v]=n[v]}}};var r=function(){var d=document.getElementById(a.target+"-cX-ChatInterfaceAskScript");if(d){document.body.removeChild(d)}};var g=function(){var d=CanvasXpress.getObject(a.target);if(d){d.n7();d.VT(true);d.rL();d.isAskingLLM=false;d.Gf()}r()};if(a&&a.success){var f=CanvasXpress.getObject(a.target);if(f){j(a,f);var q=document.getElementById("container-"+a.target);if(q){a.config.isGraphTime=f.isGraphTime;a.config.xAxisTime=f.xAxisTime;a.config.yAxisTime=f.yAxisTime;a.config.view="canvas";delete a.config.xAxisTickFormat;delete a.config.yAxisTickFormat;f.graphType=a.config.graphType;var o=f.llmStack.length;var u=f.io();var s=f.Vq();f.llmStack.push({header:s,prompt:a.prompt,n:o});if(f.llmBehaviour&&f.llmBehaviour=="update"){f.iA(f.target,true);var t={renderTo:f.target,data:u,config:a.config,callback:g};t.config.llmPrompt=a.prompt;f=new CanvasXpress(t)}else{var l=q.parentNode;var b=l.className;var m=k(f.width);var p=c(f.width,f.height);var i=p.id;if(l.parentNode&&l.parentNode.tagName.toLowerCase()=="div"){p=e(p,b);l.after(m);m.after(p)}else{l.appendChild(m);l.appendChild(p)}var t={renderTo:i,data:u,config:a.config,callback:g};t.config.llmPrompt=a.prompt;f.n7();f.VT(true);f.rL();f.isAskingLLM=false;f.Gf();f=new CanvasXpress(t);q=document.getElementById("container-"+f.target);q.style.display="block"}}else{alert("CanvasXpress Container: container-"+a.target+" - not found");r()}}else{alert("CanvasXpress Object: "+a.target+" - not found");r()}}else{alert(a.text)}};CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},BluesDark:{2:"132B4356B1F7"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000",256:"fffffffffffffefefefefefefdfdfdfdfdfdfcfcfcfcfcfcfbfbfbfbfbfbfafafafafafaf9f9f9f9f9f9f9f9f9f8f8f8f8f8f8f7f7f7f7f7f7f6f6f6f6f6f6f5f5f5f5f5f5f4f4f4f4f4f4f3f3f3f3f3f3f2f2f2f2f2f2f1f1f1f1f1f1f0f0f0f0f0f0efefefefefefeeeeeeeeeeeeededededededececececececebebebebebebeaeaeaeaeaeae9e9e9e9e9e9e8e8e8e8e8e8e7e7e7e7e7e7e6e6e6e6e6e6e5e5e5e5e5e5e4e4e4e4e4e4e3e3e3e3e3e3e2e2e2e2e2e2e1e1e1e1e1e1e0e0e0e0e0e0dfdfdfdfdfdfdedededddddddddddddcdcdcdcdcdcdbdbdbdbdbdbdadadadadadad9d9d9d9d9d9d8d8d8d7d7d7d7d7d7d6d6d6d6d6d6d5d5d5d5d5d5d4d4d4d4d4d4d3d3d3d2d2d2d2d2d2d1d1d1d1d1d1d0d0d0cfcfcfcfcfcfcececececececdcdcdcdcdcdcccccccbcbcbcbcbcbcacacacacacac9c9c9c8c8c8c8c8c8c7c7c7c7c7c7c6c6c6c5c5c5c5c5c5c4c4c4c3c3c3c3c3c3c2c2c2c2c2c2c1c1c1c0c0c0c0c0c0bfbfbfbebebebebebebdbdbdbcbcbcbcbcbcbbbbbbbabababababab9b9b9b8b8b8b8b8b8b7b7b7b6b6b6b6b6b6b5b5b5b4b4b4b4b4b4b3b3b3b2b2b2b2b2b2b1b1b1b0b0b0afafafafafafaeaeaeadadadadadadacacacabababaaaaaaaaaaaaa9a9a9a8a8a8a7a7a7a7a7a7a6a6a6a5a5a5a4a4a4a4a4a4a3a3a3a2a2a2a1a1a1a0a0a0a0a0a09f9f9f9e9e9e9d9d9d9c9c9c9c9c9c9b9b9b9a9a9a9999999898989797979797979696969595959494949393939292929191919090909090908f8f8f8e8e8e8d8d8d8c8c8c8b8b8b8a8a8a8989898888888787878686868585858484848383838282828181818080807f7f7f7e7e7e7d7d7d7c7c7c7b7b7b7a7a7a7878787777777676767575757474747373737272727070706f6f6f6e6e6e6d6d6d6b6b6b6a6a6a6969696767676666666565656363636262626060605f5f5f5d5d5d5c5c5c5a5a5a5959595757575555555454545252525050504e4e4e4c4c4c4a4a4a4848484646464444444242424040403d3d3d3b3b3b3838383535353232322e2e2e2b2b2b2727272222221c1c1c15151500000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},White:{1:"ffffff"},Grey:{1:"d3d3d3",2:"d3d3d3cbcbcb",3:"d3d3d3cbcbcbc3c3c3",4:"d3d3d3cbcbcbc3c3c3bbbbbb",5:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3",6:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3ababab",7:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a3",8:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b",9:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b939393",10:"d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b9393938b8b8b"},GreyHC:{4:"ffffffbbbbbb777777333333",6:"ffffffcccccc999999666666333333000000",13:"d3d3d3c3c3c3b3b3b3a3a3a3939393838383737373636363535353434343333333232323131313"},BlueGrey:{1:"0ab0db",2:"0ab0dbd3d3d3",3:"0ab0dbd3d3d3cbcbcb",4:"0ab0dbd3d3d3cbcbcbc3c3c3",5:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbb",6:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3",7:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3ababab",8:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a3",9:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b",10:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b939393",11:"0ab0dbd3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b9393938b8b8b"},BlueRedGrey:{1:"0ab0db",2:"0ab0dbfe6969",3:"0ab0dbfe6969d3d3d3",4:"0ab0dbfe6969d3d3d3cbcbcb",5:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3",6:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbb",7:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3",8:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3ababab",9:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a3",10:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b",11:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b939393",12:"0ab0dbfe6969d3d3d3cbcbcbc3c3c3bbbbbbb3b3b3abababa3a3a39b9b9b9393938b8b8b"},Black:{1:"000000"},Diverging:{5:"f5841dedbb69d0d5e155b5d90c4487"},DivergingAlt:{5:"9e0418dd6c72d0d5e135a0c8042750"},Brand:{4:"cfe2f15eaccf0e76b0042751"},Complementary:{4:"f7d6d5ff8581e040439e0418"},Colorful:{5:"fcf6c4b1ca91718be67d53b0920148"},ColorfulAlt:{5:"fcf6c4edb681c77b7a7f50930e3587"},WHO:{6:"108dc98eca3affa16ae65550ffa3005bc2e7"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"595959",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},Highcharts:{1:"21b1f4",2:"21b1f44f52c1",3:"21b1f44f52c126e17b",4:"21b1f44f52c126e17bfe693d",5:"21b1f44f52c126e17bfe693d6a8bba",6:"21b1f44f52c126e17bfe693d6a8bbad26cf6",7:"21b1f44f52c126e17bfe693d6a8bbad26cf636e0cb",8:"21b1f44f52c126e17bfe693d6a8bbad26cf636e0cbf94b46",9:"21b1f44f52c126e17bfe693d6a8bbad26cf636e0cbf94b46ffb471",10:"21b1f44f52c126e17bfe693d6a8bbad26cf636e0cbf94b46ffb47192e8e1"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},BehancePair:{2:"6b5dd3cec8ff",4:"6b5dd3cec8ffffa2c0ffc6db",6:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7",8:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f",10:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f1b1d218d8e90"},BehanceTrio:{3:"6b5dd3cec8ff9d93e9",6:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a4",9:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5",12:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab",15:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab1b1d218d8e90494a4d"},BehanceQuartet:{4:"6b5dd3cec8ff9d93e98072dc",8:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed3",12:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4ff",16:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d",20:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d1b1d218d8e90494a4dfafafa"},Behance:{1:"6b5dd3",2:"6b5dd3ffa2c0",3:"6b5dd3ffa2c03f8cff",4:"6b5dd3ffa2c03f8cfffece73",5:"6b5dd33f8cffffa2c0fece731b1d21",6:"6b5dd3ffa2c03f8cff9d93e9ffc6dba0d7e7",7:"6b5dd33f8cffffa2c0fece731b1d21ffa25fcdf4ff",8:"6b5dd3ffa2c03f8cfffece739d93e9a0d7e7ffc6dbfee2ab",9:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab",10:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90",15:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d",20:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d8072dccdf4ffffbed3fedd9dfafafa"},GGBlanket:{1:"357BA2",2:"0095A8FFA600",3:"003f5cbc5090ffa600",4:"003f5cbc5090ffa60050bc70",5:"003f5cbc5090ffa60050bc70005aff",6:"003f5cbc5090ffa60050bc70005affff9f5c",7:"003f5cbc5090ffa60050bc70005affff9f5c7a5195",8:"003f5cbc5090ffa60050bc70005affff9f5c7a5195ff6e00",12:"003f5cbc5090ffa600007f8cd075a8ffcc3300bfbfe59bc0fff56600ffffffb6c1ffff99"},Prism:{1:"1f7ff1",2:"1f7ff1814cff",3:"1f7ff1814cffff7d00",4:"1f7ff1814cffff7d0012c5ff",5:"1f7ff1814cffff7d0012c5fff4d4fe",6:"1f7ff1814cffff7d0012c5fff4d4fee9c505",7:"1f7ff1814cffff7d0012c5fff4d4fee9c505898790"},PrismPair:{2:"1f7ff112c5ff",4:"1f7ff112c5ff814cfff4d4fe",6:"1f7ff112c5ff814cfff4d4feff7d00e9c505",8:"1f7ff112c5ff814cfff4d4feff7d00e9c505042d710ccffe"},PrismTrio:{3:"61459939d4fbfe7d29"},BMS:{4:"be2bbb585454a59fa0ede7e8",9:"be2bbb585454a59fa0ede7e8ffeccdfedccad9c5c4c6ffe6c0f2fc"},BMSPrimary:{4:"BE2BBBA69F9F595454EEE7E7"},BMSSecondary:{5:"ffeccdfedccad9c5c4c6ffe6c0f2fc",6:"ffeccdfedccaead6c8e0cbc3d9c5c4d2cac9",8:"FFECCDFEDCCAEAD5C9DFCBC3DAC5C5D2CAC8C5FFE6C0F2FB"},BMSTertiary:{2:"c6ffe6c0f2fc"},BMSTertiaryLight:{5:"59FFB9FDA97D33D6F1CB7C78FFD186"},BMSTertiaryDark:{5:"1DCE9BDF603A009FBA772A28FFAC25"},BMSBackground:{3:"f0ebeaefe6e7f9f7fa"},BMSWheat:{4:"ffeccdfed187feac25c37901"},BMSPink:{4:"fedccafea97de0613cba4421"},BMSBrown:{4:"d9c5c4cb7c79782a28511515"},BMSGreen:{4:"c6ffe652e7bd1ecd9a138967"},BMSBlue:{4:"c0f2fc33d7f102a0baa0778a"},CanvasXpress:{1:"0ab0db",2:"0ab0dbfe6969",3:"0ab0dbfed385fe6969",4:"0ab0dbfed385fe696947db0a",5:"0ab0db9e0adbfed385fe696947db0a",6:"0ab0db9e0adbfed385fe696947db0aff7d00",7:"0ab0db9e0adbfed385fe696947db0aff7d00ffa2c0",8:"0ab0db9e0adbfed385fe696947db0aff7d00ffa2c0a0d7e7",16:"0ab0dbfe6969fed38547db0a9e0adbff7d00ffa2c0a0d7e763b5e5f9a7a7fef0c783e16fc763e5ffb347ffc1d3bfe2ed"},CanvasXpressTraditional:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressOLD:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725",256:"44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf",256:"00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921",256:"0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4",256:"00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46",256:"00204c00204e00215000225100235300235500245600255800265a00265b00275d00285f002861002963002a64002a66002b68002c6a002d6c002d6d002e6e002e6f002f6f002f6f00306f00316f00316f00326e00336e00346e00346e01356e06366e0a376d0e376d12386d15396d17396d1a3a6c1c3b6c1e3c6c203c6c223d6c243e6c263e6c273f6c29406b2b416b2c416b2e426b2f436b31446b32446b33456b35466b36466b37476b38486b3a496b3b496b3c4a6b3d4b6b3e4b6b404c6b414d6b424e6b434e6b444f6b45506b46506b47516b48526b49536b4a536b4b546b4c556b4d556b4e566b4f576c50586c51586c52596c535a6c545a6c555b6c565c6c575d6d585d6d595e6d5a5f6d5b5f6d5c606d5d616e5e626e5f626e5f636e60646e61656f62656f63666f64676f65676f666870676970686a70686a70696b716a6c716b6d716c6d726d6e726e6f726f6f726f70737071737172737272747373747474757575757575757676767777767878767978777a79777b7a777b7b787c7b787d7c787e7d787f7e78807e78817f788280788381788481788582788683788784788885788985788a86788b87788c88788d88788e89788f8a78908b78918c78928c78938d78948e78958f78968f779790779891779992779a93779b93779c94779d95779e96769f9776a09876a19876a29976a39a75a49b75a59c75a69c75a79d75a89e74a99f74aaa074aba174aca173ada273aea373afa473b0a572b1a672b2a672b4a771b5a871b6a971b7aa70b8ab70b9ab70baac6fbbad6fbcae6ebdaf6ebeb06ebfb16dc0b16dc1b26cc2b36cc3b46cc5b56bc6b66bc7b76ac8b86ac9b869cab969cbba68ccbb68cdbc67cebd67d0be66d1bf66d2c065d3c065d4c164d5c263d6c363d7c462d8c561d9c661dbc760dcc860ddc95fdeca5edfcb5de0cb5de1cc5ce3cd5be4ce5be5cf5ae6d059e7d158e8d257e9d356ebd456ecd555edd654eed753efd852f0d951f1da50f3db4ff4dc4ef5dd4df6de4cf7df4bf9e049fae048fbe147fce246fde345ffe443ffe542ffe642ffe743ffe844ffe945"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"},LastAirBenderFire:{8:"ecb100a100007E605EFF45009948234B4C4E572530000000"},LastAirBenderAir:{7:"ff9933C24841FFFF338B5B4587AFD1EEB05ADBC5A0"},LastAirBenderEarth:{9:"015E05B1A8667A5C1264674225351C4C7022C7C45ED2CFABFEFED8"},LastAirBenderWater:{8:"0047ab1DB4D3A2CAEDAFB5B8120976fffafa174D79949BBC"},SpongeBob:{11:"C86925FDF56CC4433F989B46FC95765D57AFB2CE31FF2027000000B1D6C5AB8323"},Simpsons:{10:"fed90f424f46d1b271FB4122ABC67D0363C37A491E000000FC020946732E"},RickyAndMorty:{9:"01B4C697ce4cFFF874BEE5FDF675DA44281d3a4767F8D3ACE64358"},ParksAndRecreation:{10:"bdbdbda51209ffdb58ec70147A491EC24841005502f7fcb969983ab5651d"},KimPossible:{12:"FF8C0002466370D42389160402001F9CF6F7FFCE455D734DFEC3BB662C9Cfff9f5000000"},GravityFalls:{14:"417BA1ff1493ffff2e3456348b0000ff670093C0D58b45139248A71c88594747478fbc8fd2b48c000000"},GameOfThronesStark:{9:"cadde17B906F174D79fffafa898989D4CDB1708090120976000000"},GameOfThronesStannis:{7:"FF0000ff8d1aFFD700b20000cc6600FFFF66000000"},GameOfThronesLannister:{6:"89080AC5AA73FEDF25C248418B5B45000000"},GameOfThronesTyrell:{9:"068105F7DC27808000AB681BF9FE768DA08071749798FB983CB371"},GameOfThronesTargaryen:{5:"AC1F25272727ff993382878896804b"},GameOfThronesMartell:{8:"ff8000cc6600b81b1873110ff8fc23fafd7b4c2600a57642"},GameOfThronesTully:{6:"212250AE432FE4EDCA8B5B454682B4000000"},GameOfThronesGreyjoy:{6:"000000708090D4CDB1DCDCDCF7DC27808080"},GameOfThronesManderly:{7:"40e0d080808000ff00282828015202195953FFFFFF"},GameOfThronesArryn:{7:"007fff7fbfff0019334c4cffffefb2a89797FFFFFF"},Brooklyn99Regular:{10:"e7298a72bcd4e41a1cFCF40E49f149f16913525252F9FEFF000E33000000"},Brooklyn99Dark:{9:"6CA9C33A3533000E33800000CBCFD2175E78DAA520174D79000000"}};for(var e in CanvasXpress.colorSchemes){for(var f in CanvasXpress.colorSchemes[e]){var c=CanvasXpress.colorSchemes[e][f].match(/.{6}/g);CanvasXpress.colorSchemes[e][f]=c?c.map(function(a){return"#"+a}):[]}}var b=["Viridis","Magma","Plasma","Inferno","Cividis"];var b=["Viridis"];for(var d=0;d<b.length;d++){var e=JSON.parse(JSON.stringify(CanvasXpress.colorSchemes[b[d]]));CanvasXpress.colorSchemes[b[d]+"Inv"]={};for(var f in e){CanvasXpress.colorSchemes[b[d]+"Inv"][f]=e[f].reverse()}}}();CanvasXpress.instances=CanvasXpress.instances||[];CanvasXpress.config=CanvasXpress.config||[];CanvasXpress.transitions=CanvasXpress.transitions||{};CanvasXpress.remoteUpdating=CanvasXpress.remoteUpdating||false;CanvasXpress.cacheImages=CanvasXpress.cacheImages||{};CanvasXpress.cacheImagesReady=CanvasXpress.cacheImagesReady||false;CanvasXpress.cachePatterns=CanvasXpress.cachePatterns||{};CanvasXpress.cacheText=CanvasXpress.cacheText||{};CanvasXpress.fonts=CanvasXpress.fonts||{"American Typewriter":true,"Andale Mono":true,Arial:true,Baskerville:true,"Bradley Hand":true,"Brush Script MT":true,"Comic Sans MS":true,Courier:true,Didot:true,Georgia:true,"Gill Sans":true,Helvetica:true,Impact:true,"Lucida Console":true,Luminari:true,Monaco:true,Optima:true,Palatino:true,Roboto:true,Tahoma:true,"Times New Roman":true,"Trebuchet MS":true,Verdana:true};CanvasXpress.selector=CanvasXpress.selector||{vars:{},smps:{},meta:{},comp:{},nodes:{},edges:{},mixed:{},selections:0,groups:{},graphType:false};CanvasXpress.hidden=CanvasXpress.hidden||{hiddenVars:{},hiddenSmps:{},hiddenGrps:{},hiddenMapFeatures:{},hiddenNodes:{},hiddenEdges:{}};CanvasXpress.stack=CanvasXpress.stack||{};CanvasXpress.current=CanvasXpress.current||false;CanvasXpress.chain=CanvasXpress.chain||{};CanvasXpress.resizing=CanvasXpress.resizing||false;CanvasXpress.registered="A41322571F0767404733FF6AE60E";CanvasXpress.system=CanvasXpress.system||{};CanvasXpress.ready=CanvasXpress.ready||false;CanvasXpress.readyFonts=CanvasXpress.readyFonts||false;CanvasXpress.png="data:image/png;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.dates={Sun:1,Mon:2,Tue:3,Wed:4,Thu:5,Fri:6,Sat:7,Sunday:1,Monday:2,Tuesday:3,Wednesday:4,Thursday:5,Friday:6,Saturday:7,Jan:"01",Feb:"02",Mar:"03",Apr:"04",May:"05",Jun:"06",Jul:"07",Aug:"08",Sep:"09",Oct:"10",Nov:"11",Dec:"12",January:"01",February:"02",March:"03",April:"04",May:"05",June:"06",July:"07",August:"08",September:"09",October:"10",November:"11",December:"12"};CanvasXpress.countries={"-99":["Unknown","Unknown","Unknown","UNK",0,0,"UNK"],ABW:["Aruba","Americas","Caribbean","AW",12.515,-69.976,"ABW"],AFG:["Afghanistan","Asia","Southern Asia","AF",33.838,66.026,"AFG"],AGO:["Angola","Africa","Middle Africa","AO",-12.296,17.544,"AGO"],AIA:["Anguilla","Americas","Caribbean","AI",18.222,-63.061,"AIA"],ALA:["Aland Islands","Europe","Northern Europe","AX",60.205,19.953,"ALA"],ALB:["Albania","Europe","Southern Europe","AL",41.142,20.068,"ALB"],AND:["Andorra","Europe","Southern Europe","AD",42.548,1.576,"AND"],ANT:["Netherlands Antilles","Americas","Caribbean","AN",12.187,-68.694,"NLD"],ARE:["United Arab Emirates","Asia","Western Asia","AE",23.903,54.34,"ARE"],ARG:["Argentina","Americas","South America","AR",-35.377,-65.168,"ARG"],ARM:["Armenia","Asia","Western Asia","AM",40.286,44.946,"ARM"],ASM:["American Samoa","Oceania","Polynesia","AS",-14.305,-170.708,"ASM"],ATF:["French Southern and Antarctic Territories","Antarctica","Antartica","TF",-49.192,68.861,"FRA"],ATG:["Antigua & Barbuda","Americas","Caribbean","AG",17.279,-61.792,"ATG",["Antigua and Barbuda"]],AUS:["Australia","Oceania","Australia and New Zealand","AU",-25.735,134.489,"AUS"],AUT:["Austria","Europe","Western Europe","AT",47.592,14.14,"AUT"],AZE:["Azerbaijan","Asia","Western Asia","AZ",40.296,48.819,"AZE"],BDI:["Burundi","Africa","Eastern Africa","BI",-3.357,29.887,"BDI"],BEL:["Belgium","Europe","Western Europe","BE",50.642,4.663,"BEL"],BEN:["Benin","Africa","Western Africa","BJ",9.647,2.343,"BEN"],BFA:["Burkina Faso","Africa","Western Africa","BF",12.277,-1.741,"BFA"],BGD:["Bangladesh","Asia","Southern Asia","BD",23.843,90.268,"BGD"],BGR:["Bulgaria","Europe","Eastern Europe","BG",42.761,25.231,"BGR"],BHR:["Bahrain","Asia","Western Asia","BH",26.022,50.559,"BHR"],BHS:["Bahamas","Americas","Caribbean","BS",24.201,-76.547,"BHS"],BIH:["Bosnia & Herzegovina","Europe","Southern Europe","BA",44.168,17.786,"BIH",["Bosnia and Herzegovina"]],BLR:["Belarus","Europe","Eastern Europe","BY",53.539,28.046,"BLR"],BLZ:["Belize","Americas","Central America","BZ",17.217,-88.685,"BLZ"],BMU:["Bermuda","Americas","Northern America","BM",32.316,-64.74,"BMU"],BOL:["Bolivia","Americas","South America","BO",-16.715,-64.671,"BOL"],BRA:["Brazil","Americas","South America","BR",-10.774,-53.09,"BRA"],BRB:["Barbados","Americas","Caribbean","BB",13.178,-59.562,"BRB"],BRN:["Brunei Darussalam","Asia","South-Eastern Asia","BN",4.521,114.761,"BRN",["Brunei"]],BTN:["Bhutan","Asia","Southern Asia","BT",27.415,90.429,"BTN"],BVT:["Bouvet Island","Antarctica","Antartica","BV",-54.422,3.412,"NOR"],BWA:["Botswana","Africa","Southern Africa","BW",-22.183,23.815,"BWA"],CAF:["Central African Republic","Africa","Middle Africa","CF",6.571,20.482,"CAF"],CAN:["Canada","Americas","Northern America","CA",61.392,-98.266,"CAN"],CCK:["Cocos (Keeling) Islands","Asia","South-Eastern Asia","CC",-12.172,96.836,"AUS"],CHE:["Switzerland","Europe","Western Europe","CH",46.802,8.234,"CHE"],CHL:["Chile","Americas","South America","CL",-37.853,-71.374,"CHL"],CHN:["China","Asia","Eastern Asia","CN",36.567,103.904,"CHN"],CIV:["Cote d'Ivoire","Africa","Western Africa","CI",7.631,-5.556,"CIV"],CMR:["Cameroon","Africa","Middle Africa","CM",5.685,12.743,"CMR"],COD:["Democratic Republic of the Congo","Africa","Middle Africa","CD",-2.877,23.655,"COD",["Democratic Republic of Congo"]],COG:["Congo","Africa","Middle Africa","CG",-0.841,15.224,"COG"],COK:["Cook Islands","Oceania","Polynesia","CK",-20.935,-158.909,"NZL"],COL:["Colombia","Americas","South America","CO",3.901,-73.074,"COL"],COM:["Comoros","Africa","Eastern Africa","KM",-11.893,43.675,"COM"],CPV:["Cape Verde","Africa","Western Africa","CV",15.978,-23.968,"CPV"],CRI:["Costa Rica","Americas","Central America","CR",9.97,-84.188,"CRI"],CUB:["Cuba","Americas","Caribbean","CU",21.621,-79.037,"CUB"],CXR:["Christmas Island","Asia","South-Eastern Asia","CX",-10.445,105.703,"AUS"],CYM:["Cayman Islands","Americas","Caribbean","KY",19.308,-81.239,"GBR"],CYP:["Cyprus","Asia","Western Asia","CY",35.045,33.221,"CYP"],CZE:["Czech Republic","Europe","Eastern Europe","CZ",49.742,15.338,"CZE",["Czechia"]],DEU:["Germany","Europe","Western Europe","DE",51.106,10.393,"DEU"],DJI:["Djibouti","Africa","Eastern Africa","DJ",11.749,42.577,"DJI"],DMA:["Dominica","Americas","Caribbean","DM",15.435,-61.356,"DMA"],DNK:["Denmark","Europe","Northern Europe","DK",55.963,10.046,"DNK"],DOM:["Dominican Republic","Americas","Caribbean","DO",18.894,-70.485,"DOM"],DZA:["Algeria","Africa","Northern Africa","DZ",28.163,2.632,"DZA"],ECU:["Ecuador","Americas","South America","EC",-1.428,-78.768,"ECU"],EGY:["Egypt","Africa","Northern Africa","EG",26.553,29.79,"EGY"],EGY1:["Ma'tan al-Sarra","Africa","Northern Africa","EGY1",21.892,33.743,"EGY"],ERI:["Eritrea","Africa","Eastern Africa","ER",15.373,38.841,"ERI"],ESH:["Western Sahara","Africa","Northern Africa","EH",24.661,-13.137,"ESH"],ESP:["Spain","Europe","Southern Europe","ES",40.226,-3.65,"ESP"],EST:["Estonia","Europe","Northern Europe","EE",58.674,25.527,"EST"],ETH:["Ethiopia","Africa","Eastern Africa","ET",8.633,39.616,"ETH"],FIN:["Finland","Europe","Northern Europe","FI",64.5,26.266,"FIN"],FJI:["Fiji","Oceania","Melanesia","FJ",-17.454,171.983,"FJI"],FLK:["Falkland Islands (Malvinas)","Americas","South America","FK",-51.738,-59.364,"GBR",["Falkland Islands"]],FRA:["France","Europe","Western Europe","FR",46.564,2.551,"FRA"],FRA1:["Glorioso Islands","Africa","Eastern Africa","FRA1",-11.567,47.29,"FRA"],FRO:["Faroe Islands","Europe","Northern Europe","FO",62.031,-6.885,"DNK"],FSM:["Micronesia (Federated States of)","Oceania","Micronesia","FM",6.492,159.404,"FSM",["Federated States of Micronesia"]],GAB:["Gabon","Africa","Middle Africa","GA",-0.591,11.797,"GAB"],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","Northern Europe","GB",54.155,-2.896,"GBR",["United Kingdom"]],GBR1:["Jersey","Europe","Northern Europe","GBR1",49.219,-2.129,"GBR"],GBR2:["South Georgia & the South Sandwich Islands","Antarctica","Antartica","GBR2",-54.489,-36.383,"GBR"],GBR3:["Guernsey","Europe","Northern Europe","GBR3",49.458,-2.577,"GBR"],GEO:["Georgia","Asia","Western Asia","GE",42.176,43.517,"GEO"],GHA:["Ghana","Africa","Western Africa","GH",7.959,-1.208,"GHA"],GIB:["Gibraltar","Europe","Southern Europe","GI",36.138,-5.345,"GBR"],GIN:["Guinea","Africa","Western Africa","GN",10.438,-10.942,"GIN"],GLP:["Guadeloupe","Americas","Caribbean","GP",16.203,-61.537,"FRA"],GMB:["Gambia","Africa","Western Africa","GM",13.452,-15.387,"GMB",["The Gambia"]],GNB:["Guinea-Bissau","Africa","Western Africa","GW",12.03,-14.966,"GNB"],GNQ:["Equatorial Guinea","Africa","Middle Africa","GQ",1.712,10.341,"GNQ"],GRC:["Greece","Europe","Southern Europe","GR",39.068,22.959,"GRC"],GRD:["Grenada","Americas","Caribbean","GD",12.112,-61.68,"GRD"],GRL:["Greenland","Americas","Northern America","GL",74.72,-41.39,"DNK"],GTM:["Guatemala","Americas","Central America","GT",15.702,-90.357,"GTM"],GUF:["French Guiana","Americas","South America","GF",3.924,-53.242,"FRA"],GUM:["Guam","Oceania","Micronesia","GU",13.443,144.775,"GUM"],GUY:["Guyana","Americas","South America","GY",4.792,-58.975,"GUY"],HKG:["Hong Kong","Asia","Eastern Asia","HK",22.377,114.11,"CHN"],HMD:["Heard Island and McDonald Islands","Antarctica","Antartica","HM",-53.092,73.498,"AUS"],HND:["Honduras","Americas","Central America","HN",14.819,-86.62,"HND"],HRV:["Croatia","Europe","Southern Europe","HR",45.051,16.411,"HRV"],HTI:["Haiti","Americas","Caribbean","HT",18.941,-72.68,"HTI"],HUN:["Hungary","Europe","Eastern Europe","HU",47.166,19.413,"HUN"],IDN:["Indonesia","Asia","South-Eastern Asia","ID",-2.231,117.3,"IDN"],IMY:["Isle of Man","Europe","Northern Europe","IM",54.229,-4.526,"GBR"],IND:["India","Asia","Southern Asia","IN",22.326,79.386,"IND"],IND1:["Arunachal Pradesh","Asia","Eastern Asia","IND1",28.121,94.35,"IND"],IOT:["British Indian Ocean Territory","Africa","Eastern Africa","IO",-7.335,72.434,"IOT"],IRL:["Ireland","Europe","Northern Europe","IE",53.176,-8.151,"IRL"],IRN:["Iran (Islamic Republic of)","Asia","Southern Asia","IR",32.739,54.197,"IRN",["Iran","Islamic Republic of Iran"]],IRQ:["Iraq","Asia","Western Asia","IQ",33.048,43.772,"IRQ"],ISL:["Iceland","Europe","Northern Europe","IS",64.997,-18.606,"ISL"],ISR:["Israel","Asia","Western Asia","IL",31.358,34.965,"ISR"],ITA:["Italy","Europe","Southern Europe","IT",42.795,12.071,"ITA"],JAM:["Jamaica","Americas","Caribbean","JM",18.151,-77.32,"JAM"],JOR:["Jordan","Asia","Western Asia","JO",31.253,36.786,"JOR"],JPN:["Japan","Asia","Eastern Asia","JP",37.562,137.99,"JPN"],KAZ:["Kazakhstan","Asia","Central Asia","KZ",48.015,66.657,"KAZ",["Baikonur Cosmodrome"]],KAZ1:["Baikonur Cosmodrome","Asia","Central Asia","KAZ1",45.965,63.305,"KAZ"],KEN:["Kenya","Africa","Eastern Africa","KE",0.529,37.858,"KEN"],KGZ:["Kyrgyzstan","Asia","Central Asia","KG",41.465,74.555,"KGZ"],KHM:["Cambodia","Asia","South-Eastern Asia","KH",12.716,104.923,"KHM"],KIR:["Kiribati","Oceania","Micronesia","KI",1.834,-154.459,"KIR"],KNA:["Saint Kitts and Nevis","Americas","Caribbean","KN",17.326,-62.754,"KNA"],KOR:["Republic of Korea","Asia","Eastern Asia","KR",36.375,127.834,"KOR"],KSV:["Kosovo","Europe","Eastern Europe","KV",42.602,20.903,"KSV"],KWT:["Kuwait","Asia","Western Asia","KW",29.34,47.59,"KWT"],LAO:["Lao People's Democratic Republic","Asia","South-Eastern Asia","LA",18.502,103.763,"LAO",["Lao DPR","Laos"]],LBN:["Lebanon","Asia","Western Asia","LB",33.92,35.888,"LBN"],LBR:["Liberia","Africa","Western Africa","LR",6.448,-9.308,"LBR"],LBY:["Libyan Arab Jamahiriya","Africa","Northern Africa","LY",27.043,18.023,"LBY",["Libya"]],LCA:["Saint Lucia","Americas","Caribbean","LC",13.897,-60.969,"LCA"],LIE:["Liechtenstein","Europe","Western Europe","LI",47.151,9.554,"LIE"],LKA:["Sri Lanka","Asia","Southern Asia","LK",7.608,80.704,"LKA"],LSO:["Lesotho","Africa","Southern Africa","LS",-29.582,28.243,"LSO"],LTU:["Lithuania","Europe","Northern Europe","LT",55.335,23.898,"LTU"],LUX:["Luxembourg","Europe","Western Europe","LU",49.77,6.087,"LUX"],LVA:["Latvia","Europe","Northern Europe","LV",56.857,24.929,"LVA"],MAC:["Macao","Asia","Eastern Asia","MO",22.183,113.55,"CHN"],MAR:["Morocco","Africa","Northern Africa","MA",31.883,-6.318,"MAR"],MCO:["Monaco","Europe","Western Europe","MC",43.747,7.412,"MCO"],MDA:["Moldova","Europe","Eastern Europe","MD",47.193,28.473,"MDA",["Republic of Moldova"]],MDG:["Madagascar","Africa","Eastern Africa","MG",-19.374,46.706,"MDG"],MDV:["Maldives","Asia","Southern Asia","MV",3.216,73.252,"MDV"],MEX:["Mexico","Americas","Central America","MX",23.95,-102.533,"MEX"],MHL:["Marshall Islands","Oceania","Micronesia","MH",7.643,168.626,"MHL"],MKD:["The former Yugoslav Republic of Macedonia","Europe","Southern Europe","MK",41.599,21.697,"MKD",["Macedonia"]],MLI:["Mali","Africa","Western Africa","ML",17.35,-3.525,"MLI"],MLT:["Malta","Europe","Southern Europe","MT",35.89,14.441,"MLT"],MMR:["Myanmar","Asia","South-Eastern Asia","MM",21.154,96.506,"MMR"],MNE:["Montenegro","Europe","Southern Europe","ME",42.791,19.25,"MNE"],MNG:["Mongolia","Asia","Eastern Asia","MN",46.835,103.083,"MNG"],MNP:["Northern Mariana Islands","Oceania","Micronesia","MP",15.088,145.679,"USA"],MOZ:["Mozambique","Africa","Eastern Africa","MZ",-17.26,35.551,"MOZ"],MRT:["Mauritania","Africa","Western Africa","MR",20.259,-10.333,"MRT"],MSR:["Montserrat","Americas","Caribbean","MS",16.735,-62.187,"GBR"],MTQ:["Martinique","Americas","Caribbean","MQ",14.652,-61.022,"FRA"],MUS:["Mauritius","Africa","Eastern Africa","MU",-20.252,57.87,"MUS"],MWI:["Malawi","Africa","Eastern Africa","MW",-13.217,34.307,"MWI"],MYS:["Malaysia","Asia","South-Eastern Asia","MY",3.792,109.708,"MYS"],MYT:["Mayotte","Africa","Eastern Africa","YT",-12.819,45.138,"FRA"],NAM:["Namibia","Africa","Southern Africa","NA",-22.134,17.218,"NAM"],NCL:["New Caledonia","Oceania","Melanesia","NC",-21.317,165.715,"FRA"],NER:["Niger","Africa","Western Africa","NE",17.426,9.397,"NER"],NFK:["Norfolk Island","Oceania","Australia and New Zealand","NF",-29.038,167.952,"AUS"],NGA:["Nigeria","Africa","Western Africa","NG",9.593,8.105,"NGA"],NIC:["Nicaragua","Americas","Central America","NI",12.839,-85.035,"NIC"],NIU:["Niue","Oceania","Polynesia","NU",-19.053,-169.869,"NZL"],NLD:["Netherlands","Europe","Western Europe","NL",52.249,5.603,"NLD"],NOR:["Norway","Europe","Northern Europe","NO",64.448,14.084,"NOR"],NPL:["Nepal","Asia","Southern Asia","NP",28.253,83.938,"NPL"],NRU:["Nauru","Oceania","Micronesia","NR",-0.529,166.923,"NRU"],NZL:["New Zealand","Oceania","Australia and New Zealand","NZ",-41.839,171.779,"NZL"],OMN:["Oman","Asia","Western Asia","OM",20.597,56.111,"OMN"],PAK:["Pakistan","Asia","Southern Asia","PK",29.357,68.79,"PAK"],PAN:["Panama","Americas","Central America","PA",8.507,-80.103,"PAN"],PCN:["Pitcairn Island","Oceania","Polynesia","PN",-24.477,-128.594,"GBR"],PER:["Peru","Americas","South America","PE",-9.164,-74.376,"PER"],PHL:["Philippines","Asia","South-Eastern Asia","PH",11.741,122.878,"PHL"],PLW:["Palau","Oceania","Micronesia","PW",7.501,134.568,"PLW"],PNG:["Papua New Guinea","Oceania","Melanesia","PG",-6.479,145.241,"PNG"],POL:["Poland","Europe","Eastern Europe","PL",52.124,19.4,"POL"],PRI:["Puerto Rico","Americas","Caribbean","PR",18.221,-66.463,"USA"],PRK:["Democratic People's Republic of Korea","Asia","Eastern Asia","KP",40.143,127.181,"PRK",["Democratic Republic of Korea","Dem. Rep. of Korea"]],PRT:["Portugal","Europe","Southern Europe","PT",39.691,-7.963,"PRT"],PRT1:["Azores Islands","Europe","Southern Europe","PRT1",38.332,-27.304,"PRT"],PRT2:["Madeira Islands","Europe","Southern Europe","PRT2",32.747,-16.985,"PRT"],PRY:["Paraguay","Americas","South America","PY",-23.237,-58.392,"PRY"],PSE:["West Bank","Asia","Western Asia","PS",31.946,35.256,"XXX"],PSE:["Gaza Strip","Asia","Western Asia","PS",31.401,34.372,"XXX"],PYF:["French Polynesia","Oceania","Polynesia","PF",-14.855,-146.419,"FRA"],QAT:["Qatar","Asia","Western Asia","QA",25.297,51.188,"QAT"],REU:["Reunion","Africa","Eastern Africa","RE",-21.122,55.538,"FRA"],ROU:["Romania","Europe","Eastern Europe","RO",45.843,24.969,"ROU"],RUS:["Russian Federation","Europe","Eastern Europe","RU",61.949,96.568,"RUS",["Russia"]],RUS1:["Kuril Islands","Asia","Eastern Asia","RUS1",44.691,147.162,"RUS"],RWA:["Rwanda","Africa","Eastern Africa","RW",-1.998,29.917,"RWA"],SAU:["Saudi Arabia","Asia","Western Asia","SA",24.122,44.545,"SAU"],SDN:["Sudan","Africa","Northern Africa","SD",16.019,29.958,"SDN"],SDN1:["Abyei","Africa","Northern Africa","SDN1",9.767,28.398,"SDN"],SDN2:["Hala'ib Triangle","Africa","Northern Africa","SDN2",22.3,35.615,"SDN"],SDN3:["Ilemi Triangle","Africa","Northern Africa","SDN3",4.764,35.108,"SDN"],SEN:["Senegal","Africa","Western Africa","SN",14.366,-14.468,"SEN"],SGP:["Singapore","Asia","South-Eastern Asia","SG",1.351,103.808,"SGP"],SGS:["South Georgia & the South Sandwich Islands","Americas","South America","GS",-54.429,-36.587,"GBR"],SHN:["Saint Helena","Africa","Western Africa","SH",-15.965,-5.711,"GBR"],SJM:["Svalbard and Jan Mayen Islands","Europe","Northern Europe","SJ",78.828,18.363,"NOR"],SLB:["Solomon Islands","Oceania","Melanesia","SB",-8.919,159.634,"SLB"],SLE:["Sierra Leone","Africa","Western Africa","SL",8.56,-11.792,"SLE"],SLV:["El Salvador","Americas","Central America","SV",13.736,-88.867,"SLV"],SMR:["San Marino","Europe","Southern Europe","SM",43.943,12.458,"SMR"],SOM:["Somalia","Africa","Eastern Africa","SO",6.063,45.862,"SOM"],SPM:["Saint Pierre and Miquelon","Americas","Northern America","PM",46.946,-56.262,"FRA"],SRB:["Serbia","Europe","Southern Europe","RS",44.031,20.805,"SRB"],SSD:["South Sudan","Africa","Middle Africa","SS",7.295,30.315,"SSD"],STP:["Sao Tome and Principe","Africa","Middle Africa","ST",0.456,6.736,"STP"],SUR:["Suriname","Americas","South America","SR",4.126,-55.912,"SUR"],SVK:["Slovakia","Europe","Eastern Europe","SK",48.707,19.491,"SVK"],SVN:["Slovenia","Europe","Southern Europe","SI",46.123,14.826,"SVN"],SWE:["Sweden","Europe","Northern Europe","SE",62.789,16.739,"SWE"],SWZ:["Swaziland","Africa","Southern Africa","SZ",-26.563,31.497,"SWZ"],SYC:["Seychelles","Africa","Eastern Africa","SC",-6.355,52.229,"SYC"],SYR:["Syrian Arab Republic","Asia","Western Asia","SY",35.013,38.505,"SYR",["Syria"]],TCA:["Turks and Caicos Islands","Americas","Caribbean","TC",21.836,-71.813,"GBR"],TCD:["Chad","Africa","Middle Africa","TD",15.361,18.664,"TCD"],TGO:["Togo","Africa","Western Africa","TG",8.534,0.975,"TGO"],THA:["Thailand","Asia","South-Eastern Asia","TH",15.127,101.017,"THA"],TJK:["Tajikistan","Asia","Central Asia","TJ",38.528,71.042,"TJK"],TKL:["Tokelau","Oceania","Polynesia","TK",-9.196,-171.853,"TKL"],TKM:["Turkmenistan","Asia","Central Asia","TM",39.218,58.391,"TKM"],TLS:["Timor-Leste","Asia","South-Eastern Asia","TL",-8.823,125.853,"TLS"],TON:["Tonga","Oceania","Polynesia","TO",-20.403,-174.837,"TON"],TTO:["Trinidad and Tobago","Americas","Caribbean","TT",10.468,-61.254,"TTO"],TUN:["Tunisia","Africa","Northern Africa","TN",34.11,9.561,"TUN"],TUR:["Turkey","Asia","Western Asia","TR",39.06,35.179,"TUR"],TUV:["Tuvalu","Oceania","Polynesia","TV",-7.828,178.557,"TUV"],TWN:["Taiwan","Asia","Eastern Asia","TW",23.754,120.95,"CHN"],TZA:["United Republic of Tanzania","Africa","Eastern Africa","TZ",-6.271,34.823,"TZA",["Tanzania"]],UGA:["Uganda","Africa","Eastern Africa","UG",1.279,32.386,"UGA"],UKR:["Ukraine","Europe","Eastern Europe","UA",49.017,31.387,"UKR"],URY:["Uruguay","Americas","South America","UY",-32.8,-56.013,"URY"],USA:["United States of America","Americas","Northern America","US",45.695,-112.492,"USA",["United States"]],USA1:["Guantanamo","Americas","Caribbean","USA1",19.927,-75.143,"USA"],USA2:["Jarvis Island","Americas","Northern America","USA2",-0.387,-160.028,"USA"],USA3:["Midway Island","Americas","Northern America","USA3",28.205,-177.379,"USA"],UZB:["Uzbekistan","Asia","Central Asia","UZ",41.75,63.169,"UZB"],VAT:["Holy See","Europe","Southern Europe","VA",41.903,12.452,"VAT",["Vatican City"]],VCT:["Saint Vincent and the Grenadines","Americas","Caribbean","VC",13.254,-61.194,"VCT"],VEN:["Venezuela","Americas","South America","VE",7.122,-66.17,"VEN"],VGB:["British Virgin Islands","Americas","Caribbean","VG",18.444,-64.531,"GBR"],VIR:["United States Virgin Islands","Americas","Caribbean","VI",17.905,-64.808,"USA"],VNM:["Vietnam","Asia","South-Eastern Asia","VN",16.659,106.301,"VNM"],VUT:["Vanuatu","Oceania","Melanesia","VU",-16.256,167.718,"VUT"],WSM:["Samoa","Oceania","Polynesia","WS",-13.759,-172.16,"WSM"],XXX1:["Paracel Islands","Asia","South-Eastern Asia","XXX1",16.701,112.375,"XXX"],XXX2:["Spratly Islands","Asia","South-Eastern Asia","XXX2",10.562,115.597,"XXX"],XXY1:["Aksai Chin","Asia","Eastern Asia","XXY1",35.033,79.127,"XXY"],XXZ1:["Jammu-Kashmir","Asia","Eastern Asia","XXZ1",34.55,75.807,"XXZ"],YEM:["Yemen","Asia","Western Asia","YE",15.905,47.599,"YEM"],ZAF:["South Africa","Africa","Southern Africa","ZA",-28.994,25.088,"ZAF"],ZMB:["Zambia","Africa","Eastern Africa","ZM",-13.454,27.798,"ZMB"],ZWE:["Zimbabwe","Africa","Eastern Africa","ZW",-19.001,29.871,"ZWE"]};CanvasXpress.usa={AK:["Alaska",63.588753,-154.493062],AL:["Alabama",32.318231,-86.902298],AR:["Arkansas",35.20105,-91.831833],AZ:["Arizona",34.048928,-111.093731],CA:["California",36.778261,-119.417932],CO:["Colorado",39.550051,-105.782067],CT:["Connecticut",41.603221,-73.087749],DC:["District of Columbia",38.905985,-77.033418],DE:["Delaware",38.910832,-75.52767],FL:["Florida",27.664827,-81.515754],GA:["Georgia",32.157435,-82.907123],HI:["Hawaii",19.898682,-155.665857],IA:["Iowa",41.878003,-93.097702],ID:["Idaho",44.068202,-114.742041],IL:["Illinois",40.633125,-89.398528],IN:["Indiana",40.551217,-85.602364],KS:["Kansas",39.011902,-98.484246],KY:["Kentucky",37.839333,-84.270018],LA:["Louisiana",31.244823,-92.145024],MA:["Massachusetts",42.407211,-71.382437],MD:["Maryland",39.045755,-76.641271],ME:["Maine",45.253783,-69.445469],MI:["Michigan",44.314844,-85.602364],MN:["Minnesota",46.729553,-94.6859],MO:["Missouri",37.964253,-91.831833],MS:["Mississippi",32.354668,-89.398528],MT:["Montana",46.879682,-110.362566],NC:["North Carolina",35.759573,-79.0193],ND:["North Dakota",47.551493,-101.002012],NE:["Nebraska",41.492537,-99.901813],NH:["New Hampshire",43.193852,-71.572395],NJ:["New Jersey",40.058324,-74.405661],NM:["New Mexico",34.97273,-105.032363],NV:["Nevada",38.80261,-116.419389],NY:["New York",43.299428,-74.217933],OH:["Ohio",40.417287,-82.907123],OK:["Oklahoma",35.007752,-97.092877],OR:["Oregon",43.804133,-120.554201],PA:["Pennsylvania",41.203322,-77.194525],PR:["Puerto Rico",18.220833,-66.590149],RI:["Rhode Island",41.580095,-71.477429],SC:["South Carolina",33.836081,-81.163725],SD:["South Dakota",43.969515,-99.901813],TN:["Tennessee",35.517491,-86.580447],TX:["Texas",31.968599,-99.901813],UT:["Utah",39.32098,-111.093731],VA:["Virginia",37.431573,-78.656894],VT:["Vermont",44.558803,-72.577841],WA:["Washington",47.751074,-120.740139],WI:["Wisconsin",43.78444,-88.787868],WV:["West Virginia",38.597626,-80.454903],WY:["Wyoming",43.075968,-107.290284]};CanvasXpress.maps={Africa:"/data/json/africa.geo.json",Asia:"/data/json/asia.geo.json",Countries:"/data/json/countries.geo.json",Europe:"/data/json/europe.geo.json",NorthAmerica:"/data/json/north-america.geo.json",Oceania:"/data/json/oceania.geo.json",SouthAmerica:"/data/json/south-america.geo.json",USACounties:"/data/json/usa-counties.json",USADistricts:"/data/json/usa-districts.json",USAStates:"/data/json/usa-states.json",WorldContinents:"/data/json/world-continents-geo.json",World:"/data/json/world.geojson",WorldMedium:"/data/json/worldm.geojson",WorldHigh:"/data/json/worldh.geojson",WorldDeprecated:"/data/json/world.geo.json"};CanvasXpress.example={y:{vars:["A","B","C"],smps:["X","Y","Z"],data:[[1,2,3],[4,5,6],[7,8,9]]}};CanvasXpress.geojson={type:"FeatureCollection",features:[{type:"Feature",properties:{name:"Dummy"},geometry:{type:"Polygon",coordinates:[[[-180,-90],[180,-90],[180,90],[-180,90],[-180,-90]]]}}]};CanvasXpress.chromosomes={hg38:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9100000,"p36.23","gpos25"],[9100000,12500000,"p36.22","gneg"],[12500000,15900000,"p36.21","gpos50"],[15900000,20100000,"p36.13","gneg"],[20100000,23600000,"p36.12","gpos25"],[23600000,27600000,"p36.11","gneg"],[27600000,29900000,"p35.3","gpos25"],[29900000,32300000,"p35.2","gneg"],[32300000,34300000,"p35.1","gpos25"],[34300000,39600000,"p34.3","gneg"],[39600000,43700000,"p34.2","gpos25"],[43700000,46300000,"p34.1","gneg"],[46300000,50200000,"p33","gpos75"],[50200000,55600000,"p32.3","gneg"],[55600000,58500000,"p32.2","gpos50"],[58500000,60800000,"p32.1","gneg"],[60800000,68500000,"p31.3","gpos50"],[68500000,69300000,"p31.2","gneg"],[69300000,84400000,"p31.1","gpos100"],[84400000,87900000,"p22.3","gneg"],[87900000,91500000,"p22.2","gpos75"],[91500000,94300000,"p22.1","gneg"],[94300000,99300000,"p21.3","gpos75"],[99300000,101800000,"p21.2","gneg"],[101800000,106700000,"p21.1","gpos100"],[106700000,111200000,"p13.3","gneg"],[111200000,115500000,"p13.2","gpos50"],[115500000,117200000,"p13.1","gneg"],[117200000,120400000,"p12","gpos50"],[120400000,121700000,"p11.2","gneg"],[121700000,123400000,"p11.1","acen"],[123400000,125100000,"q11","acen"],[125100000,143200000,"q12","gvar"],[143200000,147500000,"q21.1","gneg"],[147500000,150600000,"q21.2","gpos50"],[150600000,155100000,"q21.3","gneg"],[155100000,156600000,"q22","gpos50"],[156600000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,173000000,"q24.3","gpos75"],[173000000,176100000,"q25.1","gneg"],[176100000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207100000,"q32.1","gneg"],[207100000,211300000,"q32.2","gpos25"],[211300000,214400000,"q32.3","gneg"],[214400000,223900000,"q41","gpos100"],[223900000,224400000,"q42.11","gneg"],[224400000,226800000,"q42.12","gpos25"],[226800000,230500000,"q42.13","gneg"],[230500000,234600000,"q42.2","gpos50"],[234600000,236400000,"q42.3","gneg"],[236400000,243500000,"q43","gpos75"],[243500000,248956422,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,6900000,"p25.2","gpos50"],[6900000,12000000,"p25.1","gneg"],[12000000,16500000,"p24.3","gpos75"],[16500000,19000000,"p24.2","gneg"],[19000000,23800000,"p24.1","gpos75"],[23800000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31800000,"p23.1","gneg"],[31800000,36300000,"p22.3","gpos75"],[36300000,38300000,"p22.2","gneg"],[38300000,41500000,"p22.1","gpos50"],[41500000,47500000,"p21","gneg"],[47500000,52600000,"p16.3","gpos100"],[52600000,54700000,"p16.2","gneg"],[54700000,61000000,"p16.1","gpos100"],[61000000,63900000,"p15","gneg"],[63900000,68400000,"p14","gpos50"],[68400000,71300000,"p13.3","gneg"],[71300000,73300000,"p13.2","gpos50"],[73300000,74800000,"p13.1","gneg"],[74800000,83100000,"p12","gpos100"],[83100000,91800000,"p11.2","gneg"],[91800000,93900000,"p11.1","acen"],[93900000,96000000,"q11.1","acen"],[96000000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108700000,"q12.3","gpos25"],[108700000,112200000,"q13","gneg"],[112200000,118100000,"q14.1","gpos50"],[118100000,121600000,"q14.2","gneg"],[121600000,129100000,"q14.3","gpos50"],[129100000,131700000,"q21.1","gneg"],[131700000,134300000,"q21.2","gpos25"],[134300000,136100000,"q21.3","gneg"],[136100000,141500000,"q22.1","gpos100"],[141500000,143400000,"q22.2","gneg"],[143400000,147900000,"q22.3","gpos100"],[147900000,149000000,"q23.1","gneg"],[149000000,149600000,"q23.2","gpos25"],[149600000,154000000,"q23.3","gneg"],[154000000,158900000,"q24.1","gpos75"],[158900000,162900000,"q24.2","gneg"],[162900000,168900000,"q24.3","gpos75"],[168900000,177100000,"q31.1","gneg"],[177100000,179700000,"q31.2","gpos50"],[179700000,182100000,"q31.3","gneg"],[182100000,188500000,"q32.1","gpos75"],[188500000,191100000,"q32.2","gneg"],[191100000,196600000,"q32.3","gpos75"],[196600000,202500000,"q33.1","gneg"],[202500000,204100000,"q33.2","gpos50"],[204100000,208200000,"q33.3","gneg"],[208200000,214500000,"q34","gpos100"],[214500000,220700000,"q35","gneg"],[220700000,224300000,"q36.1","gpos75"],[224300000,225200000,"q36.2","gneg"],[225200000,230100000,"q36.3","gpos100"],[230100000,234700000,"q37.1","gneg"],[234700000,236400000,"q37.2","gpos50"],[236400000,242193529,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8100000,"p26.1","gpos50"],[8100000,11600000,"p25.3","gneg"],[11600000,13200000,"p25.2","gpos25"],[13200000,16300000,"p25.1","gneg"],[16300000,23800000,"p24.3","gpos100"],[23800000,26300000,"p24.2","gneg"],[26300000,30800000,"p24.1","gpos75"],[30800000,32000000,"p23","gneg"],[32000000,36400000,"p22.3","gpos50"],[36400000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63800000,"p14.2","gneg"],[63800000,69700000,"p14.1","gpos50"],[69700000,74100000,"p13","gneg"],[74100000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87100000,"p12.1","gpos75"],[87100000,87800000,"p11.2","gneg"],[87800000,90900000,"p11.1","acen"],[90900000,94000000,"q11.1","acen"],[94000000,98600000,"q11.2","gvar"],[98600000,100300000,"q12.1","gneg"],[100300000,101200000,"q12.2","gpos25"],[101200000,103100000,"q12.3","gneg"],[103100000,106500000,"q13.11","gpos75"],[106500000,108200000,"q13.12","gneg"],[108200000,111600000,"q13.13","gpos50"],[111600000,113700000,"q13.2","gneg"],[113700000,117600000,"q13.31","gpos75"],[117600000,119300000,"q13.32","gneg"],[119300000,122200000,"q13.33","gpos75"],[122200000,124100000,"q21.1","gneg"],[124100000,126100000,"q21.2","gpos25"],[126100000,129500000,"q21.3","gneg"],[129500000,134000000,"q22.1","gpos25"],[134000000,136000000,"q22.2","gneg"],[136000000,139000000,"q22.3","gpos25"],[139000000,143100000,"q23","gneg"],[143100000,149200000,"q24","gpos100"],[149200000,152300000,"q25.1","gneg"],[152300000,155300000,"q25.2","gpos50"],[155300000,157300000,"q25.31","gneg"],[157300000,159300000,"q25.32","gpos50"],[159300000,161000000,"q25.33","gneg"],[161000000,167900000,"q26.1","gpos100"],[167900000,171200000,"q26.2","gneg"],[171200000,176000000,"q26.31","gpos75"],[176000000,179300000,"q26.32","gneg"],[179300000,183000000,"q26.33","gpos75"],[183000000,184800000,"q27.1","gneg"],[184800000,186300000,"q27.2","gpos25"],[186300000,188200000,"q27.3","gneg"],[188200000,192600000,"q28","gpos75"],[192600000,198295559,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15000000,"p15.33","gpos50"],[15000000,17700000,"p15.32","gneg"],[17700000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50000000,"p11","acen"],[50000000,51800000,"q11","acen"],[51800000,58500000,"q12","gneg"],[58500000,65500000,"q13.1","gpos100"],[65500000,69400000,"q13.2","gneg"],[69400000,75300000,"q13.3","gpos75"],[75300000,78000000,"q21.1","gneg"],[78000000,81500000,"q21.21","gpos50"],[81500000,83200000,"q21.22","gneg"],[83200000,86000000,"q21.23","gpos25"],[86000000,87100000,"q21.3","gneg"],[87100000,92800000,"q22.1","gpos75"],[92800000,94200000,"q22.2","gneg"],[94200000,97900000,"q22.3","gpos75"],[97900000,100100000,"q23","gneg"],[100100000,106700000,"q24","gpos50"],[106700000,113200000,"q25","gneg"],[113200000,119900000,"q26","gpos75"],[119900000,122800000,"q27","gneg"],[122800000,127900000,"q28.1","gpos50"],[127900000,130100000,"q28.2","gneg"],[130100000,138500000,"q28.3","gpos100"],[138500000,140600000,"q31.1","gneg"],[140600000,145900000,"q31.21","gpos25"],[145900000,147500000,"q31.22","gneg"],[147500000,150200000,"q31.23","gpos25"],[150200000,154600000,"q31.3","gneg"],[154600000,160800000,"q32.1","gpos100"],[160800000,163600000,"q32.2","gneg"],[163600000,169200000,"q32.3","gpos100"],[169200000,171000000,"q33","gneg"],[171000000,175400000,"q34.1","gpos75"],[175400000,176600000,"q34.2","gneg"],[176600000,182300000,"q34.3","gpos100"],[182300000,186200000,"q35.1","gneg"],[186200000,190214555,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6300000,"p15.32","gpos25"],[6300000,9900000,"p15.31","gneg"],[9900000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48800000,"p11","acen"],[48800000,51400000,"q11.1","acen"],[51400000,59600000,"q11.2","gneg"],[59600000,63600000,"q12.1","gpos75"],[63600000,63900000,"q12.2","gneg"],[63900000,67400000,"q12.3","gpos75"],[67400000,69100000,"q13.1","gneg"],[69100000,74000000,"q13.2","gpos50"],[74000000,77600000,"q13.3","gneg"],[77600000,82100000,"q14.1","gpos50"],[82100000,83500000,"q14.2","gneg"],[83500000,93000000,"q14.3","gpos100"],[93000000,98900000,"q15","gneg"],[98900000,103400000,"q21.1","gpos100"],[103400000,105100000,"q21.2","gneg"],[105100000,110200000,"q21.3","gpos100"],[110200000,112200000,"q22.1","gneg"],[112200000,113800000,"q22.2","gpos50"],[113800000,115900000,"q22.3","gneg"],[115900000,122100000,"q23.1","gpos100"],[122100000,127900000,"q23.2","gneg"],[127900000,131200000,"q23.3","gpos100"],[131200000,136900000,"q31.1","gneg"],[136900000,140100000,"q31.2","gpos25"],[140100000,145100000,"q31.3","gneg"],[145100000,150400000,"q32","gpos75"],[150400000,153300000,"q33.1","gneg"],[153300000,156300000,"q33.2","gpos50"],[156300000,160500000,"q33.3","gneg"],[160500000,169000000,"q34","gpos100"],[169000000,173300000,"q35.1","gneg"],[173300000,177100000,"q35.2","gpos25"],[177100000,181538259,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27100000,"p22.2","gneg"],[27100000,30500000,"p22.1","gpos50"],[30500000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,53000000,"p12.2","gneg"],[53000000,57200000,"p12.1","gpos100"],[57200000,58500000,"p11.2","gneg"],[58500000,59800000,"p11.1","acen"],[59800000,62600000,"q11.1","acen"],[62600000,62700000,"q11.2","gneg"],[62700000,69200000,"q12","gpos100"],[69200000,75200000,"q13","gneg"],[75200000,83200000,"q14.1","gpos50"],[83200000,84200000,"q14.2","gneg"],[84200000,87300000,"q14.3","gpos50"],[87300000,92500000,"q15","gneg"],[92500000,98900000,"q16.1","gpos100"],[98900000,100000000,"q16.2","gneg"],[100000000,105000000,"q16.3","gpos100"],[105000000,114200000,"q21","gneg"],[114200000,117900000,"q22.1","gpos75"],[117900000,118100000,"q22.2","gneg"],[118100000,125800000,"q22.31","gpos100"],[125800000,126800000,"q22.32","gneg"],[126800000,130000000,"q22.33","gpos75"],[130000000,130900000,"q23.1","gneg"],[130900000,134700000,"q23.2","gpos50"],[134700000,138300000,"q23.3","gneg"],[138300000,142200000,"q24.1","gpos75"],[142200000,145100000,"q24.2","gneg"],[145100000,148500000,"q24.3","gpos75"],[148500000,152100000,"q25.1","gneg"],[152100000,155200000,"q25.2","gpos50"],[155200000,160600000,"q25.3","gneg"],[160600000,164100000,"q26","gpos50"],[164100000,170805979,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13700000,"p21.3","gpos100"],[13700000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,27900000,"p15.2","gpos50"],[27900000,28800000,"p15.1","gneg"],[28800000,34900000,"p14.3","gpos75"],[34900000,37100000,"p14.2","gneg"],[37100000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,53900000,"p12.1","gpos75"],[53900000,58100000,"p11.2","gneg"],[58100000,60100000,"p11.1","acen"],[60100000,62100000,"q11.1","acen"],[62100000,67500000,"q11.21","gneg"],[67500000,72700000,"q11.22","gpos50"],[72700000,77900000,"q11.23","gneg"],[77900000,86700000,"q21.11","gpos100"],[86700000,88500000,"q21.12","gneg"],[88500000,91500000,"q21.13","gpos75"],[91500000,93300000,"q21.2","gneg"],[93300000,98400000,"q21.3","gpos75"],[98400000,104200000,"q22.1","gneg"],[104200000,104900000,"q22.2","gpos50"],[104900000,107800000,"q22.3","gneg"],[107800000,115000000,"q31.1","gpos75"],[115000000,117700000,"q31.2","gneg"],[117700000,121400000,"q31.31","gpos75"],[121400000,124100000,"q31.32","gneg"],[124100000,127500000,"q31.33","gpos75"],[127500000,129600000,"q32.1","gneg"],[129600000,130800000,"q32.2","gpos25"],[130800000,132900000,"q32.3","gneg"],[132900000,138500000,"q33","gpos50"],[138500000,143400000,"q34","gneg"],[143400000,148200000,"q35","gpos75"],[148200000,152800000,"q36.1","gneg"],[152800000,155200000,"q36.2","gpos25"],[155200000,159345973,"q36.3","gneg"]],8:[[0,2300000,"p23.3","gneg"],[2300000,6300000,"p23.2","gpos75"],[6300000,12800000,"p23.1","gneg"],[12800000,19200000,"p22","gpos100"],[19200000,23500000,"p21.3","gneg"],[23500000,27500000,"p21.2","gpos50"],[27500000,29000000,"p21.1","gneg"],[29000000,36700000,"p12","gpos75"],[36700000,38500000,"p11.23","gneg"],[38500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,47200000,"q11.1","acen"],[47200000,51300000,"q11.21","gneg"],[51300000,51700000,"q11.22","gpos75"],[51700000,54600000,"q11.23","gneg"],[54600000,60600000,"q12.1","gpos50"],[60600000,61300000,"q12.2","gneg"],[61300000,65100000,"q12.3","gpos50"],[65100000,67100000,"q13.1","gneg"],[67100000,69600000,"q13.2","gpos50"],[69600000,72000000,"q13.3","gneg"],[72000000,74600000,"q21.11","gpos100"],[74600000,74700000,"q21.12","gneg"],[74700000,83500000,"q21.13","gpos75"],[83500000,85900000,"q21.2","gneg"],[85900000,92300000,"q21.3","gpos100"],[92300000,97900000,"q22.1","gneg"],[97900000,100500000,"q22.2","gpos25"],[100500000,105100000,"q22.3","gneg"],[105100000,109500000,"q23.1","gpos75"],[109500000,111100000,"q23.2","gneg"],[111100000,116700000,"q23.3","gpos100"],[116700000,118300000,"q24.11","gneg"],[118300000,121500000,"q24.12","gpos50"],[121500000,126300000,"q24.13","gneg"],[126300000,130400000,"q24.21","gpos50"],[130400000,135400000,"q24.22","gneg"],[135400000,138900000,"q24.23","gpos75"],[138900000,145138636,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,37900000,"p13.2","gpos25"],[37900000,39000000,"p13.1","gneg"],[39000000,40000000,"p12","gpos50"],[40000000,42200000,"p11.2","gneg"],[42200000,43000000,"p11.1","acen"],[43000000,45500000,"q11","acen"],[45500000,61500000,"q12","gvar"],[61500000,65000000,"q13","gneg"],[65000000,69300000,"q21.11","gpos25"],[69300000,71300000,"q21.12","gneg"],[71300000,76600000,"q21.13","gpos50"],[76600000,78500000,"q21.2","gneg"],[78500000,81500000,"q21.31","gpos50"],[81500000,84300000,"q21.32","gneg"],[84300000,87800000,"q21.33","gpos50"],[87800000,89200000,"q22.1","gneg"],[89200000,91200000,"q22.2","gpos25"],[91200000,93900000,"q22.31","gneg"],[93900000,96500000,"q22.32","gpos25"],[96500000,99800000,"q22.33","gneg"],[99800000,105400000,"q31.1","gpos100"],[105400000,108500000,"q31.2","gneg"],[108500000,112100000,"q31.3","gpos25"],[112100000,114900000,"q32","gneg"],[114900000,119800000,"q33.1","gpos75"],[119800000,123100000,"q33.2","gneg"],[123100000,127500000,"q33.3","gpos25"],[127500000,130600000,"q34.11","gneg"],[130600000,131100000,"q34.12","gpos25"],[131100000,133100000,"q34.13","gneg"],[133100000,134500000,"q34.2","gpos25"],[134500000,138394717,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18300000,"p12.33","gpos75"],[18300000,18400000,"p12.32","gneg"],[18400000,22300000,"p12.31","gpos75"],[22300000,24300000,"p12.2","gneg"],[24300000,29300000,"p12.1","gpos50"],[29300000,31100000,"p11.23","gneg"],[31100000,34200000,"p11.22","gpos25"],[34200000,38000000,"p11.21","gneg"],[38000000,39800000,"p11.1","acen"],[39800000,41600000,"q11.1","acen"],[41600000,45500000,"q11.21","gneg"],[45500000,48600000,"q11.22","gpos25"],[48600000,51100000,"q11.23","gneg"],[51100000,59400000,"q21.1","gpos100"],[59400000,62800000,"q21.2","gneg"],[62800000,68800000,"q21.3","gpos100"],[68800000,73100000,"q22.1","gneg"],[73100000,75900000,"q22.2","gpos50"],[75900000,80300000,"q22.3","gneg"],[80300000,86100000,"q23.1","gpos100"],[86100000,87700000,"q23.2","gneg"],[87700000,91100000,"q23.31","gpos75"],[91100000,92300000,"q23.32","gneg"],[92300000,95300000,"q23.33","gpos50"],[95300000,97500000,"q24.1","gneg"],[97500000,100100000,"q24.2","gpos50"],[100100000,101200000,"q24.31","gneg"],[101200000,103100000,"q24.32","gpos25"],[103100000,104000000,"q24.33","gneg"],[104000000,110100000,"q25.1","gpos100"],[110100000,113100000,"q25.2","gneg"],[113100000,117300000,"q25.3","gpos75"],[117300000,119900000,"q26.11","gneg"],[119900000,121400000,"q26.12","gpos50"],[121400000,125700000,"q26.13","gneg"],[125700000,128800000,"q26.2","gpos50"],[128800000,133797422,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,11700000,"p15.4","gpos50"],[11700000,13800000,"p15.3","gneg"],[13800000,16900000,"p15.2","gpos50"],[16900000,22000000,"p15.1","gneg"],[22000000,26200000,"p14.3","gpos100"],[26200000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51000000,"p11.12","gpos75"],[51000000,53400000,"p11.11","acen"],[53400000,55800000,"q11","acen"],[55800000,60100000,"q12.1","gpos75"],[60100000,61900000,"q12.2","gneg"],[61900000,63600000,"q12.3","gpos25"],[63600000,66100000,"q13.1","gneg"],[66100000,68700000,"q13.2","gpos25"],[68700000,70500000,"q13.3","gneg"],[70500000,75500000,"q13.4","gpos50"],[75500000,77400000,"q13.5","gneg"],[77400000,85900000,"q14.1","gpos100"],[85900000,88600000,"q14.2","gneg"],[88600000,93000000,"q14.3","gpos100"],[93000000,97400000,"q21","gneg"],[97400000,102300000,"q22.1","gpos100"],[102300000,103000000,"q22.2","gneg"],[103000000,110600000,"q22.3","gpos100"],[110600000,112700000,"q23.1","gneg"],[112700000,114600000,"q23.2","gpos50"],[114600000,121300000,"q23.3","gneg"],[121300000,124000000,"q24.1","gpos50"],[124000000,127900000,"q24.2","gneg"],[127900000,130900000,"q24.3","gpos50"],[130900000,135086622,"q25","gneg"]],12:[[0,3200000,"p13.33","gneg"],[3200000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14600000,"p13.1","gneg"],[14600000,19800000,"p12.3","gpos100"],[19800000,21100000,"p12.2","gneg"],[21100000,26300000,"p12.1","gpos100"],[26300000,27600000,"p11.23","gneg"],[27600000,30500000,"p11.22","gpos50"],[30500000,33200000,"p11.21","gneg"],[33200000,35500000,"p11.1","acen"],[35500000,37800000,"q11","acen"],[37800000,46000000,"q12","gpos100"],[46000000,48700000,"q13.11","gneg"],[48700000,51100000,"q13.12","gpos25"],[51100000,54500000,"q13.13","gneg"],[54500000,56200000,"q13.2","gpos25"],[56200000,57700000,"q13.3","gneg"],[57700000,62700000,"q14.1","gpos75"],[62700000,64700000,"q14.2","gneg"],[64700000,67300000,"q14.3","gpos50"],[67300000,71100000,"q15","gneg"],[71100000,75300000,"q21.1","gpos75"],[75300000,79900000,"q21.2","gneg"],[79900000,86300000,"q21.31","gpos100"],[86300000,88600000,"q21.32","gneg"],[88600000,92200000,"q21.33","gpos100"],[92200000,95800000,"q22","gneg"],[95800000,101200000,"q23.1","gpos75"],[101200000,103500000,"q23.2","gneg"],[103500000,108600000,"q23.3","gpos50"],[108600000,111300000,"q24.11","gneg"],[111300000,111900000,"q24.12","gpos25"],[111900000,113900000,"q24.13","gneg"],[113900000,116400000,"q24.21","gpos50"],[116400000,117700000,"q24.22","gneg"],[117700000,120300000,"q24.23","gpos50"],[120300000,125400000,"q24.31","gneg"],[125400000,128700000,"q24.32","gpos50"],[128700000,133275309,"q24.33","gneg"]],13:[[0,4600000,"p13","gvar"],[4600000,10100000,"p12","stalk"],[10100000,16500000,"p11.2","gvar"],[16500000,17700000,"p11.1","acen"],[17700000,18900000,"q11","acen"],[18900000,22600000,"q12.11","gneg"],[22600000,24900000,"q12.12","gpos25"],[24900000,27200000,"q12.13","gneg"],[27200000,28300000,"q12.2","gpos25"],[28300000,31600000,"q12.3","gneg"],[31600000,33400000,"q13.1","gpos50"],[33400000,34900000,"q13.2","gneg"],[34900000,39500000,"q13.3","gpos75"],[39500000,44600000,"q14.11","gneg"],[44600000,45200000,"q14.12","gpos25"],[45200000,46700000,"q14.13","gneg"],[46700000,50300000,"q14.2","gpos50"],[50300000,54700000,"q14.3","gneg"],[54700000,59000000,"q21.1","gpos100"],[59000000,61800000,"q21.2","gneg"],[61800000,65200000,"q21.31","gpos75"],[65200000,68100000,"q21.32","gneg"],[68100000,72800000,"q21.33","gpos100"],[72800000,74900000,"q22.1","gneg"],[74900000,76700000,"q22.2","gpos50"],[76700000,78500000,"q22.3","gneg"],[78500000,87100000,"q31.1","gpos100"],[87100000,89400000,"q31.2","gneg"],[89400000,94400000,"q31.3","gpos100"],[94400000,97500000,"q32.1","gneg"],[97500000,98700000,"q32.2","gpos25"],[98700000,101100000,"q32.3","gneg"],[101100000,104200000,"q33.1","gpos100"],[104200000,106400000,"q33.2","gneg"],[106400000,109600000,"q33.3","gpos100"],[109600000,114364328,"q34","gneg"]],14:[[0,3600000,"p13","gvar"],[3600000,8000000,"p12","stalk"],[8000000,16100000,"p11.2","gvar"],[16100000,17200000,"p11.1","acen"],[17200000,18200000,"q11.1","acen"],[18200000,24100000,"q11.2","gneg"],[24100000,32900000,"q12","gpos100"],[32900000,34800000,"q13.1","gneg"],[34800000,36100000,"q13.2","gpos50"],[36100000,37400000,"q13.3","gneg"],[37400000,43000000,"q21.1","gpos100"],[43000000,46700000,"q21.2","gneg"],[46700000,50400000,"q21.3","gpos100"],[50400000,53600000,"q22.1","gneg"],[53600000,55000000,"q22.2","gpos25"],[55000000,57600000,"q22.3","gneg"],[57600000,61600000,"q23.1","gpos75"],[61600000,64300000,"q23.2","gneg"],[64300000,67400000,"q23.3","gpos50"],[67400000,69800000,"q24.1","gneg"],[69800000,73300000,"q24.2","gpos50"],[73300000,78800000,"q24.3","gneg"],[78800000,83100000,"q31.1","gpos100"],[83100000,84400000,"q31.2","gneg"],[84400000,89300000,"q31.3","gpos100"],[89300000,91400000,"q32.11","gneg"],[91400000,94200000,"q32.12","gpos25"],[94200000,95800000,"q32.13","gneg"],[95800000,100900000,"q32.2","gpos50"],[100900000,102700000,"q32.31","gneg"],[102700000,103500000,"q32.32","gpos50"],[103500000,107043718,"q32.33","gneg"]],15:[[0,4200000,"p13","gvar"],[4200000,9700000,"p12","stalk"],[9700000,17500000,"p11.2","gvar"],[17500000,19000000,"p11.1","acen"],[19000000,20500000,"q11.1","acen"],[20500000,25500000,"q11.2","gneg"],[25500000,27800000,"q12","gpos50"],[27800000,30000000,"q13.1","gneg"],[30000000,30900000,"q13.2","gpos50"],[30900000,33400000,"q13.3","gneg"],[33400000,39800000,"q14","gpos75"],[39800000,42500000,"q15.1","gneg"],[42500000,43300000,"q15.2","gpos25"],[43300000,44500000,"q15.3","gneg"],[44500000,49200000,"q21.1","gpos75"],[49200000,52600000,"q21.2","gneg"],[52600000,58800000,"q21.3","gpos75"],[58800000,59000000,"q22.1","gneg"],[59000000,63400000,"q22.2","gpos25"],[63400000,66900000,"q22.31","gneg"],[66900000,67000000,"q22.32","gpos25"],[67000000,67200000,"q22.33","gneg"],[67200000,72400000,"q23","gpos25"],[72400000,74900000,"q24.1","gneg"],[74900000,76300000,"q24.2","gpos25"],[76300000,78000000,"q24.3","gneg"],[78000000,81400000,"q25.1","gpos50"],[81400000,84700000,"q25.2","gneg"],[84700000,88500000,"q25.3","gpos50"],[88500000,93800000,"q26.1","gneg"],[93800000,98000000,"q26.2","gpos50"],[98000000,101991189,"q26.3","gneg"]],16:[[0,7800000,"p13.3","gneg"],[7800000,10400000,"p13.2","gpos50"],[10400000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28500000,"p12.1","gpos50"],[28500000,35300000,"p11.2","gneg"],[35300000,36800000,"p11.1","acen"],[36800000,38400000,"q11.1","acen"],[38400000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56000000,"q12.2","gpos50"],[56000000,57300000,"q13","gneg"],[57300000,66600000,"q21","gpos100"],[66600000,70800000,"q22.1","gneg"],[70800000,72800000,"q22.2","gpos50"],[72800000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81600000,"q23.2","gneg"],[81600000,84100000,"q23.3","gpos50"],[84100000,87000000,"q24.1","gneg"],[87000000,88700000,"q24.2","gpos25"],[88700000,90338345,"q24.3","gneg"]],17:[[0,3400000,"p13.3","gneg"],[3400000,6500000,"p13.2","gpos50"],[6500000,10800000,"p13.1","gneg"],[10800000,16100000,"p12","gpos75"],[16100000,22700000,"p11.2","gneg"],[22700000,25100000,"p11.1","acen"],[25100000,27400000,"q11.1","acen"],[27400000,33500000,"q11.2","gneg"],[33500000,39800000,"q12","gpos50"],[39800000,40200000,"q21.1","gneg"],[40200000,42800000,"q21.2","gpos25"],[42800000,46800000,"q21.31","gneg"],[46800000,49300000,"q21.32","gpos25"],[49300000,52100000,"q21.33","gneg"],[52100000,59500000,"q22","gpos75"],[59500000,60200000,"q23.1","gneg"],[60200000,63100000,"q23.2","gpos75"],[63100000,64600000,"q23.3","gneg"],[64600000,66200000,"q24.1","gpos50"],[66200000,69100000,"q24.2","gneg"],[69100000,72900000,"q24.3","gpos75"],[72900000,76800000,"q25.1","gneg"],[76800000,77200000,"q25.2","gpos25"],[77200000,83257441,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,18500000,"p11.1","acen"],[18500000,21500000,"q11.1","acen"],[21500000,27500000,"q11.2","gneg"],[27500000,35100000,"q12.1","gpos100"],[35100000,39500000,"q12.2","gneg"],[39500000,45900000,"q12.3","gpos75"],[45900000,50700000,"q21.1","gneg"],[50700000,56200000,"q21.2","gpos75"],[56200000,58600000,"q21.31","gneg"],[58600000,61300000,"q21.32","gpos50"],[61300000,63900000,"q21.33","gneg"],[63900000,69100000,"q22.1","gpos100"],[69100000,71000000,"q22.2","gneg"],[71000000,75400000,"q22.3","gpos25"],[75400000,80373285,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19900000,"p13.11","gneg"],[19900000,24200000,"p12","gvar"],[24200000,26200000,"p11","acen"],[26200000,28100000,"q11","acen"],[28100000,31900000,"q12","gvar"],[31900000,35100000,"q13.11","gneg"],[35100000,37800000,"q13.12","gpos25"],[37800000,38200000,"q13.13","gneg"],[38200000,42900000,"q13.2","gpos25"],[42900000,44700000,"q13.31","gneg"],[44700000,47500000,"q13.32","gpos25"],[47500000,50900000,"q13.33","gneg"],[50900000,53100000,"q13.41","gpos25"],[53100000,55800000,"q13.42","gneg"],[55800000,58617616,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12000000,"p12.2","gneg"],[12000000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,28100000,"p11.1","acen"],[28100000,30400000,"q11.1","acen"],[30400000,33500000,"q11.21","gneg"],[33500000,35800000,"q11.22","gpos25"],[35800000,39000000,"q11.23","gneg"],[39000000,43100000,"q12","gpos75"],[43100000,43500000,"q13.11","gneg"],[43500000,47800000,"q13.12","gpos25"],[47800000,51200000,"q13.13","gneg"],[51200000,56400000,"q13.2","gpos75"],[56400000,57800000,"q13.31","gneg"],[57800000,59700000,"q13.32","gpos50"],[59700000,64444167,"q13.33","gneg"]],21:[[0,3100000,"p13","gvar"],[3100000,7000000,"p12","stalk"],[7000000,10900000,"p11.2","gvar"],[10900000,12000000,"p11.1","acen"],[12000000,13000000,"q11.1","acen"],[13000000,15000000,"q11.2","gneg"],[15000000,22600000,"q21.1","gpos100"],[22600000,25500000,"q21.2","gneg"],[25500000,30200000,"q21.3","gpos75"],[30200000,34400000,"q22.11","gneg"],[34400000,36400000,"q22.12","gpos50"],[36400000,38300000,"q22.13","gneg"],[38300000,41200000,"q22.2","gpos50"],[41200000,46709983,"q22.3","gneg"]],22:[[0,4300000,"p13","gvar"],[4300000,9400000,"p12","stalk"],[9400000,13700000,"p11.2","gvar"],[13700000,15000000,"p11.1","acen"],[15000000,17400000,"q11.1","acen"],[17400000,21700000,"q11.21","gneg"],[21700000,23100000,"q11.22","gpos25"],[23100000,25500000,"q11.23","gneg"],[25500000,29200000,"q12.1","gpos50"],[29200000,31800000,"q12.2","gneg"],[31800000,37200000,"q12.3","gpos50"],[37200000,40600000,"q13.1","gneg"],[40600000,43800000,"q13.2","gpos50"],[43800000,48100000,"q13.31","gneg"],[48100000,49100000,"q13.32","gpos50"],[49100000,50818468,"q13.33","gneg"]],X:[[0,4400000,"p22.33","gneg"],[4400000,6100000,"p22.32","gpos50"],[6100000,9600000,"p22.31","gneg"],[9600000,17400000,"p22.2","gpos50"],[17400000,19200000,"p22.13","gneg"],[19200000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37800000,"p21.1","gpos100"],[37800000,42500000,"p11.4","gneg"],[42500000,47600000,"p11.3","gpos75"],[47600000,50100000,"p11.23","gneg"],[50100000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,61000000,"p11.1","acen"],[61000000,63800000,"q11.1","acen"],[63800000,65400000,"q11.2","gneg"],[65400000,68500000,"q12","gpos50"],[68500000,73000000,"q13.1","gneg"],[73000000,74700000,"q13.2","gpos50"],[74700000,76800000,"q13.3","gneg"],[76800000,85400000,"q21.1","gpos100"],[85400000,87000000,"q21.2","gneg"],[87000000,92700000,"q21.31","gpos100"],[92700000,94300000,"q21.32","gneg"],[94300000,99100000,"q21.33","gpos75"],[99100000,103300000,"q22.1","gneg"],[103300000,104500000,"q22.2","gpos50"],[104500000,109400000,"q22.3","gneg"],[109400000,117400000,"q23","gpos75"],[117400000,121800000,"q24","gneg"],[121800000,129500000,"q25","gpos100"],[129500000,131300000,"q26.1","gneg"],[131300000,134500000,"q26.2","gpos25"],[134500000,138900000,"q26.3","gneg"],[138900000,141200000,"q27.1","gpos75"],[141200000,143000000,"q27.2","gneg"],[143000000,148000000,"q27.3","gpos100"],[148000000,156040895,"q28","gneg"]],Y:[[0,300000,"p11.32","gneg"],[300000,600000,"p11.31","gpos50"],[600000,10300000,"p11.2","gneg"],[10300000,10400000,"p11.1","acen"],[10400000,10600000,"q11.1","acen"],[10600000,12400000,"q11.21","gneg"],[12400000,17100000,"q11.221","gpos50"],[17100000,19600000,"q11.222","gneg"],[19600000,23800000,"q11.223","gpos50"],[23800000,26600000,"q11.23","gneg"],[26600000,57227415,"q12","gvar"]]}}};CanvasXpress.graphTypes={Alluvial:["Alluvial","Sankey"],Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Bin:["Bin","Scatter2D"],Binplot:["Binplot","Scatter2D"],Bubble:["Bubble","Circular"],Bullet:["Bullet","Bar"],Bump:["Bump","Scatter2D"],CDF:["CDF","Scatter2D"],Chord:["Chord","Circular"],Circular:["Circular"],Cleveland:["Cleveland","Dotplot"],Contour:["Contour","Scatter2D"],Correlation:["Correlation"],Density:["Density"],Distribution:["Distribution","Scatter2D"],Donut:["Donut","Circular"],DotLine:["DotLine"],Dotplot:["Dotplot"],Dumbbell:["Dumbbell","Dotplot"],Fish:["Fish"],Gantt:["Gantt"],Genome:["Genome"],Heatmap:["Heatmap"],Hex:["Hex","Scatter2D"],Hexplot:["Hexplot","Scatter2D"],Histogram:["Histogram","Scatter2D"],KaplanMeier:["KaplanMeier","Scatter2D"],Line:["Line"],Lollipop:["Lollipop","Bar"],Map:["Map"],Meter:["Meter"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pareto:["Pareto","BarLine"],Pie:["Pie"],QQ:["QQ","Scatter2D"],Quantile:["Quantile","Scatter2D"],Radar:["Radar","Circular"],Ribbon:["Ribbon","Sankey"],Ridgeline:["Ridgeline","Scatter2D"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],Scatter3D:["Scatter3D"],ScatterBubble2D:["ScatterBubble2D"],Spaghetti:["Spaghetti","Scatter2D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],Streamgraph:["Streamgraph","Scatter2D"],Sunburst:["Sunburst","Circular"],TagCloud:["TagCloud"],TimeSeries:["TimeSeries","Scatter2D"],Tornado:["Tornado","Stacked"],Tree:["Tree"],Treemap:["Treemap"],Upset:["Upset","Heatmap"],Violin:["Violin","Boxplot"],Volcano:["Volcano","Scatter2D"],Venn:["Venn"],Waterfall:["Waterfall","Bar"],WordCloud:["WordCloud","TagCloud"],AllGraphs:["Alluvial","Area","AreaLine","Bar","BarLine","Boxplot","Bin","Binplot","Bubble","Bullet","Bump","CDF","Chord","Circular","Cleveland","Contour","Correlation","Density","Distribution","Donut","DotLine","Dotplot","Dumbbell","Fish","Gantt","Genome","Heatmap","Hex","Hexplot","Histogram","KaplanMeier","Line","Lollipop","Map","Meter","Network","ParallelCoordinates","Pareto","Pie","QQ","Quantile","Radar","Ribbon","Ridgeline","Sankey","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Stacked","StackedLine","StackedPercent","StackedPercentLine","Streamgraph","Sunburst","TagCloud","TimeSeries","Tornado","Tree","Treemap","Upset","Violin","Volcano","Venn","Waterfall","WordCloud"],AllGraphsCol:["Alluvial","Area","AreaLine","Bar","BarLine","Boxplot","Bullet","Bubble","Bump","CDF","Circular","Cleveland","Density","Distribution","DotLine","Dotplot","Dumbbell","Gantt","Histogram","KaplanMeier","Line","Lollipop","Map","Network","ParallelCoordinates","Pareto","QQ","Quantile","Radar","Ribbon","Ridgeline","Sankey","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Sunburst","TagCloud","TimeSeries","Tree","Treemap","Violin","Volcano","Waterfall","WordCloud"],AllGraphsNH:["AreaLine","Bar","BarLine","Boxplot","Bin","Binplot","Bubble","Bullet","Bump","CDF","Chord","Circular","Cleveland","Contour","Correlation","Density","Distribution","Donut","DotLine","Dotplot","Dumbbell","Fish","Gantt","Genome","Hex","Hexplot","Histogram","KaplanMeier","Line","Lollipop","Map","Meter","Network","ParallelCoordinates","Pareto","Pie","QQ","Quantile","Radar","Ridgeline","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Stacked","StackedLine","StackedPercent","StackedPercentLine","Streamgraph","Sunburst","TagCloud","Tornado","TimeSeries","Tree","Treemap","Violin","Volcano","Venn","Waterfall","WordCloud"],AllGraphsNL:["Area","AreaLine","Bar","BarLine","Boxplot","Bin","Binplot","Bubble","Bullet","Bump","CDF","Chord","Circular","Cleveland","Contour","Correlation","Density","Distribution","Donut","DotLine","Dotplot","Dumbbell","Fish","Gantt","Genome","Heatmap","Hex","Hexplot","Histogram","KaplanMeier","Line","Lollipop","Map","Meter","Network","ParallelCoordinates","Pareto","Pie","QQ","Quantile","Radar","Ridgeline","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Stacked","StackedLine","StackedPercent","StackedPercentLine","Streamgraph","Sunburst","TagCloud","Tornado","TimeSeries","Tree","Treemap","Upset","Violin","Volcano","Venn","Waterfall","WordCloud"],AllGraphsShpSiz:["Boxplot","Bump","Cleveland","DotLine","Dotplot","Dumbbell","Network","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","TimeSeries","Tree","Violin","Volcano"],AreaGraphs:["Area","AreaLine"],AttGraphs:["Bar","BarLine","Boxplot","Cleveland","DotLine","Dotplot","Dumbbell","Gantt","Heatmap","Line","Lollipop","ParallelCoordinates","Pareto","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tornado","Tree","Treemap","Upset","Violin","Venn","Waterfall","WordCloud"],BarGraphs:["Bar","BarLine","Bullet","Lollipop","Pareto","Waterfall"],BinHexPlots:["Bin","Binplot","Hex","Hexplot","Scatter2D"],ClusterGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Circular","Cleveland","Correlation","DotLine","Dotplot","Dumbbell","Heatmap","Line","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tornado","Tree","Treemap"],CombinationLineGraphs:["AreaLine","BarLine","DotLine","Pareto","StackedLine","StackedPercentLine"],ContourGraphs:["Pareto","Heatmap","Scatter2D"],DecorationGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Bin","Binplot","Bullet","CDF","Cleveland","Contour","Density","Distribution","DotLine","Dotplot","Dumbbell","Hex","Hexplot","Histogram","KaplanMeier","Line","Lollipop","Pareto","QQ","Quantile","Ridgeline","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Stacked","StackedLine","StackedPercent","StackedPercentLine","TimeSeries","Tornado","Violin","Volcano","Waterfall"],DensityGraphs:["Boxplot","Density","Distribution","Histogram","Ridgeline","Scatter2D","Violin"],DotGraphs:["Boxplot","Cleveland","DotLine","Dotplot","Dumbbell","Violin"],HierarchicalGraphs:["Bubble","Circular","Tree","Treemap"],IdeogramGraphs:["Circular","Genome"],LineGraphs:["Area","AreaLine","BarLine","DotLine","Line","ParallelCoordinates","Pareto","StackedLine","StackedPercentLine"],LinkGraphs:["Alluvial","Chord","Ribbon","Sankey"],NonSegregatable:["Alluvial","Bubble","Chord","Circular","Fish","Gantt","Genome","Map","Network","Radar","Ribbon","Sankey","Sunburst","TagCloud","Tree","Treemap","Venn","WordCloud"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Bullet","Cleveland","DotLine","Dotplot","Dumbbell","Gantt","Heatmap","Line","Lollipop","Meter","ParallelCoordinates","Pareto","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tornado","Tree","Treemap","Upset","Violin","Waterfall","WordCloud"],OneDGraphsGrp:["Bar","BarLine","Boxplot","Cleveland","DotLine","Dotplot","Dumbbell","Line","Pareto","Violin","Waterfall"],OneDGraphsNR:["Area","AreaLine","Bar","BarLine","Boxplot","Bullet","Cleveland","DotLine","Dotplot","Dumbbell","Line","Lollipop","ParallelCoordinates","Pareto","Waterfall"],OneTwoThreeeDGraphs:["Alluvial","Area","AreaLine","Bar","BarLine","Boxplot","Bin","Binplot","Bubble","Bullet","CDF","Chord","Circular","Cleveland","Contour","Correlation","Density","Distribution","Donut","DotLine","Dotplot","Dumbbell","Fish","Gantt","Heatmap","Hex","Hexplot","Histogram","KaplanMeier","Line","Lollipop","Meter","ParallelCoordinates","Pareto","Pie","QQ","Quantile","Radar","Ribbon","Ridgeline","Sankey","Scatter2D","Scatter3D","ScatterBubble2D","Spaghetti","Stacked","StackedLine","StackedPercent","StackedPercentLine","Streamgraph","Sunburst","TagCloud","Tornado","TimeSeries","Tree","Treemap","Upset","Violin","Volcano","Waterfall","WordCloud"],RangeGraphs:["Bar","Bullet","Meter"],OverlayGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Bullet","Cleveland","DotLine","Dotplot","Dumbbell","Heatmap","Line","Lollipop","Pareto","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tornado","Violin","Waterfall"],ScatterGraphs:["Bin","Binplot","Bump","CDF","Contour","Density","Distribution","Hex","Hexplot","Histogram","KaplanMeier","QQ","Quantile","Ridgeline","Scatter2D","ScatterBubble2D","Scatter3D","Spaghetti","Streamgraph","TimeSeries","Volcano"],ScatterGraphsND:["Bin","Binplot","Hex","Hexplot","Scatter2D","ScatterBubble2D","Scatter3D","Spaghetti","TimeSeries","Volcano"],Scatter2Graphs:["Bin","Binplot","Bump","CDF","Contour","Density","Distribution","Hex","Hexplot","Histogram","KaplanMeier","QQ","Quantile","Ridgeline","Scatter2D","ScatterBubble2D","Spaghetti","Streamgraph","TimeSeries","Volcano"],Scatter2GraphsPlus:["Bin","Binplot","Bump","CDF","Contour","Density","Distribution","Donut","Hex","Hexplot","Histogram","KaplanMeier","QQ","Quantile","Ridgeline","Scatter2D","ScatterBubble2D","Spaghetti","Streamgraph","TimeSeries","Volcano"],Scatter2Bump:["Bump","Scatter2D"],Scatter3DGraphs:["Bar","Network","Scatter3D"],Scatter3DGraphsNB:["Network","Scatter3D"],Scatter3DGraphsNN:["Bar","Scatter3D"],SortGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Bullet","Cleveland","DotLine","Dotplot","Dumbbell","Line","Lollipop","Pareto","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tornado","Violin","Waterfall"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine","Tornado"],SquareOneDGraphs:["Bar","BarLine","Boxplot","Bullet","Pareto","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tornado","Waterfall"],ThreeDGraphs:["ScatterBubble2D","Scatter3D"],TwoThreeeDGraphs:["Bin","Binplot","CDF","Contour","Density","Distribution","Hex","Hexplot","Histogram","KaplanMeier","QQ","Quantile","Ridgeline","Scatter2D","ScatterBubble2D","Scatter3D","Spaghetti","Streamgraph","TimeSeries","Volcano"]};CanvasXpress.datasets=false;CanvasXpress.Rdatasets=false;CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey10:"1a1a1a",grey1:"030303",grey11:"1c1c1c",grey12:"1f1f1f",grey13:"212121",grey14:"242424",grey15:"262626",grey16:"292929",grey17:"2b2b2b",grey18:"2e2e2e",grey19:"303030",grey20:"333333",grey2:"050505",grey21:"363636",grey22:"383838",grey23:"3b3b3b",grey24:"3d3d3d",grey25:"404040",grey26:"424242",grey27:"454545",grey28:"474747",grey29:"4a4a4a",grey30:"4d4d4d",grey3:"080808",grey31:"4f4f4f",grey32:"525252",grey33:"545454",grey34:"575757",grey35:"595959",grey36:"5c5c5c",grey37:"5e5e5e",grey38:"616161",grey39:"636363",grey40:"666666",grey4:"0a0a0a",grey41:"696969",grey42:"6b6b6b",grey43:"6e6e6e",grey44:"707070",grey45:"737373",grey46:"757575",grey47:"787878",grey48:"7a7a7a",grey49:"7d7d7d",grey50:"7f7f7f",grey5:"0d0d0d",grey51:"828282",grey52:"858585",grey53:"878787",grey54:"8a8a8a",grey55:"8c8c8c",grey56:"8f8f8f",grey57:"919191",grey58:"949494",grey59:"969696",grey60:"999999",grey6:"0f0f0f",grey61:"9c9c9c",grey62:"9e9e9e",grey63:"a1a1a1",grey64:"a3a3a3",grey65:"a6a6a6",grey66:"a8a8a8",grey67:"ababab",grey68:"adadad",grey69:"b0b0b0",grey70:"b3b3b3",grey7:"121212",grey71:"b5b5b5",grey72:"b8b8b8",grey73:"bababa",grey74:"bdbdbd",grey75:"bfbfbf",grey76:"c2c2c2",grey77:"c4c4c4",grey78:"c7c7c7",grey79:"c9c9c9",grey:"808080",grey80:"cccccc",grey8:"141414",grey81:"cfcfcf",grey82:"d1d1d1",grey83:"d4d4d4",grey84:"d6d6d6",grey85:"d9d9d9",grey86:"dbdbdb",grey87:"dedede",grey88:"e0e0e0",grey89:"e3e3e3",grey90:"e5e5e5",grey9:"171717",grey91:"e8e8e8",grey92:"ebebeb",grey93:"ededed",grey94:"f0f0f0",grey95:"f2f2f2",grey97:"f7f7f7",grey98:"fafafa",grey99:"fcfcfc",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.colorWords=["4627f67737371607","465647365647f62705028607162774","475707e6944627f67737371605d28536d2","271656c636","465677f6c6c6160247f6e6022756767657265644","4627f677373716070216028647967702e4f435a402371602566716370247f6e6e61634","d65647379737","27567676572656443796","373756270785371667e61634","4707972736e656","47079727365646","374627f67527f6c6f636","5346d6","47c61637","473756769646","465686361636","4627f67737371607021602864796770274653502371602566716370247f6e6e61634","74e405d6f62764164716445637271607","56c696644616f6c6","56671637","74653556671637","47e6962707","0742","850742","8642","6742","7742","27563777f6272456a796c616964796e696","4642","472756c616","56079747f647f62707","56c6f637e6f636","76f6c6","2756767657265646","5636e616d627f666275607","37569647275607f6270556e696665646","e6f696471636f6c6","56d616e64737f686","473656a626f4","57e656d647875647e6f636","57e656d647875647e6f636e6f6","07f64737","0476e696274735f647","27f6272754","4787564577162746","27f6c6f63447e6f666","5646f6e43796","373756c6461656843796","47361656253796","46562756473796765627"];CanvasXpress.salt="7A64D88308227186991C253EA";CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themeParams={backgroundType:true,citationAlign:true,citationColor:true,citationFontStyle:true,citationScaleFontFactor:true,colorScheme:true,fitLineColor:true,guidesShow:true,guidesColor:true,layoutSpacing:true,legendBackgroundBorderColor:true,legendBackgroundColor:true,legendColumns:true,legendHorizontalJustification:true,legendInside:true,legendKeyBackgroundBorderColor:true,legendKeyBackgroundColor:true,legendPosition:true,legendTextColor:true,legendTextFontStyle:true,legendTextScaleFontFactor:true,legendTitleColor:true,legendTitleFontStyle:true,legendTitleScaleFontFactor:true,lineDecoration:true,mapOutlineColor:true,objectBorderColor:true,panelBackgroundBorderColor:true,panelBackgroundColor:true,plotBackgroundBorderColor:true,plotBackgroundColor:true,showLegend:true,showLegendTitle:true,smpTextRotate:true,stripBackgroundBorderColor:true,stripBackgroundColor:true,stripTextColor:true,stripTextFontStyle:true,stripTextScaleFontFactor:true,subtitleAlign:true,subtitleColor:true,subtitleFontStyle:true,subtitleScaleFontFactor:true,titleAlign:true,titleColor:true,titleFontStyle:true,titleScaleFontFactor:true,varTextRotate:true,rAxisGridMajorColor:true,rAxisGridMajorLineType:true,rAxisGridMajorShow:true,rAxisGridMajorWidth:true,rAxisGridMinorColor:true,rAxisGridMinorLineType:true,rAxisGridMinorShow:true,rAxisGridMinorWidth:true,rAxisLineBottomColor:true,rAxisLineBottomLineType:true,rAxisLineBottomShow:true,rAxisLineBottomWidth:true,rAxisLineTopColor:true,rAxisLineTopLineType:true,rAxisLineTopShow:true,rAxisLineTopWidth:true,rAxisTextColor:true,rAxisTextFontStyle:true,rAxisTextScaleFontFactor:true,rAxisTicksColor:true,rAxisTicksLength:true,rAxisTicksShow:true,rAxisTitleColor:true,rAxisTitleFontStyle:true,rAxisTitleScaleFontFactor:true,xAxisGridMajorColor:true,xAxisGridMajorLineType:true,xAxisGridMajorShow:true,xAxisGridMajorWidth:true,xAxisGridMinorColor:true,xAxisGridMinorLineType:true,xAxisGridMinorShow:true,xAxisGridMinorWidth:true,xAxisLineBottomColor:true,xAxisLineBottomLineType:true,xAxisLineBottomShow:true,xAxisLineBottomWidth:true,xAxisLineTopColor:true,xAxisLineTopLineType:true,xAxisLineTopShow:true,xAxisLineTopWidth:true,xAxisTextColor:true,xAxisTextFontStyle:true,xAxisTextScaleFontFactor:true,xAxisTicksColor:true,xAxisTicksLength:true,xAxisTicksShow:true,xAxisTitleColor:true,xAxisTitleFontStyle:true,xAxisTitleScaleFontFactor:true,widthFactor:true,yAxisGridMajorColor:true,yAxisGridMajorLineType:true,yAxisGridMajorShow:true,yAxisGridMajorWidth:true,yAxisGridMinorColor:true,yAxisGridMinorLineType:true,yAxisGridMinorShow:true,yAxisGridMinorWidth:true,yAxisLineLeftColor:true,yAxisLineLeftLineType:true,yAxisLineLeftShow:true,yAxisLineLeftWidth:true,yAxisLineRightColor:true,yAxisLineRightLineType:true,yAxisLineRightShow:true,yAxisLineRightWidth:true,yAxisTextColor:true,yAxisTextFontStyle:true,yAxisTextScaleFontFactor:true,yAxisTicksColor:true,yAxisTicksLength:true,yAxisTicksShow:true,yAxisTitleColor:true,yAxisTitleFontStyle:true,yAxisTitleScaleFontFactor:true,zAxisGridMajorColor:true,zAxisGridMajorLineType:true,zAxisGridMajorShow:true,zAxisGridMajorWidth:true,zAxisGridMinorColor:true,zAxisGridMinorLineType:true,zAxisGridMinorShow:true,zAxisGridMinorWidth:true,zAxisLineBottomColor:true,zAxisLineBottomLineType:true,zAxisLineBottomShow:true,zAxisLineBottomWidth:true,zAxisLineTopColor:true,zAxisLineTopLineType:true,zAxisLineTopShow:true,zAxisLineTopWidth:true,zAxisTextColor:true,zAxisTextFontStyle:true,zAxisTextScaleFontFactor:true,zAxisTicksColor:true,zAxisTicksLength:true,zAxisTicksShow:true,zAxisTitleColor:true,zAxisTitleFontStyle:true,zAxisTitleScaleFontFactor:true};CanvasXpress.setThemeDefinitions=function(){CanvasXpress.themes=[["bw","classic","cx","cxdark","dark","economist","excel","ggblanket","grey","highcharts","light","linedraw","minimal","ptol","solarized","stata","tableau","void0","wsj"],["axis.line","element_blank",,,,"element_blank",,"element_blank",,"element_blank",,"element_blank","element_blank","element_blank","element_blank",,,"element_blank",],["axis.line.arrow",,false,,,,false,,,,,,,,,false,false,,,false],["axis.line.colour",,"#000000",,,,,,,,"#999999",,,,,"#93a1a1",,,],["axis.line.linetype",,,,,,,,,,,,,,,1,,,],["axis.line.linewidth",,1,,,,0.8,,,,1,,,,,,,,],["axis.line.y",,,,,,"element_blank",,,,,,,,,,,,,"element_blank"],["axis.line.y.left",,,"element_blank","element_blank",,,,"element_blank",,,,,,,,,,],["axis.line.y.right",,,"element_blank","element_blank",,,,"element_blank",,,,,,,,,,],["axis.minor.ticks.length",0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0.75,0,0.75],["axis.minor.ticks.y.left",,,,,,,,"element_blank",,,,,,,,,,],["axis.minor.ticks.y.right",,,,,,,,"element_blank",,,,,,,,,,],["axis.text",,,,,,,,,,,,,,,,,,"element_blank"],["axis.text.colour","#4d4d4d","#4d4d4d",,,"#4d4d4d",,"#4d4d4d",,"#4d4d4d","#4d4d4d","#4d4d4d","#000000","#4d4d4d","#4d4d4d","#4d4d4d",,"#4d4d4d",],["axis.text.face",,,,,,,,,,,,,,,,,,,"bold"],["axis.text.r.hjust",0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,,0.5],["axis.text.r.margin",2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.2,2.4,2.4,2.2,,2.4],["axis.text.size",12,12,,,12,11,12,,12,12,12,12,12,12,12,12,12,,12],["axis.text.x.colour",,,,,,,,,,,,,,,,"#000000",,],["axis.text.x.margin",2.2,2.2,11,11,2.2,10,2.2,11,2.2,2.2,2.2,2.2,2.2,2.2,2.4,2.4,2.2,,2.4],["axis.text.x.top.margin",2.2,2.2,3.3,3.3,2.2,10,2.2,3.3,2.2,2.2,2.2,2.2,2.2,2.2,2.4,2.4,2.2,,2.4],["axis.text.x.top.vjust",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,,0],["axis.text.x.vjust",1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,,1],["axis.text.y.angle",,,,,,,,,,,,,,,,90,,],["axis.text.y.colour",,,,,,,,,,,,,,,,"#000000",,],["axis.text.y.hjust",1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,,1],["axis.text.y.margin",2.2,2.2,2.75,2.75,2.2,10,2.2,2.75,2.2,2.2,2.2,2.2,2.2,2.2,2.4,2.4,2.2,,2.4],["axis.text.y.right.hjust",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,,0],["axis.text.y.right.margin",2.2,2.2,2.75,2.75,2.2,2.2,2.2,2.75,2.2,2.2,2.2,2.2,2.2,2.2,2.4,2.4,2.2,,2.4],["axis.text.y.vjust",,,,,,,,,,,,,,,,0.5,,],["axis.ticks",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["axis.ticks.arrow",false,false,,,false,false,false,,false,,false,false,,,false,false,false,,false],["axis.ticks.colour","#333333","#333333",,,"#333333",,"#333333",,"#333333",,"#b3b3b3","#000000",,,"#93a1a1",,"#333333",],["axis.ticks.length",2.75,2.75,2.75,2.75,2.75,-5,2.75,2.75,2.75,2.75,2.75,2.75,2.75,2.75,3,2.75,2.75,0,3],["axis.ticks.length.x",,,3.66,3.66,,,,3.66,,,,,,,,,,],["axis.ticks.length.y",,,2.75,2.75,,,,2.75,,,,,,,,,,],["axis.ticks.linewidth",,,,,0.5,,,,,,0.5,0.5,,,,,,],["axis.ticks.x.arrow",,,,,,,,,,,,,,,,false,,,false],["axis.ticks.x.colour",,,,,,,,,,,,,,,,"#000000",,],["axis.ticks.y",,,,,,"element_blank",,,,,,,,,,,,,"element_blank"],["axis.ticks.y.arrow",,,,,,,,,,,,,,,,false,,],["axis.ticks.y.colour",,,,,,,,,,,,,,,,"#000000",,],["axis.ticks.y.left",,,"element_blank","element_blank",,,,"element_blank",,,,,,,,,,],["axis.ticks.y.right",,,"element_blank","element_blank",,,,"element_blank",,,,,,,,,,],["axis.title",,,,,,,,,,,,,,,,,,"element_blank","element_blank"],["axis.title.colour",,,,,,,,,,,,,,,,"#000000",,],["axis.title.size",,,,,,12,,,,,,,,,,12,,],["axis.title.x.margin",2.75,2.75,8.25,8.25,2.75,,2.75,8.25,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,,3],["axis.title.x.top.margin",2.75,2.75,11,11,2.75,2.75,2.75,11,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,,3],["axis.title.x.top.vjust",0,0,,,0,0,0,,0,0,0,0,0,0,0,0,0,,0],["axis.title.x.vjust",1,1,,,1,,1,,1,1,1,1,1,1,1,1,1,,1],["axis.title.y.angle",90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,,90],["axis.title.y.margin",2.75,2.75,11,11,2.75,,2.75,11,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,,3],["axis.title.y.right.angle",-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,,-90],["axis.title.y.right.margin",2.75,2.75,11,11,2.75,2.75,2.75,11,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,,3],["axis.title.y.right.vjust",1,1,,,1,1,1,,1,5.5,1,1,5.5,5.5,1,1,1,,1],["axis.title.y.vjust",1,1,,,1,,1,,1,1,1,1,1,1,1,0,1,,1],["legend.background",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["legend.background.colour",null,null,null,null,null,,"#000000",null,null,,null,null,,,null,"#000000",null,,null],["legend.background.linetype",,,,,,0,1,,,,,,,,,1,,],["legend.background.linewidth",5.5,5.5,0,0,5.5,null,null,0,5.5,,5.5,5.5,,,null,null,5.5,,6],["legend.box",,,,,,,,,,,,,,,,"vertical",,,"vertical"],["legend.box.background","element_blank","element_blank",,,"element_blank","element_blank","element_blank",,"element_blank","element_blank","element_blank","element_blank","element_blank","element_blank","element_blank","element_blank","element_blank",,"element_blank"],["legend.box.margin",null,null,0,0,null,null,null,0,null,null,null,null,null,null,null,null,null,,null],["legend.box.spacing",11,11,,,11,11,11,,11,11,11,11,11,11,12,12,11,,12],["legend.byrow",,,false,false,,,,false,,,,,,,,,,],["legend.direction",,,"vertical","vertical",,,,"vertical",,,,,,,,,,,"horizontal"],["legend.justification","center","center","center","center","center","center","center",[0,1],"center","center","center","center","center","center","center","center","center",,"center"],["legend.key",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["legend.key.colour",,,"#FFFFFF","#000000",,,null,"#FFFFFF",,,,,,,,null,,],["legend.key.fill",,,"#FFFFFF","#000000",,,,"#FFFFFF",,,,,,,,"#ffffff",,],["legend.key.linetype",,,,,,0,,,,,,,,,0,0,,],["legend.key.linewidth",,,8.25,8.25,,5.5,5.5,8.25,,,,,,,6,6,,],["legend.key.size",12,12,19.25,19.25,12,12,12,19.25,12,12,12,12,12,12,12,12,12,12,12],["legend.key.spacing",5.5,5.5,,,5.5,5.5,5.5,,5.5,5.5,5.5,5.5,5.5,5.5,6,6,5.5,5.5,6],["legend.key.spacing.x",,,3.6,3.6,,,,3.6,,,,,,,,,,],["legend.key.spacing.y",,,3.6,3.6,,,,3.6,,,,,,,,,,],["legend.location",,,"panel","panel",,,,"panel",,,,,,,,,,],["legend.margin",5.5,5.5,8.25,8.25,5.5,5.5,5.5,8.25,5.5,5.5,5.5,5.5,5.5,5.5,6,6,5.5,,6],["legend.position","right","right","right","right","right","top","right","right","right","right","right","right","right","right","right","bottom","right","right","top"],["legend.spacing",11,11,11,11,11,15,11,11,11,11,11,11,11,11,12,0.25,11,,12],["legend.text.margin",,,5.5,5.5,,,,5.5,,,,,,,,,,],["legend.text.size",12,12,,,12,16,12,,12,12,12,12,12,12,12,12,12,12,12],["legend.ticks.length",0.2,0.2,3.4,3.4,0.2,0.2,0.2,3.4,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.2],["legend.title.hjust",0,0,,,0,0,0,,0,0,0,0,0,0,0,0.5,0,0,0],["legend.title.margin",,,5.5,5.5,,,,5.5,,,,,,,,,,],["legend.title.position",,,"top","top",,,,"top",,,,,,,,,,],["legend.title.size",,,,,,12,,,,,,,,,,14,,],["line",,,,,,,,,,,,,,,,,,"element_blank"],["line.arrow",false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,,false],["line.colour","#000000","#000000","#121B24","#FFFFFF","#000000","#000000","#000000","#121B24","#000000","#000000","#000000","#000000","#000000","#000000","#93a1a1","#000000","#000000",,"#000000"],["line.lineend","butt","butt","square","square","butt",,"butt","square","butt","butt","butt","butt","butt","butt","butt","butt","butt",,"butt"],["line.linetype",1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,,1],["line.linewidth",0.5,0.5,0.33,0.33,0.5,,0.5,0.33,0.5,0.5,0.5,0.5,0.5,0.5,0.55,0.5,0.5,,0.55],["panel.background",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["panel.background.colour",null,null,"#FFFFFF","#000000",null,,null,"#FFFFFF",null,,null,null,,,"#93a1a1",null,null,],["panel.background.fill","#ffffff","#ffffff","#FFFFFF","#000000","#7f7f7f",,"#C0C0C0","#FFFFFF","#ebebeb",,"#ffffff","#ffffff",,,"#fdf6e3","#ffffff","#ebebeb",],["panel.background.linetype",,,,,,0,,,,,,,,,,1,,],["panel.border",,"element_blank","element_blank","element_blank","element_blank","element_blank",,"element_blank","element_blank","element_blank",,,"element_blank","element_blank","element_blank","element_blank","element_blank",],["panel.border.colour","#333333",,,,,,"#000000",,,,"#b3b3b3","#000000",,,,,,],["panel.border.fill",null,,,,,,null,,,,null,null,,,,,,,null],["panel.border.linetype",,,,,,,1,,,,,,,,,,,],["panel.border.linewidth",,,,,,,,,,,1,1,,,,,,],["panel.grid.arrow",false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,,false],["panel.grid.colour","#ebebeb","#ebebeb","#F6F8FA","#F6F8FA","#6b6b6b","#ffffff","#ebebeb","#F6F8FA","#ffffff","#ebebeb","#dedede","#000000","#ebebeb","#ebebeb","#eee8d5",,"#ffffff",],["panel.grid.linetype",,,,,,,,,,,,,,,,,,,3],["panel.grid.linewidth",,,1,1,,,,4,,,,,,,,,,],["panel.grid.major",,"element_blank",,,,,,,,,,,,,,,,],["panel.grid.major.arrow",,,,,false,false,false,,,,false,false,,,false,false,,,false],["panel.grid.major.colour",,,,,,"#ffffff","#000000",,,,,,,,"#eee8d5","#eaf2f3",,,"#000000"],["panel.grid.major.linewidth",,,,,0.5,1.75,,,,,0.5,0.1,,,,,,],["panel.grid.major.x",,,,,,"element_blank","element_blank","element_blank",,,,,,,,"element_blank",,,"element_blank"],["panel.grid.minor",,"element_blank","element_blank","element_blank",,"element_blank","element_blank","element_blank",,,,,,,,"element_blank",,,"element_blank"],["panel.grid.minor.arrow",false,,,,false,,,,false,false,false,false,false,false,false,,false,],["panel.grid.minor.colour",,,,,,,,,,,,,,,"#eee8d5",,,],["panel.grid.minor.linewidth",0.5,,,,0.25,,,,0.5,0.5,0.25,0.05,0.5,0.5,0.5,,0.5,],["panel.grid.minor.x",,,"element_blank","element_blank",,,,"element_blank",,,,,,,,,,],["panel.ontop",false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false],["panel.spacing",5.5,5.5,22,22,5.5,5.5,5.5,22,5.5,5.5,5.5,5.5,5.5,5.5,6,5.5,5.5,5.5,6],["plot.background",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["plot.background.colour","#ffffff","#ffffff",,"#000000","#ffffff",null,"#ffffff",,"#ffffff",,"#ffffff","#ffffff",,,null,null,"#ffffff",],["plot.background.fill",,,,"#000000",,"#d5e4eb",,,,,,,,,,"#eaf2f3",,],["plot.background.linetype",,,,,,,,,,,,,,,0,0,,],["plot.caption.colour",,,"#121B24","#FFFFFF",,,,"#121B24",,,,,,,,,,],["plot.caption.hjust",1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1],["plot.caption.margin",5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,5.5,6,6,5.5,5.5,6],["plot.caption.position","panel","panel","plot","plot","panel","panel","panel","plot","panel","panel","panel","panel","panel","panel","panel","panel","panel","panel","panel"],["plot.caption.size",12,12,10,10,12,12,12,10,12,12,12,12,12,12,12,10,12,12,12],["plot.caption.vjust",5.5,5.5,22,22,5.5,12,5.5,22,5.5,5.5,5.5,5.5,5.5,5.5,6,null,5.5,null,null],["plot.margin",5.5,5.5,22,22,5.5,12,5.5,22,5.5,5.5,5.5,5.5,5.5,5.5,6,null,5.5,null,null],["plot.subtitle.hjust",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5,0,0,0],["plot.subtitle.margin",5.5,5.5,22,22,5.5,5.5,5.5,22,5.5,5.5,5.5,5.5,5.5,5.5,6,6,5.5,5.5,6],["plot.subtitle.size",,,,,,,,,,,,,,,,12,,],["plot.subtitle.vjust",1,1,,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],["plot.tag.hjust",0.5,0.5,0,0,0.5,0.5,0.5,0,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5],["plot.tag.position","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft","topleft"],["plot.tag.size",14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14],["plot.tag.vjust",0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5],["plot.title.face",,,"bold","bold",,"bold",,"bold",,,,,,,,,,,"bold"],["plot.title.hjust",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5,0,0,0],["plot.title.margin",5.5,5.5,27.5,27.5,5.5,,5.5,27.5,5.5,5.5,5.5,5.5,5.5,5.5,6,6,5.5,5.5,6],["plot.title.position","panel","panel","plot","plot","panel","panel","panel","plot","panel","panel","plot","panel","panel","panel","panel","panel","panel","panel","panel"],["plot.title.size",12,12,14,14,12,20,12,14,12,12,12,12,12,12,12,12,12,12,12],["plot.title.vjust",1,1,,,1,,1,,1,1,1,1,1,1,1,1,1,1,1],["rect",,,,,,,,,,,,,,,,,,"element_blank"],["rect.colour","#000000","#000000","#FFFFFF","#FFFFFF","#000000",null,"#000000","#FFFFFF","#000000","#000000","#000000","#000000","#000000","#000000","#93a1a1","#000000","#000000",,null],["rect.fill","#ffffff","#ffffff","#FFFFFF","#FFFFFF","#ffffff",null,"#ffffff","#FFFFFF","#ffffff","#ffffff","#ffffff","#ffffff","#ffffff","#ffffff","#fdf6e3","#ffffff","#ffffff",,"#f8f2e4"],["rect.linetype",1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,0],["rect.linewidth",0.5,0.5,0.33,0.33,0.5,,0.5,0.33,0.5,0.5,0.5,0.5,0.5,0.5,0.55,0.5,0.5,,0.55],["strip.background",,,,,,,,,,"element_blank",,,"element_blank","element_blank",,,,],["strip.background.colour","#333333","#000000",null,null,null,null,null,null,null,,null,,,,"#333333",null,null,],["strip.background.fill","#d9d9d9","#ffffff",null,null,"#262626",null,"#ffffff",null,"#d9d9d9",,"#b3b3b3","#000000",,,"#d9d9d9","#d9e6eb","#d9d9d9",],["strip.background.linetype",,,,,,0,0,,,,,,,,,1,,],["strip.background.linewidth",,2,,,,,,,,,,,,,,,,],["strip.clip","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit","inherit"],["strip.placement","inside","inside","outside","outside","inside","inside","inside","outside","inside","inside","inside","inside","inside","inside","inside","inside","inside",,"inside"],["strip.switch.pad.grid",2.75,2.75,0.15,0.15,2.75,2.75,2.75,0.15,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,2.75,3],["strip.switch.pad.wrap",2.75,2.75,0.15,0.15,2.75,2.75,2.75,0.15,2.75,2.75,2.75,2.75,2.75,2.75,3,3,2.75,2.75,3],["strip.text.colour","#1a1a1a","#1a1a1a",,,"#e5e5e5",,"#1a1a1a",,"#1a1a1a","#1a1a1a","#ffffff","#ffffff","#1a1a1a","#1a1a1a","#1a1a1a",,"#1a1a1a",],["strip.text.margin",4.4,4.4,7.26,7.26,4.4,,4.4,7.26,4.4,4.4,4.4,4.4,4.4,4.4,4.8,4.8,4.4,,4.8],["strip.text.size",12,12,,,12,16,12,,12,12,12,12,12,12,12,12,12,12,12],["strip.text.x.bottom.margin",,,11,11,,,,11,,,,,,,,,,],["strip.text.x.vjust",,,,,,,,,,,,,,,,0.5,,],["strip.text.y.angle",-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,-90,,-90],["strip.text.y.left.angle",90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,,90],["strip.text.y.left.margin",,,7.3333,7.3333,,,,7.3333,,,,,,,,,,],["strip.text.y.margin",,,7.3333,7.3333,,,,7.3333,,,,,,,,,,],["text.angle",0,0,0,0,0,,0,0,0,0,0,0,0,0,0,0,0,0,0],["text.colour","#000000","#000000","#121B24","#FFFFFF","#000000","#000000","#000000","#121B24","#000000","#000000","#000000","#000000","#000000","#000000","#93a1a1","#000000","#000000","#000000","#000000"],["text.debug",false,false,false,false,false,,false,false,false,false,false,false,false,false,false,false,false,false,false],["text.face","plain","plain","plain","plain","plain",,"plain","plain","plain","plain","plain","plain","plain","plain","plain","plain","plain","plain","plain"],["text.family",,,,,,,,,,,,,,,,"sans",,,"sans"],["text.hjust",0.5,0.5,0.5,0.5,0.5,,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5],["text.lineheight",0.9,0.9,0.9,0.9,0.9,,0.9,0.9,0.9,0.9,0.9,0.9,0.9,0.9,0.9,1,0.9,0.9,0.9],["text.margin",0,0,0,0,0,,0,0,0,0,0,0,0,0,0,0,0,0,0],["text.size",12,12,12,12,12,,12,12,12,12,12,12,12,12,12,12,12,12,12],["text.vjust",0.5,0.5,0.5,0.5,0.5,,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,1,0.5,0.5,0.5],["title.colour",,,,,,,,,,,,,,,"#657b83","#1e2d53",,],["title.family",,,,,,,,,,,,,,,,,,,"mono"],["title.size",,,,,,,,,,,,,,,,,,,24]];CanvasXpress.themeDef={};var a=CanvasXpress.themes.shift();for(var d=0;d<a.length;d++){CanvasXpress.themeDef[a[d]]={}}for(var d=0;d<CanvasXpress.themes.length;d++){var b=CanvasXpress.themes[d];var e=b.shift();for(var c=0;c<b.length;c++){if(b[c]!==undefined){CanvasXpress.themeDef[a[c]][e]=b[c]}}}delete CanvasXpress.themes}();CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.factory=CanvasXpress.factory||{version:57.4,buildDate:"07-11-2025",client:"",siteSrc:false,valid:typeof window.cX=="string"?window.cX:undefined,href:window.location.href,llmService:typeof window.cXLLMService=="string"?window.cXLLMService:undefined};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.prototype.init=function(f,d,b,c,e,h,g,a){this.N5=function(j){try{CanvasXpress}catch(i){return false}CanvasXpress.instances.push(this);this.initStart();this.initData();this.initAesthetics();this.initScale();this.initGeometry();this.initStatistics();this.initFacets();this.initCoordinates();this.initTheme();this.initRender();this.initUI();this.initProcess(j)};if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.isGGPlot){return new cxplot(f)}else{this.N5(CanvasXpress.createObject(f,d,b,c,e,h,g,a))}}};CanvasXpress.prototype.initProcess=function(o){this.wu=function(o){this.target=o.target;this.events=o.events;this.info=o.info;this.userId=1;this.url={};this.meta={ids:{},time:{start:parseInt(performance.timeOrigin),current:0,end:null,elapsed:[]},data:false,canvas:{},config:{user:o.config,orig:{},vals:{},remote:false},ggplot:{aes:{},config:[],coords:[],data:[],facet:[],geoms:[],labels:{},layers:{},order:{},scales:[],theme:[],map:{}},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},console:[],events:{},stack:[],def:{},dom:{},layout:{}};this.config={};this.legend={color:{},shape:{},size:{},sample:{},variable:{},line:{},pattern:{},outline:{},connect:{},contour:{},bin2d:{},decoration:{},oncoprint:{},overlays:{},colorNode:{},shapeNode:{},sizeNode:{},patternNode:{},colorEdge:{},sizeEdge:{},colorLabel:{},sizeLabel:{}};this.scales={};this.panel={};this.plot={}};this.GW=function(t){var c=this.meta.time.current||performance.now();if(!t){t=""}var n=performance.now();this.meta.time.elapsed.push([t,parseInt(n-c),parseInt(n)]);this.meta.time.current=n};this.gh=function(o){this.qS(o);this.eg(o);this.jk(o);this.sK(o);this.hu(o);this.Vs(o)};this.qS=function(o){if(typeof(o.data)=="function"){try{o.data=o.data.call(this)}catch(e){alert("Not a valid Data object:\n"+e)}}else{if(!o.noValidate){try{JSON.stringify(o.data)}catch(e){alert("Data object malformed:\n"+e)}}}};this.eg=function(o){if(o.config){if(typeof(o.config)=="function"){try{o.config=o.config.call(this)}catch(e){alert("Not a valid Data object:\n"+e)}}else{if(!o.noValidate){try{JSON.stringify(o.config)}catch(e){alert("Config object malformed:\n"+e)}}}}};this.jk=function(o){if(o.events){for(var t in o.events){var v=o.events[t];if(typeof v==="string"&&v.startsWith&&v.startsWith("/Function(")&&v.endsWith&&v.endsWith(")/")){v=v.substring(10,v.length-2).replace(/&quot;/g,'"');v=eval("("+v+")");o.events[t]=v}}}};this.sK=function(o){if(!o.info){o.info=""}};this.hu=function(o){if(o.afterRender){try{JSON.stringify(o.afterRender)}catch(e){alert("AfterRender object malformed:\n"+e)}}};this.Vs=function(o){var p=false;if(o.config&&o.config.xAxis&&o.config.yAxis){if((o.config.xAxis[0]=="vars"||o.config.xAxis[0]=="smps")&&o.config.yAxis[0]=="y"){this.IB(o)}}else{if(o.data&&Array.isArray(o.data)&&o.data[0]&&((o.data[0].x&&o.data[0].y)||o.data[0].values)){if(o.data[0].type||o.data[0].mode){this.rb(o)}}}};this.lA=function(c){if(!c){c=this}if(c.transposeData){return true}if(c.transformData){}if(c.asSampleFactors&&c.asSampleFactors.length){return true}if(c.asVariableFactors&&c.asVariableFactors.length){return true}if(c.stringSampleFactors&&c.stringSampleFactors.length){return true}if(c.stringVariableFactors&&c.stringVariableFactors.length){return true}if(c.stringNodeAttributes&&c.stringNodeAttributes.length){return true}if(c.stringEdgeAttributes&&c.stringEdgeAttributes.length){return true}if(c.showHistogram){return true}if(c.ridgeBy){return true}if(c.sortData&&c.sortData.length){return true}if(c.filterData&&c.filterData.length){return true}if(c.asDOE){}return false};this.AH=function(c){var afterRender=[];if(c.showHistogram||c.ridgeBy){if(c.showHistogram===true&&c.colorBy){afterRender.unshift(["createHistogram",[false,true],{}])}else{afterRender.unshift(["createHistogram",[c.ridgeBy||c.showHistogram||c.colorBy,true],{}])}}if(c.stringVariableFactors&&c.stringVariableFactors.length){for(var i=0;i<c.stringVariableFactors.length;i++){afterRender.unshift(["switchNumericToString",[c.stringVariableFactors[i]],{}])}}if(c.stringSampleFactors&&c.stringSampleFactors.length){for(var i=0;i<c.stringSampleFactors.length;i++){afterRender.unshift(["switchNumericToString",[c.stringSampleFactors[i],true],{}])}}if(c.stringNodeAttributes&&c.stringNodeAttributes.length){for(var i=0;i<c.stringNodeAttributes.length;i++){afterRender.unshift(["switchNumericToString",[c.stringNodeAttributes[i],false],{}])}}if(c.stringEdgeAttributes&&c.stringEdgeAttributes.length){for(var i=0;i<c.stringEdgeAttributes.length;i++){afterRender.unshift(["switchNumericToString",[c.stringEdgeAttributes[i],true],{}])}}if(c.asVariableFactors&&c.asVariableFactors.length){for(var i=0;i<c.asVariableFactors.length;i++){afterRender.unshift(["switchVarToAnnotation",[c.asVariableFactors[i]],{}])}}if(c.asSampleFactors&&c.asSampleFactors.length){for(var i=0;i<c.asSampleFactors.length;i++){afterRender.unshift(["switchSmpToAnnotation",[c.asSampleFactors[i]],{}])}}if(c.transposeData){afterRender.unshift(["transpose",[false,true],{}])}if(c.transformData){afterRender.unshift(["transform",[c.transformData,c.transformAxis,false,true],{}])}if(c.sortData&&c.sortData.length){for(var i=0;i<c.sortData.length;i++){afterRender.push(["modifySort",[c.sortData[i][0],c.sortData[i][1],c.sortData[i][2],false,i==c.sortData.length-1?true:false],{}])}}if(c.filterData&&c.filterData.length){for(var i=0;i<c.filterData.length;i++){afterRender.push(["modifyFilter",[c.filterData[i][0],c.filterData[i][1],c.filterData[i][2],c.filterData[i][3],i==c.filterData.length-1?true:false],{}])}}if(c.asDOE){afterRender.push(["createDOE",[],{}])}return afterRender};this.yh=function(){if(this.isCxplot&&this.meta.config.user.aes){var aes=this.meta.config.user.aes;if(aes.stringVariableFactors){this.stringVariableFactors=this.Ev(aes.stringVariableFactors)}if(aes.stringSampleFactors){this.stringSampleFactors=this.Ev(aes.stringSampleFactors)}if(aes.asVariableFactors){this.asVariableFactors=this.Ev(this.asVariableFactors)}if(aes.asSampleFactors){this.asSampleFactors=this.Ev(aes.asSampleFactors)}}};this.Hz=function(arr){var that=this;var getSelectedDataPoints=function(){if(that.selectedDataPoints.length){var draw=false;var x=that.xAxisIndices&&that.xAxisIndices.length?that.xAxisIndices[0]:0;var y=that.yAxisIndices&&that.yAxisIndices.length?that.yAxisIndices[0]:1;for(var i=0;i<that.selectedDataPoints.length;i++){var vi=that.as(that.selectedDataPoints[i]);if(vi>=0){that.gv([vi,x,y]);draw=true}}if(draw){if(that.isCxplot){that.aS({func:"afterRender"})}else{arr.unshift(["broadcastDraw",[{func:"afterRender"}],{},t,true])}}}};var isPWC=function(){for(var i=0;i<arr.length;i++){if(arr[i][0]=="geom_pwc"){return true}}return false};var isDecor=function(){for(var i=0;i<arr.length;i++){if(arr[i][0].match(/marker/i)){return true}}return false};this.afterRendering=true;if(!arr){arr=[]}var t=this.meta.time.start;var v=this.graphType=="Scatter2D"&&this.scatterType=="visium";this.yh();if(this.showHistogram||this.ridgeBy){if(this.showHistogram===true){arr.push(["createHistogram",[false],{},t,true])}else{arr.push(["createHistogram",[this.ridgeBy||this.showHistogram],{},t,true])}}if(this.stringVariableFactors.length){for(var i=0;i<this.stringVariableFactors.length;i++){arr.unshift(["switchNumericToString",[this.stringVariableFactors[i],false],{},t,true])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var i=0;i<this.stringSampleFactors.length;i++){arr.unshift(["switchNumericToString",[this.stringSampleFactors[i],true],{},t,true])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.stringNodeAttributes.length){for(var i=0;i<this.stringNodeAttributes.length;i++){arr.unshift(["switchNumericToString",[this.stringNodeAttributes[i],false],{},t,true])}this.stringNodeAttributes=[];this.layoutRestore=false}if(this.stringEdgeAttributes.length){for(var i=0;i<this.stringEdgeAttributes.length;i++){arr.unshift(["switchNumericToString",[this.stringEdgeAttributes[i],true],{},t,true])}this.stringEdgeAttributes=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var i=0;i<this.asVariableFactors.length;i++){arr.unshift(["switchVarToAnnotation",[this.asVariableFactors[i],false],{},t,true])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var i=0;i<this.asSampleFactors.length;i++){arr.unshift(["switchSmpToAnnotation",[this.asSampleFactors[i],false],{},t,true])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){arr.unshift(["transpose",[false,this.sortData.length||this.selectedDataPoints.length],{},t,true]);this.transposeData=false;delete (CanvasXpress.stack[this.target].config.transposeData)}if(this.pivotBy&&!this.isPivot){arr.push(["pivotX",[this.pivotBy],{},t,true])}if(this.sortData){for(var i=0;i<this.sortData.length;i++){arr.push(["modifySort",[this.sortData[i][0],this.sortData[i][1],this.sortData[i][2],false,i==this.sortData.length-1?false:true],{},t,true])}this.sortData=[];delete (CanvasXpress.stack[this.target].config.sortData)}if(this.filterData){for(var i=0;i<this.filterData.length;i++){arr.push(["modifyFilter",[this.filterData[i][0],this.filterData[i][1],this.filterData[i][2],this.filterData[i][3],i==this.filterData.length-1?false:true],{}])}this.filterData=[];delete (CanvasXpress.stack[this.target].config.filterData)}var n1=arr.length-1;var ld=false;var cv=false;var pw=isPWC();var dc=isDecor();for(var i=0;i<arr.length;i++){var ar=arr[i];var fn=ar.shift();if(fn){var pr=ar.length>0?ar.shift():[];var cn=ar.length>0?ar.shift():{};var tm=ar.length>0?ar.shift():t;var rp=ar.length>0?ar.shift():false;if(this.view=="table"&&fn=="setDimensions"){continue}if(fn=="setDimensions"){if(this.width==pr[0]&&this.height==pr[1]){continue}}if(fn=="clickView"){cv=true;continue}if(fn=="updateDataFilter"||fn=="resetDataFilter"){this.skipRender=true}var dr=arr[i+1]&&arr[i+1][0]&&arr[i+1][0].match(/drag/i)?true:false;this.skipRender=fn=="createDOE"||fn=="createHistogram"||fn=="modifyColorScheme"||fn.match(/segregate/)||dr?false:!this.showTransition&&i<n1?true:this.view=="table"?false:false;if(fn.match(/switch/)){this.skipRender=i<n1?true:false}if(fn.match(/updateConfig/)){this.skipRender=false}if(pw){if(fn.match(/geom_boxplot|geom_bar/)){this.skipRender=false}}if(this.graphType=="Sankey"&&i==0){this.skipRender=false}if(this.debug||dc){this.skipRender=false}for(var c in cn){this[c]=cn[c]}if(fn.match(/switch/)&&v&&i==n1){ld=true}if(this[fn]){this[fn].apply(this,pr)}if(fn.match(/switch|clickGraphMaxMin/)&&i==n1&&!ld){this.Oj()}if(fn=="moveCanvas"){CanvasXpress.stack[this.target].afterRender.push([fn,pr])}if(rp){var ii=CanvasXpress.stack[this.target].afterRender.length-1;CanvasXpress.stack[this.target].afterRender[ii][4]=true}if(ld){this.IW()}else{if(n1==i){this.Nl(false,true)}}}}if(this.asDOE&&this.CV()){this.SH(this.asDOE)}getSelectedDataPoints();this.dU("afterRender");this.afterRendering=false;this.stackInitial=arr.length};this.h3=function(){if(this.toDoPivot){this.Qs(this.toDoPivot);this.toDoPivot=false}else{if(this.prompt){this.eW()}}};this.T4=function(){if(window.location.search!=""){var p=location.search.substring(1).split("&");for(var i=0;i<p.length;i++){var v=p[i].split("=");if(!v[0]){continue}if(v[0].match(/^cX/)){this.url[v[0]]=v[1]||true}else{this.url[v[0]]=v[1]=="false"?false:v[1]=="true"?true:v[1]}}}};this.Ki=function(){var arr=CanvasXpress.alias.split("#");var t0=arr.pop().split("");var t1=arr.shift().split("");var t={};for(var i=0;i<t0.length;i++){t[t1[i]]=t0[i]}for(var i=0;i<arr.length;i++){var w=arr[i].split("");var n=w.length;var f="";for(var j=0;j<n-2;j++){f+=t[w[j]]}var g=w[n-2]+w[n-1];if(this[g]){this[f]=this[g]}}};this.iS=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var f=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var t=this;var c=function(blb,fn){t.Rh(blb,fn);setTimeout(function(){window.close()},4000)};t.print(false,f,c)}else{if(this.url.hasOwnProperty("cXprintBase64")||this.cacheBase64){this.cacheBase64=false;var c=function(){return};if(CanvasXpress.$(this.target)){this.print(false,false,c)}}}};this.fo=function(o,e){var t=this;var w=window;var q=t.$w;if(this.verbose){w[q(8)][q(31)][q(32)](o)}};this.dU=function(cllr,scope){var that=this;var runCallback=function(){var t=scope||that;if(t.graphType=="Map"&&t.mapId&&!window[t.mapId]){return}if(t.fonts&&t.fonts.length>0&&!CanvasXpress.readyFonts){CanvasXpress.readyFonts=true;return}t.fo("canvasXpress data ready - "+cllr);t.iS();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(cllr=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.isUpdateRemoteData){runCallback()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){runCallback()}}else{if(!this.isTransitionOn){runCallback()}}}}};this.A2=function(){CanvasXpress.stack[this.target].stateCX.push(this.lc())};this.setView=function(){if(this.view=="table"){this.view="canvas";this.iO()}else{if(this.view=="layout"){this.view="canvas";this.BK()}}};this.VL=function(f){var s=CanvasXpress.stack[this.target];var b=this.lA();this.pK(false,false,false,false,false,false,b);this.Hz(s.afterRenderInit);this.A2();CanvasXpress.current=this.target;this.setView();this.meta.time.end=parseInt(performance.now());this.h3();this.Gf();if(f){f.call(this)}};this.c9=function(f){if(!this.lazyLoad||(!this.loaded&&this.TT(this.meta.canvas.ctx.canvas))){this.VL(f)}};this.uY=function(o){var t=this;t.wu(o);t.GW("init");t.T4();t.gh(o);t.Qj();t.Ki();t.Ht();t.NW();t.e0(o.config);t.yI();t.ej();t.Uv();t.jY(o.data);t.GW("initData");t.DD();t.Os();t.jG();t.pl();t.P1(o.data,o.config,o.events,o.info,o.afterRender);t.AK();t.Ki();t.c9(o.callback)};this.uY(o)};CanvasXpress.prototype.initStart=function(){this.initIO();this.initCrypt();this.initDOM();this.initViewport();this.initConfig()};CanvasXpress.prototype.initDataset=function(){this.yi=function(){delete (this.meta.data);this.cN(false,false,false,true)};this.af=function(c){if(c){this.meta.data={tracks:[]}}for(var H=0;H<this.data.tracks.length;H++){var y=this.data.tracks[H];var p={};if(y.type=="dataframe"){for(var E in y.dataframe){var I=y.dataframe[E];if(this.Nv(I)){var s=this.aC(I);var a=this[this.axisAlgorithm](s[0],s[1],5,this.isGraphTime,this.axisWilkinsonLoose);var q=[];for(var B=0;B<a.length;B++){q.push(a[B].toString())}var f=this.tx(q);var J=this.r9(f,this.xAxisTextFont);var A=Math.min(s[0],a[0]);var G=Math.max(s[1],a[a.length-1]);var z=(y.height||this.featureTypeDefault)/((G-A)*1.05);var h=this.QK(y.colorSpectrum||this.colorSpectrum,A,G,y.colorSpectrumZeroValue||this.colorSpectrumZeroValue,y.colorSpectrumBreaks||this.colorSpectrumBreaks,true);p[E]={type:"Numeric",range:s,values:a,valuesStr:q,maxValueStrLen:J,min:A,max:G,units:z,brew:h}}else{var b={};for(var B=0;B<I.length;B++){b[I[B]]=true}var x=this.hj(b);var D={};var F=0;var K=0;var u="";for(var B=0;B<x.length;B++){D[x[B]]=B;var g=this.r9(x[B],this.xAxisTextFont);if(g>F){F=g;K=x[B].length;u=x[B]}}var e=[];for(var B=0;B<x.length;B++){if(y.meta&&y.meta.hasOwnProperty(E)&&y.meta[E].hasOwnProperty("color")&&y.meta[E].color.hasOwnProperty(x[B])){e.push(y.meta[E].color[x[B]])}else{e.push(this.colors[B%this.colors.length])}}var w=[];for(var B=0;B<x.length;B++){if(y.meta&&y.meta.hasOwnProperty(E)&&y.meta[E].hasOwnProperty("shape")&&y.meta[E].shape.hasOwnProperty(x[B])){w.push(y.meta[E].shape[x[B]])}else{w.push(this.shapes[B%this.shapes.length])}}p[E]={type:"String",levels:x,order:D,maxLevLen:F,maxLevChr:K,maxLevStr:u,colors:e,shapes:w,sizes:this.l0(x.length)}}}}else{if(y.type.match(/bar|heatmap/)){var I=y.data;var r=[];for(var C=0;C<I.length;C++){for(var B=0;B<I[C].data.length;B++){r.push(I[C].data[B])}}var s=this.aC(r);var a=this[this.axisAlgorithm](s[0],s[1],5,this.isGraphTime,this.axisWilkinsonLoose);var q=[];for(var C=0;C<a.length;C++){q.push(a[C].toString())}var f=this.tx(q);var J=this.r9(f,this.xAxisTextFont);var A=Math.min(s[0],a[0]);var G=Math.max(s[1],a[a.length-1]);var z=(y.height||this.featureTypeDefault)/((G-A)*1.05);var h=this.QK(y.colorSpectrum||this.colorSpectrum,A,G,y.colorSpectrumZeroValue||this.colorSpectrumZeroValue,y.colorSpectrumBreaks||this.colorSpectrumBreaks,true);p={range:s,values:a,valuesStr:q,maxValueStrLen:J,min:A,max:G,units:z,brew:h}}}this.meta.data.tracks.push(p)}};this.k8=function(q,N,L){var f=this;var P=this.meta.data;var y=this.data;var s=["nodes","edges"];var x=this.nodeFont;var D={x:true,y:true,z:true,width:true,height:true,eventless:true,color:true,hideLabel:true,imagePath:true,size:true,shape:true,endArrow:true,startArrow:true,elbows:true};var g=function(d){for(var a in d){if(d[a]["t"]=="Numeric"){var j=f.iH(d[a]["o"]);if(j.length==2&&(d[a]["o"].hasOwnProperty("true")&&d[a]["o"].hasOwnProperty("false"))){d[a]["t"]="String"}else{if(j.length==1&&(d[a]["o"].hasOwnProperty("true")||d[a]["o"].hasOwnProperty("false"))){d[a]["t"]="String"}else{if(j.length==1&&d[a]["o"].hasOwnProperty("")){d[a]["t"]="String"}}}}}return d};var K=function(a){var k={};for(var j=0;j<f.data[a].length;j++){var o=f.data[a][j];for(var d in o){if(D.hasOwnProperty(d)){continue}var l=o[d]===null?false:o[d];if(typeof(l)!="object"){if(k.hasOwnProperty(d)){if(!k[d]["o"].hasOwnProperty(l)){k[d]["o"][l]=true}if(isNaN(l)){k[d]["t"]="String"}}else{k[d]={o:{},t:isNaN(l)?"String":"Numeric"};k[d]["o"][l]=true}}else{if(!k.hasOwnProperty(d)){k[d]={o:{}}}k[d]["t"]="Object";for(var r in l){k[d]["o"][r]=true}}}}return g(k)};var e=function(d){var a=f.hj(b[d]["o"]);if(f.legendOrder&&f.legendOrder[d]){var l=f.Ev(f.legendOrder[d]);for(var j=0;j<a.length;j++){if(!l.includes(a[j])){l.push(a[j])}}return l}else{return a}};if(!q||q=="nodes"||q=="edges"){if(q&&L&&P[q][N]){delete (P[q][N])}for(var J=0;J<s.length;J++){var E=s[J];if(q){if(q!=E){continue}}if(y[E]){var b=K(E);for(var G in b){if(N){if(N!=G){continue}}var c={};c.len=this.r9(G,x);c.type=b[G]["t"];var I=0;var O=0;var A="";if((this.colorKey&&this.colorKey.hasOwnProperty(G))||(this.legendOrder&&this.legendOrder.hasOwnProperty(G))){c.type="String"}if(c.type=="String"||c.type=="Object"){var B=e(G);c.unique=this.ak(B);c.levels=B;c.order={};for(var H=0;H<B.length;H++){c.order[B[H]]=H;var h=this.r9(B[H],x);if(h>I){I=h;O=B[H].length;A=B[H]}}c.maxLevLen=I;c.maxLevChr=O;c.maxLevStr=A;c.colors=[];var p=0;for(var H=0;H<B.length;H++){c.colors.push(this.colors[p%this.colors.length]);p++}if(this.colorKey&&this.colorKey.hasOwnProperty(G)){for(var H in this.colorKey[G]){if(c.order.hasOwnProperty(H)){c.colors[c.order[H]]=this.colorKey[G][H]}}}c.shapes=[];var p=0;for(var H=0;H<B.length;H++){c.shapes.push(this.shapes[p%this.shapes.length]);p++}if(this.shapeKey&&this.shapeKey.hasOwnProperty(G)){for(var H in this.shapeKey[G]){if(c.order.hasOwnProperty(H)){c.shapes[c.order[H]]=this.shapeKey[G][H]}}}c.sizes=this.l0(B.length,E=="edges");if(this.sizeKey&&this.sizeKey.hasOwnProperty(G)){for(var H in this.sizeKey[G]){if(c.order.hasOwnProperty(H)){c.sizes[c.order[H]]=this.sizeKey[G][H]}}}c.patterns=[];var p=0;for(var H=0;H<B.length;H++){c.patterns.push(this.patterns[p%this.patterns.length]);p++}if(this.patternKey&&this.patternKey.hasOwnProperty(G)){for(var H in this.patternKey[G]){if(c.order.hasOwnProperty(H)){c.patterns[c.order[H]]=this.patternKey[G][H]}}}}else{c.unique=false;var B=this.hj(b[G]["o"]);var w=this.aC(B);c.rmin=w[0];c.rmax=w[1];c.n=B.length;var M=this.colorSpectrum;if(E=="edges"){c.colorBrew=this.QK(M,w[0],w[1])}else{c.colorBrew=this.QK(M,w[0],w[1],this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}c.min=c.colorBrew.min;c.max=c.colorBrew.max;c.zero=c.colorBrew.zero;c.vals=c.colorBrew.vals;c.incr=c.colorBrew.incr;c.decs=c.colorBrew.decs;c.levels=c.colorBrew.vals;c.order={};for(var H=0;H<c.levels.length;H++){c.order[c.levels[H]]=H;var h=this.r9(c.levels[H],x);if(h>I){I=h;O=c.levels[H].toString().length;A=c.levels[H]}c.maxLevLen=I;c.maxLevChr=O;c.maxLevStr=A}c.shapes=this.shapes;c.sizes=this.sizes;c.patterns=this.patterns}P[E][G]=c}}}}if(this.decorations.length&&this.decorationsType=="heatmap"){var u=[];P.decorations={};P.decorations.unique=false;P.decorations.type="Numeric";P.decorations.n=0;for(var H=0;H<this.decorations.length;H++){var G=this.decorations[H];if(P.nodes[G]&&P.nodes[G].type=="Numeric"){P.decorations.n+=P.nodes[G].n;u.push(P.nodes[G].rmin);u.push(P.nodes[G].rmax)}else{if(P.nodes[G]&&P.nodes[G].type=="Object"){for(var F=0;F<P.nodes[G].levels.length;F++){var z=P.nodes[G].levels[F];for(var C=0;C<y.nodes.length;C++){if(y.nodes[C][G]&&y.nodes[C][G].hasOwnProperty(z)&&y.nodes[C][G][z]&&!isNaN(y.nodes[C][G][z])){P.decorations.n++;u.push(y.nodes[C][G][z])}}}}}}if(u.length){var M=this.colorSpectrum;var w=this.aC(u);P.decorations.rmin=w[0];P.decorations.rmax=w[1];P.decorations.colorBrew=this.QK(M,w[0],w[1],this.colorSpectrumZeroValue,this.colorSpectrumBreaks);P.decorations.min=P.decorations.colorBrew.min;P.decorations.max=P.decorations.colorBrew.max;P.decorations.zero=P.decorations.colorBrew.zero;P.decorations.vals=P.decorations.colorBrew.vals;P.decorations.incr=P.decorations.colorBrew.incr;P.decorations.decs=P.decorations.colorBrew.decs;P.decorations.levels=P.decorations.colorBrew.vals;P.decorations.order={};for(var H=0;H<P.decorations.levels.length;H++){P.decorations.order[P.decorations.levels[H]]=H;var h=this.r9(P.decorations.levels[H],x);if(h>I){I=h;O=P.decorations.levels[H].toString().length;A=P.decorations.levels[H]}P.decorations.maxLevLen=I;P.decorations.maxLevChr=O;P.decorations.maxLevStr=A}}}};this.FV=function(O,af,ac,P,ah){var J=this;var G=this.meta.config.user;var A=this.meta.data;var l=this.data;var C=CanvasXpress.colorSchemes;var p=["x","z","w"];var Y=this.font;var D=function(s,a,r,ai,ak){var t={};if(J.legendOrder&&J.legendOrder[s]){for(var aj=0;aj<J.legendOrder[s].length;aj++){t[J.legendOrder[s][aj]]=aj}var j=J.legendOrder[s].length;if(a){for(var aj in a){if(!t.hasOwnProperty(aj)){t[aj]=j++}}}else{for(var aj=0;aj<r.length;aj++){if(!t.hasOwnProperty(r[aj])){t[aj]=j++}}}return t}else{if(J.isCxplot&&G.hasOwnProperty("aes")&&G.aes.hasOwnProperty("meta")&&G.aes.meta.hasOwnProperty(s)){var d={};var j=0;for(var aj=0;aj<G.aes.meta[s].length;aj++){if(a.hasOwnProperty(G.aes.meta[s][aj])||a.hasOwnProperty(G.aes.meta[s][aj]+"\x00")){d[G.aes.meta[s][aj]]=j++}}return d}else{if(ai){var r=[];for(var aj in a){t[aj]=new Date(J.dateFormat(aj)).getTime();r.push(aj)}r=r.sort(function(o,k){return t[o]-t[k]});var d={};var j=0;for(var aj=0;aj<r.length;aj++){if(!d.hasOwnProperty(r[aj])){d[r[aj]]=j++}}return d}else{if(ak){var r=J.iH(a);r=r.sort(function(o,k){return parseInt(CanvasXpress.dates[o])-parseInt(CanvasXpress.dates[k])});var d={};for(var aj=0;aj<r.length;aj++){d[r[aj]]=aj}return d}else{var r=J.iH(a);for(var aj=0;aj<r.length;aj++){if(!r[aj].match("\x00")){return false}}r=r.sort(function(o,k){return Number(o.replace("\x00",""))-Number(k.replace("\x00",""))});var d={};for(var aj=0;aj<r.length;aj++){d[r[aj]]=aj}return d}}}}};var Z=function(ai,d,o){if(J[ai+"Key"]&&J[ai+"Key"][U]){if(J.ZR(J[ai+"Key"][U])){o[ai+"By"]=J[ai+"Key"][U];for(var k=0;k<S.length;k++){if(!o[ai+"By"].hasOwnProperty(S[k])){var s=Number(S[k].replace("\x00",""));if(!o[ai+"By"].hasOwnProperty(s)){o[ai+"By"][S[k]]=d[k%d.length]}else{o[ai+"By"][S[k]]=o[ai+"By"][s]}}else{if(ai=="color"){o[ai+"By"][S[k]]=J.ZM(o[ai+"By"][S[k]])}}}o[ai+"s"]=[];for(var k=0;k<S.length;k++){o[ai+"s"][k]=o[ai+"By"][S[k]]}}else{if(J.Hl(J[ai+"Key"][U])){o[ai+"s"]=J[ai+"Key"][U]}else{if(ai=="color"){var t=S.length;if(C[J[ai+"Key"][U]][t]){o[ai+"s"]=C[J[ai+"Key"][U]][t]}else{var r=J.iH(C[J[ai+"Key"][U]]);r.sort(function(aj,j){return aj-j});if(t>r[r.length-1]){t--;while(!C[J[ai+"Key"][U]][t]){t--}}else{if(t<r[r.length-1]){t++;while(!C[J[ai+"Key"][U]][t]){t++}}}o[ai+"s"]=C[J[ai+"Key"][U]][t]}for(var k=0;k<t;k++){o[ai+"s"][k]=J.ZM(C[J[ai+"Key"][U]][t][k])}}}}}else{o[ai+"s"]=[];var a=0;if(ai=="color"&&S.length>d.length&&d.length==1&&J.graphType=="Map"){var t=S.length;var r=J.iH(C[J.colorScheme]);r.sort(function(aj,j){return aj-j});if(t>r[r.length-1]){t--;while(!C[J.colorScheme][t]){t--}}else{if(t<r[r.length-1]){t++;while(!C[J.colorScheme][t]){t++}}}for(var k=0;k<t;k++){o[ai+"s"][k]=J.ZM(C[J.colorScheme][t][k])}}else{for(var k=0;k<d.length;k++){if(ai=="color"){o[ai+"s"].push(J.ZM(d[a%d.length]))}else{o[ai+"s"].push(d[a%d.length])}a++}}}};var B=function(a,d,k){var ak=J.colorSpectrum;if(J[a+"Key"]&&J[a+"Key"][U]){if(J.ZR(J[a+"Key"][U])){d[a+"By"]=J[a+"Key"][U];for(var s=0;s<k.length;s++){if(!d[a+"By"].hasOwnProperty(k[s].toString())){d[a+"By"][k[s].toString()]=J[a+"s"][s%J[a+"s"].length]}}d.orderS=D(U,false,k)}else{if(a=="color"){if(J.Hl(J[a+"Key"][U])){ak=J[a+"Key"][U]}else{var ai=J.iH(C[J[a+"Key"][U]]);ai.sort(function(al,j){return al-j});ak=C[J[a+"Key"][U]].hasOwnProperty(8)?C[J[a+"Key"][U]][8]:C[J[a+"Key"][U]][ai[0]]}}}}if(a=="color"){d.colorBrew=J.QK(ak,Q[0],Q[1],J.colorSpectrumZeroValue,J.colorSpectrumBreaks,true);var r=["min","max","zero","vals","incr","decs"];var aj=J.l4(k).sort(function(al,j){return al-j});for(var s=0;s<r.length;s++){var o=r[s];d[o]=d.colorBrew[o]}d.levels=aj.length<d.colorBrew.vals.length?d.colorBrew.vals:aj.length>10?d.colorBrew.vals:aj;d.order={};for(var s=0;s<d.levels.length;s++){d.order[d.levels[s]]=s;var t=J.r9(d.levels[s],Y);if(t>ag){ag=t;c=d.levels[s].toString().length;aa=d.levels[s]}d.maxLevLen=ag;d.maxLevChr=c;d.maxLevStr=aa}}else{d[a+"s"]=a=="connect"?J.colors:J[a+"s"]}};if(!O||O=="w"||O=="x"||O=="z"){if(O&&ac){if(!af){delete (A[O])}else{if(A[O][af]){delete (A[O][af])}}}for(var X=0;X<p.length;X++){var T=p[X];if(O){if(O!=T){continue}}Y=T=="z"?this.varTextFont:this.smpTextFont;var u=l[T];if(u){for(var U in u){if(af){if(af!=U){continue}}if(T=="w"){if(U!="smps"&&U!="grps"){continue}if(U=="grps"){I=u[U];A[T].smps={};for(var V=0;V<u.smps.length;V++){A[T].smps[u.smps[V]]=V}continue}}var I={origin:T,len:this.r9(U,Y)};var M=u[U];var ad=I.len;var b=U.length;var W=U;var ag=0;var c=0;var aa="";I.type=this.Nv(M)&&!this.Ry(M)&&!this.E3(M)?"Numeric":"String";if(I.type=="String"){this.eX(T,U);I.unique=this.ak(M);I["boolean"]=this.gZ(M);I.date=this.Ek(M);I.monthDay=this.rK(M);I.geo=this.Jp(M)||this.Ng(M);if(I["boolean"]&&this.isR){for(var V=0;V<M.length;V++){if(M[V]!=null){if(typeof(M[V])=="string"){if(M[V].toLowerCase()=="true"){M[V]=true}else{if(M[V].toLowerCase()=="false"){M[V]=false}else{M[V]=null}}}}}}var F=this.mQ(M);var q=this.p4(M);var e=D(U,F,false,I.date,I.monthDay);var S=this.m4(this.iH(F));I.levels=e?S.sort(function(j,d){return(e[j]||e[j.replace("\x00","")])-(e[d]||e[d.replace("\x00","")])}):S;I.n=[];for(var V=0;V<I.levels.length;V++){I.n.push(F[I.levels[V]])}I.unordered=q;I.order={};for(var V=0;V<S.length;V++){I.order[S[V]]=e&&e.hasOwnProperty(S[V])?e[S[V]]:V;var E=this.r9(S[V],Y);if(E>ag){ag=E;c=S[V].length;aa=S[V]}}I.maxLevLen=ag;I.maxLevChr=c;I.maxLevStr=aa;Z("color",this.colors,I);Z("shape",this.shapes,I);Z("size",this.l0(S.length),I);Z("pattern",this.patterns,I);Z("linePattern",this.linePatterns,I);Z("connect",this.colors,I)}else{I.unique=false;I["boolean"]=false;for(var V=0;V<M.length;V++){M[V]=M[V]==null||M[V]==this.missingDataValue?Number.NaN:Number(M[V])}var Q=this.aC(M);I.rmin=Q[0];I.rmax=Q[1];I.n=M.length;B("color",I,M);B("shape",I,M);B("size",I,M);B("pattern",I,M);B("linePattern",I,M);B("connect",I,M)}A[T][U]=I;if(!A.m[T]){A.m[T]={}}if(A.m[T].maxFacLen){if(ad>A.m[T].maxFacLen){A.m[T].maxFacLen=ad;A.m[T].maxFacChr=b;A.m[T].maxFacStr=W}}else{A.m[T].maxFacLen=ad;A.m[T].maxFacChr=b;A.m[T].maxFacStr=W}}}if(P){return}var w,H,R;if(T=="z"){w="y";H="vars";R="Var"}if(T=="x"||T=="q"){w="y";H="smps";R="Smp"}if(T=="w"){w="w";H="smps";R="Smp"}var ag=0;var c=0;var aa="";if(l[w]){for(var V=0;V<l[w][H].length;V++){if(l[w][H].length>this.fullTextMeasureCheck){var L=l[w][H][V].toString().length;if(L>c){var E=this.r9(l[w][H][V],Y);if(E>ag){ag=E;c=L;aa=l[w][H][V]}}}else{if(l[w][H][V]!=null){var L=l[w][H][V].toString().length;if(L>=c){var E=this.r9(l[w][H][V].toString(),Y);if(E>ag){ag=E;c=L;aa=l[w][H][V].toString()}}}}}A[w]["max"+R+"Len"]=ag;A[w]["max"+R+"Chr"]=c;A[w]["max"+R+"Str"]=aa;A[w].vars=this.Jp(l.y.vars)?"World":this.Ng(l.y.vars)?"USA":this.Ek(l.y.vars)?"Date":"String";A[w].smps=this.Jp(l.y.smps)?"World":this.Ng(l.y.smps)?"USA":this.Ek(l.y.smps,true)?"Date":"String";if(A[w].smps=="Date"){A[w].date=this.Py(l.y.smps)}if(T=="x"){var ab={};var z=l.y.smps;for(var V=0;V<z.length;V++){var Q=this.aC(this.uV(V));ab[z[V]]={min:Q[0],max:Q[1],type:"Numeric"};if(ah){ab[z[V]].time=ah[V]}}if(!A[w]["range"]){A[w]["range"]={}}this.Gt(A[w]["range"],ab)}if(T=="z"){var ab={};var x=l.y.vars;for(var V=0;V<l.y.data.length;V++){var Q=this.aC(l.y.data[V]);ab[x[V]]={min:Q[0],max:Q[1],type:"Numeric"}}if(!A[w]["range"]){A[w]["range"]={}}this.Gt(A[w]["range"],ab)}if(T=="w"){var ab={};var g=[];var h=this.isGroupedData?this.data.w:this.data.y;if(this.layoutValid&&this.data.l&&this.data.l.smps){for(var V=0;V<this.data.l.smps.length;V++){g.push(V)}}else{g=this.isGroupedData&&this.grpIndices?this.grpIndices:this.smpIndices}var N=h.smps;for(var V=0;V<g.length;V++){var Q=this.aC(this.et(V));ab[N]={min:Q[0],max:Q[1],type:"Numeric"}}if(!A[w]["range"]){A[w]["range"]={}}this.Gt(A[w]["range"],ab)}}}this.dX(O&&af?this.meta.data[O][af]:false)}else{if(O=="y"&&l.y){var ag=0;var c=0;var aa="";for(var V=0;V<l.y.vars.length;V++){if(l.y.vars.length>this.fullTextMeasureCheck){var L=l.y.vars[V].toString().length;if(L>c){var E=this.r9(l.y.vars[V],Y);if(E>ag){ag=E;c=L;aa=l.y.vars[V]}}}else{if(l.y.vars[V]!=null){var L=l.y.vars[V].toString().length;if(L>=c){var E=this.r9(l.y.vars[V],Y);if(E>ag){ag=E;c=L;aa=l.y.vars[V]}}}}}A.y.maxVarLen=ag;A.y.maxVarChr=c;A.y.maxVarStr=aa;A.y.vars=this.Jp(l.y.vars)?"World":this.Ng(l.y.vars)?"USA":this.Ek(l.y.vars)?"Date":"String";if(!A.y.range){A.y.range={}}for(var V=0;V<l.y.data.length;V++){var Q=this.aC(l.y.data[V]);A.y.range[l.y.vars[V]]={};A.y.range[l.y.vars[V]].min=Q[0];A.y.range[l.y.vars[V]].max=Q[1];A.y.range[l.y.vars[V]].type="Numeric"}}else{if(l.y[O]){A[O]={};var ag=0;var c=0;var aa="";if(this.Mb(l.y[O])){for(var V=0;V<l.y[O].length;V++){for(var U=0;U<l.y[O][V].length;U++){if(l.y[O][V][U]!=null){l.y[O][V][U]=Number(l.y[O][V][U])}else{l.y[O][V][U]=Number.NaN}}}var Q=this.hE(l.y[O]);A[O].rmin=Q[0];A[O].rmax=Q[1];A[O].n=l.y[O].length*l.y[O][0].length;A[O].type="Numeric";A[O].colorBrew=this.QK(this.colorSpectrum,Q[0],Q[1],null,false,true);var ae=["min","max","zero","vals","incr","decs"];for(var V=0;V<ae.length;V++){var f=ae[V];A[O][f]=A[O].colorBrew[f]}A[O].levels=A[O].colorBrew.vals;A[O].order={};for(var V=0;V<A[O].levels.length;V++){A[O].order[A[O].levels[V]]=V;var E=this.r9(A[O].levels[V],Y);if(E>ag){ag=E;c=A[O].levels[V].toString().length;aa=A[O].levels[V]}A[O].maxLevLen=ag;A[O].maxLevChr=c;A[O].maxLevStr=aa}A[O].shapes=this.shapes;A[O].sizes=this.sizes;A[O].patterns=this.patterns}else{var S={};for(var V=0;V<l.y[O].length;V++){for(var U=0;U<l.y[O][V].length;U++){if(l.y[O][V][U]!=null){S[l.y[O][V][U]]=true}else{l.y[O][V][U]=""}}}S=this.m4(this.iH(S));A[O].levels=S;A[O].order={};for(var V=0;V<S.length;V++){A[O].order[S[V]]=V;var E=this.r9(S[V],Y);if(E>ag){ag=E;c=S[V].length;aa=S[V]}}A[O].maxLevLen=ag;A[O].maxLevChr=c;A[O].maxLevStr=aa;A[O].type="String";A[O].colors=[];var K=0;for(var V=0;V<S.length;V++){A[O].colors.push(this.colors[K%this.colors.length]);K++}A[O].shapes=[];var K=0;for(var V=0;V<S.length;V++){A[O].shapes.push(this.shapes[K%this.shapes.length]);K++}var y=this.l0(S.length);A[O].sizes=[];var K=0;for(var V=0;V<S.length;V++){A[O].sizes.push(y[K%y.length]);K++}A[O].patterns=[];var K=0;for(var V=0;V<S.length;V++){A[O].patterns.push(this.patterns[K%this.patterns.length]);K++}}}else{alert("Error while setting metadata. This may not work!")}}}};this.MR=function(){if(!this.meta.data){if(!this.graphType.match(/(Scatter)/)&&this.data.y&&this.data.y.smps&&this.Ek(this.data.y.smps,true)){this.Aj(this.data)}if(this.graphType=="Network"){this.meta.data={nodes:{},edges:{},decorations:{}};this.k8()}else{if(this.graphType=="Genome"){this.meta.data={tracks:[]};this.af()}else{if(this.graphType=="Venn"){}else{this.meta.data={w:{},x:{},y:{},z:{},m:{},p:{g:[],l:[],i:[]},l:[],q:{l:{},g:[],b:false,o:false},f:false,r:false,u:false,s:false,b:{l:[],g:false,c:false},c:{z:{},s:{},p:[]},d:{m:{},v:[],g:[],s:{},a:{},l:[],q:null,x:{},y:{},z:{},d:{}}};if(this.data.y){var L=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;var N=this.data.y;var D=N.data;var z=new Array(N.smps.length).fill(true);var p=[];if(this.isRawData){var K=this.xAxisTime;var w=this.yAxisTime;var P=this.xAxis[0];var c=this.yAxis[0];var M=this.missingDataValue;for(var H=0,I=N.smps.length;H<I;H++){if((K&&P==N.smps[H])||(w&&c==N.smps[H])){p.push(H)}}for(var H=0,I=p.length;H<I;H++){for(var G=0,h=D.length;G<h;G++){var a=D[G][p[H]];if(a!=null&&toString.call(a)!=="[object Date]"&&L.test(a)){D[G][p[H]]=new Date(a).getTime()}}}var I=D.length;for(var H=0;H<I;H++){if(D[H]!=null){var h=D[H].length;for(var G=0;G<h;G++){var J=D[H][G];if(J!=null){if(z[G]&&!this.Ek([J])){z[G]=false}D[H][G]=J==M?Number.NaN:Number(J)}else{D[H][G]=Number.NaN}}}else{if(this.graphType=="Map"){D[H]=[]}}}}else{var y=this.summaryType=="iqr"?["iqr1","iqr3","median","qtl1","qtl3","out"]:[this.summaryType];var u=y.length;var M=this.missingDataValue;var b=this.summaryType;for(var H=0;H<u;H++){var x=y[H];if(N.hasOwnProperty(x)){var B=N[x];var q=B.length;for(var G=0;G<q;G++){var s=B[G];var g=s.length;for(var F=0;F<g;F++){if(x=="out"){var e=s[F];var A=e.length;for(var E=0;E<A;E++){if(e[E]!=null){e[E]=e[E]==M?Number.NaN:Number(e[E])}else{D[H][G]=Number.NaN}}}else{if(s[F]!=null){s[F]=s[F]==M?Number.NaN:Number(s[F])}else{s[F]=Number.NaN}}}}}else{if(x){N[x]=[];var Q=b=="iqr"?"median":b;var O=N[Q];var o=O.length;for(var G=0;G<o;G++){var s=N[x][G]=[];var r=O[G];var C=r.length;for(var F=0;F<C;F++){s[F]=[]}}}}}var x=b=="iqr"?"median":b;var B=N[x];var q=B?B.length:0;N.data=[];if(x){for(var H=0;H<q;H++){N.data.push(B[H])}}}}this.FV(false,false,false,false,z)}}}}};this.ir=function(a){var b=this.isGroupedData?this.data.w:this.data.y;if(a=="cor"&&b.cor){return true}else{if(a=="venn"&&this.data.venn){return true}else{if(a=="network"&&this.data.nodes){return true}else{if(a=="genome"&&this.data.tracks){return true}else{if(a=="sum"&&b.sum&&b.sum[0].length>0){return true}else{if(a=="max"&&b.max&&b.max[0].length>0){return true}else{if(a=="min"&&b.min&&b.min[0].length>0){return true}else{if(a=="count"&&b.count&&b.count[0].length>0){return true}else{if(a=="mean"&&b.mean&&b.mean[0].length>0){return true}else{if(a=="median"&&b.median&&b.median[0].length>0){return true}else{if(a=="iqr"&&b.iqr1&&b.qtl1&&b.median&&b.qtl3&&b.iqr3&&b.median[0].length>0){return true}else{if(a=="raw"&&this.isRawData){return true}else{return false}}}}}}}}}}}}};this.we=function(aw,f,Q,ag,J){var W=this;var r=this.isDOE?this.data.l.data[this.layoutCurrent||0]:false;var t=this.isGroupedData&&!f&&this.data.w?this.data.w:this.data.y;var ah=this.graphType=="Scatter2D"&&this.scatterType=="visium"?CanvasXpress.cacheImages[this.backgroundImageMD5||this.zM(this.backgroundImage)]:false;var w=this.TN(true);var at=Number.POSITIVE_INFINITY;var K=Number.NEGATIVE_INFINITY;var A=Number.POSITIVE_INFINITY;var ab=Number.NEGATIVE_INFINITY;if(this.setMin!=null&&this.setMax!=null){this.minData=Number(this.setMin);this.maxData=Number(this.setMax);return}if(this.isGroupedData&&!aw&&!r){aw=this.graphType=="Boxplot"?"iqr":this.summaryType;if(this.graphType=="Boxplot"&&!this.isBoxplotCalc){this.cg(this.groupingFactors,false,false,false,true);t=this.data.w}}if(this.isGroupedData&&!f&&this.data.w&&!ag&&!r&&!this.layoutCurrent){for(var ak=0;ak<t.min.length;ak++){if(t.min[ak]){for(var aj=0;aj<t.min[ak].length;aj++){if(!isNaN(t.min[ak][aj])){at=Math.min(at,t.min[ak][aj])}if(!isNaN(t.max[ak][aj])){K=Math.max(K,t.max[ak][aj])}}}}}else{if(this.graphType=="Meter"){var H;if(this.layoutValid&&this.segregateVariablesBy.length&&this.segregateSamplesBy.length){H=this.data.l.comp[this.layoutCurrent||0][0][0]}else{if(this.layoutValid&&this.segregateVariablesBy.length&&!this.segregateSamplesBy.length){H=this.layoutCurrent||0}else{if(this.layoutValid&&this.segregateSamplesBy.length){H=this.xAxis.length?this.as(this.xAxis[0]):0}else{H=this.layoutValid?(this.layoutCurrent||0):this.xAxis.length?this.as(this.xAxis[0]):0}}}this.meterIndex=H>=0?H:0;var Y=this.data.y.data[this.meterIndex];at=0;K=this.Wj(Y,true)}else{if(w){var G=this.varIndices.length;for(var ak=0;ak<G;ak++){var S=this.varIndices[ak];var E=this.smpIndices.length;var N=0;at=0;for(var aj=0;aj<E;aj++){var C=this.smpIndices[aj];var O=this.data.y.data[S][C];if(!isNaN(O)){N+=O;at=Math.min(N,at);K=Math.max(N,K)}}}}else{if(aw=="fish"){if(J=="xAxis"){at=this.fishTimepoints[0]-((this.fishTimepoints[this.fishTimepoints.length-1]-this.fishTimepoints[0])/5);K=this.fishTimepoints[this.fishTimepoints.length-1]}else{at=0;K=100}}else{if(aw=="genome"){var S=this.data.tracks.length;for(var ak=0;ak<S;ak++){var C=this.data.tracks[ak].data.length;for(var aj=0;aj<C;aj++){if(this.data.tracks[ak].type=="box"){var au=this.data.tracks[ak].data[aj].data.length;for(var ai=0;ai<au;ai++){Y=this.data.tracks[ak].data[aj].data[ai];K=Math.max(K,Math.max(Y[0],Y[1]));at=Math.min(at,Math.min(Y[0],Y[1]))}}else{if(this.data.tracks[ak].type=="sequence"){Y=this.data.tracks[ak].data[aj].offset;K=Math.max(K,Y+this.data.tracks[ak].data[aj].sequence.length);at=Math.min(at,Y)}else{if(this.data.tracks[ak].type.match(/bar|heatmap/)){Y=this.data.tracks[ak].data[aj].offset;K=this.data.tracks[ak].autowidth?Math.max(K,Y+this.data.tracks[ak].data[aj].data.length):Math.max(K,Y);at=Math.min(at,Y)}else{if(this.data.tracks[ak].type=="dataframe"){var au=this.data.tracks[ak].data[0].data.length;for(var ai=0;ai<au;ai++){Y=this.data.tracks[ak].dataframe[this.data.tracks[ak].data[0].data[ai].xAxis];K=Math.max(K,Y[Y.length-1]);at=Math.min(at,Y[0])}}else{if(this.data.tracks[ak].type=="marker"){var au=this.data.tracks[ak].data[aj].data.length;for(var ai=0;ai<au;ai++){Y=this.data.tracks[ak].data[aj].data[ai];K=Math.max(K,Y[Y.length-1]);at=Math.min(at,Y[0])}}else{Y=this.data.tracks[ak].data[aj].offset;K=Math.max(K,Y);at=Math.min(at,Y)}}}}}}}}else{if(aw=="circular"){if(this.circularType=="chord"){this.circularChord=this.H2();at=0;K=this.circularChord.total}else{var ap=J&&this[J].length?this.as(this[J]):this.as(this.rAxis);if(ap>=0){var ad=this.aC(this.data.y.data[ap]);at=ad[0];K=ad[1]}else{at=0;K=1}}}else{if(aw=="gantt"){if(!this.data.gantt){this.isGanttDataFormated=false;this.ww()}var ak=this.as(this.ganttStart);var aj=this.as(this.ganttEnd);var ar=this.v8(this.data.gantt);at=ar[ak].sort(function(d,c){return d-c})[0];K=ar[aj].sort(function(d,c){return c-d})[0]}else{if(aw=="km"&&!f){if(!this.layoutValid){this.f3()}if(J=="y"){at=0;K=1}else{var ac=this.layoutValid&&this.meta.data.p.l.length?this.meta.data.p.l:this.meta.data.p.g;if(this.layoutValid&&this.meta.data.p.l.length){for(var ak=0;ak<ac.length;ak++){for(var aj=0;aj<ac[ak].length;aj++){at=Math.min(at,ac[ak][aj].data.time[0]);K=Math.max(K,ac[ak][aj].data.time[ac[ak][aj].data.time.length-1])}}}else{for(var ak=0;ak<ac.length;ak++){at=Math.min(at,ac[ak].data.time[0]);K=Math.max(K,ac[ak].data.time[ac[ak].data.time.length-1])}}}}else{if(aw=="qq"||aw=="cdf"){if(aw=="qq"){this.fw()}else{this.ha()}var ac=this.layoutValid?this.meta.data.p.l:this.meta.data.p.g;if(this.layoutValid){for(var ak=0;ak<ac.length;ak++){for(var aj=0;aj<ac[ak].length;aj++){at=Math.min(at,ac[ak][aj].data[J][0]);K=Math.max(K,ac[ak][aj].data[J][ac[ak][aj].data[J].length-1])}}}else{for(var ak=0;ak<ac.length;ak++){at=Math.min(at,ac[ak].data[J][0]);K=Math.max(K,ac[ak].data[J][ac[ak].data[J].length-1])}}}else{if(aw=="density"&&t.density){var P=function(d){for(var c=1;c<W.data.l.name.length;c++){if(W.data.l.name[c]==d){return c-1}}return 0};if(J=="xAxis"){var ap=this.layoutCurrent||0;at=t.density[ap].histogram.breaks[0];K=t.density[ap].histogram.breaks[t.density[ap].histogram.breaks.length-1]}else{if(this.histogramAsDotplot&&J=="yAxis"){if(this.histogramStackDir!="down"){at=-0.5;K=0.5}else{at=0;K=1}}else{if(this.densityPosition.match(/filled|stacked/)){if(this.histogramStat=="count"){if(this.densityPosition=="filled"){K=t.global.maxY}else{if(this.densityPosition=="stacked"){K=t.global.maxY}}}else{if(this.densityPosition=="filled"){K=1}else{if(this.densityPosition=="stacked"){K=t.position.max}}}at=0}else{if(this.histogramType=="stacked"&&this.histogramStat=="count"){if(this.layoutValid&&this.data.l){for(var ak=0;ak<this.data.l.axes.length;ak++){var u=[];var h=0;for(var aj=0;aj<this.data.l.axes[ak].yAxis.length;aj++){var ap=P(this.data.l.axes[ak].yAxis[aj]);h+=t.density[ap].histogram.maxY}K=Math.max(K,h)}}else{K=t.global.maxY}at=0}else{if(this.histogramType=="stacked"){K=0}for(var ak=0;ak<this.smpIndices.length;ak++){if(this.histogramType=="stacked"){K+=t.density[this.smpIndices[ak]-1].globalMaxY}else{K=Math.max(K,t.density[this.smpIndices[ak]-1].globalMaxY)}}at=0}}}}}else{if(aw=="percentile"&&!f&&!ag){at=0;K=100}else{if((aw=="mean"||aw=="median"||aw=="sum"||aw=="max"||aw=="min"||aw=="count")&&!f){if(ag){if(this.dodgeBy){var aq=this.dodgeBy;this.dodgeBy=false;this.groupingFactors.push(aq);this.cg(this.groupingFactors,false,false,false,true);K=this.maxData;at=this.minData;this.groupingFactors.pop();this.cg(this.groupingFactors,false,false,false,true);this.dodgeBy=aq}else{K=0;at=0;ab=0;A=0;var o=this.isGroupedData?this.grpIndices:this.smpIndices;var ao=this.isTransformedData?t.trans:t[this.summaryType];var V=this.graphType=="Circular"&&this.showIdeogram;var F=V?[this.varIndices,o]:[o,this.varIndices];var y=F[0].length;for(var ak=0;ak<y;ak++){var S=F[0][ak];var e=0;var g=0;var z=F[1].length;for(var aj=0;aj<z;aj++){var C=this.isGroupedData?aj:F[1][aj];var O=V?ao[S][C]:ao[C][S];if(!isNaN(O)){A=Math.min(O,A);ab=Math.max(O,ab);if(O>0){e+=O}else{if(O<0){g+=O}}}}K=Math.max(e,K);at=Math.min(g,at)}}}else{var G=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ak=0;ak<G;ak++){var S=this.varIndices[ak];if(S==undefined){continue}var Y;var ae;if(this.isTransformedData){Y=t.trans[S]||t.trans[ak];ae=t.tstdev?(t.tstdev[S]||t.tstdev[ak]):false}else{if(this.summaryType=="mean"){Y=t.mean[S]||t.mean[ak]}else{if(this.summaryType=="median"){Y=t.median[S]||t.median[ak]}else{if(this.summaryType=="sum"){Y=t.sum[S]||t.sum[ak]}else{if(this.summaryType=="max"){Y=t.max[S]||t.max[ak]}else{if(this.summaryType=="min"){Y=t.min[S]||t.min[ak]}else{if(this.summaryType=="count"){Y=t.count[S]||t.count[ak]}}}}}}ae=t.stdev?(t.stdev[S]||t.stdev[ak]):false}if(Y){var am=Y.length;for(var aj=0;aj<am;aj++){var Z;var O=Y[aj];if(ae){Z=ae[aj]/2}else{Z=Number.NaN}if(!isNaN(O)){if(!isNaN(Z)){if(Q){if(O>0){at=Math.min(O-Z,at);K=Math.max(O+Z,K)}}else{at=Math.min(O-Z,at);K=Math.max(O+Z,K)}}else{if(Q){if(O>0){at=Math.min(O,at);K=Math.max(O,K)}}else{at=Math.min(O,at);K=Math.max(O,K)}}}}}}}}else{if(this.summaryType=="mean"&&!this.isRawData){var S=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ak=0;ak<S;ak++){if(this.varIndices[ak]==undefined){continue}var C=this.smpIndices.length;for(var aj=0;aj<C;aj++){var O=t.mean[this.varIndices[ak]][this.smpIndices[aj]];var al=t.stdev&&t.stdev[this.varIndices[ak]]&&t.stdev[this.varIndices[ak]][this.smpIndices[aj]]/2?t.stdev[this.varIndices[ak]][this.smpIndices[aj]]/2:0;if(!isNaN(O)){if(!isNaN(al)){at=Math.min(O-al,at);K=Math.max(O+al,K)}else{at=Math.min(O,at);K=Math.max(O,K)}}}}}else{if((aw=="iqr"&&!f&&this.grpIndices)||(this.summaryType=="iqr"&&!this.isRawData)){var G=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ak=0;ak<G;ak++){var S=this.varIndices[ak];var M=this.grpIndices?this.grpIndices:this.smpIndices;var av=M.length;if(t.iqr1[S]){for(var aj=0;aj<av;aj++){var C=M[aj];var D=t.iqr1[S][C];var B=t.iqr3[S][C];var X=t.out[S][C];if(!isNaN(D)&&!isNaN(B)){if(Q){if(D>0&&B>0){at=Math.min(D,at);K=Math.max(B,K)}}else{at=Math.min(D,at);K=Math.max(B,K)}}if(X){var T=X.length;for(var ai=0;ai<T;ai++){if(!isNaN(X[ai])){if(Q){if(X[ai]>0){at=Math.min(X[ai],at);K=Math.max(X[ai],K)}}else{at=Math.min(X[ai],at);K=Math.max(X[ai],K)}}}}}}}}else{if(aw=="cor"){var o=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;var S=o.length;for(var ak=0;ak<S;ak++){var C=o.length;for(var aj=0;aj<C;aj++){var O=this.isTransformedData&&t.trans?t.trans[ak][aj]:t.cor[ak][aj];if(!isNaN(O)){if(Q){if(O>0){at=Math.min(O,at);K=Math.max(O,K)}}else{at=Math.min(O,at);K=Math.max(O,K)}}}}}else{if(r){var C=J=="xAxis"?0:1;if(this.graphType=="Scatter2D"){for(var ak=0;ak<r.y.data.length;ak++){var O=r.y.data[ak][C];if(!isNaN(O)){at=Math.min(O,at);K=Math.max(O,K)}}}else{for(var ak=0;ak<r.y.data[C].length;ak++){var O=r.y.data[C][ak];if(!isNaN(O)){at=Math.min(O,at);K=Math.max(O,K)}}}}else{var ao=this.isTransformedData&&t.trans?t.trans:t.data;var a=ah?ah.height:false;if(ao&&ao.length>0){if(ag){var V=this.graphType=="Circular"&&this.showIdeogram;var F=V?[this.varIndices,this.smpIndices]:[this.smpIndices,this.varIndices];var y=F[0].length;K=0;at=0;ab=0;A=0;for(var ak=0;ak<y;ak++){var e=0;var g=0;var z=F[1].length;for(var aj=0;aj<z;aj++){var O=V?ao[F[0][ak]][F[1][aj]]:ao[F[1][aj]][F[0][ak]];if(!isNaN(O)){A=Math.min(O,A);ab=Math.max(O,ab);if(O>0){e+=O}else{if(O<0){g+=O}}}}K=Math.max(e,K);at=Math.min(g,at)}}else{var S=this.motionBy||(this.isDOE&&this.isDOE==1)?this.data.y.vars.length:this.varIndices.length;for(var ak=0;ak<S;ak++){if(this.varIndices[ak]==undefined){continue}var C=this.smpIndices.length;for(var aj=0;aj<C;aj++){var L=this.motionBy?ak:this.varIndices[ak];if(ao[L]){var O=a?a-ao[L][this.smpIndices[aj]]:ao[L][this.smpIndices[aj]];if(!isNaN(O)){if(Q){if(O>0){at=Math.min(O,at);K=Math.max(O,K)}}else{at=Math.min(O,at);K=Math.max(O,K)}}}}}if(this[J+"Transform"]=="sqrt"){at=Math.sqrt(at);K=Math.sqrt(K)}}}}}}}}}}}}}}}}}}}if(this.graphType=="Boxplot"&&this.showViolinBoxplot&&!this.violinTrim){var x=this.meta.data.d;if(this.isGroupedData){x=x.g;var S=x.length;for(var ak=0;ak<S;ak++){var C=x[ak].length;for(var aj=0;aj<C;aj++){var an=x[ak][aj].density.xy;if(an.length){if(!isNaN(an[0][0])){at=Math.min(at,an[0][0])}if(!isNaN(an[an.length-1][0])){K=Math.max(K,an[an.length-1][0])}}}}if(aw.match(/log/)){if(at<=0){at=Math.max(Number.MIN_VALUE,at)}if(K<=0){K=Math.max(Number.MIN_VALUE,K)}}}else{x=x.v;var S=x.length;for(var ak=0;ak<S;ak++){var an=x[ak].density.xy;if(an.length){if(!isNaN(an[0][0])){at=Math.min(at,an[0][0])}if(!isNaN(an[an.length-1][0])){K=Math.max(K,an[an.length-1][0])}}}}}else{if(this.graphType=="Scatter2D"&&this.scatterType=="visium"){var R=CanvasXpress.cacheImages[this.backgroundImageMD5||this.zM(this.backgroundImage)];at=0;K=J.match(/y/i)?R.height:R.width}else{if(this.graphType=="Scatter2D"&&this.ribbonBy){var ao=this.isTransformedData&&t.trans?t.trans:t.data;var x=this.meta.data;if(this.Hl(this.ribbonBy)){if(this.Hl(this.ribbonBy[0])&&this.Hl(this.ribbonBy[1])&&J=="yAxis"){for(var ak=0;ak<this.ribbonBy[0].length;ak++){var q=this.ribbonBy[0][ak];var b=this.ribbonBy[1][ak];if(!isNaN(q)){at=Math.min(q,at)}if(!isNaN(b)){K=Math.max(b,K)}}}else{if(x.z&&x.z.hasOwnProperty(this.ribbonBy[0])&&x.z[this.ribbonBy[0]].type=="Numeric"&&x.z.hasOwnProperty(this.ribbonBy[1])&&x.z[this.ribbonBy[1]].type=="Numeric"){for(var ak=0;ak<this.varIndices.length;ak++){var b=this.data.z[this.ribbonBy[0]][this.varIndices[ak]];var q=this.data.z[this.ribbonBy[1]][this.varIndices[ak]];if(!isNaN(b)){at=Math.min(b,at);K=Math.max(b,K)}if(!isNaN(q)){at=Math.min(q,at);K=Math.max(q,K)}}}else{var U=this.sF(this.ribbonBy);if(this.Hl(U)&&J=="yAxis"){for(var ak=0;ak<this.varIndices.length;ak++){for(var aj=0;aj<this.smpIndices.length;aj++){var b=ao[this.varIndices[ak]][U[0]];var q=ao[this.varIndices[ak]][U[1]];if(!isNaN(b)){at=Math.min(b,at);K=Math.max(b,K)}if(!isNaN(q)){at=Math.min(q,at);K=Math.max(q,K)}}}}}}}else{if(x.z&&x.z.hasOwnProperty(this.ribbonBy)&&x.z[this.ribbonBy].type=="Numeric"){for(var ak=0;ak<this.varIndices.length;ak++){var Z=this.data.z[this.ribbonBy][this.varIndices[ak]];for(var aj=0;aj<this.smpIndices.length;aj++){var O=ao[this.varIndices[ak]][this.smpIndices[aj]];if(!isNaN(O)&&!isNaN(Z)){at=Math.min(O-Z,at);K=Math.max(O+Z,K)}}}}else{for(var ak=0;ak<this.varIndices.length;ak++){for(var aj=0;aj<this.smpIndices.length;aj++){var O=ao[this.varIndices[ak]][this.smpIndices[aj]];var Z=ao[this.varIndices[ak]][U];if(!isNaN(O)&&!isNaN(Z)){at=Math.min(O-Z,at);K=Math.max(O+Z,K)}}}}}}else{if(this.showHistogram||this.isDOE){var aa=this.WL();if(aa){if(this.isDOE){if(this.isDOE&&this.layoutCurrent&&this.data.l.data&&this.data.l.data[this.layoutCurrent]&&this.data.l.params&&!this.data.l.params[this.layoutCurrent].showHistogram){}else{if(J=="xAxis"){at=aa.histogram?aa.histogram.breaks[0]:aa.density.histogram.breaks[0];K=aa.histogram?aa.histogram.breaks[aa.histogram.breaks.length-1]:aa.density.histogram.breaks[aa.density.histogram.breaks.length-1]}else{if(J=="yAxis"){switch(this.densityPosition){case"filled":at=0;K=aa.density?aa.density.histogram.maxY:aa.histogram.maxY;break;case"stacked":at=0;K=aa.density?aa.density.histogram.maxY:aa.histogram.maxY;break;default:at=0;K=this.histogramType=="stacked"&&aa.density?aa.density.histogram.maxY:this.histogramType=="stacked"?aa.histogram.maxY:this.layoutCurrent?aa.histogram.maxY:this.Wj(aa.summary.cols);break}}}}}else{if(J=="xAxis"){at=aa.density.minData;K=aa.density.maxData}else{if(J=="yAxis"){if(this.histogramStat=="count"){switch(this.densityPosition){case"filled":at=0;K=this.layoutValid?aa.summary.globalMaxCount:aa.density.histogram.maxY;break;case"stacked":at=0;K=this.layoutValid?aa.summary.globalMaxCount:aa.density.histogram.maxY;break;default:at=0;K=this.layoutValid&&this.histogramType=="stacked"?aa.summary.globalMaxCount:this.histogramType=="stacked"?aa.density.histogram.maxY:this.Wj(aa.summary.cols);break}}else{if(this.histogramStat=="density"){switch(this.densityPosition){case"filled":at=0;K=1;break;case"stacked":at=0;K=aa.summary.position.max;break;default:at=0;K=aa.summary.globalMaxY;break}}}}}}}}else{if(this.graphType=="Scatter2D"&&this.colorBy&&this.scatterType=="area"&&J=="yAxis"){this.yc();if(this.meta.data.s){var aa=this.layoutValid?this.meta.data.s.layout[this.layoutCurrent||0]:this.meta.data.s;at=0;K=aa.maxY}}else{if(this.graphType=="Scatter2D"&&(this.colorBy||this.yAxis.length>1)&&!this.dataPointSizeScaleFactor&&this.scatterType=="stream"){if(J=="xAxis"){var I=(K-at)*this.scatterStreamExtraSpan;at-=I;K+=I}else{if(J=="yAxis"){this.b8();if(this.meta.data.s){var aa=this.layoutValid?this.meta.data.s.layout[this.layoutCurrent||0]:this.meta.data.s;switch(this.scatterStreamType){case"mirror":at=-aa.maxY;K=aa.maxY;break;case"ridge":at=0;K=aa.maxY*2;break;case"proportional":at=0;K=1;break}}}}}else{if(this.graphType=="Scatter2D"&&J=="yAxis"&&(this.showLoessFit||this.showRegressionFit||this.showQuantileRegressionFit)){if(this.showLoessFit){this.l1()}if(this.showRegressionFit){this.ba()}if(this.showQuantileRegressionFit){this.Tw()}if(this.meta.data.s){var af=this.meta.data.s;if(af.minY!=null&&af.minY<Number.POSITIVE_INFINITY&&af.maxY!=null&&af.maxY>Number.NEGATIVE_INFINITY){if(this.dataPointSizeScaleFactor){at=Math.min(at,af.minY);K=Math.max(K,af.maxY)}else{at=af.minY;K=af.maxY}}}}}}}}}}if(this.decorations){if(this.decorations.error){for(var ak=0;ak<this.decorations.error.length;ak++){if(this.graphType=="Scatter2D"){}else{at=Math.min(at,this.decorations.error[ak].min);K=Math.max(K,this.decorations.error[ak].max)}}}if(this.decorations.marker){for(var ak=0;ak<this.decorations.marker.length;ak++){if(this.decorations.marker[ak].type=="pwc"){K=Math.max(K,this.decorations.marker[ak].ymax)}}}if(this.decorations.text){for(var ak=0;ak<this.decorations.text.length;ak++){if(this.decorations.text[ak].value!=null){at=Math.min(at,this.decorations.text[ak].value);K=Math.max(K,this.decorations.text[ak].value)}}}}this.minData=this.setMin!=null?this.setMin:at==Number.POSITIVE_INFINITY||at==Number.NEGATIVE_INFINITY?0:at;this.maxData=this.setMax!=null?this.setMax:K==Number.NEGATIVE_INFINITY||K==Number.POSITIVE_INFINITY?1:K;if(ag&&aw!="percentile"){this.minDataStacked=A;this.maxDataStacked=ab}};this.wD=function(a){var c=false;if(this.scatterPlotMatrix&&a!=null){var b=this.meta.data.s&&this.meta.data.s.density?this.meta.data.s.density:false;if(b&&b.layout&&b.Global&&b.Global.Samples&&b.Global.sets&&this.layoutValidN!=null&&b.Global.sets[b.layout[this.layoutValidN][a]]){c=b.Global.Samples[b.Global.sets[b.layout[this.layoutValidN][a]].name.split(":")[1]].summary}}else{c=this.meta.data.s&&this.meta.data.s.density&&this.meta.data.s.density.Global&&this.meta.data.s.density.Global.summary?this.meta.data.s.density.Global.summary:false}if(c){return{data:c.histogram,vars:c.vars,smps:this.Ev(c.smps).splice(1,c.smps.length-1)}}else{return false}};this.dL=function(k,p,s,q){this.filterFitIndices=[];for(var h=0;h<this.varIndices.length;h++){this.filterFitIndices.push(false)}var f=k!=null?(this.layoutParams?this.layoutParams[k].setMinX:null):this.setMinX;var b=k!=null?(this.layoutParams?this.layoutParams[k].setMaxX:null):this.setMaxX;var e=k!=null?(this.layoutParams?this.layoutParams[k].setMinY:null):this.setMinY;var a=k!=null?(this.layoutParams?this.layoutParams[k].setMaxY:null):this.setMaxY;var o=this.Q8(this.scatterPlotMatrix?p:this.xAxisIndices[p],"x",q);var l=this.Q8(this.scatterPlotMatrix?s:this.yAxisIndices[s],"y",q);for(var h=0;h<o.length;h++){var r=this.varIndices[h];var d=o[h];var c=l[h];if(d==null||c==null||isNaN(d)||isNaN(c)){if(q){this.filterFitIndices[q[h]]=true}else{this.filterFitIndices[r]=true}}else{if((f===null||(d>=f&&d<=b))&&(e===null||(c>=e&&c<=a))){}else{if(q){this.filterFitIndices[q[h]]=true}else{this.filterFitIndices[r]=true}}}}for(var h=0;h<o.length;h++){if(o[h]==null||l[h]==null||isNaN(o[h])||isNaN(l[h])){o.splice(h,1);l.splice(h,1);h--}}if(this.skipFilterFit&&(f===null||f<=b)&&(e===null||e<=a)){return[o,l]}this.skipFilterFit=false;var j=[];var g=[];for(let h=0;h<o.length;h++){var d=o[h];var c=l[h];if((f===null||(d>=f&&d<=b))&&(e===null||(c>=e&&c<=a))){j.push(d);g.push(c)}}return[j,g]};this.WL=function(){var I=this;var K=[];var S=function(aw,an,aq){var aa=[];var aj=[];var q=aw.sets||[aw];var ah=0;if(!I.isDOE){for(var av=0;av<q.length;av++){aa=aa.concat(q[av].data);aj=I.histogramAsDotplot?aj.concat([av]):aj.concat(q[av].idxs);ah=Math.max(ah,q[av].globalMaxY)}}var ad=!I.isDOE?I.kZ(aa,an,aj):aw;var ab={globalMaxY:ah,vars:[],smps:[],data:[],histogram:[],values:[],cols:[],position:{factor:1,max:0,tot:[]},stacked:[],filled:[]};var ao=ad.histogram.count.length;var am=ad.histogram.breaks;var aB=ad.histogram.fbreaks;var ap=am[0];for(var av=0;av<ao;av++){ab.vars.push("Bin"+(av+1)+" ("+ad.histogram.breaks[av]+" - "+ad.histogram.breaks[av+1]+")");ab.data[av]=[];ab.data[av][0]=am[av+1]-ap;ab.histogram[av]=[];ab.values[av]=[];for(var au=0;au<q.length;au++){ab.histogram[av][au]=[];ab.values[av][au]=[]}}ab.smps.push("Bin");for(var av=0;av<q.length;av++){var az=0;ab.smps.push(q[av].name);var ac=[];for(var au=0;au<ao;au++){ac[au]=0}for(var au=0;au<q[av].data.length;au++){var af=q[av].data[au];var ay=q[av].idxs[au];if(typeof af==="number"&&isFinite(af)){var al=I.QQ(af,aB);ac[al]++;if(ab.histogram[al]&&ab.histogram[al][av]){ab.histogram[al][av].push(ay);ab.values[al][av].push(af)}}}for(var au=0;au<ao;au++){ab.data[au][av+1]=ac[au];az=Math.max(az,ac[au])}ab.cols.push(az)}for(var av=0;av<ad.xy.length;av++){ab.position.tot[av]=0}var at=[];var ar=0;for(var av=0;av<q.length;av++){var ai=q[av];var aA=I.Mw(ai.xy,ad.xy);var ak=[];var ae=[];for(var au=0;au<ad.xy.length;au++){ak[au]=[ad.xy[au][0],ab.position.tot[au]];ab.position.tot[au]+=aA[au][1];ae[au]=[ad.xy[au][0],ab.position.tot[au]]}ab.stacked[av]=ae.concat(ak.reverse());at.push(aA);for(var au=0;au<ab.position.tot.length;au++){ar=Math.max(ar,ab.position.tot[au])}ab.position.max=ar;ab.position.factor=ad.histogram.maxY/ar}var ax=[];for(var av=0;av<ad.xy.length;av++){ax[av]=0}for(var av=0;av<q.length;av++){var ai=q[av];var aA=at.shift();var ak=[];var ae=[];for(var au=0;au<ad.xy.length;au++){ak[au]=[ad.xy[au][0],ax[au]];ax[au]+=(ab.position.tot[au]>0?aA[au][1]/ab.position.tot[au]:0);ae[au]=[ad.xy[au][0],ax[au]]}ab.filled[av]=ae.concat(ak.reverse())}if(aq!=null){var az=0;for(var av=0;av<aq.length;av++){var ag=0;for(var au=0;au<aq[av].length;au++){ag+=ab.cols[aq[av][au]]}az=Math.max(az,ag)}ab.globalMaxCount=az}if(!I.isDOE){aw.density=ad}aw.summary=ab};var b=function(){var j=I.meta.data.s.density;if(I.isDOE&&j.DOE){if(I.layoutCurrent){return j.DOE[I.data.l.smps[I.layoutCurrent]]}else{return j.Global}}else{if(I.scatterPlotMatrix){return I.layoutCurrent!==false&&j.layout[I.layoutCurrent].length?j.Global.Samples[j.Global.sets[j.layout[I.layoutCurrent][0]].name.split(":")[1]]:false}else{if(j.Global){return j.Global}}}};var s=function(k,j){return k.filter(function(l){return j.includes(l)})};var C=function(){var l=[];var j=[];var aa=[];var q=[];var ab=I.meta.data.s.density.layout;if(I.segregateVariablesBy.length){if(I.meta.data.z&&I.meta.data.z.hasOwnProperty(I.segregateVariablesBy[0])){l=I.meta.data.z[I.segregateVariablesBy[0]].levels}if(I.segregateVariablesBy.length>1&&I.meta.data.z&&I.meta.data.z.hasOwnProperty(I.segregateVariablesBy[1])){j=I.meta.data.z[I.segregateVariablesBy[1]].levels}}if(I.segregateSamplesBy.length){if(I.meta.data.z&&I.meta.data.z.hasOwnProperty(I.segregateSamplesBy[0])){aa=I.meta.data.z[I.segregateSamplesBy[0]].levels}else{if(I.segregateSamplesBy[0]=="sample"){aa=I.data.y.smps}}if(I.segregateSamplesBy.length>1&&I.meta.data.z&&I.meta.data.z.hasOwnProperty(I.segregateSamplesBy[1])){q=I.meta.data.z[I.segregateSamplesBy[1]].levels}}var k=(l.length||1)*(j.length||1)*(aa.length||1)*(q.length||1);if(ab.length&&ab.length==k){return true}else{return false}};var A=function(ag,ae){var ac=[];var ab=ae||I.segregateVariablesBy[ag];var aj=I.meta.data.z[ab].levels;var ap=I.data;if(!Z.hasOwnProperty("Factor")){Z.Factor={}}var ai=0;for(var am=0;am<aj.length;am++){Z.layout[am]=[];var ah=I.meta.data.z[ab].levels[am];Z.Factor[ah]={};var ad=[];for(var al=0;al<I.varIndices.length;al++){var an=I.varIndices[al];if(String(ap.z[ab][an])==ah){ad.push(an)}}ac.push(I.Ev(ad));var q=[];for(var al=0;al<I.smpIndices.length;al++){var an=I.smpIndices[al];var l=[];var ao=[];var aq=ah+":"+ap.y.smps[an];for(var ak=0;ak<ad.length;ak++){var aa=ad[ak];var af=ap.y.data[aa][an];if(typeof af==="number"&&isFinite(af)){l.push(af);ao.push(aa)}}Z.Factor[ah][ap.y.smps[an]]=I.kZ(l,"Factor:"+aq,ao);q.push(Z.Factor[ah][ap.y.smps[an]]);Z.layout[am].push(ai++)}K=K.concat(q)}return ac};if(!this.meta.data.s){this.meta.data.s={}}if(!this.meta.data.s.density){this.meta.data.s.density={}}if(!this.meta.data.s.density.layout){this.meta.data.s.density.layout=[]}if(this.isDOE&&this.meta.data.s.density.hasOwnProperty("DOE")){return b()}else{if(this.meta.data.s.ready&&!this.isDOE){var Q=this.segregateSamplesBy.length+this.segregateVariablesBy.length;if(Q&&!C()){this.meta.data.s={};this.meta.data.s.density={};this.meta.data.s.density.layout=[]}else{return b()}}}if(this.isDOE){if(this.meta.config.user.graphType==this.graphType||this.meta.config.user.graphType==this.meta.data.s.graphType||this.meta.config.user.graphType=="Heatmap"){var X=this.data;var y=this.meta.data.s.graphType||this.meta.config.user.graphType||this.graphType;var Z=this.meta.data.s.density;var d=y.match(/Scatter|Map/)?X.z:X.x;var a=y.match(/Scatter|Map/)?this.Yg("z","Numeric"):this.Yg("x","Numeric");var c=this.data.l.doe;var o=false;if(!Z.hasOwnProperty("DOE")){Z.DOE={}}if(a&&a.length){for(var T=0;T<a.length;T++){var H=a[T];var t=[];var B=[];for(var R=0;R<c.length;R++){var J=d[H][c[R]];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(c[R])}}Z.DOE[H]=this.kZ(t,"DOE:"+H,B);S(Z.DOE[H],"Global-"+H)}}var N=Object.keys(Z.DOE).length;while(N<this.maxDOENumber+1&&!o){if(y.match(/Scatter|^Map/)){for(var T=0;T<X.y.smps.length;T++){var H=X.y.smps[T];var t=[];var B=[];for(var R=0;R<this.varIndices.length;R++){var J=X.y.data[this.varIndices[R]][T];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(this.varIndices[R])}}Z.DOE[H]=this.kZ(t,"DOE:"+H,B);S(Z.DOE[H],"Global-"+H);N++;if(N>this.maxDOENumber){break}}}else{for(var T=0;T<X.y.vars.length;T++){var H=X.y.vars[T];var t=[];var B=[];for(var R=0;R<this.smpIndices.length;R++){var J=X.y.data[T][this.smpIndices[R]];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(this.smpIndices[R])}}Z.DOE[H]=this.kZ(t,"DOE:"+H,B);S(Z.DOE[H],"Global-"+H);N++;if(N>this.maxDOENumber){break}}}o=true}}}else{if(this.graphType.match(/Scatter|Map/)){if(this.segregateVariablesBy.length&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.segregateVariablesBy[0])){var Z=I.meta.data.s.density;var V=A(0);if(this.segregateVariablesBy.length==2||(this.showHistogram!=true&&this.showHistogram!=this.segregateVariablesBy[0])){var e=this.segregateVariablesBy.length==2?this.segregateVariablesBy[1]:this.showHistogram;var U=this.segregateVariablesBy.length==2?A(1):A(false,e);K=[];var h=this.meta.data.z[this.segregateVariablesBy[0]].levels;var f=this.meta.data.z[e].levels;var X=this.data;var N=0;for(var T=0;T<h.length;T++){for(var R=0;R<f.length;R++){Z.layout[N]=[];var G=this.meta.data.z[this.segregateVariablesBy[0]].levels[T];var E=this.meta.data.z[e].levels[R];var r=G+":"+E;Z.Factor[r]={};var z=s(V[T],U[R]);var M=[];for(var P=0;P<this.smpIndices.length;P++){var Y=this.smpIndices[P];var t=[];var B=[];var w=r+":"+X.y.smps[Y];for(var O=0;O<z.length;O++){var D=z[O];var J=X.y.data[D][Y];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(D)}}Z.Factor[r][X.y.smps[Y]]=this.kZ(t,"Factor:"+w,B);M.push(Z.Factor[r][X.y.smps[Y]]);if(this.segregateVariablesBy.length==2){Z.layout[N].push(N++)}else{Z.layout[T].push(N++)}}K=K.concat(M)}}}}else{if((this.segregateSamplesBy.length&&this.segregateSamplesBy[0]=="sample")||(this.scatterPlotMatrix&&this.scatterPlotMatrix!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.scatterPlotMatrix))){var u=this.scatterPlotMatrix?this.scatterPlotMatrix:this.showHistogram;var Z=this.meta.data.s.density;var W=u!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(u)?this.meta.data.z[u].levels:false;var X=this.data;var N=0;if(this.scatterPlotMatrix){var L=this.scatterPlotMatrixType=="all"?this.smpIndices.length+1:this.smpIndices.length;for(var T=0;T<L;T++){for(var R=0;R<L;R++){Z.layout[N++]=[]}}N=0}if(!Z.hasOwnProperty("Samples")){Z.Samples={}}if(W){for(var T=0;T<this.smpIndices.length;T++){if(!this.scatterPlotMatrix){if(!Z.layout[T]){Z.layout[T]=[]}}var F=this.smpIndices[T];Z.Samples[X.y.smps[F]]={};var x=[];for(var R=0;R<W.length;R++){var r=this.meta.data.z[u].levels[R];var z=[];for(var P=0;P<this.varIndices.length;P++){var Y=this.varIndices[P];if(String(X.z[u][Y])==r){z.push(Y)}}var t=[];var B=[];var w=X.y.smps[F]+":"+r;for(var P=0;P<z.length;P++){var Y=z[P];var J=X.y.data[Y][F];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(Y)}}Z.Samples[X.y.smps[F]][r]=this.kZ(t,"Samples:"+w,B);x.push(Z.Samples[X.y.smps[F]][r]);if(this.scatterPlotMatrix){Z.layout[(T*this.smpIndices.length)+(T%this.smpIndices.length)+(this.scatterPlotMatrixType=="all"?T:0)].push(N++)}else{Z.layout[T].push(N++)}}K=K.concat(x)}if(this.scatterPlotMatrixType=="all"){var F=this.smpIndices.length*(this.smpIndices.length+1);var N=0;for(var T=0;T<this.smpIndices.length;T++){for(var R=0;R<W.length;R++){Z.layout[F].push(N++)}F++}}}else{for(var T=0;T<this.smpIndices.length;T++){Z.layout[T]=[];var F=this.smpIndices[T];var t=[];var B=[];for(var R=0;R<this.varIndices.length;++R){var p=this.varIndices[R];var J=X.y.data[p][F];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(p)}}Z.Samples[X.y.smps[F]]=this.kZ(t,"Samples:"+X.y.smps[F],B);Z.layout[T].push(N++);K=K.concat([Z.Samples[X.y.smps[F]]])}}}else{if((this.showHistogram&&this.showHistogram!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showHistogram))||(this.ridgeBy&&this.ridgeBy&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.ridgeBy))){var u=this.ridgeBy?this.ridgeBy:this.showHistogram;var Z=this.meta.data.s.density;var W=this.meta.data.z[u].levels;var X=this.data;var N=0;if(!Z.hasOwnProperty("Factor")){Z.Factor={}}for(var T=0;T<W.length;T++){var r=this.meta.data.z[u].levels[T];Z.Factor[r]={};var z=[];for(var R=0;R<this.varIndices.length;R++){var p=this.varIndices[R];if(String(X.z[u][p])==r){z.push(p)}}for(var R=0;R<this.smpIndices.length;R++){var p=this.smpIndices[R];var t=[];var B=[];var w=r+":"+X.y.smps[p];for(var P=0;P<z.length;P++){var Y=z[P];var J=X.y.data[Y][p];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(Y)}}Z.Factor[r][X.y.smps[p]]=this.kZ(t,"Factor:"+w,B);K.push(Z.Factor[r][X.y.smps[p]])}}}else{if(!this.meta.data.s.density.hasOwnProperty("Variables")){var Z=this.meta.data.s.density;var X=this.data;if(!Z.hasOwnProperty("Samples")){Z.Samples={}}for(var T=0;T<this.smpIndices.length;T++){var F=this.smpIndices[T];var t=[];var B=[];for(var R=0;R<this.varIndices.length;R++){var p=this.varIndices[R];var J=X.y.data[p][F];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(p)}}Z.Samples[X.y.smps[F]]=this.kZ(t,"Samples:"+X.y.smps[F],B);K.push(Z.Samples[X.y.smps[F]])}}}}}}else{var Z=this.meta.data.s.density;var W=this.stackBy&&this.meta.data.x.hasOwnProperty(this.stackBy)?this.meta.data.x[this.stackBy].levels:false;var X=this.data;if(!Z.hasOwnProperty("Variables")){Z.Variables={}}if(W){var x=[];for(var T=0;T<this.varIndices.length;T++){var F=this.varIndices[T];Z.Variables[X.y.vars[F]]={};for(var R=0;R<W.length;R++){var r=this.meta.data.x[this.stackBy].levels[R];var g=[];for(var P=0;P<this.smpIndices.length;P++){var Y=this.smpIndices[P];if(String(X.x[this.stackBy][Y])==r){g.push(Y)}}var t=[];var B=[];var w=X.y.vars[F]+":"+r;for(var P=0;P<g.length;P++){var Y=g[P];var J=X.y.data[F][Y];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(Y)}}Z.Variables[X.y.vars[F]][r]=this.kZ(t,"Variables:"+w,B);x.push(Z.Variables[X.y.vars[F]][r])}K=K.concat(x)}}else{for(var T=0;T<this.varIndices.length;T++){var F=this.varIndices[T];var t=[];var B=[];for(var R=0;R<this.smpIndices.length;R++){var p=this.smpIndices[R];var J=X.y.data[F][p];if(typeof J==="number"&&isFinite(J)){t.push(J);B.push(p)}}Z.Variables[X.y.vars[F]]=this.kZ(t,"Variables:"+X.y.vars[F],B);K.push(Z.Variables[X.y.vars[F]])}}}}if(K.length){if(!Z.hasOwnProperty("Global")){Z.Global={sets:K};S(Z.Global,"Global",Z.layout)}if(Z.Samples&&this.scatterPlotMatrix){Z.Global.Samples={};for(var T in Z.Samples){Z.Global.Samples[T]={sets:[]};for(var R in Z.Samples[T]){Z.Global.Samples[T].sets.push(Z.Samples[T][R])}S(Z.Global.Samples[T],"Global-"+T)}}}this.meta.data.s.ready=true;this.meta.data.s.graphType=this.meta.data.s.graphType||this.graphType;return b()};this.l1=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={loess:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("loess")){this.meta.data.s.loess={}}}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={loess:{}};this.l1(true,e)}}else{this.l1(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showLoessFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showLoessFit)?this.meta.data.z[this.showLoessFit].levels:false;var p=this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;for(var e=0;e<p;e++){var k=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var r=this.axesType=="X"||this.axesType=="XYZ"?0:e;var o=this.xAxisIndices[k]+":"+this.yAxisIndices[r];if(h){for(var d=0;d<h.length;d++){var l=this.lG(this.showLoessFit,h[d],g!=null?this.data.l.comp[g]:false);var q=this.dL(g,k,r,l);if(q[0].length>5){try{b.loess[o+":"+h[d]]=this.nB([q[0],q[1]],"Loess:"+o+":"+h[d]+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.loess[o+":"+h[d]].range[2]);b.maxY=Math.max(b.maxY,b.loess[o+":"+h[d]].range[3])}catch(c){f.push(["setLoessData",q[0].length,o+":"+h[d],c])}}}}else{var l=g!=null?this.data.l.comp[g]:false;var q=this.dL(g,k,r,l);if(q[0].length>5){try{b.loess[o]=this.nB([q[0],q[1]],"Global:"+o+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.loess[o].range[2]);b.maxY=Math.max(b.maxY,b.loess[o].range[3])}catch(c){f.push(["setLoessData",q[0].length,o,c])}}}}}};this.ba=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={regression:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("regression")){this.meta.data.s.regression={}}}if(this.layoutValid&&this.meta.data.s.layout&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={regression:{}};this.ba(true,e)}}else{this.ba(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showRegressionFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showRegressionFit)?this.meta.data.z[this.showRegressionFit].levels:false;var q=this.scatterPlotMatrix?this.data.y.smps.length:this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;if(this.scatterPlotMatrix){for(var e=0;e<q;e++){for(var d=0;d<q;d++){if(e==d){continue}var p=e+":"+d;if(h){for(var c=0;c<h.length;c++){var o=this.lG(this.showRegressionFit,h[c],this.data.l.comp[e]);var s=this.dL(g,e,d,o);if(s[0].length>3){b.regression[p+":"+h[c]]=this.Gs(s[0],s[1],"Regression:"+p+":"+h[c]);b.minY=Math.min(b.minY,b.regression[p+":"+h[c]][4][2]);b.maxY=Math.max(b.maxY,b.regression[p+":"+h[c]][4][3])}else{f.push(["setRegressionData",s[0].length,p+":"+h[c],"Less than 3 values"])}}}else{var o=g!=null?this.data.l.comp[g]:false;var s=this.dL(g,e,d,o);if(s[0].length>3){b.regression[p]=this.Gs(s[0],s[1],"Global:"+p+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[p][4][2]);b.maxY=Math.max(b.maxY,b.regression[p][4][3])}else{f.push(["setRegressionData",s[0].length,p,"Less than 3 values"])}}}}}else{for(var e=0;e<q;e++){var l=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var r=this.axesType=="X"||this.axesType=="XYZ"?0:e;var p=this.xAxisIndices[l]+":"+this.yAxisIndices[r];if(h){for(var d=0;d<h.length;d++){var o=this.lG(this.showRegressionFit,h[d],g!=null?this.data.l.comp[g]:false);var s=this.dL(g,l,r,o);if(s[0].length>3){b.regression[p+":"+h[d]]=this.Gs(s[0],s[1],"Regression:"+p+":"+h[d]+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[p+":"+h[d]][4][2]);b.maxY=Math.max(b.maxY,b.regression[p+":"+h[d]][4][3])}else{f.push(["setRegressionData",s[0].length,p+":"+h[d],"Less than 3 values"])}}}else{var o=g!=null?this.data.l.comp[g]:false;var s=this.dL(g,l,r,o);if(s[0].length>3){b.regression[p]=this.Gs(s[0],s[1],"Global:"+p+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[p][4][2]);b.maxY=Math.max(b.maxY,b.regression[p][4][3])}else{f.push(["setRegressionData",s[0].length,p,"Less than 3 values"])}}}}}};this.Tw=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={quantileRegression:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("quantileRegression")){this.meta.data.s.quantileRegression={}}}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={quantileRegression:{}};this.Tw(true,e)}}else{this.Tw(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showQuantileRegressionFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showQuantileRegressionFit)?this.meta.data.z[this.showQuantileRegressionFit].levels:false;var p=this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;for(var e=0;e<p;e++){var k=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var r=this.axesType=="X"||this.axesType=="XYZ"?0:e;var o=this.xAxisIndices[k]+":"+this.yAxisIndices[r];if(h){for(var d=0;d<h.length;d++){var l=this.lG(this.showQuantileRegressionFit,h[d],g!=null?this.data.l.comp[g]:false);var q=this.dL(g,k,r,l);if(q[0].length>5){try{b.quantileRegression[o+":"+h[d]]=this.ia(q[0],q[1],this.quantiles,"QuantileRegression:"+o+":"+h[d]+(g!=null?":"+g:""));if(this.ZR(b.quantileRegression[o+":"+h[d]])){b.minY=Math.min(b.minY,b.quantileRegression[o+":"+h[d]].range[2]);b.maxY=Math.max(b.maxY,b.quantileRegression[o+":"+h[d]].range[3])}}catch(c){f.push(["setQuantileRegressionData",q[0].length,o+":"+h[d],c])}}}}else{var l=g!=null?this.data.l.comp[g]:false;var q=this.dL(g,k,r,l);if(q[0].length>5){try{b.quantileRegression[o]=this.ia(q[0],q[1],this.quantiles,"Global:"+o+(g!=null?":"+g:""));if(this.ZR(b.quantileRegression[o])){b.minY=Math.min(b.minY,b.quantileRegression[o].range[2]);b.maxY=Math.max(b.maxY,b.quantileRegression[o].range[3])}}catch(c){f.push(["setQuantileRegressionData",q[0].length,o,c])}}}}}};this.yc=function(b,o){if(!b){if(!this.meta.data.s||(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length)){if(!this.meta.data.s){this.meta.data.s={areas:{},layout:[]}}}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var f=0;f<this.data.l.comp.length;f++){this.meta.data.s.layout[f]={areas:{}};this.yc(true,f)}}else{this.yc(true)}}else{var c=o!=null?this.meta.data.s.layout[o]:this.meta.data.s;var g=[];var p=this.meta.data.z[this.colorBy].levels;var h=this.l4(this.Q8(this.xAxisIndices[0],"x")).sort(function(u,j){return u-j});for(var f=0;f<p.length;f++){var r=this.lG(this.colorBy,p[f]);if(r.length==0){delete c.areas[p[f]];continue}var l=this.Q8(this.xAxisIndices[0],"x",r).sort(function(u,j){return u-j});var d=this.Q8(this.yAxisIndices[0],"y",r).sort(function(u,j){return l[u]-l[j]});var s=0;var t=[[],[]];for(var e=0;e<h.length;e++){var r=l.indexOf(h[e]);if(r>=0){t[0].push(l[r]);t[1].push(d[r]);s=r}else{if(e==0){t[0].push(h[e]);t[1].push(h[e]<l[0]?NaN:0)}else{if(s<d.length){t[0].push(h[e]);t[1].push(this.BT(h[e-1],d[s],h[e+1],d[s+1],h[e]))}else{t[0].push(h[e]);t[1].push(NaN)}}}}c.areas[p[f]]=t}for(var f=0;f<p.length;f++){var q=c.areas[p[f]];if(q){for(e=0;e<h.length;e++){if(!g[e]){g[e]=0}if(!isNaN(c.areas[p[f]][1][e])){g[e]+=c.areas[p[f]][1][e]}}}}c.totals=g;var k=Number.NEGATIVE_INFINITY;for(var f in g){k=Math.max(k,g[f])}c.minY=0;c.maxY=k}};this.b8=function(p,D){if(!p){if(!this.meta.data.s||(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length)){if(!this.meta.data.s){this.meta.data.s={wiggles:{},layout:[]};this.b8(true)}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var y=0;y<this.data.l.comp.length;y++){this.meta.data.s.layout[y]={wiggles:{}};this.b8(true,y)}}}}else{var b=D!=null?this.meta.data.s.layout[D]:this.meta.data.s;var u=[];var s=this.colorBy?this.meta.data.z[this.colorBy].levels:this.yAxis;var k=this.l4(this.Q8(this.xAxisIndices[0],"x")).sort(function(l,j){return l-j});var C=Number.POSITIVE_INFINITY;var B=Number.NEGATIVE_INFINITY;var z=Number.NEGATIVE_INFINITY;var o=this.meta.console;for(var y=0;y<s.length;y++){var q=this.colorBy?this.lG(this.colorBy,s[y],D!=null?this.data.l.comp[D]:false):false;var r=this.Q8(this.xAxisIndices[0],"x",q);var E=this.colorBy?this.Q8(this.yAxisIndices[0],"y",q):this.Q8(this.yAxisIndices[y],"y",q);var g=[[],[]];for(var w=0;w<k.length;w++){var q=r.indexOf(k[w]);if(q>=0){g[0].push(r[q]);g[1].push(E[q])}else{g[0].push(k[w]);g[1].push(0)}}if(r.length>5){this.loessSpan=this.scatterStreamBandwidth?Math.max(0.1,this.scatterStreamBandwidth-0.45):0.3;try{var t=this.nB([g[0],g[1]],"Stream"+s[y]+(D!=null?D:""));for(var w=0;w<t.y.length;w++){t.y[w]=Math.max(t.y[w],0);z=Math.max(z,t.y[w])}C=Math.min(C,t.x[0]);B=Math.max(B,t.x[t.x.length-1]);b.wiggles[s[y]]=t}catch(f){o.push(["setStreamData",r.length,s[y],f])}}}var r=[];var h=(B-C)/(this.scatterStreamNumber-1);var x=(B-C)*this.scatterStreamExtraSpan;var A=z/500;for(var y=C-(this.scatterStreamTrueRange.match(/none|min_x/)?x:0);y<=B+(this.scatterStreamTrueRange.match(/none|max_x/)?x:0);y+=h){r.push(y)}for(var y=0;y<s.length;y++){var t=b.wiggles[s[y]];if(t&&t.x&&t.y){var d=this.Ev(t.x);var c=this.Ev(t.y);d.unshift(C-x);d.push(B+x);c.unshift(0);c.push(0);var e=this.CJ(d,c,r);for(var w=0;w<e[1].length;w++){e[1][w]=Math.max(e[1][w],A)}b.wiggles[s[y]].stream={x:e[0],y:e[1]};for(w=0;w<e[0].length;w++){if(!u[w]){u[w]=0}u[w]+=Math.abs(e[1][w]*0.5)}}}b.totals=u;var a=Number.NEGATIVE_INFINITY;for(var y in u){a=Math.max(a,u[y])}b.minY=-a;b.maxY=a}};this.hE=function(g){var d=Number.POSITIVE_INFINITY;var a=Number.NEGATIVE_INFINITY;var e=this.varIndices.length;for(var c=0;c<e;c++){var f=this.smpIndices.length;for(var b=0;b<f;b++){var h=g[this.varIndices[c]][this.smpIndices[b]];if(!isNaN(h)){d=Math.min(h,d);a=Math.max(h,a)}}}d=d==Number.POSITIVE_INFINITY||d==Number.NEGATIVE_INFINITY?-1:d;a=a==Number.NEGATIVE_INFINITY||a==Number.POSITIVE_INFINITY?1:a;return[d,a]};this.HS=function(){var d=this.data.y;if(this.isGroupedData){this.data.w={};d=this.data.w}var b=["vars","smps","labs","glab","desc","data","mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","trans","tstdev","cor","min","max","sum","count","grps","grpIdxs","factors","scale"];var c=b.length;for(var a=0;a<c;a++){if(!d[b[a]]){if(b[a]=="factors"){d[b[a]]={}}else{d[b[a]]=[]}}}d.iqr=d.median};this.WR=function(a){var c=["mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","cor","min","max","sum","count","grps","grpIdxs","factors","scale"];var d=c.length;if(this.isGroupedData){if(!this.isTransformedData){c.push("trans");c.push("tstdev")}d=c.length;for(var b=0;b<d;b++){delete (this.data.y[c[b]])}delete (this.data.w)}else{if(!this.isTransformedData){c.push("trans");c.push("tstdev")}d=c.length;if(this.isRawData){for(var b=0;b<d;b++){delete (this.data.y[c[b]])}}else{}}if(a&&this.isRawData){this.HS()}};this.Fc=function(f,I){var b=this.isGroupedData?this.data.w:this.data.y;var h=this.isGroupedData?false:true;var A=Number.POSITIVE_INFINITY;var z=Number.NEGATIVE_INFINITY;if(!this.isGroupedData){this.HS()}var d=["trans","tstdev","mean","median","stdev","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","n","min","max","sum","count","scale"];var E=function(j,c){if(!b[j][c]){b[j][c]=[]}};if(f=="gantt"){if(!this.data.gantt){this.isGanttDataFormated=false;this.ww()}var G=this.as(this.ganttStart);var F=this.as(this.ganttEnd);var K=this.v8(this.data.gantt);A=K[G].sort(function(j,c){return j-c})[0];z=K[F].sort(function(j,c){return c-j})[0];b.min=[[A]];b.max=[[z]];b.scale=this[this.axisAlgorithm](A,z,5,this.isGraphTime,this.axisWilkinsonLoose)}else{if(f=="cor"){this.isBoxplotCalc=false;if(this.correlationAxis=="samples"){if(this.isGroupedData&&b.cor.length==0){this.Ab(true,true,true)}var r=this.isGroupedData?this.grpIndices:this.smpIndices;var l=r.length;for(var G=0;G<l;G++){var w=r[G];var s=this.et(w);if(!b.cor[w]){b.cor[w]=[]}var g=r.length;for(var F=G;F<g;F++){var H=r[F];if(!b.cor[H]){b.cor[H]=[]}var q=this.et(H);if(G==F){if(this.isTransformedData){b.trans[w][H]=1}b.cor[w][H]=1}else{b.cor[w][H]=this.dy(s,q);b.cor[H][w]=b.cor[w][H];if(this.isTransformedData){b.trans[w][H]=b.cor[w][H];b.trans[H][w]=b.cor[H][w]}}A=Math.min(A,b.cor[w][H]);z=Math.max(z,b.cor[w][H])}}}else{var l=this.varIndices.length;for(var G=0;G<l;G++){var w=this.varIndices[G];if(!b.cor[w]){b.cor[w]=[]}var g=this.varIndices.length;for(var F=G;F<g;F++){var H=this.varIndices[F];if(!b.cor[H]){b.cor[H]=[]}if(G==F){b.cor[w][H]=1;if(this.isTransformedData){b.trans[w][H]=1}}else{b.cor[w][H]=this.dy(b.data[w],b.data[H],h);b.cor[H][w]=b.cor[w][H];if(this.isTransformedData){b.trans[w][H]=b.cor[w][H];b.trans[H][w]=b.cor[H][w]}}A=Math.min(A,b.cor[w][H]);z=Math.max(z,b.cor[w][H])}}}b.min=[A];b.max=[z];b.scale=this[this.axisAlgorithm](A,z,5,this.isGraphTime,this.axisWilkinsonLoose)}else{this.isBoxplotCalc=f=="iqr"?true:false;var l=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var G=0;G<l;G++){var a;var w=this.varIndices[G];if(w==undefined){continue}var u=d.length;for(var F=0;F<u;F++){E(d[F],w)}if(this.isGroupedData){if(!I){var y=this.isTransformedData?this.data.y.trans:this.data.y.data;a=[];var p=this.data.w.grps.length;for(var F=0;F<p;F++){a[F]=[];var o=this.data.w.grps[F].length;for(var D=0;D<o;D++){var e=this.data.w.grps[F][D];a[F].push(y[w][e])}}}else{a=I[w]}}else{b.grps=[];a=[];var g=this.smpIndices.length;for(var F=0;F<g;F++){var H=this.smpIndices[F];b.grps[F]=[];b.grps[F].push(H);a[F]=[this.isTransformedData&&b.trans?b.trans[w][H]:b.data[w][H]]}}if(f=="iqr"){this.summaryType="iqr";if(this.isRawData){if(!this.isGroupedData){var g=this.smpIndices.length;for(var F=0;F<g;F++){var H=this.smpIndices[F];if(this.isTransformedData){b.trans[w][F]=a[F][0]}b.mean[w][H]=a[F][0];b.median[w][H]=a[F][0];b.qtl1[w][H]=a[F][0];b.qtl3[w][H]=a[F][0];b.iqr1[w][H]=a[F][0];b.iqr3[w][H]=a[F][0];b.out[w][H]=[];b.n[w][H]=1;b.conf[w][H]=[];b.min[w][H]=a[F][0];b.max[w][H]=a[F][0]}}else{var u=a.length;for(var F=0;F<u;F++){var x=this.RD(a[F]);if(this.isTransformedData){b.trans[w][F]=x[1]}b.mean[w][F]=x[0];b.median[w][F]=x[2];b.qtl1[w][F]=x[1];b.qtl3[w][F]=x[3];b.iqr1[w][F]=x[4];b.iqr3[w][F]=x[5];b.out[w][F]=x[6];b.n[w][F]=x[7];b.conf[w][F]=x[8]?x[8]:[];b.min[w][F]=x[9]?x[9][0]:NaN;b.max[w][F]=x[9]?x[9][1]:NaN}}}b.iqr=b.median}else{if(f=="median"){this.summaryType="median";if(this.isRawData){var u=a.length;for(var F=0;F<u;F++){var C=this.XV(a[F],h);var B=this.Wj(a[F],h);var x=this.XX(a[F],h);if(this.isTransformedData){b.trans[w][F]=x[1]}b.min[w][F]=C;b.max[w][F]=B;b.median[w][F]=x[0];b.n[w][F]=x[1]}}}else{if(f=="mean"||f=="raw"){this.summaryType="mean";if(this.isRawData){var u=a.length;for(var F=0;F<u;F++){var C=this.XV(a[F],h);var B=this.Wj(a[F],h);var x=this.Lq(a[F],h);if(this.isTransformedData){b.trans[w][F]=x[0];b.tstdev[w][F]=x[1]}b.min[w][F]=C;b.max[w][F]=B;b.mean[w][F]=x[0];b.stdev[w][F]=x[1];b.n[w][F]=x[2]}}}else{if(f=="min"||f=="max"){this.summaryType=f;if(this.isRawData){var u=a.length;for(var F=0;F<u;F++){var C=this.XV(a[F],h);var B=this.Wj(a[F],h);if(this.isTransformedData){b.trans[w][F]=B}b.min[w][F]=C;b.max[w][F]=B;b.n[w][F]=a[F].length}}}else{if(f=="sum"){this.summaryType="sum";if(this.isRawData){var u=a.length;for(var F=0;F<u;F++){var J=this.Nk(a[F],h);if(this.isTransformedData){b.trans[w][F]=J}b.min[w][F]=0;b.max[w][F]=J;b.sum[w][F]=J;b.n[w][F]=a[F].length}}}else{if(f=="count"){this.summaryType="count";if(this.isRawData){var u=a.length;for(var F=0;F<u;F++){var t=a[F].length;if(this.isTransformedData){b.trans[w][F]=t}b.min[w][F]=0;b.max[w][F]=t;b.count[w][F]=t;b.n[w][F]=t}}}}}}}}}if(f=="iqr"){for(var G=0;G<b.n.length;G++){if(b.n[G]){for(var F=0;F<b.n[G].length;F++){b.nfac[G][F]=Math.sqrt((b.n[G][F])/(this.smpIndices.length))*2}}}}for(var G=0;G<b.min.length;G++){if(b.min[G]){for(var F=0;F<b.min[G].length;F++){A=Math.min(A,b.min[G][F]);z=Math.max(z,b.max[G][F])}}}b.scale=this[this.axisAlgorithm](A,z,this.xAxisTicks,this.isGraphTime,this.axisWilkinsonLoose)}}};this.H6=function(){var e=this.isGroupedData?this.data.w:this.data.y;var d;for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];e.data[c]=[];e.trans[c]=[];if(this.summaryType=="mean"){for(var a=0;a<e.mean[c].length;a++){e.data[c][a]=e.mean[c][a]}}else{if(this.summaryType=="median"||this.summaryType=="iqr"){for(var a=0;a<e.median[c].length;a++){e.data[c][a]=e.median[c][a]}}else{if(this.summaryType=="sum"){for(var a=0;a<e.sum[c].length;a++){e.data[c][a]=e.sum[c][a]}}else{if(this.summaryType=="max"){for(var a=0;a<e.max[c].length;a++){e.data[c][a]=e.max[c][a]}}else{if(this.summaryType=="min"){for(var a=0;a<e.min[c].length;a++){e.data[c][a]=e.min[c][a]}}else{if(this.summaryType=="count"){for(var a=0;a<e.count[c].length;a++){e.data[c][a]=e.count[c][a]}}}}}}}if(!d){d=c}}return d};this.xQ=function(b,c,a){switch(b){case"log2":return a?Math.pow(2,c):Math.log(c)/Math.LN2;case"log10":return a?Math.pow(10,c):Math.log(c)/Math.LN10;case"-log2":return a?-Math.pow(2,c):-Math.log(c)/Math.LN2;case"-log10":return a?-Math.pow(10,c):-Math.log(c)/Math.LN10;case"exp2":return a?Math.log(c)/Math.LN2:Math.pow(2,c);case"exp10":return a?Math.log(c)/Math.LN10:Math.pow(10,c);case"sqrt":return a?c*c:Math.sqrt(c);default:return c}};this.Ux=function(e,d,a,c){if(this.PU()||this.graphType.match(/Area/)){return}if(!this.isGroupedData){this.HS()}var b=this.transformData;this.transformData=e;this.transformAxis=d;this.xAxisMaxStrLength=false;this.xAxis2MaxStrLength=false;this.yAxisMaxStrLength=false;this.zAxisMaxStrLength=false;if(e=="reset"||e=="undo"){this.Zl();this.transformData=false;this.isTransformedData=false;if(this.tempIndices){if(this.isGroupedData){this.grpIndices=this.tempIndices}else{this.smpIndices=this.tempIndices}this.tempIndices=false}}else{if(e=="save"){this.HV();this.transformData=false;this.isTransformedData=false}else{if(e=="log2"||e=="log10"||e=="-log2"||e=="-log10"||e=="exp2"||e=="exp10"||e=="sqrt"){if(this.Jb(e)){this.isTransformedData=e}else{this.transformData=b;return}}else{if(e=="ratio2"||e=="ratio10"){this.kX(e,a);this.isTransformedData=e}else{this.Ph(e,d,!this.isRawData||this.isGroupedData?this.H6():0);this.isTransformedData=e}}}}delete (this.meta.def.colorBrew);if(this.graphType=="Boxplot"){this.summarizeBoxplot=true}this.pI();if(!c){this.Oj({func:"transform",par:[e,d,a,c]})}};this.Zl=function(){var d=this.data.y;for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];for(var a=0;a<d.data[c].length;a++){if(d.trans&&d.trans[c]&&!isNaN(d.data[c][a])){d.trans[c][a]=d.data[c][a]}}}if(this.isGroupedData){this.isTransformedData=false;this.cg(this.groupingFactors,false,false,false,true)}};this.HV=function(){var a=this.isGroupedData?this.groupingFactors:false;var e=this.data.y;if(e.trans&&e.trans.length>0){this.Ab();for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];for(var b=0;b<e.data[d].length;b++){if(!isNaN(e.data[d][b])){e.data[d][b]=e.trans[d][b]}}}if(a){this.isTransformedData=false;this.cg(a,false,false,false,true)}}};this.Jb=function(e){var g=this.data.y;var a=this.ob(g.data);if(e.match(/log/)){if(a[0]<=0){if(!this.nanOmit){alert("Cannot log transform values <= 0");return false}else{this.fo("Dropping values <= 0");alert("Dropping values <= 0")}}e=e=="log2"?"log2":e=="-log2"?"-log2":e=="-log10"?"-log10":"log10"}else{if(e.match(/exp/)){if(a[1]>=1000){alert("Cannot exp transform values > 1000");return false}e=e=="exp2"?"exp2":"exp10"}}if(!g.trans){g.trans=[]}if(!g.tstdev){g.tstdev=[]}var f=this.motionBy?this.data.y.vars.length:this.isGroupedData?this.data.y.vars.length:!this.isDOE?this.data.y.vars.length:this.varIndices.length;for(var c=0;c<f;c++){var d=this.motionBy||!this.isDOE?c:this.varIndices[c];if(!g.trans[d]){g.trans[d]=[]}if(!g.tstdev[d]){g.tstdev[d]=[]}for(var b=0;b<g.data[d].length;b++){if(!isNaN(g.data[d][b])){if(e=="log2"){this.transformBase=2;g.trans[d][b]=Math.log(g.data[d][b])/Math.LN2}else{if(e=="log10"){this.transformBase=10;g.trans[d][b]=Math.log(g.data[d][b])/Math.LN10}else{if(e=="-log2"){this.transformBase=2;g.trans[d][b]=-Math.log(g.data[d][b])/Math.LN2}else{if(e=="-log10"){this.transformBase=10;g.trans[d][b]=-Math.log(g.data[d][b])/Math.LN10}else{if(e=="exp2"){this.transformBase=2;g.trans[d][b]=Math.pow(2,g.data[d][b])}else{if(e=="exp10"){this.transformBase=10;g.trans[d][b]=Math.pow(10,g.data[d][b])}else{if(e=="sqrt"){g.trans[d][b]=Math.sqrt(g.data[d][b])}}}}}}}}}}if(this.isGroupedData){this.isTransformedData=e;this.cg(this.groupingFactors,false,false,true,true)}return true};this.kX=function(){var h=[];var p=this.data;var a=this.isGroupedData&&!this.graphType.match(/dotplot|boxplot/i)?p.w:p.y;if(this.isGroupedData&&this.ratioGroupReference&&p.x.hasOwnProperty(this.ratioGroupReference)){if(!this.ratioLevelReference){for(var u=0;u<p.x[this.ratioGroupReference].length;u++){if(p.x[this.ratioGroupReference][u]!=null){this.ratioLevelReference=p.x[this.ratioGroupReference][u];break}}}if(this.groupingFactors.length==1){this.ratioReference=this.sF(this.ratioLevelReference);if(this.ratioReference<0){this.ratioLevelReference=p.w.smps[0];this.ratioReference=0}h=[this.ratioReference]}else{var f=[];for(var u=0;u<this.groupingFactors.length;u++){if(this.groupingFactors[u]!=this.ratioGroupReference){f.push(this.groupingFactors[u])}}var b={};var x=[];var t=0;for(var u=0;u<this.smpIndices.length;u++){var k=this.smpIndices[u];var o=[];var A;for(var s=0;s<f.length;s++){var w=f[s];A=p.x[w][k];if(!A){A="NA"}o.push(A)}A=o.join(" - ");if(!b.hasOwnProperty(A)){p.w.smps.push(A);x[t]=A;b[A]=[];b[A].push(k);t++}else{b[A].push(k)}}h=this.hA(this.ratioGroupReference,this.ratioLevelReference);this.ratioReference=[];for(var u=0;u<p.w.grps.length;u++){var g=p.w.grps[u][0];var q=false;for(var r in b){for(var s=0;s<b[r].length;s++){if(g==b[r][s]){q=this.Fe(b[r]);break}}if(q){break}}for(var s=0;s<h.length;s++){if(q.hasOwnProperty(h[s])){this.ratioReference.push(h[s]);break}}}}}else{if(this.ratioSampleReference){var y=this.isGroupedData&&this.graphType.match(/dotplot|boxplot/i);if(y){this.isGroupedData=false;this.ratioReference=this.sF(this.ratioSampleReference);this.isGroupedData=true}else{this.ratioReference=this.sF(this.ratioSampleReference)}}if(this.ratioReference<0){this.ratioSampleReference=p.y.smps[0];this.ratioReference=0}h=[this.ratioReference]}for(var u=0;u<this.varIndices.length;u++){var k=this.varIndices[u];if(!a.trans){a.trans=[]}if(!a.stdev){a.stdev=[]}if(!a.trans[k]){a.trans[k]=[]}if(!a.stdev[k]){a.stdev[k]=[]}for(var s=0;s<a.data[k].length;s++){var e;if(this.isGroupedData&&this.ratioGroupReference&&p.x.hasOwnProperty(this.ratioGroupReference)){if(this.groupingFactors.length==1){e=p.w.mean[k][this.ratioReference]}else{e=p.w.mean[k][this.ratioReference[s]]}}else{e=a.data[k][this.ratioReference]}if(!isNaN(a.data[k][s])&&!isNaN(e)&&e>0){var c=this.transformBase==2?"ratio2":"ratio10";var z=a.data[k][s]/e;var d=a.stdev[k][s];if(c=="ratio2"){a.trans[k][s]=Math.log(z)/Math.LN2;if(d&&d>0){a.tstdev[k][s]=Math.log(d)/Math.LN2}}else{if(c=="ratio10"){a.trans[k][s]=Math.log(z)/Math.LN10;if(d&&d>0){a.tstdev[k][s]=Math.log(d)/Math.LN10}}}}}}};this.Ph=function(s,p,o){var c=this.isGroupedData&&!this.graphType.match(/dotplot|boxplot/i)?this.data.w:this.data.y;var k=this.isGroupedData?false:true;var q;p=p?p:this.transformAxis;if(p=="samples"){for(var g=0;g<c.data[o].length;g++){var b=[];for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];b.push(c.data[h][g])}if(s=="percentile"){q=this.aC(b)}else{if(s=="zscore"){q=this.Lq(b,k)}}for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];if(!c.trans){c.trans=[]}if(!c.trans[h]){c.trans[h]=[]}if(!isNaN(c.data[h][g])){if(s=="percentile"){c.trans[h][g]=this.an(q[0],q[1],c.data[h][g])}else{if(s=="zscore"){c.trans[h][g]=(c.data[h][g]-q[0])/q[1]}}}}}}else{for(var g=0;g<this.varIndices.length;g++){var r=this.varIndices[g];if(!c.trans){c.trans=[]}if(!c.trans[r]){c.trans[r]=[]}var b=c.data[r];if(s=="percentile"){q=this.aC(b)}else{if(s=="zscore"){q=this.Lq(b,k)}}for(var d=0;d<b.length;d++){if(!isNaN(c.data[r][d])){if(s=="percentile"){c.trans[r][d]=this.an(q[0],q[1],c.data[r][d])}else{if(s=="zscore"){c.trans[r][d]=(c.data[r][d]-q[0])/q[1]}}}}}}};this.bD=function(c){var d=this.Ev(this.segregateSamplesBy);var b=this.Ev(this.segregateVariablesBy);this.a5(true);this.cg(c,false,false,true,true,true);this.Ej(b,d,true)};this.cg=function(ah,R,r,ac,c,C,ai){var L=this;if(this.PU()){return}if(!this.isRawData){return}var af=this.data;if(!this.Hl(ah)){ah=[ah]}else{ah=this.l4(ah)}if(!ah||ah.length<1||!af.x){return this.Ab()}if(ah.length>1&&ah.includes("__FACTOR__")){ah=ah.filter(function(a){return a!="__FACTOR__"})}for(var Y=0;Y<ah.length;Y++){if(!ah||!af.x[ah[Y]]){return this.Ab()}}if(!this.isDOE&&this.layoutComb&&af.l&&!this.eI(af.l.group,ah)){this.bD(ah);af.l.group=ah;if(!c){this.Oj({func:"groupSamples",par:[ah,R,r,ac,c,C,ai]})}return}if(af.l&&af.l.group){af.l.group=ah}var w={};var P={};var f=this.Fe(this.smpOverlays);var z=af.w&&af.w.smps?af.w.smps:false;var D=this.Ev(this.hiddenGrps);if(!this.isDOE&&!ac){this.Ff(true)}if(!ac){this.Ff()}this.isGroupedData=true;this.groupingFactors=ah;this.WR(true);this.hiddenGrps=ai?D:[];this.isGroupedData=false;var al=this.smpIndices.length;for(var Y=0;Y<al;Y++){var y=this.smpIndices[Y];var G=[];var q=[];var B;var U;for(var X=0;X<ah.length;X++){var M=ah[X];B=this.mU(y,"x",M);if(this.meta.data.x[M].type=="Numeric"){B=B||"null"}else{B=B===false?"false":(B||"null")}G.push(B);if(!f.hasOwnProperty(M)){q.push(B)}}B=G.join(" :: ");U=q.length>0?q.join(" :: "):"";if(!w.hasOwnProperty(B)){af.w.smps.push(B);P[B]=U;w[B]=[]}w[B].push(y)}this.isGroupedData=true;if(af.w.smps.length<1){af.w.smps=z;this.Oj({func:"groupSamples",par:[ah,R,r,ac,c,C,ai]});return}if(this.isCxplot&&ah.length==1&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(ah[0])&&this.meta.data.x[ah[0]].levels&&this.meta.data.x[ah[0]].type!="Numeric"){if(this.sortIncludeEmpty){if(this.meta.config.user.aes.hasOwnProperty("meta")){if(ah[0]==this.meta.config.user.aes.x&&this.meta.config.user.aes.meta.hasOwnProperty("xLabels")){var Z=this.Ev(this.meta.config.user.aes.meta.xLabels);var ab=false;for(var Y=0;Y<Z.length;Y++){if(this.meta.data.x[ah[0]].levels.includes(Z[Y])){continue}else{ab=true}}af.w.smps=ab?this.Ev(this.meta.data.x[ah[0]].levels):Z}else{if(ah[0]==this.meta.config.user.aes.y&&this.meta.config.user.aes.meta.hasOwnProperty("yLabels")){var Z=this.Ev(this.meta.config.user.aes.meta.yLabels);var ab=false;for(var Y=0;Y<Z.length;Y++){if(this.meta.data.x[ah[0]].levels.includes(Z[Y])){continue}else{ab=true}}af.w.smps=ab?this.Ev(this.meta.data.x[ah[0]].levels):Z}else{af.w.smps=this.Ev(this.meta.data.x[ah[0]].levels)}}}else{af.w.smps=this.Ev(this.meta.data.x[ah[0]].levels)}}}else{if(this.isCxplot&&ah.length==2&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(ah[0])&&this.meta.data.x[ah[0]].levels&&this.meta.data.x[ah[0]].type!="Numeric"&&this.meta.data.x.hasOwnProperty(ah[1])&&this.meta.data.x[ah[1]].levels&&this.meta.data.x[ah[1]].type!="Numeric"){if(this.sortIncludeEmpty){var l=this.meta.data.x;af.w.smps=this.Ev(af.w.smps.sort(function(s,k){var t=s.split(" :: ");var j=k.split(" :: ");var d=l[ah[0]].levels.indexOf(t[0]);var a=l[ah[0]].levels.indexOf(j[0]);if(d==a){d=l[ah[1]].levels.indexOf(t[1]);a=l[ah[1]].levels.indexOf(j[1])}return d-a}))}}else{if(this.sortOnGrouping){if(this.sortOnGrouping=="size"){af.w.smps.sort(function(j,d){return w[j].length-w[d].length})}else{if(this.sortOnGrouping=="descending"){af.w.smps.sort().reverse()}else{af.w.smps.sort()}}}}}var al=af.w.smps.length;for(var Y=0;Y<al;Y++){var B=af.w.smps[Y];af.w.labs.push(P[B]);af.w.grps.push(w[B]);af.w.grpIdxs.push(Y)}this.grpIndices=[];if(r){var al=r.length;for(var Y=0;Y<al;Y++){this.grpIndices.push(r[Y]);if(!ai){this.hiddenGrps.push(false)}}}else{var al=af.w.grps.length;for(var Y=0;Y<al;Y++){this.grpIndices.push(Y);if(!ai){this.hiddenGrps.push(false)}}}var al=this.varIndices.length;var T=af.w.vars;for(var Y=0;Y<al;Y++){T.push(af.y.vars[this.varIndices[Y]])}var S={};var h=this.meta.data.x;for(var B in af.x){S[B]=h[B].type=="Numeric"}var al=af.w.grps.length;for(var Y=0;Y<al;Y++){var E=af.w.grps[Y];var aj=E?E.length:0;for(var B in af.x){var g=af.x[B];var ad=af.w.factors[B];if(!ad){ad=af.w.factors[B]=[]}var J;if(S[B]){J=[];for(var X=0;X<aj;X++){var H=g[E[X]];if(!isNaN(H)){J.push(H)}}ad.push(this.V6(J))}else{J={};for(var X=0;X<aj;X++){var H=g[E[X]];if(H!=null&&H!==""){J[H]=true}}var A=this.iH(J);ad.push(A.join(" + "))}}}var aa=this.meta.data.x;for(var B in af.x){if(aa[B]["boolean"]){var ad=af.w.factors[B];var x=ad.length;for(var Y=0;Y<x;Y++){ad[Y]=ad[Y]!=="false"}}}var S=[];if(R){S=this.Hl(R)?R:[R]}else{R=this.graphType=="Boxplot"?"iqr":this.graphType.match(/Stacked/i)?"sum":this.summaryType?this.summaryType:"mean";S.push(R)}var F=this.isTransformedData;var u=this.summaryType;var e=af.y;for(var Q=0,I=S.length;Q<I;Q++){var o=[];var ak=S[Q];var V=F?e.trans:true;var ae;if(F&&e.trans){ae=e.trans?e.trans:this.data.y.trans}else{if(this.isRawData){ae=e.data}else{ae=e[u]||e[this.summaryType]}}var al=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var Y=0;Y<al;Y++){var K=this.varIndices[Y];if(K==undefined){continue}var O=o[K]=[];var p=af.w.grps;var aj=p.length;for(var X=0;X<aj;X++){var b=O[X]=[];var N=p[X];var ag=N?N.length:0;for(var W=0;W<ag;W++){b.push(ae[K][N[W]])}}}this.Fc(ak,o)}this.Mk();this.C6(false,false,false,!this.layoutComb);if(!C){this.xAxisValues=[];this.xAxis2Values=[];this.yAxisValues=[];this.zAxisValues=[];if(!this.layoutComb||!this.layoutAdjust){if(typeof(this.setAxes)=="function"){this.kv()}}}if(!V){this.Jb(this.isTransformedData)}if(!c){this.Oj({func:"groupSamples",par:[ah,R,r,ac,c,C,ai]})}};this.Ab=function(f,c,a){if(this.PU()){return}var b=this.groupingFactors.length==1&&this.groupingFactors[0]=="__FACTOR__";if(!this.isGroupedData&&!this.groupingFactors.length){return}this.Ff(true);this.isGroupedData=false;var e=this.data;if(e.l){delete (e.l.group)}if(e.w&&!a){delete (e.w)}this.groupingFactors=[];this.hiddenGrps=[];this.FV("w");if(!c){this.C6(false,false,false,true)}if(this.summaryType=="iqr"&&b){this.summaryType="raw";this.graphType="Bar"}if(!f){this.Oj({func:"ungroupSamples",par:[f,c,a]})}return};this.HJ=function(){this.isGroupedData=false;this.cg(this.groupingFactors,false,false,false,true)};this.zV=function(){var a={data:this.v8(this.data),config:this.Ei()};if(this.toDoPivot){a.config.colorBy=this.toDoPivot;a.config.groupingFactors.push(this.toDoPivot)}a.config.groupingFactors=this.Ev(this.groupingFactors);a.config.segregateVariablesBy=this.Ev(this.segregateVariablesBy);a.config.segregateSamplesBy=this.Ev(this.segregateSamplesBy);return a};this.hW=function(b){this.Hp();if(this.PU()){return}if(this.isPivot){var a=this.v8(this.data.y.unpivoted);this.colorBy=a.config.colorBy;this.a5(true);if(this.isGroupedData){this.Ab(true)}this.jY(a.data,true);if(a.config.groupingFactors.length){this.cg(a.config.groupingFactors,false,false,false,true)}this.isPivot=false;if(a.config.segregateVariablesBy.length||a.config.segregateSamplesBy.length){this.Ej(a.config.segregateVariablesBy,a.config.segregateSamplesBy,true)}if(!b){this.Oj({func:"removePivot",par:[b]})}}this.HF()};this.qO=function(e,h){this.Hp();if(this.PU()){return}var b=this.zV();this.isPivot=true;this.colorBy=false;var f={y:{data:[],vars:[],smps:[]}};this.a5(true);if(this.isGroupedData){this.Ab(true)}var g=e.shift();for(var d=0;d<e.length;d++){f.y.vars.push(e[d][0]);var a=[];for(var c=1;c<g.length;c++){a.push(e[d][c])}f.y.data.push(a)}g.shift();f.y.smps=g;this.jY(f,true);this.data.y.unpivoted=b;if(b.config.segregateVariablesBy.length||b.config.segregateSamplesBy.length){this.Ej(b.config.segregateVariablesBy,b.config.segregateSamplesBy,true)}this.WR();if(b.config.groupingFactors.length){this.groupingFactors=this.Ev(b.config.groupingFactors);this.gg([cat],true,"groupingFactors")}if(!h){this.Oj({func:"pivot",par:[e,h]})}this.HF()};this.Qs=function(e,f){this.Hp();if(this.PU()){return}if(this.isPivot||!this.TU()){return}var y=this.zV();var N={y:{vars:[],smps:[],data:[]}};var b=function(c){var d=[];for(var k=0;k<h.length;k++){if(h[k]!=e){var j=L.x[h[k]][c];if(j===false){j="false"}else{if(j===null){j="null"}else{if(j===true){j="true"}}}d.push(j.toString().replace("\x00",""))}}return d.length?d.join("\x00"):"x"+c};this.a5(true);if(this.isGroupedData){this.Ab(true)}var h=this.hj(this.data.x);var G=this.meta.data.x[e];var L=this.data;var r=G.levels;var H=r.length;var B=[];var A={};for(var K=0;K<H;K++){B[K]={};for(var J=0;J<L.y.smps.length;J++){var s=L.x[e][J];if(s===false){s="false"}else{if(s===null){s="null"}else{if(s===true){s="true"}}}if(s==r[K]){var M=b(J);if(!B[K][M]){B[K][M]=[]}B[K][M].push(J)}if(M!=null){A[M]=true}}}for(var M in A){var g=0;for(var K=0;K<H;K++){if(B[K].hasOwnProperty(M)){g=Math.max(g,B[K][M].length)}}A[M]=g}for(var K=0;K<H;K++){for(J=0;J<L.y.vars.length;J++){N.y.data[K+J]=[];if(L.y.vars.length==1){N.y.vars.push(r[K].replace("\x00",""))}else{N.y.vars.push(L.y.vars[J]+"::"+r[K].replace("\x00",""))}for(var M in A){var F=this.iH(B[K]);for(var I=0;I<A[M];I++){if(K==0&&J==0){N.y.smps.push(M);var E=M.split("\x00");var D=0;for(var C=0;C<h.length;C++){if(h[C]!=e){if(!N.x){N.x={}}if(!N.x.hasOwnProperty(h[C])){N.x[h[C]]=[]}N.x[h[C]].push(E[D++])}}}if(B[K].hasOwnProperty(M)&&B[K][M][I]!=null){N.y.data[K+J].push(L.y.data[J][B[K][M][I]])}else{N.y.data[K+J].push(null)}}}}}for(var M in N.x){if(this.ak(N.x[M])){N.y.smps=N.x[M];delete (N.x[M]);break}}if(N.y.data.length!=N.y.vars.length||N.y.data[0].length!=N.y.smps.length){if(y.config.segregateVariablesBy.length||y.config.segregateSamplesBy.length){this.Ej(N.config.segregateVariablesBy,N.config.segregateSamplesBy)}this.WR();if(y.config.groupingFactors.length){this.groupingFactors=this.Ev(y.config.groupingFactors)}if(!this.isCxplot){alert("Invalid Pivoting")}return}else{this.isPivot=true;this.colorBy=false;y.factor=e}if(N.y.vars.includes("null")){var a=null;for(var K=0;K<N.y.vars.length;K++){if(N.y.vars[K]=="null"){a=K;break}}if(a!=null){N.y.vars.splice(a,1);N.y.data.splice(a,1)}}this.jY(N,true);this.data.y.unpivoted=y;this.WR();if(y.config.groupingFactors.length){this.groupingFactors=this.Ev(y.config.groupingFactors);this.gg([e],true,"groupingFactors")}if(y.config.segregateVariablesBy.length||y.config.segregateSamplesBy.length){this.Ej(y.config.segregateVariablesBy,y.config.segregateSamplesBy,true)}if(!f){this.Oj({func:"pivotX",par:[e,f]})}this.HF()};this.uz=function(h,a,g){var c=[];var f=this.data;for(var b=0;b<f.y.smps.length;b++){c.push([f.x[h][b],f.x[a][b],f.y.data[0][b]])}var e=this.SK(c,0,1,2);return this.qO(e,g)};this.jK=function(o,a,f,c){var e=[];var k;var h=this.data;if(h.x.hasOwnProperty(o)){for(var g=0;g<h.y.smps.length;g++){e.push([h.x[o][g],h.y.data[0][g],h.y.data[1][g]])}if(h.y.vars[0]==a){k=this.SK(e,0,1,2)}else{if(h.y.vars[1]==a){k=this.SK(e,0,2,1)}}}else{if(h.x.hasOwnProperty(a)){for(var g=0;g<h.y.smps.length;g++){e.push([h.x[a][g],h.y.data[0][g],h.y.data[1][g]])}if(h.y.vars[0]==o){k=this.SK(e,1,0,2)}else{if(h.y.vars[1]==o){k=this.SK(e,2,0,1)}}}}if(f){var l=this.Ev(k[0]);l.shift();l.unshift(0);e=[];for(var g=0;g<k.length;g++){e[g]=[];for(var b=0;b<l.length;b++){e[g][l[b]]=k[g][b]}}for(var g=0;g<f.length;g++){e[0][g+1]=f[g]}k=e}return this.qO(k,c)};this.HH=function(e,a,d){var c;e=this.as(e);a=this.as(a);for(var b=0;b<this.data.y.vars.length;b++){if(b!=e&&b!=a){c=b;break}}return this.qO(this.SK(this.aj(this.data.y.data),e,a,c),d)};this.cR=function(f){var h=f.x;var g=f.z;if(h){f.z=h}else{delete (f.z)}if(g){f.x=g}else{delete (f.x)}var l=f.y.smps;f.y.smps=f.y.vars;f.y.vars=l;var k=f.y.data;f.y.data=[];var b=f.y.vars.length;for(var c=0;c<b;c++){f.y.data[c]=[];var e=f.y.smps.length;for(var a=0;a<e;a++){f.y.data[c][a]=k[a][c]}}return f};this.Ho=function(B,f,a){if(this.PU()){return}this.Hp();if(this.graphType.match(/Gantt/)){this.SJ(100,100,"Data transpose not allowed for Gantt graphs",5000);return}if(this.graphType=="Bar"&&this.barType=="lollipop"&&!a){this.SJ(100,100,"Data transpose not allowed for Lollipops",5000);return}var y=this.data;var t=this.meta.data;if(B){return this.aj(B)}else{this.Ab(true);this.Ux("reset",false,false,true);if(y.l){delete (y.l)}var e=["varOverlays","varOverlayInfo","varOverlayProperties","varOverlaysStrLength","varOverlaysThicknessBottom","varOverlaysThicknessTop","varDendrogramNewick","colorVarDendrogramBy","heatmapVarSeparateBy","variablesClustered","segregateVariablesBy"];var g=["smpOverlays","smpOverlayInfo","smpOverlayProperties","smpOverlaysStrLength","smpOverlaysThicknessBottom","smpOverlaysThicknessTop","smpDendrogramNewick","colorSmpDendrogramBy","heatmapSmpSeparateBy","samplesClustered","segregateSamplesBy"];for(var w=0;w<e.length;w++){if(this[e[w]]||this[g[w]]){var o=this[e[w]];var p=this[g[w]];this[e[w]]=p;this[g[w]]=o}}var l=y.x;var k=y.z;if(l){y.z=l}else{delete (y.z)}if(k){y.x=k}else{delete (y.x)}var q=t.x;var c=t.z;t.x=c;t.z=q;for(var w in t.x){t.x[w].origin="x"}for(var w in t.z){t.z[w].origin="z"}var h=t.y.maxSmpChr;var b=t.y.maxSmpLen;var C=t.y.maxSmpStr;t.y.maxSmpChr=t.y.maxVarChr;t.y.maxSmpLen=t.y.maxVarLen;t.y.maxSmpStr=t.y.maxVarStr;t.y.maxVarChr=h;t.y.maxVarLen=b;t.y.maxVarStr=C;var r=y.y.smps;y.y.smps=y.y.vars;y.y.vars=r;var A=y.y.data;y.y.data=[];for(var w=0;w<y.y.vars.length;w++){y.y.data[w]=[];for(var u=0;u<y.y.smps.length;u++){y.y.data[w][u]=A[u][w]}}this.xAxis=[];this.yAxis=[];this.zAxis=[];this.jY(this.data);this.WR();this.C6(false,false,false,true);this.dataTableTransposed=!this.dataTableTransposed;if(!f){this.Oj({func:"transpose",par:[B,f]})}this.HF()}};this.H2=function(){var q={};var x=[];var N=[];var I=[];var A=[];for(var F=0;F<this.varIndices.length;F++){var l=this.varIndices[F];var L=this.data.y.vars[l];x.push(L);q[L]={};for(var E=0;E<this.smpIndices.length;E++){var K=this.smpIndices[E];var J=this.data.y.smps[K];x.push(J);q[L][J]=this.data.y.data[l][K]}}x=this.l4(x);var B=x.length;var k=0;for(var F=0;F<B;F++){N[F]=[];A.push(this.Cj(0,B-1,1));var b=0;for(var E=0;E<B;E++){N[F][E]=0;if(q[x[F]]&&q[x[F]][x[E]]){N[F][E]=q[x[F]][x[E]]}b+=N[F][E]}I.push(b);k+=b}for(var F=0;F<A.length;F++){A[F].sort(function(d,c){return N[F][c]-N[F][d]})}if(this.circularArc>360){this.circularArc=360}else{if(this.circularArc<90){this.circularArc=90}}var y=this.circularArc*(Math.PI*2)/360;var p=(y-this.MA(this.arcSegmentsSeparation)*(this.circularArc==360?B:B-1))/k;var h=[];var f=[];var C=0;for(var F=0;F<B;F++){var a=C;for(var E=0;E<B;E++){var H=A[F][E];var M=N[F][H];var D=C;var P=C+=M*p;h[H*B+F]={idx:F,sid:H,start:D,end:P,value:M,color:this.colors[H%this.colors.length]}}f[F]={name:x[F],idx:F,start:a,end:C,value:I[F],color:this.colors[F%this.colors.length]};C+=this.MA(this.arcSegmentsSeparation)}var O=[];for(var F=0;F<B;F++){for(var E=F;E<B;E++){var e=h[E*B+F];var G=h[F*B+E];if(e.value||G.value){O.push({source:e,target:G})}}}return{chords:O,segments:f,total:k,unit:p}};this.ud=function(){var b=[];for(var a=0;a<this.data.y.smps.length;a++){b.push(" ")}if(!this.data.x){this.data.x={}}this.data.x.__FACTOR__=b;this.FV("x","__FACTOR__",false,true);this.cg(["__FACTOR__"],false,false,false,true)};this.Nc=function(b,e){if(b){this.data.y.smps.push("__COUNT__");for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].push(1)}}else{this.data.y.vars.push("__COUNT__");var c=[];for(var a=0;a<this.data.y.smps.length;a++){c.push(1)}this.data.y.data.push(c)}this.FV("y");this.Gd(true,true);this.Z9();if(!e){this.Oj({func:"countData",par:[]})}};this.rq=function(b,c){if(b){var a=this.sF("__COUNT__");if(a>=0){this.data.y.smps.splice(a,1);for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].splice(a,1)}}}else{var a=this.as("__COUNT__");if(a>=0){this.data.y.vars.splice(a,1);this.data.y.data.splice(a,1)}this.FV("y");this.Gd(true,true);this.Z9()}if(!c){this.Oj({func:"uncountData",par:[]})}};this.K6=function(b,e){if(b){this.data.y.smps.push("__SEQ__");for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].push(a+1)}}else{this.data.y.vars.push("__SEQ__");var c=[];for(var a=0;a<this.data.y.smps.length;a++){c.push(a+1)}this.data.y.data.push(c)}this.FV("y");this.Gd(true,true);this.Z9();if(!e){this.Oj({func:"sequenceData",par:[]})}};this.yH=function(b,c){if(b){var a=this.sF("__SEQ__");if(a>=0){this.data.y.smps.splice(a,1);for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].splice(a,1)}}}else{var a=this.as("__SEQ__");if(a>=0){this.data.y.vars.splice(a,1);this.data.y.data.splice(a,1)}}this.FV("y");this.Gd(true,true);this.Z9();if(!c){this.Oj({func:"unsequenceData",par:[]})}};this.qR=function(){var u=this.isDOE?this.data.l.data[this.layoutCurrent]:false;var g=this.isDOE?u.y.data[0]:this.Ev(this.data.y.data[this.meterIndex]);var t=this.isDOE?u.y.meter.group:this.groupingFactors.length?this.groupingFactors[0]:false;var e=this.isDOE?u.x[t]:t?this.Ev(this.data.x[t]):false;var h=this.isDOE?u.y.meter.summary:this.summaryType;var c=this.isDOE?u.y.meter.topology:this.meterTopology;var p=t&&(!this.isDOE||this.isDOE==1)?this.meta.data.x[t]:t&&this.isDOE>1?this.meta.data.z[t]:false;var j=this.isDOE&&this.isDOE>1?this.varIndices:this.smpIndices;this.isMeterSummarized={data:g,count:g.length,sum:this.Nk(g),mean:this.V6(g),max:this.Wj(g)};var q=this.isMeterSummarized;var a=this.rangeSegments.length&&!this.isDOE?this.rangeSegments[this.rangeSegments.length-1]:false;switch(h){case"count":case"countTotal":q.value=q.count;q.scale=this[this.axisAlgorithm](0,a||q.count,5,false,this.axisWilkinsonLoose);q.reference=q.count;break;case"average":case"mean":case"raw":q.value=q.mean;q.scale=this[this.axisAlgorithm](0,a||q.max,5,false,this.axisWilkinsonLoose);q.reference=q.max;break;case"sum":case"sumTotal":q.value=q.sum;q.scale=this[this.axisAlgorithm](0,a||q.sum,5,false,this.axisWilkinsonLoose);q.reference=q.sum;break;case"percentage":case"percentageTotal":q.value=100;q.scale=this[this.axisAlgorithm](0,a||100,5,false,this.axisWilkinsonLoose);q.reference=100;break}q.range=a||q.scale[q.scale.length-1];var k=this.JN();var b=this.isDOE?this.layoutWidth:this.width-(this.marginLeft+this.marginRight);var o=(this.isDOE?this.layoutHeight:this.height)-(k+this.marginTop+this.marginBottom);if(t){if(p&&p.type=="String"){q.n=p.levels.length;let ratio=b/o;let inverseRatio=o/b;let condition=q.n<2&&c=="auto";let condition2=c=="auto"&&ratio>q.n-0.5;let condition3=c=="auto"&&inverseRatio>q.n-0.5;let condition4=c=="horizontal";let condition5=c=="vertical";if(condition||condition2||condition4){q.cols=q.n;q.rows=1}else{if(condition3||condition5){q.cols=1;q.rows=q.n}else{q.cols=Math.ceil(Math.sqrt(q.n));q.rows=Math.ceil(q.n/q.cols)}}q[t]={};q.levels=p.levels;for(var f=0;f<j.length;f++){var d=e[f];if(!q[t][d]){q[t][d]={data:[],count:0,sum:0,mean:0,max:0}}q[t][d].data.push(g[f])}for(var f in q[t]){q[t][f].count=q[t][f].data.length;q[t][f].sum=this.Nk(q[t][f].data);q[t][f].mean=this.V6(q[t][f].data);q[t][f].max=this.Wj(q[t][f].data);switch(h){case"count":q[t][f].value=q[t][f].count;q[t][f].scale=this[this.axisAlgorithm](0,q[t][f].count,5,false,this.axisWilkinsonLoose);q[t][f].reference=q[t][f].count;break;case"countTotal":q[t][f].value=q[t][f].count;q[t][f].scale=this[this.axisAlgorithm](0,q.count,5,false,this.axisWilkinsonLoose);q[t][f].reference=q.count;break;case"average":case"mean":case"raw":q[t][f].value=q[t][f].mean;q[t][f].scale=this[this.axisAlgorithm](0,q[t][f].max,5,false,this.axisWilkinsonLoose);q[t][f].reference=q[t][f].max;break;case"sum":q[t][f].value=q[t][f].sum;q[t][f].scale=this[this.axisAlgorithm](0,q[t][f].sum,5,false,this.axisWilkinsonLoose);q[t][f].reference=q[t][f].sum;break;case"sumTotal":q[t][f].value=q[t][f].sum;q[t][f].scale=this[this.axisAlgorithm](0,q.sum,5,false,this.axisWilkinsonLoose);q[t][f].reference=q.sum;break;case"percentage":q[t][f].value=100;q[t][f].scale=this[this.axisAlgorithm](0,100,5,false,this.axisWilkinsonLoose);q[t][f].reference=100;break;case"percentageTotal":q[t][f].value=q[t][f].mean*100/q.max;q[t][f].scale=this[this.axisAlgorithm](0,Math.max(100,q[t][f].value),5,false,this.axisWilkinsonLoose);q[t][f].reference=Math.max(100,q[t][f].value);break}}}else{t=false}}if(!t){q.n=1;q.cols=1;q.rows=1}q.width=b/q.cols;q.height=o/q.rows};this.B2=function(){if(this.isSwimmerSumarized){if(this.isGroupedData!=this.isSwimmerSumarized.grouped){delete this.isSwimmerSumarized}}if(!this.isSwimmerSumarized){var u=this;var o=function(){var c={title:"Response",shape:[u.shapes[0],u.shapes[1]],shapeColor:["grey","grey"],size:[false,false],line:[false,false],lineColor:[false,false],lineStart:[false,false],lineEnd:[false,false],text:["Response Start","Response End"]};for(var e in z.color){c.shape.push(false);c.shapeColor.push(false);c.size.push(false);c.line.push("solid");c.lineColor.push(z.color[e]);c.lineStart.push(false);c.lineEnd.push(false);c.text.push(e)}c.shape.push("triangle");c.shapeColor.push("grey");c.size.push(false);c.line.push(false);c.lineColor.push(false);c.lineStart.push(false);c.lineEnd.push(false);c.text.push("Continued Response");return c};var z={high:[],cap:[],fill:[],color:{},shape:{},smps:{},grouped:this.isGroupedData};var a=this.ks();var b=this.as(this.swimHigh);var q=this.as(this.swimStart);var f=this.as(this.swimEnd);if(!this.swimStatus){this.swimStatus="Status"}if(!this.swimHighCap){this.swimHighCap="HighCap"}var B=this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.swimStatus)?this.meta.data.x[this.swimStatus]:false;var y=this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.swimHighCap)?this.meta.data.x[this.swimHighCap]:false;if(this.isGroupedData){this.isGroupedData=false;for(var p=0;p<a.length;p++){for(var k=0;k<this.data.w.grps[a[p]].length;k++){var t=this.data.w.grps[a[p]][k];var r=this.uP(b,t,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var A=this.uP(q,t,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var w=this.uP(f,t,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);z.smps[this.data.w.smps[a[p]]]=p;z.fill[p]=this.QN(a[p],t,"colorBy");if(B){var d=this.mU(t,"x",this.swimStatus);if(!z[d]){z[d]=[]}if(!z[d][p]){z[d][p]=[]}z[d][p].push([A,w]);z.color[d]=this.xj(this.meta.data.x[this.swimStatus].colors[this.meta.data.x[this.swimStatus].order[d]],-50)}else{if(!z.none){z.none=[]}if(!z.none[p]){z.none[p]=[]}z.none[p].push([A,w]);z.color.none="green"}z.high.push(r);if(y){var x=this.mU(t,"x",this.swimHighCap);z.cap[p]=x&&x.match(/arrow/i)?true:false}}}this.isGroupedData=true}else{for(var p=0;p<a.length;p++){var r=this.uP(b,a[p],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var A=this.uP(q,a[p],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var w=this.uP(f,a[p],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);z.smps[this.data.y.smps[a[p]]]=p;z.fill[p]=this.QN(r[p],a[p],"colorBy");if(B){var d=this.mU(a[p],"x",this.swimStatus);if(!z[d]){z[d]=[]}if(!z[d][p]){z[d][p]=[]}z[d][p].push([A,w]);z.color[d]=this.xj(this.meta.data.x[this.swimStatus].colors[this.meta.data.x[this.swimStatus].order[d]],-50)}else{if(!z.none){z.none=[]}if(!z.none[p]){z.none[p]=[]}z.none[p].push([A,w]);z.color.none="green"}z.high.push(r);if(y){var x=this.mU(a[p],"x",this.swimHighCap);z.cap[p]=x&&x.match(/arrow/i)?true:false}}}this.isSwimmerSumarized=z;this.customLegend[0]=o()}};this.VY=function(){if(this.isOncoprint&&!this.isOncoprintSumarized){var g=this;var q=this.data;var k=80;var p=this.meta.data;var o=function(){for(var c=0;c<p[g.oncoprintCNA].levels.length;c++){if(p[g.oncoprintCNA].levels[c].match(/ampli/i)){return c}}return false};var a=function(){for(var c=0;c<p[g.oncoprintCNA].levels.length;c++){if(p[g.oncoprintCNA].levels[c].match(/delet/i)){return c}}return false};var l=function(){var x=p[g.oncoprintCNA].levels.length;var w={};var s=o();var c=a();var u=[];if(s!=null){w[p[g.oncoprintCNA].levels[s]]="rgb(255,0,0)"}if(c!=null){w[p[g.oncoprintCNA].levels[c]]="rgb(0,0,255)"}for(var t=0;t<p[g.oncoprintCNA].levels.length;t++){var j=p[g.oncoprintCNA].levels[t];if(w.hasOwnProperty(j)){u.push(w[j])}else{if(j==""){u.push("rgb(220,220,220)")}else{u.push(g.colors[t])}}}p[g.oncoprintCNA].colors=u};var r=function(){if(g.oncoprintMUT){var j=p[g.oncoprintMUT].levels.length;if(CanvasXpress.colorSchemes.Greens[j]){p[g.oncoprintMUT].colors=CanvasXpress.colorSchemes.Greens[j]}else{if(j==2){var c=CanvasXpress.colorSchemes.Greens[3];p[g.oncoprintMUT].colors=[c[1],c[2]]}else{if(j==1){p[g.oncoprintMUT].colors=["rgb(0,153,0)"]}else{p[g.oncoprintMUT].colors=CanvasXpress.colorSchemes.Greens[9]}}}}};var f={cols:[],rows:[]};l();r();for(var e=0;e<q.y.vars.length;e++){f.rows[e]={CNA:{},MUT:{},TOT:0};for(var d=0;d<p[this.oncoprintCNA].levels.length;d++){var h=p[this.oncoprintCNA].levels[d];f.rows[e].CNA[h]=0}for(var d=0;d<p[this.oncoprintMUT].levels.length;d++){var b=p[this.oncoprintMUT].levels[d];f.rows[e].MUT[b]=0}}for(var e=0;e<q.y.smps.length;e++){f.cols[e]={CNA:{},MUT:{},TOT:0};for(var d=0;d<p[this.oncoprintCNA].levels.length;d++){var h=p[this.oncoprintCNA].levels[d];f.cols[e].CNA[h]=0}for(var d=0;d<p[this.oncoprintMUT].levels.length;d++){var b=p[this.oncoprintMUT].levels[d];f.cols[e].MUT[b]=0}}for(var e=0;e<q.y.vars.length;e++){for(var d=0;d<q.y.smps.length;d++){var h=this.uP(e,d,false,false,false,false,this.oncoprintCNA);var b=this.uP(e,d,false,false,false,false,this.oncoprintMUT);if(h){f.rows[e].CNA[h]++;f.cols[d].CNA[h]++}if(b){f.rows[e].MUT[b]++;f.cols[d].MUT[b]++}if(h||b){f.rows[e].TOT++;f.cols[d].TOT++}}}if(!q.z){q.z={}}for(var e=0;e<p[this.oncoprintCNA].levels.length;e++){var h=p[this.oncoprintCNA].levels[e];q.z[h]=[];for(var d=0;d<q.y.vars.length;d++){q.z[h][d]=f.rows[d].CNA[h]}this.FV("z",h,false,true);this.varOverlayProperties[h]={type:"Stacked",position:"top",thickness:k,color:p[this.oncoprintCNA].colors[e],showName:false,showBox:false};if(this.oncoprintColSummary){this.varOverlays.push(h)}}for(var e=0;e<p[this.oncoprintMUT].levels.length;e++){var b=p[this.oncoprintMUT].levels[e];q.z[b]=[];for(var d=0;d<q.y.vars.length;d++){q.z[b][d]=f.rows[d].MUT[b]}this.FV("z",b,false,true);this.varOverlayProperties[b]={type:"Stacked",position:"top",thickness:k,color:p[this.oncoprintMUT].colors[e],showName:false,showBox:false};if(this.oncoprintColSummary){this.varOverlays.push(b)}}q.z["Altered-Vars"]=[];q.z["% Altered-Vars"]=[];for(var e=0;e<q.y.vars.length;e++){q.z["Altered-Vars"][e]=f.rows[e].TOT;q.z["% Altered-Vars"][e]=(f.rows[e].TOT/q.y.smps.length*100).toFixed(1)+"%"}this.FV("z","Altered-Vars",false,true);this.FV("z","% Altered-Vars",false,true);this.varOverlayProperties["% Altered-Vars"]={type:"Text",position:"bottom",thickness:this.overlaysThickness+2,showName:false};if(!q.x){q.x={}}for(var e=0;e<p[this.oncoprintCNA].levels.length;e++){var h=p[this.oncoprintCNA].levels[e];q.x[h]=[];for(var d=0;d<q.y.smps.length;d++){q.x[h][d]=f.cols[d].CNA[h]}this.FV("x",h,false,true);this.smpOverlayProperties[h]={type:"Stacked",position:"right",thickness:k,color:p[this.oncoprintCNA].colors[e],showName:false,showBox:false};if(this.oncoprintRowSummary){this.smpOverlays.push(h)}}for(var e=0;e<p[this.oncoprintMUT].levels.length;e++){var b=p[this.oncoprintMUT].levels[e];q.x[b]=[];for(var d=0;d<q.y.smps.length;d++){q.x[b][d]=f.cols[d].MUT[b]}this.FV("x",b,false,true);this.smpOverlayProperties[b]={type:"Stacked",position:"right",thickness:k,color:p[this.oncoprintMUT].colors[e],showName:false,showBox:false};if(this.oncoprintRowSummary){this.smpOverlays.push(b)}}q.x["Altered-Smps"]=[];q.x["% Altered-Smps"]=[];for(var e=0;e<q.y.smps.length;e++){q.x["Altered-Smps"][e]=f.cols[e].TOT;q.x["% Altered-Smps"][e]=(f.cols[e].TOT/q.y.vars.length*100).toFixed(1)+"%"}this.FV("x","Altered-Smps",false,true);this.FV("x","% Altered-Smps",false,true);this.smpOverlayProperties["% Altered-Smps"]={type:"Text",position:"left",thickness:Math.ceil(p.x["% Altered-Smps"].maxLevLen),showName:false,rotate:true};if(this.oncoprintRowSummary){this.smpOverlays.push("% Altered-Smps")}this.isOncoprintSumarized=true;this.NC()}};this.Jn=function(){if(this.isUpSet&&!this.isUpSetSumarized){this.isUpSetSumarized={vars:[],smps:[]};this.showHeatmapIndicator=false;this.showVariableNames=false;var l=[];var a=[];for(var g=0;g<this.data.y.smps.length;g++){l[g]=0;if(this.upSetSets.length){if(this.upSetSets.includes(this.data.y.smps[g])){a.push(g)}}else{a.push(g)}for(var f=0;f<this.data.y.vars.length;f++){if(this.data.y.data[f][g]>0){l[g]++}}}if(!this.data.x){this.data.x={}}this.data.x.Sets=l;a=a.sort(function(s,j){return l[j]-l[s]});if(!this.upSetSets.length){a=a.splice(0,this.nUpSets)}this.isUpSetSumarized.vars=this.Ev(a.reverse());a=this.Fe(a);var b=[];var o=[];var r=[];var c=[];var e={};var h={};var k=[];for(var g=0;g<this.data.y.vars.length;g++){o=[];b[g]=0;for(var f=0;f<this.data.y.smps.length;f++){if(this.data.y.data[g][f]>0){b[g]++;if(a.hasOwnProperty(f)){o.push(f)}}}var q=o.join(":");if(!e.hasOwnProperty(q)){e[q]=[]}e[q].push(g)}this.isUpSetSumarized.inter=e;var p=[];for(var g in e){var d=g.split(":").length;h[g]=e[g].length;if(g!=""){p.push(g)}for(var f=0;f<e[g].length;f++){r[e[g][f]]=h[g];c[e[g][f]]=g;k[e[g][f]]=d}}if(!this.data.z){this.data.z={}}this.data.z.Matrix=b;this.data.z.Size=r;this.data.z.Label=c;this.data.z.Terms=k;p=p.sort(function(s,j){return s.split(":").length-j.split(":").length||e[j].length-e[s].length});for(var g=0;g<p.length;g++){this.isUpSetSumarized.smps.push(e[p[g]][0])}this.smpIndices=this.isUpSetSumarized.vars;this.varIndices=this.isUpSetSumarized.smps;this.FV("z","Matrix");this.FV("z","Size");this.FV("z","Label");this.FV("z","Terms");this.varOverlayProperties.Size={type:"Bar",position:"top",color:this.upsetMainBarColor,thickness:(this.layoutValid?this.layoutHeight:this.height)*this.upsetMatrixPlotBarRatio,showBox:false};this.varOverlays.push("Size");this.FV("x","Sets");this.smpOverlayProperties.Sets={type:"Bar",position:"left",color:this.upsetSetsBarColor,thickness:(this.layoutValid?this.layoutWidth:this.width)*0.2,showBox:false};this.smpOverlays.push("Sets")}};this.uP=function(h,g,o,d,f,p,q,l,b){var c=Number.NaN;var a=this.isGroupedData?this.data.w:this.data.y;if(l){c=this.data.y[l][h][g]}else{if(this.isGroupedData||!this.isRawData){if(this.isTransformedData){if(!o){c=a.trans[h][g]}else{if(o=="stdev"){c=a.tstdev[h][g]}else{if(a.hasOwnProperty(o)){c=a[o][h][g]}}}}else{o=o?o:this.summaryType;if(a.hasOwnProperty(o)){c=a[o][h]?a[o][h][g]:NaN}else{c=0}}}else{if(o){if(a[o]&&a[o][h]){c=a[o][h][g]}else{if(o=="sum"&&!this.isGroupedData){c=a.data[h][g]}}}else{if(this.isTransformedData&&a.trans&&a.trans.length){c=a.trans[h][g]}else{c=a.data[h][g]}if(b){c=b-c}}}}if(d!="percentile"&&((f!=null||p!=null||q))){if(q){if(o=="out"){for(var e=0;e<c.length;e++){c[e]*=q}}else{c*=q}}if(f!=null&&f!=false&&f!=undefined){if(o=="out"){for(var e=0;e<c.length;e++){c[e]=Math.max(f,c[e])}}else{c=Math.max(f,c)}}if(p!=null&&p!=false&&p!=undefined){if(o=="out"){for(var e=0;e<c.length;e++){c[e]=Math.min(p,c[e])}}else{c=Math.min(p,c)}}}if(d){if(!isNaN(c)){if(d=="log2"){c=Math.log(c)/Math.LN2}else{if(d=="log10"){c=Math.log(c)/Math.LN10}else{if(d=="-log2"){c=-Math.log(c)/Math.LN2}else{if(d=="-log10"){c=-Math.log(c)/Math.LN10}else{if(d=="exp2"){c=Math.pow(2,c)}else{if(d=="exp10"){c=Math.pow(10,c)}else{if(d=="sqrt"){c=Math.sqrt(c)}else{if(d=="percentile"){c=this.an(f,p,c)}}}}}}}}}}return c==null?Number.NaN:c};this.uV=function(b){var a=[];var d=this.data.y.data.length;for(var c=0;c<d;c++){a.push(this.data.y.data[c][b])}return a};this.et=function(k,o,j,d){var h=[];if(!o){o=this.varIndices}if(this.isGroupedData||!this.isRawData){var b=this.isGroupedData?this.data.w:this.data.y;if(this.isTransformedData){if(b.trans[0]&&b.trans[0][k]){h.push(b.trans[0][k])}}else{j=this.summaryType=="iqr"?"median":this.summaryType;if(b.hasOwnProperty(j)&&b[j].length){var c=this.isDOE&&this.isDOE==1?this.data.y.vars.length:o.length;for(var g=0;g<c;g++){var l=o[g];if(b[j][l]){h.push(b[j][l][k])}}}}}else{var f=j?this.data.y[j]:this.data.y.data;var c=this.isDOE&&this.isDOE==1?this.data.y.vars.length:o.length;var a=this.xAxisIndices||[];var p=this.yAxisIndices||[];var e=a.includes(k)?"x":p.includes(k)?"y":false;if(this.isTransformedData){for(var g=0;g<c;g++){var l=o[g];if(this.data.y.trans[l]){h.push(this.data.y.trans[l][k])}}}else{if(d){for(var g=0;g<c;g++){var l=o[g];if(l==undefined){continue}h.push(this.uP(l,k,false,d,this[e+"AxisFloorValue"],this[e+"AxisCeilValue"],this[e+"AxisFactorValue"]))}}else{for(var g=0;g<c;g++){var l=o[g];if(f[l]){if(e){h.push(this.uP(l,k,false,d,this[e+"AxisFloorValue"],this[e+"AxisCeilValue"],this[e+"AxisFactorValue"]))}else{h.push(f[l][k])}}}}}}return h};this.AL=function(b){var a=[];var e=this.smpIndices.length;if(this.isTransformedData){for(var c=0;c<e;c++){var d=this.smpIndices[c];a.push(this.data.y.trans[b][d])}}else{for(var c=0;c<e;c++){var d=this.smpIndices[c];a.push(this.data.y.data[b][d])}}return a};this.Cb=function(a){var c={};if(this.data.z){for(var b in this.data.z){c[b]=this.mU(a,"z",b)}}c[name]=this.data.y.vars[a];return c};this.BO=function(a){if(this.isGroupedData){return this.hU(a)}else{return this.wT(a)}};this.wT=function(a){var c={};if(this.data.x){for(var b in this.data.x){c[b]=this.mU(a,"x",b)}}else{i=Math.min(Math.max(Math.floor(v*(m.vals.length+1)/m.vals[n])-1,0),n)}c.name=this.data.y.vars[a];return c};this.hU=function(a){var d=[];var e=this.data.w.grps[a].length;for(var b=0;b<e;b++){var c=this.data.w.grps[a][b];d.push(this.getMetaDataForSmpAtIndex[c])}return d};this.C6=function(f,a,b,e){var d=this.layoutComb&&this.layoutParams?this.layoutParams[f||0]:this;if(!a){a=d.varIndices}if(!b){b=this.isGroupedData?d.grpIndices:d.smpIndices}if(e||!d.startingVarIndices||d.startingVarIndices.length==0){d.startingVarIndices=this.Ev(a)}if(this.isGroupedData){if(e||!d.startingGrpIndices||d.startingGrpIndices.length==0){d.startingGrpIndices=this.Ev(b)}}else{if(e||!d.startingSmpIndices||d.startingSmpIndices.length==0){d.startingSmpIndices=this.Ev(b)}}};this.sO=function(c){var f=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy"];var h=["colorEdgeBy","SizeEdgeBy"];var g=this.meta.data;for(var e=0;e<f.length;e++){var b=this[f[e]];if(!g.nodes.hasOwnProperty(b)){this[f[e]]=false}}for(var e=0;e<h.length;e++){var b=this[h[e]];if(!g.edges.hasOwnProperty(b)){this[h[e]]=false}}if(this.decorations){var k=[];for(var e=0;e<this.decorations.length;e++){var j=this.decorations[e];if(g.nodes.hasOwnProperty(j)){k.push(j)}}this.decorations=k}if(c){this.rB()}};this.R0=function(c){var q=this;var p=["color","shape","size","line","pattern","outline","connect","motion","ellipse","ridge","stack","pie"];var b="";var k=function(){if(q.graphType.match(/Scatter/)){if(q.meta.data.hasOwnProperty("z")&&q.meta.data.z.hasOwnProperty("variable")){return"variable"}else{return false}}else{if(q.meta.data.hasOwnProperty("x")&&q.meta.data.x.hasOwnProperty("variable")){return"variable"}else{return false}}};for(var g=0;g<p.length;g++){var t=this[p[g]+"By"];if(this.Hl(t)){t=t[0]}var r=this[t+"Data"];if(t){if(this.isMultidimensionalData){if(r&&!this.data.y[r]){this[p[g]+"By"]=false;this[t+"Data"]=false}}else{if(t=="variable"){continue}else{if(t=="data"&&this.ridgeBy){continue}else{if(this.data.x&&this.data.x.hasOwnProperty(t)){continue}else{if(this.data.z&&this.data.z.hasOwnProperty(t)){if(p[g].match(/ellipse|ridge/)&&this.meta.data.z[t].type=="Numeric"){this[p[g]+"By"]=false}continue}else{if(this.sF(t)!=-1||this.sF(t,true)!=-1){continue}else{if(this.th()&&t=="sample"&&(p[g]=="shape"||p[g]=="color")){continue}else{this[p[g]+"By"]=false}}}}}}}}}if(this.treemapBy.length>0){var h=[];var f=[];for(var g=0;g<this.treemapBy.length;g++){if(this.treemapBy[g]=="sample"){f.push("sample")}else{if(!this.data.x||!this.data.x.hasOwnProperty(this.treemapBy[g])){f.push("sample")}else{if(this.data.x&&this.data.x.hasOwnProperty(this.treemapBy[g])){h.push(this.treemapBy[g])}}}}if(f.length>0){}this.treemapBy=h}var o=this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Map|Circular/)||this.graphType=="Tree";if(this.shapeBy&&!this.isMultidimensionalData&&!o){b+="shapeBy changed to false (shapeBy not support in"+this.graphType+")\n";this.shapeBy=false}else{if(this.shapeBy&&this.groupingFactors.length>1&&!o){b+="shapeBy changed to variable (multiple grouping factors not allowed)\n";this.shapeBy="variable"}else{if(this.shapeBy&&this.groupingFactors.length==1&&this.shapeBy!=this.groupingFactors[0]&&!o){b+="shapeBy changed to variable (grouping factor should the same as shapeBy)\n";this.shapeBy="variable"}}}if(this.sizeBy&&!this.isMultidimensionalData&&!o){b+="sizeBy changed to false (sizeBy not support in"+this.graphType+")\n";this.sizeBy=false}else{if(this.sizeBy&&this.groupingFactors.length>1&&!o){b+="sizeBy changed to variable (multiple grouping factors not allowed)\n";this.sizeBy="variable"}else{if(this.sizeBy&&this.groupingFactors.length==1&&this.sizeBy!=this.groupingFactors[0]&&!o){b+="sizeBy changed to variable (grouping factor should the same as sizeBy)\n";this.sizeBy="variable"}}}if(this.colorBy&&this.graphType=="Heatmap"&&!this.isMultidimensionalData){this.ra(this.colorBy)}else{if(this.colorBy&&this.groupingFactors.length>1&&!this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Stacked|Treemap/)&&!this.isCxplot){b+="colorBy changed to variable (multiple grouping factors not allowed)\n";this.colorBy="variable"}else{if(this.colorBy&&this.groupingFactors.length==1&&this.colorBy!=this.groupingFactors[0]&&!this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Stacked|Treemap|Line/)&&this.barType!="swimmer"){if(this.toDoPivot){this.colorBy=false}else{b+="colorBy changed to variable (grouping factor should the same as colorBy)\n";this.colorBy="variable"}}}}if((this.shapeBy||this.sizeBy||this.patternBy||this.outlineBy)&&!this.colorBy&&!this.isMultidimensionalData&&!this.graphType=="Heatmap"&&!this.isCxplot){this.colorBy="variable"}else{if(!this.shapeBy&&!this.sizeBy&&!this.patternBy&&this.colorBy=="variable"&&this.graphType!="Map"){this.colorBy=k()}}if(this.shapeBy=="variable"&&!this.colorBy&&!this.th()){this.colorBy="variable"}if(this.sizeBy=="variable"&&!this.colorBy&&!this.th()){this.colorBy="variable"}if(this.patternBy=="variable"&&!this.colorBy&&!this.th()){this.colorBy="variable"}if(this.stackBy&&!this.colorBy){this.colorBy=this.stackBy}else{if(this.stackBy&&this.colorBy&&this.stackBy!=this.colorBy){b+="colorBy changed to stackBy (remove stackBy to color by different factor)\n";this.colorBy=this.stackBy}}if(this.dodgeBy&&!this.colorBy){this.colorBy=this.dodgeBy}else{if(this.dodgeBy&&this.colorBy&&this.dodgeBy!=this.colorBy){b+="colorBy changed to dodgeBy (remove dodgeBy to color by different factor)\n";this.colorBy=this.dodgeBy}}if(this.lineBy&&!this.colorBy&&this.isGroupedData){}else{if(this.lineBy&&this.colorBy&&this.lineBy!=this.colorBy&&this.isGroupedData){b+="colorBy changed to lineBy (remove lineBy to color by different factor)\n";this.colorBy=this.lineBy}else{if(this.lineBy&&!this.isGroupedData&&this.graphType!="Scatter2D"){b+="Data needs to be grouped";this.lineBy=false}}}if(b!=""){this.SJ(10,10,b,3000)}if(this.colorBy||this.shapeBy||this.sizeBy||this.lineBy){var p=["colorBy","shapeBy","lineBy"];var s=[];for(var g=0;g<p.length;g++){if(this[p[g]]){s.push(p[g])}}var u=[];for(var e=0;e<s.length;e++){if(u.indexOf(this[s[e]])===-1){u.push(this[s[e]])}}if(u.length===1){this.legendCombine=s}}if(c){this.rB()}};this.Yg=function(e,d){var a=[];if(this.meta.data[e]){for(var b in this.meta.data[e]){if(d&&this.meta.data[e][b].type==d){a.push(b)}else{if(!d){a.push(b)}}}}return a};this.PR=function(d,f,c,k,e){var l=d.vals.length-1;var g;if((k[e]=="shapes"&&!this.shapeByContinuous)||(k[e]=="sizes"&&!this.sizeByContinuous)){for(var j=0;j<d.vals.length;j++){if(f<=d.vals[j]){g=j;break}}}else{g=Math.min(Math.max(Math.floor(f*(d.vals.length+1)/d.vals[l])-1,0),l)}return c?g:parseInt(this[k[e]][g%this[k[e]].length])};this.eP=function(b,d,c){var e=b.vals?b.vals.length-1:b.values.length-1;return parseFloat((((d-b.min)/(b.max-b.min))*(this[c][e]-this[c][0])))+parseInt(this[c][0])};this.mU=function(a,d,e,c){var f=d=="x"?this.data.x:d=="z"?this.data.z:false;if(this.isGroupedData&&!c&&d!="z"){var b=this.data.w;return b&&b.factors.hasOwnProperty(e)?b.factors[e][a]:"NoCatFound"}else{if(f&&f.hasOwnProperty(e)){return f[e][a]}else{return undefined}}};this.hr=function(e,c,q){var g=e?this.meta.data.nodes:this.meta.data.edges;var b=this[q];var k={colorNodeBy:"colors",colorEdgeBy:"colors",shapeNodeBy:"shapes",sizeNodeBy:"sizes",sizeEdgeBy:"sizes",patternNodeBy:"patterns"};var l=0.5;if(e){if(b&&g.hasOwnProperty(b)&&e.hasOwnProperty(b)&&e[b]!=null){if(g[b].type=="Numeric"&&q!="shapeNodeBy"){switch(q){case"colorNodeBy":return e[b]!=null?this.b3(g[b].colorBrew,Number(e[b])):false;case"shapeNodeBy":var j=parseInt(this.an(g[b].min,g[b].max,Number(e[b]))/10);return j==10?"circle":"pie"+j;case"sizeNodeBy":var o=g[b].max-g[b].min<=10?100:g[b].max-g[b].min<=100?50:20;var j=parseInt(this.an(g[b].min,g[b].max,Number(e[b])))/o;return Math.pow(l+j,2);case"patternNodeBy":return"closed"}}else{if(k[q]){var j=g[b].order[e[b]];return g[b][k[q]][j]}else{alert("Ooops")}}}else{q=q.replace("NodeBy","");if(e.hasOwnProperty(q)){return e[q]}else{switch(q){case"color":return this.nodeColor;case"shape":return"circle";case"size":return 1;case"pattern":return"closed"}}}}else{if(b&&g.hasOwnProperty(b)&&(c.hasOwnProperty(b))){if(q=="colorEdgeBy"){if(g[b].type=="Numeric"){return this.b3(g[b].colorBrew,Number(c[b]))}else{if(k[q]){var j=g[b].order[c[b]];return g[b][k[q]][j]}else{alert("Ooops")}}}else{if(q="sizeEdgeBy"){if(g[b].type=="Numeric"){l=Math.min(this.minEdgeSize,this.edgeThickness);var j=(parseInt(this.an(g[b].min,g[b].max,Number(c[b]||g[b].min)))/100)*this.maxEdgeSize*this.edgeThickness;return l+(isNaN(j)?l:j)}else{if(k[q]){var j=g[b].order[c[b]];return j*this.edgeThickness}else{alert("Ooops")}}}else{alert("Ooops. Not implemented yet!")}}}else{if(q=="colorEdgeBy"){return c.color||this.edgeColor}else{if(q="sizeEdgeBy"){return c.thickness||this.edgeThickness}else{alert("Ooops. Not implemented yet!")}}}}};this.QN=function(G,E,F,D,w){var e=this;var y,x,j,B,k;var u=D||this[F];var C=this.eb();var A=this.groupingFactors&&this.groupingFactors.length==1;var o=this.data;var H=this.meta.data;var z={colorVarDendrogramBy:"colors",colorSmpDendrogramBy:"colors",colorBy:"colors",colorLabelBy:"colors",colorByData:"colors",outlineBy:"colors",outlineByData:"colors",markerBy:"colors",shapeBy:"shapes",shapeByData:"shapes",sizeBy:"sizes",sizeLabelBy:"sizes",sizeByData:"sizes",patternBy:"patterns",patternByData:"patterns",stackBy:"colors",dodgeBy:"colors",lineBy:"colors",linePatternBy:"linePatterns",confidenceBy:"colors"};var d=function(){var b={};var h=0;if(E>=0&&o.w.grps[E]){for(var g=0;g<o.w.grps[E].length;g++){var c=H.x[u].type;var a=o.x[u][o.w.grps[E][g]];if(!b.hasOwnProperty(a)){b[a]=true;h++}if(h>1){return false}}}return true};var f=function(){if(!e.patternBy){if(G>e.colors.length-1&&!e.colorBy){return e[z[F]][Math.floor(G/e.colors.length)]}else{return e[z[F]][0]}}else{return e[z[F]][0]}};var r=F&&this[z[F]]?this[z[F]].length:false;if(G!=null&&E!=null&&u&&o.y.hasOwnProperty(u)){y=o.y[u][G][E];x=H[u];j=x.type}else{if(E!=null&&u&&o.x&&o.x.hasOwnProperty(u)){x=H.x[u];if(C||!this.isGroupedData){j=x.type;y=this.graphType=="Gantt"?o.x[u][E]:this.isGroupedData?o.w.smps[E]:o.x[u][E];if(x[F]&&x[F].hasOwnProperty(y)){return x[F][y]}else{if(F=="colorSmpDendrogramBy"&&x.colorBy&&x.colorBy.hasOwnProperty(y)){return x.colorBy[y]}}}else{if((A&&(this.groupingFactors[0]==u||d()))||(!A&&this.isGroupedData&&this.isCxplot&&this.groupingFactors.length>1)){j=x.type;y=E!==false&&E>=0&&o.w.grps[E]?o.x[u][o.w.grps[E][0]]:false;if(y&&F.match(/color|patternBy/)){if(x[F]&&x[F].hasOwnProperty(y)){return x[F][y]}else{if(x[z[F]]){return x[z[F]][x.order[y]%r]}else{return this[z[F]][x.order[y]%r]}}}else{return x[z[F]]?x[z[F]][0]:F.match(/color/)?this[z[F]][0]:F=="patternBy"?f():this[z[F]][0]}}else{return G!=null&&F.match(/color/)?this[z[F]][G%r]:F=="patternBy"?f():this[z[F]][0]}}}else{if(G!=null&&u&&o.z&&o.z.hasOwnProperty(u)){x=H.z[u];j=x.type;y=o.z[u][G];if(x[F]&&(x[F].hasOwnProperty(y)||x[F][y])){return x[F][y]}else{if(x[F]&&(x[F].hasOwnProperty(y+"\x00")||x[F][y+"\x00"])){return x[F][y+"\x00"]}else{if(x[F]&&x[F][y.replace("\x00","")]){return x[F][y.replace("\x00","")]}else{if(F=="colorVarDendrogramBy"&&x.colorBy&&x.colorBy.hasOwnProperty(y)){return x.colorBy[y]}else{if(x[F]&&F=="linePatterns"&&x.order&&x.order.hasOwnProperty(y)){return x[F][x.order[y]%this[F].length]}}}}}}else{if(G!=null&&E!=null&&F&&((this.isGroupedData&&H.w.smps.hasOwnProperty(F))||(!this.isGroupedData&&H.y.range.hasOwnProperty(F)))){y=o.y.data[G][E];x=H.y.range[F];j=H.y.type}else{if(G!=null&&!this.isGroupedData&&u&&H.y.range.hasOwnProperty(u)){x=H.y.range[u];j=x.type;k=E!=null?false:this.sF(u);y=E!=null?o.y.data[G][E]:o.y.data[G]?o.y.data[G][k>=0?k:0]:0;if(H.modified&&H.modified.z&&H.modified.z[u]){return this[z[F]][y%r]}else{if(!x.colorBrew){x.colorBrew=this.QK(false,x.min,x.max);x.vals=x.colorBrew.vals}}}else{if(G!=null){if(u){return this[z[F]][G%r]}else{return !u&&F.match(/color/)?this[z[F]][G%r]:F=="patternBy"?f():this[z[F]][0]}}else{return this[z[F]][0]}}}}}}if(j=="Numeric"){if(F.match(/color|outlineBy/)){return !isNaN(y)&&y!==null?this.b3(x.colorBrew,Number(y)):this.missingDataColor}else{if(F.match(/shapeBy/)){if(!isNaN(y)){return this.shapeByContinuous?"pie"+this.PR(x,y,true,z,F):this[z[F]][this.PR(x,y,true,z,F)]}else{return"sphere"}}else{if(F.match(/sizeBy/)){if(!isNaN(y)){return this.sizeByContinuous?this.eP(x,y,z[F]):this.PR(x,y,false,z,F)}else{return this[z[F]][0]}}else{if(F.match(/patternBy/)){if(!isNaN(y)){return this.PR(x,y,false,z,F)}else{return"closed"}}}}}}else{if(j=="String"){if(x[z[F]]){if(w){if(F=="sizeLabelBy"){return this.mD([5,9,13,17,21],this.an(x[z[F]][0],x[z[F]][x[z[F]].length-1],x[z[F]][x.order[y]%x[z[F]].length])/100)}else{return this.an(x[z[F]][0],x[z[F]][x[z[F]].length-1],x[z[F]][x.order[y]%x[z[F]].length])}}else{return F=="sizeBy"?parseInt(x[z[F]][x.order[y]%x[z[F]].length]):x[z[F]][x.order[y]%x[z[F]].length]}}else{return F=="sizeBy"?parseInt(this[z[F]][x.order[y]%this[z[F]].length]):this[z[F]][x.order[y]%this[z[F]].length]}}}};this.By=function(a,t){var s=this.meta.data;var d=this.data;var u=this.graphType=="Network"?["nodes","edges"]:["x","z"];if(a&&t){t.colors=a;t.connects=a}else{for(var p=0;p<u.length;p++){var f=u[p];if(d[f]){if(this.graphType=="Network"){this.decorationsTextColors=[];return}else{var b=d[f]||s[f];for(var h in b){if(s[f][h]&&s[f][h].type=="String"){var r=b[h];var q=this.p4(d[f]?r:r.levels);var c=this.m4(q);var e=c.length;if((!this.colorKey&&this.graphType!="Map")||(this.colorKey&&!this.colorKey.hasOwnProperty(h))){s[f][h].colors=[];var w=0;if(e!=a.length&&this.colorScheme){var g=this.lX(e,this.colorScheme);for(var l=0;l<c.length;l++){s[f][h].colors.push(g[w%g.length]);w++}}else{for(var l=0;l<c.length;l++){s[f][h].colors.push(a[w%a.length]);w++}}}}}}}}}};this.Mk=function(){if(this.groupingFactors.length){var e=true;if(this.colorBy&&this.groupingFactors.includes(this.colorBy)&&this.data.w&&this.groupingFactors.length>1){e=false;var a=this.groupingFactors.indexOf(this.colorBy);for(var c=0;c<this.data.w.smps.length;c++){if(this.data.w.smps[c].length){if(!this.data.w.glab[c]){this.data.w.glab[c]=this.Ev(this.data.w.smps[c])}var d=this.data.w.glab[c].split(" :: ");d.splice(a,1).join(" :: ");if(this.showLegend){this.data.w.smps[c]=d}}}}if(this.shapeBy&&this.groupingFactors.includes(this.shapeBy)&&this.data.w&&this.groupingFactors.length>1){e=false;var a=this.groupingFactors.indexOf(this.shapeBy);for(var c=0;c<this.data.w.smps.length;c++){if(this.data.w.smps[c].length){if(!this.data.w.glab[c]){this.data.w.glab[c]=this.Ev(this.data.w.smps[c])}var d=this.data.w.glab[c].split(" :: ");d.splice(a,1).join(" :: ");if(this.showLegend){this.data.w.smps[c]=d}}}}if(e){if(this.data.w&&this.data.w.glab.length==this.data.w.smps.length){this.data.w.smps=this.Ev(this.data.w.glab)}}}if(this.data.w&&this.data.w.smps&&this.groupingFactors.length){for(var c=0;c<this.segregateSamplesBy.length;c++){var a=this.groupingFactors.indexOf(this.segregateSamplesBy[c]);for(var b=0;b<this.data.w.smps.length;b++){if(this.data.w.smps[b].length){if(!this.data.w.glab[b]){this.data.w.glab[b]=this.Ev(this.data.w.smps[b])}var d=this.data.w.glab[b].split(" :: ");if(a>=0){d.splice(a,1).join(" :: ")}else{d=d.join(" :: ")}this.data.w.smps[b]=d}}}}if(this.data.w){this.FV("w")}};this.NO=function(b,f,c){if(b!=null&&f){if(!c){c=this.iT(f)}var e=[];if(this.Hl(b)){if(this.Hl(f)){var g=b.length;for(var d=0;d<g;d++){if(c.hasOwnProperty(b[d])){e.push(c[b[d]])}}return e}else{return c.hasOwnProperty(f)?c[f[d]]:-1}}else{return f.indexOf(b)}}};this.wn=function(q,d,p,h,b){var j=[];var t={};var e=this.data[p];var g=this.meta.data[p];if(e&&q&&e[q]){g=g[q];for(var k=0;k<d.length;k++){var r=d[k];var f=this.mU(r,p,q,h)||"";if(!t.hasOwnProperty(f)){j.push(f)}t[f]=true}if(g&&b){if(g.monthDay){j=j.sort(function(l,c){return parseInt(CanvasXpress.dates[l])-parseInt(CanvasXpress.dates[c])})}else{if(this.scatterPlotMatrix){j=j.sort(function(l,c){return l.toLowerCase().localeCompare(c.toLowerCase())})}else{j=j.sort(function(l,c){return g.n[g.order[c]]-g.n[g.order[l]]||c>l})}}}}return j};this.rj=function(k,e,b,j,g){var r=[];var d=this.data[j];if(d&&k&&d[k]){if(e){for(var f=0;f<b.length;f++){var q=b[f];var p=this.mU(q,j,k);if(p==e){if(g&&!g[q]){r.push(q)}else{r.push(q)}}}}else{for(var f=0;f<b.length;f++){var q=b[f];var p=this.mU(q,j,k);if(!p){if(g&&!g[q]){r.push(q)}else{r.push(q)}}}}}return r};this.u4=function(p,d,l,g,k){var b={};var h=[];var j=false;var e=this.data[k];if(!d){d=k=="x"?this.smpIndices:this.varIndices}if(e&&e.hasOwnProperty(p)){for(var f=0;f<d.length;f++){var r=d[f];var q=this.mU(r,k,p);if(q!=null){b[q]=true;h.push(q)}else{j=true}}if(j){h.push("")}if(g){return l?h.join("+"):h}else{h=[]}for(var f in b){h.push(f)}if(j){h.push("")}return l?h.join("+"):h}};this.qT=function(a,c,b){var f=this.data;if(f.y){var k=f.y.smps;if(!k&&f.y.vars){if(!f.y.data){alert("Missing data object")}k=[];for(var e=0;e<f.y.data[0].length;e++){k.push("smp"+(e+1))}f.y.smps=k}var h=[];var g=[];if(a){for(var e=0;e<a.length;e++){h.push(a[e]);g.push(false)}}else{for(var e=0;e<k.length;e++){h.push(e);g.push(false)}}if(!c&&this.varIndices){this.la()}this.smpIndices=this.sortDir=="descending"?h.reverse():h;this.hiddenSmps=this.sortDir=="descending"?g.reverse():g}if(this.data.w&&this.data.w.smps){h=[];g=[];this.hiddenGrps=[];for(var e=0;e<this.data.w.smps.length;e++){h.push(e);g.push(false)}this.grpIndices=this.sortDir=="descending"?h.reverse():h;this.hiddenGrps=this.sortDir=="descending"?g.reverse():g}if(this.layoutComb&&this.layoutParams&&!b){for(var e=0;e<this.layoutParams.length;e++){var j=this.layoutParams[e];if(j){if(j.startingSmpIndices){j.smpIndices=j.startingSmpIndices;j.smpIndicesStart=-1}if(this.isGroupedData&&j.startingGrpIndices){j.grpIndices=j.startingGrpIndices;j.grpIndicesStart=-1}}}}};this.sF=function(b,e,d,f,c){if(!f){f=this.isGroupedData&&!e?this.data.w.smps:this.data.y.smps;c=this.iT(f)}return this.NO(b,f,c)};this.sN=function(b){return this[b]||[]};this.hA=function(c,b,d){return this.rj(c,b,d||this.smpIndices,"x",this.hiddenSmps)};this.OU=function(b,c){return this.wn(b,c||this.smpIndices,"x",true)};this.yV=function(b,e){if(this.isGroupedData&&!this.data.w){this.grpIndices=[];for(var d=0;d<b.length;d++){this.grpIndices.push(b[d])}}else{this.smpIndices=[];for(var d=0;d<b.length;d++){this.smpIndices.push(b[d])}}if(e){var c=this.Fe(b);var g=this.isGroupedData?this.data.w:this.data.y;var f=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;for(var d=0;d<g.smps.length;d++){if(c.hasOwnProperty(d)){f[d]=false}else{f[d]=true}}}};this.WE=function(g){if(this.PU()){return}if(g){var b=this.isGroupedData?this.data.w:this.data.y;var e=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var f=[];if(this.Hl(g)){for(var d=0;d<g.length;d++){for(var c=0;c<b.smps.length;c++){if(b.smps[c]==g[d]){if(e[c]){e[c]=false}else{e[c]=true}break}}}}else{for(var d=0;d<b.smps.length;d++){if(b.smps[d]==g){if(e[d]){e[d]=false}else{e[d]=true}break}}}var a=[];for(var d=0;d<b.smps.length;d++){if(!e[d]){a.push(d)}}this.yV(a);this.Oj({func:"hideUnhideSmps",par:[g]})}};this.MJ=function(){var c=[];var g=this.isGroupedData?this.data.w.smps:this.data.y.smps;var h=this.isGroupedData?this.data.w:this.data.y;var e=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var f=this.isGroupedData?this.grpIndices:this.smpIndices;for(var d=0;d<g.length;d++){var a=-1;for(var b=0;b<f.length;b++){if(f[b]==d){a=b;break}}c.push({name:g[d],hidden:e[d],index:a})}return c};this.FP=function(b,e,d,c){return this.u4(b,e,d,c,"x")};this.tM=function(g,h){var j=this.data;if(j.y){var c=j.y.vars;if(!c){c=[];if(j.y.data){for(var f=0;f<j.y.data.length;f++){c.push("var"+(f+1))}}else{c=[];j.y.data=null}j.y.vars=c}var a=[];var b=[];if(!this.isDOE&&this.xAxis.length&&this.so()){g=this.xAxis2.length?this.as(this.xAxis).concat(this.as(this.xAxis2)):this.as(this.xAxis);if(this.Hl(g)){if(!g.length&&(this.isPivot||this.graphType=="Pie"||this.graphType=="Map")){for(var f=0;f<j.y.data.length;f++){g.push(f)}}}else{if(g>=0){g=[g]}else{g=false}}}if(g&&g.length){for(var f=0;f<g.length;f++){a.push(g[f]);b.push(false)}}else{for(var f=0;f<c.length;f++){a.push(f);b.push(false)}}if(!h&&this.smpIndices){this.la()}if(this.layoutComb&&this.layoutParams){for(var f=0;f<this.layoutParams.length;f++){var e=this.layoutParams[f];if(e&&e.startingVarIndices){e.varIndices=e.startingVarIndices;e.varIndicesStart=-1}}}this.varIndices=a;this.hiddenVars=b}};this.as=function(b,e,d,c){if(!d){d=this.data.y.vars;c=this.iT(d)}return this.NO(b,d,c)};this.J9=function(c,b){var d=this[c+"VarIndices"];d=[];for(var e=0;e<b.length;e++){d.push(b[e])}};this.JA=function(b){return this[b+"VarIndices"]};this.lG=function(c,b,d){return this.rj(c,b,d||this.varIndices,"z",this.hiddenVars)};this.tU=function(b,c){return this.wn(b,c||this.varIndices,"z")};this.Uf=function(b){this.varIndices=[];for(var c=0;c<b.length;c++){this.varIndices.push(b[c])}};this.wV=function(f){if(this.PU()){return}var e=this.data.y;var d=this.hiddenVars;if(f){if(this.Hl(f)){for(var c=0;c<f.length;c++){for(var b=0;b<e.vars.length;b++){if(e.vars[b]==f[c]){if(d[b]){d[b]=false}else{d[b]=true}break}}}}else{for(var c=0;c<e.vars.length;c++){if(e.vars[c]==f){if(d[c]){d[c]=false}else{d[c]=true}break}}}var a=[];for(var c=0;c<e.vars.length;c++){if(!d[c]){a.push(c)}}this.Uf(a);this.Oj({func:"hideUnhideVars",par:[f]})}};this.iW=function(){var d=[];for(var c=0;c<this.data.y.vars.length;c++){var a=-1;for(var b=0;b<this.varIndices.length;b++){if(this.varIndices[b]==c){a=b;break}}d.push({name:this.data.y.vars[c],hidden:this.hiddenVars[c],index:a})}return d};this.fO=function(b,e,d,c){return this.u4(b,e,d,c,"z")};this.FE=function(){var e=this.data.nodes;var g={};var f={};var a={};for(var b=0;b<e.length;b++){var c=e[b];g[c.id]=c;f[c.id]=b;a[c.id]=false}this.nodes=g;this.data.nodeIndices=f;this.nodeInitialCache=a;this.MK()};this.CK=function(){if(this.data.nodeIndices){var a=this.data.nodeIndices;var e=this.data.nodes;var f={};for(var b=0;b<e.length;b++){var c=e[b];f[c.id]=c}e=[];for(var b in a){e[a[b]]=f[b]}this.data.nodes=e;this.nodes=f;this.MK()}else{this.FE()}};this.tD=function(c){this.nodes={};this.data.nodeIndices={};var f=this.data.nodes;for(var a=0;a<f.length;a++){var b=f[a];b.hide=false;this.nodes[b.id]=b;this.data.nodeIndices[b.id]=a}var d=this.data.edges;for(var a=0;a<d.length;a++){d[a].hide=false}this.MK();if(!c){this.la()}};this.MK=function(){this.hiddenNodes={};this.hiddenEdges={};var d=this.data.nodes;for(var a=0;a<d.length;a++){this.hiddenNodes[d[a].id]=false}var b=this.data.edges;for(var a=0;a<b.length;a++){var c=b[a].id1+":"+b[a].id2;this.hiddenEdges[c]=false}};this.O1=function(b,c){c=c?true:false;this.isHiddenNodes=c;var f=this.data.nodes;var j=this.nodes;if(b){if(this.Hl(b)){for(var a=0;a<b.length;a++){var g=b[a];var e=f[this.data.nodeIndices[g]];e.hide=c;if(j&&j[g]!=null){j[g].hide=c}}}}else{for(var a=0;a<f.length;a++){var e=f[a];e.hide=c;if(j&&j[e.id]!=null){j[e.id].hide=c}}this.Hp();this.Oj({func:"hideUnhideNodes",par:[b,c]})}};this.Ui=function(){var d=this.data.tracks;for(var c=0;c<d.length;c++){var a=d[c];a.hide=false;var e=a.data;for(var b=0;b<e.length;b++){e[b].hide=false}}};this.AM=function(c,b,d){var e=this.meta.map.geojson.features;if(d){for(var a=0;a<e.length;a++){e[a].hidden=d}}for(var a=0;a<c.length;a++){e[c[a]].hidden=b}};this.ta=function(){if(this.meta.map&&this.meta.map.geojson){for(var a=0;a<this.meta.map.geojson.features.length;a++){this.meta.map.geojson.features[a].hidden=false}}};this.h4=function(c,a,b){if(this.graphType=="Network"){this.CK()}else{if(this.graphType!="Genome"&&this.graphType!="Venn"){this.tM(c,b);this.qT(a,b)}}};this.Ff=function(c){if(this.isGroupedData&&this.grpIndices&&this.data.w){if(c&&this.grpIndices.length){var a=[];for(var b=0;b<this.grpIndices.length;b++){var d=this.data.w.grps[this.grpIndices[b]];if(d){a=a.concat(d)}}this.smpIndices=a}else{this.h4()}}};this.cN=function(h,b,f,e){var d=this.graphType;var a=["colorByData","outlineByData","shapeByData","sizeByData","patternByData"];if(!e){this.h4(h,b,f)}if(d=="Network"||d=="Genome"){this.MR()}else{if(d!="Venn"){this.MR();for(var c=0;c<a.length;c++){if(this[a[c]]&&this.data.y.hasOwnProperty(this[a[c]])){this.FV(this[a[c]])}else{this[a[c]]=false}}if(this.oncoprintCNA&&this.data.y.hasOwnProperty(this.oncoprintCNA)){this.FV(this.oncoprintCNA);this.isOncoprint=true}if(this.oncoprintMUT&&this.data.y.hasOwnProperty(this.oncoprintMUT)){this.FV(this.oncoprintMUT)}if(this.heatmapType=="upset"){this.isUpSet=true}}}};this.RY=function(c){var b=["sankey","tree","bubble","gantt","contour"];for(var a=0;a<b.length;a++){delete (c[b[a]])}return c};this.ww=function(){if(!this.isGanttDataFormated){this.data.gantt=[];for(var b=0;b<this.data.y.vars.length;b++){this.data.gantt[b]=[];for(var a=0;a<this.data.y.smps.length;a++){var c=this.data.y.data[b][a]!=null?this.UW(this.data.y.data[b][a]).getTime():null;this.data.gantt[b].push(c)}}this.isGanttDataFormated=true}};this.F3=function(){if(!this.isQQ){this.s4(true)}};this.QM=function(){if(!this.isCDF){this.ce(true)}};this.Hx=function(){if(!this.isManhattanDataFormated){var h=this;var q=function(t,x){var u=0;for(var w=0;w<t-1;w++){u+=h.chromosomeLengths[w]}return u+x};var k=this.manhattanMarkerChromosomeNumber?this.sF(this.manhattanMarkerChromosomeNumber):-1;var o=this.manhattanMarkerPosition?this.sF(this.manhattanMarkerPosition):-1;var b=this.manhattanMarkerLogPValue?this.sF(this.manhattanMarkerLogPValue):-1;var s=this.manhattanRangeStart?this.sF(this.manhattanRangeStart):-1;var j=this.manhattanRangeEnd?this.sF(this.manhattanRangeEnd):-1;var d=this.manhattanCNV?this.sF(this.manhattanCNV):-1;if(this.scatterType=="manhattan"){if(k<0){this.scatterType=false;alert("Missing marker chromosome number");return}if(o<0){this.scatterType=false;alert("Missing marker base position");return}if(b<0){this.scatterType=false;alert("Missing marker p-value");return}}else{if(this.scatterType=="manhattanCNV"){if(k<0){this.scatterType=false;alert("Missing marker chromosome number");return}if(s<0){this.scatterType=false;alert("Missing marker start base position");return}if(j<0){this.scatterType=false;alert("Missing marker end base position");return}if(d<0){this.scatterType=false;alert("Missing CNV value");return}}}if(!this.chromosomeLengths.length&&(o>=0||j>=0)){var a=[];for(var g=0;g<this.data.y.vars.length;g++){var f=this.data.y.data[g][k];var l=this.scatterType=="manhattan"?this.data.y.data[g][o]:this.data.y.data[g][j];if(!a[f]){a[f]=[]}a[f].push(l)}for(var g=0;g<a.length;g++){this.chromosomeLengths[g]=this.Wj(a[g]||[0])+1}}else{if(!this.chromosomeLengths.length){alert("Ooops! Missing chromosome lengths and no way to calculate them.");this.scatterType=false;return}}if(this.scatterType=="manhattan"){var p=this.sF("Manhattan");if(p>=0){for(var g=0;g<this.data.y.vars.length;g++){this.data.y.data[g][p]=q(this.data.y.data[g][k],this.data.y.data[g][o])}}else{this.data.y.smps.push("Manhattan");for(var g=0;g<this.data.y.vars.length;g++){this.data.y.data[g].push(q(this.data.y.data[g][k],this.data.y.data[g][o]))}}}else{if(this.scatterType=="manhattanCNV"){var e=this.sF("ManhattanStart");var r=this.sF("ManhattanEnd");if((e<0&&r>=0)||(e>=0&&r<0)){this.scatterType=false;return}else{if(e>=0&&r>=0){for(var g=0;g<this.data.y.vars.length;g++){this.data.y.data[g][e]=q(this.data.y.data[g][k],this.data.y.data[g][s]);this.data.y.data[g][r]=q(this.data.y.data[g][k],this.data.y.data[g][j])}}else{this.data.y.smps.push("ManhattanStart");this.data.y.smps.push("ManhattanEnd");for(var g=0;g<this.data.y.vars.length;g++){this.data.y.data[g].push(q(this.data.y.data[g][k],this.data.y.data[g][s]));this.data.y.data[g].push(q(this.data.y.data[g][k],this.data.y.data[g][j]))}}}}else{alert("Ooops! Wrong Manhattan type.");this.scatterType=false;return}}var c=this.meta.config.user;this.manhattanMarkerChromosomeNumberIndex=k;this.manhattanMarkerPositionIndex=o;this.manhattanMarkerLogPValueIndex=b;this.manhattanRangeStartIndex=s;this.manhattanRangeEndIndex=j;this.manhattanCNVIndex=d;this.xAxis=this.scatterType=="manhattanCNV"?["ManhattanStart"]:["Manhattan"];this.xAxisTitle=c.xAxisTitle||"Chromosome";this.yAxis=this.scatterType=="manhattanCNV"?[this.data.y.smps[d]]:[this.data.y.smps[b]];this.yAxisTitle=c.yAxisTitle||(this.scatterType=="manhattanCNV"?this.data.y.smps[d]:this.data.y.smps[b]);this.xAxisGridMajorShow=c.xAxisGridMajorShow||false;this.xAxisGridMinorShow=c.xAxisGridMinorShow||false;this.xAxisLineRighShow=c.xAxisLineRightShow||false;this.yAxisGridMinorShow=c.yAxisGridMinorShow||false;this.yAxisLineTopShow=c.yAxisLineTopShow||false;this.yAxisLineBottomShow=c.yAxisLineBottomShow||false;this.isManhattanDataFormated=true}};this.oV=function(){if(this.sankeySource&&this.sankeyTarget){this.data.sankey={nodes:[],links:[]};var g={};for(var c=0;c<this.smpIndices.length;c++){var e=this.smpIndices[c];var d=this.mU(e,"x",this.sankeySource);var b=this.mU(e,"x",this.sankeyTarget);var a=this.uP(this.xAxisIndices[0],e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);this.data.sankey.links.push({source:d,target:b,value:a,id:e});g[d]=true;g[b]=true}var h=0;for(var c in g){this.data.sankey.nodes.push({name:c,id:h++})}var f={};this.data.sankey.nodes.forEach(function(j){f[j.name]=j});this.data.sankey.links=this.data.sankey.links.map(function(j){return{source:f[j.source],target:f[j.target],parent:j.parent,value:j.value,id:j.id}})}else{if(this.data.sankey){var f={};this.data.sankey.nodes.forEach(function(j){f[j.name]=j});this.data.sankey.links=this.data.sankey.links.map(function(j){return{source:f[j.source],target:f[j.target],parent:j.parent,value:j.value,id:j.id}})}}};this.Zq=function(b){if(this.graphType=="Sankey"||(this.graphType=="Circular"&&(this.circularType=="sunburst"||this.circularType=="bubble"))){this.xAxisIndices[0]=this.as(this.xAxis[0])}if(this.hierarchy.length>0){if(!this.data[b]||(this.data[b].hierarchy&&!this.eI(this.data[b].hierarchy,this.hierarchy))){this.data[b]={};this.data[b]["data"]={name:this.hierarchy[0],children:[]};for(var f=0;f<this.smpIndices.length;f++){var l=this.smpIndices[f];var a=this.data[b]["data"].children;for(var e=0;e<this.hierarchy.length;e++){var c=this.hierarchy[e];var h=-1;for(var d=0;d<a.length;d++){if(this.mU(l,"x",c)==a[d].name){h=d}}if(h==-1){var g=this.mU(l,"x",c);if(g!=null){a.push({name:g,children:[]});h=a.length-1}else{if(e==this.hierarchy.length-1){a.push({name:this.data.y.smps[l],size:this.data.y.data[this.xAxisIndices[0]][l],idx:l});continue}else{continue}}}a=a[h].children;if(e===this.hierarchy.length-1){a.push({name:this.data.y.smps[l],size:this.data.y.data[this.xAxisIndices[0]][l],idx:l})}}}}}else{this.data[b]={};this.data[b]["data"]={name:"Samples",children:[]};for(var f=0;f<this.smpIndices.length;f++){var l=this.smpIndices[f];var a=this.data[b]["data"].children;a.push({name:this.data.y.smps[l],size:this.data.y.data[this.xAxisIndices[0]][l],idx:l})}}};this.gK=function(a){var b=window.location.origin;var d={};var c=[];for(m in CanvasXpress.countries){var e=CanvasXpress.countries[m][0];d[m]=[e,b+"/data/maps/"+m+".json"];c.push(e)}for(m in CanvasXpress.usa){var e=CanvasXpress.usa[m][0];d[m]=[e,b+"/data/maps/"+m+".json"];c.push(e)}for(m in CanvasXpress.maps){d[m]=[m,CanvasXpress.maps[m]];c.push(m)}return a?c:d};this.UZ=function(c){if(!c){c="png"}var b=window.location.origin+"/data/flags"+(c=="svg"?"/svg/3x2/":"/png/");var a={};for(m in CanvasXpress.countries){var e=CanvasXpress.countries[m][0];var d=c=="svg"?CanvasXpress.countries[m][3]:CanvasXpress.countries[m][3].toLowerCase();a[m]=[e,b+d+"."+c]}return a};this.jY=function(f,d,a){var c=this;var h=function(l){if(c.isJupyter&&l.hasOwnProperty("y")&&!l.hasOwnProperty("x")&&!l.hasOwnProperty("z")){var e=c.Ev(l.y.vars);var k=c.Ev(l.y.smps);k.unshift("Id");l=l.y.data;for(var j=0;j<l.length;j++){l[j].unshift(e[j])}l.unshift(k)}return l};if(f&&typeof f=="string"){try{f=JSON.parse(f)}catch(g){}}f=h(f);this.data=f||CanvasXpress.example;this.isExample=f?false:true;if(this.isExample){this.$(this.target).style.display="none"}this.nodesData=false;this.edgesData=false;this.featuresData=false;if(d){delete this.meta.data;this.meta.vals={}}this.validGraphTypes=[];if(Array.isArray(f)&&Array.isArray(f[0])){var b=this.arrayToCX(this.Ev(f),this.meta.config.user);this.data=b.data;if(b.config&&b.config.summaryType){this.summaryType=b.config.summaryType;this.dataTableZeroHeader=b.config.dataTableZeroHeader||""}this.T5();if(b.config&&b.config.graphType=="Scatter2D"){this.I1()}if(b.config.isGraphTime){this.isGraphTime=true;this.xAxisTime=b.config.xAxisTime;this.yAxisTime=b.config.yAxisTime}}else{if(this.isDataFrame){this.data=this.ji(f,this.meta.config.user);this.T5();if(b.config&&b.config.graphType=="Scatter2D"){this.I1()}if(b.config.isGraphTime){this.isGraphTime=true;this.xAxisTime=b.config.xAxisTime;this.yAxisTime=b.config.yAxisTime}}else{this.mh()}}if(this.data&&(this.data.y||this.data.venn||this.data.nodes||this.data.tracks||this.data.fx)){if(this.data.fx){this.jB()}if(this.data.venn){if(this.graphType=="Venn"){this.summaryType="venn"}this.validGraphTypes.push("Venn")}if(this.data.nodes){if(this.graphType=="Network"){this.summaryType="network"}this.validGraphTypes.push("Network")}if(this.data.tracks){if(this.graphType=="Genome"){this.summaryType="genome"}this.validGraphTypes.push("Genome")}if(this.data.y){this.llmHeader=this.Vq();if(!this.data.y&&!this.data.y.cor&&!this.data.y.close){alert("Dude! there is not a valid data structure");return}else{if(this.data.y.data){this.isRawData=true;this.summaryType=this.summaryType&&this.summaryType.match(/iqr|median|mean|cor|sum|max|min|count|gantt/)?this.summaryType:"raw";if(this.summaryType=="cor"){this.graphType="Correlation"}else{if(this.summaryType=="iqr"){this.graphType="Boxplot"}else{if(this.summaryType=="gantt"){this.graphType="Gantt"}else{if(this.data.y[this.summaryType]){if(this.eI(this.data.y[this.summaryType],this.data.y.data)){this.isRawData=false}}}}}if(this.graphType=="Gantt"){if(!this.ganttStart||this.as(this.ganttStart)<0){this.ganttStart=this.data.y.vars[0]}if(!this.ganttEnd||this.as(this.ganttEnd)<0){this.ganttEnd=this.data.y.vars[1]||this.data.y.vars[0]}this.ww()}else{if(this.graphType=="Scatter2D"&&this.scatterType&&this.scatterType.match(/manhattan/)){this.Hx()}}}else{this.isRawData=false;if(this.data.y.iqr1&&this.data.y.qtl1&&this.data.y.median&&this.data.y.qtl3&&this.data.y.iqr3){this.summaryType="iqr"}else{if(this.data.y.median){this.summaryType="median"}else{if(this.data.y.mean){this.summaryType="mean"}else{if(this.data.y.cor){this.summaryType="cor"}else{if(this.data.y.sum){this.summaryType="sum"}else{if(this.data.y.max){this.summaryType="max"}else{if(this.data.y.min){this.summaryType="min"}else{if(this.data.y.count){this.summaryType="count"}else{this.summaryType=false}}}}}}}}}}this.validGraphTypes.push("Bar");this.validGraphTypes.push("Line");this.validGraphTypes.push("Area");this.validGraphTypes.push("AreaLine");this.validGraphTypes.push("BarLine");this.validGraphTypes.push("Boxplot");this.validGraphTypes.push("Dotplot");this.validGraphTypes.push("DotLine");this.validGraphTypes.push("Heatmap");this.validGraphTypes.push("Stacked");this.validGraphTypes.push("StackedLine");this.validGraphTypes.push("StackedPercent");this.validGraphTypes.push("StackedPercentLine");this.validGraphTypes.push("Pie");this.validGraphTypes.push("Correlation");this.validGraphTypes.push("Circular");if(this.data.y.smps||this.isDOE){if(this.data.y.smps.length>2||this.isDOE){this.validGraphTypes.push("Scatter2D");this.validGraphTypes.push("ScatterBubble2D");this.validGraphTypes.push("Scatter3D")}else{if(this.data.y.smps.length>1||this.isDOE){this.validGraphTypes.push("Scatter2D")}}}}this.validGraphTypes.sort();this.cN(false,false,a)}}};CanvasXpress.prototype.initAesthetics=function(){this.initLegendUtils();this.initMarkerUtils()};CanvasXpress.prototype.initScale=function(){};CanvasXpress.prototype.initGeometry=function(){this.initPrimitives();this.initUtils();this.initDendrograms();this.initGraph()};CanvasXpress.prototype.initStatistics=function(){this.initNumeric();this.initjLouvain();this.initCola();this.initMathUtils();this.initSankeyUtils();this.initTreeUtils();this.initCirclePackUtils();this.initNetworkUtils();this.initFFT();this.initContour();this.initDensity();this.initHist();this.initLoess();this.initQuantreg();this.initLAPACK();this.initClusterUtils()};CanvasXpress.prototype.initFacets=function(){this.initLayout()};CanvasXpress.prototype.initCoordinates=function(){this.initAxes()};CanvasXpress.prototype.initTheme=function(){this.hM=function(c){var a=c.toLowerCase().replace(/ /g,"");switch(a){case"grey":case"gray":case"igray":case"ggplot":return CanvasXpress.themeDef.grey;case"bw":case"blackandwhite":return CanvasXpress.themeDef.bw;case"linedraw":return CanvasXpress.themeDef.linedraw;case"light":return CanvasXpress.themeDef.light;case"dark":return CanvasXpress.themeDef.dark;case"minimal":return CanvasXpress.themeDef.minimal;case"classic":return CanvasXpress.themeDef.classic;case"void":case"void0":return CanvasXpress.themeDef.void0;case"economist":return CanvasXpress.themeDef.economist;case"excel":return CanvasXpress.themeDef.excel;case"solarized":return CanvasXpress.themeDef.solarized;case"paulTol":case"paultol":case"ptol":return CanvasXpress.themeDef.ptol;case"highcharts":return CanvasXpress.themeDef.highcharts;case"wallstreetjournal":case"wallstreet":case"wsj":return CanvasXpress.themeDef.wsj;case"tableau":return CanvasXpress.themeDef.tableau;case"stata":return CanvasXpress.themeDef.stata;case"ggblanket":return CanvasXpress.themeDef.ggblanket;case"cx":case"canvasxpress":return CanvasXpress.themeDef.cx;case"cxdark":case"canvasxpressdark":return CanvasXpress.themeDef.cxdark;case"cx2":case"canvasxpresstraditional":return CanvasXpress.themeDef.grey;default:var b=this.Ev(CanvasXpress.themeDef.light);b["panel.border.colour"]=null;return b}};this.L3=function(b){if(!b){b="x"}var e=["AxisShow","Axis2Show","AxisTitleColor","AxisTitleScaleFontFactor","AxisTextColor","AxisTextScaleFontFactor","AxisTicksShow","AxisTicksColor","AxisTicksLength","AxisTicksWidth","AxisLineBottomShow","AxisLineBottomColor","AxisLineBottomLineType","AxisLineBottomWidth","AxisLineTopShow","AxisLineTopColor","AxisLineTopLineType","AxisLineTopWidth","AxisGridMajorShow","AxisGridMajorColor","AxisGridMajorLineType","AxisGridMajorWidth","AxisGridMinorShow","AxisGridMinorColor","AxisGridMinorLineType","AxisGridMinorWidth"];var f=["r","z"];for(var d=0;d<f.length;d++){for(var c=0;c<e.length;c++){this[f[d]+e[c]]=this[b+e[c]]}}};this.bN=function(c){var b=c.toLowerCase().replace(/ /g,"");var a=CanvasXpress.graphTypes.OneDGraphs.includes(this.graphType);this.theme="none";this.backgroundType="panel";this.colorScheme="User";this.guidesShow=false;this.guidesColor="#cccccc";this.lineDecoration="symbol";this.mapOutlineColor="#cccccc";this.objectBorderColor="rgba(0,0,0,0)";this.fitLineColor="#FFD700";this.legendColumns=1;this.widthFactor=1;switch(b){case"grey":case"gray":case"igray":case"ggplot":this.guidesShow=true;this.guidesColor="#ffffff";this.mapOutlineColor="#ffffff";this.fitLineColor="#0000FF";this.objectBorderColor="rgba(0,0,0,0)";this.colorScheme="GGPlot";break;case"bw":case"blackandwhite":this.backgroundType="solid";this.lineDecoration="pattern";this.colorScheme="BlackAndWhite";break;case"linedraw":this.colorScheme="GGPlot";break;case"light":this.colorScheme="GGPlot";break;case"dark":this.colorScheme="GGPlot";break;case"minimal":this.colorScheme="GGPlot";break;case"classic":this.colorScheme="GGPlot";break;case"void":case"void0":this.colorScheme="GGPlot";break;case"economist":this.colorScheme="Economist";this.backgroundType="solid";this.mapOutlineColor="#D5E4EB";this.legendColumns=8;if(a){this.xAxisTicksMajorShow=true}break;case"excel":this.colorScheme="Excel";this.mapOutlineColor="#C0C0C0";if(a){this.xAxisTicksMajorShow=true}break;case"solarized":this.colorScheme="Solarized";this.backgroundType="solid";this.mapOutlineColor="#FDF6E3";break;case"paulTol":case"paultol":case"ptol":this.colorScheme="PaulTol";this.backgroundType="solid";this.mapOutlineColor="#ffffff";break;case"highcharts":this.colorScheme="Highcharts";this.backgroundType="solid";this.mapOutlineColor="#ffffff";this.objectBorderColor="rgba(0,0,0,0)";this.widthFactor=0.75;break;case"wallstreetjournal":case"wsj":this.colorScheme="WallStreetJournal3";this.backgroundType="solid";this.mapOutlineColor="#F8F2E4";this.legendColumns=4;if(a){this.xAxisTicksMajorShow=true}break;case"tableau":this.colorScheme="TableauMedium";this.mapOutlineColor="#E5E5E5";break;case"stata":this.colorScheme="Stata";this.mapOutlineColor="#EAF2F3";this.legendColumns=4;if(a){this.xAxisTicksMajorShow=true}break;case"ggblanket":this.colorScheme="GGBlanket";break;case"cx":case"canvasxpress":this.colorScheme="CanvasXpress";this.stripBackgroundColor="rgba(0,0,0,0)";this.stripBackgroundBorderColor="rgba(0,0,0,0)";this.objectBorderColor="rgba(0,0,0,0)";this.xAxisLineBottomShow=true;this.xAxisTicksShow=true;break;case"cx2":case"canvasxpresstraditional":this.colorScheme="CanvasXpressTraditional";this.objectBorderColor="rgb(0,0,0)";this.panelBackgroundBorderColor="#337AB7";break;case"cxdark":case"canvasxpressdark":this.colorScheme="CanvasXpress";this.stripBackgroundColor="rgba(0,0,0,0)";this.stripBackgroundBorderColor="rgba(0,0,0,0)";this.objectBorderColor="rgba(0,0,0,0)";this.xAxisLineBottomShow=true;this.xAxisTicksShow=true;this.xAxisLineBottomColor="rgb(255,255,255)";this.smpTextColor="rgb(255,255,255)";this.smpTitleColor="rgb(255,255,255)";break;case"lastairbenderfire":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderFire";break;case"lastairbenderair":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderAir";break;case"lastairbenderwater":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderWater";break;case"lastairbenderearth":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderEarth";break;case"gameofthronestargaryen":this.colorScheme="GameOfThronesTargaryen";break;case"gameofthronesstark":this.colorScheme="GameOfThronesStark";break;case"gameofthronesstannis":this.colorScheme="GameOfThronesStannis";break;case"gameofthroneslannister":this.colorScheme="GameOfThronesLannister";break;case"gameofthronestyrell":this.colorScheme="GameOfThronesTyrell";break;case"gameofthronesmartell":this.colorScheme="GameOfThronesMartell";break;case"gameofthronestully":this.colorScheme="GameOfThronesTully";break;case"gameofthronesgreyjoy":this.colorScheme="GameOfThronesGreyjoy";break;case"gameofthronesmanderly":this.colorScheme="GameOfThronesManderly";break;case"gameofthronesarryn":this.colorScheme="GameOfThronesArryn";break;default:this.colorScheme="User";this.colors=["#0ab0db","#fe6969","#fed385","#47db0a","#9e0adb","#ff7d00","#ffa2c0","#a0d7e7","#63b5e5","#f9a7a7","#fef0c7","#83e16f","#c763e5","#ffb347","#ffc1d3","#bfe2ed"];break}};this.YN=function(a){return this.fQ(a)};this.oe=function(){this.defaultThemeValues={};for(var a in CanvasXpress.themeParams){this.defaultThemeValues[a]=this[a]}};this.fQ=function(c,a){if(!c){c=CanvasXpress.stack[this.target]&&CanvasXpress.stack[this.target].config&&CanvasXpress.stack[this.target].config.theme?CanvasXpress.stack[this.target].config.theme:"none"}var b=this.hM(c);this.wK(b,true);this.L3();this.bN(c);this.oe();if(!a){this.Oj({func:"setTheme",par:[c]})}}};CanvasXpress.prototype.initRender=function(){this.Mc=function(p){var l=this;var c=function(i){return s&&s.map.hasOwnProperty(i)?s.map[i]:false};if(!this.counterFoo){this.counterFoo=[]}if(!this.counterFoo[this.layoutCurrent||0]){this.counterFoo[this.layoutCurrent||0]=0}this.counterFoo[this.layoutCurrent||0]++;var m=function(i,B){var C=i.replace("draw","get")+"Area";return l[C].apply(l,B)};var q=p.p;var r=p.i;var y=p.m;var n=p.g;var t=p.s;var d=p.b;var A=p.t;var f=p.h;var h=this.meta.render;var s=h.transition;var x=q.shift();var k=p.i?m(x,q):false;var b=x.match(/^draw/)?x.replace("draw","").substring(0,1):"O";var g=h.objects.length;var o=this.transparencyHidden;n=n!=null?n.toString():g;if(!h.groups.hasOwnProperty(n)){h.groups[n]=[]}if(!h.types.hasOwnProperty(A)){h.types[A]={all:[],drawShape:[],drawLine:[],drawText:[],drawArcText:[],other:[]}}if(!h.order.includes(A)){h.order.push(A)}var w=h.types[A].hasOwnProperty(x)?h.types[A][x].length:h.types[A].other.length;var u=r&&this.Hl(r)?r.join(":"):r?r:A+":"+b+":"+this.RX(w);h.objects.push({func:x,params:q,idx:r,id:u,n:g,modifier:y,group:n,area:k,layout:(this.layoutComb?this.layoutCurrent:false),type:A,skip:t,baseline:d});h.groups[n].push(g);h.types[A].all.push(g);switch(x){case"drawShape":h.types[A].drawShape.push(g);break;case"drawLine":h.types[A].drawLine.push(g);break;case"drawText":h.types[A].drawText.push(g);break;case"drawArcText":h.types[A].drawText.push(g);break;default:h.types[A].other.push(g);break}if(n!=g&&x=="drawLine"&&h.objects[n].idx){if(!r){r=h.objects[n].idx}u=r.join(":")+":"+h.groups[n].length;h.objects[g].id=u;if(this.showBoxplotOriginalData){}}h.origin[g]=[];var a=h.map;var z=h.origin[g];if(this.showTransition){if(A=="Data"&&r&&!this.graphType.match(/Scatter|Treemap|Circular/)){if(this.isGroupedData){if((this.dQ()&&r[r.length-1]!="box")||this.graphType.match(/Stacked/)){u=r[0]+":"+r[r.length-1];a[u]=g;z.push(c(u))}else{if(r.length==2&&n==g){var e=this.data.w.grps[r[1]]||[];var j=e.length;for(var v=0;v<j;v++){u=r[0]+":"+e[v];a[u]=g;z.push(c(u))}}else{if(r.length==3&&r[2]=="box"){var e=this.data.w.grps[r[1]]||[];var j=e.length;for(var v=0;v<j;v++){u=r[0]+":"+e[v]+":box";a[u]=g;z.push(c(u))}}else{a[u]=g;z.push(c(u))}}}}else{a[u]=g;z.push(c(u))}}else{a[u]=g;z.push(c(u))}}if(CanvasXpress.graphTypes.OneTwoThreeeDGraphs.includes(this.graphType)||this.graphType=="TagCloud"||this.graphType=="Map"||this.graphType=="Network"||this.graphType=="Sankey"){if(f){if(this.filterMode=="color"){switch(x){case"drawShape":q[5]=this.missingDataColor;q[6]=this.missingDataColor;break;case"drawLine":q[5]=this.missingDataColor;break;case"drawText":q[4]=this.missingDataColor;break;case"drawArcText":q[7]=this.missingDataColor;break}}else{switch(x){case"drawShape":q[5]=this.eN(this.Y3(q[5]),o,true);q[6]=this.eN(this.Y3(q[6])||this.foreground,o,true);break;case"drawLine":q[5]=this.eN(this.Y3(q[5]),o,true);break;case"drawText":q[4]=this.eN(this.Y3(q[4]),o,true);break;case"drawArcText":q[7]=this.eN(this.Y3(q[7]),o,true);break}}}}if(this.debug&&!this.isSVG||(this.graphType=="Network"&&this.is3DNetwork&&this.isR)){this.s2(g,g+1)}return g};this.pO=function(c,d){var a=this.meta.render;var b=this.us();if(a.objects.length>0&&!this.skipTransition&&this.showTransition){delete (a.transition);if(!d){if(this.graphType=="Network"&&!this.isLayoutDone){}else{a.transition=this.Ev(a)}}}if(!c){a.objects=[];a.groups={};a.types={};a.order=[];a.map={};a.origin=[]}b.resetRender();b.resetContext()};this.s2=function(k,f,h){if(!this.skipRender){this.GW("render - start");var j=this.us();var c=this.meta.render.objects;var g=0;if(c.length>0){if(!k){k=0}if(!f){f=c.length}for(var d=k;d<f;d++){var b=c[d];var a=b.params;switch(b.func){case"drawShape":this.f6(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15],j);break;case"drawLine":this.hC(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15],a[16],j);break;case"drawText":this.VU(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],j);break;case"setClipArea":this.il(a[0],j);break;case"resetClipArea":this.Np(j);break;case"setGlobalCompositionOperation":this.b6(a[0],j);break;default:this[b.func].apply(this,b.params);break}g++}}j.render();this.GW("render - end - "+g+"/"+(f-k)+" objects");if(!h){j.resetRender()}}}};CanvasXpress.prototype.initUI=function(){this.initSave();this.initSVG();this.initInterface();this.initFilterUtils();this.initSortUtils();this.initTooltip();this.initTooltipMouse();this.initTooltipDiv();this.initLLM();this.initToolbar();this.initMenus();this.initLinks();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initCustomizer();this.initEvents();this.initAnimation();this.initRemote()};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.$cXI=function(f,a,o,m,j){try{CanvasXpress}catch(e){return false}var that=this;var showAltTooltip=function(ev){var el=ev.target;while(el.tagName!=="svg"){el=el.parentNode}var ch=el.parentNode.className.match(/cX-chat/);var ac=that.appLayout||that.customizing?el.getBoundingClientRect():ch?that.SX(ev,el.parentNode.parentNode):that.SX(ev,el.parentNode);var tt=that.$(that.target+"canvasXpressAltTooltip");var ti;if(!el.dataset.title){var te=el.querySelector("title");if(!te){return false}ti=te?te.innerHTML:"";el.setAttribute("data-title",ti);te.parentNode.removeChild(te)}else{ti=el.dataset.title}if(ti=="Chat with AI"){ac.y+=that.height-4}if(tt){tt.innerHTML=ti;tt.style.display="block";tt.style.left=((ac.left||ac.x)-1.5)+"px";tt.style.top=((ac.top||ac.y)+18)+"px"}return false};var hideAltTooltip=function(){var tt=that.$(that.target+"canvasXpressAltTooltip");if(tt){tt.style.display="none"}};var b=document.createElementNS("http://www.w3.org/2000/svg","svg");var e=function(q){var k={};var i=q.split(/class=/);var t="<style>";for(var u=1;u<i.length;u++){var p=i[u].match(/'(.+?)'/);if(p){var s=p[1].split(/\s+/);for(var r=0;r<s.length;r++){var d=s[r];if(CanvasXpress.icons.classes.hasOwnProperty(d)&&!k.hasOwnProperty(d)){var tt=CanvasXpress.icons.classes[d];tt=tt.replace(/l:/g,"stroke-miterlimit:");tt=tt.replace(/w:/g,"stroke-width:");tt=tt.replace(/n:/g,"font:");tt=tt.replace(/s:/g,"stroke:");tt=tt.replace(/f:/g,"fill:");t+="."+d+tt}}}}t+="</style>";return t};if(CanvasXpress.icons.use.hasOwnProperty(f)){var h="<rect class='cxnc' x='0' y='0' width='100' height='100' />";if(CanvasXpress.icons.gradients.hasOwnProperty(f)){var hh=CanvasXpress.icons.gradients[f];hh=hh.replace(/s=/g,"style=");hh=hh.replace(/o=/g,"offset=");hh=hh.replace(/c=/g,"stop-color=");hh=hh.replace(/q=/g,"gradientTransform=");hh=hh.replace(/u=/g,"gradientUnits=");hh=hh.replace(/<\/s/g,"</stop").replace(/<s/g,"<stop");hh=hh.replace(/<\/r/g,"</radialGradient").replace(/<r/g,"<radialGradient");hh=hh.replace(/<\/l/g,"</linearGradient").replace(/<l/g,"<linearGradient");h+=hh}for(var g=0;g<CanvasXpress.icons.use[f].length;g++){var hh=CanvasXpress.icons.symbols[CanvasXpress.icons.use[f][g]];hh=hh.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");hh=hh.replace(/<\/l/g,"</line").replace(/<l/g,"<line");hh=hh.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");hh=hh.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");hh=hh.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");hh=hh.replace(/<\/t/g,"</text").replace(/<t/g,"<text");hh=hh.replace(/tr=/g,"transform=");hh=hh.replace(/q=/g,"points=");hh=hh.replace(/h=/g,"height=");hh=hh.replace(/w=/g,"width=");hh=hh.replace(/c=/g,"class=");h+=hh}var l=e(h);if(!j){j=24}b.setAttribute("xmlns","http://www.w3.org/2000/svg");b.setAttribute("viewBox","0 0 100 100");b.setAttribute("style","width:"+j+"px;height:"+j+"px;box-sizing:border-box;");if(a){for(var g in a){if(g=="className"){b.setAttribute("class",a[g])}else{b.setAttribute(g,a[g])}}}b.addEventListener("mousemove",showAltTooltip.bind(event));b.addEventListener("mouseout",hideAltTooltip);var z=a&&a.hasOwnProperty("title")?"<title>"+a.title+"</title>":"";if(o){for(var g in o){b.style[g]=o[g]}}b.innerHTML=z+l+h}return m?new XMLSerializer().serializeToString(b):b};this.$cXIU=function(b,e,a,l){try{CanvasXpress}catch(f){return false}var j="";var d=function(p){var n={};var k=p.split(/class=|c=/);var s="<style>";for(var t=1;t<k.length;t++){var o=k[t].match(/'(.+?)'/);if(o){var r=o[1].split(/\s+/);for(var q=0;q<r.length;q++){var i=r[q];if(CanvasXpress.icons.classes.hasOwnProperty(i)&&!n.hasOwnProperty(i)){s+="."+i+CanvasXpress.icons.classes[i]}}}}s+="</style>";s=s.replace(/l:/g,"stroke-miterlimit:");s=s.replace(/w:/g,"stroke-width:");s=s.replace(/n:/g,"font:");s=s.replace(/s:/g,"stroke:");s=s.replace(/f:/g,"fill:");return s};if(b&&CanvasXpress.icons.use.hasOwnProperty(e)){var g="";if(CanvasXpress.icons.gradients.hasOwnProperty(e)){g+=CanvasXpress.icons.gradients[e];g=g.replace(/&quot;/g,'"').replace(/&apos;/g,"'");g=g.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");g=g.replace(/<\/l/g,"</line").replace(/<l/g,"<line");g=g.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");g=g.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");g=g.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");g=g.replace(/<\/t/g,"</text").replace(/<t/g,"<text");g=g.replace(/tr=/g,"transform=");g=g.replace(/q=/g,"points=");g=g.replace(/h=/g,"height=");g=g.replace(/w=/g,"width=");g=g.replace(/c=/g,"class=")}for(var f=0;f<CanvasXpress.icons.use[e].length;f++){var gi=CanvasXpress.icons.symbols[CanvasXpress.icons.use[e][f]].replace(/&quot;/g,'"').replace(/&apos;/g,"'");gi=gi.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");gi=gi.replace(/<\/l/g,"</line").replace(/<l/g,"<line");gi=gi.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");gi=gi.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");gi=gi.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");gi=gi.replace(/<\/t/g,"</text").replace(/<t/g,"<text");gi=gi.replace(/tr=/g,"transform=");gi=gi.replace(/q=/g,"points=");gi=gi.replace(/h=/g,"height=");gi=gi.replace(/w=/g,"width=");gi=gi.replace(/c=/g,"class=");g+=gi}g="<rect class='cxnc' x='0' y='0' width='100' height='100' />"+g;var h=d(g);if(a){for(var f in a){if(f=="className"){b.setAttribute("class",a[f])}else{b.setAttribute(f,a[f]);if(f=="title"){j="<title>"+a[f]+"</title>"}}}}if(l){for(var f in l){b.style[f]=l[f]}}b.innerHTML=j+h+g}};this.$pX=function(){var t=this;var q=t.$w;var p=t.$(t.target+q(2));if(p){return p.value}else{if(t.meta.config&&t.meta.config.user&&t.meta.config.user[q(0)]){return t.meta.config.user[q(0)]}else{return false}}};this.js=function(s){var h="";for(var i=0;i<s.length;i++){h+=""+s.charCodeAt(i).toString(16)}return h};this.$h=function(h){var s="";for(var i=0;i<h.length;i+=2){s+=String.fromCharCode(parseInt(h.substr(i,2),16))}return s};this.$w=function(i,n){var q=function(h){var s="";for(var i=0;i<h.length;i+=2){s+=String.fromCharCode(parseInt(h.substr(i,2),16))}return s};try{CanvasXpress}catch(e){return false}return i>50?CanvasXpress.colorWords[i]:n?q(CanvasXpress.colorWords[i].split("").reverse().join("")).split("").reverse().join(""):q(CanvasXpress.colorWords[i].split("").reverse().join(""))};this.LC=function(){try{CanvasXpress}catch(f){return false}if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.png),width:1,height:1,loading:"eager",title:"CanvasXpress",alt:"CanvasXpress"})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.$$=function(){try{CanvasXpress}catch(f){return false}var o=this;var j=CanvasXpress;var g=function(i){if(!i){i=j[h[4]]}else{if(i.length>36){return 0}}var c=i.length;var f=Number(i.substring(2,3));var d=Number(i.substring(c-3,c-2));var q=i.substring(3+f,3+f+5)[h[7]]("")[h[8]]()[h[9]]("");var m=i.substring(c-(3+d+5),c-(3+d));return Number(q+""+m+"000")};var l=["686578546f537472696e67","6472617754657874","666163746f7279","73797374656d","72656769737465726564","76616c6964","737562737472696e67","73706c6974","72657665727365","6a6f696e","43616e766173587072657373","4e6f7420612076616c696420636f7079206f6620","556e737570706f727465642056657273696f6e206f6620","20522056657273696f6e","204e6f64652056657273696f6e","697352566965776572","697352436f6e736f6c65","68726566","2f7777772e63616e7661737870726573732e6f72672f646973742f","72616e646f6d496e744265747765656e","666f6e7453697a65","666f6e744e616d65","69734378706c6f74","6378706c6f742042792043616e766173587072657373","736574506978656c496d616765","64697361626c65426561636f6e","69734a757079746572"];var h=[];for(var e=0;e<l.length;e++){h.push(o.$h(l[e]))}var a=Number(g());var p=Number(o.meta.time.start);var n=isNaN(j[h[2]][h[5]])?Number(g(j[h[2]][h[5]])):0;var k=new RegExp(h[18]).test(j[h[2]][h[17]])||j[h[3]][h[15]]||j[h[3]][h[16]];var b=o[h[22]]?h[23]:h[10];if(!k){if(a-p<0){if(!n||n-p<0){if(j[h[2]][h[5]]){b=h[11]+h[10]}setTimeout(function(){o.$$$(b)},o[h[19]](1,3)*1000)}}}};this.$$$=function(m){var t=this;var w=["6472617754657874","666f6e744e616d65"];var d=[];var s=Math.min(t.width,t.height);var f=s>1200?24:s>800?20:s>500?16:s>300?12:8;for(var i=0;i<w.length;i++){d.push(t.$h(w[i]))}var a=f+"px "+t[d[1]];t[d[0]](m,t.width-(f/2.66),t.height-(f/1.66),a,"rgba(0,0,0,1)","right","middle",false,false,false,false,false,true)};this.PI=function(){var c=this.$(this.target);var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.height=parseInt((c.height/2)-100.5)+"px";l.style.display="block"}};this.Cy=function(){var d=this.$("CanvasXpress-ParentNode-"+this.target);if(d){d.style.width=this.width+"px";d.style.height=this.height+"px"}};this.Gf=function(){if(!this.prompt){var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.display="none"}this.loaded=true;this.Cy();this.$$()}};this.d6=function(){var c=this.$cX("canvas").setAttribute("id",this.DW("-canvasXpress-"));window.document.body.appendChild(c);return c.id};this.DW=function(t,f){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return f?n:i};this.hT=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.ZT(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.ZT=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(e,c)};this.oy=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.m5=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.RO=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.TT=function(el,d){var w=this.m5();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.X0=function(e,n){return e&&e.classList?e.classList.contains(n):false};this.Tg=function(e,n){if(e){e.classList.add(n)}};this.Rs=function(e,n){if(e){e.classList.remove(n)}};this.md=function(e,r,a){if(e){e.classList.remove(r);e.classList.add(a)}};this.bf=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.QN(o[i])+";"}return s};this.Nn=function(e){if(!e){return}try{CanvasXpress}catch(f){e.preventDefault();e.stopPropagation();return false}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.rU=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.q6=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.Ay=function(el,type){if("createEvent" in document){var e=document.createEvent("HTMLEvents");e.initEvent(type,false,true);el.dispatchEvent(e)}else{var e=document.createEventObject();e.eventType=type;el.fireEvent("on"+e.eventType,e)}};this.Y6=function(e){var c={};for(var i in e){c[i]=e[i]}return c};this.cc=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.q6(e),c)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}};this.Jq=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.q6(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.iH(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.uk=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.cQ=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.Jq(o,e,m[i][0],m[i][1])}}};this.qD=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.g4=function(e){var o=e.target||e.srcElement;if(typeof(o)!="object"){o=this.$(o)}if(o instanceof SVGElement&&o.ownerSVGElement){o=o.ownerSVGElement}return o};this.dispatchEvent=function(l,e){l.dispatchEvent(e)};this.cI=function(c,t){if(c){var r=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(r){r(c)}else{if(!t){t=1000/60}window.setTimeout(c,t)}}};this.setTimeout=function(d,c){if(this.isR){setTimeout(d,c)}else{var a=this;var b=function(e){return new Promise(function(g,f){if(e){setTimeout(g,e)}else{setTimeout(g,1000)}})};b(c).then(function(){d.apply(a)})}};this.oQ=function(c,d){this.fo("canvasXpress setInterval ready - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}this.lC=function(dom,clbk,self){var resizeObeserver=new ResizeObserver(function(entries){var t=this;entries.forEach(function(entry){clbk(entry,t,self)})});resizeObeserver.observe(dom)};if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}this.$z=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var a=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&w[q(41)]()}},message:{get:function(){w[q(41)]()}}});var $cl=w[q(31)][q(32)];setTimeout($cl.bind(w[q(31)],"%c",a))};if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(len===0){return false}var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==="number"&&typeof y==="number"&&isNaN(x)&&isNaN(y))}while(k<len){if(sameValueZero(o[k],searchElement)){return true}k++}return false}})}this.zL=function(t,l){var d=this.$cX("div",{className:"CanvasXpressSelectDropdown"});var h=this.$cX("h2",{className:"CanvasXpressSelectDropdown",innerHTML:t});var s=this.$cX("select",{id:this.target+":"+t,className:"CanvasXpressSelectDropdown"},{height:"30px",padding:"0 10px"});var o=this.$cX("option",{value:"All",innerHTML:"All"});s.appendChild(o);for(var i=0;i<l.length;i++){var o=this.$cX("option",{value:l[i],innerHTML:l[i]});s.appendChild(o)}d.appendChild(h);d.appendChild(s);return d};this.Pn=function(t,l,s){var d=this.$cX("div",{id:this.target+":"+t,className:"CanvasXpressRadioGroup"});var h=this.$cX("h2",{className:"CanvasXpressRadioGroup",innerHTML:t});var f=this.$cX("form",{className:"CanvasXpressRadioGroup"});for(var i=0;i<l.length;i++){var c=this.$cX("label",{className:"CanvasXpressRadioGroup",innerHTML:l[i]},{marginRight:"18px"});var e=this.$cX("input",{type:"radio",name:t,value:l[i],checked:s&&l[i]==s?true:false});c.appendChild(e);f.appendChild(c)}d.appendChild(h);d.appendChild(f);return d};this.mG=function(a,g,c,h,p){var Q="CanvasXpressToggle";var b=this.$cX("div",{className:Q});var d=this.$cX("label",{className:Q});var f=p?this.$cX("input",{className:Q,params:a,type:"checkbox"}):this.$cX("input",{id:a||this.DW("-cX-Toggle-"),className:Q,type:"checkbox"});if(g){f.checked=true}var e=this.$cX("div",{className:Q+"Switch"});var j=this.$cX("span",{className:Q,innerHTML:c||""});var i=this.$cX("span",{className:Q,innerHTML:h||""});d.appendChild(j);d.appendChild(f);d.appendChild(e);d.appendChild(i);b.appendChild(d);return b};this.Jg=function(J,p,u,A,r){if(u!=null&&A!=null){u=parseFloat(u);A=parseFloat(A);if(u>A){var G=A;A=u;u=G}}var o=this.O3(u,A,4);u=o[0];A=o[o.length-1];var y=A-u;var a=(((y*1000000)-(parseInt(y)*1000000))/1000000).toString().replace(/\./,"").length-1;var e=Math.pow(1/10,(a+1));var C=u>0?Math.log10(u):u==0?0:null;var E=A>0?Math.log10(A):A==0?0:null;var c=[];var Q="CanvasXpressRangeSlider";if(C!=null&&E!=null){var I=this.O3(C,E,4);for(var B=0;B<I.length;B++){c.push(this.ct((Math.pow(10,I[B])),a))}c=this.MC(c)}var b=this.$cX("div",{className:Q+"Container"},{width:r+"px"});var m=this.$cX("div",{className:Q+"ContainerTop"});var g=this.$cX("div",{className:Q+"ContainerTop"},{width:"50%"});var z=this.$cX("span",{className:Q+"ContainerTop",innerHTML:J});var x=this.mG(p+"LinLog",true,"Log","Lin");var F=this.$cX("div",{className:Q+"ContainerBottom"});var t=this.$cX("input",{id:(p+"Min")||this.DW("-cX-RangeSliderMin-"),className:Q,type:"range",min:u,max:A,value:u,step:e});var w=this.$cX("input",{id:(p+"Max")||this.DW("-cX-RangeSliderMax-"),className:Q,type:"range",min:u,max:A,value:A,step:e});var f=this.$cX("input",{id:(p+"InputMin")||this.DW("-cX-RangeSliderInputMin-"),className:Q+"Min",type:"number",min:u,max:A,value:u,step:e});var h=this.$cX("input",{id:(p+"InputMax")||this.DW("-cX-RangeSliderInputMax-"),className:Q+"Max",type:"number",min:u,max:A,value:A,step:e});var l=this.$cX("div",{className:Q+"Input"});var s=this.$cX("div",{className:Q});var q=this.$cX("div",{className:Q+"Track"});var n=this.$cX("div",{className:Q+"Range"});var k=this.$cX("div",{className:Q+"ThumbLeft"});var d=this.$cX("div",{className:Q+"ThumbRight"});var H=this.$cX("div",{className:Q+"Ticks"});var D=this.$cX("div",{className:Q+"Ticks"},{display:"none"});for(var B=0;B<o.length;B++){H.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:o[B]}));if(B<o.length-1){for(var v=0;v<4;v++){H.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}for(var B=0;B<c.length;B++){D.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:c[B]}));if(B<c.length-1){for(var v=0;v<4;v++){D.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}if(C==null||E==null){x.style.display="none"}g.appendChild(z);m.appendChild(g);x.firstChild.firstChild.nextSibling.tickLinear=H;x.firstChild.firstChild.nextSibling.tickLog=D;x.firstChild.firstChild.nextSibling.minRange=t;x.firstChild.firstChild.nextSibling.maxRange=w;m.appendChild(x);f.minRange=t;h.maxRange=w;l.appendChild(f);l.appendChild(h);t.decs=a;t.minInput=f;t.maxRange=w;t.minThumb=k;t.range=n;t.linLog=x.firstChild.firstChild.nextSibling;w.decs=a;w.maxInput=h;w.minRange=t;w.maxThumb=d;w.range=n;w.linLog=x.firstChild.firstChild.nextSibling;s.appendChild(q);s.appendChild(n);s.appendChild(k);s.appendChild(d);F.appendChild(l);F.appendChild(t);F.appendChild(w);F.appendChild(s);F.appendChild(H);F.appendChild(D);b.appendChild(m);b.appendChild(F);return b};this.YX=function(){try{return window.self!==window.top}catch(e){return true}};this.NW=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var $v=function(){var c=w.navigator.userAgent;var b;var a=c.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(a[1])){b=/\brv[ :]+(\d+)/g.exec(c)||[];return"IE "+(b[1]||"")}if(a[1]==="Chrome"){b=c.match(/\b(OPR|Edge)\/(\d+)/);if(b!=null){return b.slice(1).join(" ").replace("OPR","Opera")}}a=a[2]?[a[1],a[2]]:[w.navigator.appName,w.navigator.appVersion,"-?"];if((b=c.match(/version\/(\d+)/i))!=null){a.splice(1,1,b[1])}return a.join(" ")};var $o=function(){var e=w.navigator.userAgent;var a=w.navigator.platform;var f=["Macintosh","MacIntel","MacPPC","Mac68K"];var b=["Win32","Win64","Windows","WinCE"];var c=["iPhone","iPad","iPod"];var d=null;if(f.indexOf(a)!==-1){d="Mac OS"}else{if(c.indexOf(a)!==-1){d="iOS"}else{if(b.indexOf(a)!==-1){d="Windows"}else{if(/Android/.test(e)){d="Android"}else{if(!d&&/Linux/.test(a)){d="Linux"}}}}}return d};var s=$v().split(" ");var o=$o();w[q(8)][q(31)]=w[q(8)][q(31)]||w[q(31)];w[q(8)][q(6)]={browser:s[0],browserVersion:s[1],os:o,alt:(o=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(o=="Mac OS"?"&#8963;":"Ctrl"),shift:(o=="Mac OS"?"&#8679;":"Shift"),isNode:typeof exports==="object"&&typeof module!=="undefined",isReact:typeof React!="undefined",isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(s[0].match(/safari/i)?true:this.YX())}}};CanvasXpress.prototype.initSVG=function(){function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,desc:"",enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.desc=m.desc||l.desc;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__root.setAttribute("desc",this.desc);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){if(!l){return}var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.VO=k};CanvasXpress.prototype.initInterface=function(){this.DU=function(c){var b=this;b.Hp();b.PI();var a=new XMLHttpRequest();a.open("GET",c,true);a.onreadystatechange=function(){if(a.readyState==4){if(a.status==200){var e=b.parseJSON(a.responseText);if(e){window.cXMap=e;b.updateData({data:false,config:{graphType:"Map",topoJSON:e,mapId:"cXMap"}});b.Gf()}else{b.Gf();alert("Oooops! Not a valid CanvasXpress json map file")}}else{b.Gf();alert("Oooops! Not a valid CanvasXpress json map file")}}};a.send()};this.Db=function(b){return function(e){b.Hp();var k=e.target.files[0];var i=k.type;var l=k.name.split(".");var a=new FileReader();var j=l.pop();if(j=="json"){a.onload=function(){try{var c=b.parseJSON(a.result);b.Wk();b.layoutValid=false;for(var p in c.config){b[p]=c.config[p]}if(c.afterRender){for(var f=0;f<c.afterRender.length;f++){var g=c.afterRender[f];var d=g[0];var h=g[1]||[];b[d].apply(b,h)}}else{b.Oj({func:"loadParamsFile",par:(r)})}}catch(r){alert("Oooops! Not a valid CanvasXpress json parameter file")}};a.readAsText(k)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.z2=function(d){var g=[];var f=[];var h=[];var c=[];for(var b=0;b<d.links.length;b++){var a=d.links[b];if(a.source&&a.target&&a.value){h.push(a.source);c.push(a.target);f.push(a.value);g.push("Smp"+(b+1))}}var e={y:{vars:["Weight"],smps:g,data:[f]},x:{Source:h,Target:c}};return{renderTo:"newSankey",data:e,config:{graphType:"Sankey",sankeySource:"Source",sankeyTarget:"Target"}}};this.HU=function(a){var b=this;var c=function(k){var w=0;var g=[];var q=[];var e={};var C=function(f,j,l,i){return Array.prototype.concat.apply(f.map(function(m){if(!e.hasOwnProperty(m.name)){e[m.name]=0}e[m.name]++;if(e[m.name]>1){m.name+=e[m.name]}var p=b.Ev(m);p.level=l||1;p.parent=i||null;return p}),f.map(function(m){w=Math.max(w,(l||1)+1);if(!m.children){g.push(m.name);q.push(m.value||1)}return C(j(m)||[],j,(l||1)+1,m.name)}))};var d=function d(f){return f.children||null};var h=C(d(k),d).map(function(f){f.n=f.children?f.children.length:0;return delete f.children&&f});var B={y:{vars:["Dummy"],smps:g,data:[q]},x:{}};for(var x=0;x<B.y.smps.length;x++){for(var v=0;v<h.length;v++){if(!h[v].n&&B.y.smps[x]==h[v].name){h[v].smp=x;break}}}var n=[];var z=a.name;B.x[z]=[];n.push(z);for(var x=2;x<w-1;x++){B.x[z+x]=[];n.push(z+x)}var A={};for(var x=0;x<h.length;x++){A[h[x].name]=x}for(var x=0;x<n.length;x++){for(var v=0;v<B.y.smps.length;v++){B.x[n[x]][v]=null}}for(var x=0;x<h.length;x++){if(h[x].parent){var r=h[x].parent;var t=A[r];var o=h[x].smp;var u=h[x].level-1;var y=h[t].parent;B.x[z+(u>1?u:"")][o]=h[t].name;while(y){t=A[y];u=h[t].level;B.x[z+(u>1?u:"")][o]=h[t].name;y=h[t].parent}}}return{renderTo:"newTree",data:B,config:{graphType:"Tree",hierarchy:n}}};return c(a)};this.Ss=function(b){return function(q,z,a,r,B){b.Hp();b.PI();var t=function(c){if(c.config&&c.config.backgroundImage&&!Array.isArray(c.config.backgroundImage)&&c.config.backgroundImage.match(/^javascript:\/\//)&&c.config.backgroundImageSrc){var d=new Image();d.id=c.config.backgroundImage.split("//")[1];d.style.display="none";d.src="data:image/png;base64,"+atob(c.config.backgroundImageSrc);document.body.appendChild(d);CanvasXpress.cacheImages[b.zM(d.src)]=d}else{if(c.config&&c.config.backgroundImage&&Array.isArray(c.config.backgroundImage)){c.config.backgroundImageMD5=b.aI(c.config.backgroundImage);var d=new Image();d.onload=function(){CanvasXpress.cacheImages[c.config.backgroundImageMD5]=this};d.crossOrigin="anonymous";d.src=b.eG(c.config.backgroundImage)}}};var v=r?r:q.target?q.target.files[0]:q.files[0];var f=v.type;var y=v.name.split(".");var s=new FileReader();var e=window;if(f=="image/png"){var u=function(g,h){var c="";for(var d=0;d<4;d++){c+=String.fromCharCode(g.getUint8(h+d))}return c=="tEXt"};var x=function(d,h,i){var c="";for(var g=0;g<i;g++){c+=String.fromCharCode(d.getUint8(h+g))}return c.match(/CanvasXpress/)};s.onload=function(){var m=new DataView(this.result);var g=m.getUint32(8);var h=m.getUint32(8+4+4+g+4);if(u(m,8+4+4+g+4+4)&&x(m,8+4+4+g+4+4+4,h)){var n=m.getUint32(8+4+4+g+4+4+4+h+4);var l=8+4+4+g+4+4+4+h+4+4+4;var c="";for(var d=0;d<n;d++){c+=String.fromCharCode(m.getUint8(l+d))}c=c.replace("ReproducibleResearch\0","");var k;try{k=b.parseJSON(decodeURIComponent(c))}catch(j){k=b.parseJSON(c)}t(k);var i=b.$w;if(k.config[i(0)]){b.Gf();b.fy(k)}else{if(k.hasOwnProperty("config")){delete (k.config.remoteService)}b.Ap(k,a);b.Gf()}}else{b.Gf();b.backgroundImage="data:image/png;base64, "+b.qo(this.result);b.Lt({func:"changeAttribute",par:["backgroundImage",b.backgroundImage]});b.backgroundType="image";b.Lt({func:"changeAttribute",par:["backgroundType","image"]});b.skipStack=true;b.Oj();b.skipStack=false;alert("Oooops! Not a valid CanvasXpress Image\nUsing image as background!")}};s.readAsArrayBuffer(v)}else{if(f=="application/x-bzip2"){s.onload=function(){var c=b.Fp(this.result);if(y[1].match(/ml$/)){try{CanvasXpress.loadRemoteData(y[0],c,false,false,b.updateRemoteData)}catch(d){b.Gf();alert("Oooops! Not a valid bz2 file for CanvasXpress")}}else{b.Gf();alert("Oooops! Not a valid bz2 file for CanvasXpress")}};s.readAsBinaryString(v)}else{if(y[y.length-1]=="parquet"){s.onload=function(){try{var d=b.KQ(s.result);d.renderTo=y[0];b.Ap(d,a);b.Gf()}catch(c){b.Gf();alert("Oooops! Not a valid parquet file for CanvasXpress")}};s.readAsArrayBuffer(v)}else{var A=y.pop();if(A=="json"){s.onload=function(){try{var n=b.parseJSON(s.result);t(n);var h=b.$w;if(n.config[h(0)]){b.Gf();b.fy(n)}else{if(n.data||(n&&n.config&&n.config.graphType&&n.config.graphType=="Map")){if(n.config.topoJSON){if(n.config.mapId){delete window[n.config.mapId];delete b.meta.map;delete b.topoJSON}}else{if(b.graphType=="Map"&&b.TC(n)){b.Oj();b.Gf();return}}b.Ap(n,a);b.Gf()}else{if(n.config){b.Wk();b.layoutValid=false;for(var d in n.config){b[d]=n.config[d]}if(n.afterRender){for(var m=0;m<n.afterRender.length;m++){var c=n.afterRender[m];var i=c[0];var g=c[1]||[];b[i].apply(b,g)}}else{b.Oj({func:"loadFile",par:[l,z,a,r]})}}else{if(n.children&&n.children.length){n=b.HU(n);b.Ap(n,a);b.Gf()}else{if(n.nodes&&n.links){n=b.z2(n);b.Ap(n,a);b.Gf()}else{if(n.type&&n.type.match(/FeatureCollection|Topology/)){var k={data:false,config:{graphType:"Map",topoJSON:n,mapId:"cXMap"}};window.cXMap=n;b.updateData(k);b.Gf()}else{var j=n.error.error}}}}}}}catch(l){b.Gf();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(A=="geojson"){s.onload=function(){try{var i=b.parseJSON(s.result);b.FT(b.Ev(b.data.y.vars),true);var c=b.Ev(b.data);for(var d=0;d<i.features.length;d++){c.y.vars[d]="Id"+(d+1);c.y.data[d]=[];c.y.data[d][0]=0}if(i.type&&i.type.match(/FeatureCollection|Topology/)){var h={data:c,config:{graphType:"Map",topoJSON:i,mapId:"cXMap"}};window.cXMap=i;b.updateData(h);b.Gf()}}catch(g){b.Gf();alert("Oooops! Not a valid geojson file")}}}else{if(A=="svg"){s.onload=function(){try{var d=b.SVGtoCX(s.result);var g=b.$w;if(d.config[g(0)]){b.Gf();b.fy(d)}else{b.Ap(d,a);b.Gf()}}catch(c){b.Gf();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(A=="txt"||A=="csv"||A=="tsv"||A=="tab"||A=="lsk"||A=="sql"){s.onload=function(){try{var c=s.result;var g;if(b.graphType=="Network"){g=b.arrayToCXNetwork(b.parseDelimited(c),false,false,false,b.data);if(g&&!b.Hl(g)){var h="";if(g.fail>0){h=g.fail+" records couldn't be mapped to network data"}alert(g.rows+" "+g.type+" records added to network data\n"+h);if(g.type=="node"){b.fF(g.data)}else{b.S6(g.data)}b.Gf();return}else{g=b.arrayToCX(g)}}else{g=b.H5(b.parseDelimited(c),b.graphType=="Map");if(g&&!b.Hl(g)){if(g.addt){alert(g.recs+" records added as an additional data set\n")}else{alert(g.recs+" records added to meta data\n")}b.ON(g.data,g.addt);b.Gf();return}else{if(A=="lsk"||A=="sql"){g=b.arrayToCX(CanvasXpress.qO(g))}else{g=b.arrayToCX(g)}}}g.renderTo=y[0].replace(/\s/g,"").replace(/\(/g,"").replace(/\)/g,"");if(B){g.config.view="table"}b.Ap(g,a);b.Gf()}catch(d){b.Gf();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(A=="esv"){s.onload=function(){try{var c=s.result;var g=b.arrayToCXNetwork(b.parseDelimited(c),false,false,false,b.data,"edge");g.renderTo=y[0];b.Ap(g,a);b.Gf()}catch(d){b.Gf();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(A=="gml"){s.onload=function(){try{var d=b.Mp(s.result);d.renderTo=y[0];b.Ap(d,a);b.Gf()}catch(c){b.Gf();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(A.match(/ml$/)||A=="gexf"){s.onload=function(){try{CanvasXpress.loadRemoteData(y[0],s.result,false,false,b.updateRemoteData)}catch(c){b.Gf();alert("Oooops! Not a valid "+A+" file for CanvasXpress")}}}}}}}}}s.readAsText(v)}}}}}(this);this.pd=function(a){return function(i,h){if(a.isEditable||h){var b=a.UF();var k="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";k+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";k+="<canvas id='"+a.target+"' width='"+a.width+"' height='"+a.height+"'></canvas>";var c=a.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(c);var g=a.$cX("textarea",{name:"title",value:(a.title||"CanvasXpress")});var j=a.$cX("textarea",{name:"html",value:k});var l=a.$cX("textarea",{name:"js",value:b});var d=a.$cX("button",{type:"submit"});c.appendChild(g);c.appendChild(j);c.appendChild(l);c.appendChild(d);d.click();document.body.appendChild(c)}}}(this);this.mn=function(a){return function(j,i){if(a.isEditable||i){a.Hp();var b=a.UF().replace(/\'/g,"");var l='<link rel="stylesheet" href="https://www.canvasxpress.org/dist/canvasXpress.css" type="text/css"/>\n';l+='<script type="text/javascript" src="https://www.canvasxpress.org/dist/canvasXpress.min.js"><\/script>\n\n';l+='<canvas id="'+a.target+'" width="'+a.width+'" height="'+a.height+'"></canvas>';var d="https://www.canvasxpress.org/dist/canvasXpress.css;https://www.canvasxpress.org/dist/canvasXpress.min.js";var h='{"title": "'+(a.title||"CanvasXpress")+'", "html": "'+l+'" js: "'+b+'" js_external: "'+d+'"}';h='{"title": "CanvasXpress", "html": "'+l.replace(/"/g,"'")+'", "js": "'+b.replace(/"/g,"'")+'", "js_external": "'+d.replace(/"/g,"'")+'"}';var c=a.$cX("form",{id:"submitToCodePen",method:"post",action:"https://codepen.io/pen/define",target:"_blank"},{display:"none"});document.body.appendChild(c);var k=a.$cX("input",{type:"hidden",name:"data",value:h});var g=a.$cX("button",{type:"submit"});c.appendChild(k);c.appendChild(g);g.click();document.body.appendChild(c)}}}(this);this.EA=function(){this.qJ();var e=CanvasXpress.stack[this.target];var b=e.afterRender;var c=[];for(var d=0;d<b.length;d++){if(b[d][0].match(/^sort/)){c.push(this.Ev(b[d]))}}return this.oS({renderTo:e.renderTo,data:this.data,config:this.Ei(),afterRender:c,factory:e.factory,system:e.system,version:e.version})};this.save=function(a){return function(j,i,d,g){var c=a.$w;var l=a.$pX();a.Hp();var k=i?i+".json":a.saveFilename?a.saveFilename+".json":"cX-"+a.target+".json";k=k.replace(/.json.json$/,".json");CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;if(l){CanvasXpress.stack[a.target].data=a[c(9)](a.QB(CanvasXpress.stack[a.target].data),l);CanvasXpress.stack[a.target].config[c(0)]=true}var h;if(d){h=a.oS({config:CanvasXpress.stack[a.target].config,afterRender:CanvasXpress.stack[a.target].afterRender||[]})}else{if(g||(j&&(j.ctrlKey||j.altKey))){h=a.EA()}else{h=a.oS(a.rT(a.xK(CanvasXpress.stack[a.target])))}}var b=new Blob([h],{type:"text/plain"});a.Rh(b,k)}}(this);this.saveSVG=function(a){return function(k,i){var g=a.$pX();var c=a.$w;a.Hp();CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;a.isSVG=true;var l=a.showTransition;var d=a.rT(a.xK(CanvasXpress.stack[a.target]));if(g){d.data=a[c(9)](a.QB(d.data),g);d.config[c(0)]=true}d=a.isReproducibleResearch?a.QB(d):"";a.showTransition=false;a.meta.canvas.SVG=new a.VO({width:a.width,height:a.height,desc:d});a.meta.canvas.SVG.render=function(){var n=this.o.length;for(var r=0;r<n;r++){var u=this.o[r];var p=u.funcs;for(var q in u){if(q!=="funcs"){this[q]=u[q]}}if(p){var t=p.length;for(var q=0;q<t;q++){var s=p[q];var e=s[0];if(this[e]){this[e].apply(this,s[1])}}}}};a.meta.canvas.SVG.resetRender=function(){this.o=[]};a.meta.canvas.SVG.resetContext=function(){this.direction="ltr";this.fillStyle="#000000";this.filter="none";this.font="10px sans-serif";this.fontKerning="auto";this.fontStretch="normal";this.fontVariantCaps="normal";this.globalAlpha=1;this.globalCompositeOperation="source-over";this.imageSmoothingEnabled=true;this.imageSmoothingQuality="low";this.letterSpacing="0px";this.lineCap="butt";this.lineDashOffset=0;this.lineJoin="miter";this.lineWidth=1;this.miterLimit=10;this.shadowBlur=0;this.shadowColor="rgba(0, 0, 0, 0)";this.shadowOffsetX=0;this.shadowOffsetY=0;this.strokeStyle="#000000";this.textAlign="start";this.textBaseline="alphabetic";this.textRendering="auto";this.wordSpacing="0px"};a.GY(true);var h=a.meta.canvas.SVG.getSerializedSvg();if(a.isReproducibleResearch){a.SJ(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var m=i?i+".svg":a.saveFilename?a.saveFilename+".svg":"cX-"+a.target+".svg";m=m.replace(/.svg.svg$/,".svg");var b=new Blob([h],{type:"image/svg+xml"});a.Rh(b,m);a.showTransition=l;delete (a.meta.canvas.SVG);a.isSVG=false}}(this);this.qo=function(c){var e="";var b=new Uint8Array(c);var a=b.byteLength;for(var d=0;d<a;d++){e+=String.fromCharCode(b[d])}return window.btoa(e)};this.OX=function(c){var d=window.atob(c);var a=d.length;var b=new Uint8Array(a);for(var e=0;e<a;e++){b[e]=d.charCodeAt(e)}return b.buffer};this.NN=function(){if(this.useLeaflet){var b=this.$("leaflet-"+this.target);if(b){var a=this.meta.canvas.ctx.canvas;var h=this.$cX("canvas",{width:this.width,height:this.height});var c=h.getContext("2d");var e=b.getElementsByTagName("img");for(var d=0;d<e.length;d++){var f=e[d];var j=f._leaflet_pos.x;var g=f._leaflet_pos.y;c.Cl(f,j,g,256,256)}c.Cl(a,0,0,this.width,this.height);return h}}};this.print=function(b){return function(c,e,a){try{CanvasXpress}catch(N){c.preventDefault();c.stopPropagation();return false}var L=window;var I=b.width;var H=b.height;var y=b.printMagnification;var G=b.autoScaleFont;var E=b.showTransition;var B=b.skipStack;var A=["outlineWidth","lineThickness","xAxisGridMajorWidth","yAxisGridMajorWidth","zAxisGridMajorWidth","xAxisGridMinorWidth","yAxisGridMinorWidth","zAxisGridMinorWidth","xAxisLineLeftWidth","xAxisLineRightWidth","yAxisLineTopWidth","yAxisLineBottomWidth","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(b.target)){b=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var D=function(d){if(d&&y!=1){for(var f=0;f<A.length;f++){b[A[f]]/=y}b.autoScaleFont=G;b.showTransition=E;b.setDimensions(I,H,true);b.skipStack=B}else{if(y!=1){b.skipStack=true;b.showTransition=false;for(var f=0;f<A.length;f++){b[A[f]]*=y}b.autoScaleFont=true;b.setDimensions(I*y,H*y,true)}}};var O=function(){var i;var h=[];for(var d=0;d<256;d++){i=d;for(var g=0;g<8;g++){i=((i&1)?(3988292384^(i>>>1)):(i>>>1))}h[d]=i}return h};var M=function(i){var h=L.crcTable||(L.crcTable=O());var d=0^(-1);for(var g=0;g<i.length;g++){d=(d>>>8)^h[(d^i.charCodeAt(g))&255]}return(d^(-1))>>>0};var J=function(g,h){var d=new Uint8Array(g.byteLength+h.byteLength);d.set(new Uint8Array(g),0);d.set(new Uint8Array(h),g.byteLength);return d.buffer};var F=function(g){var l="tEXt";var h=g.length;var d=M(l+g);var k=new ArrayBuffer(12+h);var i=new DataView(k);i.setUint32(0,h);for(var j=0;j<l.length;j++){i.setUint8(4+j,l.charCodeAt(j))}for(var j=0;j<g.length;j++){i.setUint8(8+j,g.charCodeAt(j))}i.setUint32(4+4+h,d);return k};var K=function(){var f=false;var g=b.$pX();var d=b.$w;if(b.isReproducibleResearch){if(b.printMagnification!=1){delete (CanvasXpress.stack[b.target].config.showTransition)}if(c&&(c.ctrlKey||c.altKey)){f=b.EA()}else{f=b.rT(b.xK(CanvasXpress.stack[b.target]))}}else{f=b.parseJSON(c.ctrlKey||c.altKey?b.EA():b.QB(CanvasXpress.stack[b.target]));f.afterRender=[f.afterRender[0]]}if(g){f.config[d(0)]=true;f.data=b[d(9)](b.QB(f.data),g)}return encodeURIComponent(b.QB(f))};var P=function(h,j,i,g){var d=J(h,j);d=J(d,i);d=J(d,g);return d};var z=function(h){var d=new FileReader();var g="";if(b.isReproducibleResearch){g+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{g+="<h2>Right click to save image</h2>"}d.onload=function(f){g+="<img width="+b.width+" height="+b.height+" src= '"+f.target.result+"'/>";b.RT(c,g,b.g4(c),{maxWidth:b.width+"px",whiteSpace:"normal"},40,40)};d.readAsDataURL(h)};D();b.Hp();CanvasXpress.stack[b.target].factory=CanvasXpress.factory;CanvasXpress.stack[b.target].system=CanvasXpress.system;if(!CanvasXpress.factory.valid){b.$$$("CanvasXpress")}var C=b.useLeaflet?b.NN():b.meta.canvas.ctx.canvas;C.toBlob(function(g){var h=new FileReader();var d=e?e+".png":b.saveFilename?b.saveFilename+".png":"cX-"+b.target+".png";d=d.replace(/.png.png$/,".png");h.onloadend=function(){var m=new DataView(this.result);var k=m.getUint32(8);var j=8+4+4+k+4;var i=this.result.slice(0,j);var f=this.result.slice(j);var n=F("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var p=F("ReproducibleResearch\0"+K());var o=P(i,n,p,f);var l=new Blob([o],{type:"image/png"});b.meta.base64=b.qo(o);if(a){a(l,d)}else{if(b.printType=="download"){if(b.isReproducibleResearch){b.SJ(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}b.Rh(l,d)}else{z(l)}}D(true)};h.readAsArrayBuffer(g)},"image/png");if(b.customizing){}else{if(b.maximized){b.hQ(c)}}}}(this);this.fK=function(a){return function(f){var b=a.meta.canvas.ctx;a.meta.canvas.ctx=new this.VO({width:a.width,height:a.height});a.Oj({func:"exportToSVG",par:[f]});var c=a.H1(a.meta.canvas.ctx.getSerializedSvg());var d=window.open("",a.target+"-SVG");d.document.write(c);a.meta.canvas.ctx=b;a.Oj({func:"exportToSVG",par:[f]});return false}}(this);this.Oq=function(a){return this.EL(a)};this.aL=function(e,b){var c="<table>";for(var a=0;a<e.length;a++){c+="<tr><td>";c+=e[a].join("</td><td>");c+="</td></tr>"}c+="</table>";return b?c:window.open().document.write(c)};this.EL=function(e){var c="";for(var a=0;a<e.length;a++){c+=e[a].join("\t")+"\n"}var b=this.$(this.target+"-cX-linkTab");if(!b){b=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(b)}b.download=this.target+".tsv";b.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(c);b.click()};this.xG=function(e){var c="";if(e[0].length){c+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';c+='<table class="CanvasXpressDataTable" style="position:inherit;">';c+="<tbody>";c+="<tr>";for(var b=0;b<e[0][0].length;b++){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][0][b];c+="</div>";c+="</th>"}c+="</tr>";for(var b=1;b<e[0].length;b++){c+="<tr>";for(var a=0;a<e[0][b].length;a++){if(a==0){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</th>"}else{if(e[2]&&e[2][b]&&e[2][b][a]){c+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+e[2][b][a]+'">'}else{c+='<td class="CanvasXpressTableCell" style="height:18px">'}c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</td>"}}c+="</tr>"}c+="</tbody>";c+="</table>";c+="</div>"}return c};this.Mr=function(){var h=new Set(["xAxis","yAxis","zAxis","rAxis","xAxis2","graphType","dataTableTransposed","layoutAxis","showHistogram","showHistogramDensity","isContour","showTransition","showAnimation","scatterType","circularType","barType","ringOrder","showViolinBoxplot"]);var b=this.Ei();var f=b.graphType;if(this.showHistogram){f=this.ridgeBy?"Ridgeline":this.showHistogramDensity?"Density":"Histogram"}else{if(this.isContour){f="Contour"}else{if(b.scatterType){f=this.Cv(b.scatterType);if(f=="Bin2d"){f="Binplot"}else{if(f=="Km"){f="Kaplan-Meier"}else{if(f=="Qq"){f="QQ"}}}}else{if(b.circularType){f=this.Cv(b.circularType)}else{if(b.barType){f=this.Cv(b.barType)}else{if(this.scatterPlotMatrix){f="SPLOM"}else{if(this.showViolinBoxplot){f="Violin"}}}}}}}var e=CanvasXpress.doc.P.graphType.L.replace("{_value_}",f)+(this.scatterPlotMatrix?". ":" of ");if(b.rAxis){e+=b.rAxis.join(", ")+" in the R axis";if(b.yAxis){e+=" and "+b.yAxis.join(", ")+" in the Y axis"}e+=". "}else{if(b.xAxis&&b.xAxis2){e+=b.xAxis.join(", ")+" in the X axis and "+b.xAxis2.join(", ")+" in the secondary X axis. "}else{if(b.xAxis&&b.yAxis&&b.zAxis){e+=b.xAxis.join(", ")+" in the X axis, "+b.yAxis.join(", ")+" in the Y axis and "+b.zAxis.join(", ")+" in the Z axis. "}else{if(b.xAxis&&b.yAxis){if(this.showHistogram||b.xAxis[0]==b.yAxis[0]){e+=b.xAxis.join(", ")+". "}else{e+=b.xAxis.join(", ")+" in the X axis and "+b.yAxis.join(", ")+" in the Y axis. "}}else{if(b.xAxis){e+=b.xAxis.join(", ")+". "}}}}}for(var a in b){if(!a.match(/^llm/)&&!h.has(a)){var c=CanvasXpress.doc.P[a].L;var j=CanvasXpress.doc.P[a].T;if(c.match(/^\{/)&&j=="boolean"){var k=c.match(/^\{(.+?)\|(.+?)\}/);if(b[a]){e+=c.replace(/\{.+?\}/,k[1])+". "}else{e+=c.replace(/\{.+?\}/,k[2])+". "}}else{if(a=="sortData"){var k=b[a][0];if(k.length&&k.length>2){e+=k[1]==="var"?"Sort variables by "+k[2]+". ":"Sort samples by "+k[2]+". "}}else{if(a.match(/^filter/)){var g=this.meta.config.user.filterData;if(g){for(var d=0;d<g.length;d++){e+="Filter data that is "+g[d][2]+" to "+g[d][3].join(", ")+". "}}}else{if(a.match(/ScaleFontFactor/)){var k=c.match(/^\{(.+?)\|(.+?)\}/);if(b[a]>1){e+=c.replace(/\{.+?\}/,k[1]).replace("{_value_}",b[a])+". "}else{e+=c.replace(/\{.+?\}/,k[2]).replace("{_value_}",b[a])+". "}}else{if(j=="array"){e+=c.replace("{_value_}",b[a].join(", "))+". "}else{if(j=="object"){}else{e+=c.replace("{_value_}",b[a])+". "}}}}}}}}return this.eh(e,60)};this.iB=function(g){var h=[];var b=g.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var c=["header","quote","row.names","fill","check.names","stringsAsFactors"];var f=false;for(var e=0;e<b.length;e++){var a=b[e];if(a.match(/library\(canvasXpress\)/)){h.push(a.replace("library(canvasXpress)",'library(<span class="cX-code-value">canvasXpress</span>)'))}else{if(a.match(/canvasXpress\(/)){h.push(a.replace("canvasXpress(",'<span class="cX-code-value">canvasXpress</span>('));f=true}else{if(a.match(/\"http.+\"/)){a=a.replace(/(\"http.+?\")/,'<span class="cX-code-string">$1</span>');for(var d=0;d<c.length;d++){a=a.replace(c[d],'<span class="cX-code-key">'+c[d]+"</span>")}a=a.replace('""','<span class="cX-code-string">""</span>,');a=a.replace(/\"\t\"/,'<span class="cX-code-string">"&#92;t"</span>');a=a.replace("=1,",'=<span class="cX-code-number">1</span>,');a=a.replace(/FALSE/g,'<span class="cX-code-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="cX-code-boolean">TRUE</span>');h.push(a)}else{if(f){if(a.match(/\".+?\"/)){a=a.replace(/(\".+?\")/g,'<span class="cX-code-string">$1</span>')}else{if(a.match(/[^xis][\d\.]+/)){a=a.replace(/([\d\.]+)/,'<span class="cX-code-number">$1</span>')}}a=a.replace(/\n/,"&#92;n");a=a.replace(/(\w+)?=/,'<span class="cX-code-key">$1=</span>');a=a.replace(/FALSE/g,'<span class="cX-code-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="cX-code-boolean">TRUE</span>')}h.push(a)}}}}return'<pre class="cX-code-content">\n<code>'+h.join("</code>\n<code>")+"</code>\n</pre>"};this.Zy=function(e,d,f,b){var a=this.QB(e,d?d:null,2);if(a.length>10000){f=false}if(f){a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}a=a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(g){var c="number";if(/^"/.test(g)){if(/:$/.test(g)){g=g.replace(":"," =");c="key"}else{c="string"}}else{if(/true|false/.test(g)){g=g.replace("false","FALSE").replace("true","TRUE");c="boolean"}else{if(/null/.test(g)){g=g.replace("null","NULL");c="null"}}}return f?('<span class="cX-code-'+c+'">'+g+"</span>"):g});if(b){return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")}else{return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")}};this.mO=function(){var g=[];var m=[];var n,b,q,a,o,h;var k="";var f=CanvasXpress.stack[this.target].data;var p="<span class=cX-code-value>canvasXpress</span>(\n";if(this.meta.config.remote&&!this.ZR(this.meta.config.remote.data)){if(this.meta.config.remote.data===false){k+="data = FALSE\n"}else{k+='data = "'+this.meta.config.remote.data+'"\n'}p+="  <span class=cX-code-key>data</span> = data,\n"}else{if(this.graphType=="Map"&&!this.ZR(this.meta.config.remote.data)){k+="";p+="  <span class=cX-code-key>data</span> = <span class=cX-code-value>FALSE</span>,\n"}else{if(f.y){g=[];for(var e=0;e<f.y.vars.length;e++){var l=[];for(var d=0;d<f.y.smps.length;d++){l.push(f.y.data[e][d]!=null?f.y.data[e][d]:"NA")}g.push("<span class=cX-code-number>"+l.join("</span>,<span class=cX-code-number>")+"</span>,")}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="vals = c("+g.join("\n")+")\n";q='vars = c(<span class=cX-code-string>"'+f.y.vars.join('"</span>,\n<span class=cX-code-string>"')+'"</span>)\n';a='smps = c(<span class=cX-code-string>"'+f.y.smps.join('"</span>,\n<span class=cX-code-string>"')+'"</span>)\n';o="data = as.data.frame(matrix(vals, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+f.y.vars.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+f.y.smps.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>TRUE</span>, <span class=cX-code-key>dimnames</span> = list(vars, smps)))\n";k+=b+q+a+o;p+="  <span class=cX-code-key>data</span> = data,\n"}if(f.x){g=[];m=[];b="";for(var e in f.x){var c=this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:"fail";if(c=="Numeric"){g.push("<span class=cX-code-number>"+f.x[e].join("</span>,\n<span class=cX-code-number>")+"</span>,")}else{g.push('<span class=cX-code-string>"'+f.x[e].join('"</span>,\n<span class=cX-code-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valx = c("+g.join("\n ")+")\n";if(this.graphType=="Tree"){b=b.replace(/\"\"/g,"NA")}q='varx = c(<span class=cX-code-string>"'+m.join('"</span>,<span class=cX-code-string>"')+'"</span>)\n';o="datx = as.data.frame(matrix(valx, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+m.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+f.y.smps.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>TRUE</span>, <span class=cX-code-key>dimnames</span> = list(varx, smps)))\n";k+=b+q+o;p+="  <span class=cX-code-key>smpAnnot</span> = datx,\n"}if(f.z){g=[];m=[];b="";for(var e in f.z){var c=this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:"fail";if(c=="Numeric"){g.push("<span class=cX-code-number>"+f.z[e].join("</span>,\n<span class=cX-code-number>")+"</span>,")}else{g.push('<span class=cX-code-string>"'+f.z[e].join('"</span>,\n<span class=cX-code-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valz = c("+g.join("\n ")+")\n";a='smpz = c(<span class=cX-code-string>"'+m.join('"</span>,<span class=cX-code-string>"')+'"</span>)\n';o="datz = as.data.frame(matrix(valz, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+f.y.vars.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+m.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>FALSE</span>, <span class=cX-code-key>dimnames</span> = list(vars, smpz)))\n";k+=b+a+o;p+="  <span class=cX-code-key>varAnnot</span> = datz,\n"}if(f.nodes){k+="nodes = list(\n"+this.Zy(f.nodes,function(j,i){if(j!="layout"){return i}},false,true)+")\n";p+='  <span class=cX-code-key>"nodeData"</span> = nodes,\n'}if(f.edges){k+="edges = list(\n"+this.Zy(f.edges,false,false,true)+")\n";p+='  <span class=cX-code-key>"edgeData"</span> = edges,\n'}if(f.groups){k+="groups = list(\n"+this.Zy(f.groups,false,false,true)+")\n";p+='  <span class=cX-code-key>"groupData"</span> = groups,\n'}if(f.constraints){k+="constraints = list(\n"+this.Zy(f.constraints,false,false,true)+")\n";p+='  <span class=cX-code-key>"constraintData"</span> = constraints,\n'}if(f.venn){k+="venn = data.frame(\n"+this.Zy(f.venn.data,false,true)+")\n";p+="  <span class=cX-code-key>vennData</span> = venn,\n";if(f.venn.legend){k+="legn = data.frame(\n"+this.Zy(f.venn.legend,false,true)+")\n";p+="  <span class=cX-code-key>vennLegend</span> = legn,\n"}}if(f.tracks){p+="  <span class=cX-code-key>tracks</span> = genome,\n";k+="genome = list(\n"+this.Zy(f.tracks,false,true)+")\n"}}}n=this.meta.config.remote?this.v8(this.meta.config.remote.config):this.v8(CanvasXpress.stack[this.target].config);if(CanvasXpress.stack[this.target].afterRender&&CanvasXpress.stack[this.target].afterRender.length>1){n.afterRender=this.Ev(CanvasXpress.stack[this.target].afterRender)}p+=this.Zy(n,false,true)+")";h="library(<span class=cX-code-value>canvasXpress</span>)\n"+k+p;return"<code>"+h.replace(/\n/g,"</code>\n<code>")+"</code>"};this.oS=function(d,b,e,a){return e&&d?this.ph(d,b):d?this.QB(d,b,a||2):false};this.ph=function(c,b){if(c){var a=this.QB(c,b?b:null,2);if(a.length>10000){return a}else{a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}a=a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(e){var d="number";if(/^"/.test(e)){if(/:$/.test(e)){d="key"}else{d="string"}}else{if(/true|false/.test(e)){d="boolean"}else{if(/null/.test(e)){d="null"}}}return'<span class="cX-code-'+d+'">'+e+"</span>"});return a}else{return false}};this.jR=function(g,e){var d=function(h){return h.replace(/"/g,"&quot;").replace(/^\s*/g,"").replace(/'\s*\+\s*'/g,"' + '").replace(/'\s*\+\s*Math/g,"' + Math").replace(/\*/g," * ").replace(/\)\//g,") / ").replace(/<(.+?)>/g,"&lt;$1&gt;")};g=g.replace(/{/g,"{\n").replace(/}/g,"\n}");var b=g.split(/\n/);var a=[d(b[0])];var f="  ";if(!e){e=""}for(var c=1;c<b.length;c++){b[c]=d(b[c]);if(b[c].match(/[\w{}]/)){if(b[c].match(/}\s*else\s*\{\s*$/)){f=f.replace("  ","");a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\{\s*$/)){a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\}\s*;*\s*$/)){f=f.replace("  ","");a.push(e+f+b[c])}else{a.push(e+f+b[c])}}}}}return a.join("\n")};this.j4=function(d,a){var c="{\n";if(!a){a="  "}for(var b in d){c+=a+'"'+b+'": '+d[b]+",\n"}a=a.replace("  ","");return c.replace(/,\n$/,"\n")+a+"}"};this.H1=function(n){var f=/(>)\s*(<)(\/*)/g;var t=/ *(.*) +\n/g;var e=/(<.+>)(.+\n)/g;var d=n.replace(f,"$1\n$2$3").replace(t,"$1\n").replace(e,"$1\n$2");var r=0;var b="";var a=d.split("\n");var k=0;var q="other";var v={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var p=0;p<a.length;p++){var h=a[p];var u=Boolean(h.match(/<.+\/>/));var g=Boolean(h.match(/<\/.+>/));var m=Boolean(h.match(/<[^!].*>/));var c=u?"single":g?"closing":m?"opening":"other";var s=q+"->"+c;q=c;var l="";k+=v[s];for(var o=0;o<k;o++){l+="  "}b+=l+h+"\n"}return b};this.yq=function(d,h,b){var a=h?"  ":b?"        ":"    ";var c=this.sC(true).replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var g=this.hI(true).replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var f=this.QZ(true);var e=this.pt(true);var i="";if(h){i+="<span class=cX-code-key>import</span> streamlit <span class=cX-code-key>as</span> st\n\n"}else{if(b){i+="<span class=cX-code-key>from</span> shiny <span class=cX-code-key>import</span> App, ui, render, reactive\n\n"}}i+="<span class=cX-code-key>from</span> canvasxpress.canvas <span class=cX-code-key>import</span> CanvasXpress\n";if(d||h||b){i+="<span class=cX-code-key>from</span> canvasxpress.plot <span class=cX-code-key>import</span> graph\n\n"}else{i+="<span class=cX-code-key>from</span> canvasxpress.plot <span class=cX-code-key>import</span> show_in_browser\n\n"}if(d){i+="graph(\n";i+="  CanvasXpress(\n";i+="    data = "+c+",\n";i+="    config = "+g+",\n";if(f){i+="    events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="    after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="    width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="    height = <span class=cX-code-number>"+this.height+"</span>\n";i+="  )\n";i+=")\n\n"}else{if(h){i+="chord_chart = CanvasXpress(\n";i+="  config = "+g+",\n";if(f){i+="  events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="  after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="  width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="  height = <span class=cX-code-number>"+this.height+"</span>\n";i+=")\n\n";i+="<span class=cX-code-comment># Write the UI to the browser</span>\n";i+="<span class=cX-code-comment># This code will be re-executed with each click of the button</span>\n\n";i+="<span class=cX-code-comment># Name the theme</span>\n";i+='st.title(<span class=cX-code-key>"CanvasXpress in Streamlit!"</span>)\n\n';i+="<span class=cX-code-comment># Some columns to organize the button and chart</span>\n";i+="column1, column2 = st.columns(2)\n\n";i+="<span class=cX-code-comment># A column with our data generator button</span>\n";i+="column1.write(\n";i+="  <span class=cX-code-comment># This has no associated action, so by default</span>\n";i+="  <span class=cX-code-comment># it triggers a redraw of the UI.</span>\n";i+='  st.button(<span class=cX-code-key>"Generate New Data"</span>)\n';i+=")\n\n";i+="<span class=cX-code-comment># Another column with the chart displayed</span>\n";i+="<span class=cX-code-comment># With each redraw generate new random values</span>\n";c=c.replace(/\n  /g,"\n");i+="chord_chart.data = "+c+"\n";i+="column2.write(\n";i+="  <span class=cX-code-comment># This plots the CanvasXpress chart into the UI.</span>\n";i+="  graph(chord_chart)\n";i+=")\n\n";i+="<span class=cX-code-comment># On the command line, execute:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   streamlit run app.py\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># And output similar to the following will be provided:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   Running on http://localhost:8501/ (Press CTRL+C to quit)\n"}else{if(b){i+="app_ui = ui.page_fluid(\n";i+="  ui.row(\n";i+="    <span class=cX-code-comment># Define widgets here - for example:</span>\n";i+="    ui.input_slider(\n";i+='      <span class=cX-code-key>"points_desired"</span>,\n';i+='      <span class=cX-code-key>"Points"</span>,\n';i+="      min = <span class=cX-code-number>"+this.minData+"</span>,\n";i+="      max = <span class=cX-code-number>"+this.maxData+"</span>,\n";i+="      value = <span class=cX-code-number>"+this.minData+"</span>\n";i+="    )\n";i+="  )\n";i+="  ui.row(\n";i+='    ui.output_ui(<span class=cX-code-key>"chart_view"</span>),\n';i+="  )\n";i+=")\n\n";i+="def server(input, output, session):\n";i+="  @render.ui\n";i+="  @reactive.event(input.points_desired)\n";i+="  def chart_view():\n";i+="    return graph(\n";i+="      CanvasXpress(\n";i+="        data = "+c+",\n";i+="        config = "+g+",\n";if(f){i+="        events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="        after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="        width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="        height = <span class=cX-code-number>"+this.height+"</span>\n";i+="    )\n";i+="  )\n\n";i+="app = App(app_ui, server)\n\n";i+="<span class=cX-code-comment># On the command line, execute:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   shiny run --reload --launch-browser app.py\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># And output similar to the following will be provided:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)\n"}else{i+='<span class=cX-code-key>if</span> __name__ == <span class=cX-code-key>"__main__"</span>:\n';i+="  <span class=cX-code-comment># Define a CX bar chart with some basic data</span>\n";i+="  chart: CanvasXpress = CanvasXpress(\n";i+="    render_to = "+this.target+",\n";i+="    data = "+c+",\n";i+="    config = "+g+",\n";if(f){i+="    events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="    after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="    width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="    height = <span class=cX-code-number>"+this.height+"</span>\n";i+="  )\n\n";i+="  <span class=cX-code-comment># Display the chart in its own Web page</span>\n";i+="  show_in_browser(chart)\n"}}}return"<code>"+i.replace(/\n/g,"</code>\n<code>")+"</code>"};this.JQ=function(){var k=JSON.parse(this.meta.config.user.cxplot);var l=JSON.stringify(k.data).replace(/\],/g,"],\n  ");var c=this.Hl(k.geoms)?k.geoms:[k.geoms];var a={};var h="";if(k.aes&&k.order){k.aes.meta={};Object.assign(k.aes.meta,k.order);if(!k.aes.hasOwnProperty("x")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("x")){k.aes.x=k.layers[d].x;break}}}if(!k.aes.hasOwnProperty("y")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("y")){k.aes.y=k.layers[d].y;break}}}}var m=JSON.stringify(k.aes);var j=["labels","scales","colors","coordinates","theme","facet","config"];h+="<span class=cX-code-key>var</span> data = "+l+";\n\n";h+='<span class=cX-code-key>var</span> cxp = <span class=cX-code-value>new</span> cxplot("canvas", data, aes('+m+"));\n";for(var b=0;b<c.length;b++){var d=a[c[b]]?c[b]+"."+a[c[b]]:c[b];var e=c[b].toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges");if(this[e]&&!this.skipGeoms){h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k.layers[d])+");\n"}a[d]=a[d]?a[d]+1:1}for(var b=0;b<j.length;b++){if(k[j[b]]){var e="gg_"+j[b];if(this.Hl(k[j[b]])){if(k[j[b]].length>0){h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}else{h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}}return"<code>"+h.replace(/\n/g,"</code>\n<code>")+"</code>"};this.gJ=function(g,f){var a=[["Id"]];for(var e=0;e<this.data.y.vars.length;e++){a[e+1]=[];a[e+1][0]=this.data.y.vars[e]}for(var e=0;e<this.data.y.smps.length;e++){a[0][e+1]=this.data.y.smps[e];for(var d=0;d<this.data.y.vars.length;d++){a[d+1][e+1]=this.data.y.data[d][e]}}if(g&&this.data[g]){if(g=="x"){for(var e in this.data.x){var b=a.length;a[b]=[];a[b][0]=e;for(var d=0;d<this.data.y.smps.length;d++){a[b][d+1]=this.data.x[e][d]}}}else{if(g=="z"){for(var e in this.data.z){var b=a[0].length;a[0][b]=e;for(var d=0;d<this.data.y.vars.length;d++){a[d+1][b]=this.data.z[e][d]}}}}}return f?this.aj(a):a};this.TC=function(d){if(d){var g={};for(var e=0;e<this.data.y.vars.length;e++){g[this.data.y.vars[e]]=e}var c=0;for(var e=0;e<d.data.y.vars.length;e++){if(g.hasOwnProperty(d.data.y.vars[e])){c++}}var f=0;for(var e=0;e<d.data.y.smps.length;e++){if(g.hasOwnProperty(d.data.y.smps[e])){f++}}if(c>0||f>0){if(c>f){}else{for(var e=0;e<d.data.y.vars.length;e++){this.data.z[d.data.y.vars[e]]=[];for(var b=0;b<d.data.y.smps.length;b++){if(g.hasOwnProperty(d.data.y.smps[b])){var a=g[d.data.y.smps[b]];this.data.z[d.data.y.vars[e]][a]=d.data.y.data[e][b]}}}if(d.data.hasOwnProperty("x")){for(var e in d.data.x){this.data.z[e]=[];for(var b=0;b<d.data.y.smps.length;b++){if(g.hasOwnProperty(d.data.y.smps[b])){var a=g[d.data.y.smps[b]];this.data.z[e][a]=d.data.x[e][b]}}}}}this.colorBy=d.data.y.vars[0];this.FV("z",false,false,true);return true}}return false};this.H5=function(a,b){if(this.varIndices.length&&this.smpIndices.length){var g=this;var B=function(i){if(i=="s"){return{y:{smps:g.Ev(g.data.y.smps)},x:{}}}else{return{y:{vars:g.Ev(g.data.y.vars)},z:{}}}};var C={};if(b&&this.data.z&&this.data.z.hasOwnProperty("cXId")){for(var x=0;x<this.data.z.cXId.length;x++){C[this.data.z.cXId[x]]=x}}var k={s:[],v:[]};var l={s:[],v:[]};var s;var v=2;var r=false;for(var x=1;x<a.length;x++){s=this.sF(a[x][0]);if(s>-1){k.s.push([x,s]);continue}s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.as(a[x][0]);if(s>-1){k.v.push([x,s]);continue}}for(var x=1;x<a[0].length;x++){s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.as(a[0][x]);if(s>-1){l.v.push([x,s]);continue}s=this.sF(a[0][x]);if(s>-1){l.s.push([x,s]);continue}}var h=k.s.length>v?k.s.length:0;var f=k.v.length>v?k.v.length:0;var e=l.s.length>v?l.s.length:0;var d=l.v.length>v?l.v.length:0;var z=this.data.y.smps.length;var A=this.data.y.vars.length;if(h||f||e||d){var t=0;if(h==z&&d==A){var D=[];for(var x=0;x<l.v.length;x++){var o=l.v[x][0];var c=l.v[x][1];D[c]=[];for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D[c][q]=a[y][o];t++}}r=true}else{if(e==z&&f==A){var D=[];for(var x=0;x<k.v.length;x++){var o=k.v[x][0];var c=k.v[x][1];D[c]=[];for(var w=0;w<l.s.length;w++){var y=l.s[w][0];var q=l.s[w][1];D[c][q]=a[o][y];t++}}r=true}else{if(h>=f&&h>=e&&h>=d){var D=B("s");for(var x=1;x<a[0].length;x++){D.x[a[0][x]]=[];var u=0;for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D.x[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.x[a[0][x]]}}}else{if(f>=h&&f>=e&&f>=d){var D=B("v");for(var x=1;x<a[0].length;x++){D.z[a[0][x]]=[];var u=0;for(var w=0;w<k.v.length;w++){var y=k.v[w][0];var q=k.v[w][1];D.z[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.z[a[0][x]]}}}else{if(e>h&&e>=f&&e>=d){var D=B("s");for(var x=0;x<l.s.length;x++){var o=l.s[x][0];var c=l.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.x[a[w][0]]=[]}D.x[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.x[a[w][0]]}}}else{if(d>h&&d>=f&&d>=e){var D=B("v");for(var x=0;x<k.s.length;x++){var o=k.s[x][0];var c=k.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.z[a[w][0]]=[]}D.z[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.z[a[w][0]]}}}}}}}}return{data:D,recs:t,addt:r}}else{if(b){var D=this.arrayToCX(a);this.data.x=D.data.x;this.data.y.smps=D.data.y.smps;this.data.y.vars=this.Ev(this.data.z.id);this.updateData(this.data);var p=this.meta.map.geojson.features;for(var x=0;x<p.length;x++){p[x].properties.key=this.data.y.vars[x];p[x].properties.varId=[x]}return{data:false,recs:this.data.y.smps.length,addt:false}}else{return a}}}return a};this.PK=function(){this.loadLLMDatasets=!this.loadLLMDatasets;this.Hp();if(CanvasXpress.datasets){return}var b=function(c){return function(d){CanvasXpress.datasets=c.parseJSON(d)}}(this);var a=window.location.origin+"/data/json/LLMdatasets.json";this.hG(a,false,b)};this.wz=function(){var b=function(c){return function(d){CanvasXpress.Rdatasets=c.parseJSON(d)}}(this);var a=this.RdatasetsURL+"datasets.json";this.hG(a,false,b);this.Hp()};this.S9=function(a,b){this.z9(this.RdatasetsURL+"csv/"+a+"/"+b+".csv");this.Rdataset={library:a,dataset:b,url:this.RdatasetsURL+"json/"+a+"/"+b+"Info.json",info:false}};this.GC=function(a,b){this.z9(this.RdatasetsURL+"datasetsCX.csv")};this.O5=function(){var f=this;var b=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var d=function(n){var l=function(z){var y={};var B=z[0];var r=0;var w=0;var u=0;var q={};var A=false;for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++}else{if(f.data.nodeIndices.hasOwnProperty(s)){r++}else{u++}}q[s]=x}if(!r&&!w){for(var x=0;x<f.data.nodes.length;x++){var s=f.data.nodes[x];if(s.hasOwnProperty("extId")&&q.hasOwnProperty(s.extId)){z[q[s.extId]][0]=s.id;r++}}}if(w>r){r=0;w=0;u=0;A="edge";for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++;y[s+":"+t]={};for(var v=2;v<B.length;v++){y[s+":"+t][B[v]]=z[x][v]}}else{u++}}}else{if(r>8){r=0;w=0;u=0;A="node";for(var x=1;x<z.length;x++){var s=z[x][0];if(f.data.nodeIndices.hasOwnProperty(s)){r++;y[s]={};for(var v=1;v<B.length;v++){y[s][B[v]]=z[x][v]}}else{u++}}}else{return z}}if((A=="edge"&&(w>5||w>=z.length-1))||(A=="node"&&(r>5||r>=z.length-1))){return{data:y,rows:Math.max(r,w),fail:u,type:A}}else{return z}};var o=l(f.parseDelimited(n));if(o&&!f.Hl(o)){var k="";if(o.fail>0){k=o.fail+" records couldn't be mapped to network data"}f.SJ(100,150,o.rows+" "+o.type+" records added to network data\n"+k,5000);var p=f.meta.config.user;var e=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var m=0;m<e.length;m++){var j=e[m];if(p.hasOwnProperty(j)){f[j]=p[j]}}if(o.type=="node"){f.fF(o.data)}else{f.S6(o.data)}if(f.appendNetworkData.length>0){f.O5()}else{f.Oj({func:"appendNetworkDataFromURL"});f.Gf()}}};var c=function(e){if(e.type=="node"){f.fF(e.data)}else{f.S6(e.data)}if(f.appendNetworkData.length>0){f.O5()}else{f.Oj({func:"appendNetworkDataFromURL"});f.Gf()}};var a=function(e){return function(i){if(b.match(/\.txt$/)||b.match(/\.csv$/)||b.match(/\.tsv$/)||b.match(/\.tab$/)){d(i)}else{e.Gf();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(b){if(typeof(b)=="string"){var g=null;try{g=JSON.parse(b);return c(g)}catch(h){g=null}g=this.parseDelimited(b)||null;if(g){return d(b)}if(this.isValidURL(b)){return this.hG(b,false,a)}}else{c(b)}}};this.z9=function(a){this.remoteService=a;this.hG(a,false,this.setDataSetFromURL,"text")};this.sw=function(a){return function(d){var f=function(i){return function(j){this.Rdataset.info=this.parseJSON(j);this.dataTableColMetadata=this.Rdataset.info.parameters}}(a);var e=a.arrayToCX(a.parseDelimited(d));var c=a.$("container-"+a.target).parentNode;var h=a.DW("-cX-data-sets-");var b=a.$cX("canvas",{id:h,width:a.originalWidth,height:a.originalHeight});a.ZT(b);c.appendChild(b);e.renderTo=h;e.config.view="table";var g=new CanvasXpress(e);g.Rdataset=a.Rdataset;g.hG(g.Rdataset.url,false,f,false,false,g);g.iA(a.target)}}(this);this.P1=function(e,d,i,c,f){if(!CanvasXpress.stack){CanvasXpress.stack={}}var b=this.$(this.target);var g=this.Ev(d)||false;if(g&&this.graphName){for(var a in this.graphName){g[a]=this.graphName[a]}}if(g&&this.scatterContext){g.graphType=this.scatterContext}var h=this.isCxplot&&this.Hl(e)?this.Ev(this.data):e?this.v8(e):false;if(this.isGraphTime){g.isGraphTime=true}if(this.xAxisTime){g.xAxisTime=this.xAxisTime}if(this.yAxisTime){g.yAxisTime=this.yAxisTime}if(b){CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:h,config:g,events:i?i:false,info:c?c.toString().replace(/'/g,"'").replace(/"/g,"'"):false,afterRenderInit:f?f:false,afterRender:[["setDimensions",[b.originalWidth,b.originalHeight,true]]],stateCX:[],stateIndexCX:0,noValidate:true}}};this.Mz=function(d){if(d.data){if(d.config.stringSampleFactors){for(var b=0;b<d.config.stringSampleFactors.length;b++){var c=d.config.stringSampleFactors[b];if(d.data.x&&d.data.x[c]){for(var a=0;a<d.data.x[c].length;a++){d.data.x[c][a]=d.data.x[c][a]}}}}if(d.config.stringVariableFactors){for(var b=0;b<d.config.stringVariableFactors.length;b++){var c=d.config.stringVariableFactors[b];if(d.data.z&&d.data.z[c]){for(var a=0;a<d.data.z[c].length;a++){d.data.z[c][a]=d.data.z[c][a]}}}}CanvasXpress.stack[this.target].data=d.data}};this.PE=function(){return CanvasXpress.stack[this.target].afterRender};this.lc=function(){var g={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,cola:true,colaConnector:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,leafletMap:true,lines:true,moveSankeyId:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true,mousedownElement:true,filteringNumericOn:true};if(this.graphType!="Network"||(this.graphType=="Network"&&this.networkLayoutType=="cola")){g.data=true}var f=Object.keys(this);var a=this.Fe(CanvasXpress.config);var e=[];for(var d=0;d<f.length;d++){var h=f[d];if(a.hasOwnProperty(h)){e.push(h)}else{if(!this.VJ(this[h])&&!g.hasOwnProperty(h)){e.push(h)}}}var b={};for(var d=0;d<e.length;d++){var h=e[d];b[h]=this.ZR(this[h])?this.Ev(this[h],true):this[h]}return b};this.d1=function(a){if(!a){a=0}var b=CanvasXpress.stack[this.target].stateCX[a];for(var e in b){this[e]=b[e]}var d={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.Oj({func:"setConfigState",par:[a]});this.skipStack=false;for(var e in d){this[e]=d[e]}};this.Lt=function(d){if(!this.skipStack&&d){var i=d.func;var j=d.par?this.fa(d.par):[];var c=d.prop?this.Ev(d.prop):{};var v=new Date().getTime();var w=CanvasXpress.stack[this.target];var e=w?w.afterRender.length:0;if(i&&w){switch(i){case"setDimensions":if(j&&j[0]==this.width&&j[1]==this.height){return}if(j&&j[5]){i="clickGraphMaxMin";j=j[5]>0?[false,false,true]:[false,this.maximized,false]}w.afterRender.push([i,j,{},v]);break;case"broadcastDraw":i=j[0].func;j=j[0]&&j[0].par?this.fa(j[0].par):[];c=j[0]&&j[0].prop||{};if(i){w.afterRender.push([i,j,c,v])}break;case"drawIndicesAfterPannEvent":case"drawIndicesAfterWheelEvent":case"drawRangesAfterWheelEvent":case"updateDragCircular":case"updateDragScatter":case"updateDragNetwork":case"updateDragGenome":case"updateDragMap":case"updateDragMarker":var k=w.afterRender;var b=w.stateCX;var g=i=="updateDragNetwork"&&j[0].shiftKey?false:true;if(e>1&&k[e-1][0]==i&&g){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}w.afterRender.push([i,j,c,v]);break;case"handleWheelEvent":w.afterRender.push([i,j,c,v]);break;case"resortSankeyDONOTUSE":var k=w.afterRender;var b=w.stateCX;if(e>1&&k[e-1][0]=="resortSankey"){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}default:w.afterRender.push([i,j,c,v]);break}if(!this.disableUndoRedoKeys&&w.stateIndexCX<w.stateCX.length-1){w.stateCX.splice(w.stateIndexCX,w.stateCX.length-1)}this.meta.stack.push([i,this.meta.time.start,this.meta.time.elapsed]);if(!this.disableUndoRedoKeys){var r=this.lc();w.stateCX.push(r);w.stateIndexCX=w.stateCX.length-1}}}};this.r8=function(a){return function(b){a.Wr(b,true)}}(this);this.Wr=function(a){return function(c,b,f){if(a.maximized){a.hQ()}if(a.motionBy){return}a.skipStack=true;a.reproducing=true;a.PA();a.bg();a.EW(c,true);a.meta.ids={};if(f){a.xT();a.vt(c,true,true)}else{a.wW(c);if((c&&c.shiftKey)||b){a.vt(c,true)}}}}(this);this.QE=function(a){return function(b){a.wt(b,true)}}(this);this.wt=function(a){return function(j,f,l){var k=a.xK(CanvasXpress.stack[a.target]);if(!this.isRawData){if(k.data.y){delete k.data.y.data}}this.isQQ=false;this.isCDF=false;k.config.showTransition=f?true:false;if(l){var g=a.Ev(k.afterRender);k.afterRender=[];for(var h=0;h<g.length;h++){var n=g[h];if(n[0]=="addCDFPlot"&&k.config.decorations){delete k.config.decorations.cdf}if(n&&n[4]){k.afterRender.push(n)}}}var b=false;if(a.maximized){a.hQ()}a.iA(a.target,true);new CanvasXpress(k)}}(this)};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.Rh=a};CanvasXpress.prototype.initConfig=function(){this.sj=function(cat){var d=CanvasXpress.doc;if(!d.M[cat]){d.M[cat]={}}if(!d.M[cat].P){d.M[cat].P=[];d.M[cat].U={}}};this.rW=function(base,color,desc,cat,llm,k){this[base+"Color"]=color==false?false:(color||"rgb(0,0,0)");var d=CanvasXpress.doc;var p=[base+"Color"];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base+"Color"]={C:"Color for the "+desc+"<br>",D:this[base+"Color"],M:cat,T:"color",L:llm||("Color the "+this.Y4(base)+" {_value_}")};if(desc.match(/^[x|y|r].+axis/)){d.P[base+"Color"].L="Color the "+desc.toLowerCase().replace(/ var /," variable ").replace(/ smp /," sample ")+"{_value_}"}};this.uT=function(base,color,desc,cat,llm,k){this[base]=color||"rgb(0,0,0)";var d=CanvasXpress.doc;var p=[base];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base]={C:"Color for the "+desc+"<br>",D:this[base],M:cat,T:"color",L:llm||("Color the "+this.Y4(base)+" {_value_}")}};this.oL=function(name,def,opts,desc,cat,llm,k,func){this[name]=def||false;var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string",L:llm||(name.match(/By$/)?this.Cv(name.replace(/By$/," ").replace(/ var /," variable ").replace(/ smp /," sample "))+"data by {_value_}":("Set the "+this.Y4(name)+" to {_value_}"))};if(func){d.P[name].F=func}};this.bq=function(name,def,opts,desc,cat,llm,k,func){this[name]=def||"";var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string",L:llm||("Set the "+this.Y4(name)+" to {_value_}")};if(func){d.P[name].F=func}};this.ck=function(name,def,desc,cat,llm,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"string",L:llm||("Set the "+this.Y4(name)+" to {_value_}")}}};this.xh=function(name,def,desc,cat,llm,k){this[name]=def==null?null:(def||0);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"integer",L:llm||("Set the "+this.Y4(name)+" to {_value_}")}}};this.kK=function(name,def,desc,cat,llm,k){this[name]=def!=null?def:null;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"float",L:llm||("Set the "+this.Y4(name)+" to {_value_}")};if(desc.match(/^[x|y|r].+axis/)){d.P[name].L="Set the "+desc.toLowerCase().replace(/ var /," variable ").replace(/ smp /," sample ")+" to {_value_}"}}};this.JW=function(name,def,desc,cat,llm,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"boolean",L:llm||("Set the "+this.Y4(name)+" to {boolean}")};if(!llm&&desc.match(/^Flag to \w.+/)){var f=desc.split(/\./);var m=f[0].match(/^Flag to (\w+)(.+)/);if(m.length){var v=this.Cv(m[1]);d.P[name].L="{"+v+"|Do Not "+v+"}"+m[2]}}}};this.Kc=function(name,def,desc,cat,llm,k){this[name]=def||[];if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array",L:llm||("Set the "+this.Y4(name)+" to {_value_}")}}};this.QX=function(name,def,desc,cat,llm,k){this[name]=def==false?false:(def||[]);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array",L:llm||("Set the "+this.Y4(name)+" to {_value_}")}}};this.Kv=function(name,def,desc,cat,llm,k){this[name]=def==false?false:{};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"object",L:llm||("Set the "+this.Y4(name)+" to {_value_}")}}};this.Nm=function(name,def,desc,cat,llm,k){this[name]=def||{cases:[],comp:[],op:[],type:[],value:[]};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"filter",L:llm||("Filter data where "+this.Y4(name)+" {_value_}")}}};this.ny=function(name,def,desc,cat,llm,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.sj(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"url",L:llm||("Set the URL for "+this.Y4(name).replace(/url/i,"")+" to {_value_}")}}};this.ss=function(cat,desc,graphs,llm){var d=CanvasXpress.doc;this.sj(cat);d.M[cat].U={C:desc,U:CanvasXpress.graphTypes[graphs],L:llm}};this.hd=function(base,fill,color,size,type,desc,cat,llm,k){this.rW(base,fill||"rgba(255,255,255,0)",desc,cat,llm,k);this.rW(base+"Border",color||"rgba(255,255,255,0)","border in "+desc,cat,llm,k);this.kK(base+"BorderSize",size||1,"Size for the border line in "+desc,cat,llm,k);this.oL(base+"BorderLineType",type||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the border in "+desc,cat,llm,k)};this.OS=function(base,face,color,size,scale,align,line,rotate,margin,desc,cat,llm,k){var s=this.Y4(base);this.bq(base+"FontStyle",face||"",["","bold","italic","bold italic"],"Font style for the "+desc,cat,llm,k);this.rW(base,color==false?false:(color||"rgb(0,0,0)"),"text in "+desc,cat,llm,k);this.xh(base+"FontSize",size||11,"Font size for the text in "+desc+". Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the "+base+"ScaleFontFactor",cat,llm,k);this.kK(base+"ScaleFontFactor",scale||1,"Scaling factor used to increase or decrease the "+desc+" font size in the canvas",cat,llm||("{Increase|Decrease} the size of the "+s+" by a factor of {_value_}").replace(/ var /," variable ").replace(/ smp /," sample "),k);this.oL(base+"Align",align||"center",["left","center","right"],"Alignment (or position) for the "+desc,cat,llm||("Align the "+s+" to the {_value_}").replace(/ var /," variable ").replace(/ smp /," sample "),k);this.oL(base+"Baseline",line||"middle",["top","middle","bottom"],"Baseline (or reference line) for the "+desc,cat,llm,k);this.xh(base+"Rotate",margin!=null?rotate:0,"Rotation in degrees for the "+desc,cat,llm||("Rotate the "+s+" {_value_} degrees").replace(/ var /," variable ").replace(/ smp /," sample "),k);this.kK(base+"Margin",margin!=null?margin:5,"Margin to pad or separate the characters in the "+desc,cat,llm,k)};this.z7=function(base,show,newick,pos,color,desc,cat,llm,k){var l=base.toLowerCase();var p=base=="Var"?["top","bottom"]:["left","right"];this.lj(base+"Dendrogram",show==false?false:true,desc,cat,llm,k);this.JW(l+"DendrogramUseHeight",false,"Boolean flag to allow the use of height in the provided Newick string for branch representation in the "+desc,cat,llm,k);this.JW(l+"DendrogramHang",true,"Flag to use extend the lines to the end of the terminal nodes when the newick is provided for the "+desc,cat,llm,k);this.ck(l+"DendrogramNewick",newick||false,"Custom dendrogram in Newick format created outside CanvasXpress to define and specify the hierarchy for the "+desc+".",cat,llm,k);this.Xt(l+"Dendrogram",pos,p,desc+" in the plot. It could be top, bottom, right or left depending on the orientation of the graph",cat,llm,k);this.oL("color"+base+"DendrogramBy",color||false,[false],"Name of metadata annotation to color the "+desc,cat,llm,k)};this.S4=function(base,color,trn,wid,len,type,show,desc,cat,llm,k){this.rW(base,color,desc,cat,llm,k);this.kK(base+"Transparency",trn||1,"Transparency for the color of the "+desc,cat,llm,k);this.kK(base+"Width",wid||1,"Width for the "+desc,cat,llm,k);this.kK(base+"Length",len||null,"Length for the "+desc,cat,llm,k);this.od(base,type,desc,cat,llm,k);this.oi(base,show,desc,cat,llm,k)};this.g1=function(base,show,height,desc,cat,llm,k){var s=this.Y4(base);this.JW(base+"HistogramShow",show==false?false:true,"Flag to show/hide the histogram in the "+desc,cat,llm||"{Show|Hide} the "+s+" histogram",k);this.xh(base+"HistogramHeight",height||80,"Size in pixels for the histogram in the "+desc,cat,llm,k)};this.YP=function(base,show,height,pos,desc,cat,llm,k){var s=this.Y4(base);this.JW(base+"RugShow",show==false?false:true,"Flag to show/hide a data rug in the "+desc,cat,llm||"{Show|Hide} the "+s+" rug",k);this.xh(base+"RugHeight",height||80,"Size in pixels for the data rug in the "+desc,cat,llm,k);this.oL(base+"RugPosition",pos?pos[0]:false,pos,"Position for the data rug in the"+desc,cat,llm,k)};this.Xt=function(base,pos,opts,desc,cat,llm,k){var s=this.Y4(base.replace(/^Var/,"Variable").replace(/^Smp/,"Sample"));this.oL(base+"Position",pos||"right",opts,"Position for the "+desc,cat,llm||"Put the "+s+" on the {_value_}",k)};this.gl=function(base,dir,desc,cat,llm,k){this.oL(base+"Direction",dir||"vertical",["vertical","horizontal"],"Direction for "+desc,cat,llm,k)};this.lj=function(base,show,desc,cat,llm,k){var s=this.Y4(base.replace(/^Var/,"Variable").replace(/^Smp/,"Sample"));this.JW("show"+base,show==false?false:true,"Flag to show/hide the "+desc,cat,llm||"{Show|Hide} the"+s,k)};this.oi=function(base,show,desc,cat,llm,k){var s=this.Y4(base);this.JW(base+"Show",show==false?false:true,"Flag to show/hide the "+desc,cat,llm||"{Show|Hide} the "+s,k)};this.od=function(base,style,desc,cat,llm,k){this.oL((base+"LineType").replace("LineLine","Line"),style||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the "+desc,cat,llm,k)};this.Dm=function(base,trn,desc,cat,llm,k){var s=this.Y4(base);this.oL(base+"Transform",trn||false,[false,"log2","log10","-log2","-log10","exp2","exp10","sqrt","percentile"],"Type of transformation for values in "+desc,cat,llm||"Transform the "+s+" to {_value_}",k)};this.ms=function(base,desc,cat,llm,k){var c=base.toUpperCase();var s=c=="Y"?["Right","Left"]:c=="X"?["Top","Bottom"]:[];var p=c=="Y"?["left","rigth","both"]:c=="X"?["bottom","top","both"]:false;var f=c=="Y"?" on the left":c=="X"?" on the bottom":"";var a=c=="Y"?" on the right":c=="X"?" on the top":"";var t=c=="Z"?10:5;if(c!="R"){this.Kc(base+"Axis",[],"Name of the samples, groups or variables to be displayed in the "+desc,cat,llm,k);this.Kc(base+"AxisIndices",[])}if(c=="X"){this.Kc(base+"Axis2",[],"Name of the samples, groups or variables to be displayed in the second "+desc,cat,llm,k)}this.xh(base+"AxisCurrent",0,"Sample id that is currently displayed in the "+desc+". Important when there are more that one series displayed in the graph",cat,llm,k);this.JW(base+"AxisShow",true,"Flag to show/hide the "+desc+f,cat,llm||"{Show|Hide} the "+desc,k);if(c=="X"||c=="Y"){this.JW(base+"Axis2Show",false,"Flag to show/hide the "+desc+a,cat,llm||"{Show|Hide} the "+desc,k);this.JW(base+"Axis2Rotate",false,"Flag to rotate 180 degrees the direction of the "+desc+a,cat,llm,k)}this.kK("setMin"+c,null,"Set the minimum value for data in the "+desc,cat,llm||"Set the minimum value for data in the "+desc+" to {_value_}",k);this.kK("setMax"+c,null,"Set the maximum value for data in the "+desc,cat,llm||"Set the maximum value for data in the "+desc+" to {_value_}",k);if(c!="R"){this.kK("setPanningMin"+c,null,"Set the minimum value allowed to pann the data in the "+desc,cat,llm,k);this.kK("setPanningMax"+c,null,"Set the maximum value allowed to pann the data in the "+desc,cat,llm,k)}this.kK(base+"AxisAbsMin",null);this.kK(base+"AxisAbsMax",null);this.ck(base+"AxisMaxStrLength",false);this.kK(base+"AxisMin",null);this.kK(base+"AxisMax",null);this.kK(base+"AxisRange",null);this.kK(base+"AxisIncr",null);this.kK(base+"AxisDecs",null);this.JW(base+"AxisExtensionMin",false);this.JW(base+"AxisExtensionMax",false);if(c=="X"){this.kK("setMin"+c+2,null,"Set the minimum value for data in the second "+desc,cat,llm||"Set the minimum value for data in the "+desc+" to {_value_}",k);this.kK("setMax"+c+2,null,"Set the maximum value for data in the second "+desc,cat,llm||"Set the maximum value for data in the "+desc+" to {_value_}",k);this.kK(base+"Axis2AbsMin",null);this.kK(base+"Axis2AbsMax",null);this.ck(base+"Axis2MaxStrLength",false)}this.JW(base+"AxisTime",false,"Flag to force date format in "+desc,cat,llm,k);this.JW(base+"AxisExact",false,"Flag to force exact values in "+desc,cat,llm,k);this.Kc(base+"AxisValues",[]);this.Kc(base+"AxisValuesRaw",[]);this.Kc(base+"AxisMinorValues",[]);this.Kc(base+"AxisSetValues",[],"Set the values for the axis in the "+desc,cat,llm,k);this.Kc(base+"AxisSetMinorValues",[],"Set the minor values for the axis in the "+desc,cat,llm,k);if(c=="X"){this.Kc(base+"Axis2Values",[]);this.Kc(base+"Axis2ValuesRaw",[]);this.Kc(base+"Axis2MinorValues",[])}this.Dm(base+"Axis",false,desc,cat,llm,k);this.JW(base+"AxisTransformTicks",false,"Flag to transform the values of the ticks in the "+desc,cat,llm,k);this.JW(base+"AxisTransformLinearTicks",false,"Flag to transform the values of the ticks back to linear scale in the "+desc,cat,llm,k);this.kK(base+"AxisCeilValue",null,"Value to ceil the data in the "+desc,cat,llm,k);this.kK(base+"AxisFloorValue",null,"Value to floor the data in the "+desc,cat,llm,k);this.kK(base+"AxisFactorValue",null,"Value to factor the data in the "+desc,cat,llm,k);this.ck(base+"AxisTitle",false,desc+" title "+f,cat,llm,k);this.ck(base+"Axis2Title",false,desc+"2 title "+a,cat,llm,k);this.JW(base+"AxisTitleDynamic",false,"Set the title for the "+desc+" dynamically as it changes when configured by the user",cat,llm,k);this.OS(base+"AxisTitle","","rgb(0,0,0)",8,1,"center","middle",0,5,"axis title",cat,llm,k);this.OS(base+"AxisText","","rgb(0,0,0)",8,1,"center","middle",0,5,"axis text",cat,llm,k);this.S4(base+"AxisGridMajor","rgb(204, 204, 204)",1,1,5,"solid",true,"major grid lines in the "+desc+f,cat,llm,k);this.S4(base+"AxisGridMinor","rgb(204, 204, 204)",1,0.5,5,"solid",true,"minor grid lines in the "+desc,cat,llm,k);this.oi(base+"AxisGridMajor",true,"major grid lines in the "+desc,cat,llm||"{Show|Hide} the major grid lines in the "+desc,k);this.oi(base+"AxisGridMinor",true,"minor grid lines in the "+desc,cat,llm||"{Show|Hide} the minor grid lines in the "+desc,k);this.S4(base+"AxisTicks","rgb(204, 204, 204)",1,1,null,"solid",true,"marker lines across the "+desc,cat,llm,k);for(var i=0;i<s.length;i++){this.S4(base+"AxisTick"+s[i],"rgb(204, 204, 204)",1,1,null,"solid",true,s[i].toLocaleLowerCase()+" tick line across the "+desc,cat,llm,k)}for(var i=0;i<s.length;i++){this.S4(base+"AxisLine"+s[i],"rgb(204, 204, 204)",1,1,null,"solid",true,s[i].toLocaleLowerCase()+" line across the "+desc,cat,llm,k);this.oi(base+"AxisLine"+s[i],false," line in the "+desc,cat,llm,k)}this.ck(base+"AxisTickFormat",false,desc+" format for the tick values in the "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,llm,k);this.xh(base+"AxisTicks",t,"Approx number of tick lines in the "+desc,cat,llm,k);if(c=="X"){this.ck(base+"Axis2TickFormat",false,desc+" format for the tick values in the second "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,llm,k);this.xh(base+"Axis2Ticks",t,"Approx number of tick lines in the second "+desc,cat,llm,k)}this.S4(base+"AxisLogTicks","rgb(0,0,0)",1,1,8,"solid",false,"log tick lines in the "+desc+f,cat,llm,k);if(c=="X"||c=="Y"){this.xh(base+"AxisMinorTicks",2,"Number of minor ticks between major ticks in the "+desc,cat,llm,k);this.g1(base+"Axis",false,80,desc,cat,llm,k);if(p){this.YP(base+"Axis",false,15,p,desc,cat,llm,k)}}};this.Y4=function(str){return str.replace(/([A-Z])/g," $1").toLowerCase().replace(/ var /," variable ").replace(/ smp /," sample ").replace("variableiable","variable")};this.Wk=function(){var k=CanvasXpress.config;var t=["bw","classic","cx","cxdark","dark","economist","excel","ggblanket","ggplot","gray","grey","highcharts","igray","light","linedraw","minimal","none","ptol","solarized","stata","tableau","void0","wsj","cx2"];var b="rgb(0,0,0)";var w="rgb(255,255,255)";var n="rgba(0,0,0,0)";var m="rgba(255,255,255,0)";var c;c="General";this.ss(c,"General properties used in all visualizations","AllGraphs",true);this.oL("graphType","Bar",CanvasXpress.graphTypes.AllGraphs,"Specifies the type of graph to be rendered",c,"Create a {_value_} graph",k);this.ck("graphName",false,"String used to store popular graph or plot names to map to the real graphType parameter in CanvasXpress",c);this.oL("theme","none",t,"The style for the plot or theme will control all the non-data elements of the plot including titles, legends, axes, panel and plot background colors and other stylistic elements",c,"",k);c="General One Dimensional Graphs";this.ss(c,"General properties used in one dimensional visualizations","OneDGraphs",true);this.oL("graphOrientation","horizontal",["horizontal","vertical"],"Specifies the orientation of one-dimensional graphs",c,"Orient the graph {_value_}",k);this.JW("invertGraph",false,"Option to reverse one-dimensional horizontal graphs for plotting from right to left",c,"{Invert|Do not invert} the graph",k);c="Plot Data Type";this.ss(c,"Type of plot","AllGraphs",false);this.JW("isR",false,"Flag to indicate visualization wasa done through the R API interface",c,"",k);this.JW("isChat",false,"Expose the chat interface at instatiation of the plot",c,"{Show|Hide} the chat interface",k);this.JW("isCxplot",false,"Flag to indicate visualization wasa done through the cxplot interface",c,"",k);this.ck("isGGMatrix",false,"String to correspond to the longest label to put in the left margin if the plot is part of a ggplot extension library, ggmatrix",c,"",k);this.JW("isDataFrame",false,"Flag to use data object as a data frame from R or Python",c,"",k);c="Plot Mode";this.ss(c,"Properties to customize the plot","AllGraphs",false);this.JW("isEditable",true,"Prevent data editing in JS Fiddle and CodePen by disabling the option in the File menu",c,"{Enable|Disable} edit of the graph on third party sites",k);this.JW("isReproducibleResearch",true,"Flag to track user modifications for Reproducible Research",c,"{Keep|Do not keep} track of modifications",k);this.xh("reproduceTime",500,"Duration in milliseconds to wait for replicating user modifications via the UI",c,"",k);c="Plot Performance";this.ss(c,"Properties to improve plot performance","AllGraphs",false);this.xh("overplotPixels",500000,"Specify the pixel count for stacking to address overplotting. Increased values result in reduced overplotting, particularly advantageous for datasets with numerous variables",c,"",k);this.xh("fullTextMeasureCheck",500,"Perform a comprehensive review of variable and sample name lengths when exceeding the specified quantity. This is beneficial for extensive data sets, as canvas lacks an efficient method for measuring text",c,"",k);this.JW("skipRender",false,"Flag to skip rendering of the graph",c);c="Plot View";this.ss(c,"General view properties","AllGraphs",true);this.oL("view","canvas",["canvas","table","layout"],"Specify the initial view or display for the visualization",c,"View data in a {_value_}",k);this.JW("layoutTable",false,"Flag to display the table and the filters without the canvas in the layout view",c,"",k);this.JW("tableLayout",false,"Flag to display the table and the filters without the canvas in the table view",c,"",k);c="Graph Metadata";this.ss(c,"General graph metadata properties used in all graphs","AllGraphs",false);this.Kc("tags",[],"Tags",c,"",k);this.Kv("metaData",{},"Metadata for the columns of files retrieved from a URL",c,"",k);this.ck("password",false,"Password to protect exploring data",c,"",k);this.kK("createVersion",false,"CanvasXpress Version used to create plot. This is parsed from the PNG or JSON data loaded",c);this.Kv("createFactory",false,"CanvasXpress Factory used to create plot. This is parsed from the PNG or JSON data loaded",c);c="Foreground and Background";this.ss(c,"Foreground and Background properties used in all visualizations","AllGraphs",true);this.uT("foreground",b,"Specifies the default foreground color for text and lines not covered in a more specific configuration property",c,"",k);this.uT("background",w,"Specifies the default background color for elements in the canvas not covered in a more specific configuration property",c,"",k);c="Plot and Panel Areas";this.ss(c,"General plot and panel properties used in all graphs","AllGraphs",true);this.hd("plotBackground",w,"rgba(204,204,204,0)",1,"solid","plot background. This includes the entire graph area","Plot and Panel Areas","",k);this.hd("panelBackground",w,"rgba(204,204,204,0)",1,"solid","panel background. This includes only the area where the data is plotted","Plot and Panel Areas","",k);this.oL("backgroundType","solid",["solid","gradient","panel","panelGradient","panelSolidGradient","image","panelImage"],"Specifies the style for the background of the canvas. The canvas background is composed of a frame with a panel where the data is plotted. Either of these elements the may be a solid or gradient color or an image of your choosing. The colorScheme property will be used If gradient is specified",c,"",k);this.ny("backgroundImage",false,"Specifies the url for the background image when the background type is of the type image or panelImage",c,"",k);this.ck("backgroundImageSrc",false,"Specifies the source for the background image when the background type is of the type image or panelImage",c,"",k);c="Transparency";this.ss(c,"General transparency properties used in all graphs","AllGraphs",false);this.kK("transparency",null,"Unit interval or fraction of transparency applied to all elements in the visualizations",c,"",k);this.kK("transparencyHidden",0.1,"Unit interval or fraction of transparency applied to elements that are hidden",c,"",k);c="Shadows";this.ss(c,"Shadow properties used in most visualizations","AllGraphs",false);this.lj("Shadow",false,"shadows in all graph objects in the canvas. It will be forced to false if the browser is IE",c,"",k);this.lj("TextShadow",false,"shadows in text in the canvas. It will be forced to false if the browser is IE",c,"",k);this.xh("shadowOffsetX",1,"Length in pixels for the shadow offset in the X axis",c,"",k);this.xh("shadowOffsetY",1,"Length in pixels for the shadow offset in the Y axis",c,"",k);this.xh("shadowBlur",2,"Amount in blur for the shadow",c,"",k);this.rW("shadow","rgba(0,0,0,0.5)","shadow",c,"",k);c="Gradients";this.ss(c,"Properties used to adjust color gradients in all visualizations","AllGraphs",true);this.JW("gradient",false,"Flag to apply a color gradient to all elements in the graphs",c,"",k);this.oL("gradientType","radial",["linear","radial"],"Specifies the type of gradient pattern",c,"",k);this.oL("gradientOrientation","vertical",["vertical","horizontal"],"Specifies the orientation of the gradient when the gradient type is linear.",c,"",k);c="Aspect Ratio, Space and Width";this.ss(c,"Properties used to adjust the aspect ratio, space and width in most visualizations","AllGraphs",true);this.JW("adjustAspectRatio",true,"Flag to resize graph elements in the plots to fit within the specified canvas width and height. If the flag is set to false the width and height of the canvas will be sized according to the number of elements in the data set",c,"",k);this.xh("adjustAspectRatioMax",3,"Specifies the number of times to try to automatically adjust the size of the canvas when adjustAspectRatio is true",c);this.xh("adjustAspectRatioYTries",0,"Counter set when trying to automatically adjust the vertical size of the canvas when adjustAspectRatio is true",c);this.xh("adjustAspectRatioXTries",0,"Counter set when trying to automatically adjust the horizontal size of the canvas when adjustAspectRatio is true",c);this.kK("percentAspectRatioPlotArea",0.35,"Specifies the minimum unit interval or fraction for the plotting area",c,"",k);this.kK("fixedAspectRatio",0,"Keep fixed aspect ratio expressed as y / x. A zero value is used to ignore otherwise the x and y axes are set accordingly. This has a use only in visium plots",c,"",k);this.xh("variableSpace",2,"Pixels between the data series in one-dimensional plots",c,"",k);this.xh("widthFactor",1,"Factor to adjust the width of the graph elements in one-dimensional and three-dimensional plots. The greater the number, the wider the elements",c,"",k);this.xh("dataPointSize",10,"Approximate pixel size for the data points in scatter plots, dotplots and boxplots. The size will be adjusted according to the dimensions of the graph",c,"",k);this.kK("dataPointSizeScaleFactor",1,"Factor used to adjust the size of the dataPointSize",c,"",k);this.xh("setPlotX",0,"Set the x dimension of the plotting area to the specified number of pixels, provided the value is greater than zero. This is used to align multiple graphs in a web page",c,"",k);this.xh("setPlotY",0,"Set the y dimension of the plotting area to the specified number of pixels, provided the value is greater than zero. This is used to align multiple graphs in a web page",c,"",k);this.xh("setPlotLeft",0,"Set the left dimension of the plotting area to the specified number of pixels, provided the value is greater than zero. This is used to align multiple graphs in a web page",c,"",k);this.xh("setPlotTop",0,"Set the top dimension of the plotting area to the specified number of pixels, provided the value is greater than zero. This is used to align multiple graphs in a web page",c,"",k);c="Margins";this.ss(c,"Margin properties used in most visualizations","AllGraphs",true);this.xh("margin",8,"Relative length in pixels for the distance between various objects in the graphs. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true",c,"",k);this.xh("marginLeft",8,"Specifies the length in pixels for the left margin in the canvas",c,"",k);this.xh("marginTop",8,"Specifies the length in pixels for the top margin in the canvas",c,"",k);this.xh("marginBottom",8,"Specifies the length in pixels for the bottom margin in the canvas",c,"",k);this.xh("marginRight",16,"Specifies the length in pixels for the right margin in the canvas",c,"",k);c="Text";this.ss(c,"Properties associated with text attributes","AllGraphs",true);this.Kc("fonts",[],"Goggle Fonts",c,"",k);this.Kc("fontsExternal",[],"External Fonts",c,"",k);this.oL("fontName","Arial",Object.keys(CanvasXpress.fonts),"Font name. Web-Safe HTML fonts",c,"",k);this.bq("fontStyle","",["","bold","italic","bold italic"],"Font style",c,"",k);this.rW("font",b,"font",c,"",k);this.xh("fontSize",11,"Font size for text in complex plot only. See other categories to modify specific font sizes",c,"",k);this.kK("fontScaleFontFactor",1,"Scaling factor used to increase or decrease the font size in the canvas",c,"",k);this.oL("align","center",["right","center","left"],"Default horizontal alignment for drawing text",c,"",k);this.oL("baseline","middle",["top","middle","bottom"],"Default vertical alignment for drawing text",c,"",k);this.xh("maxTextSize",40,"Maximum size for any text in the canvas",c,"",k);this.xh("minTextSize",4,"Minimum size for any text in the canvas",c,"",k);this.JW("autoScaleFont",true,"Flag to adjust the font size in many visualization. Please be aware that scaling factors can still modify the font size. This flag needs to be false for the text to accept the specified font size",c,"",k);this.xh("scaleTextConstantMult",25,"Constants to autoscale text",c);this.kK("scaleTextConstantAdd",2,"Constants to autoscale text (extra)",c);this.kK("scaleTextConstantFactor",55,"Constants to autoscale text across all fonts. The higherthe value, the smaller the text",c);c="Marginal Text";this.ss(c,"Properties associated with marginal text","AllGraphs",true);this.ck("topMarginalText",false,"Text to include at the top of the graph in the top margin",c,"",k);this.OS("topMarginalText","",b,13,1,"left","top",0,5,"top marginal text",c,"",k);this.ck("bottomMarginalText",false,"Text to include at the bottom of the graph in the bottom margin",c,"",k);this.OS("bottomMarginalText","",b,13,1,"left","top",0,5,"bottom marginal text",c,"",k);this.ck("leftMarginalText",false,"Text to include at the left of the graph in the left margin",c,"",k);this.OS("leftMarginalText","",b,13,1,"left","center",0,5,"left marginal text",c,"",k);this.ck("rightMarginalText",false,"Text to include at the right of the graph in the right margin",c,"",k);this.OS("rightMarginalText","",b,13,1,"left","center",0,5,"right marginal text",c,"",k);c="Text Placement";this.ss(c,"Properties associated with text placements attributes","AllGraphs",true);this.JW("optimizeTextPosition",false,"Flag to optimize position for text in many plots",c,"",k);this.oL("optimizeTextPositionStrategy","greedy",["annealing","greedy","boundingBox"],"Startegy to optimize placement of text",c,"",k);this.JW("optimizeTextPositionEnforceBounds",true,"Flag to enforce bounds when optimizing position for text in many plots",c,"",k);this.JW("optimizeTextPositionRemoveOverlaps",true,"Flag to remove overlaps when optimizing position for text in many plots",c,"",k);this.xh("optimizeTextPositionTemperature",1000,"Temperature parameter when optimizing position for text in many plots",c,"",k);this.xh("optimizeTextPositionCooling",1,"Cooling parameter when optimizing position for text in many plots",c,"",k);c="Titles and Subtitles";this.ss(c,"Properties associated with titles and subtitles","AllGraphs",true);this.ck("title",false,"Title of the graph",c,"",k);this.ck("subtitle",false,"Subtitle of the graph",c,"",k);this.OS("title","bold",b,13,1,"center","middle",0,5,"title",c,"",k);this.hd("titleBackground",m,m,0.5,"solid","title background",c,"",k);this.OS("subtitle","",b,12,1,"center","middle",0,5,"subtitle",c,"",k);this.hd("subtitleBackground",m,m,0.5,"solid","subtitle background",c,"",k);c="Citations or References";this.ss(c,"Properties associated with citations or references of the plot","AllGraphs",true);this.ck("citation",false,"A reference citation of the graph which is placed at the bottom right corner",c,"",k);this.OS("citation","",b,8,1,"right","middle",0,5,"citations",c,"",k);c="Lines";this.ss(c,"Properties to adjust Lines","AllGraphs",true);this.xh("dashLength",8,"Size in pixels of the length of the dashes and the separation between the dashes in the dashed lines",c,"",k);this.xh("dotLength",1,"Size in pixels of the length between dots in the doted lines",c,"",k);this.kK("arrowQuadraticFactor",2.3,"Factor to use to bend the quadratic lines",c,"",k);this.oL("arrowHeadType","filledArc",["wire","filledStraight","filledArc","filledQuadratic","filledBezier"],"Type for the head of the arrows",c,"",k);this.JW("arrowHeadTypeOpen",false,"Flag to use white fill for the arrow head",c,"",k);this.xh("arrowHeadSize",10,"Size in pixels of the arrow head in arrow lines",c,"",k);this.kK("arrowHeadAngle",22.5,"The angle for the head of the arrow",c,"",k);this.oL("capType","butt",["butt","round","square"],"Default type of cap for lines",c,"",k);this.oL("joinType","mitter",["mitter","bevel","round"],"Default type for joining lines",c,"",k);this.xh("lineWidthEvent",0.5,"Size in pixels of the width for the events in the lines",c);this.kK("outlineWidth",1,"Default width in pixels for lines in networks and other line elements in all visualizations except for the lines in the line plots",c,"",k);this.kK("lineThickness",1,"Default thickness in pixels for the lines in line plots",c,"",k);this.JW("adjustBezier",false,"Flag to select the bezier line type. the bezier can start from the top or bottom (vertical), or from the side (horizontal). This will be based on the location of the two points joined by the line",c,"",k);this.Kc("lines",["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC"],"Line types in network graphs for the edges (or connections) between network nodes.<br> There are three styles: solid, dashed and dotted and four sub types: straight, bezier, curved (clockwise) and curvedCC (counter clockwise). The line types can be any combination of a style followed by a subtype. By default the type is always a solid straight line so there is no need to specify solid or stright as a style if there is a subtype.<br> Lines can also have elbows which are specified as a 2D-array. In the case a straight solid line each elements in the array will have an x,y coordinate and each segment will be perpendicular to the previous one. For example in this edge object:<br> <i>{ ..., type : line, elbows : [ [20, 40], [60, 80] ], ... }</i><br> A special subtype of line called segmented can also have elbows which are not perpendicalar to each other. For example in this edge object:<br> <i>{ ..., type : segmented, elbows : [ [20, 40], [60, 80] ], ... }</i><br> In the case of a bezier curved each element of the array will have an x,y coordinate for the control point 1, an x,y coordinate for the control point 2 and an x,y coordinate for the end of the line.<br> <i>{ ..., type : bezier, elbows : [ [20, 40, 40, 20, 40, 40], ... ], ... }</i><br> If the property elbow is specified the line will be drawn using the first and last elements of the array rather than the coordinates of the two nodes. A property startX and startY can be used to better adjust the position of the starting line. Similarly, a property endX and endY can be used to better adjust the position of the end line. These properties have a maginitud between -1 to 1 which will be used based on the width and height of the source and target node. For example in the following edge object the line will start in the middle bottom of the source node and will end at the upper left of the target node.<br>  <i>{ ..., type : line, startX : 0, startY : 1, endX : -1, endY : -0.5, ... }</i>",c);this.Kc("arrows",["arrow","square","round"],"Arrows for the edges (or connections) in network graphs.<br> There are three arrow types: arrow, square and round. They can be at the start or at the end of the line. To specify an arrow at the start of the line include a startArrow property in the edge; to specify an arrow at the end of the line include a endArrow property in the edge. For example in this edge object:<br> <i>{ ..., type : line, startArrow : square, endArrow : arrow, ... }</i>",c);c="Colors";this.ss(c,"Properties to adjust Colors","AllGraphs",true);this.oL("colorScheme","User",Object.keys(CanvasXpress.colorSchemes).sort(),"Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization",c,"",k);this.Kc("colors",["#0ab0db","#fe6969","#fed385","#47db0a","#9e0adb","#ff7d00","#ffa2c0","#a0d7e7","#63b5e5","#f9a7a7","#fef0c7","#83e16f","#c763e5","#ffb347","#ffc1d3","#bfe2ed"],c,c,"",k);this.Kc("colorHSV",[0,0,1],"Color HSV. Hue, Saturation and Value used when configuring colors",c);this.Kc("colorRGB",[1,1,1],"Color RGB. Red, Green, Blue used when configuring colors",c);this.Kc("colorSpectrum",["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"],"An array with valid color names to create a color brew for the default color indicators",c,"",k);this.JW("colorSpectrumBinned",false,"Flag to bin the color spectrum based on the colorSpectrumBreaks or the colorSpectrum colors",c,"",k);this.Kc("colorSpectrumBreaks",[],"An array with numbers in ascending order for the color spectrum to create discontinuous spectra. It must have the same length of the colorSpectrum array for example [0, 0.3, 1]",c,"",k);this.kK("colorSpectrumZeroValue",null,"A value to be at the center of the color spectrum to produce symmetrical heatmaps",c,"",k);this.xh("colorSpectrumNumber",100,"Number of colors to use in the color spectrum",c);this.xh("colorSpectrumTarget",10,"Approximate number of colors to use to build the color spectrum",c);this.rW("odd",w,"odd numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots",c,"",k);this.rW("even","rgb(245,245,245)","even numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots",c,"",k);this.oL("blindnessType",false,[false,"protanopia","deuteranopia","tritanopia","monochromatic"],"Color Blindness",c,"",k);this.Kv("colorSpectrumByFactor",{},"Color spectrum by factor in heatmaps. The first key represents the name of the factor within the x/z data object. The subsequent keys correspond to each level of that factor. Finally, the next keys include show, order, spectrum, setMin, setMax, zero, and breaks, each paired with their respective values",c,"",k);c="Shapes";this.ss(c,"Properties to adjust Shapes","AllGraphs",true);this.xh("roundedPolygonRadius",5,"Radius for rounded polygons",c,"",k);this.JW("useRoundRectangles",false,"Flag to use round rectangles in bar graphs, stacked graphs and boxplots",c,"",k);this.oL("plotStyle","default",["default","ggplot","ggplotSwitched","open","border"],"Style for some shapes used mainly in boxplot, violin and density plots",c,"",k);c="Sizes";this.ss(c,"Properties to adjust Sizes","AllGraphs",true);this.Kc("sizes",[8,12,16,20,24,28,32,36,40,44,48],"Array with sizes used invisualizations. The order will dictate the utilization in the visualization",c,"",k);this.xh("initialSize",null,"Initial size in pixels for the objects in the visualizations",c,"",k);this.xh("sizeStep",4,"Size step in pixels for the objects in the visualizations",c,"",k);c="General Attributes";this.ss(c,"Properties related to Shapes, Images and Patterns","AllGraphs",true);this.Kc("shapes",["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"],"Array with shapes used in visualizations. The order will dictate the utilization in the visualization",c,"",k);this.Kc("images",[],"Array of urls of images used in scatter plots. Additional shapes will be used if the array does not contain as many images as needed",c,"",k);this.Kc("patterns",["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"],"Patterns used in visualizations to fill objects. This array must contain one or more pattern names and in concert with the color array can be used to specify the pattern colors for all filled objects in the visualizations.. The order will dictate the utilization in the visualization",c,"",k);this.Kc("linePatterns",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line Patterns used in line visualizations",c,"",k);this.rW("patternStroke","rgb(0,0,0)","Color for the stroke of the patterns used in visualizations",c,"",k);this.rW("patternFill","rgba(0,0,0,0)","Color for the fill of the patterns used in visualizations",c,"",k);this.xh("patternStrokeWidth",1,"Width in pixels for the stroke of the patterns used in visualizations",c,"",k);c="Samples";this.ss(c,"Properties associated with samples","OneTwoThreeeDGraphs",true);this.xh("maxSmpStringLen",25,"Maximum length in characters a sample label or description can have so anything above is truncated",c,"",k);this.ck("smpTitle",false,"Title for the sample axis in one dimensional plots",c,"Set the sample title to {_value_}",k);this.xh("smpLabelInterval",1,"Interval for the sample labels in one dimensional and circular plots",c,"",k);this.JW("smpLabelImage",false,"Flag to use images as sample labels when possible",c,"",k);this.JW("smpLabelImageRound",false,"Flag to use round images as sample labels",c,"",k);this.JW("smpLabelAutoAlignPosition",true,"Flag to use best position for sample labels depending on the location of them. It will align them right when placed in the left of the graphs and viceversa",c,"",k);this.lj("SampleNames",true,"sample names",c,"",k);this.Kc("highlightSmp",[],"Name of samples to highlight",c,"",k);this.rW("smpHighlight","#fe6969","higlighted samples",c,"",k);this.OS("smpTitle","",b,11,1,"center","middle",0,5,"sample title",c,"",k);this.OS("smpText","",b,11,1,"right","middle",0,5,"sample labels",c,"",k);c="Variables";this.ss(c,"Properties associated with variables","OneTwoThreeeDGraphs",true);this.xh("maxVarStringLen",25,"Maximum length in characters a variable label or description can have so anything above is truncated",c,"",k);this.ck("varTitle",false,"Title for the variables in hetamap plots",c,"Set the variable title to {_value_}",k);this.xh("varLabelInterval",1,"Interval for the variable labels in heatmaps",c,"",k);this.lj("VariableNames",true,"variable names",c,"",k);this.Kc("highlightVar",[],"Name of variables to highlight",c,"",k);this.rW("varHighlight","#fe6969","higlighted variables",c,"",k);this.OS("varTitle","",b,11,1,"center","middle",0,5,"variable title",c,"",k);this.OS("varText","",b,11,1,"center","middle",0,5,"variable text",c,"",k);c="Bins";this.ss(c,"Function to bin samples and variables","OverlayGraphs",true);this.Kv("binConfigurations",{},"Properties for the binning functions",c,"",k);c="Overlays";this.ss(c,"Colored boxes to help in the visualization of samples and variables","OverlayGraphs",true);this.xh("maxOverlayStringLen",30,"Maximum length in characters for the sample or variable metadata when included as an overlay. Anything above is truncated",c,"",k);this.xh("overlaysThickness",18,"Relative length in pixels for the thickness of the colored boxes to classify samples and or variables in one dimensional plots. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true",c,"",k);this.Kc("smpOverlays",[],"Sample metadata to overlay in one dimensional plots",c,"",k);this.Kv("smpOverlayProperties",{},"Object to assign properties of the sample overlays. The key should be a valid sample annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes",c,"",k);this.xh("smpOverlaysLegendColumns",1,"Number of columns for the sample overlay legends",c,"",k);this.lj("SmpOverlaysLegend",false,"sample overlay legends",c,"",k);this.Kc("varOverlays",[],"Variable metadata to overlay in heatmap plots",c,"",k);this.Kv("varOverlayProperties",{},"Object to assign properties of the variable overlays. The key should be a valid variable annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes",c,"",k);this.xh("varOverlaysLegendColumns",1,"Number of columns for the variable overlay legends",c,"",k);this.lj("VarOverlaysLegend",false,"sample overlay legends",c,"",k);this.Xt("overlaysLegend","topRight",["topRight","right","bottomLeft","bottom"],"the variable and sample overlays legend",c,"",k);this.lj(c,true,"overlays in one dimensional plots",c,"",k);this.lj("NameOverlays",true,"the overlays name",c,"",k);this.lj("ValueOverlays",true,"overlay values in one dimensional plots",c,"",k);this.OS("overlayText","",b,11,1,"center","middle",0,5,"overlays",c,"",k);this.hd("panelOverlayBackground",w,"rgba(204,204,204,1)",1,"solid","panel background",c,"",k);c="Legends";this.ss(c,"Legends for variables and samples","OverlayGraphs",true);this.JW("legendInside",false,"Flag to position the legend inside the graphs",c,"",k);this.xh("legendColumns",1,"Number of columns in legends",c,"Divide the legend in {_value_} columns",k);this.xh("legendRows",1,"Number of rows in legends",c,"Divide the legend in {_value_} rows",k);this.xh("legendMax",50,"Maximum number of items in the variable legends",c,"Set the maximum number of items in the legend to {_value_} ",k);this.JW("legendStyleGgplot",false,"Flag to use ggplot style for the size legends",c,"",k);this.Kv("legendOrder",false,"Object to specify custom order for the levels in the legends. The key of the object is the name of a valid sample or variable annotation included in the data object. The value for element is an array with the levels for the corresponding factor",c,"",k);this.JW("legendOrderByCols",true,"Flag to draw legends by columns in the graphs",c,"",k);this.Kc("customLegend",[],"Custom legends : Array of objects [{ size : [], shape : [], shapeColor : [], line : [], lineColor : [], lineStart : [], lineEnd : [], text : [], x : number, y : number, title : string }]",c,"",k);this.lj("Legend",true,"legend",c,"",k);this.lj("VariableLegend",true,"legend variable",c,"",k);this.lj("SampleLegend",true,"legend sample. Not implemented!!!!!",c,"",k);this.lj("ColorLegend",true,"legend color",c,"",k);this.lj("ShapeLegend",true,"legend shape",c,"",k);this.lj("SizeLegend",true,"legend size",c,"",k);this.lj("OutlineLegend",true,"legend outline",c,"",k);this.lj("PatternLegend",true,"legend pattern",c,"",k);this.lj("ConnectLegend",true,"legend connect",c,"",k);this.lj("LineLegend",true,"legend line",c,"",k);this.lj("ColorLabelLegend",true,"legend label color",c,"",k);this.lj("SizeLabelLegend",true,"legend label size",c,"",k);this.lj("ColorNodeLegend",true,"legend node color",c,"",k);this.lj("ShapeNodeLegend",true,"legend node shape",c,"",k);this.lj("SizeNodeLegend",true,"legend node size",c,"",k);this.lj("PatternNodeLegend",true,"legend node pattern",c,"",k);this.lj("ColorEdgeLegend",true,"legend edge color",c,"",k);this.lj("SizeEdgeLegend",true,"legend edge size",c,"",k);this.lj("LegendTitle",true,"the legend title",c,"",k);this.lj("LegendBorder",true,"the legend border",c,"",k);this.Xt("legend","right",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the legend",c,"",k);this.kK("legendHorizontalJustification",0.5,"Horizontal justification for legends when legend are in top or bottom positions",c,"",k);this.kK("legendVerticalJustification",0.5,"Vertical justification for legends when legend are in left or right positions",c,"",k);this.gl("legend","vertical","legend",c,"",k);this.hd("legendBackground",m,m,0.5,"solid","legend background",c,"",k);this.hd("legendKeyBackground",m,m,1,"solid","legend key background",c,"",k);this.xh("legendKeySize",15,"Width in pixels for the legend key",c,"",k);this.xh("legendKeyMargin",5,"Width in pixels for the legend key margin",c,"",k);this.OS("legendText","",b,11,1,"left","middle",0,8,"legends",c,"",k);this.OS("legendTitle","",b,11,1,"left","middle",0,8,"legends",c,"",k);c="Decorations";this.ss(c,"Additional elements added to graphs to increase data understanding","DecorationGraphs",true);this.xh("decorationsWidth",20,"Length in pixels of the width for the decorations in the networks",c,"",k);this.xh("decorationsHeight",40,"Length in pixels of the height for the decorations in the networks",c,"",k);this.oL("decorationsType","bar",["pie","bar","heatmap","stacked","stackedpercent"],"Type for the decorations in the networks. The types stacked and stackedpercent must be two dimensional. Heatmap could be one or two dimensional",c,"",k);this.Kv("decorations",false,"Name of the node properties to include in the network decorations in the data.nodes object",c,"",k);this.Kc("decorationsColors",[],"Array of colors used for selection in network decorations not to be confused by its singular form decorationsColor above",c,"",k);this.Kv("decorationsProperties",{},"Object to assign properties like color for the network decorations",c,"",k);this.JW("decorationsClipped",true,"Flag to clip decorations to the x,y area of the plot.",c,"",k);this.kK("decorationsTransparency",0.2,"Transparency for range decorations",c,"",k);this.lj(c,true,"decorations",c,"",k);this.lj("DecorationsLegend",true,"decoration legends",c,"",k);this.lj("DecorationsBorder",false,"the decoration legends border",c,"",k);this.Xt("decorations","bottom",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the decorations",c,"",k);this.hd("decorationsBackground",m,"rgb(204,204,204)",0.5,"solid","decoration legends background",c,"",k);this.OS("decorationsText","",b,11,1,"center","middle",0,5,"decoration legends",c,"",k);this.JW("decorationsOnTop",true,"Flag to draw decorations after drawing the data",c,"",k);this.JW("decorationsTransform",true,"Flag to transform the data in decorations produced in Cxplot",c,"",k);c="Data";this.ss(c,"Data related parameters","OneTwoThreeeDGraphs",true);this.JW("isGroupedData",false,"Flag to indicate if the data is grouped",c);this.JW("isBoxplotCalc",false,"Flag to indicate if the iqr has been calculated when the graph type is Boxplot",c);this.Kc("groupingFactors",[],"An array that holds the group names used for grouping the data. It must be a category in the data.x object",c,"Group data by {_value_}",k);this.oL("summaryType",false,[false,"iqr","median","mean","cor","min","max","count","sum"],"Summary type for the data when grouping",c,"",k);this.JW("transposeData",false,"Flag to transpose data as a parameter. This parameter accomplishes the same as the function transpose at load time",c,"",k);this.Kc("appendNetworkData",[],"Array containing additional data files to append to networks. Useful for loading KEGG and Wikipatways to decorate the nodes and the edges",c,"",k);this.OS("dataText","",false,11,1,"center","middle",0,5,"data labels",c,"",k);c="Data Context";this.ss(c,"Data context related parameters","OneTwoThreeeDGraphs",true);this.Kc("asSampleFactors",[],"Array containing variable names. Numeric variable data (in rows) to be treated as a sample factor (move from y to x object). This parameter accomplishes the same as the function switchVarToAnnotation at load time. It can be used in conjunction with the parameter stringSampleFactors to be treated as a string. TO DO: write example",c,"",k);this.Kc("asVariableFactors",[],"Array containing sample names. Numeric sample data (in columns) to be treated as a variable factor (move from y to z object). This parameter accomplishes the same as the function switchSmpToAnnotation at load time. It can be used in conjunction with the parameter stringVariableFactors to be treated as a string. TO DO: write example",c,"",k);this.Kc("stringSampleFactors",[],"Array containing sample factors. The numeric sample factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for samples at load time. It can be used in conjunction with the parameter asSampleFactors. TO DO: write example",c,"",k);this.Kc("stringVariableFactors",[],"Array containing variable factors. The numeric variable factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for variables at load time. It can be used in conjunction with the parameter asVariableFactors. TO DO: write example",c,"",k);this.Kc("stringNodeAttributes",[],"Array containing node attributes. The numeric node attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for nodes at load time",c,"",k);this.Kc("stringEdgeAttributes",[],"Array containing edge attributes. The numeric edge attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for edges at load time",c,"",k);c="Data Transformation";this.ss(c,"Data transformation related parameters","OneTwoThreeeDGraphs",true);this.JW("isTransformedData",false,"Flag to indicate the data is transformed",c);this.xh("transformBase",10,"Default log or exponential transformation for the data",c);this.oL("transformData",false,[false,"log2","log10","-log2","-log10","exp2","exp10","sqrt","percentile","zscore","ratio2","ratio10","save","reset","undo"],"Default transformation type for ALL the data. Data can also be transformed by axis (x,y,z) to give more flexibility. false, save, reset and undo are NOT real transformations. They are only used in the canvasXpress UIs to save the transformed data",c,"",k);this.oL("transformAxis","samples",["samples","variables"],"Default axis to use to transform the data when either z-score or ratio transformation is used",c,"",k);c="Data Ratio Reference";this.ss(c,"Data ratio related parameters","OneTwoThreeeDGraphs",true);this.xh("ratioReference",0,"Default index of sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs",c,"",k);this.oL("ratioSampleReference",false,[false],"Name of the sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs",c,"",k);this.oL("ratioGroupReference",false,[false],"Name of the group used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs",c,"",k);this.oL("ratioLevelReference","",[],"Name of the level used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs",c,"",k);c="Data Faceting";this.ss(c,"Data faceting related parameters","AllGraphs",true);this.Kc("segregateSamplesBy",[],"An array that holds the annotation(s) used to segregate the samples ala Facet way in R. It must be categories in the data.x object",c,"Segregate samples by {_value_}",k);this.Kc("segregateVariablesBy",[],"An array that holds the annotation(s) used to segregate the variables ala Facet way in R. It must be categories in the data.z object",c,"Segregate variables by {_value_}",k);this.ck("splitSamplesBy",false,"Factor (in the x data object) used to split the samples ala split in complex heatmap",c,"Split samples by {_value_}",k);this.ck("splitVariablesBy",false,"Factor (in the z data object) used to separate the variables ala split in complex heatmap",c,"Split variables by {_value_}",k);this.xh("splitSeparation",10,"Length in pixels to separate the splits in samples and variables",c,"",k);c="Data Time Series";this.ss(c,"Time series related parameters","OneTwoThreeeDGraphs",true);this.oL("timeFormat","isoDate",["default","shortDate","mediumDate","longDate","fullDate","shortTime","mediumTime","longTime","isoDate","isoTime","isoDateTime","isoUtcDateTime","year","month","day","hour","minute","second"],"Time Format according to date.format.js Steven Levithan <stevenlevithan.com>",c,"",k);this.JW("isGraphTime",false,"Flag to indicate if the data is a time series so there is no need to plot every time interval. It is boolean in one dimensional plots or a string indicating the axis which is timed x, y or z",c,"",k);this.Kc("timeValues",[],"Array containing the tick values when the the graph is a time series","Time Series");this.Kc("timeValueIndices",[],"Array containing the indices of the values when the the graph is a time series","Time Series");this.Kv("timeValueProperties",{},"Object with all the time properties needed to plot the data","Time Series");c="Data Sorting";this.ss(c,"Data sorting related parameters","OneTwoThreeeDGraphs",true);this.oL("sortDir","ascending",["ascending","descending"],"Default direction for data sorting. Almost private parameters used within the different CanvasXpress UIs",c,"",k);this.JW("sortCaseSensitive",false,"Flag to use case sensitive in ascii sorting. Almost private parameters used within the different CanvasXpress UIs",c,"",k);this.Kc("sortData",[],"Array of arrays with sorting functions. Each function takes three parameters. The first parameter must be either smp to identify the parameters are related to the samples, var to identify the parameters are related to the variables, or cat to identify a sample or variable category. The second parameter can be either smp to indicate to sort the sample indices or var to indicate to sort the variable indices. The third parameter is the value for the key referenced by the first parameter. A special case for this parameter could be samples or variables to indicate to sort by the names of the samples or variables respectively. Here are some examples to sort the samples in the data: [ [cat, smp, Factor1] ]   : Sort the samples by the sample category Factor1 [ [var, smp, Variable1] ] : Sort the samples by the value of the Variable1 [ [cat, smp, samples] ]   : Sort the samples by their name.  Important!!!! This parameter will clean the data and remove any variables not used in the dataset at load time",c,"",k);this.oL("sortOnGrouping",false,[false,"ascending","descending"],"Sort the name of the groups after sample grouping.<br>",c,"",k);this.JW("sortIncludeEmpty",true,"Flag to include empty groups when sorting",c,"",k);c="Missing Data";this.ss(c,"Missing data related parameters","OneTwoThreeeDGraphs",true);this.rW("missingData","rgb(245,245,245)","missing data",c,"",k);this.ck("missingDataValue","NA","String value use to specify missing data",c,"",k);this.JW("nanOmit",false,"Flag to omit NaN values in log transformation",c,"",k);c="Error Bars";this.ss(c,"Error bar and confidence intervals related parameters","OneTwoThreeeDGraphs",true);this.lj("ErrorBars",true,"error bars in graphs",c,"",k);this.oL("errorBarsType","confidenceInterval95",["standardDeviation","standardErrorMean","confidenceInterval95"],"Type of error bars",c,"",k);this.rW("errorBars",b,"error bars in dotplots and barplots",c,"",k);this.kK("errorBarsThickness",3,"Thickness for the error bars in dotplots",c,"",k);this.xh("errorBarsWidth",2,"Minimum size of the bar in pixels to determine to show or hide error bar ends in the graphs when available",c,"",k);this.oL("standardDeviationType","unbiased",["biased","unbiased"],"Type of Standard Deviation. biased uses n as denominator and unbiased uses (n - 1) as denominator where n is the number of values",c,"",k);c="Random";this.ss(c,"Properties used to generate random data sets","AllGraphs",false);this.xh("randomSeed",8,"Specifies the random seed number to create pseudo random numbers",c,"",k);this.JW("pseudoRandom",true,"Flag to indicate to use pseudo random rather than random",c,"",k);this.oL("randomMethod","numericalRecipes",["jenkins","numericalRecipes"],"Random method",c,"",k);c="Ranges";this.ss(c,"General parameters use in graphs that utilize ranges","RangeGraphs",true);this.Kc("rangeColors",[],"Colors for the background ranges in bullet and meter graphs",c,"",k);this.kK("rangeColorTransparency",0.6,"Transparency to apply to the range colors in bullet graphs",c,"",k);this.oi("rangeStack",false,"labels for the background ranges in bullet graphs",c,"",k);this.Kc("rangeStack",[],"Variable names to define the background ranges in bullet graphs. If left empty, the entire graph area will be used",c,"",k);this.Kc("rangeSegments",[],"Top value for a particular range segments",c,"",k);c="X-Axis";this.ss(c,"X axis parameters","OneTwoThreeeDGraphs",true);this.ms("x","X axis",c,"",k);c="Y-Axis";this.ss(c,"Y axes parameters","TwoThreeeDGraphs",true);this.ms("y","Y axis",c,"",k);c="Z-Axis";this.ss(c,"Z axes parameters","ThreeDGraphs",true);this.ms("z","Z axis",c,"",k);c="R-Axis";this.ss(c,"R axis parameters","Circular",true);this.JW("rAxisPercentShow",false,"Flag to show on not the percent in each segment in the R axis",c,"",k);this.oL("rAxisLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the ticks values in circular plots",c,"",k);this.ck("rAxis",false,"Radial axis for circular plots. It must be the name of a variable. Only applicable to 2 Dimensional circular plots",c,"",k);this.JW("rAxisZero",false,"Flag to force the rAxis property to start from zero otherwise it starts from the minimum value",c,"",k);this.ms("r","R axis",c,"",k);c="Axis";this.ss(c,"General axis parameters","OneTwoThreeeDGraphs",true);this.kK("axisExtension",0.1,"Percentage to extend the values of the data to ensure all the data points are plotted inside and not over the edges of the graph",c,"",k);this.oL("axisAlgorithm","rPretty",["heckbert","wilkinson","wilkinsonExtended","rPretty"],"Algorithm used to position tick labels on axes. See An Extension of Wilkinson Algorithm for Positioning Tick Labels on Axes. Justin Talbot, Sharon Lin, Pat Hanrahan",c,"",k);this.JW("axisWilkinsonLoose",false,"Flag to indicate whether to use loose positioning when using the wilkinson algorithm to position the labels on the axis. There will not be a difference most of the times",c,"",k);this.JW("axisCoordinate",false,"Flag to coordinate xAxis and xAxis2 in *-Line combination plots",c,"",k);this.kK("setMax",null,"Maximum value to set the data",c);this.kK("setMin",null,"Minimum value to set the data",c);c="Plot Area";this.ss(c,"General parameters for the plotting area in one dimensional plots","OneDGraphs",true);this.S4("guides","rgb(204,204,204)",1,1,5,"solid",false,"the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics",c,"",k);this.oL("guideStyle","line",["line","track"],"Style for the guides",c,"",k);this.JW("blockContrast",false,"Flag to creates a shade between the samples so there are two backgrounds, one for the odd samples and one for the even samples",c,"",k);this.JW("plotByVariable",false,"Flag to indicate whether to group the data variable rather than by sample",c,"",k);this.JW("is3DPlot",false,"Flag to create or not a 3D plot",c,"",k);this.lj("DataValues",false,"data values in the bar graphs, stacked graphs, dotplots and line graphs",c,"",k);this.oL("dataValuesFrequency","ends",["all","first","last","ends"],"Frequency for the data values in line graphs",c,"",k);this.oL("dataValuesPosition","outside",["inside","outside"],"Position for the data values in line graphs",c,"",k);this.JW("binned",false,"Flag to bin the data points in dotplots and boxplots",c,"",k);this.oL("binAlignment","center",["left","center","right"],"Alignment for the data points when binned",c,"",k);this.JW("jitter",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots",c,"",k);this.kK("jitterFactor",0.8,"Factor for jittering. The larger the more jitter",c,"",k);this.JW("sina",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots with sina style",c,"",k);this.rW("objectBorder",n,"border of all objects in one dimensional graphs. It turns into the non-transparent fill color if set to false",c,"",k);this.kK("objectColorTransparency",1,"The transparency for the color fill of all objects in one dimensional graphs. A value between 0 and 1",c,"",k);this.xh("dotplotOutlineThreshold",5000,"Maximum number of data points before skipping plotting their outline but only the fill color",c,"",k);this.JW("linesOnGroups",true,"Flag to create lines on groups when multiple grouping factors are used",c,"",k);c="Hierarchy";this.ss(c,"General parameters to build hierarchy for circular (sunburst) trees and bubbles graphs","HierarchicalGraphs",true);this.Kc("hierarchy",[],"Hierarchy for trees and bubble graphs made up of sample annotations present the data x object",c,"",k);c="Data Point Attributes";this.ss(c,"General attributes for data points in scatter and one dimensional plots","OneTwoThreeeDGraphs",true);this.oL("colorBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to color the variables",c,"",k,"getXZData");this.Kv("colorKey",false,"Object to assign custom colors to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object, or the name of an annotation in the data.z object. The value for each key could be either: (1) a scalar with a valid color scheme (see this.meta.def.colorSchemes), or (2) an array with valid colors, or (3) an object to specify custom colors for each of the values of the annotation. A default color will be assigned to a data point whose value was not included the object. CanvasXpress will handle string and numeric annotation approprietly. However, if an object is specified like that one in number (3) the annotation will be treated as categorical even if the annotation is numeric",c,"",k);this.ck("colorByData",false,"String that identify the object containing a two dimensional array with discrete values used to color data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)",c,"",k);this.ck("colorLegendTitle",false,"Title for the color legend",c,"",k);this.oL("shapeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to shape the variables. When shapeByData is specified shapeBy is used for the title in the legend",c,"",k,"getXZData");this.JW("shapeByContinuous",false,"Flag to use pie shapes with continuous data as opposed to by binning the data and show regular shapes",c,"",k);this.Kv("shapeKey",false,"Object to assign custom shapes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default shape will be assigned to a data point whose value was not included the object",c,"",k);this.ck("shapeByData",false,"String that identify the object containing a two dimensional array with values used to shape data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)",c,"",k);this.oL("shapeByShape",false,[false,"sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","mdavid"],"String that identify the shape to use in regular and multidimensional heatmaps. shapeByData will take precedence over this property",c,"",k);this.ck("shapeLegendTitle",false,"Title for the shape legend",c,"",k);this.oL("sizeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to size the variables. When sizeByData is specified sizeBy is used for the title in the legend",c,"",k,"getXZData");this.JW("sizeByContinuous",false,"Flag to show the size data continuously as opposed to by binning the sizes",c,"",k);this.Kv("sizeKey",false,"Object to assign custom sizes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default size will be assigned to a data point whose value was not included the object",c,"",k);this.ck("sizeByData",false,"String that identify the object containing a two dimensional array with values used to size data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data3)",c,"",k);this.ck("sizeLegendTitle",false,"Title for the size legend",c,"",k);this.ck("outlineBy",false,"Name of the annotation for the outline when drawing a multidimensional Heatmap",c,"",k,"getXZData");this.ck("outlineByData",false,"String that identify the object containing a two dimensional array with values used to color the outline data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)",c,"",k);this.oL("patternBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to pattern the variables. When patternByData is specified patternBy is used for the title in the legend",c,"",k,"getXZData");this.Kv("patternKey",false,"Object to assign custom patterns to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default pattern will be assigned to a data point whose value was not included the object",c,"",k);this.ck("patternByData",false,"String that identify the object containing a two dimensional array with values used to pattern the data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)",c,"",k);this.oL("connectBy",false,[false],"Name of a variable annotation to connect the variables",c,"",k,"getXZData");this.JW("connectByNoColor",false,"Flag to prevent coloring the lines by the connectBy annotation. Usefull when connectBy is used along with colorBy to avoid confusion of colors",c,"",k);this.rW("connectBy","rgb(204,204,204)","connectBy lines",c,"",k);this.xh("connectByWidth",2,"Width for the line of the connectBy line",c,"",k);this.Kv("connectKey",false,"Object to assign custom colors to lines when samples are connected by a sample annotations included in the data object. The key of the object is the name of an annotation in the data.x object. A default connect will be assigned to a data point whose value was not included the object",c,"",k);this.Kv("connectByData",{},"Internal object with connectBy data",c);this.Kc("treemapBy",[],"Array of sample annotations to treemap the variables. The array may also include sample to use as last level",c,"",k,"getXZData");this.oL("stackBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Bar graphs",c,"",k,"getZData");this.oL("dodgeBy",false,[false],"Name of a sample annotation to dodge the samples of each variable in Bar graphs",c,"",k,"getXData");this.oL("lineBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Line graphs",c,"",k,"getXData");this.oL("ribbonBy",false,[false],"Name of a sample annotation(s) to create a ribbon of each variable in scatter plots. If a single annotation is passed then it will be used as a standard deviation. If two annotations are passed then, it will be used as upper and lower confidence intervals. Alternatively it could be a pair of arrays witht the actual data. Works in coordination with the lineBy parameter",c,"",k);this.oL("ribbonByType","line",["line","area"],"Type of ribbon to create",c,"",k);this.oL("motionBy",false,[false,"variable"],"Utility to create dynamic filtering of data in Scatter plots",c,"",k);this.oL("markerBy",false,[false,"variable"],"Utility to create dynamic markers in Map. It must have a latitude and longitude metadata too",c,"",k);this.oL("ellipseBy",false,[false,"variable"],"Utility to create error ellipses in Scatter plots",c,"",k,"getZData");this.oL("confidenceBy",false,[false,"variable"],"Name of a variable annotation to color the confidence intervals",c,"",k,"getZData");this.oL("ridgeBy",false,[false],"Utility to create ridgelines in Scatter2D plots",c,"",k);this.oL("pieBy",false,[false],"Utility to create pie with a sample annotation",c,"",k);this.oL("pivotBy",false,[false],"Utility to pivot data with a sample annotation",c,"",k);this.oL("colorLabelBy",false,[false],"Name of the variable annotation to color the labels in Scatter2D plots",c,"",k,"getZData");this.oL("sizeLabelBy",false,[false],"Name of the variable annotation to size the labels in Scatter2D plots",c,"",k,"getZData");c="Fit Lines";this.ss(c,"Parameters used to create regression, loess and quantiles lines in 2d scatter plots","Scatter2D",true);this.S4("fitLine","#fed385",1,2,null,"solid",true,"fit line",c,"",k);c="Confidence Intervals";this.ss(c,"Parameters used to create regression, loess and quantiles confidence intervals in 2d scatter plots","Scatter2D",true);this.rW("confidenceInterval","rgb(50,50,50)","confidence intervals",c,"",k);this.lj("ConfidenceIntervals",true,"confidence intervals in the regression plots ",c,"",k);this.kK("confidenceLevel",0.95,"Confidence level for regressions and ellipses",c,"",k);this.JW("confidenceIntervalColorCoordinate",false,"Flag to color coordinate the confidence intervals and line fit",c,"",k);c="Regression";this.ss(c,"Parameters used to create regression lines in 2d scatter plots","Scatter2D",true);this.lj("RegressionFit",false,"Flag to show the regression fit",c,"",k);this.lj("RegressionFitEquation",true,"Flag to show the regression fit equation",c,"",k);this.oL("regressionFitEquationPosition","top",["top","bottom"],"Position for the regression fit equation",c,"",k);this.lj("RegressionFullRange",false,"full range in regression plots",c,"",k);this.oL("regressionType","linear",["linear","exponential","logarithmic","power","polynomial"],"Type of linear least-squares fitting methods for simple data analysis",c,"",k);this.xh("regressionOrder",2,"Specifies the number of degrees to solve for in polynomial regressions",c,"",k);c="Loess";this.ss(c,"Parameters used to create smooth lines in 2d scatter plots","Scatter2D",true);this.lj("LoessFit",false,"Flag to show the loess fit in Scatter plots",c,"",k);this.oL("loessDegree",2,[0,1,2],"Loess degree. 0 : Constant, 1 : Linear, 2 : Quadratic",c,"",k);this.xh("loessSteps",30,"Loess steps. Number of steps to smooth the line",c,"",k);this.kK("loessBandwidth",0.8,"Loess bandwidth. Thickness for the confidence of the loess curve. A vaulue between 0 and 1",c,"",k);this.kK("loessCell",0.2,"Loess cell. If interpolation is used this controls the accuracy of the approximation via the maximum number of points in a cell in the kd tree. Cells with more than floor(n*span*cell) points are subdivided",c,"",k);this.kK("loessSpan",0.75,"Loess span. Factor to adjust the gaussian shape of the loess curve. A vaulue between 0 and 1",c,"",k);this.xh("loessIteration",4,"Loess iterations",c);this.JW("loessNormalize",true,"Flag to normalize loess fit in Scatter2D plots",c,"",k);this.oL("loessFamily","gaussian",["gaussian","symmetric"],"Loess Family. Type of error distribution to be optimized in fitting. The default, gaussian, is fitting with least squares. Fitting with Tukeys biweight M-Estimator is used if family is symmetric",c,"",k);this.oL("loessSurface","interpolate",["direct","interpolate"],"Loess Surface. The fitted surface to be computed exactly (direct) or via interpolation from a kd tree",c,"",k);this.oL("loessStatistics","approximate",["approximate","exact"],"LoessStatistics. The statistics to be computed exactly, approximately or not at all? Exact computation can be very slow ",c,"",k);c="DOE";this.ss(c,"Parameters used to create graphs with meta data","AllGraphs",false);this.xh("maxDOENumber",8,"Maximum number of graphs when creating a DOE",c,"",k);this.Kc("includeDOE",[],"Array containing the factors to include when exploring the DOE. If left empty all the factors will be included",c,"",k);this.JW("autoexpandDOE",true,"Flag to expand verticaly the extent of the meta data-plots when changing the size of the graphs",c,"",k);this.JW("extendedDOE",true,"Flag to extend DOE to include variables / samples",c,"",k);this.Kv("asDOE",false,"Object with configurations to create DOE",c,"",k);c="3D Attributes";this.ss(c,"General parameters in 3d scatter plots and networks","Scatter3DGraphs",true);this.kK("xRotate",45,"Starting number of degrees to rotate graph arround the X axis",c,"",k);this.kK("yRotate",0,"Starting number of degrees to rotate graph arround the Y axis",c,"",k);this.kK("zRotate",0,"Starting number of degrees to rotate graph arround the Z axis",c,"",k);this.kK("x3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the X Axis",c,"",k);this.kK("y3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Y Axis",c,"",k);this.kK("z3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Z Axis",c,"",k);this.lj("3DGrid",true,"X,Y,Z grid in 3D plots",c,"",k);this.xh("rotationSensitivity",450,"Factor to adjust the sensitivity of the mouse when rotating the graph",c,"",k);this.xh("rotationStep",2,"Number of degrees used when the plot is automatically rotated",c);this.kK("perspectiveFactor",2.2,"Factor to use to make the 3D perspective. The higher the number the more perspective. Perspective of zero is no perspective at all",c,"",k);this.rW("outline3D",b,"outline of the 3D Scatters",c,"",k);c="Dendrograms";this.ss(c,"General parameters in dendrograms","ClusterGraphs",true);this.z7("Var",true,false,"top",false,"variable (column) dendrogram",c,"",k);this.z7("Smp",true,false,"left",false,"sample (row) dendrogram",c,"",k);this.xh("dendrogramHeight",80,"Size in pixels for the dendrogram",c,"",k);this.rW("dendrogram",b,"dendrograms",c,"",k);c="Clustering";this.ss(c,"Parameters used in clustering","ClusterGraphs",true);this.oL("clusteringDistance","euclidianDistance",["euclidianDistance","manhattanDistance","maxDistance"],"Distance metric to use when clustering data",c,"",k);this.oL("linkage","complete",["single","complete","average"],"Linkage type to use when clustering data",c,"",k);this.oL("clusterAxis","samples",["samples","variables"],"Axis to use when clustering data",c,"",k);this.xh("kmeansVarClusters",3,"Number of clusters when clustering variable data with kmeans",c,"",k);this.xh("kmeansSmpClusters",3,"Number of clusters when clustering sample data with kmeans",c,"",k);this.xh("maxIterations",500,"Number of maximum iterations when clustering data with kmeans for one dimensional graphs or maximum number of iterations when calculating force direct layout networks",c,"",k);this.oL("imputeMethod","mean",["mean","median"],"Imputation method for missing data when clustering",c,"",k);this.JW("samplesClustered",false,"Flag to cluster samples",c,"",k);this.JW("variablesClustered",false,"Flag to cluster variables",c,"",k);this.JW("samplesKmeaned",false,"Flag to k-mean samples",c,"",k);this.JW("variablesKmeaned",false,"Flag to k-mean variables",c,"",k);c="Ideograms";this.ss(c,"General parameters for Ideograms","IdeogramGraphs",true);this.lj("Ideogram",false,"Human Chromosome Ideogram. Force circular plots to be two dimensional",c,"",k);this.oL("ideogram","hg38",["hg38"],'Ideogram. Additional ideograms can be loaded by appending to the CanvasXpress.chromosomes object. The format of the ideogram is based on the R data for USCS.hg19.chr<br> CanvasXpress.chromosomes = {<br> &nbsp;&nbsp;hg19 : {<br> &nbsp;&nbsp;&nbsp;&nbsp;order : [ 1, 2, 3, 4, 5, 6, 7, 8, ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;data : {<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1 : [ [ 0, 2300000, "p36.33", "gneg" ], ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2 : [ [ 0, 4300000, "p25.3", "gneg" ],  ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;}<br> &nbsp;&nbsp;}<br> }',c,"",k);this.ck("ideogramChromosomeNumber","1","Chromosome number",c,"",k);this.JW("ideogramShowFullChromosome",true,"Flag to show the full chromosome",c,"",k);this.OS("ideogramSegment","",b,10,1,"center","middle",0,8,"ideogram segment",c,"",k);this.xh("ideogramHeight",20,"Default size in pixels of the ideogram height",c,"",k);this.ck("ideogramChromosome","chr","Factor name included in the data.z object used to map to the chromosome number",c,"",k);this.ck("ideogramChromosomePosition","pos","Factor name included in the data.z object used to map to the chromosome position",c,"",k);c="Combination Plots";this.ss(c,"Parameters used in complex plots","AllGraphs",true);this.kK("weight",1,"Fraction of the canvas to be used (a value between 0 and 1). Used when multiple graphs are displayed in one canvas. Could be an number or an array of numbers",c);this.kK("scaleX",1,"Scale factor for the X axis",c);this.kK("scaleY",1,"Scale factor for the Y axis",c);this.kK("translateX",0,"Amount to translate for the X axis",c);this.kK("translateY",0,"Amount to translate for the Y axis",c);this.kK("offsetX",0,"Additional amount to move for the X axis",c);this.kK("offsetY",0,"Additional amount to move for the Y axis",c);this.kK("layoutWidth",0,"Width of the current segment of the canvas when there are multiple graphs",c);this.kK("layoutHeight",0,"Height of the current segment of the canvas when there are multiple graphs",c);this.xh("layoutCurrent",0,"Integer to identify the current graph being displayed in the canvas",c);this.ck("layout","1X1","Topology of the canvas. Number of rows and columns",c);this.JW("layoutComb",false,"Flag that identify that multiple graphs will be displayed in the canvas. This is the case when ata is segregated, splom, multiple pies or DOE visualizations",c);this.ck("layoutTopology",false,"Topology of the canvas. Number of columns and rows separated by X. For example: 2X1, 1X3, etc",c,"",k);this.JW("layoutAdjust",false,"Flag to force recalculating the ranges in the axes when multiple graphs are displayed in the canvas",c,"",k);this.JW("layoutGlobalGroups",false,"Flag to force same groups across all layout plots",c,"",k);this.JW("layoutCollapse",false,"Flag to make layout graphs without any space in between",c,"",k);this.xh("layoutSpacing",8,"Spacing between layout graphs",c,"",k);this.oL("layoutType","wrap",["wrap","rows","cols"],"Type of layout to place the position for the labels in the trellis plot. Identify the axis that will be used to place the first segregating factor. rows will use the first segregating factor in the rows and the second in the columns. cols will use the first segregating factor in the columns and the second in the rows. wrap will wrap the segregating factors putting the sample factors in the columns",c,"",k);this.JW("layoutRemoveEmpty",true,"Flag to remove empty combinations in segregated layouts",c,"",k);this.JW("layoutCanvasCompartments",false,"Flag to draw lines around each graph in the layout in the canvas. Used only when debugging",c,"",k);this.Kc("layoutConfig",[],"Array of object to assign visualization configurations to each layout",c,"",k);c="Combination Plot Strips";this.ss(c,"Parameters used in strips complex plots","AllGraphs",true);this.hd("stripBackground",m,n,1,"solid","layout label strip background",c,"",k);this.OS("stripText","",b,11,1,"center","middle",0,5,"label strip text in layout graphs",c,"",k);this.oi("strip",true,"the layout label strip",c,"",k);this.kK("stripThickness",30,"Thickness of the layout label strip",c,"",k);this.xh("stripTextLines",1,"Lines for the layout label strip",c,"",k);this.xh("stripTextMaxLength",100,"Maximum length for the layout label strip. If longer, text will be ellipsed",c,"",k);c="Images";this.ss(c,"General parameters with images","AllGraphs",false);this.xh("imageTimeOut",1000,"Time in milliseconds to wait to load images",c,"",k);this.xh("imageMaxTries",10,"Maximum times to try to load images. Used to calculate the timeout which will be imageTimeOut / imageTries which will be 100ms by default",c,"",k);this.xh("imageTries",0,"Image try counter",c);c="Area Graphs";this.ss(c,"General parameters in area graphs","AreaGraphs",true);this.oL("areaType","overlapping",["overlapping","stacked","percent"],"Types of area graphs when displaying multiple series. The options include overlapping which is the default, stacked, and percent area graphs",c,"",k);c="Bar Graphs";this.ss(c,"General parameters in bar graphs","BarGraphs",true);this.oL("barType","normal",["normal","lollipop","arrow","bullet","lollipopBullet","swimmer","waterfall"],"Flag to produce normal or other modifications of bar graphs",c,"",k);this.JW("barZero",true,"Flag to force zero in bar graphs with positive values",c,"",k);c="Bin Plots";this.ss(c,"Parameters used to create bin plots in 2d scatter plots","BinHexPlots",true);this.Kc("binplotBins",[],"Approximate number of bins in a bin plot. It may vary considerably to the actual number used in the bin plot to ensure a pretty size for the intervals in the bin plot. ggplots default is 30",c,"",k);this.Kc("binplotBinWidth",[],"Width in actual units for the histogram bin",c,"",k);this.JW("binplotDrop",true,"Flag to drop cells with zero counts in binplots",c,"",k);this.oL("binplotShape","hexagon",["rectangle","hexagon","oval"],"Type for the shape to use in binplots",c,"",k);this.oL("binplotColorScheme","BluesDark",Object.keys(CanvasXpress.colorSchemes).sort(),"Color scheme to use in binplots",c,"",k);c="Boxplot Graphs";this.ss(c,"General parameters in Boxplot Graphs","Boxplot",true);this.xh("boxplotOutliersRatio",10,"Ratio for the size of the outliers with respect to boxplot",c,"",k);this.rW("boxplotOutliers",false,"outlier data points in boxplots",c,"",k);this.rW("boxplotOutliersBorder",false,"border of outlier data points in boxplots",c,"",k);this.oL("boxplotOutliersShape","circle",["circle","square","triangle","diamond","plus","minus","star","circleOpen","squareOpen","triangleOpen","diamondOpen"],"Shape for the outlier data points",c,"",k);this.oL("boxplotWhiskersType","double",["single","double","none"],"Boxplot whiskers type",c,"",k);this.oL("boxplotType","boxWhiskers",["boxWhiskers","range"],"Boxplot type",c,"",k);this.JW("boxplotNotched",false,"Flag to notch boxplots",c,"",k);this.kK("boxplotTransparency",0.4,"Fraction to adjust color transparency for the boxplot id individual data points are shown",c,"",k);this.rW("boxplot",false,"boxplot if individual data points are shown",c,"",k);this.JW("boxplotVarWidth",false,"Flag to adjust the width of boxplots. Similar to R if true then the width is proportional to the sqare root of the number of observations",c,"",k);this.kK("boxplotCoef",1.5,"Number that determines how far the plot whiskers extend out from the box",c,"",k);this.oL("boxplotHingeFunction","summary",["summary","fivenum"],"Function to calculate the boxplor hinges. See https://chemicalstatistician.wordpress.com/2013/08/12/exploratory-data-analysis-the-5-number-summary-two-different-methods-in-r-2/",c,"",k);this.lj("BoxplotOriginalData",false,"observed data point in boxplots. (Should be called showBoxplotDataPoints)",c,"",k);this.rW("boxplotOriginalData",false,"data points in the boxplots",c,"",k);this.kK("boxplotDataPointTransparency",0.8,"Fraction to adjust color transparency for the data points when displaying original data in boxplots",c,"",k);this.rW("boxplotBorder",b,"line of the borders in boxplots",c,"",k);this.rW("boxplotMedian",false,"line of the median of data in boxplots",c,"",k);this.xh("boxplotMedianWidth",2,"Width for the line of the median of data in boxplots",c,"",k);this.JW("boxplotMean",false,"Flag to show mean of data in boxplots",c,"",k);this.rW("boxplotMean","#fed385","data mean in boxplots",c,"",k);this.rW("boxplotMeanBorder","#fe6969","border of the data mean in boxplots",c,"",k);this.JW("boxplotConnect",false,"Flag to show data in boxplots connected",c,"",k);this.xh("boxplotConnectWidth",2,"Width for the line of the connection of boxes in boxplots",c,"",k);c="Bubble Graphs";this.ss(c,"General parameters in circular bubble graphs","Bubble",true);this.rW("bubble","rgba(204,204,204,0.33)","Bubbles. Only applicable to the bubble subtype",c,"",k);this.rW("bubbleOutline",b,"Outline of bubbles. Only applicable to the bubble subtype",c,"",k);this.oL("bubbleLabel","auto",["first","last","all","auto","none"],"Position for the labels in bubble circular plot",c,"",k);this.oL("bubbleLabelPosition","center",["top","center","bottom"],"Position for the labels in bubble circular plot",c,"",k);this.oL("bubbleLabelLineType","arch",["line","arch"],"Line type when label is away from the bubble",c,"",k);c="Bullet Graphs";this.ss(c,"General parameters in bullet graphs","Bullet",true);this.kK("bulletWidthRatio",0.5,"A number between 0.1 and 1 to adjust the width of the bullet",c,"",k);this.oL("bulletStyle","square",["square","round","squareGradient","roundGradient"],"Style for the bullet",c,"",k);this.oL("bulletTargetVarName",false,[false],"Variable name to use to identify target in bullet graphs",c,"",k);this.kK("bulletTargetWidthRatio",0.7,"A number between 0.1 and 1 to adjust the width of the bullet target line",c,"",k);this.rW("bulletTargetVar",b,"bullet target line",c,"",k);this.oL("bulletTargetType","line",["line","circle","openCircle","star","openStar"],"Shape for the target of the bullet",c,"",k);this.kK("bulletTargetLineWidth",3,"Width for the target line in bullet graphs when the bulletTargetLine is a line",c,"",k);c="Chord Graphs";this.ss(c,"General parameters in circular chord graphs","Chord",true);this.xh("chordThickness",28,"Relative length in pixels of the chord thickness in the circular graphs. Only applicable to the chord subtype",c,"",k);this.oL("chordColor","largest",["source","target","largest","smallest"],"Color the ribbon according to either the source or the target of the connection",c,"",k);this.oi("chordScale",true,"the scale in the chord graphs",c,"",k);c="Circular Graphs";this.ss(c,"General parameters in circular graphs","Circular",true);this.oL("circularType","normal",["normal","radar","sunburst","chord","bubble"],"Property to set the subtype of circular graph. If set to sunburst or bubble then smpOverlays can be used to build a hierarchy for the graph",c,"",k);this.kK("circularCenterProportion",0.3,"Proportion of the center of the circular graph to use as void; that is the fraction of the radius in the middle of the graph",c,"",k);this.xh("circularRotate",0,"Number of degrees to rotate the circular graph to adjust the starting point",c,"",k);this.xh("circularArc",360,"Number of degrees to extend the circular graph",c,"",k);this.kK("circularLetterSeparationFactor",1.5,"Factor to adjust the spacing between letters in the circular graphs. The greater the number the closer the letters in the labels",c,"",k);this.oL("circularOverlayLevelOrientation","circular",["perpendicular","circular"],"Orientation to show the segregation levels",c,"",k);this.oL("circularSampleLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the sample names",c,"",k);this.oL("circularLabelsAlign","outside",["inside","outside"],"Position to align the variable and sample names in circular plot",c,"",k);this.oL("circularScalesAlign","inside",["inside","outside"],"Position to align the percent and radial axes in circular plot",c,"",k);this.oL("circularAnchorsAlign","inside",["inside","outside"],"Position to align the anchors in circular plot",c,"",k);this.oL("circularAnchors2Align","outside",["inside","outside"],"Position to align the anchors2 in circular plot",c,"",k);this.oL("circularDataPosition","distributed",["absolute","distributed"],"Position to align the data in 2D radial graphs and ideograms",c,"",k);this.xh("circularAnchorLength",15,"Length in pixels of the height of the circular anchor",c,"",k);this.rW("circularAnchor","#0ab0db","circular anchor",c,"",k);c="Circular Graph Connections";this.ss(c,"General parameters for connections in circular graphs","Circular",true);this.lj("CircularConnections",true,"connections in circular graphs",c,"",k);this.Kc("connections",[],"Array to store connections in circular graphs",c,"",k);this.kK("circularConnectionsTransparency",0.5,"Percentage of transparency applied to the connections in the circular graphs",c,"",k);c="Circular Graph Arc Segments";this.ss(c,"General parameters for arc segments in circular graphs","Circular",true);this.xh("arcSegmentsSeparation",8,"Number of degrees to separate the arc segments in the circular plots. The arc segments can be set with the segregateSampleBy property",c,"",k);this.Kc("arcSegmentsRadius",[],"Array containing the proportion of the radius for each arc segment in the circular plot. If not specified then all radius will be the same. The plot will be scaled based of the largest value in the array",c,"",k);c="Circular Graph Rings";this.ss(c,"General parameters for rings in circular graphs","Circular",true);this.xh("ringSeparation",5,"Number of pixels to separate the rings in the circular plots",c,"",k);this.Kc("ringTracks",[],"An array specifying the names of each track in the circular plot. It must match the length of the *vars* array used for the data. Use an empty string to exclude a variable from the plot",c,"",k);this.Kc("ringGraphType",[],"Array containing the graph type for each ring in the circular plot",c,"",k);this.Kc("ringGraphWeight",[],"Array containing the proportion of the dimensions for each data ring in the circular plot. It must be a value between 0.1 and 1. If not specified then all ring will be weighted the same",c,"",k);this.Kc("ringOrder",[],"Array containing the order of the rings. The array includes the levels of the factor specified as either segregateSamplesBy when show the ideogram or segregateVariablesBy when there is no ideogram. It may also include any of the following terms: dendrogram, ideogram, labels, scale, percent and data. If there are sample overlays, the array may also contain any of the factor names include in the this.data.x object. This array supersede any other configurations for example for the sample overlays. CanvasXpress will honored all other configurations if left empty",c,"",k);c="Contours";this.ss(c,"Parameters used to create contours in one and two dimensional plots","ContourGraphs",true);this.JW("isContour",false,"Flag to show the contour",c,"",k);this.JW("contourFilled",false,"Flag to color the contour plot",c,"",k);this.kK("contourFilledTransparency",1,"Transparency applied to the filled contours",c,"",k);this.lj("ContourBands",true,"contour bands",c,"",k);this.rW("contourBands","#0ab0db","the bands in contours",c,"",k);this.xh("contourLevelWidth",null,"Width of contour levels",c,"",k);this.xh("contourLevelNumber",10,"Numbe of contour levels. Overridden by contourLevelWidth",c,"",k);this.oL("contourStat","density",["density","ndensity","count"],"Contour density type",c,"",k);this.oL("contourType","normal",["normal","raster","point"],"Contour type",c,"",k);this.Kc("contourLevels",[],"Numeric vector to set the contour levels. It is automatically calculated if not defined using the axisAlgorithm setting and the contourLevelNumber",c,"",k);this.lj("ContourLevel",false,"levels in contours",c,"",k);this.lj("ContourDataPoints",false,"data points in contours",c,"",k);this.rW("contourDataPoints",b,"data points in contours when the contour is filled",c,"",k);this.oL("contourColorScheme","Viridis",Object.keys(CanvasXpress.colorSchemes).sort(),"Color scheme to use in contours",c,"",k);c="Correlation Graphs";this.ss(c,"General parameters for correlation","Correlation",true);this.oL("correlationAxis","samples",["samples","variables"],"Axis used for the correlation",c,"",k);this.JW("correlationAnchorLegend",false,"Flag to show a region above the correlation plot that anchror a sample/variable to a position",c,"",k);this.xh("correlationAnchorLegendAlignWidth",40,"Length in pixels of the height of the correlation anchor legend",c,"",k);this.xh("correlationLabelInterval",1,"Interval for the sample or variable labels in the correlation plot",c,"",k);this.oL("correlationType","diamond",["diamond","circle"],"Shape to use in the correlation graphs",c,"",k);c="Density Plots";this.ss(c,"Parameters used to create density plots in 1d and 2d scatter plots","DensityGraphs",true);this.lj("ScatterDensity",false,"density kernel in histograms",c,"",k);this.oL("densityKernel","gaussian",["gaussian","rectangular","triangular","epanechnikov","quartic","biweight","cosine","optcosine"],"Histogram density kernels",c,"",k);this.oL("densityPosition","normal",["normal","stacked","filled"],"Histogram density position",c,"",k);this.oL("bandwidthRule","nrd0",["nrd0","nrd","silverman"],"Bandwidth rule ",c,"",k);this.xh("bandwidthCut",3,"Bandwidth cut",c,"",k);this.kK("bandwidthAdjust",1,"Bandwidth adjust for the window",c,"",k);c="Dotplot Graphs";this.ss(c,"General parameters in dotplot graphs","DotGraphs",true);this.oL("dotplotType","normal",["arrow","bullet","cleveland","connected","line","lineConnected","normal","stacked","transition"],"Style for the dotplot. Transition plot are only applicable when data is grouped",c,"",k);c="Dumbbell Graphs";this.ss(c,"General parameters in dumbbell graphs","DotGraphs",true);this.oL("dumbbellType","stacked",["arrow","bullet","cleveland","connected","line","lineConnected","stacked"],"Style for the dumbbell plot",c,"",k);c="Fish Graphs";this.ss(c,"General parameters in fish graphs","Fish",true);this.Kc("fishParents",[],"Fish Parents",c,"",k);this.Kc("fishTimepoints",[],"Fish Timepoints",c,"",k);this.JW("fishSeparateIndependentClones",false,"Flag to separate indepenent clones",c,"",k);this.oL("fishShape","polygon",["spline","polygon"],"Fish Shape",c,"",k);this.Kc("fishAxis",[],"Fish Axis (array with lines across the X Axis)",c,"",k);this.Kc("fishAxisLabels",[],"Fish Axis Labels (array with names for the lines across the X Axis). Must have the same dimension as the fishAxis",c,"",k);this.Kc("fishCloneLabels",[],"Fish Clone Labels (array with names for the clones). Must have the same dimension as the fishParents",c,"",k);c="Gantt Charts";this.ss(c,"General parameters in gantt charts","Gantt",true);this.oL("ganttStart",false,[false],"Variable to use in Gantt plots as start date. Defaults to the first variable in the data set",c,"",k);this.oL("ganttEnd",false,[false],"Variable to use in Gantt plots as end date. Defaults to the second variable in the data set",c,"",k);this.oL("ganttCompletion",false,[false],"Variable annotation in the x object to use in Gantt plots as completion percentage. Must be a value between 0 and 1",c,"",k);this.oL("ganttDependency",false,[false],"Variable annotation in the x object to use in Gantt plots as dependency. Must be a valid sample / group name",c,"",k);this.oL("ganttDependencyEnd",false,[false],"Variable annotation for the type of ending for the dependency line. Options are arrow, square or round",c,"",k);this.rW("ganttDependency",false,"variable metadata used for the dependency line. Defaults to rgb(0,0,0)",c,"",k);this.kK("ganttDependencyThickness",false,"Variable annotation for the thickness of the dependency line. Defaults to 1",c,"",k);this.kK("ganttCompletionTransparency",0.5,"Fraction to adjust color transparency for completion",c,"",k);c="Genome Browser";this.ss(c,"General parameters used in genome browser","Genome",true);this.xh("genomeTicks",50,"Number of ticks in the genome browser",c,"",k);this.rW("wire","rgba(204,204,204,0.1)","ticks in the genome browser",c,"",k);this.xh("periodTicksLabels",5,"Number of ticks to skip between values in the genome browser",c,"",k);this.oL("genomeResolution","low",["low","medium","high"],"Number to adjust the splines curvature",c,"",k);c="Genome Browser Tracks";this.ss(c,"General parameters used in genome browser tracks","Genome",true);this.OS("trackName","",b,11,1,"center","middle",0,8,"track name","Genome Browser Tracks","",k);this.rW("trackFill",w,"fill of the tracks in the genome browser",c,"",k);this.rW("trackDir",b,"strand direction of the tracks in the genome browser",c,"",k);this.xh("subtracksMaxDefault",8,"Maximum number of subtracks to show in a track",c,"",k);this.Kc("trackConfigurableProperties",["name","hideName","hideFeatureNames","type","height","fill","outline","data","hide","connect","subtracksMax","highlight"],"Track configurable properties<br> @tracks {name:[string];Track name;[]}",c,"",k);c="Genome Browser Features";this.ss(c,"General parameters used in genome browser features","Genome",true);this.xh("showFeatureNameThereshold",20,"Threshehold used to set te limit when there are too many features in the genome browser",c,"",k);this.OS("featureName","",b,11,1,"center","middle",0,8,"feature name",c,"",k);this.rW("featureFill",w,"fill of the feature in the genome browser",c,"",k);this.rW("featureDir",b,"strand direction of the feature in the genome browser",c,"",k);this.xh("maxFeatureStringLen",30,"Maximum length in characters a feature label can have so anything above is truncated",c,"",k);this.xh("featureWidthDefault",3,"Default size in pixels of the feature width",c,"",k);this.xh("featureHeightDefault",14,"Default size in pixels of the feature height",c,"",k);this.oL("featureSpliceStyle","rect",["rect","broken"],"Default style for splicing in boxes",c,"",k);this.xh("featureTraceHeight",40,"Default size in pixels of the trace height",c,"",k);this.xh("featureTraceTrim",1,"Default triming for nucleotide values in the traces (expressed in percent)",c,"",k);this.JW("featureTracesShow",true,"Flag to use to show traces",c,"",k);this.xh("featureQualityHeight",14,"Default size in pixels of the quality height",c,"",k);this.JW("featureQualityValues",false,"Flag to use to show values for the quality",c,"",k);this.JW("featureQualityShow",true,"Flag to use to show quality",c,"",k);this.xh("featureSignalToNoiseHeight",14,"Default size in pixels of the quality height",c,"",k);this.JW("featureSignalToNoiseValues",false,"Flag to use to show values for the quality",c,"",k);this.JW("featureSignalToNoiseShow",true,"Flag to use to show quality",c,"",k);this.xh("featureCoordinateHeight",14,"Default size in pixels of the coordinates height",c,"",k);this.JW("featureCoordinateShow",true,"Flag to use to show coordinates",c,"",k);this.xh("featureTranslateHeight",14,"Default size in pixels of the translation height",c,"",k);this.JW("featureTranslateShow",true,"Flag to use to show tranlation",c,"",k);this.oL("featureTypeDefault","line",["box","bar","heatmap","sequence","triangle","line"],"Default type for the feature in the genome browser",c,"",k);this.JW("featureStaggered",false,"Flag to use to stagger the features in the genome panel",c,"",k);this.Kc("featureConfigurableProperties",["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"],"Feature configurable properties<br> @features {id:[string];Feature id;[],fill:[color];Color for the feature;[]}",c,"",k);c="Genome Browser Sequences";this.ss(c,"General parameters used in genome browser sequeces","Genome",true);this.OS("sequence","",b,11,1,"center","middle",0,8,"sequence",c,"",k);this.rW("sequenceFill",false,"background when showing sequnces in the box or sequence object in the Genome. The default is to use the background of the object. If specied a valid color then all the background of sequences will be uniform",c,"",k);this.rW("sequenceGAP","rgb(255,0,255)","deletions, insertions and gaps in the genome browser",c,"",k);this.rW("sequenceA","rgb(0,103,0)","adenines and alanines in the genome browser",c,"",k);this.rW("sequenceB",b,"degenerate C/G/T and asparagines in the genome browser",c,"",k);this.rW("sequenceC","rgb(0,0,255)","cytosines and cysteins in the genome browser",c,"",k);this.rW("sequenceD",b,"degenerate A/G/T and aspartic acids in the genome browser",c,"",k);this.rW("sequenceE",b,"glutamic acids in the genome browser",c,"",k);this.rW("sequenceF","rgb(0,0,255)","phenylalanines in the genome browser",c,"",k);this.rW("sequenceG",b,"guanines and glycines in the genome browser",c,"",k);this.rW("sequenceH","rgb(255,0,0)","degenerate A/C/T and histidines in the genome browser",c,"",k);this.rW("sequenceI","rgb(0,103,0)","isoleucines in the genome browser",c,"",k);this.rW("sequenceK","rgb(255,0,0)","degenerate G/T and lysines in the genome browser",c,"",k);this.rW("sequenceL","rgb(0,103,0)","leucines in the genome browser",c,"",k);this.rW("sequenceM","rgb(0,103,0)","degenerate A/G and methionines in the genome browser",c,"",k);this.rW("sequenceN",b,"degenerate A/C/G/T and asparagines in the genome browser",c,"",k);this.rW("sequenceP","rgb(255,165,0)","prolines in the genome browser",c,"",k);this.rW("sequenceQ",b,"glutamines in the genome browser",c,"",k);this.rW("sequenceR","rgb(255,0,0)","degenerate A/G and arginines in the genome browser",c,"",k);this.rW("sequenceS","rgb(255,165,0)","degenerate G/C and serines in the genome browser",c,"",k);this.rW("sequenceT","rgb(255,0,0)","thymidines and threonines in the genome browser",c,"",k);this.rW("sequenceU","rgb(255,0,0)","uracils in the genome browser",c,"",k);this.rW("sequenceV","rgb(0,103,0)","degenerate A/C/G and valines in the genome browser",c,"",k);this.rW("sequenceW","rgb(0,0,255)","degenerate A/T and tryptophans in the genome browser",c,"",k);this.rW("sequenceX",b,"any aminoacid code in the genome browser",c,"",k);this.rW("sequenceY","rgb(0,0,255)","degenerate C/T and tyrosines in the genome browser",c,"",k);this.rW("sequenceZ",b,"glutamines in the genome browser",c,"",k);this.rW("sequenceStart","rgb(0,204,0)","start codon in the genome browser",c,"",k);this.rW("sequenceEnd","rgb(255,0,0)","end codon in the genome browser",c,"",k);c="Heatmap Graphs";this.ss(c,"General parameters for heatmaps","Heatmap",true);this.xh("varIndicesStart",-1,"Number that indicates starting point for variables in heatmaps when the canvas is zoom in",c);this.xh("smpIndicesStart",-1,"Number that indicates starting point for samples in heatmaps when the canvas is zoom in",c);this.xh("grpIndicesStart",-1,"Number that indicates starting point for grouped samples in heatmaps when the canvas is zoom in",c);this.JW("isMultidimensionalData",false,"Flag to indicate if there is more than a single data set",c);this.JW("heatmapAutoAdjust",false,"Flag to adjust the color spectrum of the heatmaps when zooming in/out. The full spectrum range will be utilized to cover the selcted cells in the heatmap if the flag is set to true",c,"",k);this.JW("heatmapCellBox",true,"Flag to print a box around the heatmap cells",c,"",k);this.rW("heatmapCellBox","rgb(102,102,102)","heatmap boxes around the cells",c,"",k);this.kK("heatmapCellBoxWidth",1,"Width for the heatmap boxes around the cells",c,"",k);this.uT("heatmapCellBoxColorHighlight","#fed385","highlighted heatmap cells",c,"",k);this.kK("heatmapCellBoxHighlightWidth",1,"Width for the highlighting heatmap boxes around the cells",c,"",k);this.JW("heatmapHighlightByRowCol",false,"Flag to highlight specific rows and columns in the heatmap cells when a variable or a sample is selected",c,"",k);this.uT("heatmapHighlightByRowColIntersection","#9b6f2b","highlighted heatmap cells where rows and columns intersect",c,"",k);this.kK("heatmapHighlightByRowColIntersectionWidth",3,"Width for the highlighting heatmap boxes around the cells where rows and columns intersect",c,"",k);this.oL("varTitleLabelPosition","bottom",["bottom","top"],"Position for variable labels",c,"",k);this.oL("smpTitleLabelPosition","left",["left","right"],"Position for sample labels",c,"",k);this.oL("heatmapType","normal",["normal","circle","hexagon","upset","correlation"],"Type of Heatmap used to overlay a layer on top of an image. Special for spatial transcriptomics and UpSet plots",c,"",k);this.JW("heatmapCollapse",false,"Flag to collapse cells in heatmaps of type circle or hexagon. If true cells are ploted without outline otherwise the outline is the foreground color",c,"",k);c="Heatmap Color Indicators";this.ss(c,"General parameters for heatmap color indicators","Heatmap",true);this.lj("HeatmapIndicator",true,"heatmap color indicator",c,"",k);this.xh("heatmapIndicatorHeight",40,"Length in pixels for the heatmap indicator",c,"",k);this.xh("heatmapIndicatorWidth",200,"Length in pixels for the heatmap indicator line width used for increase the size of the indicator",c,"",k);this.JW("adjustAspectRatioHeatmapIndicator",true,"Flag to ensure the heatmap indicator scales appropriately when the graph is rendered or the user manually resizes the graph, the adjustAspectRatio flag must be set to true for the adjustAspectRatioHeatmapIndicator to take effect",c,"",k);this.oL("heatmapIndicatorPosition","right",["topLeft","top","topRight","right"],"Position for the heatmap indicator",c,"",k);this.JW("heatmapIndicatorBeforeOverlays",true,"Flag to place the heatmap indicator before the overlay legends",c,"",k);this.JW("heatmapIndicatorHistogram",false,"Flag to show histogram in the heatmap indicator",c,"",k);this.rW("heatmapIndicatorHistogram","#0ab0db","heatmap indicator histogram",c,"",k);c="Histograms";this.ss(c,"Parameters used to create histograms in 2d scatter plots","Scatter2D",true);this.ck("showHistogram",false,"Flag or sample annotation to create histogram. If true is specified then the histogram will be done with all data",c,"",k);this.kK("histogramBarWidth",false,"Length in pixels for half of the bar width in the 2D scatter plot histogram",c);this.JW("histogramRight",true,"Flag to use histogram right binning.  If true, the histogram cells are right-closed (left open) intervals",c,"",k);this.JW("histogramLowest",true,"Flag to use histogram lowest binning. If true, an x[i] equal to the breaks value will be included in the first (or last, for right = FALSE) bar",c,"",k);this.xh("histogramBins",30,"Approximate number of bins in a histogram. It may vary to the actual number used in the histogram to ensure a pretty size for the intervals in the histogram. Default is the same as in ggplot which is 30",c,"",k);this.Kc("histogramBreaks",[],"Numeric vector to set the histogram breaks. It is automatically calculated if not defined using the axisAlgorithm setting and the histogramBins",c,"",k);this.kK("histogramBinWidth",false,"Width in actual units for the histogram bin",c,"",k);this.oL("histogramType","dodged",["dodged","staggered","stacked"],"Type of histogram when multiple series are present",c,"",k);this.lj("HistogramDensity",false,"density kernel in histograms",c,"",k);this.lj("HistogramPath",false,"histograms path",c,"",k);this.lj("FilledHistogramPath",false,"filled histogram path",c,"",k);this.kK("histogramPathFillTransparency",0.85,"Transparency applied to the filled histogram path",c,"",k);this.rW("histogramPath",false,"histogram path. If not specified the it defaults to the color of the histogram bars",c,"",k);this.xh("histogramPathWidth",2,"Width for the line of the histogram path line",c,"",k);this.lj("FilledHistogramDensity",false,"filled histogram density",c,"",k);this.kK("histogramDensityFillTransparency",0.85,"Transparency applied to the filled histogram density",c,"",k);this.lj("HistogramDataPoints",false,"original data point in histograms",c,"",k);this.lj("HistogramQuantiles",false,"quantile 0.25 and 0.75 in density plots",c,"",k);this.lj("HistogramMedian",false,"histogram median",c,"",k);this.oL("histogramMedianLineType","dashed",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line type for the histogram median",c,"",k);this.JW("showHistogramBars",false,"Flag to hide the histogram bars",c,"",k);this.oL("histogramSizeEstimator","sturges",["sturges","freedmanDiaconis","scott"],"Histogram size estimator",c,"",k);this.oL("histogramStat","count",["density","count"],"Histogram density type",c,"",k);this.JW("histogramAsDotplot",false,"Flag to use dots as histogram bars",c,"",k);this.hd("histogramDotplot","#fe6969",b,0.5,"solid","data points in dotplot histograms","Histograms","",k);this.kK("histogramStackRatio",1,"Stack ratio for dotplot histograms. I has to be a value between 0 and 1",c,"",k);this.oL("histogramStackDir","down",["down","center","centerwhole"],"Direction to stack the dots in dotplot histograms",c,"",k);c="Kaplan Meier Plots";this.ss(c,"Parameters used to create kaplan meier curves in 2d scatter plots","Scatter2D",true);this.lj("KMConfidenceIntervals",true,"confidence intervals in Kaplan-Meier plots ",c,"",k);this.lj("KMMedianSurvivalTime",false,"median survival time in Kaplan-Meier plots ",c,"",k);this.kK("kmConfidenceLevel",0.95,"Confidence level for Kaplan Meier plots",c,"",k);this.oL("kmConfidenceIntervalType","log",["ordinary","log","loglog"],"Confidence intervals type for Kaplan Meier estimates",c,"",k);this.JW("kmInvertCensored",false,"Flag to indicate whether zero values are censored or not in Kaplan-Meier plots",c,"",k);this.JW("kmCensoredRug",false,"Flag to indicate whether to show the censored data as a rug in Kaplan-Meier plots",c,"",k);this.ck("kmRiskTable",false,"Data to show the number of subjects at risk in Kaplan-Meier plots. It will be aligned to the major ticks in the x Axis",c,"",k);this.JW("kmPvalue",false,"Flag to show the p-value in Kaplan-Meier plots",c,"",k);this.ck("kmTime",false,"Data to use as time2 in Kaplan-Meier plots. It must be a numeric factor as it will be used to set the range for the events in the Kaplan-Meier plot",c,"",k);this.JW("kmCxplot",false,"Flag to indicate Kaplan-Meier plot was generated through survminer",c,"",k);this.Kc("kmColors",[],"Array with colors for the Kaplan-Meier plots",c,"",k);c="Line Graphs";this.ss(c,"General parameters in line graphs","LineGraphs",true);this.oL("lineDecoration","symbol",[false,"dot","symbol","pattern"],"Lines decorations in the line graphs",c,"",k);this.oL("lineErrorType","bar",["bar","area"],"Line error type in the line graphs. The line type must be spline for the area error type. ",c,"",k);this.JW("coordinateLineColor",false,"Flag to use same color in BarLine plots. If set to true the color of the bars and the lines will be coordinated",c,"",k);this.oL("lineType","rect",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line used to join the points in line graphs",c,"",k);this.kK("tension",0.3,"Curvature for the splines and hulls",c,"",k);this.xh("tensionSegments",16,"Number of segments to smooth a quadratic curve",c,"",k);c="Lollipop Graphs";this.ss(c,"General parameters in lollipop graphs","Bar",true);this.JW("barLollipopOpen",false,"Flag to use open pattern for the lollipop",c,"",k);c="Manhattan Plots";this.ss(c,"General parameters in scatter plots","Scatter2D",true);this.Kc("chromosomeLengths",[],"Manhattan Chromosomes length is a sorted array by chromosome with the length in base pairs for each chromosome. It is required when scatterType is manhattan",c,"",k);this.Kc("armLengths",[],"Manhattan Chromosomes arm length is a sorted array by chromosome with the length in base pairs for each chromosomeshort arm. It has to have the same dimesions as the chromosomeLengths",c,"",k);this.ck("manhattanMarkerChromosomeNumber",false,"Sample name included in the data.y.smps object used to map to the chromosome number",c,"",k);this.oL("manhattanMarkerPosition",false,[false],"Sample name included in the data.y.smps object used to map to the position in base pairs",c,"",k);this.oL("manhattanMarkerLogPValue",false,[false],"Sample name included in the data.y.smps object used to map to the negative log 10 p value",c,"",k);this.oL("manhattanCNV",false,[false],"Sample name included in the data.y.smps object used to map to the copy number value",c,"",k);this.oL("manhattanRangeStart",false,[false],"Sample name included in the data.y.smps object used to map the start position",c,"",k);this.oL("manhattanRangeEnd",false,[false],"Sample name included in the data.y.smps object used to map the end position",c,"",k);this.lj("manhattanRangeMiddle",false,"show dot in the middle of the range in manhattan plots",c,"",k);this.xh("manhattanRangeLineWidth",10,"Number of pixels for the line width in manhattan plots",c,"",k);this.Kc("manhattanColors",["rgb(128,128,128)","rgb(135,206,235)"],"Colors for the manhattan plots alternative chromosomes",c,"",k);this.Kc("manhattanContrastColor","rgba(0,0,0,0.1)","Manhattan contrast color",c,"",k);c="Maps";this.ss(c,"Map properties used in all visualizations","Map",true);this.ck("topoJSON",false,"TopoJSON map string",c,"",k);this.ck("mapId",false,"Map Id for the map div in the DOM",c,"",k);this.ck("mapPropertyId",false,"Map Property Id use to match the data ids to the GeoJSON layer Id",c,"",k);this.oL("mapProjection","mercator",["mercator","albers","orthographic"],"Map projection",c,"",k);this.Kv("mapConfig",false,"Map config",c,"",k);this.Kv("mapConfigFeatures",false,"Map config for features use to translate and scale",c,"",k);this.Kc("mapSmps",[],"Samples to use in maps",c,"",k);this.Kc("hiddenMapFeatures",[],"Hidden Map features",c,"",k);this.Kc("visibleMapFeatures",[],"Visible Map features. It Overrides the hidden features",c,"",k);this.rW("map","#0ab0db","maps",c,"",k);this.rW("mapOutline","rgb(204,204,204)","outline of the maps",c,"",k);this.oL("mapMarkerShape","drop",["drop","sphere","square","triangle","star","rhombus","octagon","mdavid","pentagon","rectangle"],"Default shape for the markers in map (if no shapeBy is specified",c,"",k);this.kK("mapMarkerShapeScaleFactor",1,"Scale factor for the marker shapes",c,"",k);c="Maps Albers";this.ss(c,"Map albers properties used in map visualizations","Map",true);this.kK("mapLatitudeOrigin",23,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps",c,"",k);this.kK("mapCentralMeridian",-96,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps",c,"",k);this.kK("mapStandardParallel1",29.5,"Map Standard Parallel 1 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps",c,"",k);this.kK("mapStandardParallel2",45.5,"Map Standard Parallel 2 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps",c,"",k);this.ss("Maps Orthographic","Map orthographic properties used in map visualizations","Map",true);this.JW("mapGraticuleShow",false,"Flag to show Map Graticule","Maps Orthographic","",k);this.oL("mapGraticuleType","solid",["dashed","solid"],"Map Graticule type","Maps Orthographic","",k);c="Maps Leaflet";this.ss(c,"Map leaflet properties used in map visualizations","Map",true);this.JW("useLeaflet",false,"Flag to use leaflet",c,"",k);this.kK("leafletAlpha",0.7,"Transparency for leaflet layers",c,"",k);this.kK("leafletZoomAlphaColor",6,"Zoom level before turning transparent the leaflet layers",c,"",k);this.oL("leafletTileType","street",["street","terrain","labels","satellite"],"Leaflet tile type",c,"",k);c="Meter Graphs";this.ss(c,"General parameters in meter graphs","Meter",true);this.oL("meterType","gauge",["gauge","speedometer","vertical","horizontal","state","digital","number"],"Type of meter. ",c,"",k);this.oL("meterTopology","auto",["auto","grid","horizontal","vertical"],"Topology set up for the meters",c,"",k);this.rW("meterNeedle",b,"Meter Needle Color",c,"",k);this.rW("meterBackground","rgb(229,229,229)","Meter Background Color",c,"",k);this.xh("meterThickness",50,"Thickness in pixels for the vertical, horizontal and state meters",c,"",k);c="Network Graphs";this.ss(c,"General parameters used in networks","Network",true);this.JW("calculateLayout",true,"Flag to force or not to calculate the network layout",c,"",k);this.JW("networkFreeze",false,"Flag to prevent autoscaling for the network layout. Useful when images are part of the network",c,"",k);this.xh("networkMaxIterations",15,"Number of iterations to separate subnetworks",c,"",k);this.JW("networkFreezeOnLoad",false,"Flag to prevent autoscaling for the network layout after loading. Useful when images are part of the network",c,"",k);this.JW("preScaleNetwork",false,"Flag to prescale or not the network. This is an aesthetic parameter to make the graph look nicer... Sometimes..",c,"",k);this.JW("ignoreEventlessOrder",false,"Flag to render all nodes at one time rather that rendering first the eventless nodes and then the non-eventless nodes",c,"",k);this.QX("subNetworks",false,"Array to keep independent networks",c);this.oL("networkLayoutType","forceDirected",["forceDirected","circular","radial","cola"],"Type of network layout",c,"",k);this.ck("networkRoot",false,"Node Id of the network root",c,"",k);this.JW("isNetworkMetrics",false,"Flag to calculate all network metrics: betweenness, closeness, eccentricity and degree",c,"",k);this.lj("NetworkRadialLayout",false,"radial layout wire",c,"",k);this.JW("is3DNetwork",false,"Flag to create or not a 3D network",c,"",k);this.JW("networkNodesOnTop",true,"Flag to draw the nodes on top of edges in the networks. Useful for very populated netwrok graphs. When is set to true all the edges will be in the background",c,"",k);this.JW("moveParentsWithChildren",false,"Flag to make parents move when a child is moved",c,"",k);this.Kc("highlightNode",[],"Name of nodes in the data.nodes object to highlight",c,"",k);this.rW("nodeHighlight","rgb(255,0,0)","highlighted nodes",c,"",k);this.xh("showNodeNameThreshold",50,"Thereshold used to set the limit to hide or display the name of nodes in a network. If the number of nodes exceed this thereshold then the name will not be shown",c,"",k);this.xh("showNodeNameSizeThreshold",20,"Thereshold used to set the limit to hide or display the name of nodes in a network based on the size of the node. If the number of node size exceed this thereshold then the name will be shown",c,"",k);this.xh("nodeSize",15,"Approximate pixels for the size of the nodes in the network. Automatically adjusted depending on the numebr of nodes in the network",c);this.kK("nodeSizeScaleFactor",1,"Scaling factor for increasing size of all nodes in the network",c,"",k);this.rW("edge",b,"edges",c,"",k);this.xh("edgeThickness",1,"Default thickness for the edges in the networks",c);this.kK("edgeSeparationFactor",1,"Factor to adjust the separation between the edge and the node in the networks",c,"",k);this.oL("labelNodePosition","auto",["auto","center","top","right","bottom","left"],"Default position for the node label",c,"",k);this.OS("node","",false,11,1,"center","middle",0,8,"node","Network Graphs","",k);this.rW("node","rgb(245,245,245)","nodes",c,"",k);this.ck("networkVendor",false,"Network vendor",c,"",k);this.oL("networkProgressBarPosition","bottom",["none","bottom","center","top"],"Position for the progress bar",c,"",k);c="Network Algorithm Parameters";this.ss(c,"General parameters used in the layout algorithms for networks","Network",true);this.kK("networkConvergenceThreshold",0.05,"Threshold for the convergence of the network",c,"",k);this.oL("attractiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating attractive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log",c,"",k);this.oL("repulsiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating repulsive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log",c,"",k);this.JW("useBarnesHutSimulation",false,"Flag to use Barnes-Hut simulation",c,"",k);this.JW("networkDisjoint",true,"Flag to use positioning forces rather than centering forces. Applicable only to force directed layouts that contain multiple subnetworks",c,"",k);this.kK("networkSpeed",0.1,"Network Speed",c,"",k);this.kK("networkGravity",0.75,"Network Gravity",c,"",k);this.xh("networkSpringLength",35,"Ideal length for links (springs in physical model)",c,"",k);this.kK("networkSpringCoeff",0.0008,"Hooks law coefficient. 1 - solid spring",c,"",k);this.kK("networkRepulsion",-1,"Coulombs law coefficient. Its used to repel nodes thus should be negative if you make it positive nodes start attract each other",c,"",k);this.kK("networkTheta",0.8,"Theta coefficient from Barnes Hut simulation. Ranged between (0, 1). The closer its to 1 the more nodes algorithm will have to go through. Setting it to one makes Barnes Hut simulation no different from brute-force forces calculation (each node is considered)",c,"",k);this.kK("networkDragCoeff",0.09,"Drag force coefficient. Used to slow down system, thus should be less than 1. The closer it is to 0 the less tight system will be",c,"",k);this.xh("networkTimeStep",20,"Default time step (dt) for forces integration",c,"",k);this.Kc("barnesHutUpdateQueue",[],"Barnes Hut Queue for performance and avoid Javascript GC",c);this.Kc("barnesHutNodesCache",[],"Barnes Hut node cache for performance and avoid Javascript GC",c);this.xh("barnesHutNodesCacheCurrent",0,"Barnes Hut idex for node cache for performance and avoid Javascript GC",c);c="Network Cola Algorithm Parameters";this.ss(c,"General parameters used in the cola layout algorithm for networks","Network",true);this.xh("networkColaLinkDistance",20,"Ideal length for links",c,"",k);this.JW("networkColaAvoidOverlaps",true,"Flag to avoid overlaps of nodes in the cola network",c,"",k);this.JW("networkColaHandleDisconnected",true,"Flag to handle disconnected nodes in the cola network",c,"",k);this.kK("networkColaConvergenceThreshold",0.01,"Threshold for the convergence of the cola network",c,"",k);this.kK("networkColaGroupCompactness",0.000001,"Compactness for the groups in the cola network",c,"",k);this.xh("networkColaSymmetricDiffLinkLengths",5,"Symmetric difference for the link lengths in the cola network",c,"",k);this.kK("networkColaJaccardLinkLength",false,"Ideal length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs",c,"",k);this.kK("networkColaJaccardLinkLengthDefault",1,"Default length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs",c,"",k);this.oL("networkColaFlowLayoutAxis",false,[false,"x","y"],"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle",c,"",k);this.kK("networkColaFlowLayoutSeparation",10,"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle",c,"",k);this.xh("networkColaStartUnconstrainedIterations",0,"Number of iterations to run unconstrained",c,"",k);this.xh("networkColaUserConstraintIterations",0,"Number of user iterations to run unconstrained",c,"",k);this.xh("networkColaAllConstraintsIterations",0,"Number of iterations to run all constraints",c,"",k);this.xh("networkColaGridSnapIterations",0,"Number of iterations to run grid snap",c,"",k);this.JW("networkColaKeepRunning",true,"Flag to keep running the cola network",c,"",k);this.JW("networkColaCenterGraph",true,"Flag to center the cola network",c,"",k);c="Network Node and Edge Attributes";this.ss(c,"General parameters used for nodes and edges in networks","Network",true);this.ck("colorNodeBy",false,"Name of the attribute to color the nodes",c,"",k);this.ck("shapeNodeBy",false,"Name of the attribute to shape the nods",c,"",k);this.ck("sizeNodeBy",false,"Name of the attribute to size the nodes",c,"",k);this.ck("patternNodeBy",false,"Name of the attribute to pattern the nodes",c,"",k);this.ck("colorEdgeBy",false,"Name of the attribute to color the edges",c,"",k);this.ck("sizeEdgeBy",false,"Name of the attribute to size the edges",c,"",k);this.kK("minEdgeSize",0,"Number of pixels to add to the minimum thickness for the edges when the edges are sized by a property. Should be a value between 0 and 1.5",c,"",k);this.kK("maxEdgeSize",10,"Thickness for the edges when the edges are sized by a property. Should be a value between 10 and 20",c,"",k);c="Network Communities";this.ss(c,"General parameters used in network communities","Network",true);this.lj("NetworkCommunities",false,"network communities",c,"",k);this.JW("calculateNetworkCommunities",true,"Flag to calculate the network communities using the jLouvain algorithm. If this flag is false the property community and communityColor for each node will need to be provided, otherwise all nodes will belong to a single community",c,"",k);this.JW("coordinateNetworkConvexHullCommunityColor",false,"Flag to coordinate colors of the nodes with convex hull for the network communities",c,"",k);this.kK("hullScale",1.25,"Scaling factor for extension of the hulls in the network communities",c,"",k);this.xh("networkCommunities",null,"Number of network communities",c);this.Kc("networkConvexHulls",[],"Array for the Network community convex hull property object",c);c="Oncoprint Graphs";this.ss(c,"General parameters for oncoprints","Heatmap",true);this.JW("isOncoprint",false,"Flag to draw an oncoprint",c);this.ck("oncoprintCNA",false,"String to identify the data object to use to draw the copy number alterations; that is the amplifications (which will be colored red) and deletions (which will be colored blue). It MUST be a file with only two categorical levels",c,"",k);this.ck("oncoprintMUT",false,"String to identify the data object to use to draw the mutations. For example missense, non-synonymous, truncating, etc. Each level will be colored in a shade of green",c,"",k);this.JW("oncoprintHeatmapSwitch",false,"Flag to switch to Oncoprint or Heatmap visualization. Requieres data in the data object",c,"",k);this.JW("oncoprintNoAlterations",true,"Flag to switch to show variables and samples without any alterations",c,"",k);this.JW("oncoprintColSummary",false,"Flag to show column summary in oncoprints",c,"",k);this.JW("oncoprintRowSummary",false,"Flag to show row summary in oncoprints",c,"",k);this.lj("HeatmapOncoprint",false,"heatmap along with the oncoprint",c,"",k);this.oL("oncoprintHeatmapPosition","bottom",["right","bottom","left","top"],"Position for the heatmap in the oncoprint",c,"",k);c="Parallel Coordinates Graphs";this.ss(c,"General parameters in Parallel Coordinates Graphs","ParallelCoordinates",true);this.Kc("parallelCoordinates",[],"Array used to store and handle a parallel coordinates plot",c);c="Pie Charts";this.ss(c,"General parameters in pie charts","Pie",true);this.oL("pieType","separated",["separated","solid"],"Position for the pices of the pie",c,"",k);this.xh("pieSegmentPrecision",0,"Number of decimals for values in the Pie charts",c,"",k);this.xh("pieSegmentSeparation",1,"Length in pixels for the separation of the pieces of the pie charts",c,"",k);this.oL("pieSegmentLabels","inside",["inside","outside"],"Location for the values in the pie charts",c,"",k);this.oL("pieLabelType","percentage",["percentage","value"],"Pie label type to show the percentage of the slice or the actual number",c,"",k);this.kK("maxPieSectors",20,"Max pie sectors. After that number the sectors will be put in a sector named other",c,"",k);this.lj("PieValues",true,"values for the pie",c,"",k);this.lj("PieSampleLabel",true,"sample label when plotting multiple pies",c,"",k);this.kK("startPieSectors",270,"Starting degrees for pie sectors. 0 is equivalent to 3:00 oclock",c,"",k);this.kK("pieInnerRadius",0,"Percentage of the radius in the pies to remove to make a donut. It must be a number between 0 to 1",c,"",k);this.Kc("pieColors",[],"Pie Colors. Defaults to the parameter colors",c,"",k);c="Quantile Regression Plots";this.ss(c,"Parameters used to create Quantile Regression plots in 2d scatter plots","Scatter2D",true);this.Kc("quantiles",["0.25","0.5","0.75"],"Array with quantiles to use in quantile regression plots",c,"",k);this.lj("QuantileRegressionFit",false,"Quantile Regression fit in Scatter2D plots",c,"",k);c="Ridgeline Plots";this.ss(c,"Parameters used to create ridgeline plots in 1d and 2d scatter plots","Scatter2D",true);this.kK("ridgelineScale",1.5,"Scale for ridgeline",c,"",k);this.JW("ridgelineViolin",false,"Flag to use a violin to calculate the ridgeline plot",c,"",k);c="Sankey Diagrams";this.ss(c,"General parameters in sankey diagrams","Sankey",true);this.xh("sankeyNodeWidth",30,"Width for the Sankey nodes",c,"",k);this.xh("sankeyNodePadding",8,"Padding between the Sankey nodes",c,"",k);this.xh("sankeyIterations",32,"Number of iterations for the Sankey diagram. Stting iterations to zero will not reorder the nodes",c);this.oL("sankeySource",false,[false],"Name of a sample annotation to use as source in the sankey diagrams",c,"",k);this.oL("sankeyTarget",false,[false],"Name of a sample annotation to use as target in the sankey diagrams",c,"",k);this.Kc("sankeyAxes",[],"Axes to include in the alluvial plots. It must sample annotations of the string type in the x object",c,"",k);this.rW("sankeyNodes",false,"sankey nodes",c,"",k);this.rW("sankeyLinks","rgba(204,204,204,0.66)","sankey lines (links)",c,"",k);this.rW("sankeyOutline",n,"sankey outline",c,"",k);this.OS("sankeyText","",b,11,1,"center","middle",90,0,"sankey diagram labels",c,"",k);this.oi("sankeyText",true,"labels in the Sankey diagrams",c,"",k);this.OS("sankeyTitle","",b,11,1,"center","middle",0,0,"sankey diagram titles",c,"",k);this.oi("sankeyTitle",true,"titles in the Sankey diagrams",c,"",k);this.JW("sankeyTextAuto",true,"Flag to adjust the text orientation and the visibility for the labels in the Sankey diagrams",c,"",k);this.JW("sankeyTextInside",true,"Flag to draw the text of the sankey labels inside the plot. It is only applicable when sankeyTextAuto is false",c,"",k);c="Scatter Plots";this.ss(c,"General parameters in scatter plots","ScatterGraphs",true);this.oL("scatterType",false,[false,"line","bar","dot","area","image","lineImage","lineStep","boxplot","visium","manhattan","manhattanCNV","bin2d","polygon","stream"],"Type of scatter plot",c,"",k);this.JW("isBumpPlot",false,"Flag to create a Bump plot",c,"",k);this.lj("ScatterLineOriginalData",false,"observed data points in scatter plots with scatter type line",c,"",k);this.JW("scatterContext",false,"Flag to use Scatter2D when the graphType is not but the scatterType is line, bar, dot, area or boxplot",c);this.kK("scatterLineAlpha",1,"Transparency applied to lines in scatter plots",c,"",k);this.kK("scatterPointAlpha",1,"Thickness applied to data points in scatter plots",c,"",k);this.kK("groupingFactorWindow",false,"The width for the data when grouping in Scatter2D plots. This is the analogous parameter to cut_width in R. It defaults to a fifth of the data range. The scatterType must be boxplot to take this parameter into effect",c,"",k);this.rW("function",b,"function plots",c,"",k);this.rW("cXscatter",b,"scatter cXplots",c,"",k);this.lj("DataLabels",false,"data labels in scatter plots",c,"",k);this.JW("isDataLabels",false,"Flag to put a background in data labels",c,"",k);this.JW("isDataLabelsBackgroundColor",false,"Flag to use the color in the colorDataLabels as a background in data labels",c,"",k);this.hd("dataLabelBackground",w,b,0.5,"solid","data labels background","Scatter Plots","",k);this.JW("scatterAxesEqual",false,"Flag to keep same range in both axes",c,"",k);this.xh("scatterOutlineThreshold",50000,"Maximum number of data points before skipping plotting their outline but only the fill color",c,"",k);c="Scatter Plot Matrix";this.ss(c,"Parameters used to create a matrix of 2d scatter plots","Scatter2D",true);this.oL("scatterPlotMatrix",false,[true,false],"Could be a boolean to plot a matrix of 2D scatterplots or a sample annotation to color and segregate the plots",c,"",k);this.oL("scatterPlotMatrixType","both",["both","upper","lower","correlation","correlationHistogram","correlationDensity","all","first"],"Type for the matrix of 2D scatterplots. Draw either in both panels, upper only or lower only. Show any combination of correlation, histogram, density and variability (boxplots). Also specify whether to use all versus all or only the first data set",c,"",k);this.lj("ScatterPlotMatrixLabels",false,"labels in the scatter plot matrix",c,"",k);c="Stream Plots";this.ss(c,"General parameters in scatter plots","Scatter2D",true);this.oL("scatterStreamType","mirror",["mirror","ridge","proportional"],"Type of stream scatter plot",c,"",k);this.kK("scatterStreamBandwidth",0.75,"Scatter stream bandwidth. Tensor for the wiggles of the stream wiggles. A vaulue between 0 and 1",c,"",k);this.xh("scatterStreamNumber",1000,"Number of values for the wiggles",c,"",k);this.kK("scatterStreamExtraSpan",0.01,"Scatter stream extra extension for the wiggles. A vaulue between 0 and 1 as in percent",c,"",k);this.oL("scatterStreamTrueRange","both",["both","min_x","max_x","none"],"Expand the X axis",c,"",k);this.Kc("scatterStreamWiggles",[],"Order for the streamgraph wiggles",c,"",k);c="Swimmer Graphs";this.ss(c,"General parameters in swimmer graphs","Bar",false);this.oL("swimHigh",false,[false],"Variable to use in Swimmer plot. Defaults to the first variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/",c,"",k);this.oL("swimStart",false,[false],"Variable to use in Swimmer Plot. Defaults to the second variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/",c,"",k);this.oL("swimEnd",false,[false],"Variable to use in Swimmer Plot. Defaults to the third variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/",c,"",k);this.oL("swimStatus",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to Status. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/",c,"",k);this.oL("swimHighCap",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to High Cap. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/",c,"",k);c="Tag Cloud";this.ss(c,"General parameters used in tag clouds","TagCloud",true);this.xh("tagCloudTextWeightFactor",1,"Factor weight for text in tag cloud visualizations",c,"",k);this.xh("tagCloudTextGridSize",8,"Size for the grid in text tag cloud visualizations",c,"",k);this.kK("tagCloudTextEllipticity",0.65,"Ellipticity for the for text in tag cloud visualizations",c,"",k);this.kK("tagCloudTextRotateRatio",0.1,"Ratio for rotation of text in cloud visualizations",c,"",k);this.oL("tagCloudShape",false,[false,"circle","cardioid","diamond","square","triangle","triangle2","pentagon","star"],"Shape for the tag cloud",c,"",k);this.JW("tagCloudMask",false,"Flag to add a shadow for the selected shape",c,"",k);this.Kc("tagCloudGridPoints",[],"Array to keep state of the used space in the tag cloud visualization",c);c="Trees";this.ss(c,"General parameters in trees","Tree",true);this.xh("treeNodeSize",5,"Size for the Tree nodes",c);this.xh("treeNodeId",0,"Id for the nodes in the tree",c);this.kK("treeNodeSizeScaleFactor",1,"Scale factor to adjust the size of tree nodes",c,"",k);this.oL("treeLabelAlign","center",["left","center","right"],"Alignment for labels the tree diagrams",c,"",k);this.rW("treeLink","rgba(204,204,204,0.66)","tree lines (links)",c,"",k);this.rW("treeNodeOutline","#0ab0db","tree node outline",c,"",k);this.xh("treeLinkWidth",1,"Width for the Tree lines",c,"",k);this.JW("treeInverted",false,"Flag to plot the tree inverted",c,"",k);this.oL("treeType","normal",["bracket","circular","normal"],"Type of tree layout",c,"",k);this.JW("treeClickDisable",false,"Flag to disable clicking in tree plots",c,"",k);c="Tree Bracket";this.ss(c,"General parameters in tree brackets","Tree",true);this.kK("treeBracketFactor",0.5,"Proportion of the tree bracket to use",c,"",k);this.kK("treeBracketLengthFactor",4,"Factor to extend the length of the tree node",c,"",k);c="Treemap Graphs";this.ss(c,"General parameters for treemaps","Treemap",true);this.xh("treemapBorderWidth",3,"Width for the treemap border",c,"",k);this.rW("treemapBorder","rgba(204,204,204,0.33)","treemap header and border",c,"",k);c="UpSet Plots";this.ss(c,"General parameters for upset","Heatmap",true);this.JW("isUpSet",false,"Flag to draw an upset plot",c);this.xh("nUpSets",5,"Number of sets to draw",c,"",k);this.xh("nUpSetIntercepts",40,"Number of intercepts to draw",c,"",k);this.Kc("upSetSets",[],"Array containing the names of the sets to include",c,"",k);this.Kc("upSetIntercepts",[],"Array containing the names of the intercepts to include. Sets must be separated by &&",c,"",k);this.rW("upsetShade","rgb(159,159,159)","row shading in matrix",c,"",k);this.kK("upsetShadeAlpha",0.1,"Transparency of shading in matrix",c,"",k);this.kK("upsetMatrixDotAlpha",0.2,"Transparency of the empty intersections points in the matrix",c,"",k);this.rW("upsetMatrix","rgb(59,59,59)","the intersection points",c,"",k);this.rW("upsetMainBar","rgb(59,59,59)","the main bar plot",c,"",k);this.rW("upsetSetsBar","rgb(59,59,59)","set bar plot",c,"",k);this.kK("upsetPointSizeFactor",1,"Adjust the size of points in matrix plot",c,"",k);this.kK("upsetLineSizeFactor",1,"Adjust width of lines in matrix plot",c,"",k);this.kK("upsetMatrixPlotBarRatio",0.7,"Ratio between matrix plot and main bar plot",c,"",k);c="Venn Diagrams";this.ss(c,"General parameters in Venn diagrams","Venn",true);this.JW("vennLegendColors",false,"Flag to use the venn colors to use for the legends instead of the letters",c,"",k);this.xh("vennGroups",4,"Number of groups in the Venn diagram",c,"",k);this.Kc("vennCompartments",["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"],"Name for the compartments in the the Venn diagrams",c);this.Kc("vennColors",[],"Colors for the Venn bubles. If not specified the colors will be chosen from the colors array. Colors in this array need to be at least the same number of groups in the Venn diagram",c,"",k);c="Violin Plots";this.ss(c,"General parameters in Boxplot Graphs","Boxplot",true);this.lj("ViolinBoxplot",false,"violin plot in boxplots",c,"",k);this.JW("violinTrim",true,"Flag to trim violin plots",c,"",k);this.oL("violinScale","width",["area","count","width"],"Type for scaling violin plots",c,"",k);this.lj("BoxplotIfViolin",false,"boxplots when violin plot are show. It does not affect anything unless violins are shown",c,"",k);this.kK("boxplotWidthRatioIfViolin",0.33,"A number between 0.1 and 1 to adjust the width of the boxplot when violins are shown. It does not affect anything unless violins are shown",c,"",k);this.kK("violinTransparency",0.4,"Fraction to adjust color transparency for the violins",c,"",k);this.rW("violin",false,"violins. If specified all the violins will have the assigned color; otherwise it will be automatically assigned",c,"",k);this.rW("violinBorder",b,"violin borders",c,"",k);this.lj("ViolinQuantiles",false,"quantile 0.25 and 0.75 in violin plots",c,"",k);c="Visium Plots";this.ss(c,"General parameters in scatter plots","Scatter2D",true);this.JW("visiumFlip",false,"Flag to invert the data in visium plots. ",c,"",k);this.JW("visiumPanning",false,"Flag to disallow panning in  visium plots. Dragging will always zoom",c,"",k);this.JW("visiumFixedAspectRatio",true,"Flag to fix aspect ratio for visium plots",c,"",k);c="Waterfall Graphs";this.ss(c,"General parameters in waterfall graphs","Bar",true);this.rW("waterfallNet","rgb(153,153,153)","bars in end of the waterfall plot",c,"",k);this.rW("waterfallIncrease","rgb(10,176,219)","bars increasing in the waterfall plot",c,"",k);this.rW("waterfallDecrease","rgb(254, 105, 105)","bars decreasing in the waterfall plot",c,"",k);c="Remote Procedures";this.ss(c,"Parameters used when getting data remotely","AllGraphs",false);this.ny("remoteService",false,"Url used to obtain data remotely thorugh a web service or directly from a file. If the remote service is a file then it expects a json file with a two dimensional array. Each of the arrays should have a key (which will be used in a drop down menu) and a value to point to a url where to get the data. If the remote service is a web service it expects a canvasXpress object. The default parameters for web services are index (to identify the current record number) and dir (to identify the direction; it could be either next or prev)",c,"",k);this.Kv("remoteParams",{},"Object to hold additional parameters used to obtain data remotely. The target property will be always added to the method as well as the direction [next|prev]",c,"",k);this.oL("remoteDirection","next",["next","prev"],"Direction parameter used to obtain data remotely",c,"",k);this.JW("remoteAutoPlay",false,"Flag to iterate over remote data sets",c,"",k);this.xh("remoteAutoPlayDelay",3000,"Time in milliseconds to wait between iterations while automatically going over remote data sets",c,"",k);this.JW("remoteParamOverride",true,"Flag to override parameters to maintain the state of the graphs when using remote services",c,"",k);this.oL("remoteTransitionEffect","slide",["none","slide","fade"],"Effect for the remote transitions",c,"",k);this.JW("remoteAutoSize",true,"Flag to adjust remote graph to current canvas size",c,"",k);this.ck("remoteParentId","","Id for the parent holding the remoteWindow to prevent id collisions",c);this.xh("remoteDataIndex",0,"Index of the canvasXpress object requested",c);this.Kc("remoteIds",[],"Array of the remoteIds passed after a service call",c);this.Kc("remoteData",[],"Array for the remote data pased after a service call",c);this.JW("remoteUpdating",false,"Flag to indicate that updating data is in progress",c);c="R";this.ss(c,"Parameters associated with R","AllGraphs",false);this.ny("RdatasetsURL","https://raw.githubusercontent.com/neuhausi/Rdatasets/refs/heads/master/","URL for R objects",c);this.JW("loadRDatasets",false,"Flag to load R datasets from Github",c,"",k);this.Kv("Rdataset",{},"Object to hold the info for the R dataset loaded",c,"",k);c="cxplot";this.ss(c,"General properties used in cxplot","AllGraphs",false);this.Kv("aes",{},"Initial Configuration passed to cxplot when used in combination with ggplot",c,"",k);this.Kv("ggplot",{},"Initial ggplot configuration passed to cxplot",c,"",k);c="LLM";this.ss(c,"Parameters associated with LLM","AllGraphs",false);this.ny("llmServiceURL","https://www.canvasxpress.org/cgi-bin/services.pl","URL for LLM service",c,"",k);this.oL("llmModel","gemini-2.0-flash-lite",["gemini-2.0-flash-lite","gemini-2.0-flash","gemini-1.5-flash","gemini-1.5-pro","gpt-4o-mini"],"Large language models are models that use deep learning algorithms to process large amounts of text. They are designed to understand the structure of natural language and to pick out meanings and relationships between words. These models are capable of understanding context, identifying and extracting information from text, and making predictions about a text content",c,"",k);this.kK("llmTopp",1,"A sampling technique with temperature, called nucleus sampling, where you can control how deterministic the model is. If you are looking for exact and factual answers keep this low. If you are looking for more diverse responses, increase to a higher value. If you use Top P it means that only the tokens comprising the top_p probability mass are considered for responses, so a low top_p value selects the most confident responses. This means that a high top_p value will enable the model to look at more possible words, including less likely ones, leading to more diverse outputs",c,"",k);this.kK("llmTemperature",0,"The lower the temperature, the more deterministic the results in the sense that the highest probable next token is always picked. Increasing temperature could lead to more randomness, which encourages more diverse or creative outputs. You are essentially increasing the weights of the other possible tokens. In terms of application, you might want to use a lower temperature value for tasks like fact-based QA to encourage more factual and concise responses. For poem generation or other creative tasks, it might be beneficial to increase the temperature value",c,"",k);this.kK("llmPresencePenalty",0,"The presence penalty also applies a penalty on repeated tokens but, unlike the frequency penalty, the penalty is the same for all repeated tokens. A token that appears twice and a token that appears 10 times are penalized the same. This setting prevents the model from repeating phrases too often in its response. If you want the model to generate diverse or creative text, you might want to use a higher presence penalty. Or, if you need the model to stay focused, try using a lower presence penalty",c,"",k);this.kK("llmFrequencyPenalty",0,"The frequency penalty applies a penalty on the next token proportional to how many times that token already appeared in the response and prompt. The higher the frequency penalty, the less likely a word will appear again. This setting reduces the repetition of words in the model response by giving tokens that appear more a higher penalty",c,"",k);this.kK("llmMaxNewTokens",1250,"The number of tokens the model generates by adjusting the max length. Specifying a max length helps you prevent long or irrelevant responses and control costs",c,"",k);this.oL("llmBehaviour","update",["append","update"],"Behaviour for the LLM when retriving new visualization",c,"",k);this.kK("llmIconTransparency",1,"Transparency for the LLM icon",c,"",k);this.xh("llmIconSize",50,"Size for the LLM icon",c,"",k);this.ck("llmPrompt","","Default value for the prompt",c,"",k);this.ck("prompt",false,"String use to call the LLM from initialization",c,"",k);this.JW("llmUseDev",false,"Flag to use dev service",c,"",k);this.Kc("llmStack",[],"Array to cache LLM questions",c,"",k);this.Kc("llmHeader",[],"Header as array",c,"",k);this.JW("llmUseCopilot",false,"Flag to use copilot to help with the prompt",c,"",k);this.oi("llmCodeExamples",false,"Flag to show the LLM code examples",c,"",k);this.JW("loadLLMDatasets",false,"Flag to load the LLM datasets from Website",c,"",k);this.xh("llmCodeExamples",40,"Number of example to generate",c,"",k);this.xh("llmCodeMaxSentences",6,"Maximum number of sentences to use in each example",c,"",k);c="Print";this.ss(c,"General print properties used in all graphs","AllGraphs",false);this.JW("cacheBase64",false,"Flag to cache image in meta data as Base64",c,"",k);this.oL("printType","download",["download","window"],"Type of printing when the camera icon in the UI is pressed. Download is to download the image while window is to save the image in a new browser window",c,"",k);this.xh("printMagnification",1,"Print Magnification to produce High Definition images",c,"",k);this.JW("printThumbnail",false,"Flag to print thumbnail",c,"",k);this.ck("saveFilename",false,"Filename to use when downloading the canvas as an image or as json. If not specified. the filename will be based on the target id of the canvas. cX- + canvas.targetId + extension",c,"",k);c="Effect";this.ss(c,"Effects for UI widgets","AllGraphs",false);this.oL("effect","none",["none","magic","puffIn","openDownLeft","openDownLeftOut","perspectiveDown","rotateDown","twisterInDown","puffOut","openDownRight","openDownRightOut","perspectiveUp","rotateUp","twisterInUp","vanishIn","openUpLeft","openUpLeftOut","perspectiveLeft","rotateLeft","swap","vanishOut","openUpRight","openUpRightOut","perspectiveRight","rotateRight","openDownLeftReturn","perspectiveDownReturn","openDownRightReturn","perspectiveUpReturn","openUpLeftReturn","perspectiveLeftReturn","openUpRightReturn","perspectiveRightReturn","slideDown","swashOut","tinRightOut","bombRightOut","boingInUp","spaceOutUp","slideUp","swashIn","tinLeftOut","bombLeftOut","boingOutDown","spaceOutRight","slideLeft","foolishIn","tinUpOut","spaceOutDown","slideRight","holeOut","tinDownOut","spaceOutLeft","slideDownReturn","tinRightIn","spaceInUp","slideUpReturn","tinLeftIn","spaceInRight","slideLeftReturn","tinUpIn","spaceInDown","slideRightReturn","tinDownIn","spaceInLeft"],"Effect used to show widgets Magic - Ver 1.3.0 - https://minimamente.com",c,"",k);this.ck("codeEffectIn","slideLeftReturn2","Code Effect In",c,"",k);this.ck("codeEffectOut","slideLeft","Code Effect Out",c,"",k);this.ck("customizerEffectIn","slideLeftReturn","Customize Effect In",c,"",k);this.ck("customizerEffectOut","slideUp2","Customizer Effect Out",c,"",k);this.ck("datafilterEffectIn","slideRightReturn","Data Filter Effect In",c,"",k);this.ck("datafilterEffectOut","slideRight","Data Filter Effect Out",c,"",k);this.ck("datatableEffectIn","slideDownReturn","Data Table Effect In",c,"",k);this.ck("datatableEffectOut","slideDown3","Data Table Effect Out",c,"",k);this.ck("motionEffectIn","swashIn","Motion Effect In",c,"",k);this.ck("motionEffectOut","holeOut","Motion Effect Out",c,"",k);this.ck("remoteEffectIn","holeIn","Remote Effect In",c,"",k);this.ck("remoteEffectOut","holeOut","Remote Effect Out",c,"",k);this.ck("toolbarEffectIn","holeIn","Toolbar Effect In",c,"",k);this.ck("toolbarEffectOut","holeOut","Toolbar Effect Out",c,"",k);this.ck("tooltipDivEffectIn","holeOut","Tooltip Div Effect In",c,"",k);this.ck("tooltipDivEffectOut","spaceInUp","Tooltip Div Effect Out",c,"",k);c="Animations and Visualization Transitions";this.ss(c,"Animation and visualization transition parameters","AllGraphs",false);this.lj("Animation",true,"animation for the graphs",c,"",k);this.lj("Transition",false,"transitions for the graphs",c,"",k);this.xh("transitionStep",30,"Steps for transition",c,"",k);this.xh("transitionStaggering",10,"Steps for transitionioning data objects",c,"",k);this.oL("transitionFunction","easeInOutQuad",["linear","easeInQuad","easeOutQuad","easeInOutQuad","easeInCubic","easeOutCubic","easeInOutCubic","easeInQuart","easeOutQuart","easeInOutQuart","easeInQuint","easeOutQuint","easeInOutQuint"],"Easing function for the transition",c,"",k);c="Events";this.ss(c,"Event parameters","AllGraphs",false);this.JW("disableEvents",false,"Flag to disable all events",c,"",k);this.JW("disableCode",false,"Flag to disable showing the code",c,"",k);this.JW("disableMenu",false,"Flag to disable showing the menu on right clicks",c,"",k);this.JW("disableToolbar",false,"Flag to disable showing the toolbar",c,"",k);this.JW("disableTooltipCallout",false,"Flag to disable the tooltip callouts",c,"",k);this.JW("disableDataTable",false,"Flag to disable showing data table",c,"",k);this.JW("disableChat",false,"Flag to disable chat with AI",c,"",k);this.JW("disableDataFilters",false,"Flag to disable showing data filters",c,"",k);this.JW("disableCustomizer",false,"Flag to disable the data explorer",c,"",k);this.JW("disableCanvas",false,"Flag to disable all canvas events",c,"",k);this.JW("disableDrag",false,"Flag to disable drag events in canvas",c,"",k);this.JW("disableKeys",false,"Flag to disable key binding events. This prevent some default browser shortcuts and it is system specific. Please see the Event section bellow",c,"",k);this.JW("disableShowShortcuts",true,"Flag to disable showing shortcuts",c,"",k);this.JW("disablePlusMinusKeys",true,"Flag to disable plus / minus key binding events",c,"",k);this.JW("disableUndoRedoKeys",true,"Flag to disable undo / redo key binding events",c,"",k);this.JW("disableDocument",false,"Flag to disable mousemove and mouseup in the document",c,"",k);this.JW("disableWindow",false,"Flag to disable resizing the canvas when the window is resized. ",c,"",k);this.JW("disableWheel",false,"Flag to disable wheel. ",c,"",k);this.JW("disableBeacon",false,"Flag to disable beacon. ",c,"",k);this.JW("playable",false,"Flag to make the plot playable if there are after rendering functions",c,"",k);this.JW("resizable",true,"Flag to disable resizing the canvas by dragging the mouse over the edges",c,"",k);this.JW("resizableX",true,"Flag to disable resizing the width of the canvas by dragging the mouse over the edges",c,"",k);this.JW("resizableY",true,"Flag to disable resizing the height of canvas by dragging the mouse over the edges",c,"",k);this.JW("movable",true,"Flag to disable moving the canvas by dragging the mouse from the move image in the toolbar",c,"",k);this.xh("maxSubMenus",25,"Maximum number of submenus in the context menus",c,"",k);this.lj("PrimaryMenus",false,"primary menus in toolbar",c,"",k);this.xh("maxItemMenuCheckbox",10,"Maximum number of items in a menu before it becomes a scroll box",c,"",k);this.JW("skipClick",false,"Flag to skip click events after a mouse down event in visualizations where there is a drag capabilities",c);this.xh("infoTimeOut",3000,"Time in milliseconds to wait between updates for the mouse over info to show up",c,"",k);this.xh("infoStartTime",new Date().getTime(),"Time in milliseconds to keep track of time",c);this.xh("infoTimeIn",50,"Time in milliseconds to start showing info after a mouse over",c,"",k);this.JW("broadcast",true,"Flag to enable broadcasting to other canvasXpress objects in the page",c,"",k);this.ck("broadcastGroup",false,"Group Id for canvas to broadcast to. If not specified then it broadcasts to all canvases",c,"",k);this.lj("MousePositionOnDrag",true,"mouse position when dragging in relation to the zero coordinate (top-right) of the canvas",c,"",k);this.oL("toolbarType","under",["over","under","fixed"],"Toolbar type",c,"",k);this.xh("toolbarSize",36,"Height for the toolbar in graphs",c,"",k);this.Kc("toolbarItems",["Save","Chat","History","Table","Tabs","Explore","Lasso","Customize","Password","Maximize"],"Array containing the items in the top toolbar. All items included by default",c,"",k);this.Kc("toolbarCodes",[],"Array containing the items in the left toolbar for language code. Options are: JSON, R, Python, Jupyter, Streamlit, Shiny, JSFiddle, CodePen. Leave empty to disable",c,"",k);this.Kc("toolbarFonts",[],"Array containing the items in the right toolbar for font families. Some examples are: American Typewriter, Andale Mono, Arial, Bradley Hand, Comic Sans MS, Courier, Monaco, Optima, Times New Roman, Trebuchet MS. Leave empty to disable",c,"",k);this.Kc("toolbarSchemes",[],"Array containing the items in the bottom toolbar for color schemes. Some examples are: Economist, GGPlot, Excel, PaulTol, BlackAndWhite, Solarized, Stata, Tableau, GGBlanket, CanvasXpress. Leave empty to disable",c,"",k);this.JW("lazyLoad",false,"Flag to load canvas only if shown in viewport",c,"",k);this.ck("hoverTemplate",false,"HTML string to use as template for the hover info",c,"",k);c="Grey Out";this.ss(c,"General grey out properties used in all graphs","AllGraphs",false);this.JW("highlightGreyOut",false,"Flag to add a grey overlay to the entire graph to create a subtle background effect. This ensures that when an element is highlighted on mouseover, it stands out with greater contrast and clarity",c,"",k);this.kK("highlightGreyOutTransparency",0.67,"The proportion of grey overlay to apply across the entire graph",c,"",k);c="Tooltip";this.ss(c,"Tooltip parameters","AllGraphs",false);this.kK("tooltipTransparency",null,"Transparency for the tooltip",c,"",k);this.rW("tooltipFont",false,"Color for the tooltip text if specified",c,"",k);this.rW("tooltipBackground",false,"Background color for the tooltip if specified",c,"",k);this.rW("tooltipBorder",false,"Border color for the tooltip if specifies",c,"",k);c="Data Selection";this.ss(c,"Parameters used to select data in all visualizations","AllGraphs",true);this.oL("selectionMode","highlight",["highlight","ghost","name","filter"],"Mode use to highlight selected data points in visualizations",c,"",k);this.rW("selection","rgb(255,0,0)","The color used for selected data points when selection mode is to be highlight",c,"",k);this.oL("selectionMetadata",false,[false],"Matadata (or factor) to use to display selected data points instead of the variable name. This metadata has to be in the data.z object. This property is only valid when the selectionMode is name and the visualization is a Scatter plot",c,"",k);this.Kc("selectedDataPoints",[],"Variable / Sample names of data points (in the data object) to initially select",c,"",k);c="Zooming, Panning and Resizing";this.ss(c,"Parameters associated with zooming, panning and resizing events","AllGraphs",false);this.kK("zoom",1,"Zoom factor for the networks. A number greater than zero",c,"",k);this.kK("zoomGlobal",1,"Cumulative zoom factor for the networks",c);this.kK("zoomStep",0.2,"Percentage step for zooming networks and genome panel",c,"",k);this.JW("zoomScale",true,"Flag to scale nodes and edges in networks with zoom and data points in 3D scatter plots",c,"",k);this.JW("zoomVariablesDisable",false,"Flag to disable zooming of variables with mouse wheel in Heatmaps",c,"",k);this.JW("zoomSamplesDisable",false,"Flag to disable zooming of samples with mouse wheel in Heatmaps",c,"",k);this.JW("zoomXDisable",false,"Flag to disable zooming of x axis with mouse wheel in Scatter plots",c,"",k);this.JW("zoomYDisable",false,"Flag to disable zooming of y axis with mouse wheel in Scatter plots",c,"",k);this.JW("zoomDisable",false,"Flag to disable zooming in all plots",c,"",k);this.kK("panningX",0,"Number of unit to pan the network in the X dimension",c,"",k);this.kK("panningY",0,"Number of unit to pan the network in the Y dimension",c,"",k);this.kK("panningGlobalX",0,"Cumulative number of unit to pan the network in the X dimension",c);this.kK("panningGlobalY",0,"Cumulative number of unit to pan the network in the Y dimension",c);this.kK("panningStep",0.2,"Percentage step for panning networks",c,"",k);this.rW("resizerBackground","rgba(204,204,204,0.7)","div that shows up when resizing the canvas",c,"",k);c="Motion Charts";this.ss(c,"General parameters in scatter plots","Scatter2Graphs",true);this.xh("motionWidth",250,"Size in pixels for the motion widget when used to reproduce user customizations",c,"",k);this.OS("motionCurrent","","rgb(0,0,0,0.3)",60,1,"center","middle",0,5,"motion charts",c,"",k);c="HTML Widgets";this.ss(c,"General parameters for filtering with external HTML widgets","AllGraphs",true);this.oL("htmlWidget",false,[false],"Name of a variable / sample annotation to filter the data with an external HTML widget. Changes are not reflected when the customizer is open",c,"",k,"getXZData2");this.oL("htmlWidgetType","auto",["auto","radio","dropdown","range"],"Type of HTML widget to use. Changes are not reflected when the customizer is open",c,"",k);this.xh("htmlWidgetHeight",120,"Height in pixels for the HTML widget. Changes are not reflected when the customizer is open",c,"",k);c="Data UI Widgets";this.ss(c,"Parameters associated with all data UI widgets","AllGraphs",false);this.oL("dataUIStyle","modern",[false,"stripped","modern","old","bms","rdc","ngs360"],"Style for the UI",c,"",k);this.rW("widgetsBackground","rgba(255, 255, 255, 0.95)","background all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsBase","rgb(83, 105, 255)","elements in all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsBorder","rgb(83, 105, 255)","border of all elements in all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.kK("widgetsHoverTransparency",0.2,"Transparency for the elements in all the UI widgets when mouse overs. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsAccent","rgba(83, 105, 255, 0.1)","accent elements in all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsContrast","rgb(83, 105, 255)","contrast elements in all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsStriped","rgba(83, 105, 255, 0.05)","stripe elements in the data table",c,"",k);this.rW("widgetsFont","rgb(34, 34, 34)","the elements in all the UI widgets. It only applied if the dataUIStyle is set to false",c,"",k);this.rW("widgetsIconClsA","#5369ff","class-a widget icons",c,"",k);this.rW("widgetsIconClsB","#292929","class-b widget icons",c,"",k);this.rW("widgetsIconClsC","#999999","class-c widget icons",c,"",k);this.rW("widgetsIconClsC","#ffffff","class-x widget icons",c,"",k);c="Data Customizer";this.ss(c,"Parameters associated with data customizer","AllGraphs",false);this.xh("maxDataCustomizerEntries",10000,"Maximum number of samples or variables to display in the data customizer",c,"",k);this.oL("customizerSize","medium",["xsmall","small","midsmall","medium","large"],"Size for the customizer. Requires re-opening of customizer",c,"",k);this.JW("customizerEntriesAsList",true,"Flag to show entries in scrolling widgets as text. The default is to show them as icons-like",c,"",k);this.JW("customizerGraphMaximize",false,"Flag to maximize the graph when the customizer is called",c,"",k);c="Data Table/Filter";this.ss(c,"Parameters associated with data table and data filter","AllGraphs",false);this.JW("skipConfigurableProperties",true,"Flag to exclude configurable parameters in the data table and the data filters in Networks and Genome Browser",c,"",k);this.Kc("nodesProperties",[],"Two dimensional array with object properties not at the root level for the nodes in the Network graph to include in the Data table and the data filter",c,"",k);this.Kc("edgesProperties",[],"Two dimensional array with object properties not at the root level for the edges in the Network graph to include in the Data table and the data filter",c,"",k);this.Kc("featuresProperties",[],"Two dimensional array with object properties not at the root level for the features in the Genome graph to include in the Data table and the data filter",c,"",k);c="Data Filters";this.ss(c,"Parameters associated with filtering","AllGraphs",false);this.xh("dataFilterWidth",300,"Size in pixels for the data filters",c,"",k);this.oL("filterType","and",["and","or"],"Type for the filter. Can be and or or",c,"",k);this.oL("filterMode","hide",["hide","color"],"Mode for the legend filters. Can be set to hide the data using transparency or to color the data points with the missingDataColor",c,"",k);this.JW("filterSkipNullKeys",false,"Flag to bypass filtering when a key is non existent in the data objects",c,"",k);this.JW("filterSkipNullValues",false,"Flag to bypass filtering when a value is null",c,"",k);this.Nm("filterVarBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter variables by their annotation included in the data.z object used in one dimensional plots. Used in the CanvasXpress UIs",c,"",k);this.Nm("filterSmpBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter samples by their annotation included in the data.x object used in one dimensional plots. Used in the CanvasXpress UIs",c,"",k);this.Nm("filterNodeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter nodes by their properties used in network graphs. Used in the CanvasXpress UIs",c,"",k);this.Nm("filterEdgeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter edges by their properties used in network graphs. Used in the CanvasXpress UIs",c,"",k);this.Nm("filterFeatureBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter features by their properties used in genome browser. Used in the CanvasXpress UIs",c,"",k);this.Nm("filterDataBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter data by their value in the data object used in oncoprints. Used in the CanvasXpress UIs",c,"",k);this.Kc("filterData",[],"Array of arrays with filtering functions. Each function takes four parameters. The fisrt parameter is the type of filter. This could either of: var, smp, series, meta, x, y, z, data, network or guess (if not known). The second parameter is the key that usually correspond to a sample or variable factor name in the x or z object of the data. The third parameter is the operator to use which is one of: >, >=, <, <=, between, exact, like or not like and the four parameter is an array with the value or values that are needed for the corresponding evaluation. Here are some examples: [ x, class, exact, [ A ] ], [ guess, dose, between, [ 0.5, 2 ] ]",c,"",k);c="Data Table";this.ss(c,"Parameters associated with the data table","AllGraphs",false);this.JW("dataTableTransposed",true,"Flag to transpose the data in the data table",c,"",k);this.xh("maxRows",10,"Maximum number of rows to display in the data table",c,"",k);this.xh("maxCols",10,"Maximum number of columns to display in the data table",c,"",k);this.xh("colWidth",100,"Number of pixels for the width of cells in the data table",c,"",k);this.xh("rowHeight",26,"Number of pixels for the height of cells in the data table",c,"",k);this.xh("rowLines",1,"Number of lines in cells in the data table",c,"",k);this.JW("refresehDataTableOnDraw",false,"Flag to refresh data after drawing the plot",c,"",k);this.lj("DataTableOnSelect",false,"Flag to show data after selecting data in the plot",c,"",k);this.oL("networkShowDataTable","nodes",["nodes","edges"],"Show nodes or edges on data table",c,"",k);this.kK("colorDataTableTransparency",0.5,"Transparency for the background of the data table cells if colored",c,"",k);this.xh("startCol",0,"Starting column in the data table",c);this.xh("startRow",0,"Starting row in the data table",c);this.xh("totalCols",null,"Total columns in the data table",c);this.xh("totalRows",null,"Total rows in the data table",c);this.ck("dataTableImage",false,"Image to brand the data table",c,"",k);this.Kv("dataTableRowProperties",{},"Properties for the rows in the data table. Key is the variable name and the value is the height in pixels",c,"",k);this.Kv("dataTableColProperties",{},"Properties for the cols in the data table. Key is the sample name and the value is the width in pixels",c,"",k);this.Kv("dataTableColMetadata",{},"Metadata for the cols in the data table. Key is the sample name and the value is the column info",c,"",k);this.Kc("dataTableColHide",[],"Array to store the columns to hide in the data table",c,"",k);this.Kc("dataTableColOrder",[],"Array to store the column sorting for the data table. It only applies to meta data and exclude variables or samples. Those not included willl be placed last",c,"",k);this.Kc("dataTableRowOrder",[],"Array to store the row sorting for the data table. It only applies to meta data and exclude variables or samples. Those not included willl be placed last",c,"",k);this.Kc("dataTableColumnWidth",[],"Array to store the column width for the data table",c);this.Kc("dataTableRowHeight",[],"Array to store the row height for the data table",c);this.JW("dataTableAutoColumnWidth",true,"Flag to calculate the width of the columns based on the header at load time",c,"",k);this.JW("colorDataTable",false,"Flag to color the data table",c,"",k);this.oL("dataTableBorders","rows",["all","none","rows","cols"],"data table borders",c,"",k);this.rW("dataTableBorder","rgb(204, 204, 204)","border of the data table cells",c,"",k);this.oi("dataTableHeaderBorders",true,"Flag to show the borders in the data table headers. The color of the border will be the same as that used for the base color of the UI widgets",c,"",k);this.oi("dataTableStripe",true,"Flag to show the stripes in the data table rows",c,"",k);this.kK("dataTableStripeTransparency",0.05,"Transparency for the stripes in the data table using the base color for the UI widgets",c,"",k);this.ck("dataTableZeroHeader","","Name for the first column in the data table",c,"",k);this.JW("dataTableCellLinkUnderline",true,"Flag to underline url or anchor links in cells in the data table",c,"",k);c="Debug";this.ss(c,"Debugging parameters","AllGraphs",false);this.Kc("errors",[],"Array containing benign errors produced when rendering canvasXpress",c);this.JW("debug",false,"Flag to turn on alerts",c,"",k);this.JW("debugWithArea",false,"Flag to render object areas when debugging",c,"",k);this.JW("verbose",false,"Flag to turn on/off verbose",c,"",k);this.JW("offline",false,"Flag to work offline",c,"",k);this.lj("Version",true,"version when mouse over top-left corner of the canvas",c,"",k);this.lj("Code",false,"code for the canvas",c,"",k);this.oL("codeType","params",["pretty","compact","tab","params"],"Output type for the JSON code",c,"",k)};this.Wy=function(){var a=this.ZM(this.iconClsA,false,true);var b=this.ZM(this.iconClsB,false,true);var c=this.ZM(this.iconClsC,false,true);var x=this.ZM(this.iconClsX,false,true);var q={cxtxa:"{f:none;s:"+a+";w:4px;}",cxa0:" {w:0px;f:"+a+";}",cxc0:"{w:0px;f:"+c+";}",cxa1:" {l:10;w:3px;f:none;s:"+a+";}",cxa:" {l:10;w:4px;f:none;s:"+a+";}",cxa2:"{l:10;w:1px;f:"+a+";s:"+a+";}",cxa3:"{l:10;w:1px;f:none;s:"+a+";}",cxb:"{l:10;w:4px;f:none;s:"+b+";}",cxb2:"{l:10;w:1px;f:"+b+";s:"+b+";}",cxb3:"{l:10;w:1px;f:none;s:"+b+";}",cxc:"{l:10;w:4px;f:none;s:"+c+";}",cxaa:"{s:"+a+";f:"+a+";}",cxbb:"{s:"+b+";f:"+b+";}",cxcc:"{s:"+c+";f:"+c+";}",cxab:"{s:"+a+";f:"+b+";}",cxac:"{s:"+a+";f:"+c+";}",cxbc:"{s:"+b+";f:"+c+";}",cxaw:"{l:10;w:3px;s:"+a+";f:#ffffff;}",cxbw:"{l:10;w:3px;s:"+b+";f:#ffffff;}",cxxx:"{w:15px;s:"+x+";f:none;}",cxblue:"{s:"+a+";w:5px;}"};for(var i in q){CanvasXpress.icons.classes[i]=q[i]}};this.No=function(){var root=document.documentElement;var getProp=function(p){return getComputedStyle(root).getPropertyValue(p)};var setProp=function(p,v){root.style.setProperty(p,v)};this.red=getProp("--cx-color-red");this.blue=getProp("--cx-color-blue");this.green=getProp("--cx-color-green");this.yellow=getProp("--cx-color-yellow");this.orange=getProp("--cx-color-orange");this.purple=getProp("--cx-color-purple");this.white=getProp("--cx-color-white");this.gray=getProp("--cx-color-gray");this.black=getProp("--cx-color-black");this.transparent=getProp("--cx-color-transparent");this.fontFamily=getProp("--cx-font-family");this.transparentBorder=getProp("--cx-border-transparent");switch(this.dataUIStyle){case"modern":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(83, 105, 255)";this.hoverWidgetsColor="rgba(83,105,255, 0.2) ";this.accentWidgetsColor="rgba(83, 105, 255, 0.1)";this.contrastWidgetsColor="rgb(83, 105, 255)";this.iconClsA="#5369ff";this.iconClsB="#292929";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(83, 105, 255, 0.05)";this.dataTableHeaderBordersShow=true;break;case"stripped":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(204, 204, 204)";this.hoverWidgetsColor="rgb(204, 204, 204, 0.6)";this.accentWidgetsColor="rgb(204, 204, 204, 0.4)";this.contrastWidgetsColor="rgb(123, 123, 123)";this.iconClsA="#000000";this.iconClsB="#454545";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(0, 0, 0, 0.05)";this.dataTableHeaderBordersShow=false;break;case"old":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(204, 204, 204) ";this.hoverWidgetsColor="rgb(204, 204, 204, 0.6)";this.accentWidgetsColor="linear-gradient(rgb(240, 240, 240), rgb(230, 230, 230))";this.contrastWidgetsColor="rgb(123, 123, 123)";this.iconClsA="#000000";this.iconClsB="#454545";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(0, 0, 0, 0.05)";this.dataTableHeaderBordersShow=false;break;case"bms":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(189, 184, 184)";this.hoverWidgetsColor="rgb(190, 43, 187, 0.1)";this.accentWidgetsColor="rgb(190, 43, 187, 0.6)";this.contrastWidgetsColor="rgb(190, 43, 187)";this.iconClsA="#BE2BBB";this.iconClsB="#595454";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(190, 43, 187, 0.05)";this.dataTableHeaderBordersShow=false;break;case"rdc":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(255, 255, 255)";this.hoverWidgetsColor="rgba(42,106,220,0.2)";this.accentWidgetsColor="rgba(42,106,220,0.1)";this.contrastWidgetsColor="rgb(42,106,220)";this.iconClsA="#2A6ADC";this.iconClsB="#292929";this.iconClsC="#999999";this.iconClsX="#2A6ADC";this.widgetsStripedColor="rgb(227, 242, 253)";this.dataTableHeaderBordersShow=false;break;case"ngs360":this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(240, 240, 240)";this.hoverWidgetsColor="rgb(204, 204, 204, 0.6)";this.accentWidgetsColor="linear-gradient(rgb(240, 240, 240), rgb(230, 230, 230))";this.contrastWidgetsColor="rgb(123, 123, 123)";this.iconClsA="#000000";this.iconClsB="#454545";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(0, 0, 0, 0.05)";this.dataTableHeaderBordersShow=false;break;default:this.fontWidgetsSize=this.fontSize+"px";this.fontWidgetsColor=this.widgetsFontColor;this.backgroundWidgetsColor=this.widgetsBackgroundColor;this.baseWidgetsColor=this.widgetsBaseColor;this.hoverWidgetsColor=this.widgetsBaseColor.replace(")",", "+this.widgetsHoverTransparency+")").replace("rgb","rgba");this.accentWidgetsColor=this.widgetsAccentColor;this.contrastWidgetsColor=this.widgetsContrastColor;this.iconClsA=this.widgetsIconClsAColor;this.iconClsB=this.widgetsIconClsBColor;this.iconClsC=this.widgetsIconClsCColor;this.iconClsX=this.white;break}this.borderWidgets="1px solid "+this.widgetsBorderColor;this.Wy();setProp("--cx-font-size",this.fontWidgetsSize);setProp("--cx-font-color",this.fontWidgetsColor);setProp("--cx-color","normal "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-color-bold","bold "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-color-italic","italic "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-background-widgets-color",this.backgroundWidgetsColor);setProp("--cx-background-color",this.baseWidgetsColor);setProp("--cx-background-hover-color",this.hoverWidgetsColor);setProp("--cx-background-border-hover-color",this.iconClsX);setProp("--cx-background-accent-color",this.accentWidgetsColor);setProp("--cx-background-contrast-color",this.contrastWidgetsColor);setProp("--cx-border",this.borderWidgets)};this.PF=function(){var fs=["fontSize","titleFontSize","subtitleFontSize","smpTitleFontSize","smpTextFontSize","varTitleFontSize","varTextFontSize","overlayTextFontSize","dataTextFontSize","legendTextFontSize","legendTitleFontSize","decorationsTextFontSize","xAxisTextFontSize","xAxisTitleFontSize","yAxisTextFontSize","yAxisTitleFontSize","zAxisTextFontSize","zAxisTitleFontSize","rAxisTextFontSize","rAxisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var i=0;i<fs.length;i++){if(CanvasXpress.doc.P[fs[i]]){this[fs[i]]=Number(CanvasXpress.doc.P[fs[i]].D)}}this.cr()};this.cr=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpTextFont=this.smpTextFontStyle+" "+this.smpTextFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varTextFont=this.varTextFontStyle+" "+this.varTextFontSize+"px "+this.fontName;this.dataTextFont=this.dataTextFontStyle+" "+this.dataTextFontSize+"px "+this.fontName;this.overlayTextFont=this.overlayTextFontStyle+" "+this.overlayTextFontSize+"px "+this.fontName;this.legendTextFont=this.legendTextFontStyle+" "+this.legendTextFontSize+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+this.legendTitleFontSize+"px "+this.fontName;this.decorationsTextFont=this.decorationsTextFontStyle+" "+this.decorationsTextFontSize+"px "+this.fontName;this.stripTextFont=this.stripTextFontStyle+" "+this.stripTextFontSize+"px "+this.fontName;this.xAxisTextFont=this.xAxisTextFontStyle+" "+this.xAxisTextFontSize+"px "+this.fontName;this.xAxisTitleFont=this.xAxisTitleFontStyle+" "+this.xAxisTitleFontSize+"px "+this.fontName;this.yAxisTextFont=this.yAxisTextFontStyle+" "+this.yAxisTextFontSize+"px "+this.fontName;this.yAxisTitleFont=this.yAxisTitleFontStyle+" "+this.yAxisTitleFontSize+"px "+this.fontName;this.zAxisTextFont=this.zAxisTextFontStyle+" "+this.zAxisTextFontSize+"px "+this.fontName;this.zAxisTitleFont=this.zAxisTitleFontStyle+" "+this.zAxisTitleFontSize+"px "+this.fontName;this.rAxisTextFont=this.rAxisTextFontStyle+" "+this.rAxisTextFontSize+"px "+this.fontName;this.rAxisTitleFont=this.rAxisTitleFontStyle+" "+this.rAxisTitleFontSize+"px "+this.fontName;this.sankeyTitleFont=this.sankeyTitleFontStyle+" "+this.sankeyTitleFontSize+"px "+this.fontName;this.sankeyTextFont=this.sankeyTextFontStyle+" "+this.sankeyTextFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName;this.topMarginalTextFont=this.topMarginalTextFontStyle+" "+this.topMarginalTextFontSize+"px "+this.fontName;this.bottomMarginalTextFont=this.bottomMarginalTextFontStyle+" "+this.bottomMarginalTextFontSize+"px "+this.fontName;this.leftMarginalTextFont=this.leftMarginalTextFontStyle+" "+this.leftMarginalTextFontSize+"px "+this.fontName;this.rightMarginalTextFont=this.rightMarginalTextFontStyle+" "+this.rightMarginalTextFontSize+"px "+this.fontName};this.FX=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var o in this.meta.config.user){if(this.isPivot){if(o=="groupingFactors"||o=="summaryType"){continue}}if(CanvasXpress.doc.P[o]&&CanvasXpress.doc.P[o].hasOwnProperty("T")){if(CanvasXpress.doc.P[o].T=="integer"||CanvasXpress.doc.P[o].T=="float"){this.meta.config.user[o]=this.meta.config.user[o]===null?null:Number(this.meta.config.user[o])}this[o]=this.meta.config.user[o]}else{this[o]=this.meta.config.user[o]}}this.T5();if(String(this.scatterType).match(/line|bar|dot|area|boxplot/)&&!this.is3DPlot&&this.graphType!="Scatter3D"&&!this.isCxplot){this.scatterContext=this.graphType;this.graphType="Scatter2D"}}};this.s5=function(a){var o={};if(a){for(var i=0;i<a.length;i++){o[a[i]]=this[a[i]]}}this.Wk();for(var i in o){this[i]=o[i]}};this.CZ=function(o,n){if(o){var p=this.Ev(o);if(o.groupingFactors&&this.groupingFactors.length){if(!this.eI(o.groupingFactors,this.groupingFactors)){this.Ab(!n)}}if(o.sortData){for(var i=0;i<o.sortData.length;i++){this.zd(o.sortData[i][0],o.sortData[i][1],o.sortData[i][2],!n,false,false,true)}o.sortData=[]}this.meta.config.user=o;for(var i in o){this[i]=o[i]}this.T5();if(this.xAxisTime||this.yAxisTime||this.yAxis.length){this.I1()}if(this.filterData&&this.filterData.length){for(var i=0;i<this.filterData.length;i++){this.iy(this.filterData[i][0],this.filterData[i][1],this.filterData[i][2],this.filterData[i][3],i==this.filterData.length-1?false:true)}}if(!n){this.Oj({func:"updateConfig",par:[p,n]})}}};this.n8=function(o){if(o){for(var i in o){this[i]=o[i]}}};this.Ei=function(a){var that=this;var o={};var k=CanvasXpress.config.sort();var skip={colors:true,shapes:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true};var cols={background:true,foreground:true};if(this.isTransformedData){o.isTransformedData=this.isTransformedData}for(var i=0;i<k.length;i++){var j=k[i];if(j.match(/FontSize$/)){continue}if(this.defaultThemeValues.hasOwnProperty(j)&&this.defaultThemeValues[j]==this[j]){continue}if(CanvasXpress.doc.P[j]&&CanvasXpress.doc.P[j].hasOwnProperty("D")){var d=j.match(/groupingFactors|segregate/)?[]:CanvasXpress.doc.P[j].D;if(skip.hasOwnProperty(j)){continue}var v=that[j]===undefined?false:that[j];if(typeof(v)=="object"){if(d=="[]"){d=[]}if(d=="{}"){d={}}if(v===null){if(d!=null){o[j]=v}}else{if(j=="sizes"){if(!this.eI(v,d.map(Number))){o[j]=v}}else{if(j=="colorSpectrum"||j=="colors"){var t=[];for(var c=0;c<v.length;c++){var tc=this.ZM(v[c],false,true);if(tc){t.push(tc.toLowerCase())}}if(!this.eI(t,d)){o[j]=v}}else{if(j.match("filter")){if(!this.eI(v,d)){o[j]=v}}else{if(!this.eI(v,d)){o[j]=v}}}}}}else{if(j.match(/Color/)||cols.hasOwnProperty(j)){if(this.ZM(v)!=this.ZM(d)){o[j]=v}}else{if(d!=null&&d.toString().match(/false|true|null/)){if(j=="summaryType"&&v=="raw"){continue}else{if(v.toString()!=d.toString()){o[j]=v}}}else{if(v!=d){o[j]=v}}}}}}if(o.backgroundImage&&o.backgroundImage.match(/javascript:\/\//)){if(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]]){o.backgroundImageSrc=btoa(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]].replace("data:image/png;base64,",""))}}if(a){for(var i=0;i<a.length;i++){o[a[i]]=this[a[i]]}}o.graphType=this.graphType;return o};this.TO=function(){return this.meta.config.user};this.ZO=function(o){if(o){for(var i in o){var e=o[i];e=e.substring(10,e.length-2).replace(/&quot;/g,'"');this.events[i]=eval("("+e+")")}}};this.Ae=function(id){var c=this.$(id);if(!c||c.tagName.toLowerCase()!="canvas"){c=this.$cX("canvas",{id:id});window.body.appendChild(c)}return this.lg(c)};this.S3=function(){var dpr=window.devicePixelRatio||1;var ctx=this.lg(this.$cX("canvas"));var bsr=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=dpr/bsr};this.yr=function(canvas,dpi){canvas.style.width=canvas.style.width||canvas.width+"px";canvas.style.height=canvas.style.height||canvas.height+"px";var scaleFactor=dpi/96;var width=parseFloat(canvas.style.width);var height=parseFloat(canvas.style.height);var oldScale=canvas.width/width;var backupScale=scaleFactor/oldScale;var backup=canvas.cloneNode(false);this.lg(backup).drawImage(canvas,0,0);var ctx=this.lg(canvas);canvas.width=Math.ceil(width*scaleFactor);canvas.height=Math.ceil(height*scaleFactor);ctx.setTransform(backupScale,0,0,backupScale,0,0);ctx.drawImage(backup,0,0);ctx.setTransform(scaleFactor,0,0,scaleFactor,0,0)};this.gW=function(){var c=this.$(this.target);var p=this.meta.canvas.canvasPixelRatio;if(c){this.S3();this.zy();this.meta.canvas.ctx=this.lg(c);this.meta.canvas.ctx.setTransform(p,0,0,p,0,0);this.meta.canvas.ctx.o=[];this.meta.canvas.ctx.render=function(p){var l=this.o.length;for(var i=0;i<l;i++){var o=this.o[i];var funcs=o.funcs;for(var j in o){if(j!=="funcs"){this[j]=o[j]}}if(funcs){var ll=funcs.length;for(var j=0;j<ll;j++){var f=funcs[j];var f0=f[0];if(this[f0]){this[f0].apply(this,f[1])}if(p){var t=this.getTransform().a;if(t!=p){this.setTransform(p,0,0,p,0,0)}}}}}};this.meta.canvas.ctx.resetRender=function(){this.o=[]};this.meta.canvas.ctx.resetContext=function(){this.direction="ltr";this.fillStyle="#000000";this.filter="none";this.font="10px sans-serif";this.fontKerning="auto";this.fontStretch="normal";this.fontVariantCaps="normal";this.globalAlpha=1;this.globalCompositeOperation="source-over";this.imageSmoothingEnabled=true;this.imageSmoothingQuality="low";this.letterSpacing="0px";this.lineCap="butt";this.lineDashOffset=0;this.lineJoin="miter";this.lineWidth=1;this.miterLimit=10;this.shadowBlur=0;this.shadowColor="rgba(0, 0, 0, 0)";this.shadowOffsetX=0;this.shadowOffsetY=0;this.strokeStyle="#000000";this.textAlign="start";this.textBaseline="alphabetic";this.textRendering="auto";this.wordSpacing="0px"}}};this.lg=function(canvas){return canvas.getContext("2d")};this.us=function(){var c=this.isSVG?this.meta.canvas.SVG:this.isHighlightCanvas?this.meta.canvas.ctx2:this.meta.canvas.ctx;this.currentCanvasContext=c.canvas.id;return c};this.zy=function(){setTimeout(function(){var c=new RegExp("/www.canvasxpress.org/dist/");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){if(scripts[i].src&&c.test(scripts[i].src)){CanvasXpress.factory.siteSrc=true}}},0)};this.RW=function(){var c=CanvasXpress.system;c.isR=this.isR;c.isHTMLWidgets=typeof HTMLWidgets!="undefined";c.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;c.isRViewer=/\bviewer_pane=1\b/.test(window.location);c.isRConsole=c.isHTMLWidgets&&!c.isShiny&&!c.isRViewer;c.isNode=typeof exports==="object"&&typeof module!=="undefined";c.isReact=typeof React!="undefined";c.isCxplot=this.isCxplot;c.isGGMatrix=this.isGGMatrix;c.isjQuery=typeof $==="function";c.isJupyter=typeof _JUPYTERLAB!="undefined";c.isReveal=typeof Reveal!="undefined";c.isZoom=typeof zoom!="undefined"};this.Lg=function(){if(CanvasXpress.system.isJupyter){this.isJupyter=true}};this.sM=function(images){for(var i=0;i<images.length;i++){images[i].style.transform="scale("+(1/Reveal.getScale())+")";images[i].style.margin="auto"}};this.B7=function(divs){for(var i=0;i<divs.length;i++){divs[i].parentNode.style.overflowX="unset";divs[i].style.transform="scale("+(1/Reveal.getScale())+")";divs[i].style.magin="auto"}};this.st=function(){var that=this;if(CanvasXpress.system.isReveal&&!window.RevealCanvasXpress){var images=document.querySelectorAll("img.CanvasXpress");that.sM(images);var canvases=document.querySelectorAll("canvas.CanvasXpress");for(var i=0;i<canvases.length;i++){canvases[i].parentNode.parentNode.style.overflowX="unset";canvases[i].parentNode.style.transform="scale("+(1/Reveal.getScale())+")";canvases[i].parentNode.style.margin="auto";canvases[i]["data-responsive"]=true;canvases[i]["data-aspectRatio"]=parseInt(canvases[i].clientWidth)+":"+parseInt(canvases[i].clientHeight);if(canvases[i].hasAttribute("data-src")&&canvases[i].id){new CanvasXpress({renderTo:canvases[i].id,data:canvases[i].getAttribute("data-src")})}}Reveal.addEventListener("slidechanged",function(event){var images=Reveal.getCurrentSlide().querySelectorAll("img.CanvasXpress");that.sM(images);var canvases=Reveal.getCurrentSlide().querySelectorAll("canvas.CanvasXpress");if(canvases.length){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.B7(divs)}});Reveal.addEventListener("dblclick",function(event){var target=event.target;if(!target.id){target.id="foobar"}if(target.tagName.toLowerCase()=="img"&&that.X0(target,"CanvasXpress")){var id=that.DW("-cX-Reveal-"+target.id+"-");var cnv=document.createElement("canvas");cnv.id=id;cnv.width=target.clientWidth;cnv.height=target.clientHeight;cnv["data-responsive"]=true;cnv["data-aspectRatio"]=parseInt(target.clientWidth)+":"+parseInt(target.clientHeight);target.parentNode.insertBefore(cnv,target.nextSibling);target.style.display="none";new CanvasXpress({renderTo:id,data:target.src,callback:function(){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.B7(divs)}})}});window.RevealCanvasXpress=true}};this.mh=function(){if(String(this.graphType).match(/line|bar|dot|area|boxplot/i)&&!this.is3DPlot&&this.graphType!="Scatter3D"){var s=false;if(!this.xAxis.length&&!this.yAxis.length){if((this.lineBy&&this.data.z&&this.dataz.hasOwnProperty(this.lineBy))||(this.colorBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorBy))){s=true}}else{if(this.xAxis.length&&this.yAxis.length){if(this.data.y.smps.includes(this.xAxis[0])&&this.data.y.smps.includes(this.yAxis[0])){s=true}}}if(s){this.I1()}}};this.SC=function(){if(this.graphName){for(var p in this.graphName){this[p]=this.graphName[p]}}};this.T5=function(){switch(this.graphType){case"Alluvial":this.graphName={graphType:this.graphType};this.graphType="Sankey";return;case"Bin":case"Binplot":this.graphName={graphType:this.graphType,binplotShape:this.binplotShape,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="bin2d";this.binplotShape="oval";return;case"Bubble":this.graphName={graphType:this.graphType,circularType:this.circularType};this.graphType="Circular";this.circularType="bubble";return;case"Bullet":this.graphName={graphType:this.graphType,barType:this.barType};this.graphType="Bar";this.barType="bullet";return;case"Bump":this.graphName={graphType:this.graphType,isBumpPlot:this.isBumpPlot,lineBy:this.lineBy,colorBy:this.colorBy,dataPointSize:this.dataPointSize};this.graphType="Scatter2D";this.isBumpPlot=true;this.lineBy=this.lineBy||this.colorBy;this.colorBy=this.lineBy;this.dataPointSize=25;return;case"CDF":this.graphName={graphType:this.graphType,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="cdf";return;case"Chord":this.graphName={graphType:this.graphType,circularType:this.circularType};this.graphType="Circular";this.circularType="chord";return;case"Cleveland":this.graphName={graphType:this.graphType,dotplotType:this.dotplotType};this.graphType="Dotplot";this.dotplotType="cleveland";return;case"Contour":this.graphName={graphType:this.graphType,isContour:this.isContour};this.graphType="Scatter2D";this.isContour=true;return;case"Density":this.graphName={graphType:this.graphType,showHistogramBars:this.showHistogramBars,showFilledHistogramDensity:this.showFilledHistogramDensity,showHistogram:this.showHistogram,showHistogramDensity:this.showHistogramDensity};this.graphType="Scatter2D";this.showFilledHistogramDensity=true;this.showHistogram=this.showHistogram||true;this.showHistogramDensity=true;return;case"Donut":this.graphName={graphType:this.graphType,circularType:this.circularType};this.graphType="Circular";this.circularType="sunburst";return;case"Dumbbell":this.graphName={graphType:this.graphType,dotplotType:this.dotplotType};this.graphType="Dotplot";this.dotplotType=this.dumbbellType||"stacked";return;case"Hex":case"Hexplot":this.graphName={graphType:this.graphType,binplotShape:this.binplotShape,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="bin2d";this.binplotShape="hexagon";return;case"Histogram":case"Distribution":this.graphName={graphType:this.graphType,showHistogramBars:this.showHistogramBars,showHistogram:this.showHistogram};this.graphType="Scatter2D";this.showHistogramBars=true;this.showHistogram=this.showHistogram||true;return;case"KaplanMeier":this.graphName={graphType:this.graphType,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="km";return;case"Lollipop":this.graphName={graphType:this.graphType,barType:this.barType};this.graphType="Bar";this.barType="lollipop";return;case"Pareto":this.graphName={graphType:this.graphType};this.graphType="BarLine";return;case"QQ":case"Quantile":this.graphName={graphType:this.graphType,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="qq";return;case"Radar":this.graphName={graphType:this.graphType,circularType:this.circularType};this.graphType="Circular";this.circularType="radar";return;case"Ridgeline":this.graphName={graphType:this.graphType,showHistogramBars:this.showHistogramBars,showFilledHistogramDensity:this.showFilledHistogramDensity,showHistogram:this.showHistogram,showHistogramDensity:this.showHistogramDensity};this.graphType="Scatter2D";this.showFilledHistogramDensity=true;this.showHistogram=true;this.showHistogramDensity=true;return;case"Spaghetti":this.graphName={graphType:this.graphType,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="line";return;case"SPLOM":this.graphName={graphType:this.graphType,scatterPlotMatrix:this.scatterPlotMatrix};this.graphType="Scatter2D";this.scatterPlotMatrix=true;return;case"Streamgraph":this.graphName={graphType:this.graphType,scatterType:this.scatterType,dataPointSizeScaleFactor:this.dataPointSizeScaleFactor};this.graphType="Scatter2D";this.scatterType="stream";this.dataPointSizeScaleFactor=0;return;case"Sunburst":this.graphName={graphType:this.graphType,circularType:this.circularType};this.graphType="Circular";this.circularType="sunburst";return;case"Ribbon":this.graphName={graphType:this.graphType};this.graphType="Sankey";return;case"TimeSeries":case"Time-Series":case"Time Series":this.graphName={graphType:this.graphType,scatterType:this.scatterType};this.graphType="Scatter2D";this.scatterType="line";this.xAxisTime=true;return;case"Tornado":this.graphName={graphType:this.graphType};this.graphType="Stacked";return;case"Upset":this.graphName={graphType:this.graphType,heatmapType:this.heatmapType};this.graphType="Heatmap";this.heatmapType="upset";return;case"Violin":this.graphName={graphType:this.graphType,showViolinBoxplot:this.showViolinBoxplot};this.graphType="Boxplot";this.showViolinBoxplot=true;return;case"Volcano":this.graphName={graphType:this.graphType};this.graphType="Scatter2D";return;case"Waterfall":this.graphName={graphType:this.graphType};this.graphType="Bar";return;case"WordCloud":this.graphName={graphType:this.graphType};this.graphType="TagCloud";return;default:return}};this.I1=function(){if(String(this.graphType).match(/line|bar|dot|area|boxplot/i)&&!this.is3DPlot&&this.graphType!="Scatter3D"&&!this.isCxplot){var type=this.graphType.toLowerCase().replace(/dotplot/,"dot");this.scatterType=type;this.scatterContext=this.graphType;this.graphType="Scatter2D"}};this.e0=function(config){CanvasXpress.config=[];this.Wk();if(config&&config.graphType){this.graphType=config.graphType}if(this.graphType.match(/Network/)){this.xRotate=0}var k=config?Object.keys(config):[];var x=0;for(var i=0;i<k.length;i++){if(k[i].match(/^remote/)){x++;if(k[i]=="remoteData"||k[i]=="remoteIds"){this[k[i]]=config[k[i]]}}}if(!config||(config&&!config.graphOrientation&&x!=k.length)){if(config&&config.graphType&&config.graphType.match(/Scatter/)){}else{if(this.meta.config.user){this.meta.config.user.graphOrientation=this.graphOrientation}}}if(config&&config.plotStyle&&!CanvasXpress.doc.P.plotStyle.O.includes(config.plotStyle)){config.theme=config.plotStyle;delete config.plotStyle}if(config&&config.graphType&&config.graphType=="Pie"&&config.xAxis&&config.xAxis.length==1){config.pieBy=config.xAxis[0];config.xAxis=[]}this.fQ(config&&config.theme?config.theme:"none");if(config){if(!window.cX){CanvasXpress.factory.valid=config.cX;window.cX=CanvasXpress.factory.valid}for(var i in config){if(CanvasXpress.doc.P[i]&&CanvasXpress.doc.P[i].D==null&&config[i]===""){delete config[i]}}if(config.hasOwnProperty("skipRender")){this.skipRender=config.skipRender}if(!config.graphType||config.graphType.match(/Scatter|Map/)){this.dataTableTransposed=false}for(var i=0;i<CanvasXpress.config.length;i++){var o=CanvasXpress.config[i];var t=CanvasXpress.doc.P[o]?CanvasXpress.doc.P[o].T:false;if(config.hasOwnProperty(o)){if(t=="array"){if(config[o] instanceof Array){this[o]=config[o]}else{this[o]=[config[o]];config[o]=[config[o]]}}else{this[o]=config[o]}}}}this.T5();if(String(this.scatterType).match(/line|bar|dot|area|boxplot/)&&!this.is3DPlot&&this.graphType!="Scatter3D"&&!this.isCxplot){this.scatterContext=this.graphType;this.graphType="Scatter2D"}this.cr();this.No();for(var p in this.url){if(this.hasOwnProperty(p)){this[p]=this.url[p]}}this.gW();this.RW();this.st();this.Lg();window.pcX={};if(CanvasXpress.system.isShiny){this.disableUndoRedoKeys=true}if(CanvasXpress.factory.cXLLMService){this.llmServiceURL=CanvasXpress.factory.cXLLMService}}};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",year:"yyyy",yearMonth:"mmm yyyy",month:"mmmm",day:"dddd",hour:"HH",minute:"MM",second:"ss"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.uo=function(b){return !isNaN(new Date(b))};this.dateFormat=a};CanvasXpress.prototype.initText=function(){this.vL=function(C,A,z,a,D,u,p,v,j,w,d,g,B){if(C==undefined){C=""}var q=["poly"];var o=this.Dr(p);var j=this.r9(C,p,B)*(Math.PI*0.5)/a;D=(D+(u/2))-(j/2)%(Math.PI*2);u=D+j;var n=this.BC(A,z,a,D,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.BC(A,z,a-o,D,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.nJ(q)}else{return q}};this.yY=function(k,j,h,p,n,B,A,C,v,D,q,d,u){if(k==undefined){k=""}if(!u){u=this.us()}if(k==null){return}if(!u){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(j)||isNaN(h)){if(this.debug){alert("Not a valid coordinate ("+j+", "+h+") to draw "+k)}return}if(!d&&!isNaN(k)){k=this.ct(k)}k=k.toString().replace("\x00","");if(!j){j=0}if(!h){h=0}if(!A){A=this.font}if(!C){C=this.foreground}if(!v){v=this.align}if(!D){D=this.baseline}this.WF(u);var o={strokeStyle:(this.Hl(C)?C[0]:C),fillStyle:(this.Hl(C)?C[0]:C),font:A,textAlign:v,textBaseline:D,funcs:[]};var z=v=="right"?1:-1;var a=this.Dr(A);if(((["left","center"].indexOf(v)>-1)&&q)||(v=="right"&&!q)){k=k.split("").reverse().join("");if(this.Hl(C)){C=C.reverse()}}o.funcs.push(["translate",[j,h]]);n+=(Math.PI*!q);n+=(Math.PI/2)+(B/2);if(v=="center"){for(var w=0;w<k.length;w++){var g=this.r9(k[w],A,u);n+=((g+(w==k.length-1?0:this.circularLetterSeparationFactor))/(p-a))/2*-z}}B=n;o.funcs.push(["rotate",[n]]);for(var w=0;w<k.length;w++){var g=this.r9(k[w],A,u);B+=(g/2)/(p-a)*z;o.funcs.push(["rotate",[(g/2)/(p-a)*z]]);if(this.Hl(C)){o.strokeStyle=C[w];o.fillStyle=C[w]}o.funcs.push(["fillText",[k[w],0,(q?1:-1)*(0-p+a/2)]]);B+=(g/2+this.circularLetterSeparationFactor)/(p-a)*z;o.funcs.push(["rotate",[(g/2+this.circularLetterSeparationFactor)/(p-a)*z]])}u.o.push(o);this.XI(u)};this.E1=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.Dr(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.qY(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.rO=function(B,w,r,o,q,v,u,e,h,C,z,A){var j=B.split(/\n/);var d=o;if(!d){d=this.font}var n=this.Dr(d);var p=r+(j%2?0:n/2)-(j.length*n/2);for(var k=0;k<j.length;k++){this.VU(j[k],w,p,d,q,v,u,e,h,C,z,A);p+=n;if(e&&e<90){w+=n;p-=n}}};this.zG=function(s,F,B){var k=this;if(s==undefined){s=""}if(s.match(/\n/)){s=s.replace(/\n/g,"<br>")}if(!F){F=this.font}if(!B){B=this.us()}var m=["b","strong","i","em","sup","sub","s","strike","u","underline","color"];var b=[];var q=[0];var A="";var w=0;var z=false;var h=false;var d=false;var l=false;var a=false;var n=false;var g=false;var C=false;var p=0;var o=0;var H=this.Dr(F);var v=F;var u=function(){var c="";var f=H;if(z){c+="bold "}if(h){c+="italic "}if(a){g="strike"}if(n){g="underline"}if(d||l){f=0.8*H;if(d){o-=0.3*H}else{o+=0.3*H}}v=c+f+"px "+k.fontName;w=k.r9(A,v,B);q.push([p,o,v,A,w,g,C]);g=false;p+=w;A=""};var j=function(){if(A!==""){u()}q[0]=p;b.push(q);q=[0];p=0;o=0};for(var E=0;E<s.length;E++){var G=s[E];if(G=="\n"){j()}else{if(G!="<"){A+=G}else{E++;var D=s[E];var e=false;if(D=="/"){D="";e=true}var r=true;for(E=E+1;E<s.length;E++){if(s[E]=="<"){E=E-1;A+="<"+D;u();r=false;break}if(s[E]==">"){break}D+=s[E]}if(!r){continue}if(D=="br"||D=="br/"){j()}else{if(m.indexOf(D)>=0&&A!==""){u()}if(D.match(/color/)){C=e?false:D.split(":")[1].replace(/"/g,"")}else{switch(D){case"s":case"strike":a=!e;break;case"u":case"underline":n=!e;break;case"b":case"strong":z=!e;break;case"i":case"em":h=!e;break;case"sup":d=!e;if(e){o=0}break;case"sub":l=!e;if(e){o=0}break;default:A+="<"+D+">"}}}}}}w=k.r9(A,v,B);if(A.length>0){q.push([p,o,F,A,w,g,C])}v=H+"px "+this.fontName;q[0]=p+w;b.push(q);return b};this.Iq=function(r,q,p,D,E,G,F,h,v,u,n,w){var j=this;var A=function(b){b.shift();var a=["poly"];a=a.concat(j.fb(b[0],b[1],q,p,h));a=a.concat(j.fb(b[2],b[1],q,p,h));a=a.concat(j.fb(b[2],b[3],q,p,h));a=a.concat(j.fb(b[0],b[3],q,p,h));return a};var k=this.zG(r,D,w);var l=0;for(var z=0;z<k.length;z++){l=Math.max(l,k[z][0])}var o=k.length;var g=this.Dr(D);var H=p+(o%2?0:g/2)-(o.length*g/2);var C=q;var e=H;var B=q+l;var d=H+o*g;if(G=="left"){C=q;B=C+l}else{if(G=="right"){C=q-l;B=q}else{C=q-(l/2);B=q+(l/2)}}if(F=="top"){e=p;d=e+g}else{if(F=="bottom"){e=p-g;d=p}else{e=p-(g/2);d=p+(g/2)}}var I=["rect",C,e,B,d];I=h?A(I):I;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?I:this.nJ(I)}else{return I}};this.f0=function(q,o,n,I,J,L,K,g,A,r,l,C,w){var h=this.zG(q,I,C);var G=0;var z=0;var u=I;var B=this.Dr(I);var H,d;for(var F=0;F<h.length;F++){var D=h[F];G=Math.max(G,D[0])}for(var F=0;F<h.length;F++){var D=h[F];z=D[0];for(var E=1;E<D.length;E++){var v=D[E];u=v[2];if(g){switch(L){case"left":H=o+v[1];d=n+v[0];break;case"center":if(g>0){H=o+v[1];d=(n-(z/2))+v[0]+(v[4]/2)}else{H=o-v[1];d=(n+(z/2))-v[0]-(v[4]/2)}break;case"right":H=o+v[1];d=n-(v[0]+G);break}}else{switch(L){case"left":H=o+v[0];d=n+v[1];break;case"center":H=o+v[0]-z/2;d=n+v[1];break;case"right":H=o+v[0]-G;d=n+v[1];break}}var e=v[6]?this.ZM(v[6]):J;this.VU(v[3],H,d,u,e,L,K,g,A,r,l,C,w);if(v[5]){var M=this.Dr(u)/2;if(v[5]=="strike"){this.hC("line",H,d,H+v[4],d,e,1,C)}else{if(v[5]=="underline"){this.hC("line",H,d+M,H+v[4],d+M,e,1,C)}}}}n+=B}};this.qY=function(p,n,l,C,D,F,E,g,r,q,k,u){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.fb(b[0],b[1],n,l,g));a=a.concat(j.fb(b[2],b[1],n,l,g));a=a.concat(j.fb(b[2],b[3],n,l,g));a=a.concat(j.fb(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.KZ(p)){return this.Iq(p,n,l,C,D,F,E,g,r,q,k,u)}else{if(this.wS(p)){return this.E1(p,n,l,C,D,F,E,g,r,q,k,u)}}var G=[];var o=this.r9(p,C,u);var z=this.Dr(C);var B,e,A,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.r9(p,C,u);i++}}if(F=="left"){B=n;A=B+o}else{if(F=="right"){B=n-o;A=n}else{B=n-(o/2);A=n+(o/2)}}if(E=="top"){e=l;d=e+z}else{if(E=="bottom"){e=l-z;d=l}else{e=l-(z/2);d=l+(z/2)}}G=["rect",B,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.nJ(G)}else{return G}};this.VU=function(u,o,k,i,j,n,l,e,g,z,q,r,v){if(u==undefined){u=""}if(!r){r=this.us()}var h=0;if(u==null){return}if(this.KZ(u)){return this.f0(u,o,k,i,j,n,l,e,g,z,q,r,v)}else{if(this.wS(u)){return this.rO(u,o,k,i,j,n,l,e,g,z,q,r)}}if(!r){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(o)||isNaN(k)){if(this.debug){alert("Not a valid coordinate ("+o+", "+k+") to draw "+u)}return}if(q){if(o<this.marginLeft+this.offsetX+this.left||o>this.marginLeft+this.offsetX+this.left+this.x){return}if(k<this.marginTop+this.offsetY+this.top||k>this.marginTop+this.offsetY+this.top+this.y){return}}if(!o){o=0}if(!k){k=0}if(!i){i=this.font}if(!j){j=this.foreground}if(!n){n=this.align}if(!l){l=this.baseline}var p=this.r9(u,i,r);if(g){while(p>g&&h<10){u=u.substring(0,u.length-1);p=this.r9(u,i,r);h++}}if(v){r.resetRender()}if(e){r.o.push({funcs:[["save",[]]]})}var d={strokeStyle:j,fillStyle:j,font:i,textAlign:n,textBaseline:l,funcs:[]};if(e){r.o.push({funcs:[["translate",[o,k]]]});r.o.push({funcs:[["rotate",[e]]]});o=k=0}u=u.toString().replace("\x00","").replace("u0000","");if(z){d.funcs.push(["strokeText",[u,o,k]])}else{d.funcs.push(["fillText",[u,o,k]])}r.o.push(d);if(e){r.o.push({funcs:[["restore",[]]]})}if(v){r.render();r.resetRender()}};this.wS=function(b){var a=b.toString().split(/\n/);return a.length-1};this.Cv=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.RI=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.KZ=function(a){return a&&a.toString().match(/<(?:s|strike|u|underline|b|strong|i|em|sup|sub)>/);return a&&a.toString().match(/<[^>]+>/)};this.Bg=function(a){return a.replace(/<[^>]+>/g,"")};this.Sx=function(e,h,b){var g=this.zG(e,h,b);var a=0;for(var d=0;d<g.length;d++){var c=g[d];a=Math.max(a,c[0])}return a};this.xB=function(e,g,c){var b=e.split(/\n/);var a=0;for(var d=0;d<b.length;d++){a=Math.max(a,this.r9(b[d],g,c))}return a};this.r9=function(d,h,a){if(!a){a=this.us()}if(!d||!a){return 0}d=d.toString();if(!h){h=this.font}try{CanvasXpress}catch(i){return false}if(this.graphType=="TagCloud"){if(!CanvasXpress.cacheText[h]){CanvasXpress.cacheText[h]={}}if(!CanvasXpress.cacheText[h][d]){a.font=h;if(this.wS(d)){CanvasXpress.cacheText[h][d]=this.xB(d,h,a)}else{CanvasXpress.cacheText[h][d]=a.measureText(d).width}}return CanvasXpress.cacheText[h][d]}else{var b=h.replace(/[\d]+px/,"").replace(/\s\s/," ");var c=this.Dr(h).toString();if(!CanvasXpress.cacheText[b]){CanvasXpress.cacheText[b]={}}if(!CanvasXpress.cacheText[b][d]){CanvasXpress.cacheText[b][d]={};a.font=h;if(this.KZ(d)){CanvasXpress.cacheText[b][d][c]=this.Sx(d,h,a)}else{if(this.wS(d)){CanvasXpress.cacheText[b][d][c]=this.xB(d,h,a)}else{CanvasXpress.cacheText[b][d][c]=a.measureText(d).width}}}else{if(!CanvasXpress.cacheText[b][d].hasOwnProperty("ss")){var g=Object.keys(CanvasXpress.cacheText[b][d])[0];CanvasXpress.cacheText[b][d][c]=CanvasXpress.cacheText[b][d][g]*(c/g)}}return CanvasXpress.cacheText[b][d][c]}};this.HR=function(b,c){var a=this.wS(b);if(a>0){return(this.Dr(c)+this.margin)*(a+1)}else{return this.Dr(c)}};this.bp=function(c,i,b,d,a){var g=Math.ceil(i);if(this.fontStyle==false){this.fontStyle=""}var e=this.fontStyle+" "+g+"px "+this.fontName;if(c){while(this.r9(c,e,a)>b&&g>=this.minTextSize){g-=2;e=this.fontStyle+" "+g+"px "+this.fontName}if(d){while(parseInt(g/1.33)>d-2){g--}e=this.fontStyle+" "+g+"px "+this.fontName}}if(this.fontScaleFontFactor!=1){e=this.fontStyle+" "+parseInt(g*this.fontScaleFontFactor)+"px "+this.fontName}return e};this.Dr=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.QY=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.ah=function(c,b){var a=parseInt(c.toString().length*1.5/b);return this.eh(c,a)};this.eh=function(b,a){if(a<1){return b}if(this.KZ(b)){return this.BW(b,a)}else{return this.Xb(b,a)}};this.BW=function(e,a){var e=e.replace(/\n/g,"<br>");var d=e.split(/(<[^>]+>)/g);var c=[];var b=0;d.forEach(function(f){if(f.startsWith("<")&&f.endsWith(">")){c.push(f);if(f==="<br>"){b=0}}else{var g=f.split(" ");g.forEach(function(h){if(b+h.length+1>a){c.push("\n");b=0}c.push(h+" ");b+=h.length+1})}});c=c.filter(function(f){return f!==" "});return c.join("").trim()};this.Xb=function(d,c){var b="";var a=0;d.toString().split(" ").forEach(function(e){if(a+e.length+1>c){b+="\n";a=0}b+=e+" ";a+=e.length+1});return b.trim()};this.t6=function(o,k,v){var w=RegExp("(?:\\s|^)(.{1,"+k+"})(?=\\s|$)","g");var l=[];var u=[];var h=[];var s=0;var t=0;var p=this.r9(" ",v||this.font);var e;while((e=w.exec(o))!==null){l.push(e[1])}for(var g=0;g<l.length-1;g++){if(l[g].indexOf(" ")!=-1){while(l[g].length<k){for(var f=0;f<l[g].length-1;f++){if(l[g][f]==" "){l[g]=l[g].substring(0,f)+" "+l[g].substring(f);if(l[g].length==k){break}while(l[g][f]==" "){f++}}}}}u.push(l[g])}u.push(l[l.length-1]);for(var g=0;g<u.length-1;g++){var c=this.r9(u[g],v);if(c>s){s=c;t=g}h.push(c)}for(var g=0;g<u.length-1;g++){var d=parseInt((s-h[g])/p);var f=/\s+/gi;var a=[];var b;if(d>0){while((b=f.exec(u[g]))!=null){a.push(b.index)}if(a.length>d){while(d>0){u[g]=u[g].substring(0,a[d-1])+" "+u[g].substring(a[d-1]);d--}}else{while(h[g]+p<s){u[g]=u[g].replace(" ","  ");h[g]+=p}}}}return u.join("\n")};this.i0=function(a,b){var d=this.Dr(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.ct=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.Y5=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.tx(g)};this.tx=function(e,l,d){var k="";var b=0;if(e&&e.length>0){if(!l){l=this.font}for(var h=0;h<e.length;h++){if(e[h]){if(this.Hl(e[h])){for(var g=0;g<e[h].length;g++){var n=this.r9(e[h][g].toString(),l,d);if(n>b){k=e[h][g].toString();b=n}}}else{var n=this.r9(e[h].toString(),l,d);if(n>b){k=e[h].toString();b=n}}}}}return k};this.uM=function(c,b,a){if(c==null){return""}c=c.toString();if(!c){return""}if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.JJ=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.DF=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")};this.tv=function(h){var l=this;var j=function(q){var r;var p=function(t){if(!l.returnCachedLayout){r=q(t);for(var s=0;s<t.length;s++){r[s].dx=t[s].x-r[s].x;r[s].dy=t[s].y-r[s].y}}else{for(var s=0;s<t.length;s++){r[s].x=t[s].x-r[s].dx;r[s].y=t[s].y-r[s].dy}}return r};return p};var i=function(w,u){var r=function(s){return !isNaN(s)};var t=0,v=w.length,p,q=-1;if(arguments.length===1){while(++q<v){if(r(p=+w[q])){t+=p}}}else{while(++q<v){if(r(p=+u.call(w,w[q],q))){t+=p}}}return t};var b=(function(r,p){var q=function(x,w){return !(x.x>=w.x+w.width||x.x+x.width<=w.x||x.y>=w.y+w.height||x.y+x.height<=w.y)};if(q(r,p)){var v=Math.max(r.x,p.x);var t=Math.min(r.x+r.width,p.x+p.width);var u=Math.max(r.y,p.y);var s=Math.min(r.y+r.height,p.y+p.height);return(t-v)*(s-u)}else{return 0}});var n=(function(s){var r=function(w,B,A,v,z){return{x:w,y:B,width:A,height:v,location:z}};var q=s.x;var u=s.y;var t=s.width;var p=s.height;return[r(q,u,t,p,"bottom-right"),r(q-t,u,t,p,"bottom-left"),r(q-t,u-p,t,p,"top-left"),r(q,u-p,t,p,"top-right"),r(q,u-p/2,t,p,"middle-right"),r(q-t/2,u,t,p,"bottom-center"),r(q-t,u-p/2,t,p,"middle-left"),r(q-t/2,u-p,t,p,"top-center")]});var o=function(r,q){var p=function(s){var u=0;for(var t=0;t<s.length;t++){u+=s[t]}return u};return p(r.map(function(t,s){return q===s?0:b(r[q],t)}))};var k=function k(p){return i(p.map(function(q,r){return o(p,r)}))};var m=(function(q,p){return q.map(function(r,s){return[p(r,s),r,s]}).reduce(function(s,r){return s[0]>r[0]?r:s},[Number.MAX_VALUE,null,-1])});var a=function(){function w(y){function B(F,E){if(E==null||E>F.length){E=F.length}for(var H=0,G=new Array(E);H<E;H++){G[H]=F[H]}return G}function A(E){if(Array.isArray(E)){return B(E)}}function z(E){if(typeof Symbol!=="undefined"&&Symbol.iterator in Object(E)){return Array.from(E)}}function D(F,E){if(!F){return}if(typeof F==="string"){return B(F,E)}var G=Object.prototype.toString.call(F).slice(8,-1);if(G==="Object"&&F.constructor){G=F.constructor.name}if(G==="Map"||G==="Set"){return Array.from(F)}if(G==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(G)){return B(F,E)}}function C(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}return A(y)||z(y)||D(y)||C()}var v=function(A,y,z){return[].concat(w(A.slice(0,y)),[z],w(A.slice(y+1)))};var x=function(z,y){return z<y};var r=null;var p=x;var t=function(){return 0};var s;var q=function(z,y){return r-t(s[y],y,s)+t(z,y,v(s,y,z))};var u=function(A,z){function y(C){var E=0;for(var D=0;D<C.length;D++){E+=C[D]}return E}if(!r){r=y(s.map(function(D,C){return t(D,C,s)}))}var B=q(A,z);if(p(B,r)){return a().locationScore(t).winningScore(p).score(B).rectangles(v(s,z,A))}else{return u}};u.rectangles=function(){if(!arguments.length){return s}s=arguments.length<=0?undefined:arguments[0];return u};u.score=function(){if(!arguments.length){return r}r=arguments.length<=0?undefined:arguments[0];return u};u.winningScore=function(){if(!arguments.length){return p}p=arguments.length<=0?undefined:arguments[0];return u};u.locationScore=function(){if(!arguments.length){return t}t=arguments.length<=0?undefined:arguments[0];return u};return u};function c(){var p=[0,0];var r=function r(u){var t=k(u);var v=0;if(p[0]!==0&&p[1]!==0){var s={x:0,y:0,width:p[0],height:p[1]};v=i(u.map(function(x){var w=x.width*x.height-b(x,s);return w*2}))}return t+v};var q=function(t){var s=[];t.forEach(function(u){var v=n(u).map(function(w){var x=s.slice();x.push(w);return x});s=m(v,r)[1]});return s};q.bounds=function(s){if(!arguments.length){return p}p=s;return q};return q}var d=function(){var q=l.optimizeTextPositionEnforceBounds;var p=function(t){return q?t.width*t.height-b(t,q):0};var s=function(u,t,v){return o(v,t)+p(u)};var r=function r(u){var t=a().locationScore(s).rectangles(u);u.forEach(function(w,v){n(w).forEach(function(x,y){t=t(x,v)})});return t.rectangles()};r.bounds=function(){if(!arguments.length){return q}q=arguments.length<=0?undefined:arguments[0];return r};return r};var e=function(){var w=l.optimizeTextPositionTemperature;var q=l.optimizeTextPositionCooling;var p=l.optimizeTextPositionEnforceBounds;var s=function(y){return y[v(y)]};var v=function(y){return Math.floor(l.Uu()*y.length)};var x=function(y){switch(y.location){case"bottom-right":return 0;case"middle-right":case"bottom-center":return y.width*y.height/8}return y.width*y.height/4};var r=function(y){return p?y.width*y.height-b(y,p):0};var u=function(z,y,A){return o(A,y)+r(z)+x(z)};var t=function(D){var y=w;var C=function(F,E){return Math.exp((E-F)/y)>l.Uu()};var B=a().locationScore(u).winningScore(C).rectangles(D);while(y>0){var A=v(D);var z=s(n(D[A]));B=B(z,A);y-=q}return B.rectangles()};t.temperature=function(){if(!arguments.length){return w}w=arguments.length<=0?undefined:arguments[0];return t};t.cooling=function(){if(!arguments.length){return q}q=arguments.length<=0?undefined:arguments[0];return t};t.bounds=function(){if(!arguments.length){return p}p=arguments.length<=0?undefined:arguments[0];return t};return t};var g=function(v){v=v||function(w){return w};function s(w,z){function y(A,D){let minValue;let min=-1;for(var B=0;B<A.length;B++){const C=A[B];if(C!=null&&(minValue===undefined?D(C,C)===0:D(C,minValue)<0)){minValue=C;min=B}}return min}const x=y(w,z);return x<0?undefined:x}var q=(function(y,x,w){var z=x[w];if(typeof z!=="function"){throw new Error("Attempt to rebind ".concat(w," which isn't a function on the source object"))}return function(){for(var A=arguments.length,B=new Array(A),C=0;C<A;C++){B[C]=arguments[C]}var D=z.apply(x,B);return D===x?y:D}});var u=function(w){return function(x){return w.reduce(function(y,z){return y&&z(y)},x)}};var p=(function(C,w){for(var E=arguments.length,D=new Array(E>2?E-2:0),y=2;y<E;y++){D[y-2]=arguments[y]}var z=u(D);for(var A=0,B=Object.keys(w);A<B.length;A++){var x=B[A];var F=z(x);if(F){C[F]=q(C,w,x)}}return C});var r=function(x,w){return x[s(x,w)]};var t=function(x){x=v(x);var y=function(){var B=x.filter(function(C){return !C.hidden});var A=B.map(function(D,C){return[D,o(B,C)]});var z=r(A,function(D,C){return C[1]-D[1]});if(z[1]>0){z[0].hidden=true}else{return"break"}};while(true){var w=y();if(w==="break"){break}}return x};p(t,v);return t};var f=function(){var p=[0,0];var q=function(r){return r.map(function(v,u){var t=v.x;var s=v.y;if(t+v.width>p[0]){t-=v.width}if(s+v.height>p[1]){s-=v.height}return{height:v.height,width:v.width,x:t,y:s}})};q.bounds=function(){if(!arguments.length){return p}p=arguments.length<=0?undefined:arguments[0];return q};return q};switch(this.optimizeTextPositionStrategy){case"greedy":return j(g(c()))(h);case"annealing":return j(g(e()))(h);case"remove-overlaps":return j(g())(h);case"bounding-box":return j(g(f()))(h)}}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};Date.prototype.addMilliseconds=function(b){var a=new Date(this.valueOf());a.setDate(a.getMilliseconds()+b);return a};Date.prototype.addSeconds=function(b){var a=new Date(this.valueOf());a.setDate(a.getSeconds()+b);return a};Date.prototype.addMinutes=function(b){var a=new Date(this.valueOf());a.setDate(a.getMinutes()+b);return a};Date.prototype.addHours=function(a){var b=new Date(this.valueOf());b.setDate(b.getHours()+a);return b};Date.prototype.addDays=function(b){var a=new Date(this.valueOf());a.setDate(a.getDate()+b);return a};Date.prototype.addMonths=function(a){var b=new Date(this.valueOf());b.setMonth(b.getMonth()+a);return b};Date.prototype.addYears=function(b){var a=new Date(this.valueOf());a.setYear(a.getFullYear()+b);return a};this.pb=function(a){return a.getMilliseconds()};this.pe=function(a){return a.getSeconds()};this.M9=function(a){return a.getMinutes()+"."+a.getSeconds()};this.rk=function(a){return a.getMinutes()};this.I6=function(a){return a.getHours()+"."+a.getMinutes()};this.j1=function(a){return a.getHours()};this.eS=function(a){return a.getFullYear()+"."+a.getWeek()};this.NU=function(a){return(a.getMonth()+1)+"."+(a.getDay()+1)};this.o5=function(a){return a.getFullYear()+"."+(a.getMonth()+1)};this.a9=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.UW=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.gG=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.NP=function(b,a){if(b){if(this.timeFormat=="year"||b>this.times.year*2){if(b/(a||2)>=this.times.year){return"addYears"}else{return"addMonths"}}else{if(this.timeFormat=="month"||b>this.times.week){return"addDays"}else{if(b<this.times.second){return"addMilliseconds"}else{if(b<this.times.minute){return"addSeconds"}else{if(b<this.times.hour){return"addMinutes"}else{if(b<this.times.day){return"addHours"}else{return"addDays"}}}}}}}else{return"addDays"}};this.pQ=function(b){var a=this.NP(b);switch(a){case"addYears":return"year";case"addMonths":return"month";case"addDays":return"shortDate";return b>this.times.week?"yearMonth":"shortDate";case"addHours":return"hour";case"addMinutes":return"minute";case"addSeconds":case"addMilliseconds":return"second"}};this.Aj=function(e){var g=[];for(var d=0;d<e.y.smps.length;d++){g.push(new Date(e.y.smps[d]).getTime())}var f=this.Ze(g);var a=this.Ze(g.sort(function(i,h){return i-h}));if(!this.eI(f,a)){var c={y:{vars:e.y.vars,smps:[],data:[]}};for(var d=0;d<e.y.vars.length;d++){c.y.data[d]=[];for(var b=0;b<f.length;b++){c.y.data[d][f[b]]=e.y.data[d][b]}}for(var b=0;b<f.length;b++){c.y.smps[f[b]]=e.y.smps[b]}if(e.x){c.x={};for(var d in e.x){c.x[d]=[];for(var b=0;b<f.length;b++){c.x[d][f[b]]=e.x[d][b]}}}if(e.z){c.z=e.z}this.data=c}};this.Py=function(u,c){if(!c){c=10}var g={};var l=[];for(var q=0;q<u.length;q++){l.push(new Date(u[q]).getTime())}g.times=l;g.rank=this.Ze(l);g.times.sort(function(v,i){return v-i});g.range=this.aC(l);var b=new Date(g.range[0]);var r=new Date(g.range[1]);var a=[];var p=new Date(b);while(p<=r){a.push(new Date(p));p.setDate(p.getDate()+1)}g.fullRange=a;var o=r.getTime()-b.getTime();var j=o/c;var m=[{unit:"day",milliseconds:86400000},{unit:"week",milliseconds:604800000},{unit:"month",milliseconds:2629800000},{unit:"year",milliseconds:31557600000}];var k=m[0];for(var q=0;q<m.length;q++){var n=m[q];if(j>n.milliseconds){k=n}else{break}}g.unit=k;var h=Math.ceil(j/k.milliseconds);var d=[];var p=new Date(b);while(p<=r){d.push(new Date(p));if(k.unit==="day"){p.setDate(p.getDate()+h)}else{if(k.unit==="week"){p.setDate(p.getDate()+h*7)}else{if(k.unit==="month"){p.setMonth(p.getMonth()+h)}else{p.setFullYear(p.getFullYear()+h)}}}}d.push(new Date(p));g.intervals=d;var t=[];for(var q=0;q<d.length;q++){var s=d[q];if(k.unit==="day"){t.push(s.toLocaleDateString())}else{if(k.unit==="week"){t.push("Week "+s.getWeek()+", "+s.getFullYear())}else{if(k.unit==="month"){t.push(s.toLocaleDateString("default",{month:"short",year:"numeric"}))}else{t.push(s.getFullYear().toString())}}}}g.labels=t;var f=[];for(var q=0;q<l.length;q++){if(k.unit==="day"){f.push(new Date(l[q]).toLocaleDateString())}else{if(k.unit==="week"){f.push("Week "+new Date(l[q]).getWeek()+", "+new Date(l[q]).getFullYear())}else{if(k.unit==="month"){f.push(new Date(l[q]).toLocaleDateString("default",{month:"short",year:"numeric"}))}else{f.push(new Date(l[q]).getFullYear().toString())}}}}g.data=f;var e=[];var p=1;for(var q=0;q<f.length;q++){if(f[q]===t[p]){e.push(f[q]);p++}else{e.push("")}}g.dates=e;return g};this.vy=function(p,k,o){var b=new Date(p);var h=new Date(k);var m=h-b;var g=this.NP(m);var a=[];var f=[];while(b<h){var l=new Date(b);l=l[g](1);b=Date.parse(l);a.push(b)}var c=Math.max(1,Math.floor(a.length/(o-1)));for(var j=0;j<a.length;j++){if(j%c==0){if(Math.abs(a[j])>=0){f.push(a[j])}}}var l=f[1]-f[0];f.unshift(f[0]-l);f.push(f[f.length-1]+l);return f};this.ZD=function(){var h=this.a0();if(h.length){var k=Date.parse(h[0]);var a=Date.parse(h[h.length-1]);var g=a-k;var c=this.NP(g,h.length);this.timeValues=[this.dateFormat(new Date(k)[c](-1),this.timeFormat)];this.timeValueIndices=[-1];while(k<=a){var j=new Date(k);var e=this.dateFormat(j,this.timeFormat);var b=this.sF(this.timeFormat.match(/year|hour|minute|second/)?Number(e):e);this.timeValues.push(e);this.timeValueIndices.push(b);j=j[c](1);k=Date.parse(j)}}else{return[]}};this.eC=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w.labs:this.data.y.smps;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.length;c++){e=Date.parse(h[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.a0=function(){var j=this.isGroupedData?this.data.w.labs:this.data.y.smps;var b=false;var h=[];for(var c=0;c<j.length;c++){var a=j[c];var e=this.timeFormat;switch(this.timeFormat){case"Year":case"year":a+="/01/02";e="isoDate";break;case"Month":case"month":a="2018/"+CanvasXpress.dates[a]+"/02";e="isoDate";break;case"Day":case"day":a="2018/01/"+CanvasXpress.dates[a];e="isoDate";break}if(!this.uo(a)){this.isGraphTime=false;return[]}var g=Date.parse(this.dateFormat(a,e));if(isNaN(g)){if(this.isExample){h=this.eC();return h}else{b=true;break}}else{h.push(new Date(g))}}h.sort(function(f,d){return f-d});return b?false:h}};CanvasXpress.prototype.initColor=function(){var c=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;var e=/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/;var a=/^#?([0-9a-f]{6})$/i;var d=/^#?([0-9a-f]{8})$/i;var b=/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i;this.ZM=function(n,i,g){var o=n;var l=null;if(o==null){return false}if(o instanceof CanvasGradient||o.toString()==="[objectCanvasGradient]"){return n}o=o.toString().replace(/\s/g,"");var m,p,h,j;if(CanvasXpress.colorNames.hasOwnProperty(o)){o=this.TS(CanvasXpress.colorNames[o])}else{if((p=e.exec(o))){o=p[0]}else{if((m=c.exec(o))){o=m[0]}else{if((j=d.exec(o))){var k=j[1];o=this.TS("#"+k.substring(0,6));l=parseInt(k.substring(6,8),16)/255;if(i==null){i=l}}else{if((h=a.exec(o))){var k=h[1];o=this.TS(k.charAt(0)==="#"?k:"#"+k)}else{o=false}}}}}if(o&&i!=null){var f=Math.max(0,Math.min(1,i));o=this.eN(o,f,true)}if(o&&g){return this.RL(o)}return o};this.ZL=function(i,f){var j=(f==null)?10:f;var h=this.u5(i,true);if(!h){return i}h[1]=Math.max(0,h[1]-(j/100));var g="hsl("+Math.floor(h[0]*360)+","+Math.floor(h[1]*100)+"%,"+Math.floor(h[2]*100)+"%)";return this.vN(g)};this.mT=function(j,g){var f=(g==null)?10:g;var i=this.u5(j,true);if(!i){return j}i[1]=Math.min(1,i[1]+(f/100));var h="hsl("+Math.floor(i[0]*360)+","+Math.floor(i[1]*100)+"%,"+Math.floor(i[2]*100)+"%)";return this.vN(h)};this.ns=function(i){var m=this.ZM(i);if(!m){return"#000000"}var h=this.Kn(m);if(!h||h.length<3){return"#000000"}var l=h[0];var j=h[1];var f=h[2];var k=h.length>3?h[3]:1;if(k<0.5){return"#000000"}var g=(l*0.299+j*0.587+f*0.114);return g>128?"#000000":"#FFFFFF"};this.WB=function(f){return this.ZL(f,100)};this.tr=function(j,g){var f=(g==null)?10:g;var i=this.u5(j,true);if(!i){return j}i[2]=Math.min(1,i[2]+(f/100));var h="hsl("+Math.floor(i[0]*360)+","+Math.floor(i[1]*100)+"%,"+Math.floor(i[2]*100)+"%)";return this.vN(h)};this.tV=function(j,f){var h=(f==null)?10:f;var i=this.u5(j,true);if(!i){return j}i[2]=Math.max(0,i[2]-(h/100));var g="hsl("+Math.floor(i[0]*360)+","+Math.floor(i[1]*100)+"%,"+Math.floor(i[2]*100)+"%)";return this.vN(g)};this.Qy=function(m,i){var j=(i==null)?10:i;var h=this.Kn(m);if(!h||h.length<3){return m}var g=Math.round(255*(j/100));var l=Math.max(0,Math.min(255,h[0]+g));var k=Math.max(0,Math.min(255,h[1]+g));var f=Math.max(0,Math.min(255,h[2]+g));return"rgb("+l+","+k+","+f+")"};this.KY=function(h){var g=this.u5(h,true);if(!g){return h}g[0]=(g[0]+0.5)%1;var f="hsl("+Math.floor(g[0]*360)+","+Math.floor(g[1]*100)+"%,"+Math.floor(g[2]*100)+"%)";return this.vN(f)};this.ZY=function(f,n,r){var j=r.u5(f,true);if(!j){return[f]}var q=[f];var g=j[0];var l=j[1];var p=j[2];for(var h=0;h<n.length;h++){var o=n[h];var k=(g+(o/360))%1;var m="hsl("+Math.floor(k*360)+","+Math.floor(l*100)+"%,"+Math.floor(p*100)+"%)";q.push(r.vN(m))}return q};this.XK=function(f){return this.ZY(f,[120,240],this)};this.DJ=function(f){return this.ZY(f,[90,180,270],this)};this.FI=function(f){return this.ZY(f,[72,144,216,288],this)};this.Oo=function(f){return this.ZY(f,[60,120,180,240,300],this)};this.sm=function(f){return this.ZY(f,[72,216],this)};this.cM=function(f,u){var m=[];var t=this.Kn(f);if(!t||t.length<3||!u||u<=0){return[f]}var h=t[0];var n=t[1];var r=t[2];var s=u+1;var p=(255-h)/s;var q=(255-n)/s;var l=(255-r)/s;for(var k=1;k<=u;k++){var g=Math.floor(h+(p*k));var j=Math.floor(n+(q*k));var o=Math.floor(r+(l*k));g=Math.min(255,Math.max(0,g));j=Math.min(255,Math.max(0,j));o=Math.min(255,Math.max(0,o));m.unshift("rgb("+g+","+j+","+o+")")}return m};this.xj=function(m,i){var h=this.RL(this.ZM(m||"#000000"));if(!h||h.charAt(0)!=="#"){return"rgb(0,0,0)"}var l=h.substring(1,7);var g=parseInt(l,16);var k=(g>>16)+i;k=k>255?255:k<0?0:k;var j=((g>>8)&255)+i;j=j>255?255:j<0?0:j;var f=(g&255)+i;f=f>255?255:f<0?0:f;return"rgb("+k+","+j+","+f+")"};this.RL=function(j){var k=function(m){var l=parseInt(m,10);if(isNaN(l)){return"00"}l=Math.max(0,Math.min(l,255));var n=l.toString(16);return n.length==1?"0"+n:n};if(!j){return j}if(a.test(j)){return j.charAt(0)==="#"?j:"#"+j}var g=b.exec(j);if(g){var i=k(g[1]);var h=k(g[2]);var f=k(g[3]);return"#"+i+h+f}else{return j}};this.u5=function(i,n){var x=this.Kn(i);if(!x||x.length<3){return null}var j=x[0]/255;var t=x[1]/255;var u=x[2]/255;var v=Math.max(j,t,u);var p=Math.min(j,t,u);var q,y;var o=(v+p)/2;if(v==p){q=0;y=0}else{var w=v-p;y=o>0.5?w/(2-v-p):w/(v+p);switch(v){case j:q=(t-u)/w+(t<u?6:0);break;case t:q=(u-j)/w+2;break;case u:q=(j-t)/w+4;break}q/=6}if(n){return[q,y,o]}else{var m=Math.round(q*360);var k=Math.round(y*100);var f=Math.round(o*100);return"hsl("+m+","+k+"%,"+f+"%)"}};this.p1=function(f,j){var i=this.ZM(f);if(!i){return f}var l=b.exec(i);if(l){var h=parseInt(l[1],10);var m=parseInt(l[2],10);var o=parseInt(l[3],10);var p=255-h;var k=255-m;var n=255-o;if(p==k&&k==n){if(h>=128){i="rgb(0,0,0)"}else{i="rgb(255,255,255)"}}else{i="rgb("+p+","+k+","+n+")"}return j?this.RL(i):i}else{return f}};this.TS=function(g){if(!g){return g}var j=g.charAt(0)=="#"?g.substring(1):g;if(!/^[0-9a-f]{6}$/i.test(j)){return g}var i=parseInt(j.substring(0,2),16);var h=parseInt(j.substring(2,4),16);var f=parseInt(j.substring(4,6),16);if(isNaN(i)||isNaN(h)||isNaN(f)){return g}return"rgb("+i+","+h+","+f+")"};this.vN=function(w){function i(l,h,g){if(g<0){g+=1}if(g>1){g-=1}if(g<1/6){return l+(h-l)*6*g}if(g<1/2){return h}if(g<2/3){return l+(h-l)*(2/3-g)*6}return l}if(!w||typeof w!=="string"){return w}var u=/hsl\((\d{1,3}),(\d{1,3})%?,(\d{1,3})%?\)/i.exec(w.replace(/\s/g,""));if(!u){return w}var t=parseInt(u[1],10)/360;var z=parseInt(u[2],10)/100;var n=parseInt(u[3],10)/100;t=Math.max(0,Math.min(1,t));z=Math.max(0,Math.min(1,z));n=Math.max(0,Math.min(1,n));var f,v,x;if(z==0){f=v=x=n}else{var j=n<0.5?n*(1+z):n+z-n*z;var k=2*n-j;f=i(k,j,t+1/3);v=i(k,j,t);x=i(k,j,t-1/3)}var m=Math.round(f*255);var o=Math.round(v*255);var y=Math.round(x*255);return"rgb("+m+","+o+","+y+")"};this.eN=function(f,h,g,j,m){if(f==null){return false}if(f instanceof CanvasGradient){return f}var n=f;if(m){n=this.Y3(n,g)}if(!g){n=this.ZM(n)}if(!n){return false}var l=b.exec(n);if(!l){n=this.ZM(n);l=b.exec(n)}if(l){var k=l[1]+","+l[2]+","+l[3];var i;if(j){i=0}else{i=Math.max(0,Math.min(1,h));if(h==null&&l[4]!=null){i=Math.max(0,Math.min(1,parseFloat(l[4])))}else{if(h==null){i=1}else{if(h!=null&&l[4]!=null){i=Math.min(parseFloat(l[4]),h)}}}}return"rgba("+k+","+i+")"}else{return false}};this.Y3=function(i,h){if(i==null){return false}if(i instanceof CanvasGradient){return i}var f=i;if(!h){f=this.ZM(f)}if(!f){return false}var g=b.exec(f);if(g){return"rgb("+g[1]+","+g[2]+","+g[3]+")"}else{if(a.test(f)){return this.TS(f)}return false}};this.s8=function(i,h){if(i==null){return null}if(i instanceof CanvasGradient){return null}var f=i;if(!h){f=this.ZM(f)}if(!f){return null}var g=b.exec(f);if(g&&g[4]!=null){return Math.max(0,Math.min(1,parseFloat(g[4])))}else{return null}};this.nW=function(h,f){var g=this.s8(h,f);return g===0};this.P8=function(r){if(!r||r.length===0){return false}var p=0,o=0,j=0,q=0;var k=0;var m=false;for(var l=0;l<r.length;l++){var f=this.ZM(r[l]);var n=this.Kn(f);if(n&&n.length>=3){p+=n[0];o+=n[1];j+=n[2];if(n.length>3&&n[3]!=null){q+=n[3];m=true}else{q+=1}k++}}if(k===0){return false}var t=Math.round(p/k);var h=Math.round(o/k);var s=Math.round(j/k);t=Math.max(0,Math.min(255,t));h=Math.max(0,Math.min(255,h));s=Math.max(0,Math.min(255,s));if(m){var g=q/k;g=Math.max(0,Math.min(1,g));g=parseFloat(g.toFixed(3));return"rgba("+t+","+h+","+s+","+g+")"}else{return"rgb("+t+","+h+","+s+")"}};this.Kn=function(k){if(!k){return null}var g=b.exec(k);if(g){var j=parseInt(g[1],10);var i=parseInt(g[2],10);var f=parseInt(g[3],10);var h=[j,i,f];if(g[4]!=null){h.push(parseFloat(g[4]))}if(isNaN(j)||isNaN(i)||isNaN(f)){return null}return h}return null};this.WP=function(k,g){var h=this.Kn(this.ZM(k));if(!h||h.length<3){return k}var f=Math.round(0.299*h[0]+0.587*h[1]+0.114*h[2]);f=Math.max(0,Math.min(255,f));var i="rgb("+f+","+f+","+f+")";if(g!=null){var j=Math.max(0,Math.min(1,g));return this.eN(i,j,true)}else{return i}};this.RG=function(n,I){var z=this.ZM(n,I);var M=this.Kn(z);if(!M||M.length<3){return n}var r=M[0];var u=M[1];var J=M[2];if(r===0&&u===0&&J===0){return"rgb(0,0,0)"}var p=[0.7465,0.2535,1.273463,-0.073894];var ac=[1.4,-0.04,0.968437,0.003331];var Q=[1.748,0,0.062921,0.292119];var N;switch(this.blindnessType){case"protanopia":N=p;break;case"deuteranopia":N=ac;break;case"tritanopia":N=Q;break;case"monochromatic":var g=Math.ceil((r*0.212656+u*0.715158+J*0.072186));g=Math.max(0,Math.min(255,g));return"rgb("+g+","+g+","+g+")";default:return z}var S=N[0];var R=N[1];var X=N[2];var E=N[3];var x=Math.pow(r/255,2.2);var w=Math.pow(u/255,2.2);var q=Math.pow(J/255,2.2);var F=x*0.412424+w*0.357579+q*0.180464;var D=x*0.212656+w*0.715158+q*0.072185;var B=x*0.019332+w*0.119193+q*0.950444;var H=F+D+B;var k=(H===0)?0:F/H;var j=(H===0)?0:D/H;var y=(j-R)/(k-S);var U=j-k*y;var h=(E-U)/(y-X);var f=(y*h)+U;var af=(f===0)?0:h*D/f;var ad=D;var ab=(f===0)?0:(1-(h+f))*D/f;var aa=0.312713*D/0.329016;var Z=0.358271*D/0.329016;var T=aa-af;var P=Z-ab;var L=T*3.24071+P*-0.498571;var V=T*-0.969258+P*0.0415557;var v=T*0.0556352+P*1.05707;var C=af*3.24071+ad*-1.53726+ab*-0.498571;var K=af*-0.969258+ad*1.87599+ab*0.0415557;var O=af*0.0556352+ad*-0.203996+ab*1.05707;var ae=((L<0?0:1)-C)/L;var l=((V<0?0:1)-K)/V;var m=((v<0?0:1)-O)/v;var Y=[(isNaN(ae)||ae>1||ae<0)?0:ae,(isNaN(l)||l>1||l<0)?0:l,(isNaN(m)||m>1||m<0)?0:m];var t=Math.max.apply(null,Y);C=C+(t*L);K=K+(t*V);O=O+(t*v);var o=Math.pow(Math.max(0,C),1/2.2);var G=Math.pow(Math.max(0,K),1/2.2);var A=Math.pow(Math.max(0,O),1/2.2);var s=Math.round(Math.max(0,Math.min(255,o*255)));var i=Math.round(Math.max(0,Math.min(255,G*255)));var W=Math.round(Math.max(0,Math.min(255,A*255)));return"rgb("+s+","+i+","+W+")"};this.RV=function(){if(this.gradientTemp===undefined){this.gradientTemp=this.gradient}if(this.transparencyTemp===undefined){this.transparencyTemp=this.transparency}if(this.showShadowTemp===undefined){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.Ce=function(){if(this.gradientTemp!==undefined){this.gradient=this.gradientTemp}if(this.transparencyTemp!==undefined){this.transparency=this.transparencyTemp}if(this.showShadowTemp!==undefined){this.showShadow=this.showShadowTemp}};this.tl=function(){delete this.gradientTemp;delete this.transparencyTemp;delete this.showShadowTemp};this.AO=function(g,l,k,i,f,j){var h=true;if(this.gradientType==="radial"){return this.W6(g,l,k,f,j,h)}else{return this.uf(g,l,k,i,f,j,h)}};this.uf=function(w,u,g,f,l,y,p){if(!p){this.WF()}var j=this.us();if(!j){return null}var h=j.createLinearGradient(w,u,g,f);var n=l||this.colorSpectrum;var z=y;if(!this.Hl(n)||n.length<2){if(this.ZM(n)){n=[n,"rgb(0,0,0)"]}else{n=this.colorSpectrum;if(!this.Hl(n)||n.length<2){n=["rgb(255,255,255)","rgb(0,0,0)"]}}}if(!z||!this.Hl(z)){z=this.YR()?[]:this.colorSpectrumBreaks}var q=n.length;var m=q>1?1/(q-1):0;var k=m;var x=[];for(var s=0;s<q;s++){x[s]=this.ZM(n[s]);if(!x[s]){x[s]="rgb(0,0,0)"}}var v=(z&&z.length>0&&z[0]!=null)?z[0]:0;var o=this.transparency!=null?this.eN(x[0],this.transparency,true):x[0];h.addColorStop(Math.max(0,Math.min(1,v)),o);for(var s=1;s<q;s++){var t=(z&&z.length>s&&z[s]!=null)?z[s]:k;var r=this.transparency!=null?this.eN(x[s],this.transparency,true):x[s];h.addColorStop(Math.max(0,Math.min(1,t)),r);k+=m}return h};this.W6=function(o,l,h,m,z,s){if(!s){this.WF()}var g=this.us();if(!g){return null}var n=h/5.5;var j=1;var f=g.createRadialGradient(o-n,l-n,j,o,l,h);var q=m||this.colorSpectrum;var A=z;if(!this.Hl(q)||q.length<2){if(this.ZM(q)){q=[q,"rgb(0,0,0)"]}else{q=this.colorSpectrum;if(!this.Hl(q)||q.length<2){q=["rgb(255,255,255)","rgb(0,0,0)"]}}}if(!A||!this.Hl(A)){A=this.YR()?[]:this.colorSpectrumBreaks}var t=q.length;var p=t>1?1/(t-1):0;var k=p;var y=[];for(var v=0;v<t;v++){y[v]=this.ZM(q[v]);if(!y[v]){y[v]="rgb(0,0,0)"}}var x=(A&&A.length>0&&A[0]!=null)?A[0]:0;var r=this.transparency!=null?this.eN(y[0],this.transparency,true):y[0];f.addColorStop(Math.max(0,Math.min(1,x)),r);for(var v=1;v<t;v++){var w=(A&&A.length>v&&A[v]!=null)?A[v]:k;var u=this.transparency!=null?this.eN(y[v],this.transparency,true):y[v];f.addColorStop(Math.max(0,Math.min(1,w)),u);k+=p}return f};this.VQ=function(g){var h=g.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(h){var k=h[1];var j,i,f;if(k.length===6){j=parseInt(k.substr(0,2),16)/255;i=parseInt(k.substr(2,2),16)/255;f=parseInt(k.substr(4,2),16)/255}else{j=parseInt(k.charAt(0)+k.charAt(0),16)/255;i=parseInt(k.charAt(1)+k.charAt(1),16)/255;f=parseInt(k.charAt(2)+k.charAt(2),16)/255}if(typeof this.colorFromRgb==="function"){this.yQ(j,i,f)}}};this.yQ=function(i,h,f){var k=this.colorRGB||[1,1,1];var j=this.colorHSV||[0,0,1];if(k&&this.Hl(k)&&k.length===3){if(i!=null){k[0]=Math.min(1,Math.max(0,i))}if(h!=null){k[1]=Math.min(1,Math.max(0,h))}if(f!=null){k[2]=Math.min(1,Math.max(0,f))}var g=this.SZ(k[0],k[1],k[2]);if(g&&j&&this.Hl(j)&&j.length===3){if(g[0]!=null){j[0]=g[0]}j[1]=g[1];j[2]=g[2]}}};this.SZ=function(k,j,g){var f=Math.min(k,j,g);var m=Math.max(k,j,g);var l=m-f;var h=null;var i=0;if(m===0){i=0}else{i=l/m}if(l===0){h=null;i=0}else{if(m===k){h=(j-g)/l+(j<g?6:0)}else{if(m===j){h=(g-k)/l+2}else{h=(k-j)/l+4}}}return[h,i,m]};this.R2=function(f,h,i){var k=this.colorRGB||[1,1,1];var j=this.colorHSV||[0,0,1];if(j&&this.Hl(j)&&j.length===3){if(f!=null){j[0]=Math.min(6,Math.max(0,f))}if(h!=null){j[1]=Math.min(1,Math.max(0,h))}if(i!=null){j[2]=Math.min(1,Math.max(0,i))}var g=this.b9(j[0],j[1],j[2]);if(g&&k&&this.Hl(k)&&k.length===3){k[0]=g[0];k[1]=g[1];k[2]=g[2]}}};this.b9=function(l,k,n){var h,j,o;if(k===0||l==null){h=j=o=n}else{var i=Math.floor(l);var m=l-i;var g=n*(1-k);var f=n*(1-k*m);var r=n*(1-k*(1-m));switch(i){case 0:case 6:h=n;j=r;o=g;break;case 1:h=f;j=n;o=g;break;case 2:h=g;j=n;o=r;break;case 3:h=g;j=f;o=n;break;case 4:h=r;j=g;o=n;break;case 5:h=n;j=g;o=f;break;default:h=j=o=n}}return[Math.max(0,Math.min(1,h)),Math.max(0,Math.min(1,j)),Math.max(0,Math.min(1,o))]};this.pP=function(){var j=this.colorRGB||[1,1,1];if(j&&this.Hl(j)&&j.length===3){var h=Math.round(255*j[0]);var g=Math.round(255*j[1]);var f=Math.round(255*j[2]);var i=function(k){var l=k.toString(16);return l.length===1?"0"+l:l};return i(h)+i(g)+i(f)}return undefined};this.Pl=function(){return this.hj(CanvasXpress.colorNames||{})};this.Xo=function(){return this.hj(CanvasXpress.colorSchemes||{})};this.zD=function(g){if(!g){throw new Error("Input color string is empty or invalid.")}var h=g.toString().toLowerCase().replace(/\s/g,"");var i=a.exec(h);if(i){return i[1]}var k=b.exec(h);if(k&&k[4]==null){var j=this.RL(h);if(j&&j.charAt(0)==="#"){return j.substring(1)}}if(CanvasXpress.colorNames&&CanvasXpress.colorNames.hasOwnProperty(h)){var f=CanvasXpress.colorNames[h];if(f&&f.charAt(0)==="#"){return f.substring(1)}else{if(a.test("#"+f)){return f}}}throw new Error('"'+g+'" is not a valid color name, hex (#RRGGBB), or rgb() string.')};this.b3=function(g,j){var f=g;if(!f||!f.breaks||!f.colors){f=(this.meta&&this.meta.def&&this.meta.def.colorBrew)||(typeof this.getColorBrew==="function"?this.QK():null)}if(!f||!this.Hl(f.breaks)||!this.Hl(f.colors)||f.colors.length===0){return"rgb(0,0,0)"}for(var h=0;h<f.breaks.length;h++){if(j<=f.breaks[h]){return f.colors[Math.min(h,f.colors.length-1)]}}return f.colors[f.colors.length-1]};this.q4=function(f,s){var r=this;var o=f;if(!o){o=(this.meta&&this.meta.def&&this.meta.def.colorBrew)}if(!o||!this.Hl(o.grads)){return"rgba(0,0,0,0)"}var h=function(E,I,C){var A=E*2;var z=A+2;var J=(I.scol||"").replace("#","");var K=(I.ecol||"").replace("#","");if(J.length!==6||K.length!==6){return"00"}var N=J.substring(A,z);var L=K.substring(A,z);var B=parseInt(N,16);var H=parseInt(L,16);if(isNaN(B)||isNaN(H)){return"00"}var F=I.min;var M=I.max;var D=M-F;var P=Math.max(F,Math.min(M,C));var y=H-B;var O=(D===0)?0:(P-F)/D;var i=Math.round(B+(y*O));i=Math.max(0,Math.min(255,i));var G=i.toString(16);return G.length===1?"0"+G:G};var n=function(B){if(B<0||B>=o.grads.length){return"rgba(0,0,0,0)"}var i=o.grads[B];var z=h(0,i,s);var y=h(1,i,s);var A=h(2,i,s);return r.TS("#"+z+y+A)};if(o.grads.length===1){return n(0)}if(this.colorSpectrumBinned){var l=o.stops;var x=o.spectrum;if(!this.Hl(x)||x.length===0){return"rgba(0,0,0,0)"}if(l&&this.Hl(l)&&l.length>1){var m=x.length;var u=l[0];var k=l[l.length-1];if(s<u){return x[0]}if(s>=k){return x[m-1]}for(var v=0;v<l.length-1;v++){if(s>=l[v]&&s<l[v+1]){return x[Math.min(v,m-1)]}}return x[m-1]}else{var q=o.min;var w=o.max;var p=w-q;if(p<=0||x.length===0){return x[0]||"rgba(0,0,0,0)"}var j=p/x.length;var t=Math.floor((s-q)/j);if(s>=w){t=x.length-1}t=Math.max(0,Math.min(x.length-1,t));return x[t]}}else{for(var v=0;v<o.grads.length;v++){var g=o.grads[v];if(s>=g.min&&s<g.max){return n(v)}if(v===o.grads.length-1&&s===g.max){return n(v)}}if(s<o.grads[0].min){return n(0)}if(s>o.grads[o.grads.length-1].max){return n(o.grads.length-1)}return"rgba(0,0,0,0)"}};this.QK=function(n,z,I,L,N,C){var t=function(V,R){var T=[];var U=V.length;if(U<=4||(U<=8&&R>=500)){return V}var P=V[0];var Q=V[U-1];var O,S,i;if(U>8){O=(V[1]+V[2]+V[3]+V[4]+V[5]+V[6]+V[7])/7;S=(P+O)/2;i=(Q+O)/2;if(R<250){T=[P,O,Q]}else{T=[P,S,O,i,Q]}}else{if(U===8){O=(V[1]+V[2]+V[3]+V[4]+V[5]+V[6])/6;S=(P+O)/2;i=(Q+O)/2;if(R<250){T=[P,O,Q]}else{T=[P,S,O,i,Q]}}else{if(U===7){T=[V[0],V[2],V[4],V[6]]}else{if(U===6){O=(V[1]+V[2]+V[3]+V[4])/4;S=(P+O)/2;i=(Q+O)/2;if(R<250){T=[P,O,Q]}else{T=[P,S,O,i,Q]}}else{if(U===5){if(R<250){T=[V[0],V[2],V[4]]}else{T=V}}}}}}return T};var A=n||this.colorSpectrum;var s=this.graphType=="Genome";if(z!=null&&I!=null&&z==I){I+=0.1}var M=z!=null&&N&&N.length?Math.min(z,N[0]):z!=null?z:this.minData!=null?this.minData:0;var g=I!=null&&N&&N.length?Math.max(I,N[N.length-1]):I!=null?I:this.maxData!=null?this.maxData:100;var m=!s&&!C&&this.setMinX!=null?this.setMinX:null;var E=!s&&!C&&this.setMaxX!=null?this.setMaxX:null;var w,K,J;var o=[];if(L==null){J=(M+g)/2}else{J=L;w=J-M;K=g-J;if(w>K){g=J+w}else{M=J-K}}var j=this[this.axisAlgorithm](Math.min(m||M,E||g),Math.max(m||M,E||g),5,this.isGraphTime,this.axisWilkinsonLoose);j=t(j,this.heatmapIndicatorWidth);if(this.colorSpectrumBinned&&N&&N.length){j=N}if(g==Math.abs(M)&&L==0&&j.length%2){j[Math.floor(j.length/2)]=0}var r=(j[j.length-1]-j[0])/(A.length-1);var x=this.wN(j[1]-j[0]);var q=[];for(var F=0;F<j.length;F++){q[F]=j[F].toFixed(x)}var v=this.tx(q);var f=this.r9(v.toString(),this.font);var H=j[j.length-1]-j[0];var p=[];var y=this.colorSpectrumNumber;if(N&&N.length>1&&N.length==A.length){for(var F=0;F<N.length;F++){N[F]=Number(N[F]);p.push(this.ct(N[F].toString()))}v=this.tx(p);f=this.r9(v.toString(),this.font);N=N.sort(function(O,i){return O-i});var G=N[0];var h=Math.ceil(100/A.length)+1;for(var F=1;F<N.length;F++){var l=N[F];var D=this.Cj(G,l,false,h);G=D.pop();o=o.concat(D)}o.push(G);y=o.length}else{o=this.Cj(j[0],j[j.length-1],false,y)}var k={spectrum:A,stops:N,z:L,colors:[],smooth:[],grads:[],rmin:M,rmax:g,min:(N&&N.length>1?N[0]:j[0]),max:(N&&N.length>1?N[N.length-1]:j[j.length-1]),range:H,zero:J,vals:j,valStr:q,incr:r,decs:x,breaks:o,maxLevLen:f,maxLevChr:v.toString().length,maxLevStr:v};for(var F=0;F<A.length-1;F++){var B={scol:this.zD(A[F]),ecol:this.zD(A[F+1]),min:(N&&N.length>1?N[F]:j[0]+(r*F)),max:(N&&N.length>1?N[F+1]:j[0]+(r*(F+1)))};k.grads.push(B)}for(var F=0;F<y;F++){var u=this.q4(k,o[F]);k.colors.push(u);k.smooth.push(u)}return k};this.ra=function(p){var y=this.meta.def;var g=this.meta.data;if(!p){return}var h="";if(this.meta&&g&&g.x&&g.x.hasOwnProperty(p)){h="x"}else{if(this.meta&&g&&g.z&&g.z.hasOwnProperty(p)){h="z"}else{return}}var u=(h==="x")?(g.x[p]?g.x[p].levels:null):(g.z[p]?g.z[p].levels:null);if(!u||!this.Hl(u)){return}if(!y.factorColorBrew){y.factorColorBrew={}}if(!y.factorColorBrew[p]){y.factorColorBrew[p]={}}if(!this.colorSpectrumByFactor){this.colorSpectrumByFactor={}}if(!this.colorSpectrumByFactor[p]){this.colorSpectrumByFactor[p]={}}for(var o=0;o<u.length;o++){var t=u[o];var v=[];var s=[];if(h==="x"){v=this.hA(p,t);for(var n=0;n<v.length;n++){var x=v[n];for(var m=0;m<this.varIndices.length;m++){var r=this.varIndices[m];var w=this.data.y.data[r][x];if(this.t2(w)){s.push(w)}}}}else{v=this.lG(p,t);for(var n=0;n<v.length;n++){var r=v[n];for(var m=0;m<this.smpIndices.length;m++){var x=this.smpIndices[m];var w=this.data.y.data[r][x];if(this.t2(w)){s.push(w)}}}}var q=this.aC(s);if(!this.colorSpectrumByFactor[p][t]){this.colorSpectrumByFactor[p][t]={}}var f=this.colorSpectrumByFactor[p][t];if(!f.spectrum){f.spectrum=this.colorSpectrum}if(f.setMin==null){f.setMin=q[0]}if(f.setMax==null){f.setMax=q[1]}if(f.zero==null){f.zero=null}if(!f.breaks){f.breaks=[]}if(f.show==null){f.show=true}if(f.order==null){f.order=0}var l=this.QK(f.spectrum,f.setMin,f.setMax,f.zero,f.breaks);y.factorColorBrew[p][t]=l;y.factorColorBrew[p][t].show=f.show;y.factorColorBrew[p][t].order=f.order}};this.cq=function(m,j,i){this.h0();var q=this.meta.def;var o=q.colorBrew;if(!o||m||this.heatmapAutoAdjust){if(this.meta.vals&&this.meta.vals.colors){this.meta.vals.colors={}}var n,k;if(this.graphType&&this.graphType.match(/Stacked/)){n=this.minDataStacked;k=this.maxDataStacked}else{if(this.isTransformedData&&j){var p=this.showHistogram?0.000001:this.minData;var g=this.maxData;if(this.data&&this.data.y&&this.data.y.trans){n=this.XV(this.data.y.trans);k=this.Wj(this.data.y.trans)}else{n=this.minData;k=this.maxData}if(!this.t2(n,true)||!this.t2(k,true)){n=0;k=1}}else{if(i){n=i.rmin;k=i.rmax}else{n=this.minData;k=this.maxData}}}q.colorBrew=this.QK(this.colorSpectrum,n,k,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(j){var f=o;var h=this.minData!=null?this.minData:f.rmin;var l=this.maxData!=null?this.maxData:f.rmax;if(i){h=i.rmin;l=i.rmax}q.colorBrew=this.QK(this.colorSpectrum,h,l,f.z,f.stops)}else{var f=o;q.colorBrew=this.QK(this.colorSpectrum,f.rmin,f.rmax,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}}};this.lX=function(r,o,j){var k=r||8;var x=o||this.colorScheme;var s=CanvasXpress.colorSchemes||{};if(!x||!s.hasOwnProperty(x)){if(!s.hasOwnProperty(x)){return this.colors||["rgb(0,0,0)","rgb(255,255,255)"]}}var p=s[x];var n=this.iH(p).map(Number).sort(function(y,i){return y-i});if(n.length===0){return this.colors||["rgb(0,0,0)","rgb(255,255,255)"]}if(p[k]){return this.Ev(p[k])}var g=n[n.length-1];if(g===256&&p[256]&&this.Hl(p[256])){var h=p[256];var m=[];var w=this.OM(k);for(var t=0;t<k;t++){var l=Math.max(0,Math.min(255,Math.floor(w[t]*256)));m.push(h[l])}return m}if(k>g){var f=this.Ev(p[g]);if(j){return f}else{var v=f.slice();var u=f.length;for(var t=u;t<k;t++){v.push(f[t%u])}return v}}if(k<g){var q=g;for(var t=0;t<n.length;t++){if(n[t]>=k){q=n[t];break}}return this.Ev(p[q])}return this.Ev(p[g])};this.h0=function(){var g=this.meta.def;var l=this.blindnessType;var k=g.blindnessTypeSpectrum;var j=g.colorSpectrum;if(l&&(!j||l!==k)){if(!j){g.colorSpectrum=this.Ev(this.colorSpectrum);j=g.colorSpectrum}var f=[];for(var h=0;h<j.length;h++){f.push(typeof this.blindColor==="function"?this.RG(j[h]):j[h])}this.colorSpectrum=f;g.blindnessTypeSpectrum=l;delete g.colorBrew}else{if(!l&&k&&j){this.colorSpectrum=this.Ev(j);g.blindnessTypeSpectrum=null;delete g.colorBrew}}};this.dX=function(D,f){var u=this;var n=false;var w;var v=this.meta.def;var y=this.meta.data;var h=function(G){if(u.data&&u.data[G]){if(u.colorBy&&u.meta.data[G]&&u.meta.data[G].hasOwnProperty(u.colorBy)){var F=u.meta.data[G][u.colorBy];return F.colors?F.colors.length:(F.levels?F.levels.length:u.data.y.smps.length)}else{var i=u.data.y.smps.length;if(u.meta.data&&u.meta.data[G]){for(var E in u.meta.data[G]){if(u.meta.data[G][E].levels){i=Math.max(i,u.meta.data[G][E].levels.length)}}}return i}}return u.data&&u.data.y?u.data.y.smps.length:8};if(this.colorScheme==="User"){w=this.Ev(this.colors||[])}else{if(this.colorScheme==="ColorSpectrum"){var g=this.graphType==="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var A=this.colorSpectrumNumber;this.colorSpectrumNumber=g;var q=this.QK(this.colorSpectrum,0,g);w=q.colors;this.colorSpectrumNumber=A}else{var m;if(D&&D.type==="String"&&D.levels){m=D.levels.length}else{if(this.th()){if(this.layoutValid&&!this.showHistogram){m=h("z")}else{if(this.showHistogram){var k=!this.layoutValid?h("z"):1;m=this.data.y.smps.length*k}else{if(this.colorBy&&y&&y.z&&y.z.hasOwnProperty(this.colorBy)&&y.z[this.colorBy].colors){m=y.z[this.colorBy].levels.length}else{m=this.data.y.smps.length}}}}else{if(this.graphType&&this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){m=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&y.x[this.colorBy].colors?y.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType&&this.graphType.match(/Venn/)){m=this.vennGroups||3}else{if(this.graphType&&this.graphType.match(/Pie/)){m=this.data.y.vars.length}else{if(this.graphType&&this.graphType.match(/Network|Genome|Correlation/)){var x=CanvasXpress.colorSchemes||{};var r=x[this.colorScheme]||{};var l=this.iH(r).map(Number).sort(function(E,i){return E-i});m=l.length>0?l[l.length-1]:8}else{if(this.graphType==="ParallelCoordinates"){m=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&y.x[this.colorBy].colors?y.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType&&this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor&&(!this.isGroupedData||!this.colorBy)){m=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){var s=y.x[this.colorBy];m=s.colors?s.colors.length:(s.levels?s.levels.length:this.data.y.vars.length)}else{m=this.data.y.vars.length}}}}}}}}}w=this.lX(m,this.colorScheme);if(v.colors&&JSON.stringify(v.colors)!==JSON.stringify(w)){v.colors=this.Ev(w);n=true}else{if(!v.colors){v.colors=this.Ev(w);n=true}}}}var j=w;var p=this.blindnessType;var t=v.blindnessTypeColors;var o=v.colors;if(p&&(!o||p!==t||n)){if(!o||n){v.colors=this.Ev(w);o=v.colors}var B=[];for(var z=0;z<o.length;z++){B.push(typeof this.blindColor==="function"?this.RG(o[z]):o[z])}j=B;v.blindnessTypeColors=p}else{if(!p&&t&&o){j=this.Ev(o);v.blindnessTypeColors=null}}var C=[];for(var z=0;z<j.length;z++){C.push(this.ZM(j[z])||"rgb(0,0,0)")}if(!D){this.colors=C}this.By(C,D)};this.ej=function(){if(this.Hl(this.colors)){var h=[];for(var f=0;f<this.colors.length;f++){h.push(this.ZM(this.colors[f])||"rgb(0,0,0)")}this.colors=h}else{this.colors=[]}if(this.Hl(this.colorSpectrum)){var g=[];for(var f=0;f<this.colorSpectrum.length;f++){g.push(this.ZM(this.colorSpectrum[f])||"rgb(0,0,0)")}this.colorSpectrum=g}else{this.colorSpectrum=[]}}};CanvasXpress.prototype.initAttributes=function(){this.hJ=function(b,a,c){return{fillStyle:b,strokeStyle:b,lineWidth:(a?a:this.outlineWidth),lineCap:(c?c:this.capType),funcs:[]}};this.Pw=function(k,j,l,e,g,d,c,a,i,m){if(m){this.WF(m);this.Be(k,j,m);if(a){this.pn(a,m)}}var b={funcs:[]};if(this.transparency!=null){g=this.eN(g,this.transparency,true)}if(this.gradient){if(this.gradientType=="radial"){b.fillStyle=this.AO(0,0,Math.max(Math.abs(l),Math.abs(e)),false,g)}else{b.fillStyle=this.AO(0,0,l,e,g)}}else{if(c){switch(c){case"closed":case"solid":b.fillStyle=g;break;case"open":break;default:if(g){if(g.match(/0.1\)$/)&&d.match(/0.1\)$/)){b.globalAlpha=0.1}}b.fillStyle=CanvasXpress.cachePatterns[c]?CanvasXpress.cachePatterns[c]:g;break}}else{b.fillStyle=g}}b.strokeStyle=d?d:this.foreground;b.lineWidth=i?i:this.outlineWidth;b.lineJoin=this.joinType;if((l&&b.lineWidth>=l)||(e&&b.lineWidth>=e)){b.strokeStyle=g}return b};this.VN=function(b,d,c,a){if(c&&c=="open"){a.funcs.push(["stroke",[]])}else{if(d==b){a.funcs.push(["fill",[]])}else{a.funcs.push(["fill",[]]);a.funcs.push(["stroke",[]])}}};this.cF=function(a){if(!a){a=this.us()}a.resetContext()};this.nD=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left-1;d=this.marginTop+this.offsetY+this.top-1;a=this.x+2;e=this.y+2}return[b,d,a,e]};this.il=function(a,e){if(this.graphType=="Tree"){return}if(!e){e=this.us()}var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{if(this.layoutValid&&this.layoutParams&&this.layoutParams[0]){d=this.marginLeft+this.offsetX+this.layoutParams[0].left;f=this.marginTop+this.offsetY+this.layoutParams[0].top;c=this.layoutParams[0].x+1;g=this.layoutParams[0].y+1}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}}e.o.push({funcs:[["save",[]],["beginPath",[]],["rect",[d,f,c,g]],["clip",[]]]})};this.Np=function(a){if(this.graphType=="Tree"){return}if(!a){a=this.us()}a.o.push({funcs:[["restore",[]],["beginPath",[]],["rect",[0,0,this.width,this.height]],["clip",[]]]})};this.Tx=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.t5=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.PW=function(n,l,h){var k,j,d,m;if(!l){l=this.nD();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.Tx(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.Tx(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.t5(k,j,e,l);e=this.Tx(k,l)}else{j=this.t5(k,j,d,l);d=this.Tx(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.XN=function(l,j,c){var h,d,g,a,e;var k=[];if(!j){j=this.nD();j[2]+=j[0];j[3]+=j[1]}if(c){k=[];for(var f=1;f<l.length;f+=2){k.push([l[f],l[f+1]])}}else{k=l}for(var b=1;b<=8;b*=2){h=[];d=k[k.length-1];g=!(this.Tx(d,j)&b);for(var f=0;f<k.length;f++){a=k[f];e=!(this.Tx(a,j)&b);if(e!==g){h.push(this.t5(d,a,b,j))}if(e){h.push(a)}d=a;g=e}k=h;if(!k.length){break}}if(c){l=["poly"];for(var f=0;f<h.length;f++){l.push(h[f][0]);l.push(h[f][1])}return l}return h};this.dl=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.GG=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.nD()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"roundArrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"rect4":case"rectline":case"rect2i":case"rect3i":case"rect4i":case"rectlinei":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.k2(f[0]-(f[2]/2));p=this.k2(f[1]-(f[3]/2));c=this.k2(d+f[2]);n=this.k2(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.mJ=function(T,F,a,D,am,af,S,X,H,g,aj,ak,V,Y,Z,G){var ab=this.graphType=="Network"?this.lineWidthEvent:this.lineWidthEvent*4;var W=[];var M=["poly"];var U,ai,ag,J;if(!T){T="line"}if(this.Hl(H)){U=H[0];ai=H[1]}else{U=H;ai=H}if(this.Hl(g)){ag=g[0];J=g[1]}else{ag=g;J=g}if(!this.t2(ag,true)){ag=0}if(!this.t2(U,true)){U=0}if(!this.t2(J,true)){J=0}if(!this.t2(ai,true)){ai=0}T=this.NH(T,F,a,D,am,U,ag);if(T.match(/error/)){if(this.showErrorBars&&this.Nv([F,a,D,am,S])){F=Math.ceil(F);D=Math.ceil(D);a=Math.ceil(a);am=Math.ceil(am);S=Math.ceil(S);var O=S/2;if(S>0){M=["poly",F,a-ab,D-ab,am-ab,D-ab,am-O,D+ab,am-O,D+ab,am+O,D-ab,am+O,D-ab,am+ab,F,a+ab]}else{M=["poly",D-ab,am+ab,D-O,am+ab,D-O,am-ab,D+O,am-ab,D+O,am+ab,D+ab,am+ab,F+ab,a,F-ab,a]}}else{return false}}else{if(T=="spline"||T=="cardinalSpline"){if(F.length<3){return F.length<2?false:this.mJ("line",F[0],a[0],F[1],a[1],af,S,X,U,ag,aj,ak,V,Y,Z)}for(var ae=0;ae<F.length;ae++){M.push(F[ae],a[ae]-ab);W.push(a[ae]+ab,F[ae])}M=M.concat(W.reverse())}else{if(T=="arch"){if(F.length!=3||a.length!=3){return false}for(var ae=0;ae<F.length;ae++){if(!this.Nv([F[ae],a[ae]])){return false}}W=this.XW(F[0],a[0],F[1],a[1],F[2],a[2],0.25,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.XW(F[0],a[0],F[1],a[1],F[2],a[2],0.25);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="arc"){M=["poly"];W=this.BC(F,a,D,U,ag,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.BC(F,a,D-ab,U,ag);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="quadratic"){var y=this.xp(F,a,D,am,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(V))*(V>0?-1:1));var E=this.U8(F,a,D,am,U,ag,T,V);var z=this.R6(E[0],E[1],y[0],y[1],ab);var x=this.R6(y[0],y[1],E[2],E[3],ab);W=this.XW(z[0],z[1],z[4],z[5],x[4],x[5],0.1,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}var Q=[];W=this.XW(z[2],z[3],z[6],z[7],x[6],x[7],0.1,true);for(var ae=0;ae<W.length;ae++){Q.push(W[ae][1],W[ae][0])}M=M.concat(Q.reverse())}else{if(T=="roundLine"){M=["poly",F-ab,a,F-ab,am+ab,D,am+ab,D,am-ab,F+ab,am-ab,F+ab,a]}else{if(T=="bracket"){var ah=F+((D-F)*this.treeBracketFactor);M=["poly",F,a-ab,ah,a-ab,ah,am+ab,D,am+ab,D,a+ab,ah,a+ab,ah,am-ab]}else{if(this.Nv([F,a,D,am])){var K=this.U8(F,a,D,am,U,ag,T);F=K[0];a=K[1];D=K[2];am=K[3];if(aj){K=this.GG("line",[F,a,D,am],ak);if(K){F=K[0];a=K[1];D=K[2];am=K[3]}else{return false}}if(V&&this.Hl(V)&&V.length>0){if(this.Mb(V)){if(T.match(/bezier/i)){if(V[0].length==6){var al=[V[0][0],V[0][1]];for(var ae=0;ae<V.length;ae++){al=al.concat(V[ae])}al.push(V[V.length-1][0],V[V.length-1][1]);var h=this.Ev(al);for(var ae=0;ae<V.length;ae++){W=this.Za(h[0],h[1]-ab,h[2],h[3]-ab,h[4],h[5]-ab,h[6],h[7]-ab,0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}for(var ad=0;ad<6;ad++){h.shift()}}h=this.Ev(al);var Q=[];for(var ae=0;ae<V.length;ae++){W=this.Za(h[0],h[1]+ab,h[2],h[3]+ab,h[4],h[5]+ab,h[6],h[7]+ab,0.1,true);for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}for(var ad=0;ad<6;ad++){h.shift()}}M=M.concat(Q.reverse())}else{if(V.length==4){var z=this.R6(V[0][0],V[0][1],V[1][0],V[1][1],ab);var x=this.R6(V[2][0],V[2][1],V[3][0],V[3][1],ab);W=this.Za(z[0],z[1],z[4],z[5],x[0],x[1],x[4],x[5],0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}W=this.Za(z[2],z[3],z[6],z[7],x[2],x[3],x[6],x[7],0.1,true);var Q=[];for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}M=M.concat(Q.reverse())}else{var C=this.R6(V[0][0],V[0][1],V[V.length-1][0],V[V.length-1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{if(V.length>2){M=["poly"];var P=[];for(var ae=0;ae<V.length-1;ae++){P.push([V[ae][0],V[ae][1]])}for(var ae=V.length-1;ae>=1;ae--){P.push([V[ae][0],V[ae][1]])}W=this.E7(P,ab,1);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{var C=this.R6(V[0][0],V[0][1],V[1][0],V[1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{return false}}else{if(T.match(/curved/i)){var B=F==D&&a==am&&G;var u=this.So(F,a,D,am);var R=this.iP(F,a,u[0],u[1]);var N=(U||0)/R;var I=(ag||0)/R;var A=T.match(/curvedcc/i)&&F>D?false:!T.match(/curvedcc/i)&&D>=F?true:false;var r=D>=F?Math.asin((u[1]-a)/R):Math.asin(-(u[1]-a)/R);var ac=r+Math.PI;var o=[];var d=0;var aa=false;if(B){if(r<0){r+=Math.PI*2}var v=G.size;var L=G.size*0.5;switch(G.pos){case"top":o=[F,a-v,L,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":o=[F+v,a-v,L,Math.PI,Math.PI*0.5,false];break;case"right":o=[F+v,a,L,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":o=[F+v,a+v,L,Math.PI*1.5,Math.PI,false];break;case"bottom":o=[F,a+v,L,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":o=[F-v,a+v,L,0,Math.PI*1.5,false];break;case"left":o=[F-v,a,L,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":o=[F-v,a-v,L,Math.PI*0.5,0,false];break}d=0.25}else{if(D>=F){o=[u[0],u[1],Math.max(0,R),r-I,ac+N,A]}else{aa=true;o=[u[0],u[1],Math.max(0,R),ac-I,r+N,!A]}}M=["poly"];W=this.DQ(o[0],o[1],o[2]+ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?-1:1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.DQ(o[0],o[1],o[2]-ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?1:-1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T.match(/bezier/i)){var l=(F+D)/2;var k=(a+am)/2;if(T.match(/beziery/i)){W=this.Za(F,a-ab,F,k-ab,D,k-ab,D,am-ab,0.25,true)}else{W=this.Za(F,a-ab,l,a-ab,l,am-ab,D,am-ab,0.25,true)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}if(T.match(/beziery/i)){W=this.Za(F,a+ab,F,k+ab,D,k+ab,D,am+ab,0.25)}else{W=this.Za(F,a+ab,l,a+ab,l,am+ab,D,am+ab,0.25)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(F==D&&a!=am){M=["poly",F-ab,a,F+ab,a,D+ab,am,D-ab,am]}else{if(a==am&&F!=D){M=["poly",F,a-ab,D,a-ab,D,am+ab,F,am+ab]}else{var C=this.R6(F,a,D,am,ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}}}}else{return false}}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?M:this.nJ(M)}else{return M}};this.er=function(b){if(!b){b="solid"}var a=[];if(b.match(/blank/i)){a=CanvasXpress.R.lty[0]}else{if(b.match(/solid/i)){a=CanvasXpress.R.lty[1]}else{if(b.match(/dashed/i)){a=CanvasXpress.R.lty[2];a=[this.dashLength,this.dashLength-2]}else{if(b.match(/dotted/i)){a=CanvasXpress.R.lty[3];a=[this.dotLength,this.dotLength+2]}else{if(b.match(/dotdash/i)){a=CanvasXpress.R.lty[4]}else{if(b.match(/longdash/i)){a=CanvasXpress.R.lty[5]}else{if(b.match(/twodash/i)){a=CanvasXpress.R.lty[6]}}}}}}}return a};this.NH=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.hC=function(Y,G,a,E,au,ak,X,ad,K,g,ap,at,ac,ae,ag,H,U,I){if(!I){I=this.us()}var D=this.er(Y,I);var aa,ao,am,N,z;if(this.Hl(K)){aa=K[0];ao=K[1]}else{aa=K;ao=K}if(this.Hl(g)){am=g[0];N=g[1]}else{am=g;N=g}if(!this.t2(am,true)){am=0}if(!this.t2(aa,true)){aa=0}if(!this.t2(N,true)){N=0}if(!this.t2(ao,true)){ao=0}Y=this.NH(Y,G,a,E,au,aa,am);var k=false;var V=this;var ab=function(){if(z){var b=V.hJ("rgb(255,255,255)",z[4],false);b.funcs.push(["beginPath",[]]);b.funcs.push(["moveTo",[z[0],z[1]]]);b.funcs.push(["lineTo",[z[2],z[3]]]);b.funcs.push(["closePath",[]]);b.funcs.push(["stroke",[]]);I.o.push(b);V.cF(I)}};var J=function(b){switch(b){case"arrow":k=0;break;case"square":k=1;break;case"round":k=2;break;case"roundDocked":k=false;break;case"arrowOpen":k=3;break;case"arrowWire":k=4;break;case"arrowArc":k=5;break;case"arrowArcOpen":k=6;break}};if(!Y){Y="solid"}if(Y.match(/error/)){if(this.showErrorBars&&this.Nv([G,a,E,au,X])){G=Math.ceil(G);E=Math.ceil(E);a=Math.ceil(a);au=Math.ceil(au);X=Math.ceil(X);var T=X/2;if(!this.nW(ak,true)){var S=this.hJ(ak,false,ad);S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G,a]]);S.funcs.push(["lineTo",[E,au]]);S.funcs.push(["stroke",[]]);if(Math.abs(X)>this.errorBarsWidth){if(X>0){S.funcs.push(["moveTo",[E,au-T]]);S.funcs.push(["lineTo",[E,au+T]]);S.funcs.push(["stroke",[]])}else{S.funcs.push(["moveTo",[E-T,au]]);S.funcs.push(["lineTo",[E+T,au]]);S.funcs.push(["stroke",[]])}}S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I)}}}else{if(Y.match(/spline|cardinalSpline/i)){if(G.length<3){return G.length<2?false:this.hC(Y.match(/dashedSpline/i)?"dashedLine":"line",G[0],a[0],G[1],a[1],ak,X,ad,K,g,ap,at,ac,ae,ag,false,false,I)}var Z=[];var ar=[];var al=0;for(var aj=0;aj<G.length;aj++){if(this.Nv([G[aj],a[aj]])){ar.push(G[aj],a[aj]);al+=2}else{return}}var S=this.hJ(ak,X,ad);if(!this.nW(ak,true)){S.funcs.push(["setLineDash",[D]]);if(Y.match(/spline/i)){for(var aj=0;aj<al-4;aj+=2){Z=Z.concat(this.G7(ar[aj],ar[aj+1],ar[aj+2],ar[aj+3],ar[aj+4],ar[aj+5]))}S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ar[0],ar[1]]]);S.funcs.push(["quadraticCurveTo",[Z[0],Z[1],ar[2],ar[3]]]);for(var aj=2;aj<al-5;aj+=2){S.funcs.push(["quadraticCurveTo",[Z[2*aj-2],Z[2*aj-1],ar[aj+2],ar[aj+3]]])}S.funcs.push(["moveTo",[ar[al-2],ar[al-1]]]);S.funcs.push(["quadraticCurveTo",[Z[2*al-10],Z[2*al-9],ar[al-4],ar[al-3]]]);S.funcs.push(["stroke",[]])}else{ar=this.KB(ar);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ar[0],ar[1]]]);for(var aj=2;aj<ar.length-1;aj+=2){S.funcs.push(["lineTo",[ar[aj],ar[aj+1]]])}S.funcs.push(["stroke",[]])}S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I)}else{if(Y.match(/arch/)){if(G.length!=3||a.length!=3){return false}for(var aj=0;aj<G.length;aj++){if(!this.Nv([G[aj],a[aj]])){return false}}var S=this.hJ(ak,X,ad);if(!this.nW(ak,true)){S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G[0],a[0]]]);S.funcs.push(["quadraticCurveTo",[G[1],a[1],G[2],a[2]]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I);if(ag){J(ag);z=this.NM(G[1],a[1],G[2],a[2],ak,X,k,false,I)}if(ae){J(ae);z=this.NM(G[0],a[0],G[1],a[1],ak,X,k,true,I)}}else{if(Y=="arc"){var S=this.hJ(ak,X,ad);S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["arc",[G,a,Math.max(0,E),ao,N,false]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I)}else{if(Y=="quadratic"){var S=this.hJ(ak,X,ad);var y=this.xp(G,a,E,au,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(ac))*(ac>0?-1:1));var F=this.U8(G,a,E,au,ao,N,Y,ac);var aq=this.XW(F[0],F[1],y[0],y[1],F[2],F[3],0.1,true);S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[F[0],F[1]]]);S.funcs.push(["quadraticCurveTo",[y[0],y[1],F[2],F[3]]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I);if(ag){G=aq[9][0];a=aq[9][1];E=F[2];au=F[3];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){G=aq[1][0];a=aq[1][1];E=F[0];au=F[1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}else{if(Y=="roundLine"){var S=this.hJ(ak,X,ad);S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G,a]]);if(a>au){S.funcs.push(["lineTo",[G,au+this.roundedPolygonRadius]]);if(G>E){S.funcs.push(["quadraticCurveTo",[G,au,G-this.roundedPolygonRadius,au]])}else{S.funcs.push(["quadraticCurveTo",[G,au,G+this.roundedPolygonRadius,au]])}}else{S.funcs.push(["lineTo",[G,au-this.roundedPolygonRadius]]);if(G>E){S.funcs.push(["quadraticCurveTo",[G,au,G-this.roundedPolygonRadius,au]])}else{S.funcs.push(["quadraticCurveTo",[G,au,G+this.roundedPolygonRadius,au]])}}S.funcs.push(["lineTo",[E,au]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I);if(ag){J(ag);z=this.NM(G,au,E,au,ak,X,k,false,I)}if(ae){J(ae);z=this.NM(G,au,E,au,ak,X,k,true,I)}}else{if(Y=="bracket"){var an=G+((E-G)*this.treeBracketFactor);var S=this.hJ(ak,X,ad);S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G,a]]);S.funcs.push(["lineTo",[an,a]]);S.funcs.push(["lineTo",[an,au]]);S.funcs.push(["lineTo",[E,au]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I);if(ag){J(ag);z=this.NM(an,a,E,au,ak,X,k,false,I)}if(ae){J(ae);z=this.NM(G,a,an,au,ak,X,k,true,I)}}else{if(this.Nv([G,a,E,au])){var O=this.U8(G,a,E,au,ao,N,Y);var j=this.U8(G,a,E,au,ae?aa:ao,ag?am:N,Y);G=O[0];a=O[1];E=O[2];au=O[3];if(ap){O=this.GG("line",[G,a,E,au],at);if(O){G=O[0];a=O[1];E=O[2];au=O[3]}else{return false}}if(ac&&this.Hl(ac)&&ac.length>0){var Q=ac.length-1;if(this.Mb(ac)){var S=this.hJ(ak,X,ad);S.funcs.push(["setLineDash",[D]]);if(Y.match(/bezier/i)){if(!this.nW(ak,true)){if(ac[0].length==6){S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ac[0][0],ac[0][1]]]);for(var aj=0;aj<ac.length;aj++){S.funcs.push(["bezierCurveTo",[ac[aj][0],ac[aj][1],ac[aj][2],ac[aj][3],ac[aj][4],ac[aj][5]]])}S.funcs.push(["stroke",[]]);var aq;if(ag){aq=this.Za(ac[Q][0],ac[Q][1],ac[Q][0],ac[Q][1],ac[Q][2],ac[Q][3],ac[Q][4],ac[Q][5],0.1,true);G=aq[9][0];a=aq[9][1];E=aq[10][0];au=aq[10][1];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){aq=this.Za(ac[0][0],ac[0][1],ac[0][0],ac[0][1],ac[0][2],ac[0][3],ac[0][4],ac[0][5],0.1,true);G=aq[1][0];a=aq[1][1];E=aq[0][0];au=aq[0][1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}else{if(ac.length==4){S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ac[0][0],ac[0][1]]]);S.funcs.push(["bezierCurveTo",[ac[1][0],ac[1][1],ac[2][0],ac[2][1],ac[3][0],ac[3][1]]]);S.funcs.push(["stroke",[]]);var aq=this.Za(ac[0][0],ac[0][1],ac[1][0],ac[1][1],ac[2][0],ac[2][1],ac[3][0],ac[3][1],0.1,true);if(ag){G=aq[9][0];a=aq[9][1];E=ac[3][0];au=ac[3][1];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){G=aq[1][0];a=aq[1][1];E=ac[1][0];au=ac[1][1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}else{S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ac[0][0],ac[0][1]]]);S.funcs.push(["lineTo",[ac[Q][0],ac[Q][1]]]);S.funcs.push(["stroke",[]]);if(ag){G=ac[Q-1][0];a=ac[Q-1][1];E=ac[Q][0];au=ac[Q][1];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){G=ac[0][0];a=ac[0][1];E=ac[1][0];au=ac[1][1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}}}}else{if(!this.nW(ak,true)){S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[ac[0][0],ac[0][1]]]);for(var aj=0;aj<Q;aj++){S.funcs.push(["lineTo",[ac[aj+1][0],ac[aj+1][1]]])}S.funcs.push(["stroke",[]]);if(ag){G=ac[Q-1][0];a=ac[Q-1][1];E=ac[Q][0];au=ac[Q][1];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){G=ac[0][0];a=ac[0][1];E=ac[1][0];au=ac[1][1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}}S.funcs.push(["setLineDash",[[]]]);I.o.push(S);this.cF(I)}else{return false}}else{if(Y.match(/curved/i)){var C=G==E&&a==au&&H;var v=this.So(G,a,E,au);var W=Math.max(1,this.iP(G,a,v[0],v[1]));var R=(aa||0)/W;var M=(am||0)/W;var h=(ao||0)/W;var L=(N||0)/W;var B=Y.match(/curvedcc/i)&&G>E?false:!Y.match(/curvedcc/i)&&E>=G?true:false;var u=E>=G?Math.asin((v[1]-a)/W):Math.asin(-(v[1]-a)/W);var ai=u+Math.PI;var r=[];var A=[];var af=this.arrowHeadSize;var S=this.hJ(ak,X,ad);if(!this.nW(ak,true)){var d=0;var ah=false;if(C){if(u<0){u+=Math.PI*2}if(H.dir){ag=false;ae=H.end}else{ag=H.end;ae=false}var x=H.size;var P=H.size*0.5;this.arrowHeadSize=Math.ceil(H.size/3);switch(H.pos){case"top":r=[G,a-x,P,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":r=[G+x,a-x,P,Math.PI,Math.PI*0.5,false];break;case"right":r=[G+x,a,P,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":r=[G+x,a+x,P,Math.PI*1.5,Math.PI,false];break;case"bottom":r=[G,a+x,P,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":r=[G-x,a+x,P,0,Math.PI*1.5,false];break;case"left":r=[G-x,a,P,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":r=[G-x,a-x,P,Math.PI*0.5,0,false];break}d=0.25}else{if(E>=G){r=[v[0],v[1],Math.max(0,W),u-L,ai+h,B];A=[v[0],v[1],Math.max(0,W),u-M,ai+R,B]}else{ah=true;r=[v[0],v[1],Math.max(0,W),ai-L,u+h,!B];A=[v[0],v[1],Math.max(0,W),ai-M,u+R,!B]}}S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["arc",[r[0],r[1],r[2],r[3]+(ag?d:0),r[4]-(ae?d:0),r[5]]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I);var aq;if(ag||ae){aq=this.DQ(A[0],A[1],A[2],(ah?A[4]-(Math.PI*2):A[3]),(ah?A[3]:A[4]),A[5]*(ah?-1:1))}if(ag||(ah&&ae)){G=aq[15][0];a=aq[15][1];E=aq[16][0];au=aq[16][1];if(ah&&ae){J(ae)}else{J(ag)}z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae||(ah&&ag)){G=aq[1][0];a=aq[1][1];E=aq[0][0];au=aq[0][1];if(ah&&ag){J(ag)}else{J(ae)}z=this.NM(G,a,E,au,ak,X,k,true,I)}this.arrowHeadSize=af}else{if(Y.match(/bezier/i)){var o=(G+E)/2;var l=(a+au)/2;var aq;var S=this.hJ(ak,X,ad);if(!this.nW(ak,true)){S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G,a]]);if(this.graphType=="Tree"&&this.treeType=="circular"&&U){S.funcs.push(["bezierCurveTo",[U[2],U[3],U[0],U[1],E,au]]);aq=this.Za(G,a,U[0],U[1],U[0],U[1],E,au,0.1,true)}else{if(Y.match(/beziery/i)){S.funcs.push(["bezierCurveTo",[G,l,E,l,E,au]]);aq=this.Za(G,a,G,l,E,l,E,au,0.1,true)}else{S.funcs.push(["bezierCurveTo",[o,a,o,au,E,au]]);aq=this.Za(G,a,o,a,o,au,E,au,0.1,true)}}S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I);if(ag){G=aq[9][0];a=aq[9][1];E=aq[10][0];au=aq[10][1];J(ag);z=this.NM(G,a,E,au,ak,X,k,false,I)}if(ae){E=aq[0][0];au=aq[0][1];G=aq[1][0];a=aq[1][1];J(ae);z=this.NM(G,a,E,au,ak,X,k,true,I)}}else{if(Y.match(/needle/i)){var S=this.hJ(ak,X,ad);var y=this.R6(G,a,E,au,X);if(!this.nW(ak,true)){S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[y[0],y[1]]]);S.funcs.push(["lineTo",[E,au]]);S.funcs.push(["lineTo",[y[2],y[3]]]);S.funcs.push(["closePath",[]]);S.funcs.push(["stroke",[]]);S.funcs.push(["fill",[]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["arc",[G,a,X*3,0,Math.PI*2]]);S.funcs.push(["stroke",[]]);S.funcs.push(["fill",[]]);S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I)}else{var S=this.hJ(ak,X,ad);if(!this.nW(ak,true)){S.funcs.push(["setLineDash",[D]]);S.funcs.push(["beginPath",[]]);S.funcs.push(["moveTo",[G,a]]);S.funcs.push(["lineTo",[E,au]]);S.funcs.push(["stroke",[]]);S.funcs.push(["setLineDash",[[]]])}I.o.push(S);this.cF(I);if(ag){J(ag);z=this.NM(j[0],j[1],j[2],j[3],ak,X,k,false,I)}if(ae){J(ae);z=this.NM(j[0],j[1],j[2],j[3],ak,X,k,true,I)}}}}}ab()}else{return false}}}}}}}}};this.NM=function(v,b,t,a,u,k,h,e,q){if(!q){q=this.us()}var o,n;var s=function(z,C,f,D){var w=[];for(var A=0;A<z.length;A++){w.push([(z[A][0]*Math.cos(C))-(z[A][1]*Math.sin(C)),(z[A][0]*Math.sin(C))+(z[A][1]*Math.cos(C))])}var B=[];for(var A=0;A<w.length;A++){B.push([w[A][0]+f,w[A][1]+D])}return B};if(h==0){return this.Zh(v,b,t,a,u,k,1,q)}else{var p=this.hJ(u,k,false);if(h==1){var c=this.arrowHeadSize/2;var d=this.U8(v,b,t,a,0,c+1,"line");var m=d[2]-d[0];var j=d[3]-d[1];var l=k?k/2:this.outlineWidth/2;var g=s([[-l,-this.arrowHeadSize],[-l,this.arrowHeadSize]],Math.atan2(j,m),d[2],d[3]);p.funcs.push(["beginPath",[]]);p.funcs.push(["moveTo",[g[0][0],g[0][1]]]);for(var r=1;r<g.length;r++){if(!isNaN(g[r][0])&&!isNaN(g[r][1])){p.funcs.push(["lineTo",[g[r][0],g[r][1]]])}}p.funcs.push(["closePath",[]]);p.funcs.push(["stroke",[]]);o=(g[0][0]+g[1][0])/2;n=(g[0][1]+g[1][1])/2}else{if(h==2){var c=this.arrowHeadSize/2;var d=this.U8(v,b,t,a,0,c+1,"line");p.fillStyle="rgb(255,255,255)";p.funcs.push(["beginPath",[]]);p.funcs.push(["arc",[d[2],d[3],Math.max(0,Math.max(c-1,1)*1.3),0,Math.PI*2,true]]);p.funcs.push(["closePath",[]]);p.funcs.push(["fill",[]]);p.funcs.push(["stroke",[]])}else{if(h==3){var x=[this.arrowHeadTypeOpen,this.arrowHeadType];this.arrowHeadTypeOpen=true;this.arrowHeadType="filledStraight";var y=this.Zh(v,b,t,a,u,k,1,q);this.arrowHeadTypeOpen=x[0];this.arrowHeadType=x[1];return y}else{if(h==4){var x=this.arrowHeadType;this.arrowHeadType="wire";var y=this.Zh(v,b,t,a,u,k,1,q);this.arrowHeadType=x;return y}else{if(h==5){var x=this.arrowHeadType;this.arrowHeadType="filledArc";var y=this.Zh(v,b,t,a,u,k,1,q);this.arrowHeadType=x;return y}else{if(h==6){var x=[this.arrowHeadTypeOpen,this.arrowHeadType];this.arrowHeadTypeOpen=true;this.arrowHeadType="filledArc";var y=this.Zh(v,b,t,a,u,k,1,q);this.arrowHeadTypeOpen=x[0];this.arrowHeadType=x[1];return y}else{}}}}}}q.o.push(p);this.cF(q);return h==1?[o,n,t,a,k]:null}};this.Zh=function(t,e,q,b,u,j,l,n){var o=function(Q,w,O,h,L,d,M,G){n.o.push({funcs:[["save",[]]]});G.funcs.push(["beginPath",[]]);G.funcs.push(["moveTo",[Q,w]]);G.funcs.push(["lineTo",[O,h]]);G.funcs.push(["lineTo",[L,d]]);switch(M){case 0:var S=Math.sqrt(((L-Q)*(L-Q))+((d-w)*(d-w)));G.funcs.push(["arcTo",[O,h,Q,w,j*(j<1.01?0.55:0.25)*S]]);G.funcs.push(["fill",[]]);break;case 1:G.funcs.push(["beginPath",[]]);G.funcs.push(["moveTo",[Q,w]]);G.funcs.push(["lineTo",[O,h]]);G.funcs.push(["lineTo",[L,d]]);G.funcs.push(["lineTo",[Q,w]]);G.funcs.push(["fill",[]]);break;case 2:break;case 3:var D=(Q+O+L)/3;var B=(w+h+d)/3;G.funcs.push(["quadraticCurveTo",[D,B,Q,w]]);G.funcs.push(["fill",[]]);break;case 4:var P,N,s,f;var H=5;if(L==Q){var S=d-w;P=(O+Q)/2;s=(O+Q)/2;N=h+S/H;f=h-S/H}else{var S=Math.sqrt(((L-Q)*(L-Q))+((d-w)*(d-w)));var J=(Q+L)/2;var C=(w+d)/2;var K=(J+O)/2;var R=(C+h)/2;var I=(d-w)/(L-Q);var F=(S/(2*Math.sqrt(I*I+1)))/H;var E=I*F;P=K-F;N=R-E;s=K+F;f=R+E}G.funcs.push(["bezierCurveTo",[P,N,s,f,Q,w]]);G.funcs.push(["fill",[]]);break}G.funcs.push(["stroke",[]]);n.o.push(G);n.resetContext();n.o.push({funcs:[["restore",[]]]})};if(!n){n=this.us()}var r=0;switch(this.arrowHeadType){case"wire":r=2;break;case"filledStraight":r=1;break;case"filledArc":r=0;break;case"filledQuadratic":r=3;break;case"filledBezier":r=4;break}var k=l!=null?l:1;var v=this.arrowHeadAngle*Math.PI/180;var x=this.arrowHeadSize;var m=this.hJ(u,j,false);var A=Math.atan2(b-e,q-t);var p=Math.abs(x/Math.cos(v));if(this.arrowHeadTypeOpen){m.fillStyle="rgb(255,255,255)"}if(k==1||k==3){var c=A+Math.PI+v;var i=q+Math.cos(c)*p;var g=b+Math.sin(c)*p;var a=A+Math.PI-v;var z=q+Math.cos(a)*p;var y=b+Math.sin(a)*p;o(i,g,q,b,z,y,r,m)}if(k==2||k==3){var c=A+v;var i=t+Math.cos(c)*p;var g=e+Math.sin(c)*p;var a=A-v;var z=t+Math.cos(a)*p;var y=e+Math.sin(a)*p;o(i,g,t,e,z,y,r,m)}};this.ub=function(l,j,a,q,h,p,g,m,o){var k,i,n,d,b;var c=m!=null?m:1;if(c==1||c==3){k=Math.cos(q)*a+l;i=Math.sin(q)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k+10*Math.cos(n);b=i+10*Math.sin(n)}else{d=k-10*Math.cos(n);b=i-10*Math.sin(n)}this.Zh(k,i,d,b,g,m,2,o)}if(c==2||c==3){k=Math.cos(h)*a+l;i=Math.sin(h)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k-10*Math.cos(n);b=i-10*Math.sin(n)}else{d=k+10*Math.cos(n);b=i+10*Math.sin(n)}this.Zh(k,i,d,b,g,m,2,o)}};this.NB=function(h,d,n,g,j){var l=j*Math.PI/180;var e=h+d;var k=Math.abs(e/(Math.cos(l)||1));var f=Math.abs(e/(Math.sin(l)||1));var a=this.$cX("canvas");a.width=Math.abs(k);a.height=Math.abs(f);var m=this.lg(a);if(!m){console.error("Could not get 2D context for pattern canvas.");return null}m.fillStyle=g;m.fillRect(0,0,a.width,a.height);m.fillStyle=n;m.save();m.translate(a.width/2,a.height/2);m.rotate(l);m.translate(-a.width/2,-a.height/2);var b=Math.sqrt(a.width*a.width+a.height*a.height);for(var c=-b;c<b;c+=e){m.fillRect(c,-b,h,b*2)}m.restore();return a};this.dC=function(k,d,o,j,l){var g=l;var e=-l;var h=g*Math.PI/180;var f=e*Math.PI/180;var c=k+d;var a=this.$cX("canvas");a.width=Math.abs(c/Math.cos(h));a.height=Math.abs(c/Math.sin(h));var n=this.lg(a);if(!n){console.error("Could not get 2D context for pattern canvas.");return null}n.fillStyle=j;n.fillRect(0,0,a.width,a.height);n.fillStyle=o;n.save();n.translate(a.width/2,a.height/2);n.rotate(h);n.translate(-a.width/2,-a.height/2);var m=Math.sqrt(a.width*a.width+a.height*a.height);for(var b=-m;b<m;b+=c){n.fillRect(b,-m,k,m*2)}n.restore();n.save();n.translate(a.width/2,a.height/2);n.rotate(f);n.translate(-a.width/2,-a.height/2);for(var b=-m;b<m;b+=c){n.fillRect(b,-m,k,m*2)}n.restore();return a};this.JG=function(a,h,g,d,e){var f=this.$cX("canvas");var b=this.lg(f);b.strokeStyle=d;b.fillStyle=g;if(e>0&&e<90){if(e<=15){f.width=16;f.height=9;b.clearRect(0,0,16,9);b.beginPath();b.arc(4,3,a,0,Math.PI*2);b.fill();b.stroke();b.beginPath();b.arc(12,6,a,0,Math.PI*2)}else{if(e<=30){f.width=13;f.height=9;b.clearRect(0,0,13,9);b.beginPath();b.arc(3,2,a,0,Math.PI*2);b.fill();b.stroke();b.beginPath();b.arc(10,7,a,0,Math.PI*2)}else{if(e<=45){f.width=10;f.height=10;b.clearRect(0,0,10,10);b.beginPath();b.arc(2,2,a,0,Math.PI*2);b.fill();b.stroke();b.beginPath();b.arc(7,7,a,0,Math.PI*2)}else{if(e<=60){f.width=9;f.height=13;b.clearRect(0,0,9,13);b.beginPath();b.arc(2,3,a,0,Math.PI*2);b.fill();b.stroke();b.beginPath();b.arc(7,10,a,0,Math.PI*2)}else{f.width=9;f.height=16;b.clearRect(0,0,9,16);b.beginPath();b.arc(3,4,a,0,Math.PI*2);b.fill();b.stroke();b.beginPath();b.arc(6,12,a,0,Math.PI*2)}}}}}else{f.width=7;f.height=7;b.clearRect(0,0,7,7);b.beginPath();b.arc(3.5,3.5,a,0,Math.PI*2)}b.fill();b.stroke();return f};this.UR=function(a,c,e,h,g,b,d){if(!a){a=this.us()}switch(e){case"stripe":var f=this.NB(2,7,g,b,h?h*2:90);CanvasXpress.cachePatterns[c]=a.createPattern(f,"repeat");break;case"crosshatch":var f=this.dC(2,7,g,b,h);CanvasXpress.cachePatterns[c]=a.createPattern(f,"repeat");break;case"circle":var f=this.JG(1,7,g,b,h);CanvasXpress.cachePatterns[c]=a.createPattern(f,"repeat");break;default:}if(d){this.patterns[c]=CanvasXpress.cachePatterns[c];this.patterns.unshift(c)}};this.Ad=function(a){var c=this;var f=function(g){g.strokeStyle="rgb(29,137,182)";var h=[4,6,9,12,16,21,27,14,17,21,26];var k=[27,21,16,12,9,6,4,26,21,17,14];for(var j=0;j<h.length;j++){g.moveTo(h[j],k[j]);g.arc(h[j],k[j],2,0,Math.PI*2)}g.moveTo(3,32);g.arc(3,32,2,Math.PI,0);g.moveTo(13,32);g.arc(13,32,2,Math.PI,0);g.moveTo(32,3);g.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);g.moveTo(32,13);g.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);h=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];k=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var j=0;j<h.length;j++){g.moveTo(h[j][0],k[j][0]);g.lineTo(h[j][1],k[j][1])}g.stroke()};var e=function(g){g.strokeStyle="rgb(29,137,182)";g.moveTo(3,0);g.arc(3,0,2,Math.PI,0,true);g.moveTo(3,5);g.arc(3,5,2,Math.PI,0);g.moveTo(6,1);g.lineTo(8,4);g.lineTo(10,1);g.moveTo(13,0);g.arc(13,0,2,Math.PI,0,true);g.moveTo(13,5);g.arc(13,5,2,Math.PI,0);g.stroke()};var b=function(g){g.strokeStyle="rgb(29,137,182)";g.moveTo(0,3);g.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);g.moveTo(5,3);g.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);g.moveTo(1,6);g.lineTo(4,8);g.lineTo(1,10);g.moveTo(0,13);g.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);g.moveTo(5,13);g.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);g.stroke()};var d=function(){if(!a){a=c.us()}var h=c.$cX("canvas");h.width=10;h.height=10;var g=c.lg(h);g.strokeStyle=c.patternStrokeColor;g.fillStyle=c.patternFillColor;g.lineWidth=c.patternStrokeWidth;if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward")){g.clearRect(0,0,10,10);g.beginPath();g.moveTo(0,0);g.lineTo(10,10);g.stroke();CanvasXpress.cachePatterns.hatchForward=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse")){g.clearRect(0,0,10,10);g.beginPath();g.moveTo(10,0);g.lineTo(0,10);g.stroke();CanvasXpress.cachePatterns.hatchReverse=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeVertical")){h.width=3;h.height=3;g.clearRect(0,0,3,3);g.beginPath();g.moveTo(1.5,0);g.lineTo(1.5,3);g.stroke();CanvasXpress.cachePatterns.stripeVertical=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeHorizontal")){g.clearRect(0,0,3,3);g.beginPath();g.moveTo(0,1.5);g.lineTo(3,1.5);g.stroke();CanvasXpress.cachePatterns.stripeHorizontal=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("polkaDot")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,2,0,Math.PI*2);g.fill();CanvasXpress.cachePatterns.polkaDot=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossHatch")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(5,5);g.stroke();g.beginPath();g.moveTo(5,0);g.lineTo(0,5);g.stroke();CanvasXpress.cachePatterns.crossHatch=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossStripe")){h.width=3;h.height=3;g.clearRect(0,0,3,3);g.beginPath();g.moveTo(1.5,0);g.lineTo(1.5,3);g.stroke();g.beginPath();g.moveTo(0,1.5);g.lineTo(3,1.5);g.stroke();CanvasXpress.cachePatterns.crossStripe=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squares")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.strokeRect(1,1,4,4);g.stroke();CanvasXpress.cachePatterns.squares=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("circles")){g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,1,0,Math.PI*2);g.stroke();CanvasXpress.cachePatterns.circles=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("plus")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(3.5,1);g.lineTo(3.5,6);g.stroke();g.beginPath();g.moveTo(1,3.5);g.lineTo(6,3.5);g.stroke();CanvasXpress.cachePatterns.plus=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("minus")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(1,3.5);g.lineTo(6,3.5);g.stroke();CanvasXpress.cachePatterns.minus=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("bars")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(3.5,1);g.lineTo(3.5,6);g.stroke();CanvasXpress.cachePatterns.bars=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesHorizontal")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,5);g.lineTo(2.5,0);g.lineTo(5,5);g.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesVertical")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(5,2.5);g.lineTo(0,5);g.stroke();CanvasXpress.cachePatterns.squiglesVertical=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickForward")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(3,0);g.lineTo(0,3);g.closePath();g.stroke();g.fill();g.beginPath();g.moveTo(2,5);g.lineTo(5,2);g.lineTo(5,5);g.closePath();g.stroke();g.fill();CanvasXpress.cachePatterns.brickForward=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickReverse")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(5,0);g.lineTo(2,0);g.lineTo(5,3);g.closePath();g.stroke();g.fill();g.beginPath();g.moveTo(0,5);g.lineTo(0,2);g.lineTo(3,5);g.closePath();g.stroke();g.fill();CanvasXpress.cachePatterns.brickReverse=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("art")){g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,2,0,Math.PI*2);g.moveTo(0,5);g.lineTo(5,0);g.stroke();CanvasXpress.cachePatterns.art=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("pcx")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(2,0);g.lineTo(0,0);g.lineTo(0,3);g.lineTo(2,3);g.stroke();g.beginPath();g.moveTo(3,3);g.lineTo(5,5);g.stroke();g.beginPath();g.moveTo(5,3);g.lineTo(3,5);g.stroke();CanvasXpress.cachePatterns.pcx=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward3")){h.width=5;h.height=3;g.clearRect(0,0,5,3);g.beginPath();g.moveTo(0,0);g.lineTo(5,3);g.stroke();CanvasXpress.cachePatterns.hatchForward3=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse3")){g.clearRect(0,0,5,3);g.beginPath();g.moveTo(5,0);g.lineTo(0,3);g.stroke();CanvasXpress.cachePatterns.hatchReverse3=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTop")){h.width=5;h.height=16;g.clearRect(0,0,5,16);b(g);CanvasXpress.cachePatterns.membraneTop=a.createPattern(h,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBottom")){h.width=5;h.height=16;g.clearRect(0,0,5,16);g.translate(5,0);g.scale(-1,1);b(g);CanvasXpress.cachePatterns.membraneBottom=a.createPattern(h,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneRight")){h.width=16;h.height=5;g.clearRect(0,0,16,5);e(g);CanvasXpress.cachePatterns.membraneRight=a.createPattern(h,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneLeft")){h.width=16;h.height=5;g.clearRect(0,0,16,5);g.translate(0,5);g.scale(1,-1);e(g);CanvasXpress.cachePatterns.membraneLeft=a.createPattern(h,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTL")){h.width=32;h.height=32;g.clearRect(0,0,32,32);f(g);CanvasXpress.cachePatterns.membraneTL=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBL")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(0,32);g.scale(1,-1);f(g);CanvasXpress.cachePatterns.membraneBL=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTR")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(32,0);g.scale(-1,1);f(g);CanvasXpress.cachePatterns.membraneTR=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBR")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(32,32);g.scale(-1,-1);f(g);CanvasXpress.cachePatterns.membraneBR=a.createPattern(h,"no-repeat")}};if(this.patternBy||this.TN()||this.patterns[0]!="solid"){d()}else{setTimeout(function(){d()},0)}};this.Kj=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.eO=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.Ov=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.nD()}switch(v){case"arc2":K=this.BC(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.BC(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.BC(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.XN(N.concat(K.reverse()),false,true);break;case"violin":case"fish":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.Za(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.Za(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.XW(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.BC(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.XW(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.BC(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"drop":case"teardrop":case"marker":N=["circle",m,l-n,g];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"roundArrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":if(m-g==m+g){N=["rect",m-(g+1),l-a,m+g+1,l+a]}else{if(l-a==l+a){N=["rect",m-g,l-(a+1),m+g,l+a+1]}else{N=["rect",m-g,l-a,m+g,l+a]}}break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.Ov("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.Ov("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"rect4":return this.Ov("rectangle",m,l,n,n/4,H,D,C,B,k,L,M,A,I,q,J);case"rectline":return this.Ov("rectangle",m,l,n,2,H,H,C,B,k,L,M,A,I,q,J);case"rect2i":return this.Ov("rectangle",m,l,n/2,n,H,D,C,B,k,L,M,A,I,q,J);case"rect3i":return this.Ov("rectangle",m,l,n/3,n,H,D,C,B,k,L,M,A,I,q,J);case"rect4i":return this.Ov("rectangle",m,l,n/4,n,H,D,C,B,k,L,M,A,I,q,J);case"rectlinei":return this.Ov("rectangle",m,l,2,n,H,H,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.Ov("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.Ov("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.Ov("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.Ov("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.Ov("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.nJ(N)}else{return N}};this.pv=function(c,d,b){if(c&&c.length>1){var a=c.shift();while(a[0]==null||a[1]==null){a=c.shift()}b.funcs.push(["beginPath",[]]);b.funcs.push(["moveTo",[a[0]+0.5,a[1]+0.5]]);while(c.length>0){a=c.shift();while(a[0]==null||a[1]==null){a=c.shift()}b.funcs.push(["lineTo",[a[0]+0.5,a[1]+0.5]])}if(!d){b.funcs.push(["closePath",[]])}}};this.f6=function(ae,Z,Y,ab,at,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay,N){var T,aB,j,aD,V,S,ah,am;if(!N){N=this.us()}if(ai){switch(ai){case"closed":case"solid":case"open":case"round":break;default:var aE=ai;ai="closed";this.f6(ae,Z,Y,ab,at,au,au,ai,ag,X,aA,aC,af,aw,ac,ay);ai=aE;break}}switch(ae){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":case"fish":var ao=Number.MAX_VALUE;var Q=Number.MAX_VALUE*-1;var an=Number.MAX_VALUE;var O=Number.MAX_VALUE*-1;aB=[];T=[];if(Z.length==Y.length){if(ae=="spline"&&Z.length<5){return this.f6("polygon",Z,Y,ab,at,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay)}if(ae=="arch"&&(Z.length!=6||Y.length!=6||ab.length!=4||at.length!=2)){return false}if(ae=="bezier"){if(this.Nv(Z)&&this.Nv(Y)&&this.Nv(at)){for(var ar=0;ar<Z.length;ar++){ao=Math.min(ao,Z[ar]);Q=Math.max(Q,Z[ar]);an=Math.min(an,Y[ar]);O=Math.max(O,Y[ar]);T.push([Z[ar],Y[ar]])}Z=0;Y=0;for(var ar=0;ar<T.length;ar++){T[ar][0]-=Z;T[ar][1]-=Y;aB.push(T[ar][0],T[ar][1])}}else{return false}}else{if(ae=="confidence"){if(Z.length>2){for(var ar=0;ar<Z.length;ar++){if(Z[ar][0]!=null&&Z[ar][1]!=null&&Y[ar][0]!=null&&Y[ar][1]!=null&&this.Nv([Z[ar][0],Z[ar][1],Y[ar][0],Y[ar][1]])){ao=Math.min(ao,Math.min(Z[ar][0],Z[ar][1]));Q=Math.max(Q,Math.max(Z[ar][0],Z[ar][1]));an=Math.min(an,Math.min(Y[ar][0],Y[ar][1]));O=Math.max(O,Math.max(Y[ar][0],Y[ar][1]));T.push([[Z[ar][0],Z[ar][1]],[Y[ar][0],Y[ar][1]]])}}Z=(ao+Q)/2;Y=(an+O)/2;for(var ar=0;ar<T.length;ar++){T[ar][0][0]-=Z;T[ar][0][1]-=Z;T[ar][1][0]-=Y;T[ar][1][1]-=Y;aB.push([T[ar][0][0],T[ar][0][1]],[T[ar][1][0],T[ar][1][1]])}}else{return false}}else{if(ae=="violin"||ae=="fish"){if(Z[0].length==Y[0].length&&Z[1].length==Y[1].length&&Z[0].length==Z[1].length){for(var ar=0;ar<Z[0].length;ar++){if(this.Nv([Z[0][ar],Z[1][ar],Y[0][ar],Y[1][ar]])){ao=Math.min(ao,Math.min(Z[0][ar],Z[1][ar]));Q=Math.max(Q,Math.max(Z[0][ar],Z[1][ar]));an=Math.min(an,Math.min(Y[0][ar],Y[1][ar]));O=Math.max(O,Math.max(Y[0][ar],Y[1][ar]));T.push([[Z[0][ar],Z[1][ar]],[Y[0][ar],Y[1][ar]]])}}Z=(ao+Q)/2;Y=(an+O)/2;for(var ar=0;ar<T.length;ar++){T[ar][0][0]-=Z;T[ar][0][1]-=Z;T[ar][1][0]-=Y;T[ar][1][1]-=Y;aB.push([T[ar][0][0],T[ar][0][1]],[T[ar][1][0],T[ar][1][1]])}}else{return false}}else{for(var ar=0;ar<Z.length;ar++){if(Z[ar]&&Y[ar]&&this.Nv([Z[ar],Y[ar]])){ao=Math.min(ao,Z[ar]);Q=Math.max(Q,Z[ar]);an=Math.min(an,Y[ar]);O=Math.max(O,Y[ar]);T.push([Z[ar],Y[ar]])}}Z=ae=="arch"?Z[1]:(ao+Q)/2;Y=ae=="arch"?Y[1]:(an+O)/2;for(var ar=0;ar<T.length;ar++){T[ar][0]-=Z;T[ar][1]-=Y;aB.push(T[ar][0],T[ar][1])}}}}}else{return false}break;case"circle":case"sphere":case"circleOpen":case"rect":case"equilateral":case"plus":case"minus":case"diamond":case"rhombus":case"diamondOpen":case"hexagon":case"octagon":if(this.Nv([Z,Y,ab,at])){if(aA){T=this.GG(ae,[Z,Y,ab,at],aC);if(T){if(T.length==4){Z=T[0];Y=T[1];ab=Math.max(1,T[2]);at=Math.max(1,T[3])}else{if(T.length==2){Z=T[0];Y=T[1]}}}else{return false}}j=ab/2;aD=at/2;V=ab/3;S=at/3;ah=at/ab;am=1.5}break;default:if(this.Nv([Z,Y,ab,at])){if(aA){T=this.GG(ae,[Z,Y,ab,at],aC);if(T){if(T.length==4){ab=Math.max(1,T[2]);at=Math.max(1,T[3]);Z=T[0]+(ab/2);Y=T[1]+(at/2)}else{if(T.length==2){Z=T[0];Y=T[1]}}}else{return false}}else{ab=Math.max(1,ab);at=Math.max(1,at)}j=ab/2;aD=at/2;ah=at/ab;am=1.5}else{return false}break}switch(ae){case"image":var L=Array.isArray(ac)?this.backgroundImageMD5:this.zM(ac);if(ac&&(CanvasXpress.cacheImages[L]||CanvasXpress.images[ac])){var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);if(CanvasXpress.images[ac]){this.Cl(CanvasXpress.images[ac],-j*this.zoom,-aD*this.zoom,ab*this.zoom,at*this.zoom,false,false,false,false,au,ai,N,W)}else{this.Cl(CanvasXpress.cacheImages[L],-j*this.zoom,-aD*this.zoom,ab*this.zoom,at*this.zoom,false,false,false,false,au,ai,N,W)}}else{if(L&&L=="canvasXpress"){return}else{return this.f6("rectangle",Z,Y,ab,at,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",ai,ag,X,aA,aC,af,aw,ac,ay)}}break;case"circle":case"sphere":case"circleOpen":if(!this.nW(au,true)||!this.nW(aj,true)){var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[Z,Y,Math.max(0,ab/2),0,Math.PI*2,false]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W)}break;case"drop":case"teardrop":case"marker":var E=j*2/3;var D=E*0.5;var R=this.graphType=="Map"?-E*3:0;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,R,Math.max(0,j),0,Math.PI,true]]);W.funcs.push(["bezierCurveTo",[-j,R+j,0,R+D,0,R+(E*3)]]);W.funcs.push(["bezierCurveTo",[0,R+D,j,R+j,j,R]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,R,Math.max(0,j*0.3),0,Math.PI*2,true]]);W.funcs.push(["closePath",[]]);this.VN("white","black",ai,W);N.o.push(W);break;case"arrow":T=[[-j,-aD],[j,-aD],[j,aD],[-j,aD]];if(ag){ag=false;var E=at/4;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[j-at,-aD]]);W.funcs.push(["lineTo",[j-at,-aD-E]]);W.funcs.push(["lineTo",[j,0]]);W.funcs.push(["lineTo",[j-at,aD+E]]);W.funcs.push(["lineTo",[j-at,aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W)}else{var q=ab/4;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+ab]]);W.funcs.push(["lineTo",[-j-q,-aD+ab]]);W.funcs.push(["lineTo",[0,-aD]]);W.funcs.push(["lineTo",[j+q,-aD+ab]]);W.funcs.push(["lineTo",[j,-aD+ab]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W)}break;case"roundArrow":T=[[-j,-aD],[j,-aD],[j,aD],[-j,aD]];if(ag){ag=false;var E=at/4;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[j-at,-aD]]);W.funcs.push(["lineTo",[j-at,-aD-E]]);W.funcs.push(["lineTo",[j,0]]);W.funcs.push(["lineTo",[j-at,aD+E]]);W.funcs.push(["lineTo",[j-at,aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W)}else{var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);if(this.Ma()){W.funcs.push(["arc",[j-aD,0,aD,Math.PI*1.5,Math.PI*0.5,false]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[-j,-aD]])}else{W.funcs.push(["arc",[0,-aD+j,j,Math.PI,Math.PI*2,false]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[-j,aD]])}W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W)}break;case"box":case"rect":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z-j,Y-aD]]);if(at<=1){W.funcs.push(["lineTo",[Z+j,Y-aD]])}else{if(ab<=1){W.funcs.push(["lineTo",[Z-j,Y+aD]])}else{W.funcs.push(["lineTo",[Z+j,Y-aD]]);W.funcs.push(["lineTo",[Z+j,Y+aD]]);W.funcs.push(["lineTo",[Z-j,Y+aD]])}}W.funcs.push(["closePath",[]]);this.VN(au,aj,(at<=1||ab<=1?"open":ai),W);N.o.push(W);break;case"rectangle":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);if(ai&&ai=="open"){W.funcs.push(["strokeRect",[-j,-aD,ab,at]])}else{if(aj==au){W.funcs.push(["fillRect",[-j,-aD,ab,at]])}else{W.funcs.push(["fillRect",[-j,-aD,ab,at]]);W.funcs.push(["strokeRect",[-j,-aD,ab,at]])}}N.o.push(W);break;case"rect2":return this.f6("rectangle",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rect3":return this.f6("rectangle",Z,Y,ab,ab/3,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rect4":return this.f6("rectangle",Z,Y,ab,ab/4,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rectline":return this.f6("rectangle",Z,Y,ab,2,au,au,ai,ag,X,aA,aC,af,aw,ac,ay);case"rect2i":return this.f6("rectangle",Z,Y,ab/2,ab,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rect3i":return this.f6("rectangle",Z,Y,ab/3,ab,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rect4i":return this.f6("rectangle",Z,Y,ab/4,ab,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"rectlinei":return this.f6("rectangle",Z,Y,2,ab,au,au,ai,ag,X,aA,aC,af,aw,ac,ay);case"roundrectt":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+aa]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[j,-aD+aa]]);W.funcs.push(["quadraticCurveTo",[j,-aD,j-aa,-aD]]);W.funcs.push(["lineTo",[-j+aa,-aD]]);W.funcs.push(["quadraticCurveTo",[-j,-aD,-j,-aD+aa]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrectb":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[-j,aD-aa]]);W.funcs.push(["quadraticCurveTo",[-j,aD,-j+aa,aD]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["quadraticCurveTo",[j,aD,j,aD-aa]]);W.funcs.push(["lineTo",[j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrectr":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["quadraticCurveTo",[j,aD,j,aD-aa]]);W.funcs.push(["lineTo",[j,-aD+aa]]);W.funcs.push(["quadraticCurveTo",[j,-aD,j-aa,-aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrectl":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+aa]]);W.funcs.push(["lineTo",[-j,aD-aa]]);W.funcs.push(["quadraticCurveTo",[-j,aD,-j+aa,aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[j,-aD]]);W.funcs.push(["lineTo",[-j+aa,-aD]]);W.funcs.push(["quadraticCurveTo",[-j,-aD,-j,-aD+aa]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrecttr":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[j,-aD+aa]]);W.funcs.push(["quadraticCurveTo",[j,-aD,j-aa,-aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrecttl":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+aa]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[j,-aD]]);W.funcs.push(["lineTo",[-j+aa,-aD]]);W.funcs.push(["quadraticCurveTo",[-j,-aD,-j,-aD+aa]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrectbr":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["quadraticCurveTo",[j,aD,j,aD-aa]]);W.funcs.push(["lineTo",[j,-aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrectbl":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at:ab;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[-j,aD-aa]]);W.funcs.push(["quadraticCurveTo",[-j,aD,-j+aa,aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["lineTo",[j,-aD]]);W.funcs.push(["lineTo",[-j,-aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrecto":var aa=ab<at?j:aD;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);if(ab<at){W.funcs.push(["arc",[0,-aD+aa,aa,Math.PI,0]]);W.funcs.push(["lineTo",[j,aD-aa]]);W.funcs.push(["arc",[0,aD-aa,aa,0,Math.PI]]);W.funcs.push(["lineTo",[-j,-aD+aa]])}else{W.funcs.push(["arc",[-j+aa,0,aa,Math.PI*0.5,Math.PI*1.5]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["arc",[j-aa,0,aa,Math.PI*1.5,Math.PI*0.5]]);W.funcs.push(["lineTo",[-j+aa,-aD]])}W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundrect":case"roundrect2":case"roundrectd":var aa=ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius?this.roundedPolygonRadius:ab>at?at/4:ab/4;if(ae=="roundrect2"){aa*=4}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+aa]]);W.funcs.push(["lineTo",[-j,aD-aa]]);W.funcs.push(["quadraticCurveTo",[-j,aD,-j+aa,aD]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["quadraticCurveTo",[j,aD,j,aD-aa]]);W.funcs.push(["lineTo",[j,-aD+aa]]);W.funcs.push(["quadraticCurveTo",[j,-aD,j-aa,-aD]]);W.funcs.push(["lineTo",[-j+aa,-aD]]);W.funcs.push(["quadraticCurveTo",[-j,-aD,-j,-aD+aa]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);if(ae=="roundrectd"&&ab>this.roundedPolygonRadius&&at>this.roundedPolygonRadius){ab-=this.roundedPolygonRadius;at-=this.roundedPolygonRadius;j=ab/2;aD=at/2;W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD+aa]]);W.funcs.push(["lineTo",[-j,aD-aa]]);W.funcs.push(["quadraticCurveTo",[-j,aD,-j+aa,aD]]);W.funcs.push(["lineTo",[j-aa,aD]]);W.funcs.push(["quadraticCurveTo",[j,aD,j,aD-aa]]);W.funcs.push(["lineTo",[j,-aD+aa]]);W.funcs.push(["quadraticCurveTo",[j,-aD,j-aa,-aD]]);W.funcs.push(["lineTo",[-j+aa,-aD]]);W.funcs.push(["quadraticCurveTo",[-j,-aD,-j,-aD+aa]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W)}N.o.push(W);break;case"brace":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["bezierCurveTo",[-j,0,0,0,0,aD]]);W.funcs.push(["bezierCurveTo",[0,0,j,0,j,-aD]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"square":case"squareOpen":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv([[-j,-aD],[j,-aD],[j,aD],[-j,aD]],false,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"triangle":case"triangleOpen":if(ab==at){return this.f6("equilateral",Z,Y,ab,at,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay)}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv([[0,-aD],[j,aD],[-j,aD]],false,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"triangle2":if(ab==at){return this.f6("equilateral2",Z,Y,ab,at,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay)}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv([[0,aD],[j,-aD],[-j,-aD]],false,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"equilateral":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z,Y-aD]]);W.funcs.push(["lineTo",[Z+j,Y+aD]]);W.funcs.push(["lineTo",[Z-j,Y+aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,(at<=1||ab<=1?"open":ai),W);N.o.push(W);break;case"equilateral2":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv([[0,aD],[j,-aD],[-j,-aD]],false,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"diamond":case"rhombus":case"diamondOpen":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z,Y-aD]]);W.funcs.push(["lineTo",[Z+j,Y]]);W.funcs.push(["lineTo",[Z,Y+aD]]);W.funcs.push(["lineTo",[Z-j,Y]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,(at<=1||ab<=1?"open":ai),W);N.o.push(W);break;case"hexagon":var g=2*Math.PI/6;var M=[];for(var az=0;az<6;az++){M.push([j*Math.sin(g*az),aD*Math.cos(g*az)])}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);var U=M.shift();W.funcs.push(["moveTo",[Z+U[0],Y+U[1]]]);for(var az=0;M.length;az++){U=M.shift();W.funcs.push(["lineTo",[Z+U[0],Y+U[1]]])}W.funcs.push(["closePath",[]]);this.VN(au,aj,(at<=1||ab<=1?"open":ai),W);N.o.push(W);break;case"pentagon":var ax=ab/3;var T=[];for(var ar=0;ar<5;ar++){var F=(ar/5)*Math.PI*2+(-Math.PI/2);T.push([Math.cos(F)*ax,Math.sin(F)*ax])}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv(T,false,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"octagon":var aF=ab/4;var aq=at/4;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z-aF,Y-aD]]);W.funcs.push(["lineTo",[Z+aF,Y-aD]]);W.funcs.push(["lineTo",[Z+j,Y-aq]]);W.funcs.push(["lineTo",[Z+j,Y+aq]]);W.funcs.push(["lineTo",[Z+aF,Y+aD]]);W.funcs.push(["lineTo",[Z-aF,Y+aD]]);W.funcs.push(["lineTo",[Z-j,Y+aq]]);W.funcs.push(["lineTo",[Z-j,Y-aq]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,(at<=1||ab<=1?"open":ai),W);N.o.push(W);break;case"oval":case"ovald":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["save",[]]);W.funcs.push(["scale",[1,ah]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,0,Math.max(0,ab/2),0,Math.PI*2,true]]);W.funcs.push(["closePath",[]]);W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W);if(ae=="ovald"){ab-=this.margin*2;at-=this.margin*2;ah=at/ab;W.funcs.push(["save",[]]);W.funcs.push(["scale",[1,ah]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,0,Math.max(0,ab/2),0,Math.PI*2,true]]);W.funcs.push(["closePath",[]]);W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W)}N.o.push(W);break;case"oval2":return this.f6("oval",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"oval3":return this.f6("oval",Z,Y,ab,ab/3,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);case"arc":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["save",[]]);W.funcs.push(["scale",[1,ah]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,0,Math.max(0,ab/2),af,aw,false]]);if(ai!="open"){W.funcs.push(["closePath",[]])}W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"arc2":var H=at*Math.cos(af);var aI=at*Math.sin(af);var G=at*Math.cos(aw);var aG=at*Math.sin(aw);var C=this.U8(0,0,H,aI,0,ab,"line");var A=this.U8(0,0,G,aG,0,ab,"line");var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[C[2],C[3]]]);W.funcs.push(["lineTo",[H,aI]]);W.funcs.push(["arc",[0,0,Math.max(0,at),af,aw,false]]);W.funcs.push(["lineTo",[A[2],A[3]]]);W.funcs.push(["arc",[0,0,Math.max(0,at-ab),aw,af,true]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"arc3":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["save",[]]);W.funcs.push(["scale",[1,ah]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,0,Math.max(0,ab/2),0,Math.PI,false]]);W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"arch":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[T[0][0],T[0][1]]]);W.funcs.push(["quadraticCurveTo",[T[1][0],T[1][1],T[2][0],T[2][1]]]);W.funcs.push(["arc",[0,0,Math.max(0,at[0]),ab[3],ab[2],true]]);W.funcs.push(["quadraticCurveTo",[T[4][0],T[4][1],T[5][0],T[5][1]]]);W.funcs.push(["arc",[0,0,Math.max(0,at[1]),ab[1],ab[0],true]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"path":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv(T,ai=="open",W);this.VN(au,aj,ai,W);N.o.push(W);break;case"roundpolygon":T=this.eO(T);var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);for(var ar=0;ar<T.length;ar++){W.funcs.push(["arc",[T[ar][0],T[ar][1],T[ar][2],T[ar][3],T[ar][4]]])}W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"polygon":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);this.pv(T,ai=="open"&&au,W);this.VN(au,aj,ai,W);N.o.push(W);break;case"spline":var ad=[];var al=[];var I=[];al.push(aB.shift());al.push(aB.shift());I.push(aB.pop());I.unshift(aB.pop());var ak=aB.length;for(var ar=0;ar<ak-4;ar+=2){ad=ad.concat(this.G7(aB[ar],aB[ar+1],aB[ar+2],aB[ar+3],aB[ar+4],aB[ar+5]))}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[al[0],al[1]]]);W.funcs.push(["lineTo",[aB[0],aB[1]]]);W.funcs.push(["quadraticCurveTo",[ad[0],ad[1],aB[2],aB[3]]]);for(var ar=2;ar<ak-5;ar+=2){W.funcs.push(["bezierCurveTo",[ad[2*ar-2],ad[2*ar-1],ad[2*ar],ad[2*ar+1],aB[ar+2],aB[ar+3]]])}W.funcs.push(["quadraticCurveTo",[ad[2*ak-10],ad[2*ak-9],aB[ak-2],aB[ak-1]]]);W.funcs.push(["lineTo",[I[0],I[1]]]);W.funcs.push(["lineTo",[al[0],al[1]]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"hull":var ap;var ak=1;var J=[];while(aB.length>1){J.push([aB.shift(),aB.shift()])}var ad=this.Cc(J);var m=[[J[0][0],J[0][1],ad[ad.length-1][0],ad[ad.length-1][1],ad[0][0],ad[0][1],J[1][0],J[1][1]]];for(var ar=1;ar<J.length-1;ar++){m.push([J[ar][0],J[ar][1],ad[ak][0],ad[ak][1],ad[ak+1][0],ad[ak+1][1],J[ar+1][0],J[ar+1][1]]);ak+=2}m.push([J[ar][0],J[ar][1],ad[ak][0],ad[ak][1],ad[ak+1][0],ad[ak+1][1],J[0][0],J[0][1]]);var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[m[0][0],m[0][1]]]);for(var ar=0;ar<m.length;ar++){W.funcs.push(["bezierCurveTo",[m[ar][2],m[ar][3],m[ar][4],m[ar][5],m[ar][6],m[ar][7]]])}W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"violin":var ak=aB.length;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[aB[0][0],aB[1][0]]]);for(var ar=2;ar<ak;ar+=2){W.funcs.push(["lineTo",[aB[ar][0],aB[ar+1][0]]])}W.funcs.push(["lineTo",[aB[ak-2][1],aB[ak-1][1]]]);for(var ar=2;ar<ak;ar+=2){var aH=(ak-1)-ar;W.funcs.push(["lineTo",[aB[aH-1][1],aB[aH][1]]])}W.funcs.push(["lineTo",[aB[0][0],aB[1][0]]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"fish":var ak=aB.length;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[aB[0][0],aB[1][0]]]);for(var ar=2;ar<ak;ar+=2){var v=(aB[ar-2][0]+aB[ar][0])/2;W.funcs.push(["bezierCurveTo",[v,aB[ar-1][0],v,aB[ar+1][0],aB[ar][0],aB[ar+1][0]]])}W.funcs.push(["lineTo",[aB[ak-2][1],aB[ak-1][1]]]);for(var ar=2;ar<ak;ar+=2){var aH=(ak-1)-ar;var v=(aB[aH+1][1]+aB[aH-1][1])/2;W.funcs.push(["bezierCurveTo",[v,aB[aH+2][1],v,aB[aH][1],aB[aH-1][1],aB[aH][1]]])}W.funcs.push(["lineTo",[aB[0][0],aB[1][0]]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"confidence":var ak=aB.length;var ad=[];var P=[];for(var ar=0;ar<ak-4;ar+=2){var aH=(ak-1)-ar;ad=ad.concat(this.G7(aB[ar][0],aB[ar+1][0],aB[ar+2][0],aB[ar+3][0],aB[ar+4][0],aB[ar+5][0]));P=P.concat(this.G7(aB[aH-1][1],aB[aH][1],aB[aH-3][1],aB[aH-2][1],aB[aH-5][1],aB[aH-4][1]))}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[aB[0][0],aB[1][0]]]);W.funcs.push(["quadraticCurveTo",[ad[0],ad[1],aB[2][0],aB[3][0]]]);for(var ar=2;ar<ak-5;ar+=2){W.funcs.push(["bezierCurveTo",[ad[2*ar-2],ad[2*ar-1],ad[2*ar],ad[2*ar+1],aB[ar+2][0],aB[ar+3][0]]])}W.funcs.push(["quadraticCurveTo",[ad[2*ak-10],ad[2*ak-9],aB[ak-2][0],aB[ak-1][0]]]);W.funcs.push(["lineTo",[aB[ak-2][1],aB[ak-1][1]]]);W.funcs.push(["quadraticCurveTo",[P[0],P[1],aB[ak-4][1],aB[ak-3][1]]]);for(var ar=2;ar<ak-5;ar+=2){var aH=(ak-1)-ar;W.funcs.push(["bezierCurveTo",[P[2*ar-2],P[2*ar-1],P[2*ar],P[2*ar+1],aB[aH-3][1],aB[aH-2][1]]])}W.funcs.push(["quadraticCurveTo",[P[2*ak-10],P[2*ak-9],aB[0][1],aB[1][1]]]);W.funcs.push(["lineTo",[aB[0][0],aB[1][0]]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"bezier":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[aB[0],aB[1]]]);W.funcs.push(["bezierCurveTo",[aB[2],aB[3],aB[4],aB[5],aB[6],aB[7]]]);W.funcs.push(["lineTo",[aB[6],aB[7]+at]]);W.funcs.push(["bezierCurveTo",[aB[4],aB[5]+at,aB[2],aB[3]+at,aB[0],aB[1]+at]]);W.funcs.push(["lineTo",[aB[0],aB[1]]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"ellipse":var a=j*0.5522848;var av=aD*0.5522848;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[0,aD]]);W.funcs.push(["bezierCurveTo",[0,aD-av,j-a,0,j,0]]);W.funcs.push(["bezierCurveTo",[j+a,0,ab,aD-av,ab,aD]]);W.funcs.push(["bezierCurveTo",[ab,aD+av,j+a,at,j,at]]);W.funcs.push(["bezierCurveTo",[j-a,at,0,aD+av,0,aD]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"ellipse2":return this.f6("ellipse",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);break;case"ellipse3":return this.f6("ellipse",Z,Y,ab,ab/3,au,aj,ai,ag,X,aA,aC,af,aw,ac,ay);break;case"plus":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z-am,Y-aD]]);W.funcs.push(["lineTo",[Z+am,Y-aD]]);W.funcs.push(["lineTo",[Z+am,Y-am]]);W.funcs.push(["lineTo",[Z+j,Y-am]]);W.funcs.push(["lineTo",[Z+j,Y+am]]);W.funcs.push(["lineTo",[Z+am,Y+am]]);W.funcs.push(["lineTo",[Z+am,Y+aD]]);W.funcs.push(["lineTo",[Z-am,Y+aD]]);W.funcs.push(["lineTo",[Z-am,Y+am]]);W.funcs.push(["lineTo",[Z-j,Y+am]]);W.funcs.push(["lineTo",[Z-j,Y-am]]);W.funcs.push(["lineTo",[Z-am,Y-am]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"minus":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[Z-j,Y-am]]);W.funcs.push(["lineTo",[Z+j,Y-am]]);W.funcs.push(["lineTo",[Z+j,Y+am]]);W.funcs.push(["lineTo",[Z-j,Y+am]]);W.funcs.push(["lineTo",[Z-j,Y-am]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"mdavid":var ax=ab/3;var B=Math.PI/6;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["save",[]]);W.funcs.push(["scale",[0.8,0.8]]);W.funcs.push(["rotate",[K*0.45]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[ax,0]]);for(var ar=0;ar<11;ar++){W.funcs.push(["rotate",[B]]);if(ar%2==0){W.funcs.push(["lineTo",[(ax/0.55),0]])}else{W.funcs.push(["lineTo",[ax,0]])}}W.funcs.push(["closePath",[]]);W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"star":var k=(ab/4);var K=Math.PI/5;var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["save",[]]);W.funcs.push(["scale",[0.7,0.7]]);W.funcs.push(["rotate",[K*0.45]]);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[k,0]]);for(var ar=0;ar<9;ar++){W.funcs.push(["rotate",[K]]);if(ar%2==0){W.funcs.push(["lineTo",[(k/0.35),0]])}else{W.funcs.push(["lineTo",[k,0]])}}W.funcs.push(["closePath",[]]);W.funcs.push(["restore",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"pie":if(typeof(af)=="undefined"){af=0}if(typeof(aw)=="undefined"){aw=Math.PI*2}var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["arc",[0,0,Math.max(0,ab/2),af,aw,false]]);W.funcs.push(["lineTo",[0,0]]);W.funcs.push(["closePath",[]]);this.VN(au,aj,ai,W);N.o.push(W);break;case"pie0":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI/5,ac,ay);break;case"pie1":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI/3.5,ac,ay);break;case"pie2":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI/2,ac,ay);break;case"pie3":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI/1.5,ac,ay);break;case"pie4":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI,ac,ay);break;case"pie5":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI*1.2,ac,ay);break;case"pie6":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI*1.4,ac,ay);break;case"pie7":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI*1.6,ac,ay);break;case"pie8":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI*1.8,ac,ay);break;case"pie9":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,0,Math.PI*2,ac,ay);break;case"pacman":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,Math.PI*1/4,Math.PI*7/4,ac,ay);break;case"pacman2":return this.f6("pie",Z,Y,ab,ab/2,au,aj,ai,ag,X,aA,aC,Math.PI*5/4,Math.PI*3/4,ac,ay);break;case"pch0":this.f6("square",Z,Y,ab,ab,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch1":this.f6("circle",Z,Y,ab,ab,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch2":this.f6("equilateral",Z,Y,ab,ab,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch3":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[0,-aD]]);W.funcs.push(["lineTo",[0,aD]]);W.funcs.push(["stroke",[]]);W.funcs.push(["moveTo",[-j,0]]);W.funcs.push(["lineTo",[j,0]]);W.funcs.push(["stroke",[]]);N.o.push(W);break;case"pch4":var W=this.Pw(Z,Y,ab,at,au,aj,ai,ag,X,N);W.funcs.push(["beginPath",[]]);W.funcs.push(["moveTo",[-j,-aD]]);W.funcs.push(["lineTo",[j,aD]]);W.funcs.push(["stroke",[]]);W.funcs.push(["moveTo",[j,-aD]]);W.funcs.push(["lineTo",[-j,aD]]);W.funcs.push(["stroke",[]]);N.o.push(W);break;case"pch5":this.f6("diamond",Z,Y,ab,ab,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch6":this.f6("equilateral2",Z,Y,ab,ab,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch7":this.f6("pch0",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch4",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch8":this.f6("pch3",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch4",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch9":this.f6("pch3",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch5",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch10":this.f6("pch1",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch3",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch11":this.f6("pch2",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch6",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch12":this.f6("pch0",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch3",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch13":this.f6("pch1",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch4",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch14":this.f6("pch0",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);this.f6("pch6",Z,Y,ab,at,au,aj,"open",false,X,aA,aC,af,aw,ac,ay);break;case"pch15":case"pch22":this.f6("square",Z,Y,ab,ab,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch16":case"pch21":this.f6("circle",Z,Y,ab,ab,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch17":case"pch24":this.f6("equilateral",Z,Y,ab,ab,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch18":case"pch23":this.f6("diamond",Z,Y,ab,ab,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch19":this.f6("circle",Z,Y,ab+2,ab+2,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch20":this.f6("circle",Z,Y,Math.max(2,ab-2),Math.max(2,ab-2),au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;case"pch25":this.f6("equilateral2",Z,Y,ab,ab,au||this.foreground,aj,"closed",false,X,aA,aC,af,aw,ac,ay);break;default:break}if(ae=="sphere"||ae=="circle"||ae=="circleOpen"||ae=="rect"||ae=="equilateral"||ae=="plus"||ae=="minus"||ae=="diamond"||ae=="rhombus"||ae=="diamondOpen"||ae=="hexagon"||ae=="octagon"){this.cF(N)}else{this.cF(N);this.XI(N)}};this.Nb=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.lg(b);b.ctx.drawImage(a,0,0);return b};this.C3=function(k){var s=k.naturalWidth;var l=k.naturalHeight;var o=this.Nb(k);var m=o.ctx.getImageData(0,0,s,l).data;for(var f=0;f<l;f++){var t=l-(f+1);for(var e=0;e<s;e++){var d=parseInt(m[t][e][0]*255);var n=parseInt(m[t][e][1]*255);var p=parseInt(m[t][e][2]*255);var q=m[t][e][3]?parseInt(m[t][e][3]*255):255;o.ctx.fillStyle="rgba("+d+","+n+","+p+","+q+")";o.ctx.fillRect(e,f,1,1)}}return o.toDataURL("img/png")};this.hD=function(e,k){var m=this.Nb(e);var b=k?this.Kn(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.eG=function(l){var k=l.length;var q=l[0].length;var n=this.$cX("canvas",{width:q,height:k});n.ctx=this.lg(n);n.ctx.clearRect(0,0,q,k);for(var f=0;f<k;f++){var s=k-(f+1);for(var e=0;e<q;e++){var d=parseInt(l[s][e][0]*255);var m=parseInt(l[s][e][1]*255);var o=parseInt(l[s][e][2]*255);var p=l[s][e][3]?parseInt(l[s][e][3]*255):255;n.ctx.fillStyle="rgba("+d+","+m+","+o+","+p+")";if(this.scatterType=="visium"&&this.visiumFlip){n.ctx.fillRect(e,f,1,1)}else{n.ctx.fillRect(e,s,1,1)}}}if(this.scatterType=="visium"){this.backgroundImageRows=k;this.backgroundImageCols=q}return n.toDataURL("img/png")};this.Cl=function(x,v,m,j,y,D,s,p,F,g,o,u){if(!u){u=this.us()}try{v=parseInt(Math.round(v||0));m=parseInt(Math.round(m||0));j=parseInt(Math.round(j||x.naturalWidth));y=parseInt(Math.round(y||x.naturalHeight));if(this.scatterType=="visium"){if(this.visiumFlip){var A=this.xAxisMin;var z=this.xAxisMax;var b=x.naturalHeight-this.yAxisMax;var c=x.naturalHeight-this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=this.yAxisMax;u.o.push({funcs:[["scale",[a,G]],["drawImage",[x,A,n,f,E,v+k,m+B,f,E]],["scale",[1/a,1/G]]]})}else{var A=this.xAxisMin;var z=this.xAxisMax;var b=this.yAxisMax;var c=this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=x.naturalHeight-this.yAxisMax;u.o.push({funcs:[["scale",[a,G]],["drawImage",[x,A,n,f,E,v+k,m+B,f,E]],["scale",[1/a,1/G]]]})}}else{if(D&&s&&p&&F){D=parseInt(Math.round(D));s=parseInt(Math.round(s));p=parseInt(Math.round(p));F=parseInt(Math.round(F));u.o.push({funcs:[["drawImage",[x,v,m,j,y,D,s,p,F]],["drawImage",[this.hD(x,g),v,m,j,y,D,s,p,F]]]})}else{if(g&&g=="b&w"){u.o.push({funcs:[["drawImage",[this.hD(x),v,m,j,y]]]})}else{if(g){u.o.push({funcs:[["drawImage",[x,v,m,j,y]],["drawImage",[this.hD(x,g),v,m,j,y]]]})}else{if(o=="round"){var q=Math.max(j,y)/2;u.o.push({funcs:[["save",[]],["beginPath",[]],["arc",[v+q,m+q,q,0,Math.PI*2]],["clip",[]],["drawImage",[x,v,m,j,y]],["restore",[]]]})}else{u.o.push({funcs:[["drawImage",[x,v,m,j,y]]]})}}}}}}catch(C){var d=this;d.fo(C);setTimeout(function(){d.Oj({func:"drawImage",par:[x,v,m,j,y,D,s,p,F,g]})},100)}};this.b6=function(b,a){if(!CanvasXpress.system.isIE&&b){if(!a){a=this.us()}a.o.push({globalCompositeOperation:b})}};this.zK=function(a,e,c,d,b){if(!b){b=this.us()}b.o.push({funcs:[["clearRect",[a,e,c,d]]]})};this.Be=function(a,c,b){if(!b){b=this.us()}b.o.push({funcs:[["translate",[a,c]]]})};this.pn=function(b,a){if(!a){a=this.us()}a.o.push({funcs:[["rotate",[b]]]})};this.Rd=function(a,c,b){if(!b){b=this.us()}b.o.push({funcs:[["scale",[a,c]]]})};this.WF=function(a){if(!a){a=this.us()}a.o.push({funcs:[["save",[]]]})};this.XI=function(a){if(!a){a=this.us()}a.o.push({funcs:[["restore",[]]]})}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.gc=function(g,e){if(g==undefined){g=0}var b=g;var l=g.toString();var d=l.indexOf("999999");var j=l.indexOf("000000");var i=l.indexOf(".");var k=d>=0&&i<d?d:j>=0?j:null;if(k!=null){b=l.substring(0,k);var h=Math.pow(10,b.length-(b.indexOf(".")+1));return Number(Math.round(Number(l)*h)/h)}else{return e?Number.parseFloat(l).toFixed(e):Number(l)}};this.sP=function(d,l,b,f){var c=function(i,n){var p;var q=Math.floor(Math.log(i)/Math.LN10);var o=i/Math.pow(10,q);if(n){if(o<1.5){p=1}else{if(o<3){p=2}else{if(o<7){p=5}else{p=10}}}}else{if(o<1){p=1}else{if(o<2){p=2}else{if(o<5){p=5}else{p=10}}}}return p*Math.pow(10,q)};if(d>l){var g=l;d=l;d=g}else{if(l-d<1e-8){l+=0.1}}var k=[];var h=c(l-d,false);var m=c(h/(b-1),true);var a=Math.floor(d/m)*m;var j=Math.ceil(l/m)*m;for(var e=a;e<=j;e+=m){k.push(this.gc(e))}if(k[0]==k[k.length-1]){var k=[];for(var e=a;e<=j;e+=m){k.push(e)}}return f?k:this.MC(k)};this.E9=function(c,j,a,g){var b=function(A,C,B,z){var v=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var x=C-A;var s=B-1;var p=1-Math.abs(B-z)/z;var E=x/s;var u=Math.floor(Math.log(E)/Math.LN10);var F=Math.pow(10,u);var q=null;for(var D=0;D<v.length;D++){var t=v[D]*F;var G=Math.floor(A/t)*t;var n=G+s*t;if(G<=A&&n>=C){var w=1-(D-(G<=0&&n>=0?1:0))/v.length;var r=(C-A)/(n-G);if(r>0.8){var y=p+w+r;if(q==null||y>q.score){q={lmin:G,lmax:n,lstep:t,score:y}}}}}if(!q){q={lmin:A,lmax:C,lstep:1,score:0}}return q};if(j==c){if(c==0){c=-1;j=1}else{c-=Math.abs(c*0.1);j+=Math.abs(j*0.1)}}if(c>j){var h=j;c=j;c=h}else{if(j-c<1e-8){}}var l=[];var e=null;var m=[];for(var f=Math.max(Math.floor(a/2),2);f<=Math.ceil(6*a);f++){m.push(f)}for(var f=0;f<m.length;f++){var d=m[f];var o=b(c,j,d,a);if((o!=null&&e==null)||(o&&e&&o.score>e.score)){e=o}}for(var f=e.lmin;f<=e.lmax;f+=e.lstep){l.push(this.gc(f))}if(l[0]==l[l.length-1]){var l=[];for(var f=e.lmin;f<=e.lmax;f+=e.lstep){l.push(f)}}return g?l:this.MC(l)};this.z3=function(a,A,S,d,D){var h=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var K=function(c,w,m,g,z,Z){var k=w.length;var s=h(c,w);var aa=(g%Z<B||Z-(g%Z)<B)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+aa};var L=function(s,m,g){var w=m.length;var k=h(s,m);var c=1;return 1-k/(w-1)-g+c};var l=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var t=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var p=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var Y=function(g,c){return g>=c?2-(g-1)/(c-1):1};var f=[1,5,2,2.5,4,3];var H=[0.25,0.2,0.5,0.05];var R=f.length;var M={score:-2};var I=[];var B=2.22e-14;if(A==a){if(a==0){a=-1;A=1}else{a-=Math.abs(a*0.1);A+=Math.abs(A*0.1)}}if(a>A){var o=a;a=A;A=o}else{if(A-a<1e-8){}}var U=1;while(U<Number.POSITIVE_INFINITY){for(var V=0;V<R;V++){var O=f[V];var v=L(O,f,U);if((H[0]*v+H[1]+H[2]+H[3]<M.score)){U=Number.POSITIVE_INFINITY;break}var T=2;while(T<Number.POSITIVE_INFINITY){var r=Y(T,S);if((H[0]*v+H[1]+H[2]*r+H[3]<M.score)){break}var F=(A-a)/(T+1)/U/O;var G=Math.ceil(Math.log(F)/Math.LN10);while(G<Number.POSITIVE_INFINITY){var E=U*O*Math.pow(10,G);var C=t(a,A,E*(T-1));if((H[0]*v+H[1]*C+H[2]*r+H[3]<M.score)){break}var x=Math.floor(A/E)*U-(T-1)*U;var P=Math.ceil(a/E)*U;if(x>P){G++;continue}for(var y=x;y<=P;y++){var u=y*(E/U);var N=u+E*(T-1);var e=E;var J=K(O,f,U,u,N,e);var X=l(a,A,u,N);var W=p(T,S,a,A,u,N);var b=H[0]*J+H[1]*X+H[2]*W+H[3];if(b>M.score&&(!D||(u<=a&&N>=A))){M={lmin:u,lmax:N,lstep:e,score:b}}}G++}T++}}U++}for(var V=M.lmin;V<=M.lmax;V+=M.lstep){I.push(this.gc(V))}if(I[0]==I[I.length-1]){var I=[];for(var V=M.lmin;V<=M.lmax;V+=M.lstep){I.push(V)}}return d?I:this.MC(I)};this.O3=function(j,l,y,g){if(j>l){var x=l;l=j;j=x}if((isNaN(j)||isNaN(l))||(!isFinite(j)||!isFinite(l))){return[]}var u=Math.floor(y%3);var f=0.75;var w=1.5;var e=0.5+1.5*w;var v=2e-20;var i=0;var b,r,c;var n=Number.EPSILON;var t=1.25;var a=1e-10;var m=l-j;if(m==0&&l==0){b=1;r=true}else{b=Math.max(Math.abs(j),Math.abs(l));c=1+((e>=1.5*w+0.5)?1/(1+w):1.5/(1+e));c*=parseInt(Math.max(1,y))*n;r=m<b*c*3}if(r){if(b>10){b=9+b/10}b*=f;if(u>1){b/=u}}else{b=m;if(isFinite(m)){if(y>1){b/=y}else{if(y<2){b=l*0.5}else{b=l/y-j/y}}}}var q=v*Number.MIN_VALUE;if(q==0){q=Number.MIN_VALUE}if(b<q){alert("Error in rPretty: very small range");b=q}else{if(b>Number.MAX_VALUE/t){alert("Error in rPretty: very large range");b=Number.MAX_VALUE/t}}var d=Math.pow(10,Math.floor(Math.log10(b)));var p=d;if((2*d)-b<w*(b-p)){p=2*d;if((5*d)-b<e*(b-p)){p=5*d;if((10*d)-b<w*(b-p)){p=10*d}}}var A=Math.floor(j/p+a);var z=Math.ceil(l/p-a);if(i&&(i>1||!r)){if(j!=0){j*=(1-n)}else{j=-Number.MIN_VALUE}if(l!=0){l*=(1+n)}else{l=Number.MIN_VALUE}}while(A*p>j+(a*p)){A--}while(!isFinite(A*p)){A++}while(z*p<l-(a*p)){z++}while(!isFinite(A*p)){A--}var s=Math.floor(0.5+z-A);if(s<u){s=u-s;if(j==0&&A==0&&l!=0){z+=s}else{if(l==0&&z==0&&j!=0){A-=s}else{if(A>=0){z+=s/2;A-=s/2+s%2}else{A-=s/2;z+=s/2+s%2}}}y=u}else{y=s}if(A*p<j){j=A*p}if(z*p>l){l=z*p}var o=this.Cj(j,l,false,y+1);return g?o:this.MC(o)}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.gg=function(c,g,h,f,j){if(this.PU()){return}var e=this[h];if(f){var a={};if(this.Hl(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(e.includes(d)){e=this.gR(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.Hl(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.Hl(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.Oj({func:"modifyObjectArray",par:[c,g,h,f,j]})}};this.Fe=function(b){var d={};if(b&&this.Hl(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.lB=function(c){var f=[];if(c&&this.Hl(c)){var g=c.length;for(var e=0;e<g;e++){f[e]=[];if(c[e]&&this.Hl(c[e])){var b=c[e].length;for(var d=0;d<b;d++){f[e][c[e][d]]=true}}}}return f};this.iT=function(b){var d={};if(b&&this.Hl(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]+""]=c}}return d};this.tc=function(e,d){var h=[];if(!this.Hl(e)){e=this.N0(e)}var f=this.Fe(this.N0(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.gR=function(e,b){if(this.Hl(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.VJ=function(a){return a&&typeof a==="function";var b={};return a&&b.toString.call(a)==="[object Function]"};this.Hl=function(a){return Array.isArray(a)};this.ZR=function(a){return a instanceof Object};this.ak=function(b){return this.p4(b).length==b.length};this.gZ=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.ZR(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.ZR(b[c])){return false}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}}return true};this.a2=function(a){return/^https*:\/\//.test(a)};this.kg=function(c,e){var b=/^<a.*>.*<\/a>/i.test(c);if(b&&e){var d=/<a.*?href=['"](.*?)['"].*?>(.*?)<\/a>/i.exec(c);return d?[d[1],d[2]]:false}else{return b}};this.ai=function(c,e){var b=/^<a.*onclick.*>.*<\/a>/i.test(c);if(b&&e){var d=/<a.*?onclick=['|"|&quot;](.*?)['|"|&quot;].*?>(.*?)<\/a>/i.exec(c);return d?[d[1],d[2]]:false}else{return b}};this.TZ=function(a){return this.kg(a)||this.a2(a)};this.kn=function(b){var a=/<img.*?src=['"](.*?)['"].*?\/>/i.exec(b);return a&&a[1]?a[1]:false};this.N0=function(a){return this.Hl(a)?a:[a]};this.eX=function(l,d){if(this.data[l]&&this.data[l][d]){var h=this.data[l][d];var f=this.l4(h);var b={};var j=false;for(var g=0;g<f.length;g++){if(f[g]!=null&&(f[g].toString().match(/\[/)||f[g].toString().match(/\]/)||f[g].toString().match(/\{/)||f[g].toString().match(/\}/))&&!this.TZ(f[g].toString())){j=true;try{b[f[g]]=JSON.stringify(f[g])}catch(k){b[f[g]]=f[g].toString().replace(/\[/,"(").replace(/\]/,")").replace(/\{/,"(").replace(/\}/,")")}}else{if(f[g]==null){b[f[g]]=null}}}if(j){for(var g=0;g<h.length;g++){if(h[g]&&b[f[g]]!=null){h[g]=b[h[g]]}}}}};this.iH=function(a){var b=function(e){var d=[];for(var c in e){d.push(c)}return d.sort()};return this.Hl(a)?a:this.ZR(a)?b(a):[]};this.im=function(b){var a=function(e){var c=[];for(var d in e){c.push(e[d])}return c.sort()};return this.Hl(b)?b:this.ZR(b)?a(b):[]};this.l4=function(a){if(this.Hl(a)){return this.p4(a)}else{if(this.ZR(a)){return Object.keys(a)}else{return[a]}}};this.p4=function(b){var g=b.length;var e=[];var f=new Set();for(var d=0;d<g;d++){var c=b[d];if(f.has(c)){continue}f.add(c);e.push(c)}return e};this.Bj=function(a){if(this.Hl(a)){return this.p4(a)}else{if(this.ZR(a)){return this.p4(this.iH(a))}else{return[a]}}};this.mQ=function(c){var g=c.length;var f={};for(var e=0;e<g;e++){var b=c[e];var d=(f[b]!==undefined&&f[b]!==null)?f[b]:0;f[b]=d+1}return f};this.x6=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.Uu()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.i4=function(c){var f=[];var d=this.Hl(c);c=this.N0(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.tO=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.wo=function(b,a){return b.map(function(d,c){return d[a]})};this.um=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.Gt=function(a,c){if(a==null||typeof(a)!="object"){a={}}if(c==null||typeof(c)!="object"){return}for(var b in c){a[b]=c[b]}};this.y6=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.Hl(c)){return c.map(function(d){return b.Hl(d)?d.slice():b.y6(d,a)})}else{if(a){return this.ZR(c)?Object.assign({},c):this.parseJSON(this.QB(c))}else{return this.parseJSON(this.QB(c))}}};this.Ev=function(a){return a?JSON.parse(JSON.stringify(a)):false};this.xK=function(e){var d={bubble:true,gantt:true,sankey:true,tree:true,cola:true,colaConnector:true,stateCX:true,stateIndexCX:true};var a={};for(var c in e){if(d.hasOwnProperty(c)){continue}switch(c){case"data":case"config":a[c]=this.v8(e[c]);break;case"events":a[c]={};for(var b in e[c]){a[c][b]=this.y5(e[c][b])}break;default:a[c]=this.Ev(e[c]);break}}return a};this.v8=function(a,k){var p={bubble:true,gantt:true,sankey:true,tree:true,cola:true,colaConnector:true};if(this.ZR(a)&&a.config&&a.config.decorations&&a.config.decorations.marker){var d=a.config.decorations.marker;var g=d.length;for(var f=0;f<g;f++){if(d[f].text){d[f].text=d[f].text.replace(/\n/g,"__nl__")}}}if(typeof a==="string"){return a.replace(/"/g,"'")}else{if(a&&typeof a=="object"){var j=a.constructor.name;if(j!="Object"&&j!="Array"){return undefined}}else{if(a&&typeof a!=="object"){return a}}}if(!a){return a}if(Object.prototype.toString.apply(a)==="[object Array]"){var c=[];var e=a.length;for(var f=0;f<e;f++){c[f]=this.v8(a[f])}return c}var c={};for(f in a){var b=a[f];if(typeof b=="object"){var h=b&&b.constructor.name;if(b&&h!="Object"&&h!="Array"){delete a[f];continue}}if(k&&p.hasOwnProperty(f)){continue}if((b&&a.hasOwnProperty(f))||b===false||b===0){c[f]=this.v8(b,f=="data")}}return c};this.eI=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.t2=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.i4=function(a){if(this.t2(a,true)){return a}else{return Number.NaN}};this.Mb=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.t2(a[d][b])){return false}}}return true};this.Nv=function(a){var c=a.length;for(var b=0;b<c;b++){if(!this.t2(a[b])){return false}}return true};this.E3=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null){return false}}return true};this.Ry=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!==""){return false}}return true};this.Ek=function(h,c){var j=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;var e=/(^\d{1,4}?[\.|\\/|-]\d{1,2})$/;var d=/(^\d{4})$/;var b=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d+)?(?:Z|[+-]\d{2}:\d{2})?$/;var k=function(f){if(toString.call(f)==="[object Date]"){return true}if(typeof f.replace==="function"){f.replace(/^\s+|\s+$/gm,"")}if(c){return b.test(f)||d.test(f)||e.test(f)||j.test(f)}else{return b.test(f)||j.test(f)}};var a=h.length;for(var g=0;g<a;g++){if(h[g]!=null&&!k(h[g])){return false}}return true};this.rK=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null&&!CanvasXpress.dates.hasOwnProperty(a[b])){return false}}return true};this.Jp=function(a){var b={};for(var d in CanvasXpress.countries){b[d]=d;b[CanvasXpress.countries[d][0]]=d;b[CanvasXpress.countries[d][3]]=d;if(CanvasXpress.countries[d][7]){for(var c=0;c<CanvasXpress.countries[d][7].length;c++){b[CanvasXpress.countries[d][7][c]]=d}}}var e=a.length;for(var d=0;d<e;d++){if(a[d]!=null&&!b.hasOwnProperty(a[d])){return false}}return e>0?true:false};this.WZ=function(){var a={};for(var d in CanvasXpress.countries){a[d]=d;a[CanvasXpress.countries[d][0]]=d;a[CanvasXpress.countries[d][3]]=d;if(CanvasXpress.countries[d][7]){for(var b=0;b<CanvasXpress.countries[d][7].length;b++){a[CanvasXpress.countries[d][7][b]]=d}}}return a};this.Ng=function(a){var c={};for(var b in CanvasXpress.usa){c[b]=b;c[CanvasXpress.usa[b][0]]=b}var d=a.length;for(var b=0;b<d;b++){if(a[b]!=null&&!c.hasOwnProperty(a[b])){return false}}return d>0?true:false};this.JR=function(){var a={};for(var b in CanvasXpress.usa){a[b]=b;a[CanvasXpress.usa[b][0]]=b}return a};this.nn=function(a){var d=this;var c=function(f){return d.ZM(f)};var e=a.length;for(var b=0;b<e;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.cH=function(b){if(this.data.y&&this.data.y.vars){var a=this.as(b);if(a>=0){for(var c=0;c<this.data.y.smps.length;c++){if(this.data.y.data[a][c]!=1){return false}}return true}else{return false}}else{return false}};this.RX=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.k4=function(){if(this.YR()){if(this.meta.tree){return false}else{if(this.varOverlays.length+this.smpOverlays.length>0){return false}else{if(this.isMultidimensionalData){return false}}}return true}};this.TU=function(){var b=this.data.y.vars.length;var c=this.data.x?this.iH(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.SK=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.m4(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.aj=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.gS=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.t2(a[b],c)){d.push(a[b])}}return d};this.xx=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.gS(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.gS(d,true)}else{d=this.gS(b,true)}}return d};this.US=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.gS([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.gS([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.gS([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.bt=function(a){tmp=a.reverse();return tmp};this.k2=function(a){return(0.5+a)<<0;return((a+0.5)<<1)>>1};this.eb=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.kx=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.sH=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.uH=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.aI=function(b){var d=function(o,q){var p=o[0];var n=o[1];var s=o[2];var r=o[3];p=a(p,n,s,r,q[0],7,-680876936);r=a(r,p,n,s,q[1],12,-389564586);s=a(s,r,p,n,q[2],17,606105819);n=a(n,s,r,p,q[3],22,-1044525330);p=a(p,n,s,r,q[4],7,-176418897);r=a(r,p,n,s,q[5],12,1200080426);s=a(s,r,p,n,q[6],17,-1473231341);n=a(n,s,r,p,q[7],22,-45705983);p=a(p,n,s,r,q[8],7,1770035416);r=a(r,p,n,s,q[9],12,-1958414417);s=a(s,r,p,n,q[10],17,-42063);n=a(n,s,r,p,q[11],22,-1990404162);p=a(p,n,s,r,q[12],7,1804603682);r=a(r,p,n,s,q[13],12,-40341101);s=a(s,r,p,n,q[14],17,-1502002290);n=a(n,s,r,p,q[15],22,1236535329);p=i(p,n,s,r,q[1],5,-165796510);r=i(r,p,n,s,q[6],9,-1069501632);s=i(s,r,p,n,q[11],14,643717713);n=i(n,s,r,p,q[0],20,-373897302);p=i(p,n,s,r,q[5],5,-701558691);r=i(r,p,n,s,q[10],9,38016083);s=i(s,r,p,n,q[15],14,-660478335);n=i(n,s,r,p,q[4],20,-405537848);p=i(p,n,s,r,q[9],5,568446438);r=i(r,p,n,s,q[14],9,-1019803690);s=i(s,r,p,n,q[3],14,-187363961);n=i(n,s,r,p,q[8],20,1163531501);p=i(p,n,s,r,q[13],5,-1444681467);r=i(r,p,n,s,q[2],9,-51403784);s=i(s,r,p,n,q[7],14,1735328473);n=i(n,s,r,p,q[12],20,-1926607734);p=f(p,n,s,r,q[5],4,-378558);r=f(r,p,n,s,q[8],11,-2022574463);s=f(s,r,p,n,q[11],16,1839030562);n=f(n,s,r,p,q[14],23,-35309556);p=f(p,n,s,r,q[1],4,-1530992060);r=f(r,p,n,s,q[4],11,1272893353);s=f(s,r,p,n,q[7],16,-155497632);n=f(n,s,r,p,q[10],23,-1094730640);p=f(p,n,s,r,q[13],4,681279174);r=f(r,p,n,s,q[0],11,-358537222);s=f(s,r,p,n,q[3],16,-722521979);n=f(n,s,r,p,q[6],23,76029189);p=f(p,n,s,r,q[9],4,-640364487);r=f(r,p,n,s,q[12],11,-421815835);s=f(s,r,p,n,q[15],16,530742520);n=f(n,s,r,p,q[2],23,-995338651);p=l(p,n,s,r,q[0],6,-198630844);r=l(r,p,n,s,q[7],10,1126891415);s=l(s,r,p,n,q[14],15,-1416354905);n=l(n,s,r,p,q[5],21,-57434055);p=l(p,n,s,r,q[12],6,1700485571);r=l(r,p,n,s,q[3],10,-1894986606);s=l(s,r,p,n,q[10],15,-1051523);n=l(n,s,r,p,q[1],21,-2054922799);p=l(p,n,s,r,q[8],6,1873313359);r=l(r,p,n,s,q[15],10,-30611744);s=l(s,r,p,n,q[6],15,-1560198380);n=l(n,s,r,p,q[13],21,1309151649);p=l(p,n,s,r,q[4],6,-145523070);r=l(r,p,n,s,q[11],10,-1120210379);s=l(s,r,p,n,q[2],15,718787259);n=l(n,s,r,p,q[9],21,-343485551);o[0]=e(p,o[0]);o[1]=e(n,o[1]);o[2]=e(s,o[2]);o[3]=e(r,o[3])};var k=function(v,p,o,n,u,r){p=e(e(p,v),e(n,r));return e((p<<u)|(p>>>(32-u)),o)};var a=function(p,o,v,u,n,r,q){return k((o&v)|((~o)&u),p,o,n,r,q)};var i=function(p,o,v,u,n,r,q){return k((o&u)|(v&(~u)),p,o,n,r,q)};var f=function(p,o,v,u,n,r,q){return k(o^v^u,p,o,n,r,q)};var l=function(p,o,v,u,n,r,q){return k(v^(o|(~u)),p,o,n,r,q)};var j=function(q){txt="";var t=q.length;var r=[1732584193,-271733879,-1732584194,271733878];var p;for(p=64;p<=q.length;p+=64){d(r,m(q.substring(p-64,p)))}q=q.substring(p-64);var o=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(p=0;p<q.length;p++){o[p>>2]|=q.charCodeAt(p)<<((p%4)<<3)}o[p>>2]|=128<<((p%4)<<3);if(p>55){d(r,o);for(p=0;p<16;p++){o[p]=0}}o[14]=t*8;d(r,o);return r};var m=function(o){var p=[];var n;for(n=0;n<64;n+=4){p[n>>2]=o.charCodeAt(n)+(o.charCodeAt(n+1)<<8)+(o.charCodeAt(n+2)<<16)+(o.charCodeAt(n+3)<<24)}return p};var h="0123456789abcdef".split("");var g=function(q){var p="";var o=0;for(;o<4;o++){p+=h[(q>>(o*8+4))&15]+h[(q>>(o*8))&15]}return p};var c=function(n){for(var o=0;o<n.length;o++){n[o]=g(n[o])}return n.join("")};var e=function(o,n){return(o+n)&4294967295};return c(j(this.QB(b)))}};CanvasXpress.prototype.initPlotUtils=function(){this.cA=function(){var k=this.height;var p=this.width;var f=this.left;var c=this.right;var n=this.bottom;var q=this.top;var i=this.marginLeft;var d=this.marginRight;var o=this.marginBottom;var a=this.marginTop;var m=this.layoutLeft;var j=this.layoutRight;var e=this.layoutBottom;var g=this.layoutTop;this.Mc({p:["drawShape","rectangle",(i+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,"rgba(0,0,0,0.5)","open"],t:"Size"});this.Mc({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY+q)+(this.y/2),this.x,this.y,false,"red","open"],t:"Size"});this.Mc({p:["drawShape","rectangle",(i+this.offsetX+f+this.x)+(c/2),(a+this.offsetY+q)+(this.y/2),c,this.y,false,"blue","open"],t:"Size"});this.Mc({p:["drawShape","rectangle",(i+this.offsetX)+(f/2),(a+this.offsetY+q)+(this.y/2),f,this.y,false,"blue","open"],t:"Size"});this.Mc({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY)+(q/2),this.x,q,false,"blue","open"],t:"Size"});this.Mc({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY+q+this.y)+(n/2),this.x,n,false,"blue","open"],t:"Size"});return};this.u6=function(a){if(this.graphType!="Network"||a){this.Mc({p:["disableGradientTransparencyShadow"],t:"Size"});this.Mc({p:["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.plotBackgroundBorderColor,"open"],t:"Size"});this.Mc({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.cV=function(){if(this.backgroundType.match(/panel/)){if(this.isDOE&&this.graphType=="Meter"){return}var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;var d=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundBorderColor;this.Mc({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,d,"open"],t:"Size"})}};this.zS=function(){if(this.backgroundType.match(/panel/)){if(this.isDOE&&this.graphType=="Meter"){return}this.Mc({p:["disableGradientTransparencyShadow"],t:"Size"});var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.Mc({p:["drawShape","rectangle",this.width*0.5,this.height*0.5,this.width,this.height,this.plotBackgroundColor,this.plotBackgroundBorderColor],t:"Size"})}if(this.backgroundType=="panelSolidGradient"){var d=this.uf(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.Mc({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="panelGradient"){var d=this.uf(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.Mc({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="panelImage"){this.Mc({p:["drawShape","image",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{var f=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundColor;var e=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundBorderColor;this.Mc({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,f,e],t:"Size"})}}}this.Mc({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.jT=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(this.YR()&&(b.length>0&&d.length>0)&&this.samplesClustered&&this.variablesClustered){if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){}}if(e!=""){this.Hp();alert(e);return false}return true};this.vD=function(){if(!this.isDOE){if(this.jT()){if(this.YR()){this.layoutType="cols"}if(this.layoutValid&&this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.Wt(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.Fk(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.Y9()}else{if(this.segregateSamplesBy.length>0){this.Wt(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.Fk(this.segregateVariablesBy,true)}}}}}}};this.QL=function(){if(this.smpOverlays.length>0){var a=[];for(var c=0;c<this.smpOverlays.length;c++){if(this.smpOverlays[c]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[c]))){a.push(this.smpOverlays[c])}else{if(this.as(this.smpOverlays[c])>=0){this.data.x[this.smpOverlays[c]]=this.data.y.data[this.as(this.smpOverlays[c])];this.FV("x",this.smpOverlays[c]);a.push(this.smpOverlays[c])}}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var c=0;c<this.varOverlays.length;c++){if(this.varOverlays[c]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[c]))){a.push(this.varOverlays[c])}else{if(this.sF(this.varOverlays[c])>=0){var e=[];var d=this.sF(this.varOverlays[c]);for(var b=0;b<this.data.y.vars.length;b++){e.push(this.data.y.data[b][d])}this.data.z[this.varOverlays[c]]=e;this.FV("z",this.varOverlays[c]);a.push(this.varOverlays[c])}}}this.varOverlays=a}};this.dQ=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.Fh=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.lineBy||this.patternBy};this.Gl=function(){var a=this;var b=function(){if(a.isTransitionOn){CanvasXpress.transitions[a.target].push([a.isSegregatable]);return true}else{return false}};return !b()&&!this.isDOE&&!CanvasXpress.graphTypes.NonSegregatable.includes(this.graphType)};this.CV=function(){if(this.graphType.match(/Gantt|Circular|Fish|Meter|Network|Correlation|Genome|Pie|Scatter3D|TagCloud|Venn/)||this.is3DPlot||this.scatterPlotMatrix||this.isContour||this.isOncoprint){return false}return true};this.nG=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}}};CanvasXpress.prototype.initConfigUtils=function(){this.SO=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.C1=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.zM=function(a){return a?a.substring(a.lastIndexOf("/")+1):"canvasXpress"};this.JN=function(){var b=0;var a;this.xw();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.Dr(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.Dr(this.subtitleFont))*a.length}b+=this.margin}return b};this.xw=function(){var a=this.titleAlign.match(/^panel::0/)?this.left:0;this.v1(this.width-a,"titleFont");this.BY(this.title,"titleFont",this.width-a);this.v1(this.width-a,"subtitleFont",this.titleFontSize-1);this.BY(this.subtitle,"subtitleFont",this.width-a)};this.ii=function(){this.xw();if(this.title){var a=this.title.split(/\n/);var f=this.marginTop+((this.Dr(this.titleFont)+this.margin)*a.length);if(this.subtitle){a=this.subtitle.split(/\n/);f+=(this.Dr(this.subtitleFont)+this.margin)*a.length}if(this.titleColorBackground){this.Mc({p:["drawShape","rectangle",this.width/2,f/2,this.width,f,this.titleColorBackground,this.titleColorBackground],t:"Titles"})}var d=this.HR(this.title,this.titleFont);var c;var g=this.marginTop+(d/2);var b;if(this.titleAlign.match(/^plot/)){b=Number(this.titleAlign.replace(/^plot::/,""));c=this.width*b;this.Mc({p:["drawText",this.title,c+1,g,this.titleFont,this.titleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{if(this.titleAlign.match(/^panel/)){b=Number(this.titleAlign.replace(/^panel::/,""));c=(this.width*b)+this.marginLeft+this.left;this.Mc({p:["drawText",this.title,c,g,this.titleFont,this.titleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{c=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.Mc({p:["drawText",this.title,c,g,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"],t:"Titles"})}}if(this.subtitle){var e=this.HR(this.subtitle,this.subtitleFont);if(this.subtitleAlign.match(/^plot/)){b=Number(this.subtitleAlign.replace(/^plot::/,""));c=this.width*b;this.Mc({p:["drawText",this.subtitle,c+1,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{if(this.subtitleAlign.match(/^panel::/)){b=Number(this.subtitleAlign.replace(/^panel::/,""));c=(this.width*b)+this.marginLeft+this.left;this.Mc({p:["drawText",this.subtitle,c,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{c=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.Mc({p:["drawText",this.subtitle,c,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"],t:"Titles"})}}}}};this.va=function(){var b=0;var a;this.TM();if(this.citation){a=this.citation.split(/\n/);b+=(this.citationMargin+this.Dr(this.citationFont))*Math.max(1,a.length-1);b+=this.citationMargin}return b};this.TM=function(){var b=20*this.printMagnification;this.v1(this.width,"citationFont",b);var a=this.r9(this.citation,this.citationFont);var c=1;while(a>this.width||c>9){b/=2;this.v1(this.width,"citationFont",b);a=this.r9(this.citation,this.citationFont);c++}return};this.fS=function(){if(this.citation){if(this.graphType=="Network"){this.TM()}var b,c;var d=this.motionBy?40+(this.citationMargin*2):(this.va()/2);if(this.citationAlign.match(/^plot/)){var a=Number(this.citationAlign.replace(/^plot::/,""));b=(this.width*a)+this.citationMargin;c=this.height-d;this.Mc({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,a<0.5?"left":a>0.5?"right":"center","bottom"],t:"Citations"})}else{if(this.citationAlign.match(/^panel/)){var a=Number(this.citationAlign.replace(/^panel::/,""));b=this.marginLeft+this.left+(this.x*a);c=this.height-d;this.Mc({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,a<0.5?"left":a>0.5?"right":"center","bottom"],t:"Citations"})}else{switch(this.citationAlign){case"left":b=this.citationMargin;c=this.height-d;this.Mc({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,"left","bottom"],t:"Citations"});break;case"center":b=this.width/2;c=this.height-d;this.Mc({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,"center","bottom"],t:"Citations"});break;case"right":b=this.width-this.citationMargin;c=this.height-d;this.Mc({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,"right","bottom"],t:"Citations"});break}}}}};this.HI=function(){var g=this;var f=function(i,l,j,k){g.Mc({p:["setClipArea",[i,l,j,k]],t:"Titles"})};var d=function(){g.Mc({p:["resetClipArea"],t:"Titles"})};if(this.topMarginalText){f(this.margin,this.margin,this.width-(this.margin*2),this.marginTop-this.margin);var c=this.margin*2;var e=this.margin*2;var b=Math.floor((this.width-(this.margin*2))/(this.topMarginalTextFontSize*0.45));this.Mc({p:["drawText",this.eh(this.topMarginalText,b),c,e,this.topMarginalTextFont,this.topMarginalTextColor,this.topMarginalTextAlign,this.topMarginalTextBaseline],t:"Titles"});d()}if(this.bottomMarginalText){f(this.margin,this.height-this.marginBottom,this.width-(this.margin*2),this.marginBottom-this.margin);var c=this.margin*2;var e=(this.height-this.marginBottom)+this.margin*2;var b=Math.floor((this.width-(this.margin*2))/(this.bottomMarginalTextFontSize*0.45));this.Mc({p:["drawText",this.eh(this.bottomMarginalText,b),c,e,this.bottomMarginalTextFont,this.bottomMarginalTextColor,this.bottomMarginalTextAlign,this.bottomMarginalTextBaseline],t:"Titles"});d()}if(this.leftMarginalText){f(this.margin,this.marginTop+this.top,this.marginLeft-this.margin,this.height-this.marginTop-this.marginBottom);var b=Math.floor(this.marginLeft/(this.leftMarginalTextFontSize*0.45));var a=this.eh(this.leftMarginalText,b);var h=(a.split(/\n/).length-1)*(this.leftMarginalTextFontSize+this.margin)*(this.leftMarginalTextBaseline=="top"?0.4:0.2);var c=this.margin*2;var e=this.leftMarginalTextBaseline=="top"?this.marginTop+this.top+h:this.leftMarginalTextBaseline=="bottom"?this.marginTop+this.top+this.y-h:this.marginTop+this.top+(this.y/2);this.Mc({p:["drawText",a,c,e,this.leftMarginalTextFont,this.leftMarginalTextColor,this.leftMarginalTextAlign,this.leftMarginalTextBaseline],t:"Titles"});d()}if(this.rightMarginalText){f(this.width-this.marginRight,this.marginTop+this.top,this.width-this.marginRight,this.height-this.marginBottom);var b=Math.floor(this.marginRight/(this.rightMarginalTextFontSize*0.45));var a=this.eh(this.rightMarginalText,b);var h=(a.split(/\n/).length-1)*(this.rightMarginalTextFontSize+this.margin)*(this.rightMarginalTextBaseline=="top"?0.4:0.2);var c=this.width-this.marginRight;var e=this.rightMarginalTextBaseline=="top"?this.marginTop+this.top+h:this.rightMarginalTextBaseline=="bottom"?this.marginTop+this.top+this.y-h:this.marginTop+this.top+(this.y/2);this.Mc({p:["drawText",a,c,e,this.rightMarginalTextFont,this.rightMarginalTextColor,this.rightMarginalTextAlign,this.rightMarginalTextBaseline],t:"Titles"});d()}};this.sB=function(){this.UK();return this.Dr(this.font)};this.UK=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.t3=function(b){var g=this.width;var f=["titleFont","subtitleFont","citationFont"];for(var a=0;a<f.length;a++){var c=f[a];this[c+"Skip"]=true;this[c+"Size"]=b;var e=c.replace("Font","ScaleFontFactor");this[c+"Size"]=parseInt(Math.min(Math.max(parseInt(((g/50))*this[e]),this.minTextSize),this.maxTextSize));this[c]=this[c+"Style"]+" "+this[c+"Size"]+"px "+this.fontName}};this.v1=function(g,e,a){if(!g||!e){return}var c=10;var b={titleFont:c,subtitleFont:c,citationFont:c-1,legendTextFont:c,legendTitleFont:c,stripTextFont:c,xAxisTextFont:c,xAxisTitleFont:c,yAxisTextFont:c,yAxisTitleFont:c,zAxisTextFont:c,zAxisTitleFont:c,rAxisTextFont:c,rAxisTitleFont:c,smpTextFont:c,smpTitleFont:(this.graphType=="Meter"?c+2:c),varTextFont:c,varTitleFont:c,sankeyTitleFont:c,sankeyTextFont:c-1,decorationsTextFont:c,dataTextFont:c-7,overlayTextFont:c,motionCurrentFont:c*5,topMarginalTextFont:c+2,bottomMarginalTextFont:c+2,leftMarginalTextFont:c+2,rightMarginalTextFont:c+2};b[e]=11;var f=e.replace("Font","ScaleFontFactor");this[e+"Size"]=parseInt(Math.min(Math.max(((g/this.scaleTextConstantFactor)+b[e])*this[f],this.minTextSize),a||this.maxTextSize));this[e]=this[e+"Style"]+" "+this[e+"Size"]+"px "+this.fontName};this.BY=function(b,c,g){if(b&&c&&g){var e=this.Dr(this[c]);var a=this.r9(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.r9(b,this[c])}}};this.fE=function(f,e,b){if(this.adjustAspectRatio&&this.graphType!="Genome"){var a=this.meta.config.orig;var g=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","stripThickness"];var h=["legendTextMargin","legendTitleMargin","xAxisTextMargin","xAxisTitleMargin","yAxisTextMargin","yAxisTitleMargin","zAxisTextMargin","zAxisTitleMargin","xAxisTicksLength","yAxisTicksLength","zAxisTicksLength","sankeyNodeWidth","sankeyNodePadding"];for(var d=0;d<h.length;d++){g.push(h[d])}if(this.adjustAspectRatioHeatmapIndicator){g.push("heatmapIndicatorHeight");g.push("heatmapIndicatorWidth")}if(f||this.graphType=="Network"){for(var d=0;d<g.length;d++){if(a[g[d]]){this[g[d]]=a[g[d]];delete (a[g[d]])}}}else{for(var d=0;d<g.length;d++){if(!a[g[d]]){a[g[d]]=this[g[d]]}}if(!e){e=this.width}if(!b){b=this.height}for(var d=0;d<g.length;d++){this[g[d]]=Number(Math.max(0.5,Math.min(e,b)*this[g[d]]/833).toFixed(1))}}}};this.Fg=function(b,a){if(this.adjustAspectRatio&&this.graphType!="Genome"){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50)}else{this.fE(true,b,a)}}};this.UT=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];if(a){if(this.showBoxplotOriginalData&&this.colorBy&&!this.boxplotConnect){return this.background}else{this.isGroupedData=false;h=this.QN(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.QN(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.background}}this.isGroupedData=true}}else{h=this.QN(b,e,"colorBy")}}else{h=this.QN(b,e,"colorBy")}return h};this.Pc=function(a,c){if(this.Hl(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varTextColor};this.SY=function(c,b){if(this.Hl(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpTextColor};this.wi=function(e,a,f){if(this.Hl(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==e){return this.nodeHighlightColor}}}else{if(this.highlightNode==e){return this.nodeHighlightColor}}var d=this.QT(e);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!d;return d&&this.selectionMode=="highlight"?this.selectionColor:b&&a?this.eN(a,0.1,true):a?a:f?false:this.nodeColor};this.iN=function(f,d,a){if(this.Hl(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==f||this.highlightNode[c]==d){return this.nodeHighlightColor}}}else{if(this.highlightNode==f||this.highlightNode==d){return this.nodeHighlightColor}}var e=this.QT(f)||this.QT(d);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!e;return e&&this.selectionMode=="highlight"?this.selectionColor:b?this.eN(a,0.1,true):a?a:this.nodeColor};this.hi=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.as(a);if(b>-1){return this.QN(b,false,"colorVarDendrogramBy")}}return this.Pc(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.sF(c);if(b>-1){return this.QN(false,b,"colorSmpDendrogramBy")}}return this.SY(c,true)}};this.KU=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.SP=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.Sh=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.p3=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.l0=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.Ev(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.Ht=function(){var f=this.$h;var h=f("666163746f7279");var i=f("636c69656e74");var a=f("656e636f6465");var b=f("76616c6964");var d=f("757365724964");var e=f("76657273696f6e");var g=f("736574506978656c496d616765");CanvasXpress[h][i]=this[a]([CanvasXpress[h][b]||0,this[d],CanvasXpress[h][e],window.location.host].join("::"));this[g]()};this.qP=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.Aa=function(f,e){if(f){var c=this.treemapBorderWidth&&!this.isDOE?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpTextFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.Pk=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.Aa(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.Vd=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.Aa(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.s3=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.Pk(a,b,c,d)}else{return this.Vd(a,b,c,d)}};this.pi=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.Aa(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.s3(c,b,f,h)}return}var d=a[0];if(this.qP(c,b)>=this.qP([d].concat(c),b)){this.pi(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.s3(c,b,f,h);this.pi(a,[],g.orientation,g,d.title)}};this.xN=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.pi(a.slice(1),[a[0]],c,g,a[0].title)};this.gV=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.xN(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.gV(a,d)}}return b};this.v6=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.Lz=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.Uu()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.Uu()*Math.PI)};this.pf=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.r9(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.uw=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.xy=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.xl=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.xy(e+a[b][0],c+a[b][1])}};this.up=function(c,i,g,d){var k=this;var m=this.Lz();var e=this.pf(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.eN(g,0,true);var f=this.kF();var p=this.Gx();while(a--){var n=this.v6(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.x6(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.uw(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.xl(w,v,e);return true});if(h){return true}}return false};this.m2=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.qL()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.qL=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.uP(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.MX=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.m2(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.uP(j,a);var k=this.colorBy?this.QN(j,a,"colorBy"):this.foreground;if(!this.up(this.data.y.smps[a],h,k,[j,a])){this.eH();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.MX(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.gk=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.Yi=function(b,a,g){var i;if((this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)&&!this.isGroupedData)||(this.plotStyle=="open"&&!g)){i=this.Y3(b,true)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var d=this.layoutValid?this.data.y.vars.length*this.data.y.smps.length:this.varIndices.length*this.smpIndices.length;if(d>this.dotplotOutlineThreshold){i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor}else{i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor?this.objectBorderColor:this.Y3(b,true)}}else{i=this.objectBorderColor&&this.graphType!="Map"?this.objectBorderColor:this.Y3(b,true)}}if(a){var f=this.QT(a);var e=this.fT(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;i=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.eN(i,0.1,true):i}return i};this.sG=function(b,a,g){var i=(this.plotStyle=="open"&&!g)&&(!this.isDOE||!this.layoutCurrent);var j=this.eN(b,(i?0:this.objectColorTransparency),true);if(a){var f=this.QT(a);var e=this.fT(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;j=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.eN(j,0.1,true):j;if(this.transparency!=null){j=this.eN(this.Y3(j,true),this.transparency,true)}}return j};this.fT=function(a){if(this.highlightVar.length&&a!=null){var b=this.data.y.vars[a];return this.highlightVar.includes(b)}};this.yn=function(){if(this.YR()&&this.colorBy&&(this.meta.data.x[this.colorBy]||this.meta.data.z[this.colorBy])&&this.meta.def.factorColorBrew&&this.meta.def.factorColorBrew[this.colorBy]){var n=[];var k=this.meta.def.factorColorBrew[this.colorBy];var f=this.meta.data.x[this.colorBy]||this.meta.data.z[this.colorBy];var g=0;var j=0;var p="";var d={};for(var h in k){var e={rmin:k[h].rmin,rmax:k[h].rmax,min:k[h].min,max:k[h].max,decs:k[h].decs,vals:k[h].vals,maxLevLen:k[h].maxLevLen,maxLevChr:k[h].maxLevChr,maxLevStr:k[h].maxLevStr,colorBrew:k[h],level:h,order:k[h].order};if(k[h].show){if(k[h].maxLevLen>g){p=k[h].maxLevStr}g=Math.max(g,k[h].maxLevLen);j=Math.max(j,k[h].maxLevChr);n.push(e)}}if(f.maxLevLen>g){p=f.maxLevStr}g=Math.max(g,f.maxLevLen);j=Math.max(j,f.maxLevChr);return{maxLevLen:g,maxLevChr:j,maxLevStr:p,colorBrew:n.sort(function(i,c){return i.order-c.order})}}else{var k=this.meta.def.colorBrew;return{rmin:k.rmin,rmax:k.rmax,min:k.min,max:k.max,decs:k.decs,vals:k.vals,maxLevLen:k.maxLevLen,maxLevChr:k.maxLevChr,maxLevStr:k.maxLevStr,colorBrew:k}}};this.j9=function(){delete (this.cacheColors)};this.U1=function(){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}};this.e9=function(n,q,m){this.U1();var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.Nk(n)};var b=this.lX(n.length);for(var l=0;l<n.length;l++){var h=this.graphType=="Network"||this.isDOE||this.data.y.pie?l:q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=this.graphType=="Network"?l:this.isDOE?this.data.l.data[this.layoutCurrent].y.vars[l]:this.data.y.pie?this.data.y.pie.y.vars[l]:q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.t2(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.jD=function(u,h,g,t,I,w){var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.t2(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var o=this.graphType=="Network"||this.graphType!="Pie"?I[E]:k>-1?[k,C]:u.idso;var e=this.graphType=="Map"?u.cols[E]:this.sG(u.cols[E],o,this.isDOE);var D=this.Yi(e,this.graphType=="Map"?E:o);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var J=this.graphType=="Network"||this.graphType=="Map"?"Decorations":this.graphType!="Pie"?"Overlays":"Data";var D=this.pieType=="separated"?this.background:this.Yi(e);if(this.graphType=="Network"||this.graphType=="Map"){this.Mc({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:(this.graphType=="Map"?I[0]:I[E]),m:w,t:J,h:this.e1(this.graphType=="Map"?I[0][0]:I[E])})}else{if(this.graphType!="Pie"){this.Mc({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I[E],t:J})}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.Mc({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I,t:J,h:this.e1(I[0])})}else{this.Mc({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:u.idso,t:J})}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.graphType!="Map"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.Mc({p:["drawText",u.raw[k],F,b,this.xAxisTextFont,this.xAxisTextColor,"center","middle"],t:J})}else{this.Mc({p:["drawText",this.DF("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.xAxisTextFont,this.xAxisTextColor,"center","middle"],t:J})}}G+=v}G=0;d=null;if(u.ids.length>1&&this.graphType!="Map"){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.sG(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.Yi(e);this.Mc({p:["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],s:true,t:J});G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1&&this.graphType!="Map"){this.Mc({p:["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"],t:J})}}};this.ti=function(az,ax,an,ad,aa,ah,ac,X,am,aj,aC,ai,aG,al,av,ap,Z,aF){var ab,Y,aw,af;var W=this;var C=function(a){return W.isGroupedData?Z.smps[W.data.w.smps[W.grpIndices[a]]]:Z.smps[W.data.y.smps[W.smpIndices[a]]]};var ae=this.variableSpace/2;var au=aa/2;var at=aF?"Overlays":this.graphType=="Network"?"Decorations":"Data";var D=this.TN(true);var aD=0.0675;var Q=aD;if(aj=="vertical"||this.graphType=="Network"){var S=0;var U=an;var ag=0;for(var ar=0;ar<az.length;ar++){ab=((az[ar]-am)*ac)-X;var aA;var ao=(Z&&Z.cap&&Z.cap[C(ar)])||this.barType=="arrow"?"arrow":this.barType=="roundArrow"?"roundArrow":this.useRoundRectangles&&ab>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var A=this.bulletStyle.match(/round/);var E=this.sG(Z?Z.fill[C(ar)]:aC[ar],aG[ar]);var aE=aa-this.variableSpace>5?this.Yi(E,aG[ar]):E;var V=this.e1(aG[ar][0],aG[ar][1]);if(this.t2(ab,true)&&Q>=aD){if(this.barType.match(/bullet/i)){var B=[];if(this.rangeStack.length){for(var aq=this.rangeStack.length-1;aq>=0;aq--){var N=this.as(this.rangeStack[aq]);var T=this.layoutComb?this.sF(this.data.l.smps[this.layoutCurrent][0]):ar;if(N>-1){var M=((this.uP(N,T)-am)*ac)-X;var P=this.eN(this.rangeColors[aq]||E,this.rangeColorTransparency);if(M<0){aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),ad+(-M/2),aa-this.variableSpace,-M,P,P],t:"Decorations"})}else{aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),ad-(M/2),aa-this.variableSpace,M,P,P],t:"Decorations"})}B.unshift(ad-(M+this.dataTextMargin))}}B.unshift(ad-this.dataTextMargin)}else{var P=this.eN(this.rangeColors[0]||E,this.rangeColorTransparency);this.Mc({p:["drawShape","rectangle",(an+ae)+((aa-this.variableSpace)/2),X+(this.y/2),aa-this.variableSpace,this.y*2,P,P],t:"Decorations"})}if(this.rangeStackShow&&B.length){var I=an+(this.dataTextFontSize/2)+this.dataTextMargin;for(var aq=0;aq<this.rangeStack.length;aq++){this.Mc({p:["drawText",this.rangeStack[aq],I,B[aq],this.dataTextFont,this.foreground,"left","middle",-Math.PI/2],t:"Decorations"})}}}if(D){var L=ar==0||ar==az.length-1?this.waterfallNetColor:az[ar]>0?this.waterfallIncreaseColor:this.waterfallDecreaseColor;if(az[ar]==0){aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),(ad-(ab/2))-(S/2),aa-this.variableSpace,S,L,aE,ai[ar],false,false,av],i:aG[ar],m:al,t:at,h:V})}else{aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),(ad-(ab/2))-S,aa-this.variableSpace,(ab<0?-ab:ab),L,aE,ai[ar],false,false,av],i:aG[ar],m:al,t:at,h:V})}}else{if(A){ao="roundArrow"}if(this.barType=="bullet"&&this.bulletStyle.match(/Gradient/)){E=this.uf(0,-ab,1,ab,[E,"rgb(255, 255, 255)"]);aE=E}if(ab<0){aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),ad+(-ab/2),(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,-ab,E,aE,ai[ar],false,false,av],i:aG[ar],m:al,t:at,h:V})}else{aA=this.Mc({p:["drawShape",ao,(an+ae)+((aa-this.variableSpace)/2),ad-(ab/2),(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,ab,E,aE,ai[ar],false,false,av],i:aG[ar],m:al,t:at,h:V})}if(this.barType=="bullet"&&this.bulletStyle.match(/Gradient/)){this.XI()}}aw=ad-ab;af=an+au;if(ax[ar]&&this.t2(ax[ar],true)){Y=(ax[ar]/2)*ac;this.Mc({p:["drawLine","error",af,aw,af,aw-Y,this.errorBarsColor,-au,"butt"],g:aA,t:at,h:V});this.Mc({p:["drawLine","error",af,aw,af,aw+Y,this.errorBarsColor,-au,"butt"],g:aA,t:at,h:V})}if(Z){var T=C(ar);for(var aB in Z){if(aB!="cap"&&aB!="high"&&aB!="color"&&aB!="fill"){if(Z[aB][T]){for(var N=0;N<Z[aB][T].length;N++){var K=((Z[aB][T][N][0]-am)*ac)-X;var O=((Z[aB][T][N][1]-am)*ac)-X;var H=(an+ae)+((aa-this.variableSpace)/2);this.Mc({p:["drawShape",this.shapes[0],H,ad-K,aa/2,aa/2,Z.color[aB],Z.color[aB]],g:aA,t:at,h:V});if(!this.t2(O,true)){O=ab-this.margin}else{this.Mc({p:["drawShape",this.shapes[1],H,ad-O,aa/2,aa/2,Z.color[aB],Z.color[aB]],g:aA,t:at,h:V})}this.Mc({p:["drawLine","line",H,ad-K,H,ad-O,Z.color[aB],this.margin],g:aA,t:at,h:V})}}}}}if(this.barType=="bullet"&&this.bulletTargetVarName.length){var aq=this.as(this.bulletTargetVarName);var T=this.layoutComb?this.sF(this.data.l.smps[this.layoutCurrent][0]):ar;if(aq>-1){var J=((this.uP(aq,T)-am)*ac)-X;var ay=(aa-this.variableSpace)*this.bulletTargetWidthRatio;var F=(an+ae)+((aa-this.variableSpace)/2);if(this.bulletTargetType=="line"){aA=this.Mc({p:["drawLine","line",F-(ay/2),ad-J,F+(ay/2),ad-J,this.bulletTargetVarColor,this.bulletTargetLineWidth],i:[aq,T],t:"Decorations"})}else{var ak=this.bulletTargetType.replace("openC","c").replace("openS","s");this.Mc({p:["drawShape",ak,F,ad-J,ay,ay,this.bulletTargetType.match(/open/)?"rgba(0,0,0,0)":this.bulletTargetVarColor,this.bulletTargetVarColor,false,false,this.bulletTargetLineWidth],i:[aq,T],t:"Decorations"})}}}if(D){var L=ar==0||ar==az.length-1?this.waterfallNetColor:az[ar]>0?this.waterfallIncreaseColor:this.waterfallDecreaseColor;ag+=az[ar];if(ab<0){this.Mc({p:["drawText",this.ct(az[ar]),af,(ad-(ab-(this.margin/1)))-S,this.smpTextFont,L,"center","top"],g:aA,t:at,h:V})}else{if(az[ar]==0){this.Mc({p:["drawText",this.ct(ag),af,(ad-(ab+(this.margin/4)))-S,this.smpTextFont,L,"center","bottom"],g:aA,t:at,h:V})}else{this.Mc({p:["drawText",this.ct(az[ar]),af,(ad-(ab+(this.margin/4)))-S,this.smpTextFont,L,"center","bottom"],g:aA,t:at,h:V})}}if(ar>0){if(ab<0){this.Mc({p:["drawLine","dashed",U,ad-S,af,ad-S,L],g:aA,t:at,h:V})}else{this.Mc({p:["drawLine","dashed",U,((ad-(ab/2))-S)+(ab/2),af,((ad-(ab/2))-S)+(ab/2),L],g:aA,t:at,h:V})}}S+=ab;U=af}else{if(this.showDataValues&&!this.barType.match(/lollipop/)){var R=((this.Dr(this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);this.Mc({p:["drawText",this.ct(az[ar]),af,ad-(ab+R),this.dataTextFont,this.dataTextColor||E,this.dataTextAlign,this.dataTextBaseline],g:aA,t:at,h:V})}}Q=0}an+=this.Hl(ah)?ah[ar+1]-ah[ar]:ah;Q+=this.Hl(ah)?ah[ar+1]-ah[ar]:ah}}else{for(var ar=0;ar<az.length;ar++){ab=((az[ar]-am)*ac)-X;var aA;var ao=(Z&&Z.cap&&Z.cap[C(ar)])||this.barType=="arrow"?"arrow":this.barType=="roundArrow"?"roundArrow":!this.useRoundRectangles?"rectangle":ap||ab<0?"roundrectl":"roundrectr";var A=this.bulletStyle.match(/round/);var E=this.sG(Z?Z.fill[C(ar)]:aC[ar],aG[ar]);var aE=aa-this.variableSpace>5?this.Yi(E,aG[ar]):E;var V=this.e1(aG[ar][0],aG[ar][1]);if(this.t2(ab,true)&&Q>=aD){if(this.barType.match(/bullet/i)){if(this.rangeStack.length){var B=[];for(var aq=this.rangeStack.length-1;aq>=0;aq--){var N=this.as(this.rangeStack[aq]);var T=this.layoutComb?this.sF(this.data.l.smps[this.layoutCurrent][0]):ar;if(N>-1){var M=((this.uP(N,T)-am)*ac)-X;var P=this.eN(this.rangeColors[aq]||E,this.rangeColorTransparency);if(M<0){aA=this.Mc({p:["drawShape",ao,(an+M)-(M/2),(ad+ae)+((aa-this.variableSpace)/2),-M,aa-this.variableSpace,P,P],t:"Decorations"})}else{aA=this.Mc({p:["drawShape",ao,an+(M/2),(ad+ae)+((aa-this.variableSpace)/2),M,aa-this.variableSpace,P,P],t:"Decorations"})}B.unshift(an+M+this.dataTextMargin)}}B.unshift(an+this.dataTextMargin)}else{var P=this.eN(this.rangeColors[0]||E,this.rangeColorTransparency);this.Mc({p:["drawShape","rectangle",X+(this.x/2),(ad+ae)+((aa-this.variableSpace)/2),this.x*4,aa-this.variableSpace,P,P],t:"Decorations"})}if(this.rangeStackShow&&B.length){var I=ad+(this.dataTextFontSize/2)+this.dataTextMargin;for(var aq=0;aq<this.rangeStack.length;aq++){this.Mc({p:["drawText",this.rangeStack[aq],B[aq],I,this.dataTextFont,this.foreground,"left","middle"],t:"Decorations"})}}}if(A){ao="roundArrow"}if(this.barType=="bullet"&&this.bulletStyle.match(/Gradient/)){E=this.uf(ab,0,-ab,1,[E,"rgb(255, 255, 255)"]);aE=E}if(ab<0){if(ap){aA=this.Mc({p:["drawShape",ao,((an+ap)-X)-(ab/2),(ad+ae)+((aa-this.variableSpace)/2),-ab,(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,E,aE,ai[ar],ao=="arrow"?true:false,false,av],i:aG[ar],m:al,t:at,h:V})}else{aA=this.Mc({p:["drawShape",ao,(an+ab)-(ab/2),(ad+ae)+((aa-this.variableSpace)/2),-ab,(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,E,aE,ai[ar],ao=="arrow"?true:false,false,av],i:aG[ar],m:al,t:at,h:V})}}else{if(ap){aA=this.Mc({p:["drawShape",ao,((an+ap)-X)-(ab/2),(ad+ae)+((aa-this.variableSpace)/2),ab,(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,E,aE,ai[ar],ao=="arrow"?true:false,false,av],i:aG[ar],m:al,t:at,h:V})}else{aA=this.Mc({p:["drawShape",ao,an+(ab/2),(ad+ae)+((aa-this.variableSpace)/2),ab,(aa*(this.barType=="bullet"?this.bulletWidthRatio:1))-this.variableSpace,E,aE,ai[ar],ao=="arrow"?true:false,false,av],i:aG[ar],m:al,t:at,h:V})}}if(this.barType=="bullet"&&this.bulletStyle.match(/Gradient/)){this.XI()}aw=ap?(an+ap)-(ab+X):an+ab;af=ad+au;if(ax[ar]&&this.t2(ax[ar],true)){Y=(ax[ar]/2)*ac;this.Mc({p:["drawLine","error",aw,af,aw+Y,af,this.errorBarsColor,au,"butt"],g:aA,t:at,h:V});this.Mc({p:["drawLine","error",aw,af,aw-Y,af,this.errorBarsColor,au,"butt"],g:aA,t:at,h:V})}if(Z){var T=C(ar);for(var aB in Z){if(aB!="cap"&&aB!="high"&&aB!="color"&&aB!="fill"){if(Z[aB][T]){for(var N=0;N<Z[aB][T].length;N++){var K=((Z[aB][T][N][0]-am)*ac)-X;var O=((Z[aB][T][N][1]-am)*ac)-X;var G=(ad+ae)+((aa-this.variableSpace)/2);this.Mc({p:["drawShape",this.shapes[0],an+K,G,aa/2,aa/2,Z.color[aB],Z.color[aB]],g:aA,t:at,h:V});if(!this.t2(O,true)){O=ab-this.margin}else{this.Mc({p:["drawShape",this.shapes[1],an+O,G,aa/2,aa/2,Z.color[aB],Z.color[aB]],g:aA,t:at,h:V})}this.Mc({p:["drawLine","line",an+K,G,an+O,G,Z.color[aB],this.margin],g:aA,t:at,h:V})}}}}}if(this.barType=="bullet"&&this.bulletTargetVarName.length){var aq=this.as(this.bulletTargetVarName);if(aq>-1){var T=this.layoutComb?this.sF(this.data.l.smps[this.layoutCurrent][0]):ar;var J=((this.uP(aq,T)-am)*ac)-X;var ay=(aa-this.variableSpace)*this.bulletTargetWidthRatio;var F=(ad+ae)+((aa-this.variableSpace)/2);if(this.bulletTargetType=="line"){aA=this.Mc({p:["drawLine","line",an+J,F-(ay/2),an+J,F+(ay/2),this.bulletTargetVarColor,this.bulletTargetLineWidth],i:[aq,T],m:al,t:"Decorations"})}else{var ak=this.bulletTargetType.replace("openC","c").replace("openS","s");this.Mc({p:["drawShape",ak,an+J,F,ay,ay,this.bulletTargetType.match(/open/)?"rgba(0,0,0,0)":this.bulletTargetVarColor,this.bulletTargetVarColor,false,false,this.bulletTargetLineWidth],i:[aq,T],m:al,t:"Decorations"})}}}if(this.showDataValues&&!this.barType.match(/lollipop/)){var R=((this.r9(this.ct(az[ar]),this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);this.Mc({p:["drawText",this.ct(az[ar]),aw+R,af,this.dataTextFont,this.dataTextColor||aC[ar],this.dataTextAlign,this.dataTextBaseline],g:aA,t:at,h:V})}Q=0}ad+=this.Hl(ah)?ah[ar+1]-ah[ar]:ah;Q+=this.Hl(ah)?ah[ar+1]-ah[ar]:ah}}};this.ma=function(am,al,ad,W,U,ai,V,ac,aa,ao,Y,X,ar,ak,aj,ae,L,aq,y){var R=this;var H=function(b){if(R.isGraphTime){for(var a=b-1;a>=0;a--){if(!isNaN(am[a])){return a}}}return b-1};var P=function(){var b=[[],[]];if(aa=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var v=function(aP,aO,aF,aA,ax,aK,az,aE,aD,aQ,aC,aB,aR,aN,aM,aG,ay,b,aI){var z=0;var aw=aI[0].xy;var aL=[];var n=[];var p=[];var av=[];var aJ=[];for(var aH=0;aH<aI.length;aH++){if(aI[aH].split!=z){R.ma(aL,n,(aD=="vertical"?aw:aF),(aD=="vertical"?aA:aw),ax,p,az,aE,aD,aQ,av,aB,aJ,aN,aM,aG,ay,b);z=aI[aH].split;aw=aI[aH].xy;aL=[aP[aH]];n=[aO[aH]||null];p=[aK[aH]||aw];av=[aC[aH]];aJ=[aR[aH]]}else{aL.push(aP[aH]);n.push(aO[aH]||null);p.push(aK[aH]||aI[aH].xy);av.push(aC[aH]);aJ.push(aR[aH])}}R.ma(aL,n,(aD=="vertical"&&R.graphType!="ParallelCoordinates"?aw:aF),(aD=="vertical"?aA:aw),ax,p,az,aE,aD,aQ,av,aB,aJ,aN,aM,aG,ay,b)};var Z,C,B,A,j,au,at,an,Q,D,O;var T=null;var G=null;var N=U/2;var M=this.dataPointSize*0.5;var ap=Y=="open"?ao:this.objectBorderColor||ao;var ab=am.length-1;var S=[[],[]];var r=[[],[]];var af=[];var E=this.as(L);var ah=aq?"Overlays":"Data";var I=this.lineThickness;var F=[];if(y){return v(am,al,ad,W,U,ai,V,ac,aa,ao,Y,X,ar,ak,aj,ae,L,aq,y)}else{if(aa=="vertical"){C=ad;B=ad+(this.Hl(ai)?ai[1]-ai[0]:ai);if(T==null){T=C}if(this.QT([E])){ao=this.varHighlightColor;I+=2}for(var ag=1;ag<am.length;ag++){Z=ag-1;if(this.ZR(V)){j=W-((am[Z]-V[Z].min)*V[Z].units);au=W-((am[ag]-V[ag].min)*V[ag].units)}else{j=W-((am[Z]-ac)*V);au=W-((am[ag]-ac)*V)}if(G==null){G=j}O=this.lineBy?this.e1(false,false,"Property:"+this.lineBy+":"+ar[Z][2]+":x"):false;if(this.t2(j,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&X){an=this.Mc({p:["drawShape",X,C,j,M,M,ao,ap,Y[Z],false,false,aj],i:ar[Z],m:ak,g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{an=this.Mc({p:["drawShape","sphere",C,j,M,M,this.eN(ao,0,true),"rgba(0,0,0,0)",Y[Z],false,false,aj],i:ar[Z],m:ak,g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}if(this.showDataValues){if(this.dataValuesFrequency=="all"){var K=((this.Dr(this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);this.Mc({p:["drawText",this.ct(am[Z]),C,j-K,this.dataTextFont,this.dataTextColor||ao,this.dataTextAlign,this.dataTextBaseline],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{if(ag==1&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="first")){this.Mc({p:["drawText",this.ct(am[Z]),C-this.margin,j,this.dataTextFont,this.dataTextColor||ao,"right","middle"],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{if(ag==ab&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="last")){this.Mc({p:["drawText",this.ct(am[ag]),B+this.margin,au,this.dataTextFont,this.dataTextColor||ao,"left","middle"],t:ah,h:this.lineBy?O:this.e1(ar[ag][0],ar[ag][1])})}}}}if(!Q){Q=an}if(this.t2(al[Z],true)){at=(al[Z]/2)*this.ZR(V)?V[Z].units:V;if(this.lineErrorType=="bar"){this.Mc({p:["drawLine","error",C,j,C,j+at,ao,-N,"butt"],i:["Line:"+L+":"+E],g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)});this.Mc({p:["drawLine","error",C,j,C,j-at,ao,-N,"butt"],i:["Line:"+L+":"+E],g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)})}else{r[0].push([C,C]);r[1].push([j+at,j-at]);af.push([C,j])}}if(this.lineType=="spline"){S[0].push(C);S[1].push(j)}}if(this.isGraphTime&&isNaN(j)&&this.t2(au,true)){Z=H(ag);j=W-((am[Z]-ac)*V);C=F[Z]}if((this.lineType!="spline"&&this.t2(j,true)&&this.t2(au,true))||am.length<3){an=this.Mc({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(Y[Z]||"solid"):this.lineType,C,j,B,au,ao,I,"butt",false,false,aj],i:["Line:"+L+":"+E],g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)})}else{if(this.lineType=="spline"&&!this.t2(au,true)){an=this.Mc({p:["drawLine","spline",S[0],S[1],false,false,ao,I,false,false,false,aj],i:["Line:"+L+":"+E],g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)});S=[[],[]];T=null;G=null}}if(!Q){Q=an}if(r[0].length>0&&!this.t2(au,true)){var x=this.eN(ao,0.3,true);if(this.lineType=="spline"){this.Mc({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}else{var J=P();this.Mc({p:["drawShape","path",J[0],J[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}r=[[],[]];af=[]}F.push(C);C=B;B+=(this.Hl(ai)?ai[ag+1]-ai[ag]:ai)}O=this.lineBy?this.e1(false,false,"Property:"+this.lineBy+":"+ar[ab][2]+":x"):false;if(this.t2(au,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&X){an=this.Mc({p:["drawShape",X,C,au,M,M,ao,ap,Y[ab],false,false,aj],i:ar[ab],m:ak,g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{an=this.Mc({p:["drawShape","sphere",C,au,M,M,this.eN(ao,0,true),"rgba(0,0,0,0)",Y[ab],false,false,aj],i:ar[ab],m:ak,g:Q,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}if(this.showDataValues){if(this.dataValuesFrequency=="all"){var K=((this.Dr(this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);this.Mc({p:["drawText",this.ct(am[ab]),C,au-K,this.dataTextFont,this.dataTextColor||ao,this.dataTextAlign,this.dataTextBaseline],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{if(ag==1&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="first")){this.Mc({p:["drawText",this.ct(am[0]),C-this.margin,au,this.dataTextFont,this.dataTextColor||ao,"right","middle"],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{if(ag==ab&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="last")){this.Mc({p:["drawText",this.ct(am[ab]),B+this.margin,au,this.dataTextFont,this.dataTextColor||ao,"left","middle"],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}}}}if(!Q){Q=an}if(this.t2(al[ab],true)){at=(al[ab]/2)*this.ZR(V)?V[ab].units:V;if(this.lineErrorType=="bar"){this.Mc({p:["drawLine","error",C,au,C,au+at,ao,-N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)});this.Mc({p:["drawLine","error",C,au,C,au-at,ao,-N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)})}else{if(ag==am.length){r[0].push([C,C]);r[1].push([au+at,au-at]);af.push([C,au])}}}if(this.lineType=="spline"){S[0].push(C);S[1].push(au)}}if(this.lineType=="spline"){an=this.Mc({p:["drawLine","spline",S[0],S[1],false,false,ao,I,false,false,false,aj],i:["Line:"+L+":"+E],b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)})}if(!Q){Q=an}if(r[0].length>0){var x=this.eN(ao,0.3,true);if(this.lineType=="spline"){this.Mc({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}else{var J=P();this.Mc({p:["drawShape","path",J[0],J[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}}}else{j=W;au=W+(this.Hl(ai)?ai[1]-ai[0]:ai);if(G==null){G=j}for(var ag=1;ag<am.length;ag++){Z=ag-1;if(this.ZR(V)){C=ae?ad+ae-((am[Z]-V[Z].min)*V[Z].units):ad+((am[Z]-V[Z].min)*V[Z].units);B=ae?ad+ae-((am[ag]-V[ag].min)*V[ag].units):ad+((am[ag]-V[ag].min)*V[ag].units)}else{C=ae?ad+ae-((am[Z]-ac)*V):ad+((am[Z]-ac)*V);B=ae?ad+ae-((am[ag]-ac)*V):ad+((am[ag]-ac)*V)}if(T==null){T=C}O=this.lineBy?this.e1(false,false,"Property:"+this.lineBy+":"+ar[Z][2]+":x"):false;if(this.t2(C,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&X){this.Mc({p:["drawShape",X,C,j,M,M,ao,ap,Y[Z],false,false,aj],i:ar[Z],m:ak,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{this.Mc({p:["drawShape","sphere",C,j,M,M,this.eN(ao,0,true),"rgba(0,0,0,0)",Y[Z],false,false,aj],i:ar[Z],m:ak,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}if(this.showDataValues){var K=((this.r9(this.ct(am[Z]),this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);if(this.dataValuesFrequency=="all"){this.Mc({p:["drawText",this.ct(am[Z]),C+K,j,this.dataTextFont,this.dataTextColor||ao,this.dataTextAlign,this.dataTextBaseline],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{if(ag==1&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="first")){this.Mc({p:["drawText",this.ct(am[Z]),C,j-this.margin,this.dataTextFont,this.dataTextColor||ao,"center","bottom"],t:ah,h:this.lineBy?O:this.e1(ar[Z][0],ar[Z][1])})}else{if(ag==ab&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="last")){this.Mc({p:["drawText",this.ct(am[ab]),B,au+this.margin,this.dataTextFont,this.dataTextColor||ao,"center","top"],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}}}}if(this.t2(al[Z],true)){A=(al[Z]/2)*this.ZR(V)?V[Z].units:V;if(this.lineErrorType=="bar"){an=this.Mc({p:["drawLine","error",C,j,C+A,j,ao,N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)});if(!Q){Q=an}this.Mc({p:["drawLine","error",C,j,C-A,j,ao,N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)})}else{r[0].push([C+A,C-A]);r[1].push([j,j]);af.push([C,j])}}if(this.lineType=="spline"){S[0].push(C);S[1].push(j)}}if(this.isGraphTime&&isNaN(C)&&this.t2(B,true)){Z=H(ag);C=ad+((am[Z]-ac)*V);j=F[Z]}if((this.lineType!="spline"&&this.t2(C,true)&&this.t2(B,true))||am.length<3){an=this.Mc({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(Y[Z]||"solid"):this.lineType,C,j,B,au,ao,I,"butt",false,false,aj],i:["Line:"+L+":"+E],b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)})}else{if(this.lineType=="spline"&&!this.t2(B,true)){an=this.Mc({p:["drawLine","spline",S[0],S[1],false,false,ao,I,false,false,false,aj],i:["Line:"+L+":"+E],b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)});S=[[],[]];T=null;G=null}}if(!Q){Q=an}if(r[1].length>0&&!this.t2(B,true)){var x=this.eN(ao,0.3,true);if(this.lineType=="spline"){this.Mc({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}else{var J=P();this.Mc({p:["drawShape","path",J[0],J[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}r=[[],[]];af=[]}F.push(j);j=au;au+=(this.Hl(ai)?ai[ag+1]-ai[ag]:ai)}O=this.lineBy?this.e1(false,false,"Property:"+this.lineBy+":"+ar[ab][2]+":x"):false;if(this.t2(B,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&X){this.Mc({p:["drawShape",X,B,j,M,M,ao,ap,Y[ab],false,false,aj],i:ar[ab],m:ak,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{this.Mc({p:["drawShape","sphere",B,j,M,M,this.eN(ao,0,true),"rgba(0,0,0,0)",Y[ab],false,false,aj],i:ar[ab],m:ak,b:[T,G],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}if(this.showDataValues){if(this.dataValuesFrequency=="all"){var K=((this.r9(this.ct(am[Z]),this.dataTextFont)/2)+this.dataTextMargin)*(this.dataValuesPosition=="inside"?-1:1);this.Mc({p:["drawText",this.ct(am[ab]),B+K,j,this.dataTextFont,this.dataTextColor||ao,this.dataTextAlign,this.dataTextBaseline],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{if(ag==1&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="first")){this.Mc({p:["drawText",this.ct(am[0]),B,j-this.margin,this.dataTextFont,this.dataTextColor||ao,"center","bottom"],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}else{if(ag==ab&&(this.dataValuesFrequency=="ends"||this.dataValuesFrequency=="last")){this.Mc({p:["drawText",this.ct(am[ab]),B,au+this.margin,this.dataTextFont,this.dataTextColor||ao,"center","top"],t:ah,h:this.lineBy?O:this.e1(ar[ab][0],ar[ab][1])})}}}}if(this.t2(al[ab],true)){A=(al[ab]/2)*this.ZR(V)?V[ab].units:V;if(this.lineErrorType=="bar"){an=this.Mc({p:["drawLine","error",B,j,B+A,j,ao,N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)});if(!Q){Q=an}this.Mc({p:["drawLine","error",B,j,B-A,j,ao,N,"butt"],i:["Line:"+L+":"+E],g:Q,t:ah,h:this.lineBy?O:this.e1(E)})}else{r[0].push([B+A,B-A]);r[1].push([j,j]);af.push([B,j])}}if(this.lineType=="spline"){S[0].push(B);S[1].push(j)}}if(this.lineType=="spline"){an=this.Mc({p:["drawLine","spline",S[0],S[1],false,false,ao,I,false,false,false,aj],i:["Line:"+L+":"+E],b:[T,G],t:ah,h:this.lineBy?O:this.e1(E)})}if(!Q){Q=an}if(r[1].length>0){var x=this.eN(ao,0.3,true);if(this.lineType=="spline"){this.Mc({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}else{var J=P();this.Mc({p:["drawShape","path",J[0],J[1],false,false,x,x,"closed"],i:["Line-Error:"+L+":"+E],b:af,t:ah,h:this.lineBy?O:this.e1(E)})}}}}};this.DN=function(U,N,F,C,W,I,R,E,y,J,V,H,X,L,O,S,T){var m=F;var B=N;var s=this;var Y=T?"Overlays":"Data";var h=function(a){var c=0;if(s.dodgeBy){for(var b=0;b<U.length;b++){if(U[b]!=0){c++}}}return a/c};var Q=function(c,e,b,d,a){return s.gV(c,{width:d,height:a,left:e,top:b})};var A=h(C);if(J=="vertical"){F=m-y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P==U.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var x=this.sG(V[P],X[P]);var r=C>5?this.Yi(x,X[P]):x;if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+(C/2),F-(D/2),C,D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,D);this.A8(K,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+(A/2),F-(D/2),A,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+(C/2),F-(D/2),C,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+(C/2),F-(D/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}F=m-y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":"roundrectb";var x=this.sG(V[P],X[P]);var r=C>5?this.Yi(x,X[P]):x;if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,-D);this.A8(K,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+(A/2),F-(D/2),A,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+(C/2),F-(D/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}}else{N=B+y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P<U.length-1||!this.useRoundRectangles?"rectangle":O?"roundrectl":"roundrectr";var x=this.sG(V[P],X[P]);var r=C>5?this.Yi(x,X[P]):x;if(O){if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,D,C);this.A8(K,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+O-(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+O-(D/2),F+(C/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,D,C);this.A8(T,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+(D/2),F+(C/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}N=B+y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":O?"roundrectr":"roundrectl";var x=this.sG(V[P],X[P]);var r=C>5?this.Yi(x,X[P]):x;if(O){if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,-D,C);this.A8(K,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+O-(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+O-(D/2),F+(C/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.Mc({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,-D,C);this.A8(T,0,0)}else{if(this.dodgeBy){var j=this.e1(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.Mc({p:["drawShape",M,N+(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.e1(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.e1(X[P][0],X[P][1]);var G=this.Mc({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.Mc({p:["drawText",this.ct(U[P]),N+(D/2),F+(C/2),this.dataTextFont,this.dataTextColor||this.foreground,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}}};this.TG=function(ah,Y,R,P,ad,S,af,U,I,D,m,W,ae,aj,V,am,ak,L,G,al){var X=ah.length-1;var Z=ae&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var T=[];var an=-D*I;var C=m*I;var ac=al?"Overlays":"Data";var K=function(b,a){for(var c=a+1;c<ah[b].length;c++){if(ah[b][c]>0){return 1}else{if(ah[b][c]<0){return -1}}}return 0};if(W=="vertical"){for(var ab=0;ab<ah[0].length;ab++){A[ab]=af=="stacked"&&D<0?R-C:R;B[ab]=R-C}for(var ab=0;ab<ah.length;ab++){var ag=Y;var O=ae?[]:[Y];var M=ae?[]:[R-an];var H=0;var ai,J;for(var aa=0;aa<ah[0].length;aa++){if(!this.t2(ah[ab][aa],true)){ah[ab][aa]=0}var Q=af=="percent"?((ah[ab][aa]-D)*100/U[aa])*I:(ah[ab][aa]-(af=="stacked"&&D<0?0:D))*I;O.push(ag);if(af&&(af=="stacked"||af=="percent")){if(ah[ab][aa]>0||H>0){M.push(A[aa]-Q);A[aa]-=Q;H=1}else{if(ah[ab][aa]<0||H<0){M.push(B[aa]-Q);B[aa]-=Q;H=-1}else{var N=K(ab,aa);if(N<0){M.push(B[aa]-Q);B[aa]-=Q;H=-1}else{if(N>0){M.push(A[aa]-Q);A[aa]-=Q;H=1}else{M.push(an)}}}}}else{M.push(R-Q)}ag+=S}if(!ae){O.push(Y+P);M.push(R-an)}T.push([O,M,aj[ab],V[ab],am[ab]])}}else{for(var ab=0;ab<ah[0].length;ab++){A[ab]=L?Y+L:af=="stacked"&&D<0?Y+C:Y;B[ab]=Y+C}for(var ab=0;ab<ah.length;ab++){var ag=R;var O=ae?[]:L?[Y+L]:[Y+an];var M=ae?[]:[R];var H=0;var ai,J;for(var aa=0;aa<ah[0].length;aa++){if(!this.t2(ah[ab][aa],true)){ah[ab][aa]=0}var Q=af=="percent"?((ah[ab][aa]-D)*100/U[aa])*I:(ah[ab][aa]-(af=="stacked"&&D<0?0:D))*I;M.push(ag);if(af&&(af=="stacked"||af=="percent")){if(L){O.push(A[aa]-Q);A[aa]-=Q}else{if(ah[ab][aa]>0||H>0){O.push(A[aa]+Q);A[aa]+=Q;H=1}else{if(ah[ab][aa]<0||H<0){O.push(B[aa]+Q);B[aa]+=Q;H=-1}else{var N=K(ab,aa);if(N<0){O.push(B[aa]+Q);B[aa]+=Q;H=-1}else{if(N>0){O.push(A[aa]+Q);A[aa]+=Q;H=1}else{M.push(an)}}}}}}else{O.push(L?Y+L-Q:Y+Q)}ag+=S}if(!ae){O.push(L?Y+L:Y+an);M.push(R+ad)}T.push([O,M,aj[ab],V[ab],am[ab]])}}while(X>=0){var ai,J;var aa=T.pop();if(ae){if(this.lineType=="spline"){this.Mc({p:["drawLine",Z,aa[0],aa[1],false,false,aa[2],this.lineThickness],i:aa[4],m:ak,b:W=="vertical"?R-an:Y+an,t:ac,h:this.e1(aa[4][0])})}else{var J=null;for(var ab=1;ab<aa[0].length;ab++){var ai=this.Mc({p:["drawLine",Z,aa[0][ab-1],aa[1][ab-1],aa[0][ab],aa[1][ab],aa[2],this.lineThickness],i:aa[4],m:ak,g:J,b:W=="vertical"?R-an:Y+an,t:ac,h:this.e1(aa[4][0])});if(J==null){J=ai}}}}else{if(D>=0&&X>0&&af!="overlapping"){var E=W=="vertical"?T[T.length-1][1]:T[T.length-1][0];if(W=="vertical"){aa[0].shift();aa[0].pop();var F=[];var ao=[];if(this.lineType=="spline"){for(var ab=1;ab<aa[1].length-1;ab++){F.push([aa[0][ab-1],aa[0][ab-1]]);ao.push([aa[1][ab],E[ab]])}}else{for(var ab=1;ab<aa[1].length-1;ab++){F.push(aa[0][ab-1]);ao.push(aa[1][ab])}for(var ab=aa[1].length-2;ab>0;ab--){F.push(aa[0][ab-1]);ao.push(E[ab])}}aa[1].shift();aa[1].pop();this.Mc({p:["drawShape",this.lineType=="spline"?"confidence":"polygon",F,ao,this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:R-an,t:ac,h:this.e1(aa[4][0])})}else{aa[1].shift();aa[1].pop();var F=[];var ao=[];if(this.lineType=="spline"){for(var ab=1;ab<aa[0].length-1;ab++){F.push([aa[0][ab],E[ab]]);ao.push([aa[1][ab-1],aa[1][ab-1]])}}else{for(var ab=1;ab<aa[0].length-1;ab++){F.push(aa[0][ab]);ao.push(aa[1][ab-1])}for(var ab=aa[0].length-2;ab>0;ab--){F.push(E[ab]);ao.push(aa[1][ab-1])}}aa[0].shift();aa[0].pop();this.Mc({p:["drawShape",this.lineType=="spline"?"confidence":"polygon",F,ao,this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:Y+an,t:ac,h:this.e1(aa[4][0])})}}else{if(af=="overlapping"||af=="stacked"){this.Mc({p:["drawShape",Z,aa[0],aa[1],this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:W=="vertical"?R-an:Y+an,t:ac,h:this.e1(aa[4][0])})}else{if(W=="vertical"){if(this.lineType=="spline"){var ao=[];for(var ab=1;ab<aa[1].length-1;ab++){ao.push([aa[1][ab],aa[1][0]])}this.Mc({p:["drawShape","confidence",F,ao,this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:R-an,t:ac,h:this.e1(aa[4][0])})}else{this.Mc({p:["drawShape","polygon",aa[0],aa[1],this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:R-an,t:ac,h:this.e1(aa[4][0])})}}else{if(this.lineType=="spline"){var F=[];for(var ab=1;ab<aa[0].length-1;ab++){F.push([aa[0][ab],aa[0][0]])}this.Mc({p:["drawShape","confidence",F,ao,this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:Y+an,t:ac,h:this.e1(aa[4][0])})}else{this.Mc({p:["drawShape","polygon",aa[0],aa[1],this.width,this.height,this.sG(aa[2]),this.Yi(aa[2]),aa[3]],i:aa[4],m:ak,b:Y+an,t:ac,h:this.e1(aa[4][0])})}}}}}if(G){var u=this.eN(aa[2],0,true);var g=Math.min(10,S);for(var ab=1;ab<aa[0].length-1;ab++){if(this.isGraphTime&&G[ab-1]<0){continue}ai=this.Mc({p:["drawShape","sphere",aa[0][ab],aa[1][ab],g,g,u,"rgba(0,0,0,0)",aa[3]],i:[aa[4][0],G[ab-1]],s:true,t:ac});if(!ae){if(W=="vertical"){this.Mc({p:["drawLine","line",aa[0][ab],aa[1][ab]+S,aa[0][ab],aa[1][0],u,S],i:[aa[4][0],G[ab-1]],g:ai,s:true,t:ac})}else{this.Mc({p:["drawLine","line",aa[0][ab]-S,aa[1][ab],aa[0][0],aa[1][ab],u,S],i:[aa[4][0],G[ab-1]],g:ai,s:true,t:ac})}}}}X--}};this.Sp=function(ax,am,ae,ab,ah,ad,al,aj,ay,ai,aA,at,x,aa){var Y=this;var ak=this.segregateSamplesBy.length&&this.isGroupedData&&this.groupingFactors.includes(this.segregateSamplesBy[0]);var F=function(f){var d;if(Y.layoutValid&&!Y.isDOE){if(Y.segregateVariablesBy.length>0){d=f}else{if(Y.segregateSamplesBy.length>0){var a=!ak?[Y.data.l.name[Y.layoutCurrent],Y.data.w.glab[f]].join("::"):Y.data.w.labs[f]?Y.data.w.labs[f]:Y.data.w.glab[f];for(var c=0;c<n.g[I].length;c++){if(n.g[I][c].density.name==a){d=c;break}}}}}else{d=Y.grpIndices[f]}return n.g[I][d]};var J=function(a){if(Y.showBoxplotOriginalData){if(Y.plotStyle=="ggplot"){return Y.background;return Y.eN(Y.sG(ay[a],aA[a]),Y.boxplotTransparency,true,false,true)}else{return Y.eN(Y.sG(ay[a],aA[a]),Y.boxplotTransparency,true,false,true)}}else{return Y.sG(ay[a],aA[a])}};var Z=function(a){return aj=="vertical"?ae-((a-al)*ad):am+((a-al)*ad)};var n=this.meta.data.d;var I=this.as(aa);var af=this.variableSpace/2;var aq=ab/2;var M=aq/2;var K=M/2;var av=ab/this.boxplotOutliersRatio;var L={};var X={};var Q=false;var V=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(ab-this.variableSpace)*this.boxplotWidthRatioIfViolin:ab-this.variableSpace;var U=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?ab*this.boxplotWidthRatioIfViolin:0;var T=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?U/2:aq;var b=Math.max(1,ab/4);if(aj=="vertical"){for(var ap=0;ap<ax.length;ap++){if(this.isGraphTime&&aA[ap][1]<0){am+=this.Hl(ah)?ah[ap]:ah;continue}var W=this.showBoxplotOriginalData?this.e1(aA[ap][0]):this.scatterPlotMatrix&&this.scatterType=="boxplot"?this.e1(false,false,aA[ap][1]):this.e1(aA[ap][0],aA[ap][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ax[ap].length>1){var E=F(this.layoutValid?aA[ap][1]:ap);if(E){this.Wp(E,am+(ab/2),ae,ab/this.varIndices.length,ad,al,aj,at[ap],x[ap],aA[ap],W,ax[ap]);if(!this.showBoxplotIfViolin){Q=true}}}var ag=am+aq;var ac=[];var D=[];var R=this.showBoxplotOriginalData||this.showViolinBoxplot?at[ap]:ay[ap];for(var ao=0;ao<5;ao++){ac.push(Z(ax[ap][ao]));D.push(ac[ac.length-1].toString())}if(this.YR()){aA[ap]=false}if(!Q){var S=(am+af)+((ab-this.variableSpace)/2);var au=ac[3]+((ac[2]-ac[3])/2);var ar=V;var az=ac[2]-ac[3];var e=this.boxplotNotched?Z(ax[ap][7][0]):false;var an=this.boxplotNotched?Z(ax[ap][7][1]):false;var O=J(ap);var N=this.plotStyle.match(/open|border|ggplotSwitched/)?this.Y3(O):this.boxplotBorderColor;var H=this.boxplotMedianColor||N;if(this.boxplotColor){O=this.boxplotColor}var aw,P,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){ar=V*ax[ap][8];U+=(V-ar)/2}if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){P=[am+(ab-af-U)-b,am+af+U,am+af+U,am+(ab-af-U),am+(ab-af-U),am+af+U+b,am+(ab-af-U)-b]}else{P=[am+af+U+b,am+af+U,am+af+U,am+(ab-af-U),am+(ab-af-U),am+(ab-af-U)-b,am+af+U+b]}A=[ac[4],e,ac[2],ac[2],e,ac[4],ac[4]];aw=this.Mc({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W});A=[ac[4],an,ac[3],ac[3],an,ac[4],ac[4]];this.Mc({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}else{if(this.boxplotType=="range"){aw=this.Mc({p:["drawLine","line",S,ac[1],S,ac[0],this.plotStyle=="open"?N:O,av,"round"],i:aA[ap],b:ae,t:"Data",h:W})}else{aw=this.Mc({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",S,au,ar,az,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W})}}if(this.l4(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.Mc({p:["drawLine","median",am+af+U+b,ac[4],am+(ab-af-U)-b,ac[4],H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}else{if(this.boxplotType=="range"){this.Mc({p:["drawShape","sphere",S,ac[4],av*2.5,av*2.5,this.plotStyle=="open"?N:O,this.plotStyle=="open"?N:O],i:aA[ap],g:aw,t:"Data",h:W})}else{this.Mc({p:["drawLine","median",S-(ar/2),ac[4],S+(ar/2),ac[4],H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ac[0]>ac[2]){this.Mc({p:["drawLine","line",ag,ac[2],ag,ac[0],N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[1]<ac[3]){this.Mc({p:["drawLine","line",ag,ac[3],ag,ac[1],N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}else{if(this.boxplotWhiskersType=="double"){if(ac[0]>ac[2]){this.Mc({p:["drawLine","error",ag,ac[2],ag,ac[0],N,-T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[1]<ac[3]){this.Mc({p:["drawLine","error",ag,ac[3],ag,ac[1],N,-T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}}}}if(this.boxplotMean){this.Mc({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",ag,Z(ax[ap][6]),M,M,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}if(ax[ap][5]&&!this.showBoxplotOriginalData){var G={};for(var ao=0;ao<ax[ap][5].length;ao++){if(G[ax[ap][5][ao]]){continue}G[ax[ap][5][ao]]=true;var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?N:O);var C=this.boxplotOutliersBorderColor||N;this.Mc({p:["drawShape",k,ag,Z(ax[ap][5][ao]),av,av,B,C,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}}}if(!L.hasOwnProperty(R)){L[R]=[];X[R]=this.Ev(aA[ap])}L[R].push([am+af+(ab/2),ac[4]]);am+=this.Hl(ah)?ah[ap+1]-ah[ap]:ah}}else{for(var ap=0;ap<ax.length;ap++){if(this.isGraphTime&&aA[ap][1]<0){ae+=this.Hl(ah)?ah[ap]:ah;continue}var W=this.showBoxplotOriginalData?this.e1(aA[ap][0]):this.e1(aA[ap][0],aA[ap][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ax[ap].length>1){var E=F(this.layoutValid?aA[ap][1]:ap);if(E){this.Wp(E,am,ae+(ab/2),ab/this.varIndices.length,ad,al,aj,at[ap],x[ap],aA[ap],W,ax[ap]);if(!this.showBoxplotIfViolin){Q=true}}}var ag=ae+aq;var ac=[];var D=[];var R=this.showBoxplotOriginalData||this.showViolinBoxplot?at[ap]:ay[ap];for(var ao=0;ao<5;ao++){ac.push(Z(ax[ap][ao]));D.push(ac[ac.length-1].toString())}if(this.YR()){aA[ap]=false}if(!Q){var S=ac[2]+((ac[3]-ac[2])/2);var au=(ae+af)+((ab-this.variableSpace)/2);var ar=ac[3]-ac[2];var az=V;var e=this.boxplotNotched?Z(ax[ap][7][0]):false;var an=this.boxplotNotched?Z(ax[ap][7][1]):false;var O=J(ap);var N=this.plotStyle.match(/open|border|ggplotSwitched/)?this.Y3(O):this.boxplotBorderColor;var H=this.boxplotMedianColor||N;if(this.boxplotColor){O=this.boxplotColor}var aw,P,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){az=V*ax[ap][8];U+=(V-az)/2}if(this.boxplotNotched&&this.boxplotType!="range"){P=[ac[4],e,ac[2],ac[2],e,ac[4],ac[4]];if(this.showViolinBoxplot){A=[ae+(ab-af-U)-b,ae+af+U,ae+af+U,ae+(ab-af-U),ae+(ab-af-U),ae+af+U+b,ae+(ab-af-U)-b]}else{A=[ae+af+U+b,ae+af+U,ae+af+U,ae+(ab-af-U),ae+(ab-af-U),ae+(ab-af-U)-b,ae+af+U+b]}aw=this.Mc({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W});P=[ac[4],an,ac[3],ac[3],an,ac[4],ac[4]];this.Mc({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}else{if(this.boxplotType=="range"){aw=this.Mc({p:["drawLine","line",ac[0],au,ac[1],au,this.plotStyle=="open"?N:O,av,"round"],i:aA[ap],b:am,t:"Data",h:W})}else{aw=this.Mc({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",S,au,ar,az,O,N,ai[ap]],i:aA[ap],b:am,t:"Data",h:W})}}if(this.l4(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.Mc({p:["drawLine","median",ac[4],ae+af+U+b,ac[4],ae+(ab-af-U)-b,H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}else{if(this.boxplotType=="range"){this.Mc({p:["drawShape","sphere",ac[4],au,av*2.5,av*2.5,this.plotStyle=="open"?N:O,this.plotStyle=="open"?N:O],i:aA[ap],g:aw,t:"Data",h:W})}else{this.Mc({p:["drawLine","median",ac[4],au-(az/2),ac[4],au+(az/2),H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ac[2]>ac[0]){this.Mc({p:["drawLine","line",ac[2],ag,ac[0],ag,N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[3]<ac[1]){this.Mc({p:["drawLine","line",ac[3],ag,ac[1],ag,N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}else{if(this.boxplotWhiskersType=="double"){if(ac[2]>ac[0]){this.Mc({p:["drawLine","error",ac[2],ag,ac[0],ag,N,T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[3]<ac[1]){this.Mc({p:["drawLine","error",ac[3],ag,ac[1],ag,N,T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}}}}if(this.boxplotMean){this.Mc({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",Z(ax[ap][6]),ag,M,M,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:aA[ap],g:aw,b:am,t:"Data",h:W})}if(ax[ap][5]&&!this.showBoxplotOriginalData){var G={};for(var ao=0;ao<ax[ap][5].length;ao++){if(G[ax[ap][5][ao]]){continue}G[ax[ap][5][ao]]=true;var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?N:O);var C=this.boxplotOutliersBorderColor||N;this.Mc({p:["drawShape",k,Z(ax[ap][5][ao]),ag,av,av,B,C,ai[ap]],i:aA[ap],g:aw,b:am,t:"Data",h:W})}}}if(!L.hasOwnProperty(R)){L[R]=[];X[R]=this.Ev(aA[ap])}L[R].push([ac[4],ae+af+(ab/2)]);ae+=this.Hl(ah)?ah[ap+1]-ah[ap]:ah}}if(this.boxplotConnect){for(var R in L){if(L[R].length>1){var aw=this.Mc({p:["drawLine","line",L[R][0][0],L[R][0][1],L[R][1][0],L[R][1][1],R,this.boxplotConnectWidth,"butt"],i:["Line:",X[R][0],X[R][1]],t:"Data",h:W});for(var ap=1;ap<L[R].length-1;ap++){this.Mc({p:["drawLine","line",L[R][ap][0],L[R][ap][1],L[R][ap+1][0],L[R][ap+1][1],R,this.boxplotConnectWidth,"butt"],i:["Line:",X[R][0],X[R][1]],g:aw,t:"Data",h:W})}}}}};this.Op=function(R,E,T,H,L,C,P,B,K,F,S,U){var y=function(a){return L+((a-K)*B)};var x=null;for(var N=0;N<R.length;N++){var J=y(R[N][0]);var f=y(R[N][1]);var A=J+((f-J)/2);var e=C+(P/2);var W=f-J;var v=E[N]?W*E[N]:false;var w=this.sG(S[N],U[N]);var g=this.eN(w,this.ganttCompletionTransparency,true,false,true);var s=this.Yi(w,U[N]);var r=this.e1(false,U[N][0]);var D=this.Mc({p:["drawShape","roundrect",A,e,W,P,g,g,F[N]],i:U[N],g:x,b:L,t:"Data",h:r});if(!x){x=D}if(E[N]){if(E[N]==1){this.Mc({p:["drawShape","roundrect",A,e,W,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}else{this.Mc({p:["drawShape","roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}}this.Mc({p:["drawShape","roundrect",A,e,W,P,false,s,"open"],i:U[N],g:x,b:L,t:"Data",h:r});if(H.length){for(var M=0;M<H.length;M++){var I=y(H[M][0]);this.Mc({p:["drawShape","triangle2",I,C,P/3,P/3,w,s],i:[].concat(U[N].concat(H[M][1])),g:x,b:L,t:"Data",h:r})}}if(T[N]){var G=y(T[N][0]);var X=y(T[N][1]);var V=T[N][2]+(P/2);var Q=e==V?X:G+((X-G)/2);var n=e==V?V:V+(P/2);var O=A-(W/2);var k=e;this.Mc({p:["drawLine",n==k?"line":"roundLine",Q,n,O,k,this.Yi(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]],i:U[N],g:x,b:L,t:"Data",h:r})}}};this.Wp=function(s,J,B,N,A,H,F,Q,E,D,g,O){var k=[];var L=[];var e=[];var G=[];var b=[[],[]];var I,f,r,n,w,a,R,P;var S=s.density.maxY>0?s.density.maxY:0.000001;switch(this.violinScale){case"area":I=N/S*S/s.scale*0.9/this.widthFactor;break;case"count":I=N/S*s.density.sumY/s.area*0.9/this.widthFactor;break;case"width":I=N/S*0.9/this.widthFactor;break}var C=this.eN(this.violinColor||Q,this.showBoxplotOriginalData&&!this.violinColor&&this.plotStyle!="ggplot"?0:this.violinTransparency,true);if(this.violinTrim){f=[];for(var M=s.density.trim[0];M<s.density.trim[1];M++){f.push(s.density.xy[M])}}else{f=s.density.xy}if(F=="vertical"){for(var M=0;M<f.length;M++){r=(f[M][1]*I);n=((f[M][0]-H)*A);k.push(J-r);L.push(B-n);e.push(J+r);G.push(B-n);b[0].push(J);b[1].push(B-n)}}else{for(var M=0;M<f.length;M++){r=((f[M][0]-H)*A);n=(f[M][1]*I);k.push(J+r);L.push(B-n);e.push(J+r);G.push(B+n);b[0].push(J+r);b[1].push(B)}}if(k.length>1&&L.length>1){this.Mc({p:["drawShape","violin",[k,e],[L,G],false,false,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g});if(this.showViolinQuantiles){r=O;for(M=2;M<=4;M++){if(F=="vertical"){for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=f[K][1]*I;P=B-((r[M]-H)*A);this.Mc({p:["drawLine","solid",J-R,P,J+R,P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}else{for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=J+((r[M]-H)*A);P=f[K][1]*I;this.Mc({p:["drawLine","solid",R,B-P,R,B+P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}}}}else{if(F=="vertical"){r=J;n=B-((s.density.median[0]-H)*A)}else{r=J+((s.density.median[0]-H)*A);n=B}this.Mc({p:["drawShape","circle",r,n,this.margin,this.margin,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g})}};this.b2=function(D,A,h,w,g,z,k,x,F,n,e,c,b){var E=[];if(x=="vertical"){for(var C=0;C<D.length;C++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)&&!this.isGroupedData)){for(var B=0;B<D[C].length;B++){if(this.isGraphTime&&D[C][B]==null){continue}var p=F?F[C][B]:false;var f=h-((D[C][B]-z)*g);if(this.t2(f,true)){E.push([A,f,k[C][B]/2,p])}else{E.push([A,Number.NaN,k[C][B]/2,p])}}}A+=this.Hl(w)?w[C+1]-w[C]:w}}else{for(var C=0;C<D.length;C++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)&&!this.isGroupedData)){for(var B=0;B<D[C].length;B++){if(this.isGraphTime&&D[C][B]==null){continue}var p=F?F[C][B]:false;var f=e?A+e-((D[C][B]-z)*g):A+((D[C][B]-z)*g);if(this.t2(f,true)){E.push([f,h,k[C][B]/2,p])}else{E.push([Number.NaN,h,k[C][B]/2,p])}}}h+=this.Hl(w)?w[C+1]-w[C]:w}}return E};this.S0=function(R,J,A,D,z,I,Q,F,V,w,h){var p=this;var n=function(){var a=[];if(F=="vertical"){for(var l=0;l<R.length;l++){if((p.showBoxplotOriginalData&&p.isRawData)||p.graphType.match(/Dot/)||(p.graphType.match(/Bar/)&&p.barType.match(/lollipop/)&&!p.isGroupedData)){for(var k=0;k<R[l].length;k++){if(p.isGraphTime&&R[l][k]==null){continue}var f=V?V[l][k]:false;var d=A-((R[l][k]-I)*z);if(p.t2(d,true)){a.push([J,d,Q[l][k],f])}else{a.push([J,Number.NaN,Q[l][k],f])}}}J+=p.Hl(D)?D[l+1]-D[l]:D}}else{for(var l=0;l<R.length;l++){if((p.showBoxplotOriginalData&&p.isRawData)||p.graphType.match(/Dot/)||(p.graphType.match(/Bar/)&&p.barType.match(/lollipop/)&&!p.isGroupedData)){for(var k=0;k<R[l].length;k++){if(p.isGraphTime&&R[l][k]==null){continue}var f=V?V[l][k]:false;var d=w?J+w-((R[l][k]-I)*z):J+((R[l][k]-I)*z);if(p.t2(d,true)){a.push([d,A,Q[l][k],f])}else{a.push([Number.NaN,A,Q[l][k],f])}}}A+=p.Hl(D)?D[l+1]-D[l]:D}}return a};var H=this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData;var E=this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData;if(H||E){var U=n();if(H){var B=this.meta.data.x[this.connectBy];var M=0;var T=this.iH(this.connectByData);var e=this.lX(T.length);var S={};if(this.isGraphTime){for(var N=0;N<this.timeValueIndices.length;N++){if(this.timeValueIndices[N]>0){S[N.toString()]=this.timeValueIndices[N]}}}for(var N in this.connectByData){var C;var s=null;var R=this.connectByData[N];var r=this.connectByNoColor?this.connectByColor:B&&B.type!="Numeric"?B.connects[B.order[N]%B.connects.length]:e[M%e.length];if(R.length>1){for(var L=1;L<R.length;L++){var x=this.isGraphTime?U[S[R[L-1]]]:U[R[L-1]];var g=this.isGraphTime?U[S[R[L]]]:U[R[L]];if(x&&g){C=this.Mc({p:["drawLine","line",x[0],x[1],g[0],g[1],r,this.connectByWidth,"butt"],i:["Line:"+this.connectBy+" "+N,x[3][0],x[3][2],g[3][2]],g:s,t:"Data",h:this.e1(false,x[3][2])});if(s==null){s=C}}}}M++}}else{if(E){this.connectByDataVar.push(U);if(h){var B=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var N in this.connectByData){var R=this.connectByData[N];if(this.connectByDataVar.length==R.length){for(var K=0;K<this.connectByDataVar[0].length;K++){for(var L=1;L<R.length;L++){var x=this.connectByDataVar[R[L-1]][K];var g=this.connectByDataVar[R[L]][K];var c=N;if(x&&g){var P=this.data.y.vars[x[3][0]];var G=this.data.y.vars[g[3][0]];var O=this.data.y.smps[x[3][(this.isGroupedData?2:1)]];var b=this.data.y.smps[g[3][(this.isGroupedData?2:1)]];if(O==b){c=P+" - "+G+" ("+O+")"}else{c=P+" ("+O+") - "+G+" ("+b+")"}}if(this.dotplotType.match(/bullet/)){this.Mc({p:["drawLine","line",J,x[1],J+this.x,g[1],this.eN(this.connectByColor,0.2),Math.min(x[2],g[2]),"butt"],i:["Bkg:"+this.connectBy+" "+c],t:"Data",h:this.e1(false,x[3][2])})}if(this.dotplotType.match(/arrow/)){if(x[0]>g[0]){this.Mc({p:["drawLine","line",x[0],x[1],g[0],g[1],this.connectByColor,this.connectByWidth,"butt",x[2],g[2],false,false,false,"arrow"],i:["Line:"+this.connectBy+" "+c],t:"Data",h:this.e1(false,x[3][2])})}else{if(g[0]>x[0]){this.Mc({p:["drawLine","line",g[0],g[1],x[0],x[1],this.connectByColor,this.connectByWidth,"butt",x[2],g[2],false,false,false,"arrow"],i:["Line:"+this.connectBy+" "+c],t:"Data",h:this.e1(false,x[3][2])})}}}else{this.Mc({p:["drawLine","line",x[0],x[1],g[0],g[1],this.connectByColor,this.dotplotType.match(/bullet|connected/i)?Math.min(x[2],g[2]):this.connectByWidth,"butt"],i:["Line:"+this.connectBy+" "+c],t:"Data",h:this.e1(false,x[3][2])})}}}}}}}}}};this.wb=function(ae,ac,U,M,Z,P,L,T,N,R,af,V,Q,ak,J,O,I,D,C,ah){var H=this;var z=function(h){var l=H.segregateSamplesBy.length&&H.isGroupedData&&H.groupingFactors.includes(H.segregateSamplesBy[0]);var c=H.meta.data.d;var k=H.as(D);var e;if(H.layoutValid&&!H.isDOE){if(H.segregateVariablesBy.length>0){e=h}else{if(H.segregateSamplesBy.length>0){var a=!l?[H.data.l.name[H.layoutCurrent],H.data.w.glab[h]].join("::"):H.data.w.labs[h]?H.data.w.labs[h]:H.data.w.glab[h];for(var d=0;d<c.g[k].length;d++){if(c.g[k][d].density.name==a){e=d;break}}}}}else{if(H.isGroupedData){e=H.grpIndices[h]}}return c.g&&c.g[k]?c.g[k][e]:!H.isGroupedData&&c.v?c.v[k]:false};var B=function(l,c){var a=c[0];var j=0;var e="";var m={n:{},arr:{}};for(var h=0;h<l.length;h++){var d=l[h]!=null?l[h].toString():"";if(!m.n.hasOwnProperty(d)){m.n[d]=0;m.arr[d]=[]}m.n[d]++;if(m.n[d]>j){j=m.n[d];e=d}}if(m.n[e]*a>Z){a=Z*(H.binAlignment=="center"?1:0.5)/m.n[e]}for(var d in m.n){switch(H.binAlignment){case"bottom":case"right":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--}break;case"top":case"left":case"centerwhole":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break;case"center":if(m.n[d]%2){m.arr[d].push(0);m.n[d]--}else{m.arr[d].push(-a/2);m.n[d]--;m.arr[d].push(a/2);m.n[d]--}while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--;k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break}}return m.arr};var f=[];var Y=ah?"Overlays":"Data";if(R=="vertical"){for(var X=0;X<ae.length;X++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/))){var ag=this.dotplotType=="transition"?false:this.binned?B(ae[X],N[X]):false;var A=this.dotplotType=="transition"?false:this.jitter||this.sina?this.kD(this.Y1(0,ae[X].length),false,Z*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var x=z(X);this.fP(A,x,ae[X],Z)}for(var W=0;W<ae[X].length;W++){if(this.isGraphTime&&ae[X][W]==null){continue}var S=this.dotplotType=="transition"?0:this.binned&&ag[ae[X][W]]?ag[ae[X][W].toString()].shift():this.jitter?A[W]:0;var b=ak?ak[X][W]:false;var K=M-((ae[X][W]-T)*L);var E=this.sG(af[X][W],b);var F=this.plotStyle=="open"?this.Y3(E):this.Yi(E,b);if(this.plotStyle=="open"){E=this.background}if(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)){b.push("Lollipop")}if(this.t2(K,true)){var ad;f.push([U+S,K,N[X][W]/2,b]);if(this.graphType.match(/Dot/)&&this.dotplotType=="transition"&&W>0){var G=f.length-1;var g=f.length-2;while(!this.t2(f[g][1],true)&&g>=0){g--}if(this.t2(f[g][1],true)){var aj=f[G];var ab=f[g];var aa=this.eN(E,0.2,false,false,true);this.Mc({p:["drawShape","polygon",[aj[0]-aj[2],ab[0]-ab[2],ab[0]+ab[2],aj[0]+aj[2]],[aj[1],ab[1],ab[1],aj[1]],false,false,aa,aa],t:"Decorations",h:this.e1(aj[3][0],aj[3][1])||this.e1(ab[3][0],ab[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)&&this.barLollipopOpen){ad=this.Mc({p:["drawShape",Q[X][W],U+S,K,N[X][W],N[X][W],this.background,E,V[X][W],false,2,O],i:b,m:J,b:M,t:Y,h:this.e1(b[0],b[1])})}else{if(this.plotStyle!="open"&&N[X][W]<2.5){ad=this.Mc({p:["drawShape",Q[X][W],U+S,K,N[X][W],N[X][W],E,E,V[X][W],false,false,O],i:b,m:J,b:M,t:Y,h:this.e1(b[0],this.isGroupedData||(this.graphType=="Dotplot"&&b[2]!=null)?b[2]:b[1])})}else{ad=this.Mc({p:["drawShape",Q[X][W],U+S,K,N[X][W],N[X][W],E,F,V[X][W],false,false,O],i:b,m:J,b:M,t:Y,h:this.e1(b[0],this.isGroupedData||(this.graphType=="Dotplot"&&b[2]!=null)?b[2]:b[1])})}}if(this.showDataValues){this.Mc({p:["drawText",this.ct(ae[X][W]),U+S,K,this.dataTextFont,this.dataTextColor||(this.plotStyle=="open"?F:E),"center","middle"],g:ad,t:Y,h:this.e1(b[0],b[1])})}if(!this.isGroupedData){if(ac[X]&&ac[X][W]&&this.t2(ac[X][W],true)){var ai=(ac[X][W]/2)*L;this.Mc({p:["drawLine","error",U+S,K,U+S,K+ai,E,-Z,"butt",false,false,true],i:b,g:ad,t:Y,h:this.e1(b[0],b[1])});this.Mc({p:["drawLine","error",U+S,K,U+S,K-ai,E,-Z,"butt",false,false,true],i:b,g:ad,t:Y,h:this.e1(b[0],b[1])})}}}else{f.push([U+S,Number.NaN,N[X][W]/2,b])}}if(this.showErrorBars&&this.isGroupedData&&ac[X]&&ac[X]&&this.t2(ac[X][0],true)&&this.t2(ac[X][1],true)){var K=M-((ac[X][0]-T)*L);var ai=(ac[X][1]/2)*L;var b=ak?[ak[X][0][0],ak[X][0][1],"error"]:false;this.Mc({p:["drawShape","diamond",U,K,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,O],h:this.e1(false,ak[X][0][0]),t:Y});this.Mc({p:["drawLine","line",U,K-ai,U,K+ai,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,O],h:this.e1(false,ak[X][0][0]),t:Y})}}U+=this.Hl(P)?P[X+1]-P[X]:P}}else{for(var X=0;X<ae.length;X++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/))){var ag=this.dotplotType=="transition"?false:this.binned?B(ae[X],N[X]):false;var A=this.dotplotType=="transition"?false:this.jitter||this.sina?this.kD(this.Y1(0,ae[X].length),false,Z*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var x=z(X);this.fP(A,x,ae[X],Z)}for(var W=0;W<ae[X].length;W++){if(this.isGraphTime&&ae[X][W]==null){continue}var S=this.dotplotType=="transition"?0:this.binned&&ag[ae[X][W]]?ag[ae[X][W].toString()].shift():this.jitter?A[W]:0;var b=ak?ak[X][W]:false;var K=I?U+I-((ae[X][W]-T)*L):U+((ae[X][W]-T)*L);var E=this.sG(af[X][W],b);var F=this.plotStyle=="open"?this.Y3(E):this.Yi(E,b);if(this.plotStyle=="open"){E=this.background}if(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)){b.push("Lollipop")}if(this.t2(K,true)){var ad;f.push([K,M+S,N[X][W]/2,b]);if(this.graphType.match(/Dot/)&&this.dotplotType=="transition"&&W>0){var G=f.length-1;var g=f.length-2;while(!this.t2(f[g][0],true)&&g>=0){g--}if(this.t2(f[g][0],true)){var aj=f[G];var ab=f[g];var aa=this.eN(E,0.2,false,false,true);this.Mc({p:["drawShape","polygon",[aj[0],ab[0],ab[0],aj[0]],[aj[1]-aj[2],ab[1]-ab[2],ab[1]+ab[2],aj[1]+aj[2]],false,false,aa,aa],t:"Decorations",h:this.e1(aj[3][0],aj[3][1])||this.e1(ab[3][0],ab[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType.match(/lollipop/)&&this.barLollipopOpen){ad=this.Mc({p:["drawShape",Q[X][W],K,M+S,N[X][W],N[X][W],this.background,E,V[X][W],false,2,O],i:b,m:J,b:U,t:Y,h:this.e1(b[0],b[1])})}else{if(this.plotStyle!="open"&&N[X][W]<2.5){ad=this.Mc({p:["drawShape",Q[X][W],K,M+S,N[X][W],N[X][W],E,E,V[X][W],false,false,O],i:b,m:J,b:U,t:Y,h:this.e1(b[0],this.isGroupedData||(this.graphType=="Dotplot"&&b[2]!=null)?b[2]:b[1])})}else{ad=this.Mc({p:["drawShape",Q[X][W],K,M+S,N[X][W],N[X][W],E,F,V[X][W],false,false,O],i:b,m:J,b:U,t:Y,h:this.e1(b[0],this.isGroupedData||(this.graphType=="Dotplot"&&b[2]!=null)?b[2]:b[1])})}}if(this.showDataValues){this.Mc({p:["drawText",this.ct(ae[X][W]),K,M+S,this.dataTextFont,this.dataTextColor||(this.plotStyle=="open"?F:E),"center","middle"],g:ad,t:Y,h:this.e1(b[0],b[1])})}if(!this.isGroupedData){if(ac[X]&&ac[X][W]&&this.t2(ac[X][W],true)){var ai=(ac[X][W]/2)*L;this.Mc({p:["drawLine","error",K,M+S,K+ai,M+S,E,Z,"butt",false,false,true],i:b,g:ad,t:Y,h:this.e1(b[0],b[1])});this.Mc({p:["drawLine","error",K,M+S,K-ai,M+S,E,Z,"butt",false,false,true],i:b,g:ad,t:Y,h:this.e1(b[0],b[1])})}}}else{f.push([Number.NaN,M+S,N[X][W]/2,b])}}}if(this.showErrorBars&&this.isGroupedData&&ac[X]&&ac[X]&&this.t2(ac[X][0],true)&&this.t2(ac[X][1],true)){var K=U+((ac[X][0]-T)*L);var ai=(ac[X][1]/2)*L;var b=ak?[ak[X][0][0],ak[X][0][1],"error"]:false;this.Mc({p:["drawShape","diamond",K,M,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,O],h:this.e1(false,false,"Var-"+ak[X][0][0]),t:Y});this.Mc({p:["drawLine","line",K-ai,M,K+ai,M,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,O],h:this.e1(false,false,"Var-"+ak[X][0][0]),t:Y})}M+=this.Hl(P)?P[X+1]-P[X]:P}}};this.Sq=function(K,E,y,n,G,J,O,I,B,N,A,H){var x=1;var j=E;var z=0.75;var D=this.meta.vals;var M=this.plotInfo.variables;if(!D.colors){D.colors={}}for(var F=0;F<K.length;F++){var s=K[F];var L=this.isContour?"rgba(0,0,0,0)":s==null||!this.t2(s,true)?this.missingDataColor:D.colors[s.toString()]?D.colors[s.toString()]:H?this.b3(N[H[F]],s):this.b3(N,s);var C=J&&A?this.eN(L,A,true):J?L:this.heatmapCellBoxColor;var k=M[F].xy+(z/2);if(!H){D.colors[s==null?"null":s.toString()]=L}if(A){L=this.eN(L,A,true)}if(this.graphType=="Network"){if(this.shapeByShape){this.Mc({p:["drawShape",this.shapeByShape,E+(n/2),y+(G/2),n/2,G/2,L,C,B[F]],i:O[F],m:I,t:"Decorations",h:this.e1(O[F])})}else{this.Mc({p:["drawShape","rectangle",E+(n/2),y+(G/2),n,G,L,L,B[F]],i:O[F],m:I,t:"Decorations",h:this.e1(O[F])})}}else{if(this.shapeByShape){this.Mc({p:["drawShape",this.shapeByShape,k+(n/2),y+(G/2),n/2,G/2,L,C,B?B[F]:false],i:O[F],m:I,t:"Data",h:this.e1(O[F][0],O[F][1])})}else{if(F>0&&F<K.length-1){if(x>=1){this.Mc({p:["drawShape","rect",k,y+((G+z)/2),n+z,G+z,L,L,B?B[F]:false],i:O[F],m:I,b:[j,y+((G+z)/2),0,G+z],h:this.e1(O[F][0],O[F][1]),t:"Data"});x=0}}else{this.Mc({p:["drawShape","rect",k,y+((G+z)/2),n+z,G+z,L,L,B?B[F]:false],i:O[F],m:I,b:[j,y+((G+z)/2),0,G+z],h:this.e1(O[F][0],O[F][1]),t:"Data"})}}}if(this.showDataValues){this.Mc({p:["drawText",this.ct(s),(k+((n+z)/2))-2,(y+G)-2,this.dataTextFont,this.dataTextColor||this.foreground,"right","bottom"],t:"Data"})}E+=n;x+=n}};this.A8=function(B,u,p,C,D){var f=this;var r=this.HA()?this.top+this.y:this.left;var k=function(d,c){if(c){f.Mc({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.Yi(d.color),"open",false,d.outline,C,D],b:r,t:"Data"})}else{f.Mc({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.sG(d.color,d.index),f.Yi(d.color,d.index),"closed",false,false,C,D],i:d.index,b:r,t:"Data",h:f.e1(d.index[0],d.index[1])})}if(d.label){var b=f.r9(d.label,f.overlayTextFont);if(b+f.margin<d.coords.width&&f.overlayTextFontSize+f.margin<d.coords.height){if(c){f.Mc({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayTextFont,f.eN(f.foreground,0.5,true),"center","middle"],t:"Data"})}else{f.Mc({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayTextFont,f.foreground,"left","top"],t:"Data"})}}else{if(b+f.margin<d.coords.height&&f.overlayTextFontSize+f.margin<d.coords.width){if(c){f.Mc({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayTextFont,f.eN(f.foreground,0.5,true),"center","middle",-Math.PI/2],t:"Data"})}else{f.Mc({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayTextFont,f.foreground,"right","top",-Math.PI/2],t:"Data"})}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth&&!this.isDOE?1:0;var E=this.isDOE?0:this.treemapBorderWidth;var o=E*2;var e=this.smpTextFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.Mc({p:["disableGradientTransparencyShadow"],t:"Data"});if(a.coords.border>1){this.Mc({p:["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D],t:"Data"});this.Mc({p:["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>0){this.Mc({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>-1){this.Mc({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}}}var z=this.r9(a.title,this.smpTextFont);if(z+this.margin<n&&this.smpTextFontSize<=e&&a.coords.height>e+(E/2)){this.Mc({p:["drawText",a.title,m+this.margin,j+(this.smpTextFontSize/2),this.smpTextFont,this.foreground,"left","middle"],t:"Data"})}this.Mc({p:["enableGradientTransparencyShadow"],t:"Data"})}if(a.children){s(a.children)}else{k(a)}}};this.yK=function(p){this.v1(Math.min(this.width,this.height)/16,"sankeyTextFont");var n=p.links[0].target.x-p.links[0].source.x;this.sankeyHighlights={};for(var j=0;j<p.links.length;j++){var o=p.links[j];var k=this.colorBy?this.e1(false,false,"Property:"+this.colorBy+":"+o.meta+":x"):false;var b=this.Mc({p:["drawShape","bezier",o.plotX,o.plotY,n,o.dy,this.sG(o.color),this.sankeyOutlineColor,false,o.colors],i:o.tooltip,b:[this.left,this.top+this.y/2,n,o.dy],t:"Data",h:k});if(!this.sankeyHighlights.hasOwnProperty(o.target.name)){this.sankeyHighlights[o.target.name]=[]}if(!this.sankeyHighlights.hasOwnProperty(o.source.name)){this.sankeyHighlights[o.source.name]=[]}this.sankeyHighlights[o.target.name].push(b);this.sankeyHighlights[o.source.name].push(b)}for(var j=0;j<p.nodes.length;j++){var g=p.nodes[j];this.Mc({p:["drawShape","rectangle",g.plotX+(g.dx/2),g.plotY+(g.dy/2),g.dx,g.dy,g.color,this.foreground],i:g.tooltip,b:[this.left,this.top+this.y/2,g.dx,g.dy],t:"Data"});if(this.sankeyTextShow){var o=this.r9(g.name,this.sankeyTextFont);var f=this.margin*0.75;var m=g.plotX+(g.dx/2)+this.sankeyTextMargin;var c=g.plotY+(g.dy/2);var l=this.sankeyTextAlign;if(this.sankeyTextAuto){if(this.sankeyTextAlign=="left"){m=g.plotX-f;l="right"}else{if(this.sankeyTextAlign=="right"){m=g.plotX+(g.dx+f);l="left"}}}else{if(this.sankeyTextInside){if((this.sankeyTextAlign=="left"&&g.breadth>0)||(this.sankeyTextAlign=="right"&&g.breadth==p.object.maxBreadth)){m=g.plotX-f;l="right"}else{if(this.sankeyTextAlign=="right"||g.breadth==0){m=g.plotX+g.dx+f;l="left"}}}}var a=["drawText",g.name,m,c,this.sankeyTextFont,this.sankeyTextColor,l,this.sankeyTextBaseline];var e=false;if(o<(g.dy+(this.sankeyNodePadding*1))&&this.sankeyTextAuto){m+=this.sankeyTextAlign=="center"?0:this.sankeyTextAlign=="left"?-(g.dx/2):(g.dx/2);a=["drawText",g.name,m,c,this.sankeyTextFont,this.sankeyTextColor,"center",this.sankeyTextBaseline,-this.sankeyTextRotate*Math.PI/180];e=true}else{if(this.sankeyTextAuto){if(this.sankeyTextFontSize<=((g.dy*2)+this.sankeyNodePadding)){e=true}}else{e=true}}if(e){this.Mc({p:a,i:[g.tooltip[0]+":T"],t:"Data"})}}}};this.Oc=function(b,f){if(this.data.tree&&this.data.tree.plot){var a=this.data.tree.plot;var d=this.treeNodeSize;var i=b=="vertical"?true:false;var e=this.treeType=="bracket"?this.treeLabelAlign:this.treeLabelAlign=="left"?"right":this.treeLabelAlign=="right"?"left":this.treeLabelAlign;var k=this;var h=i?a.x0:a.y0;var g=i?a.y0:a.x0;var j=function(o){var n=i?o.x0:o.y0;var m=i?o.y0:o.x0;var l=k.e1(false,false,false,false,o);var u=o.data.size*k.treeBracketLengthFactor;var t=k.treeType=="bracket"?(k.treeLabelAlign=="right"?((u/2)-k.margin):((-u/2)+k.margin)):k.treeLabelAlign=="right"?(u/2)+k.margin:-(u/2)-k.margin;if(!(k.treeType=="bracket"&&o.id==0)){k.Mc({p:["drawShape",o.data.shape,n,m,u,o.data.size,k.sG(o.data.color,o.id),k.treeNodeOutlineColor,o.data.pattern,false,k.treeLinkWidth],i:["Tree-Node:"+o.id],b:[h,g],t:"Data",h:l})}if(o.children){for(var p=0;p<o.children.length;p++){j(o.children[p])}if(k.treeType=="circular"){if(k.treeLabelAlign=="center"){k.Mc({p:["drawText",o.data.name,n,m,k.smpTextFont,k.smpTextColor,"center","middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{var s=(Math.PI/2)-o.angle;var r=((d+(k.margin*2))*Math.cos(s))*(k.treeInverted?-1:1);var q=((d+(k.margin*2))*Math.sin(s))*(k.treeInverted?-1:1);if(o.angle<=Math.PI){k.Mc({p:["drawText",o.data.name,n-r,m-q,k.smpTextFont,k.smpTextColor,k.treeInverted?"left":"right","middle",s],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{k.Mc({p:["drawText",o.data.name,n-r,m-q,k.smpTextFont,k.smpTextColor,k.treeInverted?"right":"left","middle",s-Math.PI],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}}}else{if(i){if(o.parent){k.Mc({p:["drawText",o.data.name,n,m-((d/2)+k.margin),k.smpTextFont,k.smpTextColor,"right","middle",Math.PI/2],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{k.Mc({p:["drawText",o.data.name,n,m-((d/2)+k.margin),k.smpTextFont,k.smpTextColor,"center","bottom"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}}else{if(!(k.treeType=="bracket"&&o.id==0)){if(k.treeLabelAlign!="center"){k.Mc({p:["drawText",o.data.name,n+t,m+1,k.smpTextFont,k.smpTextColor,e,"middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{k.Mc({p:["drawText",o.data.name,n,m+1,k.smpTextFont,k.smpTextColor,"center","middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}}}}}else{if(k.treeType=="circular"){if(k.treeLabelAlign=="center"){k.Mc({p:["drawText",o.data.name,n,m,k.smpTextFont,k.smpTextColor,"center","middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{var s=(Math.PI/2)-o.angle;var r=((d+(k.margin*2))*Math.cos(s))*(k.treeInverted?-1:1);var q=((d+(k.margin*2))*Math.sin(s))*(k.treeInverted?-1:1);if(o.angle<=Math.PI){k.Mc({p:["drawText",o.data.name,n+r,m+q,k.smpTextFont,k.smpTextColor,k.treeInverted?"right":"left","middle",s],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{k.Mc({p:["drawText",o.data.name,n+r,m+q,k.smpTextFont,k.smpTextColor,k.treeInverted?"left":"right","middle",s-Math.PI],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}}}else{if(i){k.Mc({p:["drawText",o.data.name,n,m+(d/2)+k.margin,k.smpTextFont,k.smpTextColor,"left","middle",Math.PI/2],i:["Tree-Text-:"+o.id],b:[h,g],t:"Data",h:l})}else{if(k.treeLabelAlign!="center"){k.Mc({p:["drawText",o.data.name,n+t,m+1,k.smpTextFont,k.smpTextColor,e,"middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}else{k.Mc({p:["drawText",o.data.name,n,m+1,k.smpTextFont,k.smpTextColor,"center","middle"],i:["Tree-Text:"+o.id],b:[h,g],t:"Data",h:l})}}}}};var c=function(o){if(o.children){for(var m=0;m<o.children.length;m++){c(o.children[m])}}if(o.parent){var q=i?o.x0:o.y0;var n=i?o.y0:o.x0;var r=i?o.parent.x0:o.parent.y0;var p=i?o.parent.y0:o.parent.x0;var s=o._clicked?[r,p,r,p]:[h,g,h,g];var l=k.e1(false,o.id);if(k.treeType=="circular"){k.Mc({p:["drawLine","bezier",r,p,q,n,k.treeLinkColor,k.treeLinkWidth,false,false,false,false,false,false,false,false,false,[o.mx,o.my,o.mx2,o.my2]],i:[o.parent.id+":"+o.id],b:s,t:"Data",h:l})}else{if(k.treeType=="bracket"){if(o.parent.id!=0){k.Mc({p:["drawLine",(p!=n?"bracket":"line"),r,p,q,n,k.treeLinkColor,k.treeLinkWidth],i:[o.parent.id+":"+o.id],b:s,t:"Data",h:l})}}else{k.Mc({p:["drawLine","bezier",r,p,q,n,k.treeLinkColor,k.treeLinkWidth],i:[o.parent.id+":"+o.id],b:s,t:"Data",h:l})}}o._clicked=false}};c(a);if(!f){j(a)}}};this.mB=function(a){if(this.PU()){return}var e=this.varIndices;var d=this.smpIndices;this.C6(false,e,d);this.varIndicesStart=0;var f=[];var c=Math.min(a,e.length);for(var b=0;b<c;b++){f.push(e[b])}this.varIndices=f;this.Oj({func:"zoomOncoprintVariables",par:[a]})}};CanvasXpress.prototype.init3dUtils=function(){this.V4=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var a=1;a<=360;a++){var b=Math.PI/(180/a);this.meta.math.sin[a]=Math.sin(b);this.meta.math.cos[a]=Math.cos(b)}}};this.SS=function(){this.V4();var b=["xRotate","yRotate","zRotate"];for(var a=0;a<b.length;a++){var c=b[a];if(this[c]>360){this[c]-=360}if(this[c]<0){this[c]=360}}};this.Dd=function(){var c=this.zoom;var a=this.x;var b=this.y;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*c*this.x3DRatio;this.lenY=a/4*c*this.y3DRatio;this.lenZ=a/4*c*this.z3DRatio;this.padX=a/2;this.padY=b/2;this.padZ=this.padY};this.p6=function(i,b,l){var p,o,m;var n=[];var q=this.meta.math.sin;var h=this.meta.math.cos;var c=this.perspective;var a=parseInt(this.xRotate);var k=parseInt(this.yRotate);var f=parseInt(this.zRotate);var g=this.padX;var e=this.padY;var d=this.padZ;o=b;m=l;b=o*h[k]-m*q[k];l=o*q[k]+m*h[k];p=i;m=l;i=m*q[a]+p*h[a];l=m*h[a]-p*q[a];p=i;o=b;i=p*h[f]-o*q[f];b=p*q[f]+o*h[f];if(c){var j=c/(l+c);i=i*j;b=b*j;l=l*j}n.push(i+g);n.push(b+e);n.push(l+d);return n}};CanvasXpress.prototype.initApiUtils=function(){this.fZ=function(){return this.validGraphTypes};this.Js=function(){this.initializeAttributes()};this.sn=function(){if(this.th()||this.graphType=="Bar"){return true}else{return false}};this.vK=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&!this.YR()){return true}else{return false}};this.k5=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&!this.YR()&&this.graphType!="Pie"){return true}else{return false}};this.U0=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.q5=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.th()){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.LI=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.th()){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.kp=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.F8=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&!this.YR()&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.nT=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.th()){return true}else{return false}};this.X3=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.th()){return true}else{return false}};this.rw=function(){if(!this.YR()&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.Z3=function(){var b=["linear","exponential","logarithmic","power","polynomial","regression","normal","nonlinear","area","line","reg","nor","nlfit"];if(this.decorations){for(var a=0;a<b.length;a++){if(this.decorations[b[a]]){return true}}}else{return false}};this.lP=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.th()){return true}else{return false}};this.n2=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.Cv(a[b])+"Line")}}return e};this.ao=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.hY=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.gq=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.so=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.yJ=function(){return this.graphType.match(/BarLine|StackedLine|StackedPercentLine|AreaLine|DotLine/)};this.c1=function(){return this.showHistogram&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0};this.ym=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.gg(c,b,a)};this.AR=function(a){return this.Fe(a?this.highlightVar:this.highlightSmp)};this.on=function(g){if(this.PU()){return}var e=[];if(!this.Hl(g)){for(var d=0;d<arguments.length;d++){e.push(this.Ev(arguments[d]))}g=this.Ev(e)}else{e=this.Ev(g)}var b;var c=this;var a=e.shift();var f=this.Ev(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.Oj({func:"modifyOverlaysProperties",par:[g]})};this.AS=function(b,a){this.gg(b,a,"smpOverlays")};this.vX=function(b,a){this.gg(b,a,"varOverlays")};this.oP=function(){return this.Fe(this.smpOverlays)};this.AW=function(){return this.Fe(this.varOverlays)};this.wj=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.GU=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.pa=function(){return this.th()?this.GU():this.wj()};this.P5=function(){return[].concat(this.wj()).concat(this.GU())};this.rf=function(){return this.graphType.match(/scatter/i)?this.Vi():this.getVariablesAsArray};this.Vi=function(){var d=this.MJ();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.a3=function(){var d=this.iW();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.xS=function(a){return this.PT("nodes",a)};this.WO=function(a){return this.PT("edges",a)};this.ty=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.iH(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.qd=function(l,r,q,k,s){var h={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var c={};c[l]={o:{},t:"string",d:false};if(r){c[l]["o"]=this.Fe(this.data.y[l])}else{for(var f=0;f<this[h[l]["idx"]].length;f++){c[l]["o"][this.data.y[l][this[h[l]["idx"]][f]]]=true}}if(k||s){var n=k?this.as(q):this.sF(q,true);if(this.Hl(q)){for(var b=0;b<q.length;b++){var n=k?this.as(q[b]):this.sF(q[b],true);if(n>-1){c[q[b]]={o:{},t:"numeric",d:false};if(r){var e=this.meta.data.y.range[q[b]];c[q[b]]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.aC(g);c[q[b]]["o"]={min:a[0],max:a[1]}}}}}else{var n=k?this.as(q):this.sF(q,true);if(n>-1){c={};c[q]={o:{},t:"numeric",d:false};if(r){var e=this.meta.data.y.range[q];c[q]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.aC(g);c[q]["o"]={min:a[0],max:a[1]}}}}}if(this.data[h[l]["spc"]]){for(var j in this.data[h[l]["spc"]]){if(q&&j!=q){continue}var e=this.meta.data[h[l]["spc"]][j];c[j]={o:{},t:e.type.toLowerCase(),d:e.date};if(r){if(e.type=="Numeric"){c[j]["t"]="numeric";c[j]["o"]={min:e.rmin,max:e.rmax}}else{c[j]["t"]="string";c[j]["o"]=this.Ev(e.levels);if(c[j]["d"]){c[j]["d"]=[];for(var f=0;f<c[j].o.length;f++){c[j]["d"].push(new Date(c[j].o[f]).getTime())}var a=this.aC(c[j].d);c[j]["d"]={min:a[0],max:a[1]}}}}else{var g=[];for(var f=0;f<this[h[l]["idx"]].length;f++){var d=this.mU(this[h[l]["idx"]][f],h[l]["spc"],j,true);if(e.date){g.push(new Date(d).getTime())}if(!c[j]["o"].hasOwnProperty(d)){c[j]["o"][d]=true}}if(e.date){var a=this.aC(g);c[j]["d"]={min:a[0],max:a[1]}}if(c[j]["t"]=="numeric"){var g=[];for(var d in c[j]["o"]){for(var f=0;f<c[j]["o"][d];f++){g.push(d)}}var a=this.aC(g);c[j]["o"]={min:a[0],max:a[1]}}}}}return c};this.PT=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.lq(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.iH(this[d+"Data"])}else{return false}};this.Ww=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.lq(d,b,this[g+"Properties"])}}this.ty(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.aC(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.PG=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.Fe(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.lq(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.iH(this.featuresData)};this.lq=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.Xm=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.qg=function(a){this.Zv(a,1)};this.S2=function(a){this.Zv(a,-1)};this.r0=function(d,c){if(this.PU()){return}this.clusterAxis="samples";if(d||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.xa()}if(this.layoutValid&&!this.isDOE){var e=this.Ev(this.smpDendrogram);var f=this.Ev(this.varIndices);var a=this.Ev(this.smpIndices);for(var b=0;b<this.data.l.weight.length;b++){if(!this.data.l.cluster[b]){this.data.l.cluster[b]={}}if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){if(!this.data.l.cluster[b].smpDendrogram||this.data.l.cluster[b].smpDendrogram.leafs!=this.data.l.comp[b][1].length){this.varIndices=this.data.l.comp[b][0];this.smpIndices=this.data.l.comp[b][1];this.data.l.cluster[b].smpDendrogramNewick=this.xa()}}else{if(this.segregateSamplesBy.length>0){if(!this.data.l.cluster[b].smpDendrogram||this.data.l.cluster[b].smpDendrogram.leafs!=this.data.l.comp[b].length){this.smpIndices=this.data.l.comp[b];this.data.l.cluster[b].smpDendrogramNewick=this.xa()}}else{if(this.segregateVariablesBy.length>0){this.data.l.cluster[b].smpDendrogramNewick=this.smpDendrogramNewick}}}this.YU(this.data.l.cluster[b].smpDendrogramNewick,"smpDendrogram");this.data.l.cluster[b].smpDendrogram=this.smpDendrogram}this.varIndices=f;this.smpIndices=a;this.smpDendrogram=e}if(!c){this.Oj({func:"clusterSamples",par:[d,c]})}};this.cd=function(e,d){if(this.PU()){return}this.clusterAxis="variables";if(e||!this.varDendrogramNewick){this.varDendrogramNewick=this.xa()}if(this.layoutValid&&!this.isDOE){var b=this.Ev(this.varDendrogram);var f=this.Ev(this.varIndices);var a=this.Ev(this.smpIndices);for(var c=0;c<this.data.l.weight.length;c++){if(!this.data.l.cluster[c]){this.data.l.cluster[c]={}}if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){if(!this.data.l.cluster[c].varDendrogram||this.data.l.cluster[c].varDendrogram.leafs!=this.data.l.comp[c][0].length){this.varIndices=this.data.l.comp[c][0];this.smpIndices=this.data.l.comp[c][1];this.data.l.cluster[c].varDendrogramNewick=this.xa()}}else{if(this.segregateVariablesBy.length>0){if(!this.data.l.cluster[c].varDendrogram||this.data.l.cluster[c].varDendrogram.leafs!=this.data.l.comp[c].length){this.varIndices=this.data.l.comp[c];this.data.l.cluster[c].varDendrogramNewick=this.xa()}}else{if(this.segregateSamplesBy.length>0){this.data.l.cluster[c].varDendrogramNewick=this.varDendrogramNewick}}}this.YU(this.data.l.cluster[c].varDendrogramNewick,"varDendrogram");this.data.l.cluster[c].varDendrogram=this.varDendrogram}this.varIndices=f;this.smpIndices=a;this.varDendrogram=b}if(!d){this.Oj({func:"clusterVariables",par:[e,d]})}};this.D4=function(e,d){if(this.PU()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.ID();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.smpOverlays.includes("k-Means-S")){this.smpOverlays.push("k-Means-S")}this.FV("x","k-Means-S",false,true);this.zd("cat","smp","k-Means-S",true)}if(!d){this.Oj({func:"kmeansSamples",par:[e,d]})}};this.jN=function(e,d){if(this.PU()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.ID();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.varOverlays.includes("k-Means-V")){this.varOverlays.push("k-Means-V")}this.FV("z","k-Means-V",false,true);this.zd("cat","var","k-Means-V",true)}if(!d){this.Oj({func:"kmeansVariables",par:[e,d]})}};this.J4=function(e,c,h,g){if(this.graphType=="Circular"&&this.circularType=="bubble"){var d=this.data.bubble.root.children;for(var f=0;f<d.length;f++){var a=d[f];if(a.data.name==e){a.label.x+=c;a.label.y+=h;if(!g){this.Oj({func:"modifyLabelCoordinates",par:[e,c,h,g]})}else{this.Lt({func:"modifyLabelCoordinates",par:[e,c,h,g]})}return}}}};this.yg=function(){return this.layoutValid&&this.layoutType=="wrap"};this.bV=function(){return this.layoutValid&&this.layoutCollapse};this.yR=function(){return this.layoutValid&&this.layoutCollapse&&this.layoutAdjust};this.VZ=function(){return this.segregateVariablesBy.length||this.segregateSamplesBy.length};this.HA=function(){return this.graphOrientation=="vertical"};this.Ma=function(){return this.graphOrientation=="horizontal"};this.mY=function(){return this.graphType.match(/Area|ParallelCoordinates/)};this.YR=function(){return this.graphType=="Heatmap"};this.th=function(){return this.graphType.match(/Scatter/)}};CanvasXpress.prototype.initDimensionUtils=function(){this.eH=function(a,o,e){var c=this.margin;var j=this.meta.canvas.canvasPixelRatio;if(a||o||e){if(o||e){if(o){this.width=o;this.originalWidth=o}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.JN();this.left=c;this.right=c;this.bottom=c;this.pO()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width*j;this.meta.canvas.ctx.canvas.height=this.height*j;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width*j;this.meta.canvas.ctx2.canvas.height=this.height*j;this.meta.canvas.ctx2.canvas.style.width=this.width+"px";this.meta.canvas.ctx2.canvas.style.height=this.height+"px";this.meta.canvas.ctx.resetRender();this.meta.canvas.ctx2.resetRender();this.Rd(j,j,this.meta.canvas.ctx);this.Rd(j,j,this.meta.canvas.ctx2)}if(this.useLeaflet){return}if(this.graphType=="Scatter2D"&&this.scatterType=="visium"){this.backgroundType="panelImage"}this.Mc({p:["disableGradientTransparencyShadow"],t:"Size"});if(this.backgroundType=="image"){if(this.graphType=="Network"){var n=this.scaleFactorX||1;var l=this.scaleFactorY||1;var b=this.offsetX*n;var q=this.offsetY*l;var k=this.maxX?this.maxX*n:this.maxX;var d=this.maxY?this.maxY*l:this.maxY;var p=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.YX()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.Mc({p:["drawShape","image",(k/2)+b,(d/2)+q,k,d,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{this.Cl(CanvasXpress.cacheImages[this.zM(this.backgroundImage)],0,0,this.maxX,this.maxY,b,q,k,d,p)}}else{this.Mc({p:["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="panelImage"){if(this.graphType=="Network"){this.Mc({p:["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="solid"||this.backgroundType=="panel"||this.backgroundType=="panelSolidGradient"){this.Mc({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.plotBackgroundColor,this.plotBackgroundBorderColor],t:"Size"})}else{var i=this.uf(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0);this.Mc({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,i,i],t:"Size"})}}}this.Mc({p:["enableGradientTransparencyShadow"],t:"Size"})};this.GP=function(a,b){this.setDimensions(a,false,b)};this.sZ=function(b,a){this.setDimensions(false,b,a)};this.TX=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.Ys=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(j,b,l,k,i,a){if(this.PU()){return}if(!this.resizable){return}if(j<5||b<5){return}if(j&&b){if(Math.abs(this.width-j)<5&&Math.abs(this.height-b)<5){}}if(!j||!this.resizableX){j=this.width}if(!b||!this.resizableY){b=this.height}var g=this.meta.canvas.ctx.canvas;j=g.originalWidth=parseInt(j);b=g.originalHeight=parseInt(b);this.HW(l);if(!this.reproducing){this.XC(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}if(this.graphType=="Sankey"){this.di()}this.Oj({width:j,height:b,func:"setDimensions",par:[j,b,l,k,i,a]});this.ht();if(k){var d=this;setTimeout(function(){d.Se()},k)}else{this.Se()}if(i){try{i()}catch(f){}}};this.Uv=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.JN();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)}};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.UJ=function(){var m=["top","bottom","right","left"];var l=this.legendPosition;var a=this.graphType;var e=this.decorationsPosition;var h=this.overlaysLegendPosition;var c=this.legendInside;var j=this.layoutValid;var d=l?l.toLowerCase():null;var k=d&&m.includes(d);var g=e==="right"||e==="bottom";if(!c){if(!g&&a!=="Network"){this.decorationsPosition="bottom"}if(l&&!k&&a!=="Pie"){this.legendPosition="right";k=true}}if(a==="Pie"&&j){this.legendPosition="right";k=true}if(!h){this.overlaysLegendPosition="topRight"}if(j&&!this.An("legendPosition")){var b=this.meta.config.orig;b.insideLegend=this.insideLegend;this.insideLegend=false;var i=l?l.toLowerCase():null;var f=i&&m.includes(i);if(l&&!f){b.legendPosition=l;this.legendPosition="right"}}};this.qu=function(){if(this.autoScaleFont){var b=this.layoutComb;var a=(1-this.percentAspectRatioPlotArea);var e=b&&this.isDOE?this.layoutWidth:this.width;var d=b&&this.isDOE?this.layoutHeight:this.height;var c=this.XV(e*a,d*a);this.v1(c,"legendTextFont");this.v1(c,"legendTitleFont")}else{this.legendTextFont=this.legendTextFontStyle+" "+parseInt(this.legendTextFontSize)+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+parseInt(this.legendTitleFontSize)+"px "+this.fontName}};this.Jz=function(n,a,k,l,m,b){var c="solid";var h=this.useRoundRectangles?"roundrect":"rectangle";var i=b?this.showDecorationsBorder:this.showLegendBorder;var o=b?this.decorationsBackgroundColor:this.legendBackgroundColor;var d=!i?"rgba(255,255,255,0)":b?this.decorationsBackgroundBorderColor:this.legendBackgroundBorderColor;var g=!i?0:b?this.decorationsBackgroundBorderSize:this.legendBackgroundBorderSize;var j=[0,0,this.width,this.height];var f=n+(k/2)-this.margin;var e=a+(l/2);this.RV();this.Mc({p:["drawShape",h,f,e,k,l,o,d,c,false,g,true,j],i:[-1],m:m,t:"Legends"});this.Ce()};this.bW=function(a,d,b,i,f,h,e){this.Jz(a,d,b,i,h,e);if(f&&this.showLegendTitle){var j=this.Dr(this.legendTitleFont);var g=j/2;var c=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-b/2:b/2;d+=this.legendTitleMargin+g;this.Mc({p:["drawText",f,a+(b/2)+c,d,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"})}};this.qH=function(b,k,d,g,h,c,a,f,j,i,e){return this.Mc({p:["drawShape",d,b,k,g,g,h,c,a,false,f],i:j,g:i,t:"Legends",h:e})};this.CI=function(d,k,f,h,g,e,j,i,c){var b=d-(h/1.1);var a=d+(h/1.1);return this.Mc({p:["drawLine",f,b,k,a,k,g,e],i:j,g:i,t:"Legends",h:c})};this.Z0=function(b,j,e,k,c,d,i,h,a){var g=j-(k/1.1);var f=j+(k/1.1);return this.Mc({p:["drawLine",e,b,g,b,f,c,d],i:i,g:h,t:"Legends",h:a})};this.Pi=function(f,a,h,c,b,g,e,d){return this.Mc({p:["drawText",h,f,a,c,b,"left","middle"],i:g,g:e,t:"Legends",h:d})};this.mE=function(d,q,g,l,k,f,c,j,m,e,p,o,a){var b=this.legendTextMargin;var n=Math.max(l||0,Math.ceil(this.Dr(this.legendTextFont)))+b;var i=Math.ceil(n/2);var h;if(this.isDataLabelsBackgroundColor){h=this.qH(d,q,"rectangle",n,k,this.dataTextColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(p)?p:["legend-key-"+p],o,a)}else{h=this.qH(d,q,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(p)?p:["legend-key-"+p],o,a)}if(!o){o=h}if(this.isDataLabelsBackgroundColor){this.Mc({p:["drawText","a",d,q,this.legendTextFont,this.dataTextColor,"center","middle"],i:this.Hl(p)?p:["legend-letter-"+p],g:o,t:"Legends",h:a})}else{this.Mc({p:["drawText","a",d,q,this.legendTextFont,k,"center","middle"],i:this.Hl(p)?p:["legend-letter-"+p],g:o,t:"Legends",h:a})}this.Pi(d+i+b,q,e,this.legendTextFont,this.legendTextColor,this.Hl(p)?p:["legend-text-"+p],o,a)};this.Zt=function(l,m,q,g,k,a,j,n,c,f,e,h,d){var r=this.legendTextMargin;var p=Math.max(g||0,Math.ceil(this.Dr(this.legendTextFont)))+r;var b=Math.ceil(p/2);var o=Math.ceil(p*0.5);var i=this.qH(l,m,"rectangle",p,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(e)?e:["legend-key-"+e],h,d);if(!h){h=i}this.qH(l,m,q,o,k,a,j,1,this.Hl(e)?e:["legend-shape-"+e],h,d);this.Pi(l+b+r,m,f,this.legendTextFont,this.legendTextColor,this.Hl(e)?e:["legend-text-"+e],h,d)};this.qn=function(m,n,r,j,l,a,k,o,c,g,f,h,e){var s=this.legendTextMargin;var p=Math.ceil(j[0]);var d=j[1];var q=Math.max(d,Math.ceil(this.Dr(this.legendTextFont)))+s;var b=Math.ceil(q/2);var i=this.qH(m,n,"rectangle",q,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(f)?f:["legend-key-"+f],h,e);if(!h){h=i}this.qH(m,n,r,p,l,a,k,1,this.Hl(f)?f:["legend-shape-"+f],h,e);this.Pi(m+b+s,n,g,this.legendTextFont,this.legendTextColor,this.Hl(f)?f:["legend-text-"+f],h,e)};this.Qc=function(p,r,d,k,q,a,m,s,c,h,f,i,e){var u=this.legendTextMargin;var n=k[0];var g=k[1];var t=Math.max(g,Math.ceil(this.Dr(this.legendTextFont)))+u;var b=Math.ceil(t/2);var j=this.qH(p,r,"rectangle",t,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(f)?f:["legend-key-"+f],i,e);if(!i){i=j}var l=parseInt((this.an(n,g,d)/10)+14);var o=" "+l+"px "+this.fontName;this.Mc({p:["drawText","a",p,r,o,this.foreground,"center","middle"],i:this.Hl(f)?f:["legend-letter-"+f],g:i,t:"Legends",h:e});this.Pi(p+b+u,r,h,this.legendTextFont,this.legendTextColor,this.Hl(f)?f:["legend-text-"+f],i,e)};this.Ir=function(m,n,s,g,l,a,k,o,c,f,e,h,d,t){var u=this.legendTextMargin;var r=Math.max(g||0,Math.ceil(this.Dr(this.legendTextFont)))+u;var b=Math.ceil(r/2);var p=Math.ceil(r*0.6);var q=Math.ceil(p*0.5);var j=(isNaN(a)||!a)?1.5:a;var i=this.qH(m,n,"rectangle",r,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(e)?e:["legend-key-"+e],h,d);if(!h){h=i}this.CI(m,n,o,q,c,j,this.Hl(e)?e:["legend-line-"+e],h,d);if(t){this.Z0(m,n,o,q,c,j,this.Hl(e)?e:["legend-line-"+e],h,d)}this.Pi(m+b+u,n,f,this.legendTextFont,this.legendTextColor,this.Hl(e)?e:["legend-text-"+e],h,d)};this.IE=function(m,n,h,g,l,a,k,o,c,f,e,i,d){var s=this.legendTextMargin;var r=Math.max(g||0,Math.ceil(this.Dr(this.legendTextFont)))+s;var b=Math.ceil(r/2);var p=Math.ceil(r*0.6);var q=Math.ceil(p*0.5);var j=this.qH(m,n,"rectangle",r,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(e)?e:["legend-key-"+e],i,d);if(!i){i=j}this.CI(m,n,o,q,c,h,this.Hl(e)?e:["legend-line-"+e],i,d);this.Pi(m+b+s,n,f,this.legendTextFont,this.legendTextColor,this.Hl(e)?e:["legend-text-"+e],i,d)};this.s9=function(m,o,r,h,l,a,k,p,c,g,f,i,e){var s=this.legendTextMargin;var q=Math.max(h||0,Math.ceil(this.Dr(this.legendTextFont)))+s;var b=Math.ceil(q/2);var d=Math.ceil(q*0.3);var n=Math.ceil(b*0.8);var j=this.qH(m,o,"rectangle",q,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(f)?f:["legend-key-"+f],i,e);if(!i){i=j}this.qH(m,o,r,d,l,a,k,1,this.Hl(f)?f:["legend-shape-"+f],i,e);this.CI(m,o,p,n,c,2.5,this.Hl(f)?f:["legend-line-"+f],i,e);this.Pi(m+b+s,o,g,this.legendTextFont,this.legendTextColor,this.Hl(f)?f:["legend-text-"+f],i,e)};this.ek=function(o,q,v,j,e,b,p,r,d,h,g,k,f){var x=this.legendTextMargin;var t=Math.max(j||0,Math.ceil(this.Dr(this.legendTextFont)))+x;var c=Math.ceil(t/2);var m=Math.ceil(t*0.75);var i=Math.ceil(t*0.4);var s=Math.ceil(m*0.6);var a=Math.ceil(m*0.5);var u=p||"solid";var w=this.plotStyle=="ggplotSwitched"?e:b;var n=this.plotStyle=="ggplotSwitched"?b:e;var l=this.qH(o,q,"rectangle",t,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(g)?g:["legend-key-"+g],k,f);if(!k){k=l}this.Mc({p:["drawLine",u,o,q-s,o,q+s,w,1],i:this.Hl(g)?g:["legend-vline-"+g],g:k,t:"Legends",h:f});this.Mc({p:["drawShape","rectangle",o,q,m,i,n,w,p,false,1],i:this.Hl(g)?g:["legend-shape-"+g],g:k,t:"Legends",h:f});this.CI(o,q,u,a*1.1,w,1,this.Hl(g)?g:["legend-hline-"+g],k,f);this.Pi(o+c+x,q,h,this.legendTextFont,this.legendTextColor,this.Hl(g)?g:["legend-text-"+g],k,f)};this.Pt=function(n,p,t,i,k,b,e,q,o,g,f,j,c){var u=this.legendTextMargin;var r=Math.max(i||0,Math.ceil(this.Dr(this.legendTextFont)))+u;var a=Math.ceil(r/2);var h=Math.ceil(r*0.75);var m=Math.ceil(h*0.35);var d=this.eN(k,0.5);var s=e||"solid";var l=this.qH(n,p,"rectangle",r,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(f)?f:["legend-key-"+f],j,c);if(!j){j=l}this.qH(n,p,"rectangle",h,d,d,e,1,this.Hl(f)?f:["legend-shape-"+f],j,c);if(this.isKM){b=this.Y3(b);this.CI(n,p,q,m,b,1.5,this.Hl(f)?f:["legend-line-"+f],j,c);this.Z0(n,p,q,m,b,1.5,this.Hl(f)?f:["legend-line-"+f],j,c)}else{if(this.showScatterLineOriginalData){this.qH(n,p,t,m,k,b,e,1,this.Hl(f)?f:["legend-shape-"+f],j,c)}this.CI(n,p,q,m,b,1.5,this.Hl(f)?f:["legend-line-"+f],j,c)}this.Pi(n+a+u,p,g,this.legendTextFont,this.legendTextColor,this.Hl(f)?f:["legend-text-"+f],j,c)};this.yW=function(v,x,B,m,u,b,f,y,k,l,i,n,g){var C=this.legendTextMargin;var z=Math.max(m||0,Math.ceil(this.Dr(this.legendTextFont)))+C;var a=Math.ceil(z/2);var s=Math.ceil(z*0.75);var w=Math.ceil(s*0.5);var t=Math.ceil(z*0.3);var c=t*0.7;var A=f||"solid";var o=this.HA();var p=this.qH(v,x,"rectangle",z,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.Hl(i)?i:["legend-key-"+i],n,g);if(!n){n=p}var e,r,d,q,j,h;if(o){e=v;r=x-w;d=v;q=x+w;j=v;h=x-c}else{e=v-w;r=x;d=v+w;q=x;j=v+w-(t*0.3);h=x}this.Mc({p:["drawLine",A,e,r,d,q,b,1.5],i:this.Hl(i)?i:["legend-line-"+i],g:n,t:"Legends",h:g});this.Mc({p:["drawShape","circle",j,h,t,t,u,b,f,false,1],i:this.Hl(i)?i:["legend-shape-"+i],g:n,t:"Legends",h:g});this.Pi(v+a+C,x,l,this.legendTextFont,this.legendTextColor,this.Hl(i)?i:["legend-text-"+i],n,g)};this.Hr=function(e,q,h,l,b,g,d,k,m,f,p,o,a){var c=this.legendTextMargin;var n=Math.max(l||0,Math.ceil(this.Dr(this.legendTextFont)))+c;var j=Math.ceil(n/2);var i=this.qH(e,q,"rectangle",n,b,g,d,1,this.Hl(p)?p:["legend-shape-"+p],o,a);if(!o){o=i}this.Pi(e+j+c,q,f,this.legendTextFont,this.legendTextColor,this.Hl(p)?p:["legend-text-"+p],o,a)};this.d7=function(){var d=Math.min(this.width,this.height);var a=this.isCxplot?25:25;var c=d*a/833;var e=Number(Math.max(0.5,c).toFixed(1))*this.legendTextScaleFontFactor;var b=Number(Math.max(0.5,d*this.legendKeySize/833).toFixed(1));return Math.max(b,e)};this.EQ=function(f){var p=this.legend;var a=this.legendTitleMargin;var g=this.legendTextMargin;var c=f.text.length;var j=this.d7();var l=f.size;if(l){for(var e=0;e<l.length;e++){if(l[e]){j=Math.max(j,l[e])}}}var o=this.r9(f.title&&this.showLegendTitle?f.title:"",this.legendTitleFont)+(a*2);var b=this.r9(this.tx(f.text),this.legendTextFont);var n=this.Dr(this.legendTextFont);var h=this.Dr(this.legendTitleFont);var r=this.legendColumns>c?c:this.legendColumns;var d=Math.ceil(c/r);var q=Math.max(o,((b+j+(g*2))*r)+(g*2))+this.margin;var k=(d*(Math.max(j,n)+g))+g;var m=f.title&&this.showLegendTitle?k+h+(a*2):k;if(!p[f.id]){p[f.id]={}}p[f.id].columns=r;p[f.id].meta=f;p[f.id].width=q;p[f.id].height=m};this.xO=function(t,q,u,x){var k=this;var b=this.legend;var a=function(D){var C=k.meta.ggplot;var i=D+"LegendTitle";if(C&&C.labels&&C.labels[i]){return C.labels[i]}else{return k[D+"By"]}};var p=x||0;var s=3;if(p>s){return}var d=this.RI(t)+"By";var y=this["show"+this.Cv(t)+"Legend"]||this.graphType==="Network";var c=t==="sample";var l=this.legendStyleGgplot?false:t.match(/size/i)&&!this.sizeByContinuous;if((this[d]&&y)||c){if(this.legendCombine&&this.legendCombine.indexOf(d)>0){return}var A,z,h;var w=this.meta.data;if(q){A=a(t);if(u.type==="Numeric"&&t.match(/shape/i)&&!this.shapeByContinuous||l){z=" "+q+" - "+q+" ";if(u){u.maxLevStrMod=z;u.isRange=true}}else{z=q}h=u.sizes?u.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[d])){A=a(t);z=w.x[this[d]].maxLevStrMod||w.x[this[d]].maxLevStr;h=w.x[this[d]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[d])){A=a(t);z=w.z[this[d]].maxLevStrMod||w.z[this[d]].maxLevStr;h=w.z[this[d]].sizes||this.sizes}else{if(d.match("Node")){A=this[d];z=w.nodes[this[d]].maxLevStr;h=w.nodes[this[d]].sizes||this.sizes}else{if(d.match("Edge")){A=this[d];z=w.edges[this[d]].maxLevStr;h=w.edges[this[d]].sizes||this.sizes}else{A=0;z=0;h=this.sizes}}}}}var f=this.d7();if(t==="size"||t==="sizeNode"||t==="sizeLabel"){for(var v=0;v<b[t].n;v++){if(h[v]){f=Math.max(f,h[v])}}}else{if(t==="sample"){A=0;z=this.legend.sample.maxStr}}if(z.length>this.maxTextSize){z=z.substring(0,this.maxTextSize-3)+"..."}var r=this.Dr(this.legendTextFont);var n=this.Dr(this.legendTitleFont);var e=this.legendColumns;var o=b[(t==="outline"?"color":t)].n;var m=e>o?o:e;var g=Math.ceil(o/m);var j=this.showLegendTitle?this.r9(A,this.legendTitleFont):0;var B=((this.r9(String(z),this.legendTextFont)+Math.max(f,r)+this.legendTextMargin*3)*m)+(this.legendTextMargin*2)+this.margin;b[(t==="outline"?"color":t)].columns=m;b[(t==="outline"?"color":t)].width=Math.max(j,B);b[(t==="outline"?"color":t)].height=(g*(Math.max(f,r)+this.legendTextMargin))+this.legendTextMargin+(c?0:(this.showLegendTitle?n+this.legendTitleMargin:0));if(this.graphType==="Map"&&this.mapProjection==="orthographic"){b[(t==="outline"?"color":t)].width=0;b[(t==="outline"?"color":t)].height=0}else{if(b[(t==="outline"?"color":t)].height>this.height){this.legendColumns++;b[(t==="outline"?"color":t)].columns++;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.xO(t,q,u,p+1)}else{if(b[(t==="outline"?"color":t)].width>this.width&&b[(t==="outline"?"color":t)].columns>1){this.legendColumns--;b[(t==="outline"?"color":t)].columns--;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.xO(t,q,u,p+1)}}}}};this.Ac=function(i,b){var g=this.legend;var a=this.RI(i)+"By";var j=0;var h=0;var f=this.Dr(this.legendTextFont);var e=this.Dr(this.legendTitleFont);if(this[a]||i=="decoration"||i=="contour"||i=="bin2d"){switch(i){case"color":case"colorNode":case"colorEdge":case"outline":case"decoration":case"contour":case"bin2d":var d=this.showLegendTitle?this.r9(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendTitleFont):0;var c=b.maxLevLen+(this.legendTextMargin*3);if(this.legendPosition.match(/top|bottom/)&&this.graphType!="Scatter2D"){h=(this.showLegendTitle?(e+(this.legendTitleMargin*2)):0)+this.heatmapIndicatorHeight+(this.legendTextMargin*2);j=this.heatmapIndicatorWidth+Math.max(d,c*2)}else{h=this.heatmapIndicatorWidth+(this.legendTextMargin*2)+(this.showLegendTitle?e+(this.legendTitleMargin*2):0);j=Math.max((this.heatmapIndicatorHeight+c+(this.legendTextMargin*3)),d)}break;case"shape":case"shapeNode":case"shapeEdge":case"size":case"sizeNode":case"sizeEdge":this.xO(i,b.maxLevStr,b);return;case"pattern":case"patternNode":case"patternEdge":j=0;h=0;break}}g[(i=="outline"?"color":i)].width=j;g[(i=="outline"?"color":i)].height=h};this.Cr=function(){var h=this.legend.decoration;var v=this.decorations;h.width=0;h.height=0;h.maxLabel=0;h.columns=this.legendColumns;if(this.showDecorations&&this.showDecorationsLegend&&v){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var e=this.Dr(this.decorationsTextFont);var d=["nlfit","reg","nor","area"];var b=[96,45,30,0,0,0,0];var p=[5,2,1,0,0,0,0];var c=0;for(var r=0;r<d.length;r++){var f=d[r];if(v[f]){var u=p[r];var n=b[r];var g=u?this.r9(this.DF("%"+n+"s","X"),this.decorationsTextFont)+(this.decorationsTextMargin*u)+this.decorationsTextMargin:0;var t=0;for(var o=0;o<v[f].length;o++){var k=v[f][o];var l=this.r9(k.label,this.decorationsTextFont);t=Math.max(l,t);h.maxLabel=Math.max(t,h.maxLabel)}c=Math.max(c,this.decorationsTextMargin+t+this.decorationsTextMargin+g);h.height=(v[f].length*(e+this.decorationsTextMargin))+e+this.decorationsTextMargin}}if(this.graphType=="Map"&&v&&v.pie&&v.pie[0]&&v.pie[0].smps&&v.pie[0].smps.length){var m=0;var a=this.Dr(this.decorationsTextFont);for(var r=0;r<v.pie[0].smps.length;r++){var s=v.pie[0].smps[r];var q=this.r9(s,this.decorationsTextFont);m=Math.max(q,m);h.maxLabel=Math.max(m,h.maxLabel)}c=Math.max(c,(m+(this.decorationsTextMargin*3)+(a*2))*Math.min(v.pie[0].smps.length,h.columns));h.height+=(Math.ceil(v.pie[0].smps.length/Math.min(v.pie[0].smps.length,h.columns))*a*1.5)+(this.decorationsTextMargin*2)}h.width=c}};this.K9=function(){var b=this.legend.oncoprint;b.width=0;b.height=0;b.colors={};if(this.isOncoprint){var m=this.Ev(this.meta.data[this.oncoprintCNA].levels);var c=this.Ev(this.meta.data[this.oncoprintCNA].colors);var j=[];m.push("No Alteration");c.push("rgb(220,220,220");for(var f=0;f<m.length;f++){j.push("CNA")}var k=m.length;if(this.oncoprintMUT){m=m.concat(this.Ev(this.meta.data[this.oncoprintMUT].levels));c=c.concat(this.Ev(this.meta.data[this.oncoprintMUT].colors));for(var f=k;f<m.length;f++){j.push("MUT")}}var g=[];var n=[];for(var f=0;f<m.length;f++){if(m[f]){g.push(m[f]);n.push(j[f]);b.colors[m[f]]=c[f];if(c[f]=="rgb(220,220,220"){this.legend.oncoprintMutations=g.length}}}var e=this.tx(g,this.legendTextFont);var a=this.r9(e,this.legendTextFont);var h=Math.ceil(a+5+(this.margin*8));var l=Math.floor(this.width/h);var d=Math.ceil(g.length/l);b.width=h*l;b.height=((21+this.margin)*d)+this.margin;b.rows=d;b.cols=l;b.labels=g;b.objects=n}};this.Gy=function(f,d,c){var g;var b=f.s?f.s.density:false;var e=this.smpIndices;var a=this.maxSmpStringLen;if((b.hasOwnProperty("Samples")&&!this.segregateSamplesBy.length)||this.segregateVariablesBy.length){c.maxStr=this.uM(f.y.maxSmpStr,a);g=e.length}else{if(f.z&&f.z[d]){c.maxStr=this.uM(f.z[d].maxLevStr,a);g=b.layout[0].length}else{c.maxStr=this.uM(f.y.maxSmpStr,a);g=e.length}}return g};this.IZ=function(g,f,e,a){var j;var c=g.s?g.s.density:false;var d=this.maxSmpStringLen;if(c.hasOwnProperty("Factor")){var h=this.iH(c.Factor);if(f&&f!==true){h.push(f);if(this.colorLegendTitle){e.title=f}a++}if(this.smpIndices.length==1){e.maxStr=this.uM(this.tx(h),d)}else{h=[];for(var b=0;b<c.Global.sets.length;b++){h.push(c.Global.sets[b].name.replace(/^Factor:/,""))}e.maxStr=this.uM(this.tx(h),d)}j=h.length-a}else{if(c.hasOwnProperty("Samples")){e.maxStr=this.uM(g.y.maxSmpStr,d);j=this.smpIndices.length}else{if(c.hasOwnProperty("Variables")){e.maxStr=this.uM(g.y.maxVarStr,d);j=this.varIndices.length}}}return j};this.lI=function(){var a=this.legend.sample;var k=this.meta.data;var r=this.xAxisIndices;var w=this.yAxisIndices;var p=this.showHistogram;var d=this.maxSmpStringLen;a.width=0;a.height=0;a.columns=this.legendColumns;a.maxStr="";a.maxStrLen=0;a.title=false;a.n=1;var n=this.d7();var l=Math.max(n,this.Dr(this.legendTextFont));var o=this.Dr(this.legendTitleFont);var f=k.s?k.s.density:false;var s=0;var e=0;var t=0;var g=(this.ridgeBy&&this.data.y.smps.length===1);var y=(p&&this.histogramAsDotplot);var v=(this.colorBy&&k.x&&k.x.hasOwnProperty(this.colorBy)&&((r&&r.length===1)||(w&&w.length===1)));var x=(this.scatterType==="bin2d");if(g||y||v||x){return}if(this.th()){var c=this.data.y.smps;e=this.ridgeBy?c.length:Math.max(r.length,w.length);if(this.ridgeBy){s=this.r9(this.uM(this.tx(c),d),this.legendTextFont)}else{if(p&&f){if(this.c1()){e=this.Gy(k,p,a)}else{e=this.IZ(k,p,a,t)}if(!this.colorBy||e>1){s=this.r9(a.maxStr,this.legendTextFont)}}else{if(r.length!==w.length||r.length>1){if(r.length===w.length&&r.length>1){for(var q=0;q<r.length;q++){var h=this.uM(this.xAxis[q],d);var m=this.uM(this.yAxis[q],d);var j=h+" vs "+m;var u=this.r9(j,this.legendTextFont);if(u>s){a.maxStr=j;s=u}}}else{var b="";if(r.length>w.length){b=this.tx(this.xAxis);a.maxStr=(w.length===1)?this.uM(b,d):this.uM(b,d)+" vs "+this.uM(this.yAxis[0],d)}else{if(w.length>r.length){b=this.tx(this.yAxis);a.maxStr=(r.length===1)?this.uM(b,d):this.uM(b,d)+" vs "+this.uM(this.xAxis[0],d)}}s=this.r9(a.maxStr,this.legendTextFont)}}}}if(s){a.n=e;a.maxStrLen=s;a.width=((l+s+(this.legendTextMargin*2))*(a.columns>e?e:a.columns))+(this.legendTextMargin*2);a.height=(Math.ceil(e/a.columns)*(l+this.legendTextMargin))+this.legendTextMargin+(((o+this.legendTitleMargin)*(this.colorLegendTitle?1:0))*t)}}};this.re=function(){if(this.circularType&&this.circularType.match(/normal/)){if(this.ringGraphType&&this.ringGraphType.length){for(var a=0;a<this.ringGraphType.length;a++){if(this.ringGraphType[a]!=="heatmap"){return true}}return false}}else{if(this.circularType&&this.circularType.match(/radar/)&&this.yAxis.length){return false}}return true};this.Du=function(e,b,r){var s=0;var k=0;var h=this.varIndices;var t;if(this.graphType==="Fish"){t=this.Dr(this.legendTextFont);var c=h?h.length:0;var g=this.uM(e.maxVarStr,this.maxVarStringLen);s=((b+(this.legendTextMargin*2)+this.r9(g,this.legendTextFont))*r)+(this.legendTextMargin*2);k=(Math.ceil(c/Math.min(c,r||1))*(t+this.legendTextMargin))+(this.legendTextMargin*2)}else{if(this.graphType==="Pie"){var a=h||[];var c=a.length>this.maxPieSectors?this.maxPieSectors:a.length;var g=this.isDOE&&this.layoutCurrentDOE?this.uM(e.maxLevStr,this.maxVarStringLen):this.uM(this.isPie&&this.isPie!==true?e.maxLevStr:e.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<(h?h.length:0)&&g.length<5){g=this.uM("Other",this.maxVarStringLen)}var f=this.r9(g,this.legendTextFont)+b+(this.legendTextMargin*3);var o=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var j=(1-this.percentAspectRatioPlotArea);s=f>o*j?o*j:this.r9(g,this.legendTextFont)+b+(this.legendTextMargin*5);k=((b+this.legendTextMargin)*c)+(this.legendTextMargin*2)}else{if(this.layoutValid&&this.segregateVariablesBy&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]==="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]==="variable")){return null}else{if(!this.colorBy||(this.colorBy&&this.colorBy==="variable")){t=e.maxVarChr>this.maxVarStringLen?e.maxVarStr.substring(0,this.maxVarStringLen):e.maxVarStr;var c=h?h.length:0;s=((b+(this.legendTextMargin*2)+this.r9(t,this.legendTextFont))*r)+(this.legendTextMargin*2);k=(Math.ceil((h?h.length:0)/Math.min(c,r||1))*(b+this.legendTextMargin))+this.legendTextMargin}else{return null}}}else{if((this.colorBy&&this.colorBy==="variable")||(this.shapeBy&&this.shapeBy==="variable")||(this.sizeBy&&this.sizeBy==="variable")||(this.patternBy&&this.patternBy==="variable")){t=this.sizeBy&&this.sizeBy==="variable"&&this.sizes&&h?Math.max(this.sizes[h.length-1],this.Dr(this.legendTextFont)):this.Dr(this.legendTextFont);var c=h?h.length:0;var g=this.uM(e.maxVarStr,this.maxVarStringLen);s=t+this.r9(g,this.legendTextFont)+((this.legendTextMargin*2)*Math.min(c,r||1))+(this.legendTextMargin*2);k=(Math.ceil(c/Math.min(c,r||1))*(t+this.legendTextMargin))+(this.legendTextMargin*2)}else{if(!this.colorBy&&(this.graphType==="BarLine"||this.graphType==="DotLine"||this.graphType==="AreaLine"||this.graphType==="StackedLine"||this.graphType==="StackedPercentLine")){t=e.maxVarChr>this.maxVarStringLen&&e.maxVarStr?e.maxVarStr.substring(0,this.maxVarStringLen):e.maxVarStr;var c=(this.xAxisVarIndices?this.xAxisVarIndices.length:0)+(this.xAxis2VarIndices?this.xAxis2VarIndices.length:0);s=((b+(this.legendTextMargin*2)+this.r9(t,this.legendTextFont))*r)+(this.legendTextMargin*2);k=(Math.ceil(c/Math.min(c,r||1))*(b+this.legendTextMargin))+this.legendTextMargin}else{if(!this.colorBy&&(this.graphType==="Bar"||(this.graphType==="Line"&&!this.lineBy)||this.graphType==="Area"||this.graphType==="Dotplot"||this.graphType==="Stacked"||this.graphType==="StackedPercent"||this.graphType==="Boxplot")){t=e.maxVarChr>this.maxVarStringLen&&e.maxVarStr?e.maxVarStr.substring(0,this.maxVarStringLen):e.maxVarStr;var c=h?h.length:0;s=((b+(this.legendTextMargin*2)+this.r9(t,this.legendTextFont))*r)+(this.legendTextMargin*2);k=(Math.ceil((h?h.length:0)/Math.min(c,r||1))*(b+this.legendTextMargin))+this.legendTextMargin}else{if(this.graphType==="Circular"){if(!this.showIdeogram&&this.re()){t=e.maxVarChr>this.maxVarStringLen&&e.maxVarStr?e.maxVarStr.substring(0,this.maxVarStringLen):e.maxVarStr;var i=this.rAxisIndex>=0&&h?h.length-1:(h?h.length:0);s=((b+(this.legendTextMargin*2)+this.r9(t,this.legendTextFont))*r)+(this.legendTextMargin*2);k=(Math.ceil(i/Math.min(i,r||1))*(b+this.legendTextMargin))+this.legendTextMargin}else{return null}}}}}}}}return{width:s,height:k}};this.w8=function(a){if(this.data&&this.data.y&&this.data.y.unpivoted&&this.data.y.unpivoted.factor){var b=this.r9(this.uM(this.colorLegendTitle||this.data.y.unpivoted.factor,this.maxVarStringLen),this.legendTitleFont)+this.margin;var c=this.Dr(this.legendTitleFont)+this.legendTitleMargin;this.legend.variable.width=Math.max(this.legend.variable.width,b);this.legend.variable.height+=c}};this.n9=function(){if(this.legend.variable.height>this.height&&this.varIndices&&this.varIndices.length>0){this.legend.variable.columns++;this.maxVarStringLen=Math.max(1,this.maxVarStringLen-5);this.Fj(this.legend.variable.columns)}};this.R4=function(){if(this.isDOE&&this.layoutCurrentDOE){if(this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.layoutCurrentDOE)){return this.meta.data.x[this.layoutCurrentDOE]}if(this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.layoutCurrentDOE)){return this.meta.data.z[this.layoutCurrentDOE]}}if(this.isPie&&this.isPie!==true){if(this.meta.data.z&&this.meta.data.z[this.isPie]){return this.meta.data.z[this.isPie]}if(this.meta.data.x&&this.meta.data.x[this.isPie]){return this.meta.data.x[this.isPie]}}return this.meta.data.y};this.Fj=function(d){var g=this.legend.variable;var c=this.varIndices||0;var e=this.legendMax;if(!this.showLegend){return}g.width=0;g.height=0;g.columns=d||(c&&this.legendColumns>c.length?c.length:this.legendColumns);var h=g.columns;if(!this.showVariableLegend||c.length>e){return}var b=this.R4();var i=this.d7();var a=Math.max(i,this.Dr(this.legendTextFont));var f=this.Du(b,a,h);if(f){g.width=f.width;g.height=f.height}this.w8(b);if(h<8){this.n9()}};this.mI=function(){var b=this.legend;var a=this.data.venn.legend?this.tx(this.data.venn.legend):"N/A";b.width=this.r9(a,this.legendTextFont)+(this.margin*6);b.height=this.margin+this.margin+((this.Dr(this.legendTextFont)+this.margin)*this.vennGroups)};this.Or=function(){var c=this.legend.overlays;c.layout=[];c.width=0;c.height=0;var s=this.margin;var q=this.margin;var t=0;var n=0;var B=0;var p=false;var w=this.Dr(this.legendTextFont)+2;var f=this.d7();var b=Math.max(w,f);var h=["varOverlays","smpOverlays"];var m=["varOverlayProperties","smpOverlayProperties"];var d=["showVarOverlaysLegend","showSmpOverlaysLegend"];if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)&&this.graphType!=="Circular"){for(var y=0;y<h.length;y++){var v=this[h[y]];var l=this[d[y]];if(v.length>0&&l){for(var x=0;x<v.length;x++){var A=v[x];if(A!=="-"){var z=h[y]==="varOverlays"?"z":"x";var o=this.meta.data[z][A];var u=this.r9(o.maxLevStr,this.legendTextFont);var k=this.r9(A,this.legendTitleFont);var e=this[m[y]][A].legendColumns||this[h[y]+"LegendColumns"];if(this.graphType==="Circular"||(this[m[y]][A]&&this[m[y]][A].showLegend)){p=true;var g=0;var r=0;var a=this[m[y]][A].type;if(a==="Default"){if(o.type==="String"){g=Math.max(k,u+b+(this.margin*3))*e;r=((Math.max(w,f)+this.margin)*Math.ceil(o.levels.length/e))+w+this.margin}else{if(this.overlaysLegendPosition.match(/right/i)){g=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,k);r=this.heatmapIndicatorWidth+(this.margin*3)+w}else{g=this.heatmapIndicatorWidth+(this.margin*3)+w;r=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,k)}}}else{if(a&&a.match(/Area|Bar|Dotplot|Line|Stacked|Pie|Treemap/)){g=Math.max(w,f)+k+(this.margin*2);r=Math.max(w,f)+this.margin}else{continue}}if(!c[A]){c[A]={}}c[A].width=g;c[A].height=r;var C=c.layout;if(this.overlaysLegendPosition.match(/right/i)){if(n+this.margin+r>(this.height-(this.top+this.bottom))){s+=this.margin+g;t=g;n=r;if(C[B]){B++}C[B]=[[z,A,g,r]]}else{if(g>t){s+=(g-t);t=g}n+=r;if(!C[B]){C[B]=[]}C[B].push([z,A,g,r])}}else{if(t+this.margin+g>(this.width-(this.left+this.right))){q+=this.margin+r;t=g;n=r;if(C[B]){B++}C[B]=[[z,A,g,r]]}else{if(r>n){q+=(r-n);n=r}t+=g;if(!C[B]){C[B]=[]}C[B].push([z,A,g,r])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){c.width=p?s+(this.margin*3):0;c.height=p?n+this.margin:0}else{c.width=p?t+this.margin:0;c.height=p?q+this.margin:0}};this.LX=function(){var a=this.legend;var m=this.margin;var f=this.decorations;if(this.showDecorations&&this.showDecorationsLegend&&f){this.decorationLayout=[0]}if(this.showLegend){a.layout=[];a.width=0;a.height=0;var h=m;var c=m;var p=0;var j=0;var r=0;var s=a.layout;var o=this.graphType==="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","overlays","sample","contour","bin2d","colorLabel","sizeLabel"];for(var q=0;q<o.length;q++){var t=o[q];var b=t==="decoration"&&!this.showDecorations;var k=t==="size"&&this.graphType==="Map"&&f&&f.pie;var g="show"+this.Cv(t)+"Legend";var u=this.graphType==="Network"&&t!=="decoration"&&!this[g];var d=this.YR()&&t==="variable";if(b||k||u||d){continue}var l=a[t].width;var e=a[t].height;if(l<=0||isNaN(l)){continue}if(this.legendPosition.match(/right|left/i)){if(j+m+e>this.height){h+=m+l;p=l;j=e;r++;s[r]=[t]}else{if(l>p){h+=(l-p);p=l}j+=e;s[r]=s[r]||[];s[r].push(t)}}else{if(p+m+l>this.width){c+=m+e;p=l;j=e;r++;s[r]=[t]}else{if(e>j){c+=(e-j);j=e}p+=l;s[r]=s[r]||[];s[r].push(t)}}}for(var q=0;q<this.customLegend.length;q++){var n=this.customLegend[q];n.id="custom"+q;this.EQ(n);var l=a[n.id].width;var e=a[n.id].height;if(this.legendPosition.match(/right|left/i)){if(j+m+e>this.height){h+=m+l;p=l;j=e;r++;s[r]=[n.id]}else{if(l>p){h+=(l-p);p=l}j+=e;s[r]=s[r]||[];s[r].push(n.id)}}else{if(p+m+l>this.width){c+=m+e;p=l;j=e;r++;s[r]=[n.id]}else{if(e>j){c+=(e-j);j=e}p+=l;s[r]=s[r]||[];s[r].push(n.id)}}}a.width=p===0&&h===m?0:this.legendPosition.match(/right|left/i)?h+m:p+m;a.height=j===0&&c===m?0:this.legendPosition.match(/right|left/i)?j+m:c+m}};this.lT=function(f,d,l){var j=this;var k=this.legend;var e=function(i){if(j.meta.ggplot&&j.meta.ggplot.labels&&j.meta.ggplot.labels[i+"LegendTitle"]){return j.meta.ggplot.labels[i+"LegendTitle"]}else{return j[i+"By"]}};var a=d=="outline"?"color":d;var h=(this.RI(a)+"s").replace("Node","").replace("Edge","").replace("Label","").replace("decorations","colors");var c=k[a];delete (c.levels);c.meta=f;c.meta.title=e(a);if(l){if(this.colorSpectrumBreaks.length){c.meta.vals=this.colorSpectrumBreaks}else{var b=this.O3(l[0],l[1],5);for(var g=0;g<b.length;g++){b[g]=String(b[g]).length>5?b[g].toExponential():b[g]}c.meta.vals=b}c.meta.decs=this.wN(l[1]-l[0]);c.meta.maxLevStr=this.tx(k[(d=="outline"?"color":d)].meta.vals);c.meta.maxLevLen=this.r9(c.meta.maxLevStr,this.font);c.meta.maxLevChr=c.meta.maxLevStr.toString().length}else{var b=this.O3(f.min,f.max,5);for(var g=0;g<b.length;g++){b[g]=String(b[g]).length>5?b[g].toExponential():b[g]}if((d=="size"&&!this.sizeByContinuous)&&this.legendStyleGgplot){b.pop()}c.meta.vals=b;c.meta.maxLevStr=this.tx(b);c.meta.maxLevLen=this.r9(c.meta.maxLevStr,this.xAxisTextFont);c.meta.maxLevChr=c.meta.maxLevStr.toString().length}if(this.ridgeBy&&this.colorBy=="data"){c.meta.min=c.meta.vals[0];c.meta.max=c.meta.vals[c.meta.vals.length-1]}c.max=c.meta.maxLevStr;c.n=c.meta.vals.length;if(!c.m){c.m=[]}for(var g=0;g<c.meta.vals.length;g++){c.m[c.meta.vals[g].toString()]=a=="connect"?this.colors[g]:a=="contour"?this.b3(f,c.meta.vals[g]):a=="bin2d"?this.b3(f,c.meta.vals[g]):this[h][g%this[h].length]}this.Ac(d,c.meta)};this.gC=function(n,s,k,q,t){var e=this.varIndices;if(n){var v=0;var u=0;var m=false;var d={};var l={};var f=n[this.RI(q).replace("Node","").replace("Edge","").replace("Label","")+"s"]||this[this.RI(q).replace("Node","").replace("Edge","").replace("Label","")+"s"];if(s=="x"){var g;if(this.graphType=="Scatter2D"){g=this.xAxisIndices.length==1?this.yAxisIndices:this.yAxisIndices.length==1?this.xAxisIndices:this.smpIndices}else{g=this.isGroupedData?this.grpIndices:this.smpIndices}for(var r=0;r<g.length;r++){var b=g[r];if(this.isGroupedData&&(this.graphType=="Dotplot"||this.graphType=="Boxplot"||this.barType=="swimmer"||this.graphType=="Gantt"||this.stackBy||this.lineBy||this.dodgeBy)){this.isGroupedData=false;for(var p=0;p<this.data.w.grps[b].length;p++){var a=this.mU(this.data.w.grps[b][p],s,this[k]);l[a]=true}this.isGroupedData=true}else{var a;if(this.isGroupedData){this.isGroupedData=false;a=this.FP(this[k],this.data.w.grps[r],true);this.isGroupedData=true}else{a=this.mU(b,s,this[k])}l[a]=true}}}else{if(s=="z"){if((this.graphType=="Map"&&e.length<n.levels.length)||this.histogramAsDotplot){for(var r=0;r<n.levels.length;r++){var a=n.levels[r];l[a]=true}}else{for(var r=0;r<e.length;r++){var b=e[r];var a=this.mU(b,s,this[k]);l[a]=true}}}else{if(s=="m"){for(var r=0;r<e.length;r++){for(var p=0;p<this.smpIndices.length;p++){var a=t[e[r]][this.smpIndices[p]];l[a]=true}}}else{if(s=="modified"){n.order={};for(var r=0;r<n.levels.length;r++){l[n.levels[r]]=true;n.order[n.levels[r]]=r}}else{if(s=="nodes"||s=="edges"){n.order={};for(var r=0;r<n.levels.length;r++){l[n.levels[r]]=true;n.order[n.levels[r]]=r}}}}}}l=this.iH(l);if(n.type=="Numeric"){if(n.orderS){l.sort(function(j,i){return n.orderS[j]-n.orderS[i]})}else{l.sort(function(j,i){return j-i});n.orderS={};for(var r=0;r<l.length;r++){n.orderS[l[r]]=r}}}else{l.sort(function(j,i){return n.order[j]-n.order[i]})}var h=f?f.length:1;var c=this.legend[q];for(var r=0;r<l.length;r++){var a=l[r]!=null?l[r]:"NA";var o=this.r9(a,this.legendTextFont);if(o>v){v=o;c.max=a}d[a]=(n.type=="Numeric"?n.orderS[a]:n.order[a])%h;c.m[a]=f?f[d[a]]:r;u++}c.levels=l;m=s=="m"||s=="modified"?c.max:false;c.n=u;c.meta=n;this.xO(q,m,n)}};this.mc=function(){var e=this.legend;var h=this.meta.data;var f=["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"];for(var d=0;d<f.length;d++){var b=f[d];var g=this.RI(b);var a=g+"By";e[b]={m:{},n:0,width:0,height:0};if(this[a]){var c=h[b.match("Node")?"nodes":"edges"][this[a]];if(c.type==="Numeric"){this.lT(c,b)}else{this.gC(c,b.match("Node")?"nodes":"edges",a,b)}}}if(this.decorations.length&&this.decorationsType==="heatmap"&&h.decorations.n&&this.showDecorations){var c=h.decorations;var b="decoration";e[b]={m:{},n:0,width:0,height:0};this.lT(c,b)}};this.QF=function(){var a=this.legend;var c=this.meta.data;var g=["colorByData","shapeByData","sizeByData","patternByData","outlineByData"];for(var f=0;f<g.length;f++){var k=g[f];if(this.data.y[this[k]]){var d=this.data.y[this[k]];var h=c[this[k]];var e=k.replace("ByData","");var b=this.RI(e);var j=b+"By";e=e;a[e].m=[];a[e].n=0;if(h.type==="Numeric"){this.lT(h,e)}else{this.gC(h,"m",j,e,d)}}}};this.AI=function(){var a=this.legend;var c=this.meta.data;var e=["color","shape","size","line","pattern","outline","connect","contour","bin2d","colorLabel","sizeLabel"];for(var g=0;g<e.length;g++){var f=e[g];var d=this.RI(f);var m=d+"By";a[f]={m:{},n:0,width:0,height:0}}if(!c.b.g){var h=this.xAxisIndices[this.xAxisCurrent];var n=this.yAxisIndices[this.yAxisCurrent];var b=this.Q8(h,"x");var k=this.Q8(n,"y");var j=this.Em(b,k);c.b.g=j;c.b.c=j.brew}var f="bin2d";var l=c.b.c;this.lT(l,f)};this.K7=function(){var d=this.legend;var e=this.meta.data;if(this.showHistogram!==true){if(this.segregateVariablesBy.length>0&&this.segregateVariablesBy[0]!==this.showHistogram){var b=this.colorBy;this.colorBy=this.showHistogram;var a="color";var c=e.z[this.showHistogram];d[a]={m:{},n:0,width:0,height:0};this.gC(c,"z","colorBy",a);this.colorBy=b}}else{if(this.histogramAsDotplot&&this.colorBy){var a="color";var c=e.x[this.colorBy];d[a]={m:{},n:0,width:0,height:0};if(c.type==="Numeric"){this.lT(c,a)}else{this.gC(c,"x","colorBy",a)}}}};this.pq=function(){var e=this.legend;var h=this.meta.data;var f=["color","shape","size","line","pattern","outline","connect","contour","bin2d","colorLabel","sizeLabel"];for(var d=0;d<f.length;d++){var b=f[d];var g=this.RI(b);var a=g+"By";e[b]={m:{},n:0,width:0,height:0}}if(!h.q.g.length||!h.q.g[0]||!h.q.g[0].data){this.M1(this.isContour,true)}var b="contour";var c=h.q.g[0].data.colorBrew;this.lT(c,b)};this.rB=function(l){var a=this.legend;var c=this.meta.data;var h=["color","shape","size","pattern","outline"];var f=["color","shape","size","line","pattern","outline","connect","contour","bin2d","colorLabel","sizeLabel"];var d=this.connectByNoColor?h:f;if(!this.hiddenLegends){this.hiddenLegends={}}this.UJ();this.qu();if(["Meter","Correlation"].includes(this.graphType)){return}else{if(this.graphType==="Venn"){this.mI();return this.mI()}else{if(this.graphType==="Network"){this.mc()}else{if(this.isMultidimensionalData){this.QF()}else{if(this.scatterType==="bin2d"){this.AI()}else{if(this.showHistogram&&!this.ridgeBy){this.K7()}else{if(this.isContour&&this.contourFilled){this.pq()}else{for(var g=0;g<d.length;g++){var e=d[g];var b=this.RI(e);var k=b+"By";a[e]={m:{},n:0,width:0,height:0};if(l){continue}if(this.graphType==="Scatter2D"&&this.lineBy&&(this.ribbonBy||this.isCxplot)&&this.colorBy===this.lineBy&&k==="colorBy"&&!this.legendCombine){continue}if(this.YR()&&k==="colorBy"){continue}if(this[k]){if(this.data.x&&this.data.x.hasOwnProperty(this[k])){var j=c.x[this[k]];this[b+"ByType"]="x";if(j.type==="Numeric"&&!j[k]){this.lT(j,e)}else{this.gC(j,"x",k,e)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[k])){var j=c.z[this[k]];this[b+"ByType"]="z";if(j.type==="Numeric"&&!j[k]){this.lT(j,e,this.colorSpectrumBreaks.length?true:false)}else{this.gC(j,"z",k,e)}}else{if(this.sF(this[k])>-1&&c.y.range[this[k]]){var j=c;if(j.modified&&j.modified.z&&j.modified.z[this[k]]){j=j.modified.z;if(!j.meta){j.meta={}}j.meta[this[k]]={levels:j[this[k]]};this.gC(j.meta[this[k]],"modified",k,e)}else{j=c.y.range[this[k]];this.lT(j,e,[j.min,j.max])}}else{if(this[k]==="variable"){a[e].n=this.varIndices.length}else{if(this.ridgeBy&&this[k]==="data"){this.lT({type:"Numeric"},e,[this.xAxisMin,this.xAxisMax])}else{if(this.histogramAsDotplot&&this.data.z&&this.data.z.hasOwnProperty(this[k])){var j=c.z[this[k]];if(j.type==="Numeric"&&!j[k]){this.lT(j,e)}else{this.gC(j,"z",k,e)}}}}}}}}}}}}}}}}this.Cr();this.lI();this.Fj();this.K9();this.Or();this.LX()};this.cO=function(b,a){if(!b){return}if(a){var c=this.qQ(a);b.x=c.x;b.y=c.y}this.customLegend.push(b)};this.Cs=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.customLegend.length;a++){if(this.customLegend[a].id!=c.id){b.push(this.customLegend[a])}}this.customLegend=b}};this.jw=function(l){if(l.line){for(var y=0;y<l.line.length;y++){var c,m,C,q,v,A,s,h;var b=l.line[y];b.id=b.id==null?this.DW("-decoration-"):b.id;b.render=[];var w=b.hasOwnProperty("value")?b.value:b.hasOwnProperty("x")?b.x:b.hasOwnProperty("x1")?b.x1:b.hasOwnProperty("y")?b.y:b.hasOwnProperty("y1")?b.y1:0;var g=true;var z=b.type||"line";var f=b.color;var p=b.label||false;var t=b.labelScaleFontFactor?(parseInt(b.labelScaleFontFactor*this.decorationsTextFontSize)+"px "+this.fontName):this.decorationsTextFont;var a=b.width||1;var o=b.align||"left";var B=b.position||"over";var e=b.scope||false;if(this.HA()){c=this.marginLeft+this.offsetX+this.left;C=c+this.x;m=this.marginTop+this.offsetY+this.top+this.y-((w-this.xAxisMin)*this.xAxisUnit);q=m;A=B=="under"?q+this.margin:q-this.margin;s=B=="under"?"top":"bottom";g=m<=this.marginTop+this.offsetY+this.top+this.y&&m>=this.marginTop+this.offsetY+this.top?true:false}else{c=this.marginLeft+this.offsetX+this.left+((w-this.xAxisMin)*this.xAxisUnit);C=c;v=B=="under"?C-(this.margin*2):C+(this.margin*2);s=B=="under"?"right":"left";m=this.marginTop+this.offsetY+this.top;q=m+this.y;g=c<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(g&&e){if(this.layoutValid){g=false;var r=this.N0(this.data.l.name[this.layoutCurrent]);for(var x=0;x<r.length;x++){if(e==r[x]){g=true}}}}if(g){var n=this.isR?6:3;if(p){if(this.HA()){var u=o=="right"?C-this.margin:o=="center"?c+(this.x/2):c+this.margin;h=this.Mc({p:["drawText",p,u,A,t,f,o,s],t:"Decorations"})}else{var d=o=="right"?q-(this.margin*n):o=="center"?m+(this.y/2):m+(this.margin*n);h=this.Mc({p:["drawText",p,v,d,t,f,s,"middle"],t:"Decorations"})}b.render.push(h)}var k=b.tooltip||("&rarr; "+w);h=this.Mc({p:["drawLine",z,c,m,C,q,f,a],i:[k+":Decoration"+y],t:"Decorations"});b.render.push(h)}}}};this.gY=function(h,u,e){if(h.range){for(var w=0;w<h.range.length;w++){var a,k,z,p,d;var y=h.range[w];y.id=y.id==null?this.DW("-decoration-"):y.id;y.render=[];var o=y.hasOwnProperty("value")?y.value:y.hasOwnProperty("x")?y.x:y.hasOwnProperty("x1")?y.x1:y.hasOwnProperty("y")?y.y:y.hasOwnProperty("y1")?y.y1:null;var m=y.hasOwnProperty("value2")?y.value2:y.hasOwnProperty("x2")?y.x2:y.hasOwnProperty("y2")?y.y2:null;var c=true;var l=y.color;var g=y.smpId!=null?y.smpId:y.smp?this.sF(y.smp):null;var n=y.smpId2!=null?y.smpId2:y.smp2?this.sF(y.smp2):null;var x=o!=null?this.xQ(this.isTransformedData,o):null;var q=m!=null?this.xQ(this.isTransformedData,m):null;var b=y.scope||false;if(g==null&&n==null){if(this.HA()){a=u;z=u+this.x;k=e+this.y-((x-this.xAxisMin)*this.xAxisUnit);p=e+this.y-((q-this.xAxisMin)*this.xAxisUnit)}else{a=u+((x-this.xAxisMin)*this.xAxisUnit);z=u+((q-this.xAxisMin)*this.xAxisUnit);k=e;p=e+this.y}}else{if(x==null&&q==null){if(this.HA()){a=g!=null&&g>=0?this.smpInfo[g]:null;z=n!=null&&n>=0?this.smpInfo[n]:null;k=e;p=e+this.y}else{a=u;z=u+this.x;k=g!=null&&g>=0?this.smpInfo[g]:null;p=n!=null&&n>=0?this.smpInfo[n]:null}}else{if(this.HA()){a=g!=null&&g>=0?this.smpInfo[g]:null;z=n!=null&&n>=0?this.smpInfo[n]:null;k=e+this.y-((x-this.xAxisMin)*this.xAxisUnit);p=e+this.y-((q-this.xAxisMin)*this.xAxisUnit)}else{a=u+((x-this.xAxisMin)*this.xAxisUnit);z=u+((q-this.xAxisMin)*this.xAxisUnit);k=g!=null&&g>=0?this.smpInfo[g]:null;p=n!=null&&n>=0?this.smpInfo[n]:null}}}if(c&&b){if(this.layoutValid){c=false;var r=this.N0(this.data.l.name[this.layoutCurrent]);for(var v=0;v<r.length;v++){if(b==r[v]){c=true}}}}if(c){var f=y.tooltip||(x+" - "+q)||(this.data.y.smps[g]+" - "+this.data.y.smps[n]);var t=Math.abs(z-a);var s=Math.abs(p-k);d=this.Mc({p:["drawShape","rectangle",(a+z)/2,(k+p)/2,t,s,l,y.outline||l,y.pattern,y.rotate],i:[f+":Decoration-"+w],t:"Decorations"});y.render.push(d)}}}};this.sQ=function(e){if(e.point){for(var h=0;h<e.point.length;h++){var g=e.point[h];g.id=g.id==null?this.DW("-decoration-"):g.id;var a=g.hasOwnProperty("value")?g.value:g.hasOwnProperty("x")?g.x:g.hasOwnProperty("y")?g.y:0;var d=true;var l=g.smpId!=null?g.smpId:this.sF(g.smp);var m=this.xQ(this.isTransformedData,a);var k=g.color||this.foreground;var f=(g.width||1)*this.dataPointSize;var o=(g.height||1)*this.dataPointSize;var n=g.shape||"circle";var c=l!=null&&l>=0?this.smpInfo[l]:null;var p=(m-this.xAxisMin)*this.xAxisUnit;if(c!=null&&p!=null){if(this.HA()){p=this.marginTop+this.offsetY+this.top+this.y-p;d=p<=this.marginTop+this.offsetY+this.top+this.y&&p>=this.marginTop+this.offsetY+this.top?true:false}else{c=this.marginLeft+this.offsetX+this.left+p;p=this.smpInfo[l];d=c<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(d){var j=g.smp+"("+value+")";var b=this.Mc({p:["drawShape",n,c,p,f,o,k,k,"closed"],i:[j+":Decoration"+h],t:"Decorations"});g.render=[b]}}}}};this.Xr=function(f){if(f.text){for(var h=0;h<f.text.length;h++){var q=f.text[h];var l=q.hasOwnProperty("value");var m=q.hasOwnProperty("x");var a=q.hasOwnProperty("y");var g=l?q.value:m?q.x:a?q.y:0;q.id=q.id==null?this.DW("-decoration-"):q.id;var e=true;var k=q.smpId!=null?q.smpId:this.sF(q.smp);var n=this.xQ(this.isTransformedData,g);var j=q.labelScaleFontFactor?(parseInt(q.labelScaleFontFactor*this.decorationsTextFontSize)+"px "+this.fontName):this.decorationsTextFont;var d=q.label||false;var o=q.color||this.foreground;var c=k!=null&&k>=0?this.smpInfo[k]:null;var p=(n-this.xAxisMin)*this.xAxisUnit;if(c!=null&&p!=null){if(this.HA()){p=this.marginTop+this.offsetY+this.top+this.y-p;e=p<=this.marginTop+this.offsetY+this.top+this.y&&p>=this.marginTop+this.offsetY+this.top?true:false}else{c=this.marginLeft+this.offsetX+this.left+p;p=this.smpInfo[k];e=c<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(e){var b=this.Mc({p:["drawText",d,c,p+this.margin,j,o,"center","bottom"],t:"Decorations"});q.render=[b]}}}}};this.Mi=function(c){if(c.marker){for(var f=0;f<c.marker.length;f++){var h=c.marker[f];if(h.type=="range"){if(h.sample&&h.sample2){var e=this.sF(h.sample);var g=this.sF(h.sample2);if(e!=null&&e>=0&&g!=null&&g>=0){h.id=h.id==null?this.DW("-decoration-"):h.id;var d=this.smpInfo[e]-this.blockSeparation;var k=this.smpInfo[g]+this.blockSeparation;var j=Math.abs(k-d);var a=this.eN(h.color,this.decorationsTransparency);var b=this.Mc({p:["drawShape","rectangle",(d+k)/2,this.top+(this.y/2)+this.margin,j,this.y,a,a],t:"Decorations"});h.render=[b]}}}}}};this.GZ=function(l){if(l.error){for(var w=0;w<l.error.length;w++){var a=l.error[w];if(a.sample!=null){var b,o,B,q,k,g,y,v,f;var x=a.isIndex?a.sample:this.data.w?this.plotInfo.indices.indexOf(this.data.w.smps.indexOf(a.sample)):this.data.y.smps.indexOf(a[this.plotInfo.indices[w]].sample);a.render=[];var r=this.data.w?x:w;var t=this.xQ(this.isTransformedData,a.min||this.xAxisMin);var z=this.xQ(this.isTransformedData,a.max||this.xAxisMax);var m=a.cat?this.meta.data.x[a.cat].colors:false;var e=true;var A=a.type||"line";var d=m?m[w%m.length]:a.color||this.foreground;var n=a.size||1;var p=(a.width||1)*this.dataPointSize*4;var c=a.scope||false;if(x!=null){a.id=a.id==null?this.DW("-decoration-"):a.id;if(this.HA()){b=this.smpInfo[r];o=this.marginTop+this.offsetY+this.top+this.y-((t-this.xAxisMin)*this.xAxisUnit);B=b;q=this.marginTop+this.offsetY+this.top+this.y-((z-this.xAxisMin)*this.xAxisUnit);k=b-p;g=o;y=b+p;v=q}else{b=this.marginLeft+this.offsetX+this.left+((t-this.xAxisMin)*this.xAxisUnit);o=this.smpInfo[r];B=this.marginLeft+this.offsetX+this.left+((z-this.xAxisMin)*this.xAxisUnit);q=o;k=b;g=o-p;y=B;v=o+p}if(e&&c){if(this.layoutValid){e=false;var s=this.N0(this.data.l.name[this.layoutCurrent]);for(var u=0;u<s.length;u++){if(c==s[u]){e=true}}}}if(e){var h=this.Mc({p:["drawLine",A,b,o,B,q,d,n],i:["Error-"+a.sample+":Decoration"+w],t:"Decorations"});a.render.push(h);if(this.HA()){f=this.Mc({p:["drawLine",A,k,g,y,g,d,n],i:["Error-"+a.sample+":Decoration"+w],g:h,t:"Decorations"});a.render.push(f);f=this.Mc({p:["drawLine",A,k,v,y,v,d,n],i:["Error-"+a.sample+":Decoration"+w],g:h,t:"Decorations"});a.render.push(f)}else{f=this.Mc({p:["drawLine",A,k,g,k,v,d,n],i:["Error-"+a.sample+":Decoration"+w],g:h,t:"Decorations"});a.render.push(f);f=this.Mc({p:["drawLine",A,y,g,y,v,d,n],i:["Error-"+a.sample+":Decoration"+w],g:h,t:"Decorations"});a.render.push(f)}}}}}}};this.YG=function(e,s,c){var l=["linear","exponential","logarithmic","power","polynomial"];for(var v=0;v<l.length;v++){var x=l[v];if(e[x]){var p=e[x];for(var t=0;t<p.length;t++){var d=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[t];var o=this.yAxisIndices.length==1?this.yAxisIndices[0]:this.yAxisIndices[t];var f=this.et(d);var y=this.et(o);var b=e[x][t].color||this.colors[t%this.colors.length];var w=[];var n=this.varIndices.sort(function(j,i){return f[j]-f[i]});for(var r=0;r<n.length;r++){var a=n[r];w.push([f[a],y[a]])}var h=this[x+"Regression"](w);var u=[];var g=[];if(h&&h.predict){for(var r=0;r<h.predict.length;r++){var m=s+((h.predict[r][0]-this.xAxisMin)*this.xAxisUnit);var q=(c+this.y)-((h.predict[r][1]-this.yAxisMin)*this.yAxisUnit);u.push(m);g.push(q)}if(u.length>0){this.Mc({p:["drawLine","spline",u,g,false,false,b,1],i:["Decor-"+x+"-"+t],t:"Decorations"})}}}}}};this.oh=function(f,z,c){if(f.nlfit||f.nonlinear){var n,E,b;var h=this.varIndices;var w,G;var H=f.nlfit?f.nlfit:f.nonlinear;for(var C=0;C<H.length;C++){var B=[];var l=[];var e=C%this.colors.length;var s=Number(this.xQ(this.yAxisTransform,H[C].param[0]));var r=Number(this.xQ(this.yAxisTransform,H[C].param[1]));var q=Number(H[C].param[2]);var o=Number(H[C].param[3]);var d=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[C];var y=this.et(d);if(this.xAxisTransform=="percentile"){n=this.aC(y);b=n[0];E=n[1]}h.sort(function(j,i){return y[j]-y[i]});var m=H[C].color?H[C].color:this.colors[e];for(var A=0;A<h.length;A++){var p=h[A];var v=this.uP(p,d);var D;var t=[];if(v>0){if(A>0){var u=h[A-1];var g=this.uP(u,d);if(g>0){var F=(v-g)/25;for(var x=0;x<25;x++){t.push(g);g+=F}}}else{t=[v]}for(var x=0;x<t.length;x++){if(H[C].type=="reg"){D=s+((r-s)/(1+q/(Math.pow(t[x],o))))}else{D=s+((r-s)/(1+(Math.pow((t[x]/q),o))))}if(this.xAxisTransform){t[x]=this.xAxisTransform=="percentile"?this.an(b,E,t[x]):this.xQ(this.xAxisTransform,t[x])}w=z+((t[x]-this.xAxisMin)*this.xAxisUnit);G=(c+this.y)-((D-this.yAxisMin)*this.yAxisUnit);B.push(w);l.push(G)}}}if(B.length>0){this.Mc({p:["drawShape","path",B,l,false,false,m,m,"open",false,false,true],i:["Decor-Non-Lin-"+A+"-"+C],t:"Decorations"});if(H[C].type=="reg"){D=s+((r-s)/(1+q/(Math.pow(q,o))))}else{D=s+((r-s)/(1+(Math.pow((q/q),o))))}if(this.xAxisTransform){q=this.xAxisTransform=="percentile"?this.an(b,E,q):this.xQ(this.xAxisTransform,q)}w=z+((q-this.xAxisMin)*this.xAxisUnit);G=(c+this.y)-((D-this.yAxisMin)*this.yAxisUnit);var a=this.Mc({p:["drawLine","dottedLine",z,G,w,G,m],i:["Decor-Non-Lin-EC-h"+A+"-"+C],t:"Decorations"});this.Mc({p:["drawLine","dottedLine",w,G,w,(c+this.y),m],i:["Decor-Non-Lin-EC-v"+A+"-"+C],g:a,t:"Decorations"})}}}};this.Bs=function(k,u,e){if(k.reg||k.regression){var s=k.reg?k.reg:k.regression;for(var x=0;x<s.length;x++){var y=s[x];if(y.slope!=null&&y.intercept!=null){var b=y.color?y.color:this.colors[x%this.colors.length];var f=this.eN(b,0.3,true);var p=this.QN(x,false,"patternBy");var d=y.style?y.style:this.fitLineType;var o=Number(y.slope);var A=Number(y.intercept);var z=y.id;var t=y.cor;var w="y ~ "+this.ct(o,this.yAxisDecs+1)+"x + "+this.ct(A,this.yAxisDecs+1)+(t?" (r = "+this.ct(t,3)+")":"");var m=y.ci?y.ci:false;var h=m?m.length-1:false;var a=this.showRegressionFullRange||!m?this.xAxisMin:m[0][0];var l=(o*a)+A;var B=this.showRegressionFullRange||!m?this.xAxisMax:m[h][0];var q=(o*B)+A;a=u+(a*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);l=(e+this.y)-(l*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);B=u+(B*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(e+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var g=this.PW([[a,l],[B,q]]);if(g.length){this.Mc({p:["drawLine",d,g[0][0][0],g[0][0][1],g[0][1][0],g[0][1][1],b,2],i:["Decor-Reg-"+x,z],t:"Decorations",h:this.e1(false,false,z)})}if(m){var n=[];var r=[];var c=[];for(var v=0;v<m.length;v++){l=m[v][1];q=m[v][2];a=u+(m[v][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);l=(e+this.y)-(l*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);q=(e+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);n.push([a,a]);r.push([l,q]);c.push([a,(l+q)/2])}if(this.showConfidenceIntervals){this.Mc({p:["drawShape","confidence",n,r,false,false,f,this.isCxplot?f:b,p],i:[w+":Confidence",z],b:c,t:"Decorations",h:this.e1(false,false,z)})}}}}}};this.Jo=function(g,r,e){if(g.nor||g.normal){var a=g.nor?g.nor:g.normal;for(var t=0;t<a.length;t++){var A=a[t];if(A.mu!=null&&A.sigma!=null){var B=[];var d=[];var v=[];var p,z;var f=t%this.colors.length;var u=A.mu;var n=A.sigma;var m=A.start?A.start:A.yAxis?this.yAxisMin:this.xAxisMin;var l=A.end?A.end:A.yAxis?this.yAxisMax:this.xAxisMax;var c=120;if(m<u&&u<l){var q,w,y,o;var x=(u-m)/c;var k=n*n;var h=1/Math.sqrt(2*Math.PI*k);if(A.yAxis){y=A.max?A.max*this.xAxisUnit:this.x-(this.x*this.axisExtension);o=y/h;q=m;for(var s=0;s<c-1;s++){w=(h*Math.pow(Math.E,-Math.pow(q-u,2)/k));v.push([q,w]);p=r+(w*o);z=(e+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);B.push(p);d.push(z);q+=x}x=(l-u)/c;q=u;for(var s=0;s<c;s++){w=(h*Math.pow(Math.E,-Math.pow(q-u,2)/k));v.push([q,w]);p=r+(w*o);z=(e+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);B.push(p);d.push(z);q+=x}var b=A.color?A.color:this.colors[f];this.Mc({p:["drawShape","path",B,d,false,false,b,b,"open",false,false,true],i:["Decor-Nor-"+t],t:"Decorations"})}else{y=A.max?A.max*this.yAxisUnit:this.y-(this.y*this.axisExtension);o=y/h;q=m;for(var s=0;s<c-1;s++){w=(h*Math.pow(Math.E,-Math.pow(q-u,2)/k));v.push([q,w]);p=r+(q*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);z=(e+this.y)-(w*o);B.push(p);d.push(z);q+=x}x=(l-u)/c;q=u;for(var s=0;s<c;s++){w=(h*Math.pow(Math.E,-Math.pow(q-u,2)/k));v.push([q,w]);p=r+(q*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);z=(e+this.y)-(w*o);B.push(p);d.push(z);q+=x}var b=A.color?A.color:this.colors[f];this.Mc({p:["drawShape","path",B,d,false,false,b,b,"open",false,false,true],i:["Decor-Nor-"+t],t:"Decorations"})}}}}}};this.xg=function(au,O,an){var r=[];var G=function(av){r.unshift(av);for(var k=1;k<r.length;k++){var aw=r[k];if(av.x1>=aw.x2||aw.x1>=av.x2){continue}if(av.y1>=aw.y2||aw.y1>=av.y2){continue}return true}return false};var p=["line","text","label","point","range","image","polygon"];for(var aa=0;aa<p.length;aa++){var c=p[aa];if(au[c]){for(var a=0;a<au[c].length;a++){var n=au[c][a];if(n.x!=null||n.y!=null){var X,W,H,F,al,g,ad;var U,ac,S,ah;n.id=n.id==null?this.DW("-decoration-"):n.id;var v=n.x!=null?n.x:null;var u=n.y!=null?n.y:null;var am=n.x2!=null?n.x2:null;var T=n.y2!=null?n.y2:null;var L=n.width?n.width:(c==="point"?this.dataPointSize*1:1);var aq=n.height?n.height:(c==="point"?this.dataPointSize*1:1);var ap=n.color?n.color:this.colors[a%this.colors.length];var ai=n.type?n.type:c;var t=n.label||false;var ak=n.curve||0.5;var j=n.relative||false;var M=n.wrap||false;var o=n.justify||false;var V=(n.labelScaleFontFactor||1)*this.decorationsTextFontSize;var m=n.font||(V+"px "+this.fontName);var y=n.color||this.decorationsTextColor;var af=n.background||this.background;var at=n.position||"over";var ae=at==="under"?"top":"bottom";var P=n.align||"left";var s=c==="line"&&ai!=="line"?ai:n.style?n.style:"line";var Y=n.tooltip||false;var b=n.shape||"circle";var f=n.src||false;var ag=[];var w=false;if(ai==="line"||ai==="range"){if(v!=null&&(this.isGraphTime==="x"||this.xAxisTime)&&this.Ek([v])){U=v;v=new Date(v).getTime()}if(am!=null&&(this.isGraphTime==="x"||this.xAxisTime)&&this.Ek([am])){ac=am;am=new Date(am).getTime()}if(u!=null&&(this.isGraphTime==="y"||this.yAxisTime)&&this.Ek([u])){S=u;u=new Date(u).getTime()}if(T!=null&&(this.isGraphTime==="y"||this.yAxisTime)&&this.Ek([T])){ah=T;T=new Date(T).getTime()}if(v==null&&am==null&&u!=null&&T!=null){v=this.xAxisMin;am=this.xAxisMax}else{if(u==null&&T==null&&v!=null&&am!=null){u=this.yAxisMin;T=this.yAxisMax}}}if(j){v=this.xAxisMin+(v*this.xAxisRange);u=this.yAxisMin+(u*this.yAxisRange)}if(this.isCxplot&&this.decorationsTransform){if(this.xAxisTransform){if(v!=null){v=this.xQ(this.xAxisTransform,v)}if(am!=null){am=this.xQ(this.xAxisTransform,am)}}if(this.yAxisTransform){if(u!=null){u=this.xQ(this.yAxisTransform,u)}if(T!=null){T=this.xQ(this.yAxisTransform,T)}}}var q=this.Hl(v)&&this.Hl(u)&&am==null&&T==null;if(c==="range"||c==="point"){if(c==="point"&&n.width){L=n.width*this.xAxisUnit}if(c==="point"&&n.height){aq=n.height*this.yAxisUnit}}if(n.scope){var C=!this.layoutValid;if(this.layoutValid){var E=this.N0(this.data.l.name[this.layoutCurrent]);for(var aj=0;aj<E.length;aj++){if(n.scope.toString()===E[aj].toString().replace("\x00","")){C=true;break}}}if(!C){continue}}if(q){var R=null;var A=[];var x=[];for(var z=1;z<v.length;z++){X=O+((v[z-1]-this.xAxisMin)*this.xAxisUnit);H=O+((v[z]-this.xAxisMin)*this.xAxisUnit);W=an+this.y-((u[z-1]-this.yAxisMin)*this.yAxisUnit);F=an+this.y-((u[z]-this.yAxisMin)*this.yAxisUnit);ad=t?t:"";if(ai==="polygon"){A.push(X);x.push(W)}else{if(z===1){R=this.Mc({p:["drawLine",s,X,W,H,F,ap,L],i:[ad+":Decoration-"+z],t:"Decorations"});ag.push(R)}else{w=this.Mc({p:["drawLine",s,X,W,H,F,ap,L],i:[ad+":Decoration-"+z],g:R,t:"Decorations"});ag.push(w)}}}if(ai==="polygon"){this.Mc({p:["drawShape","polygon",A,x,false,false,ap,ap,n.pattern||"solid",n.rotate||false],i:[ad+":Decoration-"+a],t:"Decorations"})}}else{if(v!=null&&u!=null&&am!=null&&T!=null&&(c.match(/line|range/))){X=O+((v-this.xAxisMin)*this.xAxisUnit);H=O+((am-this.xAxisMin)*this.xAxisUnit);W=an+this.y-((u-this.yAxisMin)*this.yAxisUnit);F=an+this.y-((T-this.yAxisMin)*this.yAxisUnit);if(U&&S&&ac&&ah){ad=n.tooltip||("("+(U||v)+","+(S||u)+") → ("+(ac||am)+","+(ah||T)+")")}else{if(U&&ac){ad=n.tooltip||((U||v)+" → "+(ac||am))}else{if(S&&ah){ad=n.tooltip||((S||u)+" → "+(ah||T))}else{ad=n.tooltip||""}}}if(c==="range"){al=Math.abs(H-X);g=Math.abs(F-W);w=this.Mc({p:["drawShape","rectangle",(X+H)/2,(W+F)/2,al,g,ap,n.outline||ap,n.pattern,n.rotate],i:[ad+":Decoration-"+a],t:"Decorations"});ag.push(w)}else{if(s==="arch"){var K=Math.sqrt(Math.pow(H-X,2)+Math.pow(F-W,2))*ak;var e=[(X+H)*0.5,(W+F)*0.5];var D=Math.atan2(F-W,H-X)+(Math.PI/2);var J=[e[0]+K*Math.cos(D),e[1]+K*Math.sin(D)];w=this.Mc({p:["drawLine","arch",[X,J[0],H],[W,J[1],F],false,false,ap,L],i:[ad+":Decoration-"+a],t:"Decorations"});ag.push(w)}else{w=this.Mc({p:["drawLine",s,X,W,H,F,ap,L],i:[ad+":Decoration-"+a],t:"Decorations"});ag.push(w)}}}else{if(v!=null){X=O+((v-this.xAxisMin)*this.xAxisUnit);if(c==="line"||c==="range"){W=an;H=(c==="range"&&am!=null)?O+((am-this.xAxisMin)*this.xAxisUnit):X;F=W+this.y;if(c==="range"){ad=n.tooltip||"x "+(U||v)+" → "+(ac||am);al=Math.abs(H-X);g=Math.abs(F-W);w=this.Mc({p:["drawShape","rectangle",(X+H)/2,(W+F)/2,al,g,ap,n.outline||ap,n.pattern,n.rotate],i:[ad+":Decoration-"+a],t:"Decorations"});ag.push(w)}else{ad=n.tooltip||"x → "+(U||v);w=this.Mc({p:["drawLine",s,X,W,H,F,ap,L],i:[ad+":Decoration-"+a],t:"Decorations"});ag.push(w)}}else{if((c==="point"||c==="text"||c==="label")&&u!=null){W=an+this.y-((u-this.yAxisMin)*this.yAxisUnit);H=X;F=W;if(c==="point"){ad=n.tooltip||this.ct(n.x,this.xAxisDecs)+", "+this.ct(n.y,this.yAxisDecs);w=this.Mc