## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(TCRconvertR)

# For this example, create a temporary input folder
fastadir <- file.path(tempdir(), "TCRconvertR_tmp")
dir.create(fastadir, showWarnings = FALSE)
file.copy(get_example_path("fasta_dir/test_trav.fa"), fastadir)

# Build lookup tables
new_lookup_dir <- build_lookup_from_fastas(fastadir, species = "rabbit")

# Confirm they exist now
list.files(new_lookup_dir)

