/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class DenseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix1D(Object[] objectArray) {
        this(objectArray.length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix1D(int n) {
        this.setUp(n);
        this.elements = new Object[n];
    }

    protected DenseObjectMatrix1D(int n, Object[] objectArray, int n2, int n3, boolean bl) {
        this.setUp(n, n2, n3);
        this.elements = objectArray;
        this.isNoView = !bl;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        Object object = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int n = DenseObjectMatrix1D.this.zero + n3 * DenseObjectMatrix1D.this.stride;
                        Object object = objectFunction.apply(DenseObjectMatrix1D.this.elements[n]);
                        for (int i = n3 + 1; i < n4; ++i) {
                            object = objectObjectFunction.apply(object, objectFunction.apply(DenseObjectMatrix1D.this.elements[n += DenseObjectMatrix1D.this.stride]));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[this.zero]);
            int n5 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                object = objectObjectFunction.apply(object, objectFunction.apply(this.elements[n5 += this.stride]));
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        Object object = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int n = DenseObjectMatrix1D.this.zero + nArray[n4] * DenseObjectMatrix1D.this.stride;
                        Object object = objectFunction.apply(DenseObjectMatrix1D.this.elements[n]);
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = DenseObjectMatrix1D.this.zero + nArray[i] * DenseObjectMatrix1D.this.stride;
                            Object object2 = DenseObjectMatrix1D.this.elements[n];
                            object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            int n6 = this.zero + nArray[0] * this.stride;
            object = objectFunction.apply(this.elements[n6]);
            for (int i = 1; i < n; ++i) {
                n6 = this.zero + nArray[i] * this.stride;
                Object object2 = this.elements[n6];
                object = objectObjectFunction.apply(object, objectFunction.apply(object2));
            }
        }
        return object;
    }

    public Object aggregate(ObjectMatrix1D objectMatrix1D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.aggregate(objectMatrix1D, objectObjectFunction, objectObjectFunction2);
        }
        this.checkSize(objectMatrix1D);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)objectMatrix1D.index(0);
        final int n2 = objectMatrix1D.stride();
        final Object[] objectArray = (Object[])objectMatrix1D.elements();
        Object object = null;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        Object object = objectObjectFunction2.apply(DenseObjectMatrix1D.this.elements[n3], objectArray[n22]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            object = objectObjectFunction.apply(object, objectObjectFunction2.apply(DenseObjectMatrix1D.this.elements[n3 += DenseObjectMatrix1D.this.stride], objectArray[n22 += n2]));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectObjectFunction2.apply(this.elements[this.zero], objectArray[n]);
            int n7 = this.zero;
            int n8 = n;
            for (int i = 1; i < this.size; ++i) {
                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.elements[n7 += this.stride], objectArray[n8 += n2]));
            }
        }
        return object;
    }

    public ObjectMatrix1D assign(Object[] objectArray) {
        if (this.isNoView) {
            if (objectArray.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + objectArray.length + "size()=" + this.size());
            }
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            super.assign(objectArray);
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectFunction objectFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseObjectMatrix1D.this.zero + n3 * DenseObjectMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseObjectMatrix1D.this.elements[n] = objectFunction.apply(DenseObjectMatrix1D.this.elements[n]);
                            n += DenseObjectMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = objectFunction.apply(this.elements[n5]);
                n5 += this.stride;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D) {
        Object[] objectArray;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D);
        }
        DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
        if (denseObjectMatrix1D == this) {
            return this;
        }
        this.checkSize(denseObjectMatrix1D);
        if (this.isNoView && denseObjectMatrix1D.isNoView) {
            System.arraycopy(denseObjectMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseObjectMatrix1D)) {
            objectArray = denseObjectMatrix1D.copy();
            if (!(objectArray instanceof DenseObjectMatrix1D)) {
                return super.assign(objectMatrix1D);
            }
            denseObjectMatrix1D = (DenseObjectMatrix1D)objectArray;
        }
        objectArray = denseObjectMatrix1D.elements;
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseObjectMatrix1D.index(0);
        final int n2 = denseObjectMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseObjectMatrix1D.this.elements[n3] = objectArray[n22];
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = objectArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D, objectObjectFunction);
        }
        final int n = (int)objectMatrix1D.index(0);
        final int n2 = objectMatrix1D.stride();
        final Object[] objectArray = (Object[])objectMatrix1D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseObjectMatrix1D.this.elements[n3] = objectObjectFunction.apply(DenseObjectMatrix1D.this.elements[n3], objectArray[n22]);
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = objectObjectFunction.apply(this.elements[n7], objectArray[n8]);
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final Object object) {
        final Object[] objectArray = this.elements;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseObjectMatrix1D.this.zero + n3 * DenseObjectMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            objectArray[n] = object;
                            n += DenseObjectMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                objectArray[n5] = object;
                n5 += this.stride;
            }
        }
        return this;
    }

    public Object elements() {
        return this.elements;
    }

    public Object getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D selectedDenseObjectMatrix1D = (SelectedDenseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedDenseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
            return this.elements == denseObjectMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    public ObjectMatrix1D like(int n) {
        return new DenseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseObjectMatrix2D denseObjectMatrix2D = new DenseObjectMatrix2D(n, n2);
        final Object[] objectArray = (Object[])((ObjectMatrix2D)denseObjectMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseObjectMatrix2D).index(0, 0);
        final int n4 = denseObjectMatrix2D.rowStride();
        final int n5 = denseObjectMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, n2);
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseObjectMatrix1D.this.zero + i * n * DenseObjectMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                objectArray[n6] = DenseObjectMatrix1D.this.elements[n2];
                                n6 += n4;
                                n2 += DenseObjectMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    objectArray[n11] = this.elements[n10];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseObjectMatrix2D;
    }

    public ObjectMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseObjectMatrix3D denseObjectMatrix3D = new DenseObjectMatrix3D(n, n2, n3);
        final Object[] objectArray = (Object[])((ObjectMatrix3D)denseObjectMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseObjectMatrix3D).index(0, 0, 0);
        final int n5 = denseObjectMatrix3D.sliceStride();
        final int n6 = denseObjectMatrix3D.rowStride();
        final int n7 = denseObjectMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n8 = Math.min(n8, n);
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseObjectMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseObjectMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    objectArray[n] = DenseObjectMatrix1D.this.elements[n22];
                                    n += n6;
                                    n22 += DenseObjectMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        objectArray[n13] = this.elements[n12];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseObjectMatrix3D;
    }

    public void setQuick(int n, Object object) {
        this.elements[this.zero + n * this.stride] = object;
    }

    public void swap(ObjectMatrix1D objectMatrix1D) {
        DenseObjectMatrix1D denseObjectMatrix1D;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            super.swap(objectMatrix1D);
        }
        if ((denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D) == this) {
            return;
        }
        this.checkSize(denseObjectMatrix1D);
        final Object[] objectArray = (Object[])denseObjectMatrix1D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)objectMatrix1D.index(0);
        final int n2 = objectMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            Object object = DenseObjectMatrix1D.this.elements[n3];
                            DenseObjectMatrix1D.this.elements[n3] = objectArray[n22];
                            objectArray[n22] = object;
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                Object object = this.elements[n7];
                this.elements[n7] = objectArray[n8];
                objectArray[n8] = object;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        } else {
            super.toArray(objectArray);
        }
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseObjectMatrix1D(this.elements, nArray);
    }
}

