/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseCCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseCCMFComplexMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseFComplexMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseFComplexMatrix1D(n);
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    public float[] getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, float[] fArray) {
        this.elements[n2].setQuick(n, fArray);
    }

    public void setQuick(int n, int n2, float f, float f2) {
        this.elements[n2].setQuick(n, f, f2);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseFComplexMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new SparseCCMFComplexMatrix2D(n, n2);
    }
}

