/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Norm;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SmpDoubleBlas;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DenseDoubleAlgebra DEFAULT = new DenseDoubleAlgebra();
    public static final DenseDoubleAlgebra ZERO;
    protected DoubleProperty property;

    public DenseDoubleAlgebra() {
        this(DoubleProperty.DEFAULT.tolerance());
    }

    public DenseDoubleAlgebra(double d) {
        this.setProperty(new DoubleProperty(d));
    }

    public DenseDoubleCholeskyDecomposition chol(DoubleMatrix2D doubleMatrix2D) {
        return new DenseDoubleCholeskyDecomposition(doubleMatrix2D);
    }

    public Object clone() {
        return new DenseDoubleAlgebra(this.property.tolerance());
    }

    public double cond(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).cond();
    }

    public double det(DoubleMatrix2D doubleMatrix2D) {
        return this.lu(doubleMatrix2D).det();
    }

    public DenseDoubleEigenvalueDecomposition eig(DoubleMatrix2D doubleMatrix2D) {
        return new DenseDoubleEigenvalueDecomposition(doubleMatrix2D);
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static DoubleDoubleFunction hypotFunction() {
        return new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return DenseDoubleAlgebra.hypot(d, d2);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D doubleMatrix2D) {
        if (this.property.isSquare(doubleMatrix2D) && this.property.isDiagonal(doubleMatrix2D)) {
            DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
            boolean bl = true;
            int n = doubleMatrix2D2.rows();
            while (--n >= 0) {
                double d = doubleMatrix2D2.getQuick(n, n);
                bl &= d != 0.0;
                doubleMatrix2D2.setQuick(n, n, 1.0 / d);
            }
            if (!bl) {
                throw new IllegalArgumentException("A is singular.");
            }
            return doubleMatrix2D2;
        }
        return this.solve(doubleMatrix2D, DoubleFactory2D.dense.identity(doubleMatrix2D.rows()));
    }

    public DenseDoubleLUDecomposition lu(DoubleMatrix2D doubleMatrix2D) {
        return new DenseDoubleLUDecomposition(doubleMatrix2D);
    }

    public DoubleMatrix1D kron(final DoubleMatrix1D doubleMatrix1D, final DoubleMatrix1D doubleMatrix1D2) {
        int n = (int)doubleMatrix1D.size();
        final int n2 = (int)doubleMatrix1D2.size();
        final DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n * n2);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            denseDoubleMatrix1D.viewPart(i * n2, n2).assign(doubleMatrix1D2, DoubleFunctions.multSecond(doubleMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            for (int i = 0; i < n; ++i) {
                denseDoubleMatrix1D.viewPart(i * n2, n2).assign(doubleMatrix1D2, DoubleFunctions.multSecond(doubleMatrix1D.getQuick(i)));
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix2D kron(final DoubleMatrix2D doubleMatrix2D, final DoubleMatrix2D doubleMatrix2D2) {
        int n = doubleMatrix2D.rows();
        final int n2 = doubleMatrix2D.columns();
        final int n3 = doubleMatrix2D2.rows();
        final int n4 = doubleMatrix2D2.columns();
        if (doubleMatrix2D.getClass().getName().indexOf("Dense", 0) != -1 && doubleMatrix2D2.getClass().getName().indexOf("Dense", 0) != -1) {
            final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n * n3, n2 * n4);
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && doubleMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
                n5 = Math.min(n5, n);
                Future[] futureArray = new Future[n5];
                int n6 = n / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n5 - 1 ? n : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    denseDoubleMatrix2D.viewPart(i * n3, j * n4, n3, n4).assign(doubleMatrix2D2, DoubleFunctions.multSecond(doubleMatrix2D.getQuick(i, j)));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                ConcurrencyUtils.resetThreadsBeginN();
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        denseDoubleMatrix2D.viewPart(i * n3, j * n4, n3, n4).assign(doubleMatrix2D2, DoubleFunctions.multSecond(doubleMatrix2D.getQuick(i, j)));
                    }
                }
            }
            return denseDoubleMatrix2D;
        }
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        IntArrayList intArrayList4 = new IntArrayList();
        DoubleArrayList doubleArrayList2 = new DoubleArrayList();
        doubleMatrix2D.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
        doubleMatrix2D2.getNonZeros(intArrayList3, intArrayList4, doubleArrayList2);
        intArrayList.trimToSize();
        intArrayList2.trimToSize();
        doubleArrayList.trimToSize();
        intArrayList3.trimToSize();
        intArrayList4.trimToSize();
        doubleArrayList2.trimToSize();
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(intArrayList.elements());
        DenseIntMatrix1D denseIntMatrix1D2 = new DenseIntMatrix1D(intArrayList2.elements());
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(doubleArrayList.elements());
        DenseIntMatrix1D denseIntMatrix1D3 = new DenseIntMatrix1D(intArrayList3.elements());
        DenseIntMatrix1D denseIntMatrix1D4 = new DenseIntMatrix1D(intArrayList4.elements());
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(doubleArrayList2.elements());
        ((IntMatrix1D)denseIntMatrix1D).assign(IntFunctions.mult(n3));
        DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(doubleArrayList2.size(), (int)denseIntMatrix1D.size());
        for (int i = 0; i < doubleArrayList2.size(); ++i) {
            denseIntMatrix2D.viewRow(i).assign(denseIntMatrix1D).assign(IntFunctions.plus(((IntMatrix1D)denseIntMatrix1D3).getQuick(i)));
        }
        ((IntMatrix1D)denseIntMatrix1D2).assign(IntFunctions.mult(n4));
        DenseIntMatrix2D denseIntMatrix2D2 = new DenseIntMatrix2D(doubleArrayList2.size(), (int)denseIntMatrix1D2.size());
        for (int i = 0; i < doubleArrayList2.size(); ++i) {
            denseIntMatrix2D2.viewRow(i).assign(denseIntMatrix1D2).assign(IntFunctions.plus(((IntMatrix1D)denseIntMatrix1D4).getQuick(i)));
        }
        DoubleMatrix2D doubleMatrix2D3 = this.multOuter(denseDoubleMatrix1D, denseDoubleMatrix1D2, null);
        if (doubleMatrix2D instanceof SparseCCDoubleMatrix2D || doubleMatrix2D2 instanceof SparseCCDoubleMatrix2D) {
            return new SparseCCDoubleMatrix2D(n * n3, n2 * n4, (int[])((IntMatrix2D)denseIntMatrix2D).vectorize().elements(), (int[])((IntMatrix2D)denseIntMatrix2D2).vectorize().elements(), (double[])doubleMatrix2D3.viewDice().vectorize().elements(), false, false, false);
        }
        return new SparseRCDoubleMatrix2D(n * n3, n2 * n4, (int[])((IntMatrix2D)denseIntMatrix2D).vectorize().elements(), (int[])((IntMatrix2D)denseIntMatrix2D2).vectorize().elements(), (double[])doubleMatrix2D3.viewDice().vectorize().elements(), false, false, false);
    }

    public double mult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public DoubleMatrix1D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix2D.zMult(doubleMatrix1D, null);
    }

    public DoubleMatrix2D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return doubleMatrix2D.zMult(doubleMatrix2D2, null);
    }

    public DoubleMatrix2D multOuter(final DoubleMatrix1D doubleMatrix1D, final DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        int n3;
        int n4;
        Future[] futureArray;
        int n5 = (int)doubleMatrix1D.size();
        int n6 = (int)doubleMatrix1D2.size();
        final DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D == null ? doubleMatrix1D.like2D(n5, n6) : doubleMatrix2D;
        if (doubleMatrix2D2.rows() != n5 || doubleMatrix2D2.columns() != n6) {
            throw new IllegalArgumentException();
        }
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n5 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            n7 = Math.min(n7, n5);
            futureArray = new Future[n7];
            n4 = n5 / n7;
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = n3 * n4;
                n = n3 == n7 - 1 ? n5 : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            doubleMatrix2D2.viewRow(i).assign(doubleMatrix1D2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int n8 = n5;
            while (--n8 >= 0) {
                doubleMatrix2D2.viewRow(n8).assign(doubleMatrix1D2);
            }
        }
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            n7 = Math.min(n7, n6);
            futureArray = new Future[n7];
            n4 = n6 / n7;
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = n3 * n4;
                n = n3 == n7 - 1 ? n6 : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            doubleMatrix2D2.viewColumn(i).assign(doubleMatrix1D, DoubleFunctions.mult);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int n9 = n6;
            while (--n9 >= 0) {
                doubleMatrix2D2.viewColumn(n9).assign(doubleMatrix1D, DoubleFunctions.mult);
            }
        }
        return doubleMatrix2D2;
    }

    public double norm1(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0L) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
    }

    public double norm1(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            d = Math.max(d, this.norm1(doubleMatrix2D.viewColumn(n)));
        }
        return d;
    }

    public double norm2(DoubleMatrix1D doubleMatrix1D) {
        return Math.sqrt(doubleMatrix1D.zDotProduct(doubleMatrix1D));
    }

    public double vectorNorm2(final DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.isView() || !(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            int n = doubleMatrix2D.rows();
            final int n2 = doubleMatrix2D.columns();
            double d = 0.0;
            int n3 = ConcurrencyUtils.getNumberOfThreads();
            if (n3 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n4;
                n3 = Math.min(n3, n);
                Future[] futureArray = new Future[n3];
                int n5 = n / n3;
                for (n4 = 0; n4 < n3; ++n4) {
                    final int n6 = n4 * n5;
                    final int n7 = n4 == n3 - 1 ? n : n6 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double d = 0.0;
                            for (int i = n6; i < n7; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    double d2 = doubleMatrix2D.getQuick(i, j);
                                    d += d2 * d2;
                                }
                            }
                            return d;
                        }
                    });
                }
                try {
                    for (n4 = 0; n4 < n3; ++n4) {
                        Double d2 = (Double)futureArray[n4].get();
                        d += d2.doubleValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        double d3 = doubleMatrix2D.getQuick(i, j);
                        d += d3 * d3;
                    }
                }
            }
            return Math.sqrt(d);
        }
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && dArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n8;
            n = Math.min(n, dArray.length);
            Future[] futureArray = new Future[n];
            int n9 = dArray.length / n;
            for (n8 = 0; n8 < n; ++n8) {
                final int n10 = n8 * n9;
                final int n11 = n8 == n - 1 ? dArray.length : n10 + n9;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n10; i < n11; ++i) {
                            d += dArray[i] * dArray[i];
                        }
                        return d;
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n; ++n8) {
                    Double d4 = (Double)futureArray[n8].get();
                    d += d4.doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return Math.sqrt(d);
    }

    public double vectorNorm2(final DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D.isView() || !(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            int n = doubleMatrix3D.slices();
            final int n2 = doubleMatrix3D.rows();
            final int n3 = doubleMatrix3D.columns();
            double d = 0.0;
            int n4 = ConcurrencyUtils.getNumberOfThreads();
            if (n4 > 1 && n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n5;
                n4 = Math.min(n4, n);
                Future[] futureArray = new Future[n4];
                int n6 = n / n4;
                for (n5 = 0; n5 < n4; ++n5) {
                    final int n7 = n5 * n6;
                    final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double d = 0.0;
                            for (int i = n7; i < n8; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    for (int k = 0; k < n3; ++k) {
                                        double d2 = doubleMatrix3D.getQuick(i, j, k);
                                        d += d2 * d2;
                                    }
                                }
                            }
                            return d;
                        }
                    });
                }
                try {
                    for (n5 = 0; n5 < n4; ++n5) {
                        Double d2 = (Double)futureArray[n5].get();
                        d += d2.doubleValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            double d3 = doubleMatrix3D.getQuick(i, j, k);
                            d += d3 * d3;
                        }
                    }
                }
            }
            return Math.sqrt(d);
        }
        final double[] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).elements();
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && dArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n9;
            n = Math.min(n, dArray.length);
            Future[] futureArray = new Future[n];
            int n10 = dArray.length / n;
            for (n9 = 0; n9 < n; ++n9) {
                final int n11 = n9 * n10;
                final int n12 = n9 == n - 1 ? dArray.length : n11 + n10;
                futureArray[n9] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n11; i < n12; ++i) {
                            d += dArray[i] * dArray[i];
                        }
                        return d;
                    }
                });
            }
            try {
                for (n9 = 0; n9 < n; ++n9) {
                    Double d4 = (Double)futureArray[n9].get();
                    d += d4.doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return Math.sqrt(d);
    }

    public double norm(DoubleMatrix2D doubleMatrix2D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(doubleMatrix2D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(doubleMatrix2D);
            }
            case One: {
                return DEFAULT.norm1(doubleMatrix2D);
            }
            case Two: {
                return DEFAULT.norm2(doubleMatrix2D);
            }
        }
        return 0.0;
    }

    public double norm(DoubleMatrix1D doubleMatrix1D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(doubleMatrix1D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(doubleMatrix1D);
            }
            case One: {
                return DEFAULT.norm1(doubleMatrix1D);
            }
            case Two: {
                return DEFAULT.norm2(doubleMatrix1D);
            }
        }
        return 0.0;
    }

    public double norm2(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).norm2();
    }

    public double normF(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.size() == 0L) {
            return 0.0;
        }
        return doubleMatrix2D.aggregate(DenseDoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normF(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0L) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DenseDoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normInfinity(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0L) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DoubleFunctions.max, DoubleFunctions.abs);
    }

    public double normInfinity(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            d = Math.max(d, this.norm1(doubleMatrix2D.viewRow(n)));
        }
        return d;
    }

    public DoubleMatrix1D permute(DoubleMatrix1D doubleMatrix1D, int[] nArray, double[] dArray) {
        int n = (int)doubleMatrix1D.size();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (dArray == null || n > dArray.length) {
            dArray = doubleMatrix1D.toArray();
        } else {
            doubleMatrix1D.toArray(dArray);
        }
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1D.setQuick(n2, dArray[nArray[n2]]);
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix2D permute(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return doubleMatrix2D.viewSelection(nArray, nArray2);
    }

    public DoubleMatrix2D permuteColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return this.permuteRows(doubleMatrix2D.viewDice(), nArray, nArray2);
    }

    public DoubleMatrix2D permuteRows(final DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        int n = doubleMatrix2D.rows();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int n2 = doubleMatrix2D.columns();
        if (n2 < n / 10) {
            double[] dArray = new double[n];
            int n3 = doubleMatrix2D.columns();
            while (--n3 >= 0) {
                this.permute(doubleMatrix2D.viewColumn(n3), nArray, dArray);
            }
            return doubleMatrix2D;
        }
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                doubleMatrix2D.viewRow(n).swap(doubleMatrix2D.viewRow(n2));
            }
        };
        GenericPermuting.permute(nArray, swapper, nArray2, null);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2;
        int n2;
        SmpDoubleBlas smpDoubleBlas = new SmpDoubleBlas();
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        if (n < 0) {
            doubleMatrix2D = this.inverse(doubleMatrix2D);
            n = -n;
        }
        if (n == 0) {
            return DoubleFactory2D.dense.identity(doubleMatrix2D.rows());
        }
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.like();
        if (n == 1) {
            return doubleMatrix2D3.assign(doubleMatrix2D);
        }
        if (n == 2) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            return doubleMatrix2D3;
        }
        int n3 = QuickBitVector.mostSignificantBit(n);
        for (n2 = 0; n2 <= n3 && (n & 1 << n2) == 0; ++n2) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            doubleMatrix2D2 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D2;
        }
        doubleMatrix2D2 = doubleMatrix2D.copy();
        ++n2;
        while (n2 <= n3) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D4;
            if ((n & 1 << n2) != 0) {
                smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D2, doubleMatrix2D, 0.0, doubleMatrix2D3);
                doubleMatrix2D4 = doubleMatrix2D2;
                doubleMatrix2D2 = doubleMatrix2D3;
                doubleMatrix2D3 = doubleMatrix2D4;
            }
            ++n2;
        }
        return doubleMatrix2D2;
    }

    public DoubleProperty property() {
        return this.property;
    }

    public DenseDoubleQRDecomposition qr(DoubleMatrix2D doubleMatrix2D) {
        return new DenseDoubleQRDecomposition(doubleMatrix2D);
    }

    public int rank(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).rank();
    }

    public void setProperty(DoubleProperty doubleProperty) {
        if (this == DEFAULT && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = doubleProperty;
    }

    public DoubleMatrix1D backwardSolve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix2D.rows();
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        doubleMatrix1D2.setQuick(n - 1, doubleMatrix1D.getQuick(n - 1) / doubleMatrix2D.getQuick(n - 1, n - 1));
        for (int i = n - 2; i >= 0; --i) {
            double d = doubleMatrix2D.viewRow(i).zDotProduct(doubleMatrix1D2);
            doubleMatrix1D2.setQuick(i, (doubleMatrix1D.getQuick(i) - d) / doubleMatrix2D.getQuick(i, i));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D forwardSolve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix2D.rows();
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        doubleMatrix1D2.setQuick(0, doubleMatrix1D.getQuick(0) / doubleMatrix2D.getQuick(0, 0));
        for (int i = 1; i < n; ++i) {
            double d = doubleMatrix2D.viewRow(i).zDotProduct(doubleMatrix1D2);
            doubleMatrix1D2.setQuick(i, (doubleMatrix1D.getQuick(i) - d) / doubleMatrix2D.getQuick(i, i));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix2D.rows() == doubleMatrix2D.columns()) {
            return this.lu(doubleMatrix2D).solve(doubleMatrix1D);
        }
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.copy();
        this.qr(doubleMatrix2D).solve(doubleMatrix1D2);
        return doubleMatrix1D2.viewPart(0, doubleMatrix2D.columns()).copy();
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        if (doubleMatrix2D.rows() == doubleMatrix2D.columns()) {
            return this.lu(doubleMatrix2D).solve(doubleMatrix2D2);
        }
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.copy();
        this.qr(doubleMatrix2D).solve(doubleMatrix2D3);
        return doubleMatrix2D3.viewPart(0, 0, doubleMatrix2D.columns(), doubleMatrix2D2.columns()).copy();
    }

    public DoubleMatrix2D solveTranspose(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return this.solve(this.transpose(doubleMatrix2D), this.transpose(doubleMatrix2D2));
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int[] nArray, int n, int n2) {
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.rows();
        doubleMatrix2D = doubleMatrix2D.viewPart(0, n, n4, n3);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(nArray.length, n3);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewRow(n5).assign(doubleMatrix2D.viewRow(n6));
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int[] nArray) {
        if (n2 - n >= doubleMatrix2D.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.columns();
        doubleMatrix2D = doubleMatrix2D.viewPart(n, 0, n3, n4);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(n3, nArray.length);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewColumn(n5).assign(doubleMatrix2D.viewColumn(n6));
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int n3, int n4) {
        return doubleMatrix2D.viewPart(n, n3, n2 - n + 1, n4 - n3 + 1);
    }

    public DenseDoubleSingularValueDecomposition svd(DoubleMatrix2D doubleMatrix2D) {
        return new DenseDoubleSingularValueDecomposition(doubleMatrix2D, true, true);
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("cond");
        try {
            objectArrayList2.add(String.valueOf(this.cond(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("det");
        try {
            objectArrayList2.add(String.valueOf(this.det(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm1");
        try {
            objectArrayList2.add(String.valueOf(this.norm1(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm2");
        try {
            objectArrayList2.add(String.valueOf(this.norm2(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normF");
        try {
            objectArrayList2.add(String.valueOf(this.normF(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normInfinity");
        try {
            objectArrayList2.add(String.valueOf(this.normInfinity(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("rank");
        try {
            objectArrayList2.add(String.valueOf(this.rank(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("trace");
        try {
            objectArrayList2.add(String.valueOf(this.trace(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return DoubleProperty.get(objectArrayList, n).compareTo(DoubleProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(DoubleProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toVerboseString(DoubleMatrix2D doubleMatrix2D) {
        String string = "Illegal operation or error upon construction of ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A = ");
        stringBuffer.append(doubleMatrix2D);
        stringBuffer.append("\n\n" + this.toString(doubleMatrix2D));
        stringBuffer.append("\n\n" + DoubleProperty.DEFAULT.toString(doubleMatrix2D));
        DenseDoubleLUDecomposition denseDoubleLUDecomposition = null;
        try {
            denseDoubleLUDecomposition = new DenseDoubleLUDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " LUDecomposition: " + illegalArgumentException.getMessage());
        }
        if (denseDoubleLUDecomposition != null) {
            stringBuffer.append("\n\n" + denseDoubleLUDecomposition.toString());
        }
        DenseDoubleQRDecomposition denseDoubleQRDecomposition = null;
        try {
            denseDoubleQRDecomposition = new DenseDoubleQRDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " QRDecomposition: " + illegalArgumentException.getMessage());
        }
        if (denseDoubleQRDecomposition != null) {
            stringBuffer.append("\n\n" + denseDoubleQRDecomposition.toString());
        }
        DenseDoubleCholeskyDecomposition denseDoubleCholeskyDecomposition = null;
        try {
            denseDoubleCholeskyDecomposition = new DenseDoubleCholeskyDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " CholeskyDecomposition: " + illegalArgumentException.getMessage());
        }
        if (denseDoubleCholeskyDecomposition != null) {
            stringBuffer.append("\n\n" + denseDoubleCholeskyDecomposition.toString());
        }
        DenseDoubleEigenvalueDecomposition denseDoubleEigenvalueDecomposition = null;
        try {
            denseDoubleEigenvalueDecomposition = new DenseDoubleEigenvalueDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " EigenvalueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (denseDoubleEigenvalueDecomposition != null) {
            stringBuffer.append("\n\n" + denseDoubleEigenvalueDecomposition.toString());
        }
        DenseDoubleSingularValueDecomposition denseDoubleSingularValueDecomposition = null;
        try {
            denseDoubleSingularValueDecomposition = new DenseDoubleSingularValueDecomposition(doubleMatrix2D, true, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " SingularValueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (denseDoubleSingularValueDecomposition != null) {
            stringBuffer.append("\n\n" + denseDoubleSingularValueDecomposition.toString());
        }
        return stringBuffer.toString();
    }

    public double trace(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n >= 0) {
            d += doubleMatrix2D.getQuick(n, n);
        }
        return d;
    }

    public DoubleMatrix2D transpose(DoubleMatrix2D doubleMatrix2D) {
        return doubleMatrix2D.viewDice();
    }

    public DoubleMatrix2D trapezoidalLower(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 >= n4) continue;
                doubleMatrix2D.setQuick(n3, n4, 0.0);
            }
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D xmultOuter(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        DoubleMatrix2D doubleMatrix2D = doubleMatrix1D.like2D((int)doubleMatrix1D.size(), (int)doubleMatrix1D2.size());
        this.multOuter(doubleMatrix1D, doubleMatrix1D2, doubleMatrix2D);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D xpowSlow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        for (int i = 0; i < n - 1; ++i) {
            doubleMatrix2D2 = this.mult(doubleMatrix2D2, doubleMatrix2D);
        }
        return doubleMatrix2D2;
    }

    static {
        DenseDoubleAlgebra.DEFAULT.property = DoubleProperty.DEFAULT;
        ZERO = new DenseDoubleAlgebra();
        DenseDoubleAlgebra.ZERO.property = DoubleProperty.ZERO;
    }
}

