/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tlong;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tlong.LongIntProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractLongIntMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractLongIntMap() {
    }

    public void assign(final IntFunction intFunction) {
        this.copy().forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n) {
                AbstractLongIntMap.this.put(l, intFunction.apply(n));
                return true;
            }
        });
    }

    public void assign(AbstractLongIntMap abstractLongIntMap) {
        this.clear();
        abstractLongIntMap.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n) {
                AbstractLongIntMap.this.put(l, n);
                return true;
            }
        });
    }

    public boolean containsKey(final long l) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long l2) {
                return l != l2;
            }
        });
    }

    public boolean containsValue(final int n) {
        return !this.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n2) {
                return n != n2;
            }
        });
    }

    public AbstractLongIntMap copy() {
        return (AbstractLongIntMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractLongIntMap)) {
            return false;
        }
        final AbstractLongIntMap abstractLongIntMap = (AbstractLongIntMap)object;
        if (abstractLongIntMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n) {
                return abstractLongIntMap.containsKey(l) && abstractLongIntMap.get(l) == n;
            }
        }) && abstractLongIntMap.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n) {
                return AbstractLongIntMap.this.containsKey(l) && AbstractLongIntMap.this.get(l) == n;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongIntProcedure longIntProcedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                return longIntProcedure.apply(l, AbstractLongIntMap.this.get(l));
            }
        });
    }

    public abstract int get(long var1);

    public long keyOf(final int n) {
        final long[] lArray = new long[1];
        boolean bl = this.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n2) {
                boolean bl;
                boolean bl2 = bl = n == n2;
                if (bl) {
                    lArray[0] = l;
                }
                return !bl;
            }
        });
        if (bl) {
            return Long.MIN_VALUE;
        }
        return lArray[0];
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.keys(longArrayList);
        return longArrayList;
    }

    public void keys(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(l);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList longArrayList) {
        this.pairsSortedByValue(longArrayList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final LongIntProcedure longIntProcedure, final LongArrayList longArrayList, final IntArrayList intArrayList) {
        longArrayList.clear();
        intArrayList.clear();
        this.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n) {
                if (longIntProcedure.apply(l, n)) {
                    longArrayList.add(l);
                    intArrayList.add(n);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList longArrayList, IntArrayList intArrayList) {
        this.keys(longArrayList);
        longArrayList.sort();
        intArrayList.setSize(longArrayList.size());
        int n = longArrayList.size();
        while (--n >= 0) {
            intArrayList.setQuick(n, this.get(longArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(LongArrayList longArrayList, IntArrayList intArrayList) {
        this.keys(longArrayList);
        this.values(intArrayList);
        final long[] lArray = longArrayList.elements();
        final int[] nArray = intArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return nArray[n] < nArray[n2] ? -1 : (nArray[n] > nArray[n2] ? 1 : (lArray[n] < lArray[n2] ? -1 : (lArray[n] == lArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, longArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(long var1, int var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList longArrayList = this.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        LongArrayList longArrayList = new LongArrayList();
        this.keysSortedByValue(longArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IntArrayList values() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.values(intArrayList);
        return intArrayList;
    }

    public void values(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                intArrayList.add(AbstractLongIntMap.this.get(l));
                return true;
            }
        });
    }
}

