/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBufferConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer
extends PersistentObject
implements LongBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBufferConsumer target;
    protected long[] elements;
    protected LongArrayList list;
    protected int capacity;
    protected int size;

    public LongBuffer(LongBufferConsumer longBufferConsumer, int n) {
        this.target = longBufferConsumer;
        this.capacity = n;
        this.elements = new long[n];
        this.list = new LongArrayList(this.elements);
        this.size = 0;
    }

    public void add(long l) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = l;
    }

    public void addAllOf(LongArrayList longArrayList) {
        int n = longArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(longArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

