/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBuffer3DConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer3D
extends PersistentObject
implements ByteBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBuffer3DConsumer target;
    protected byte[] xElements;
    protected byte[] yElements;
    protected byte[] zElements;
    protected ByteArrayList xList;
    protected ByteArrayList yList;
    protected ByteArrayList zList;
    protected int capacity;
    protected int size;

    public ByteBuffer3D(ByteBuffer3DConsumer byteBuffer3DConsumer, int n) {
        this.target = byteBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new byte[n];
        this.yElements = new byte[n];
        this.zElements = new byte[n];
        this.xList = new ByteArrayList(this.xElements);
        this.yList = new ByteArrayList(this.yElements);
        this.zList = new ByteArrayList(this.zElements);
        this.size = 0;
    }

    public void add(byte by, byte by2, byte by3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = by;
        this.yElements[this.size] = by2;
        this.zElements[this.size++] = by3;
    }

    public void addAllOf(ByteArrayList byteArrayList, ByteArrayList byteArrayList2, ByteArrayList byteArrayList3) {
        int n = byteArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(byteArrayList, byteArrayList2, byteArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

