/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.featureExtraction;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.ohdsi.featureExtraction.StringUtilities;

public class ReadCSVFile
implements Iterable<List<String>> {
    protected BufferedReader bufferedReader;
    public boolean EOF = false;
    private char delimiter = (char)44;

    public ReadCSVFile(String filename, char delimiter) {
        this(filename);
        this.delimiter = delimiter;
    }

    public ReadCSVFile(String filename) {
        try {
            FileInputStream textFileStream = new FileInputStream(filename);
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)textFileStream, "ISO-8859-1"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public ReadCSVFile(InputStream inputstream, char delimiter) {
        this(inputstream);
        this.delimiter = delimiter;
    }

    public ReadCSVFile(InputStream inputstream) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader(inputstream, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public Iterator<List<String>> getIterator() {
        return this.iterator();
    }

    @Override
    public Iterator<List<String>> iterator() {
        return new CSVFileIterator();
    }

    private List<String> line2columns(String line) {
        List<String> columns = StringUtilities.safeSplit(line, this.delimiter);
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            if (column.startsWith("\"") && column.endsWith("\"") && column.length() > 1) {
                column = column.substring(1, column.length() - 1);
            }
            column = column.replace("\\\"", "\"");
            column = column.replaceAll("\\\\\\\\", "\\\\");
            columns.set(i, column);
        }
        return columns;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    private class CSVFileIterator
    implements Iterator<List<String>> {
        private String buffer;

        public CSVFileIterator() {
            try {
                this.buffer = ReadCSVFile.this.bufferedReader.readLine();
                if (this.buffer == null) {
                    ReadCSVFile.this.EOF = true;
                    ReadCSVFile.this.bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            return !ReadCSVFile.this.EOF;
        }

        @Override
        public List<String> next() {
            String result = this.buffer;
            try {
                this.buffer = ReadCSVFile.this.bufferedReader.readLine();
                if (this.buffer == null) {
                    ReadCSVFile.this.EOF = true;
                    ReadCSVFile.this.bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ReadCSVFile.this.line2columns(result);
        }

        @Override
        public void remove() {
            System.err.println("Unimplemented method 'remove' called");
        }
    }
}

