/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.menu.MergeData;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class MergeDialog
extends JDialog
implements ActionListener {
    private JList dataList;
    private JLabel data1;
    private JLabel newDataLabel;
    private JTextField newName;
    private JList jList1;
    private JLabel data2;
    private OkayCancelPanel okcan;
    private static String lastSelected1;
    private static String lastSelected2;
    private static String lastNewData;
    private HelpButton help;

    public MergeDialog() {
        this.initGUI();
    }

    public MergeDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            RController.refreshObjects();
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.setTitle("Merge Data");
            this.newName = new JTextField();
            this.getContentPane().add((Component)this.newName, new AnchorConstraint(855, 428, 945, 110, 1, 1, 1, 1));
            if (lastNewData == null) {
                this.newName.setText(Deducer.getUniqueName("data.merged"));
            } else {
                this.newName.setText(lastNewData);
            }
            this.newName.setPreferredSize(new Dimension(166, 22));
            this.newDataLabel = new JLabel();
            this.getContentPane().add((Component)this.newDataLabel, new AnchorConstraint(766, 428, 827, 110, 1, 1, 1, 1));
            this.newDataLabel.setText("Merged Data Name:");
            this.newDataLabel.setPreferredSize(new Dimension(166, 15));
            this.okcan = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okcan, new AnchorConstraint(827, 931, 977, 488, 1, 1, 1, 1));
            Serializable serializable = this.okcan.getApproveButton();
            serializable.setText("Continue");
            serializable.setActionCommand("mergedata");
            this.data2 = new JLabel();
            this.getContentPane().add((Component)this.data2, new AnchorConstraint(136, 972, 176, 569, 1, 1, 0, 0));
            this.data2.setText("Select Second Data Frame");
            this.data2.setPreferredSize(new Dimension(186, 15));
            serializable = new DefaultComboBoxModel();
            for (int i = 0; i < Deducer.DATA.size(); ++i) {
                ((DefaultComboBoxModel)serializable).addElement(((RObject)Deducer.DATA.elementAt(i)).getName());
            }
            this.jList1 = new JList();
            JScrollPane jScrollPane = new JScrollPane(this.jList1, 22, 31);
            this.getContentPane().add((Component)jScrollPane, new AnchorConstraint(197, 926, 72, 569, 1, 1, 2, 0));
            this.jList1.setModel(serializable);
            this.jList1.setPreferredSize(new Dimension(149, 126));
            this.jList1.setSelectionMode(0);
            this.data1 = new JLabel();
            this.getContentPane().add((Component)this.data1, new AnchorConstraint(135, 444, 176, 29, 1, 0, 0, 1));
            this.data1.setText("Select First Data Frame:");
            this.data1.setPreferredSize(new Dimension(173, 15));
            serializable = new DefaultComboBoxModel();
            for (int i = 0; i < Deducer.DATA.size(); ++i) {
                ((DefaultComboBoxModel)serializable).addElement(((RObject)Deducer.DATA.elementAt(i)).getName());
            }
            this.dataList = new JList();
            JScrollPane jScrollPane2 = new JScrollPane(this.dataList, 22, 31);
            this.getContentPane().add((Component)jScrollPane2, new AnchorConstraint(197, 447, 72, 13, 1, 0, 2, 2));
            this.dataList.setModel(serializable);
            this.dataList.setPreferredSize(new Dimension(147, 126));
            this.dataList.setSelectionMode(0);
            if (lastSelected1 != null && lastSelected2 != null) {
                this.dataList.setSelectedValue(lastSelected1, true);
                this.jList1.setSelectedValue(lastSelected2, true);
            }
            this.help = new HelpButton("pmwiki.php?n=Main.MergeData");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(135, 444, 965, 12, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.pack();
            this.setResizable(false);
            this.setSize(430, 268);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "mergedata") {
            if (!this.newName.getText().startsWith("data.merged")) {
                lastNewData = this.newName.getText();
            }
            lastSelected1 = (String)this.dataList.getSelectedValue();
            lastSelected2 = (String)this.jList1.getSelectedValue();
            if (lastSelected1 == null || lastSelected2 == null || lastSelected1.equals(lastSelected2)) {
                JOptionPane.showMessageDialog(this, "Please Select Two Unique Data Frames to Merge");
                return;
            }
            MergeData mergeData = new MergeData(this.newName.getText(), lastSelected1, lastSelected2);
            mergeData.setLocationRelativeTo(this);
            mergeData.setVisible(true);
            WindowTracker.addWindow(mergeData);
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        }
    }
}

