## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ConFluxPro)

## -----------------------------------------------------------------------------
data("base_dat", package = "ConFluxPro")
mod_pf <- pro_flux(base_dat)

## ----cfp_run_map--------------------------------------------------------------
tps_run_map <- 
  cfp_run_map(mod_pf,
              params = list("TPS" = c(0.9, 1.1)),
              type = "factor",
              method = "random",
              n_runs = 100)

## ----rmap-df------------------------------------------------------------------
head(tps_run_map)

## ----rmap-layers--------------------------------------------------------------
tps_run_map <- 
  cfp_run_map(mod_pf,
              params = list("TPS" = c(0.9, 1.1)),
              type = "factor",
              method = "random",
              n_runs = 100,
              layers_different = TRUE)

## ----rmap-layers-head---------------------------------------------------------
head(tps_run_map)

## ----rmap-params_df-----------------------------------------------------------
cfp_params_df(tps_run_map)

## -----------------------------------------------------------------------------
library(dplyr)
unique_tps <- 
  cfp_soilphys(mod_pf) %>%
  group_by(site, TPS) %>%
  summarise(upper = max(upper),
         lower = min(lower)) %>%
  cfp_layers_map(id_cols = "site",
                 gas = "CO2",
                 lowlim = 0, highlim = 1000)

tps_run_map <- 
  cfp_run_map(mod_pf,
              params = list("TPS" = c(0.9, 1.1)),
              type = "factor",
              method = "random",
              n_runs = 100,
              layers_different = TRUE,
              layers_from = "layers_altmap",
              layers_altmap = unique_tps)

## -----------------------------------------------------------------------------
cfp_params_df(tps_run_map)

## -----------------------------------------------------------------------------
unique_tps_with_limits <- 
  unique_tps %>%
  mutate(TPS_delta = ifelse(lower <= -20, 0.02, 0.04)) %>%
  mutate(TPS_min = TPS - TPS_delta,
         TPS_max = TPS + TPS_delta)

## -----------------------------------------------------------------------------
tps_run_map <- 
  cfp_run_map(mod_pf,
              params = list("TPS" = c("TPS_min", "TPS_max")),
              type = "abs",
              method = "random",
              n_runs = 100,
              layers_different = TRUE,
              layers_from = "layers_altmap",
              layers_altmap = unique_tps_with_limits)

## ----call-alternate-----------------------------------------------------------
mod_pf_alt <- alternate(
  mod_pf,
  f = function(x) complete_soilphys(x, DSD0_formula = "a*AFPS^b", quiet = TRUE),
  run_map = tps_run_map
)

## -----------------------------------------------------------------------------
efflux(mod_pf_alt[[3]]) |>
  head()

## -----------------------------------------------------------------------------
EFFLUX_alt <-
  efflux(mod_pf_alt) 
EFFLUX_alt |>
  head()

## -----------------------------------------------------------------------------
library(ggplot2)
EFFLUX_alt %>%
  ggplot(aes(x = Date, 
             y = efflux, 
             group = run_id,
             col = "modified models"))+
  geom_line(alpha = 0.2)+
  geom_line(data = efflux(mod_pf),
            aes(group = NA, col = "original model"))+
  facet_wrap(~site, ncol = 1)+
  theme_light()+
  theme(legend.position = "bottom")


## -----------------------------------------------------------------------------
EFFLUX_ref <- efflux(mod_pf)

## -----------------------------------------------------------------------------
mod_pf_eval <- evaluate_models(mod_pf_alt,
                               eval_funs = list(
                                 "error_concentration" = error_concentration,
                                 "error_efflux" = error_efflux),
                               eval_weights = c(1, 1),
                               param_cols = c("site"), 
                               eval_cols = c("site"),
                               n_best = 5,
                               scaling_fun = scale_min_median,
                               EFFLUX = EFFLUX_ref)

## -----------------------------------------------------------------------------
mod_pf_eval$best_runs

## -----------------------------------------------------------------------------
mod_pf_eval$model_error |>
  head()

## -----------------------------------------------------------------------------
mod_pf_eval$models_evaluated |>
  head()

## -----------------------------------------------------------------------------
calibrated_run_map <- mod_pf_eval$best_runs_runmap

## -----------------------------------------------------------------------------
mod_pf_cal_list <- alternate(
  mod_pf,
  f = function(x) complete_soilphys(x, DSD0_formula = "a*AFPS^b", quiet = TRUE),
  run_map = calibrated_run_map
)

## -----------------------------------------------------------------------------
mod_pf_cal <- combine_models(mod_pf_cal_list)
mod_pf_cal

