/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Report;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Check {
    private static final Pattern doublePattern = Pattern.compile("[-+]?\\d+(\\.\\d+)?");
    private final Report report;
    private static final double tolerance = 1.0E-6;
    private static final String CHECK = "check";
    private static final String REGEX = "regex";
    private static final String MATCH = "match";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Report report = (Report)xMLObject.getChild(Report.class);
            List<XMLObject> list = xMLObject.getAllChildren(Check.MATCH);
            int n = list.size();
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                XMLObject xMLObject2 = list.get(i);
                stringArray[i] = (String)xMLObject2.getAttribute(Check.REGEX);
                stringArray2[i] = xMLObject2.getStringChild(0);
            }
            return new Check(report, stringArray, stringArray2);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return null;
        }

        @Override
        public String getParserName() {
            return Check.CHECK;
        }
    };
    private static final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Report.class), new ElementRule("match", new XMLSyntaxRule[]{AttributeRule.newStringRule("regex")}, 1, Integer.MAX_VALUE)};

    public Check(Report report, String[] stringArray, String[] stringArray2) {
        this.report = report;
        String string = this.getReportAsString();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.parseDoubleRegex(string, stringArray[i]);
            boolean bl = this.checkEqualsDouble(string2, stringArray2[i]);
            if (bl) continue;
            this.failCheck(stringArray[i], string2, stringArray2[i]);
        }
    }

    private void failCheck(String string, String string2, String string3) {
        System.out.println("Report returned " + string2 + " for " + string + ". The true value is " + string3 + ".");
        System.exit(-1);
    }

    private boolean checkEqualsDouble(String string, String string2) {
        double d;
        double d2 = Double.parseDouble(string);
        return !(Math.abs(d2 - (d = Double.parseDouble(string2))) > 1.0E-6);
    }

    private String getReportAsString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.report.setOutput(printWriter);
        this.report.createReport();
        return stringWriter.toString();
    }

    private String parseDoubleRegex(String string, String string2) {
        Pattern pattern = this.stringMatchPattern(string2);
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        if (matcher.end() == -1) {
            throw new RuntimeException("Did not find \"" + string2 + "\" in the report.");
        }
        Matcher matcher2 = doublePattern.matcher(string);
        matcher2.find(matcher.end());
        int n = matcher2.start();
        int n2 = matcher2.end();
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        string.getChars(n, n2, cArray, 0);
        String string3 = new String(cArray);
        return string3;
    }

    private Pattern stringMatchPattern(String string) {
        String string2 = "\\s+" + string + "[\\s+|:]";
        return Pattern.compile(string2);
    }
}

