/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.math.matrixAlgebra.Matrix;
import dr.xml.XMLObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.util.FastMath;

public interface Transform {
    public static final NoTransform NONE = new NoTransform();
    public static final LogTransform LOG = new LogTransform();
    public static final ExpTransform EXP = new ExpTransform();
    public static final NegateTransform NEGATE = new NegateTransform();
    public static final SquaredTransform SQUARED = new SquaredTransform();
    public static final AbsTransform ABS = new AbsTransform();
    public static final Compose LOG_NEGATE = new Compose(new LogTransform(), new NegateTransform());
    public static final LogConstrainedSumTransform LOG_CONSTRAINED_SUM = new LogConstrainedSumTransform();
    public static final LogitTransform LOGIT = new LogitTransform();
    public static final SigmoidTransform SIGMOID = new SigmoidTransform();
    public static final FisherZTransform FISHER_Z = new FisherZTransform();
    public static final AffineTransform AFFINE = new AffineTransform();

    public double transform(double var1);

    public double[] transform(double[] var1, int var2, int var3);

    public double inverse(double var1);

    public double[] inverse(double[] var1, int var2, int var3);

    public double[] inverse(double[] var1, int var2, int var3, double var4);

    public double updateGradientLogDensity(double var1, double var3);

    public double[] updateGradientLogDensity(double[] var1, double[] var2, int var3, int var4);

    public double updateDiagonalHessianLogDensity(double var1, double var3, double var5);

    public double[] updateDiagonalHessianLogDensity(double[] var1, double[] var2, double[] var3, int var4, int var5);

    public double[][] updateHessianLogDensity(double[][] var1, double[][] var2, double[] var3, double[] var4, int var5, int var6);

    public double updateOffdiagonalHessianLogDensity(double var1, double var3, double var5, double var7, double var9, double var11);

    public double updateGradientInverseUnWeightedLogDensity(double var1, double var3);

    public double[] updateGradientInverseUnWeightedLogDensity(double[] var1, double[] var2, int var3, int var4);

    public double updateGradientUnWeightedLogDensity(double var1, double var3);

    public double[] updateGradientUnWeightedLogDensity(double[] var1, double[] var2, int var3, int var4);

    public double gradient(double var1);

    public double[] gradient(double[] var1, int var2, int var3);

    default public double gradientLogJacobianInverse(double d) {
        throw new RuntimeException("Not implemented");
    }

    public double gradientInverse(double var1);

    public double[] gradientInverse(double[] var1, int var2, int var3);

    public double logGradientInverse(double var1);

    public double[] logGradientInverse(double[] var1, int var2, int var3);

    public double derivativeOfTransformWrtValue(double var1);

    public double[] derivativeOfTransformWrtValue(double[] var1, int var2, int var3);

    public double secondDerivativeOfTransformWrtValue(double var1);

    public double[] secondDerivativeOfTransformWrtValue(double[] var1, int var2, int var3);

    public double secondDerivativeOfInverseTransformWrtValue(double var1);

    public double[] secondDerivativeOfInverseTransformWrtValue(double[] var1, int var2, int var3);

    public double logSecondDerivativeOfInverseTransformWrtValue(double var1);

    public double[] logSecondDerivativeOfInverseTransformWrtValue(double[] var1, int var2, int var3);

    default public Transform inverseTransform() {
        throw new RuntimeException("Not yet implemented");
    }

    public String getTransformName();

    public double logJacobian(double var1);

    public double logJacobian(double[] var1, int var2, int var3);

    public boolean isMultivariate();

    public boolean isInInteriorDomain(double var1);

    public boolean isInInteriorDomain(double[] var1, int var2, int var3);

    public static class NoTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            return NONE;
        }

        @Override
        public double transform(double d) {
            return d;
        }

        @Override
        public double inverse(double d) {
            return d;
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return true;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return d;
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return 0.0;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            return d;
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            return d;
        }

        @Override
        public double gradient(double d) {
            return 1.0;
        }

        @Override
        public double gradientInverse(double d) {
            return 1.0;
        }

        @Override
        public double logGradientInverse(double d) {
            return 0.0;
        }

        @Override
        public String getTransformName() {
            return "none";
        }

        @Override
        public double logJacobian(double d) {
            return 0.0;
        }

        @Override
        public double derivativeOfTransformWrtValue(double d) {
            return 1.0;
        }

        @Override
        public double secondDerivativeOfTransformWrtValue(double d) {
            return 0.0;
        }

        @Override
        public double secondDerivativeOfInverseTransformWrtValue(double d) {
            return 0.0;
        }

        @Override
        public double logSecondDerivativeOfInverseTransformWrtValue(double d) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    public static class LogTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            return EXP;
        }

        @Override
        public double transform(double d) {
            return Math.log(d);
        }

        @Override
        public double inverse(double d) {
            return Math.exp(d);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return d > 0.0 && !Double.isInfinite(d);
        }

        @Override
        public double gradientInverse(double d) {
            return Math.exp(d);
        }

        @Override
        public double logGradientInverse(double d) {
            return d;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return d * d2 + 1.0;
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return 1.0;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            return d3 * (d2 + d3 * d);
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            return d * d5 * d6 + d4 * d2;
        }

        @Override
        public double gradient(double d) {
            return d;
        }

        @Override
        public String getTransformName() {
            return "log";
        }

        @Override
        public double logJacobian(double d) {
            return -Math.log(d);
        }

        @Override
        public double derivativeOfTransformWrtValue(double d) {
            return 1.0 / d;
        }

        @Override
        public double secondDerivativeOfTransformWrtValue(double d) {
            return -1.0 / (d * d);
        }

        @Override
        public double secondDerivativeOfInverseTransformWrtValue(double d) {
            return Math.exp(d);
        }

        @Override
        public double logSecondDerivativeOfInverseTransformWrtValue(double d) {
            return d;
        }
    }

    public static class ExpTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            return LOG;
        }

        @Override
        public double transform(double d) {
            return Math.exp(d);
        }

        @Override
        public double inverse(double d) {
            return Math.log(d);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return !Double.isInfinite(d);
        }

        @Override
        public double gradientInverse(double d) {
            return 1.0 / d;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            double d3 = this.transform(d2);
            double d4 = this.gradientInverse(d3);
            return d * d4 + this.gradientLogJacobianInverse(d3);
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return -1.0 / d;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return Math.exp(d);
        }

        @Override
        public String getTransformName() {
            return "exp";
        }

        @Override
        public double logJacobian(double d) {
            return d;
        }
    }

    public static class NegateTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            return NEGATE;
        }

        @Override
        public double transform(double d) {
            return -d;
        }

        @Override
        public double inverse(double d) {
            return -d;
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return true;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return -d;
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return 0.0;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return -1.0;
        }

        @Override
        public double gradientInverse(double d) {
            return -1.0;
        }

        @Override
        public String getTransformName() {
            return "negate";
        }

        @Override
        public double logJacobian(double d) {
            return 0.0;
        }
    }

    public static class SquaredTransform
    extends UnivariableTransform {
        Transform inverse;

        @Override
        public Transform inverseTransform() {
            if (this.inverse == null) {
                this.inverse = new PowerTransform(0.0);
            }
            return this.inverse;
        }

        @Override
        public double transform(double d) {
            return d * d;
        }

        @Override
        public double inverse(double d) {
            return Math.sqrt(d);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return !Double.isInfinite(d);
        }

        @Override
        public double gradientInverse(double d) {
            return 0.5 / d;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            double d3 = this.transform(d2);
            double d4 = this.gradientInverse(d3);
            return d * d4 + this.gradientLogJacobianInverse(d3);
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("Mot yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return 2.0 * d;
        }

        @Override
        public String getTransformName() {
            return "squared";
        }

        @Override
        public double logJacobian(double d) {
            return Math.log(2.0 * d);
        }
    }

    public static class AbsTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            throw new RuntimeException("Not defined");
        }

        @Override
        public double transform(double d) {
            return Math.abs(d);
        }

        @Override
        public double inverse(double d) {
            throw new RuntimeException("Not defined");
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return !Double.isInfinite(d);
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("Not defined");
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("Mot yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            if (d > 0.0) {
                return 1.0;
            }
            if (d < 0.0) {
                return -1.0;
            }
            return Double.NaN;
        }

        @Override
        public String getTransformName() {
            return "abs";
        }

        @Override
        public double logJacobian(double d) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public static class Compose
    extends UnivariableTransform {
        private final UnivariableTransform outer;
        private final UnivariableTransform inner;

        public Compose(UnivariableTransform univariableTransform, UnivariableTransform univariableTransform2) {
            this.outer = univariableTransform;
            this.inner = univariableTransform2;
        }

        @Override
        public String getTransformName() {
            return "compose." + this.outer.getTransformName() + "." + this.inner.getTransformName();
        }

        @Override
        public double transform(double d) {
            double d2 = this.inner.transform(d);
            double d3 = this.outer.transform(d2);
            return d3;
        }

        @Override
        public double inverse(double d) {
            return this.inner.inverse(this.outer.inverse(d));
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return this.inner.isInInteriorDomain(d);
        }

        @Override
        public double gradientInverse(double d) {
            return this.inner.gradientInverse(d) * this.outer.gradientInverse(this.inner.transform(d));
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return this.outer.updateGradientLogDensity(this.inner.updateGradientLogDensity(d, d2), this.inner.transform(d2));
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double logJacobian(double d) {
            return this.inner.logJacobian(d) + this.outer.logJacobian(this.inner.transform(d));
        }
    }

    public static abstract class UnivariableTransform
    implements Transform {
        @Override
        public abstract double transform(double var1);

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.transform(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public abstract double inverse(double var1);

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.inverse(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Fixed sum cannot be enforced for a univariate transformation.");
        }

        @Override
        public abstract double gradientInverse(double var1);

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.gradientInverse(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return this.updateGradientInverseUnWeightedLogDensity(d, this.transform(d2)) + this.gradientLogJacobianInverse(this.transform(d2));
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.updateGradientLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            double[] dArray4 = (double[])dArray3.clone();
            for (int i = n; i < n2; ++i) {
                dArray4[i] = this.updateDiagonalHessianLogDensity(dArray[i], dArray2[i], dArray3[i]);
            }
            return dArray4;
        }

        @Override
        public double updateGradientInverseUnWeightedLogDensity(double d, double d2) {
            return d * this.gradientInverse(d2);
        }

        @Override
        public double updateGradientUnWeightedLogDensity(double d, double d2) {
            return d * this.gradient(d2);
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.updateGradientInverseUnWeightedLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.updateGradientUnWeightedLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            int n3 = n2 - n;
            double[][] dArray5 = new double[n3][n3];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray5[i][j] = i == j ? this.updateDiagonalHessianLogDensity(dArray[i][j], dArray3[i], dArray4[i]) : this.updateOffdiagonalHessianLogDensity(dArray[i][j], dArray2[i][j], dArray3[i], dArray3[j], dArray4[i], dArray4[j]);
                }
            }
            return dArray5;
        }

        @Override
        public abstract double gradientLogJacobianInverse(double var1);

        @Override
        public abstract double gradient(double var1);

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.gradient(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public abstract double logJacobian(double var1);

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            double d = 0.0;
            for (int i = n; i < n2; ++i) {
                d += this.logJacobian(dArray[i]);
            }
            return d;
        }

        @Override
        public boolean isMultivariate() {
            return false;
        }

        @Override
        public abstract boolean isInInteriorDomain(double var1);

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            for (double d : dArray) {
                if (this.isInInteriorDomain(d)) continue;
                return false;
            }
            return true;
        }

        @Override
        @Deprecated
        public double logGradientInverse(double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double[] logGradientInverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.logGradientInverse(dArray[i]);
            }
            return dArray2;
        }

        @Override
        @Deprecated
        public double derivativeOfTransformWrtValue(double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double[] derivativeOfTransformWrtValue(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.derivativeOfTransformWrtValue(dArray[i]);
            }
            return dArray2;
        }

        @Override
        @Deprecated
        public double secondDerivativeOfTransformWrtValue(double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double[] secondDerivativeOfTransformWrtValue(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.secondDerivativeOfTransformWrtValue(dArray[i]);
            }
            return dArray2;
        }

        @Override
        @Deprecated
        public double secondDerivativeOfInverseTransformWrtValue(double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double[] secondDerivativeOfInverseTransformWrtValue(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.secondDerivativeOfInverseTransformWrtValue(dArray[i]);
            }
            return dArray2;
        }

        @Override
        @Deprecated
        public double logSecondDerivativeOfInverseTransformWrtValue(double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double[] logSecondDerivativeOfInverseTransformWrtValue(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.logSecondDerivativeOfInverseTransformWrtValue(dArray[i]);
            }
            return dArray2;
        }
    }

    public static class LogConstrainedSumTransform
    extends MultivariableTransform {
        @Override
        public int getDimension() {
            return -1;
        }

        @Override
        public int getInputDimension() {
            return this.getDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.getDimension();
        }

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            double[] dArray2 = new double[n2 - n + 1];
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                dArray2[n3] = Math.log(dArray[i]);
                ++n3;
            }
            return dArray2;
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return d > 0.0 && !Double.isInfinite(d);
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            for (double d : dArray) {
                if (this.isInInteriorDomain(d)) continue;
                return false;
            }
            return true;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            int n3;
            double d = n2 - n + 1;
            double[] dArray2 = new double[n2 - n + 1];
            int n4 = 0;
            double d2 = 0.0;
            for (n3 = n; n3 <= n2; ++n3) {
                dArray2[n4] = Math.exp(dArray[n3]);
                d2 += dArray2[n4];
                ++n4;
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                dArray2[n3] = dArray2[n3] / d2 * d;
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            int n3;
            double[] dArray2 = new double[n2 - n + 1];
            int n4 = 0;
            double d2 = 0.0;
            for (n3 = n; n3 <= n2; ++n3) {
                dArray2[n4] = Math.exp(dArray[n3]);
                d2 += dArray2[n4];
                ++n4;
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                dArray2[n3] = dArray2[n3] / d2 * d;
            }
            return dArray2;
        }

        @Override
        public String getTransformName() {
            return "logConstrainedSum";
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            double d = 0.0;
            for (int i = n; i <= n2; ++i) {
                d -= Math.log(dArray[i]);
            }
            return d;
        }

        @Override
        public boolean isMultivariate() {
            return true;
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{1.5, 0.6, 0.9};
            System.err.print("Starting values: ");
            double d = 0.0;
            for (double d2 : dArray) {
                System.err.print(d2 + " ");
                d += d2;
            }
            System.err.println("\nSum = " + d);
            double[] dArray2 = LOG_CONSTRAINED_SUM.transform(dArray, 0, dArray.length - 1);
            System.err.print("Transformed values: ");
            for (double d3 : dArray2) {
                System.err.print(d3 + " ");
            }
            System.err.println();
            int n = 0;
            while (n < dArray2.length) {
                int n2 = n++;
                dArray2[n2] = dArray2[n2] + 0.2 * MathUtils.nextDouble();
            }
            dArray2 = LOG_CONSTRAINED_SUM.inverse(dArray2, 0, dArray2.length - 1);
            System.err.print("New values: ");
            double d4 = 0.0;
            for (double d5 : dArray2) {
                System.err.print(d5 + " ");
                d4 += d5;
            }
            System.err.println("\nSum = " + d4);
            if (d != d4) {
                System.err.println("Starting and ending constraints differ!");
            }
        }
    }

    public static class LogitTransform
    extends UnivariableTransform {
        private final double range;
        private final double lower;

        public LogitTransform() {
            this.range = 1.0;
            this.lower = 0.0;
        }

        @Override
        public Transform inverseTransform() {
            return SIGMOID;
        }

        @Override
        public double transform(double d) {
            return Math.log(d / (1.0 - d));
        }

        @Override
        public double inverse(double d) {
            return 1.0 / (1.0 + Math.exp(-d));
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return d > 0.0 && d < 1.0;
        }

        @Override
        public double gradientInverse(double d) {
            return this.gradient(this.inverse(d));
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return d * d2 * (1.0 - d2) - (2.0 * d2 - 1.0);
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return d * (1.0 - d);
        }

        @Override
        public String getTransformName() {
            return "logit";
        }

        @Override
        public double logJacobian(double d) {
            return -Math.log(1.0 - d) - Math.log(d);
        }
    }

    public static class SigmoidTransform
    extends UnivariableTransform {
        @Override
        public Transform inverseTransform() {
            return LOGIT;
        }

        @Override
        public double transform(double d) {
            return 1.0 / (1.0 + Math.exp(-d));
        }

        @Override
        public double inverse(double d) {
            return Math.log(d / (1.0 - d));
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return true;
        }

        @Override
        public double gradientInverse(double d) {
            return this.gradient(this.inverse(d));
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public String getTransformName() {
            return "sigmoid";
        }

        @Override
        public double logJacobian(double d) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public static class FisherZTransform
    extends UnivariableTransform {
        @Override
        public double transform(double d) {
            return FastMath.atanh(d);
        }

        @Override
        public double inverse(double d) {
            return FastMath.tanh(d);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return d > -1.0 && d < 1.0;
        }

        @Override
        public double gradientInverse(double d) {
            return 1.0 - Math.pow(this.inverse(d), 2.0);
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return (1.0 - d2 * d2) * d - 2.0 * d2;
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return -2.0 * this.inverse(d);
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            return (1.0 - d3 * d3) * (d * (1.0 - d3 * d3) - 2.0 * d2 * d3 - 2.0);
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return 1.0 - Math.pow(d, 2.0);
        }

        @Override
        public String getTransformName() {
            return "fisherz";
        }

        @Override
        public double logJacobian(double d) {
            return -Math.log1p(-d) - Math.log1p(d);
        }
    }

    public static class AffineTransform
    extends UnivariableTransform {
        private final double location;
        private final double scale;

        AffineTransform() {
            this.location = 0.0;
            this.scale = 1.0;
        }

        public AffineTransform(double d, double d2) {
            this.location = d;
            this.scale = d2;
        }

        @Override
        public String getTransformName() {
            return "Location Scale Transform";
        }

        @Override
        public double transform(double d) {
            return (d - this.location) / this.scale;
        }

        @Override
        public double inverse(double d) {
            return d * this.scale + this.location;
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return this.scale != 0.0;
        }

        @Override
        public double gradientInverse(double d) {
            return this.scale;
        }

        @Override
        public double logGradientInverse(double d) {
            return Math.log(this.scale);
        }

        @Override
        public double logJacobian(double d) {
            return -Math.log(this.scale);
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            return d * this.scale;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateGradientInverseUnWeightedLogDensity(double d, double d2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public static enum Type {
        NONE("none", new NoTransform()),
        LOG("log", new LogTransform()),
        EXP("exp", new ExpTransform()),
        NEGATE("negate", new NegateTransform()),
        LOG_NEGATE("log-negate", new Compose(new LogTransform(), new NegateTransform())),
        LOG_CONSTRAINED_SUM("logConstrainedSum", new LogConstrainedSumTransform()),
        LOGIT("logit", new LogitTransform()),
        SIGMOID("sigmoid", new SigmoidTransform()),
        FISHER_Z("fisherZ", new FisherZTransform()),
        INVERSE_SUM("inverseSum", new InverseSumTransform()),
        SQUARED("squared", new SquaredTransform()),
        ABS("abs", new AbsTransform()),
        POWER("power", new PowerTransform()),
        AFFINE("affine", new AffineTransform());

        private Transform transform;
        private String name;

        private Type(String string2, Transform transform) {
            this.name = string2;
            this.transform = transform;
        }

        public Transform getTransform() {
            return this.transform;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Util {
        public static Transform[] getListOfNoTransforms(int n) {
            Transform[] transformArray = new Transform[n];
            for (int i = 0; i < n; ++i) {
                transformArray[i] = NONE;
            }
            return transformArray;
        }

        public static Transform parseTransform(XMLObject xMLObject) {
            Transform transform = (Transform)xMLObject.getChild(Transform.class);
            ParsedTransform parsedTransform = (ParsedTransform)xMLObject.getChild(ParsedTransform.class);
            if (transform == null && parsedTransform != null) {
                return parsedTransform.transform;
            }
            return transform;
        }

        public static MultivariableTransform parseMultivariableTransform(Object object) {
            if (object instanceof MultivariableTransform) {
                return (MultivariableTransform)object;
            }
            if (object instanceof ParsedTransform) {
                return (MultivariableTransform)((ParsedTransform)object).transform;
            }
            return null;
        }
    }

    public static class ParsedTransform {
        public Transform transform;
        public int start;
        public int end;
        public int every = 1;
        public double fixedSum = 0.0;
        public List<Parameter> parameters = null;

        public ParsedTransform() {
        }

        public ParsedTransform(Transform transform, int n, int n2) {
            this.transform = transform;
            this.start = n;
            this.end = n2;
        }

        public ParsedTransform clone() {
            ParsedTransform parsedTransform = new ParsedTransform();
            parsedTransform.transform = this.transform;
            parsedTransform.start = this.start;
            parsedTransform.end = this.end;
            parsedTransform.every = this.every;
            parsedTransform.fixedSum = this.fixedSum;
            parsedTransform.parameters = this.parameters;
            return parsedTransform;
        }

        public boolean equivalent(ParsedTransform parsedTransform) {
            return this.start == parsedTransform.start && this.end == parsedTransform.end && this.every == parsedTransform.every && this.parameters == parsedTransform.parameters;
        }
    }

    public static class MultivariateArray
    extends MultivariateTransform {
        private final List<MultivariableTransform> array;

        public MultivariateArray(List<MultivariableTransform> list) {
            super(MultivariateArray.getInputDimensionArray(list), MultivariateArray.getOutputDimensionArray(list));
            this.array = list;
        }

        private static int getDimensionArray(List<MultivariableTransform> list) {
            int n = 0;
            for (MultivariableTransform multivariableTransform : list) {
                int n2 = multivariableTransform.getDimension();
                assert (n2 > 0) : "MultivariateArray only allows for transforms with a defined dimension.";
                n += n2;
            }
            return n;
        }

        private static int getInputDimensionArray(List<MultivariableTransform> list) {
            int n = 0;
            for (MultivariableTransform multivariableTransform : list) {
                n += multivariableTransform.getInputDimension();
            }
            return n;
        }

        private static int getOutputDimensionArray(List<MultivariableTransform> list) {
            int n = 0;
            for (MultivariableTransform multivariableTransform : list) {
                n += multivariableTransform.getOutputDimension();
            }
            return n;
        }

        @Override
        protected double[] transform(double[] dArray) {
            double[] dArray2 = (double[])dArray.clone();
            int n = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n2 = multivariableTransform.getDimension();
                double[] dArray3 = new double[n2];
                System.arraycopy(dArray, n, dArray3, 0, n2);
                System.arraycopy(multivariableTransform.transform(dArray3, 0, n2), 0, dArray2, n, n2);
                n += n2;
            }
            return dArray2;
        }

        @Override
        protected double[] inverse(double[] dArray) {
            double[] dArray2 = (double[])dArray.clone();
            int n = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n2 = multivariableTransform.getDimension();
                double[] dArray3 = new double[n2];
                System.arraycopy(dArray, n, dArray3, 0, n2);
                System.arraycopy(multivariableTransform.inverse(dArray3, 0, n2), 0, dArray2, n, n2);
                n += n2;
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray) {
            int n = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n2 = multivariableTransform.getDimension();
                double[] dArray2 = new double[n2];
                System.arraycopy(dArray, n, dArray2, 0, n2);
                if (!multivariableTransform.isInInteriorDomain(dArray2, 0, n2)) {
                    return false;
                }
                n += n2;
            }
            return true;
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            int n3 = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n4 = multivariableTransform.getDimension();
                double[] dArray3 = new double[n4];
                System.arraycopy(dArray, n3, dArray3, 0, n4);
                System.arraycopy(multivariableTransform.gradientInverse(dArray3, n, n2), 0, dArray2, n3, n4);
                n3 += n4;
            }
            return dArray2;
        }

        @Override
        protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
            double[] dArray3 = (double[])dArray2.clone();
            int n = 0;
            int n2 = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n3 = multivariableTransform.getInputDimension();
                int n4 = multivariableTransform.getOutputDimension();
                double[] dArray4 = new double[n4];
                System.arraycopy(dArray2, n, dArray4, 0, n4);
                double[] dArray5 = new double[n3];
                System.arraycopy(dArray, n, dArray5, 0, n3);
                System.arraycopy(multivariableTransform.updateGradientLogDensity(dArray5, dArray4, 0, n4), 0, dArray3, n2, n4);
                n += n3;
                n2 += n4;
            }
            return dArray3;
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            double[] dArray4 = (double[])dArray3.clone();
            int n3 = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n4 = multivariableTransform.getDimension();
                double[] dArray5 = new double[n4];
                System.arraycopy(dArray3, n3, dArray5, 0, n4);
                double[] dArray6 = new double[n4];
                System.arraycopy(dArray2, n3, dArray6, 0, n4);
                double[] dArray7 = new double[n4];
                System.arraycopy(dArray2, n3, dArray7, 0, n4);
                System.arraycopy(multivariableTransform.updateDiagonalHessianLogDensity(dArray7, dArray6, dArray5, n, n2), 0, dArray4, n3, n4);
                n3 += n4;
            }
            return dArray4;
        }

        @Override
        protected double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2) {
            double[] dArray3 = (double[])dArray2.clone();
            int n = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n2 = multivariableTransform.getDimension();
                double[] dArray4 = new double[n2];
                System.arraycopy(dArray2, n, dArray4, 0, n2);
                double[] dArray5 = new double[n2];
                System.arraycopy(dArray, n, dArray5, 0, n2);
                System.arraycopy(multivariableTransform.updateGradientInverseUnWeightedLogDensity(dArray5, dArray4, 0, n2), 0, dArray3, n, n2);
                n += n2;
            }
            return dArray3;
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            int n3 = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n4 = multivariableTransform.getDimension();
                double[] dArray3 = new double[n4];
                System.arraycopy(dArray, n3, dArray3, 0, n4);
                System.arraycopy(multivariableTransform.gradient(dArray3, n, n2), 0, dArray2, n3, n4);
                n3 += n4;
            }
            return dArray2;
        }

        @Override
        protected double getLogJacobian(double[] dArray) {
            double d = 0.0;
            int n = 0;
            for (MultivariableTransform multivariableTransform : this.array) {
                int n2 = multivariableTransform.getDimension();
                double[] dArray2 = new double[n2];
                System.arraycopy(dArray, n, dArray2, 0, n2);
                d += multivariableTransform.logJacobian(dArray2, 0, n2);
                n += n2;
            }
            return d;
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        protected double[] getGradientLogJacobianInverse(double[] dArray) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[][] computeJacobianMatrixInverse(double[] dArray) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public String getTransformName() {
            return "MultivariateArray";
        }

        @Override
        public boolean isMultivariate() {
            return true;
        }
    }

    public static class Collection
    extends MultivariableTransformWithParameter {
        private final List<ParsedTransform> segments;
        private final Parameter parameter;

        public Collection(List<ParsedTransform> list, Parameter parameter) {
            this.parameter = parameter;
            this.segments = this.ensureContiguous(list);
        }

        @Override
        public int getDimension() {
            return this.parameter.getDimension();
        }

        @Override
        public int getInputDimension() {
            return this.getDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.getDimension();
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        private List<ParsedTransform> ensureContiguous(List<ParsedTransform> list) {
            ArrayList<ParsedTransform> arrayList = new ArrayList<ParsedTransform>();
            int n = 0;
            for (ParsedTransform parsedTransform : list) {
                if (n < parsedTransform.start) {
                    arrayList.add(new ParsedTransform(NONE, n, parsedTransform.start));
                }
                arrayList.add(parsedTransform);
                n = parsedTransform.end;
            }
            if (n < this.parameter.getDimension()) {
                arrayList.add(new ParsedTransform(NONE, n, this.parameter.getDimension()));
            }
            return arrayList;
        }

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray2[i] = parsedTransform.transform.transform(dArray[i]);
                }
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray2[i] = parsedTransform.transform.inverse(dArray[i]);
                }
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    if (parsedTransform.transform.isInInteriorDomain(dArray[i])) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray2[i] = parsedTransform.transform.gradientInverse(dArray[i]);
                }
            }
            return dArray2;
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray3[i] = parsedTransform.transform.updateGradientLogDensity(dArray[i], dArray2[i]);
                }
            }
            return dArray3;
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            double[] dArray4 = (double[])dArray3.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray4[i] = parsedTransform.transform.updateDiagonalHessianLogDensity(dArray[i], dArray2[i], dArray3[i]);
                }
            }
            return dArray4;
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray3[i] = parsedTransform.transform.updateGradientInverseUnWeightedLogDensity(dArray[i], dArray2[i]);
                }
            }
            return dArray3;
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray3[i] = parsedTransform.transform.updateGradientUnWeightedLogDensity(dArray[i], dArray2[i]);
                }
            }
            return dArray3;
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    dArray2[i] = parsedTransform.transform.gradient(dArray[i]);
                }
            }
            return dArray2;
        }

        @Override
        public String getTransformName() {
            return "collection";
        }

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            double d = 0.0;
            for (ParsedTransform parsedTransform : this.segments) {
                if (n >= parsedTransform.end || n2 < parsedTransform.start) continue;
                int n3 = Math.max(parsedTransform.start, n);
                int n4 = Math.min(parsedTransform.end, n2);
                for (int i = n3; i < n4; ++i) {
                    d += parsedTransform.transform.logJacobian(dArray[i]);
                }
            }
            return d;
        }

        @Override
        public boolean isMultivariate() {
            return false;
        }
    }

    public static class Array
    extends MultivariableTransformWithParameter {
        private final List<Transform> array;
        private final Parameter parameter;

        public Array(List<Transform> list, Parameter parameter) {
            this.parameter = parameter;
            this.array = list;
        }

        public Array(Transform transform, int n, Parameter parameter) {
            ArrayList<Transform> arrayList = new ArrayList<Transform>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(transform);
            }
            this.parameter = parameter;
            this.array = arrayList;
        }

        @Override
        public int getDimension() {
            return this.array.size();
        }

        @Override
        public int getInputDimension() {
            return this.getDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.getDimension();
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.array.get(i).transform(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.array.get(i).inverse(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            for (int i = n; i < n2; ++i) {
                if (this.array.get(i).isInInteriorDomain(dArray[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.array.get(i).gradientInverse(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.array.get(i).updateGradientLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            double[] dArray4 = (double[])dArray3.clone();
            for (int i = n; i < n2; ++i) {
                dArray4[i] = this.array.get(i).updateDiagonalHessianLogDensity(dArray[i], dArray2[i], dArray3[i]);
            }
            return dArray4;
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.array.get(i).updateGradientInverseUnWeightedLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            double[] dArray3 = (double[])dArray2.clone();
            for (int i = n; i < n2; ++i) {
                dArray3[i] = this.array.get(i).updateGradientUnWeightedLogDensity(dArray[i], dArray2[i]);
            }
            return dArray3;
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            int n3 = n2 - n;
            double[][] dArray5 = new double[n3][n3];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (i == j) {
                        dArray5[i][j] = this.array.get(i).updateDiagonalHessianLogDensity(dArray[i][j], dArray3[i], dArray4[i]);
                        continue;
                    }
                    assert (this.array.get(i).getClass().equals(this.array.get(j).getClass()));
                    dArray5[i][j] = this.array.get(i).updateOffdiagonalHessianLogDensity(dArray[i][j], dArray2[i][j], dArray3[i], dArray3[j], dArray4[i], dArray4[j]);
                }
            }
            return dArray5;
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = n; i < n2; ++i) {
                dArray2[i] = this.array.get(i).gradient(dArray[i]);
            }
            return dArray2;
        }

        @Override
        public String getTransformName() {
            return "array";
        }

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            double d = 0.0;
            for (int i = n; i < n2; ++i) {
                d += this.array.get(i).logJacobian(dArray[i]);
            }
            return d;
        }

        @Override
        public boolean isMultivariate() {
            return false;
        }
    }

    public static class InverseMultivariate
    extends MultivariateTransform {
        private final MultivariateTransform inner;

        public InverseMultivariate(MultivariateTransform multivariateTransform) {
            super(multivariateTransform.getDimension());
            this.inner = multivariateTransform;
        }

        @Override
        public String getTransformName() {
            return "inverse." + this.inner.getTransformName();
        }

        @Override
        protected double[] transform(double[] dArray) {
            return this.inner.inverse(dArray);
        }

        @Override
        protected double[] inverse(double[] dArray) {
            return this.inner.transform(dArray);
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            throw new RuntimeException("not implemented yet.");
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not relevant.");
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            return this.inner.gradientInverse(dArray, n, n2);
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            return this.inner.gradient(dArray, n, n2);
        }

        @Override
        protected double getLogJacobian(double[] dArray) {
            return -this.inner.getLogJacobian(this.inner.inverse(dArray));
        }

        @Override
        protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
            double[] dArray3 = this.inner.getGradientLogJacobianInverse(dArray2);
            double[] dArray4 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray4[i] = dArray[i] - dArray3[i];
            }
            double[][] dArray5 = this.computeJacobianMatrix(dArray2);
            return this.updateGradientJacobian(dArray4, dArray5);
        }

        private double[][] computeJacobianMatrix(double[] dArray) {
            Matrix matrix = new Matrix(this.inner.computeJacobianMatrixInverse(dArray));
            return matrix.inverse().transpose().toComponents();
        }

        @Override
        public double[][] computeJacobianMatrixInverse(double[] dArray) {
            Matrix matrix = new Matrix(this.inner.computeJacobianMatrixInverse(this.inner.transform(dArray)));
            return matrix.inverse().transpose().toComponents();
        }

        @Override
        protected double[] getGradientLogJacobianInverse(double[] dArray) {
            double[] dArray2 = this.inner.getGradientLogJacobianInverse(dArray);
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = -dArray2[i];
            }
            return dArray2;
        }

        @Override
        public int getInputDimension() {
            return this.getDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.getDimension();
        }
    }

    public static class Inverse
    extends UnivariableTransform {
        private final UnivariableTransform inner;

        public Inverse(UnivariableTransform univariableTransform) {
            this.inner = univariableTransform;
        }

        @Override
        public String getTransformName() {
            return "inverse." + this.inner.getTransformName();
        }

        @Override
        public double transform(double d) {
            return this.inner.inverse(d);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double inverse(double d) {
            return this.inner.transform(d);
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double logJacobian(double d) {
            return -this.inner.logJacobian(this.inner.inverse(d));
        }
    }

    public static class ComposeMultivariable
    extends MultivariableTransform {
        private final MultivariableTransform outer;
        private final MultivariableTransform inner;

        public ComposeMultivariable(MultivariableTransform multivariableTransform, MultivariableTransform multivariableTransform2) {
            assert (multivariableTransform.getDimension() == multivariableTransform2.getDimension()) : "In ComposeMultivariable, transforms should have the same dimension.";
            this.outer = multivariableTransform;
            this.inner = multivariableTransform2;
        }

        @Override
        public int getDimension() {
            return this.outer.getDimension();
        }

        @Override
        public int getInputDimension() {
            return this.inner.getInputDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.outer.getOutputDimension();
        }

        @Override
        public String getTransformName() {
            return "compose." + this.outer.getTransformName() + "." + this.inner.getTransformName();
        }

        public Transform getInnerTransform() {
            return this.inner;
        }

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            return this.outer.transform(this.inner.transform(dArray, n, n2), n, n2);
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            return this.inner.inverse(this.outer.inverse(dArray, n, n2), n, n2);
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            if (this.inner.isInInteriorDomain(dArray, n, n2)) {
                return this.outer.isInInteriorDomain(this.inner.transform(dArray, n, n2), n, n2);
            }
            return false;
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.outer.updateGradientLogDensity(this.inner.updateGradientLogDensity(dArray, dArray2, n, n2), this.inner.transform(dArray2, n, n2), n, n2);
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            return this.outer.updateDiagonalHessianLogDensity(this.inner.updateDiagonalHessianLogDensity(dArray, dArray2, dArray3, n, n2), this.inner.updateGradientLogDensity(dArray2, dArray3, n, n2), this.inner.transform(dArray3, n, n2), n, n2);
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.outer.updateGradientInverseUnWeightedLogDensity(this.inner.updateGradientInverseUnWeightedLogDensity(dArray, this.outer.inverse(dArray2, n, n2), n, n2), dArray2, n, n2);
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.outer.updateGradientUnWeightedLogDensity(this.inner.updateGradientUnWeightedLogDensity(dArray, dArray2, n, n2), this.inner.transform(dArray2, n, n2), n, n2);
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            return this.inner.logJacobian(dArray, n, n2) + this.outer.logJacobian(this.inner.transform(dArray, n, n2), n, n2);
        }

        @Override
        public boolean isMultivariate() {
            return this.outer.isMultivariate() || this.inner.isMultivariate();
        }
    }

    public static class NoTransformMultivariable
    extends MultivariableTransform {
        @Override
        public int getDimension() {
            return -1;
        }

        @Override
        public int getInputDimension() {
            return this.getDimension();
        }

        @Override
        public int getOutputDimension() {
            return this.getDimension();
        }

        @Override
        public String getTransformName() {
            return "NoTransformMultivariate";
        }

        @Override
        public double[] transform(double[] dArray, int n, int n2) {
            return this.subArray(dArray, n, n2);
        }

        private double[] subArray(double[] dArray, int n, int n2) {
            int n3 = n2 - n;
            if (n3 == dArray.length) {
                return dArray;
            }
            double[] dArray2 = new double[n3];
            System.arraycopy(dArray, n2, dArray2, 0, n3);
            return dArray2;
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2) {
            return this.subArray(dArray, n, n2);
        }

        @Override
        public boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            return true;
        }

        @Override
        public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.subArray(dArray, n, n2);
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.subArray(dArray, n, n2);
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.subArray(dArray, n, n2);
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double[] inverse(double[] dArray, int n, int n2, double d) {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public double[] gradient(double[] dArray, int n, int n2) {
            return this.arrayValue(1.0, n, n2);
        }

        private double[] arrayValue(double d, int n, int n2) {
            int n3 = n2 - n;
            double[] dArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray[i] = d;
            }
            return dArray;
        }

        @Override
        public double[] gradientInverse(double[] dArray, int n, int n2) {
            return this.arrayValue(1.0, n, n2);
        }

        @Override
        public double logJacobian(double[] dArray, int n, int n2) {
            return 0.0;
        }

        @Override
        public boolean isMultivariate() {
            return false;
        }
    }

    public static class InverseSumTransform
    extends UnivariableTransform {
        private final double sum;

        InverseSumTransform() {
            this.sum = 1.0;
        }

        InverseSumTransform(double d) {
            this.sum = d;
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            return 0.0;
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            return 0.0;
        }

        @Override
        public String getTransformName() {
            return "inversedSum transform";
        }

        @Override
        public double transform(double d) {
            return d / (d * this.sum - 1.0);
        }

        @Override
        public double inverse(double d) {
            return this.transform(d);
        }

        @Override
        public double gradientInverse(double d) {
            return 0.0;
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            return 0.0;
        }

        @Override
        public double gradient(double d) {
            return 0.0;
        }

        @Override
        public double logJacobian(double d) {
            return 0.0;
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return false;
        }
    }

    public static class ReciprocalTransform
    extends UnivariableTransform {
        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            return 0.0;
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            return 0.0;
        }

        @Override
        public String getTransformName() {
            return "reciprocal transform";
        }

        @Override
        public double transform(double d) {
            return 1.0 / d;
        }

        @Override
        public double inverse(double d) {
            return 1.0 / d;
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("not yet implemented");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("not yet implemented");
        }

        @Override
        public double logJacobian(double d) {
            throw new RuntimeException("not yet implemented");
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            throw new RuntimeException("not yet implemented");
        }
    }

    public static class PowerTransform
    extends UnivariableTransform {
        private final double power;

        PowerTransform() {
            this.power = 2.0;
        }

        public PowerTransform(double d) {
            this.power = d;
        }

        @Override
        public String getTransformName() {
            return "Power Transform";
        }

        @Override
        public double transform(double d) {
            return Math.pow(d, this.power);
        }

        @Override
        public double inverse(double d) {
            return Math.pow(d, 1.0 / this.power);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            if (this.power == (double)((int)this.power)) {
                if (this.power >= 0.0) {
                    return true;
                }
                return d != 0.0;
            }
            return d > 0.0;
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateGradientInverseUnWeightedLogDensity(double d, double d2) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("not implemented yet");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double logJacobian(double d) {
            throw new RuntimeException("not implemented yet");
        }
    }

    public static class ScaledLogitTransform
    extends UnivariableTransform {
        private final double upper;
        private final double lower;

        public ScaledLogitTransform() {
            this.upper = 1.0;
            this.lower = 0.0;
        }

        public ScaledLogitTransform(double d, double d2) {
            this.upper = d;
            this.lower = d2;
        }

        @Override
        public double transform(double d) {
            return Math.log((d - this.lower) / (this.upper - d));
        }

        @Override
        public double inverse(double d) {
            double d2 = Math.exp(-d);
            return (this.upper + this.lower * d2) / (1.0 + d2);
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            return d > this.lower && d < this.upper;
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradientLogJacobianInverse(double d) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double gradient(double d) {
            return (d - this.lower) * (this.upper - d) / (this.upper - this.lower);
        }

        @Override
        public String getTransformName() {
            return "logit";
        }

        @Override
        public double logJacobian(double d) {
            return Math.log(this.upper - this.lower) - Math.log(this.upper - d) - Math.log(d - this.lower);
        }
    }

    public static abstract class MatrixVariateTransform
    extends MultivariateTransform {
        protected final int rowDimension;
        protected final int columnDimension;

        public MatrixVariateTransform(int n, int n2, int n3) {
            super(n, n2 * n3);
            this.rowDimension = n2;
            this.columnDimension = n3;
        }

        public int getRowDimension() {
            return this.rowDimension;
        }

        public int getColumnDimension() {
            return this.columnDimension;
        }
    }

    public static abstract class MultivariateTransform
    extends MultivariableTransform {
        protected int dim;
        protected int inputDimension;
        protected int outputDimension;

        public MultivariateTransform(int n) {
            this(n, n);
        }

        public MultivariateTransform(int n, int n2) {
            this.inputDimension = n;
            this.outputDimension = n2;
            this.dim = n2;
        }

        @Override
        public int getInputDimension() {
            return this.inputDimension;
        }

        @Override
        public int getOutputDimension() {
            return this.outputDimension;
        }

        @Override
        public int getDimension() {
            return this.dim;
        }

        protected abstract double[] transform(double[] var1);

        @Override
        public final double[] transform(double[] dArray, int n, int n2) {
            assert (n == 0 && n2 == dArray.length && this.dim == dArray.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.transform(dArray);
        }

        protected abstract double[] inverse(double[] var1);

        @Override
        public final double[] inverse(double[] dArray, int n, int n2) {
            assert (n == 0 && n2 == dArray.length && this.dim == dArray.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.inverse(dArray);
        }

        protected abstract double getLogJacobian(double[] var1);

        @Override
        public final double logJacobian(double[] dArray, int n, int n2) {
            assert (n == 0 && n2 == dArray.length && this.dim == dArray.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.getLogJacobian(dArray);
        }

        @Override
        public final double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            assert (n == 0 && n2 == dArray2.length && this.dim == dArray2.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.updateGradientLogDensity(dArray, dArray2);
        }

        protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
            double[] dArray3 = this.transform(dArray2, 0, dArray2.length);
            double[] dArray4 = this.updateGradientInverseUnWeightedLogDensity(dArray, dArray3);
            double[] dArray5 = this.getGradientLogJacobianInverse(dArray3);
            for (int i = 0; i < dArray.length; ++i) {
                int n = i;
                dArray4[n] = dArray4[n] + dArray5[i];
            }
            return dArray4;
        }

        @Override
        public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
            throw new RuntimeException("Not yet implemented");
        }

        protected double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2) {
            double[][] dArray3 = this.computeJacobianMatrixInverse(dArray2);
            return this.updateGradientJacobian(dArray, dArray3);
        }

        @Override
        public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            assert (n == 0 && n2 == dArray2.length && this.dim == dArray2.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.updateGradientInverseUnWeightedLogDensity(dArray, dArray2);
        }

        double[] updateGradientJacobian(double[] dArray, double[][] dArray2) {
            double[] dArray3 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    int n = i;
                    dArray3[n] = dArray3[n] + dArray2[i][j] * dArray[j];
                }
            }
            return dArray3;
        }

        @Override
        public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
            return this.updateGradientInverseUnWeightedLogDensity(dArray, this.transform(dArray2, n, n2), n, n2);
        }

        protected abstract double[] getGradientLogJacobianInverse(double[] var1);

        public abstract double[][] computeJacobianMatrixInverse(double[] var1);

        @Override
        public boolean isMultivariate() {
            return true;
        }

        protected abstract boolean isInInteriorDomain(double[] var1);

        @Override
        public final boolean isInInteriorDomain(double[] dArray, int n, int n2) {
            assert (n == 0 && n2 == dArray.length && this.dim == dArray.length) : "The multivariate transform function can only be applied to the whole array of values.";
            return this.isInInteriorDomain(dArray);
        }
    }

    public static abstract class MultivariableTransformWithParameter
    extends MultivariableTransform {
        public abstract Parameter getParameter();
    }

    public static abstract class MultivariableTransform
    implements Transform {
        public abstract int getDimension();

        public abstract int getInputDimension();

        public abstract int getOutputDimension();

        @Override
        public double transform(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double inverse(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double updateGradientLogDensity(double d, double d2) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double updateDiagonalHessianLogDensity(double d, double d2, double d3) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double updateOffdiagonalHessianLogDensity(double d, double d2, double d3, double d4, double d5, double d6) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double updateGradientInverseUnWeightedLogDensity(double d, double d2) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double updateGradientUnWeightedLogDensity(double d, double d2) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        protected double getGradientLogJacobianInverse(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double gradientInverse(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double gradient(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public double logJacobian(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        public boolean isInInteriorDomain(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double logGradientInverse(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double[] logGradientInverse(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double derivativeOfTransformWrtValue(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double[] derivativeOfTransformWrtValue(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double secondDerivativeOfTransformWrtValue(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double[] secondDerivativeOfTransformWrtValue(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double secondDerivativeOfInverseTransformWrtValue(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double[] secondDerivativeOfInverseTransformWrtValue(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        @Deprecated
        public double logSecondDerivativeOfInverseTransformWrtValue(double d) {
            throw new RuntimeException("Transformation not permitted for this type of parameter, exiting ...");
        }

        @Override
        @Deprecated
        public double[] logSecondDerivativeOfInverseTransformWrtValue(double[] dArray, int n, int n2) {
            throw new RuntimeException("Not yet implemented.");
        }
    }
}

