/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.MicrosatelliteSamplerTreeModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.oldevomodel.substmodel.MicrosatelliteModel;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import java.util.ArrayList;

@Deprecated
public class MicrosatelliteSamplerTreeLikelihood
extends AbstractTreeLikelihood {
    MicrosatelliteSamplerTreeModel treeMicrosatSamplerModel;
    MicrosatelliteModel microsatelliteModel;
    BranchRateModel branchRateModel;
    double logL = 0.0;
    double storedLogL = 0.0;
    boolean modelChanged = false;
    private ArrayList<Integer> updateAllList;
    private ArrayList<Integer> updatedNodeList;

    public MicrosatelliteSamplerTreeLikelihood(MicrosatelliteSamplerTreeModel microsatelliteSamplerTreeModel, MicrosatelliteModel microsatelliteModel, BranchRateModel branchRateModel) {
        super("MicrosatelliteSamplerTreeLikelihood", microsatelliteSamplerTreeModel.getMicrosatPattern(), microsatelliteSamplerTreeModel.getTreeModel());
        this.treeMicrosatSamplerModel = microsatelliteSamplerTreeModel;
        this.microsatelliteModel = microsatelliteModel;
        this.branchRateModel = branchRateModel;
        this.updateAllList = new ArrayList();
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateAllList.add(i);
        }
        this.updatedNodeList = this.updateAllList;
        this.addModel(this.branchRateModel);
        this.addModel(this.treeMicrosatSamplerModel);
        this.addModel(this.microsatelliteModel);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (this.updatedNodeList != this.updateAllList) {
            if (model == this.treeModel) {
                if (object instanceof TreeChangedEvent) {
                    if (((TreeChangedEvent)object).isTreeChanged()) {
                        this.updateAllNodes();
                    } else if (((TreeChangedEvent)object).isNodeChanged()) {
                        this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                    } else if (((TreeChangedEvent)object).isTreeChanged()) {
                        System.err.println("Full tree update event - these events currently aren't used\nso either this is in error or a new feature is using them so remove this message.");
                        this.updateAllNodes();
                    } else {
                        System.err.println("Another tree event has occured (possibly a trait change).");
                    }
                }
            } else if (model == this.treeMicrosatSamplerModel) {
                if (this.treeMicrosatSamplerModel.areInternalNodesChanged()) {
                    this.updateNodeAndChildren(this.treeMicrosatSamplerModel.getTreeModel().getNode(n));
                    this.treeMicrosatSamplerModel.setInternalNodesChanged(false);
                }
            } else if (model == this.microsatelliteModel) {
                if (this.microsatelliteModel.isModelUpdated()) {
                    this.updateAllNodes();
                }
            } else if (model == this.branchRateModel) {
                if (n == -1) {
                    this.updateAllNodes();
                } else {
                    this.updateNode(this.treeModel.getNode(n));
                }
            } else {
                throw new RuntimeException("Unknown componentChangedEvent");
            }
        }
        this.modelChanged = true;
        super.handleModelChangedEvent(model, object, n);
    }

    public boolean hasModelChanged() {
        return this.modelChanged;
    }

    @Override
    protected void updateNodeAndChildren(NodeRef nodeRef) {
        int n = nodeRef.getNumber();
        if (!this.updateNode[n]) {
            this.updateNode[n] = true;
            this.updatedNodeList.add(n);
        }
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            int n2 = this.treeModel.getChild(nodeRef, i).getNumber();
            if (this.updateNode[n2]) continue;
            this.updateNode[n2] = true;
            this.updatedNodeList.add(n2);
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void updateAllNodes() {
        this.updatedNodeList = this.updateAllList;
        this.likelihoodKnown = false;
    }

    @Override
    public double calculateLogLikelihood() {
        this.traverse();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.updatedNodeList.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.updatedNodeList.get(i);
            if (this.modelChanged && this.updatedNodeList != this.updateAllList) {
                d2 += this.treeMicrosatSamplerModel.getStoredLogBranchLikelihood(n2);
            }
            d3 += this.treeMicrosatSamplerModel.getLogBranchLikelihood(n2);
            this.updateNode[n2] = false;
        }
        if (this.modelChanged && this.updatedNodeList != this.updateAllList) {
            d = this.logL - d2;
        }
        this.logL = d + d3;
        this.modelChanged = false;
        this.updatedNodeList = new ArrayList();
        return this.logL;
    }

    @Override
    protected void storeState() {
        this.storedLogL = this.logL;
        super.storeState();
    }

    @Override
    protected void restoreState() {
        this.logL = this.storedLogL;
        super.restoreState();
    }

    private void traverse() {
        TreeModel treeModel = this.treeMicrosatSamplerModel.getTreeModel();
        int n = this.updatedNodeList.size();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = treeModel.getNode(this.updatedNodeList.get(i));
            int n2 = this.treeMicrosatSamplerModel.getNodeValue(nodeRef);
            if (!treeModel.isRoot(nodeRef)) {
                NodeRef nodeRef2 = treeModel.getParent(nodeRef);
                int n3 = this.treeMicrosatSamplerModel.getNodeValue(nodeRef2);
                double d = treeModel.getBranchLength(nodeRef) * this.branchRateModel.getBranchRate(treeModel, nodeRef);
                double d2 = this.microsatelliteModel.getLogOneTransitionProbabilityEntry(d, n3, n2);
                this.treeMicrosatSamplerModel.setLogBranchLikelihood(nodeRef, d2);
                continue;
            }
            double d = Math.log(this.microsatelliteModel.getStationaryDistribution()[n2]);
            this.treeMicrosatSamplerModel.setLogBranchLikelihood(nodeRef, d);
        }
    }
}

