/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.lineage;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.util.TaxonList;
import dr.oldevomodel.lineage.LineageSitePatterns;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class LineageSitePatternsParser
extends AbstractXMLObjectParser {
    public static final String PATTERNS = "lineageSNPS";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String EVERY = "every";
    public static final String TAXON_LIST = "taxonList";
    public static final String STRIP = "strip";
    public static final String UNIQUE = "unique";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("from", true, "The site position to start at, default is 1 (the first position)"), AttributeRule.newIntegerRule("to", true, "The site position to finish at, must be greater than <b>from</b>, default is length of given alignment"), AttributeRule.newIntegerRule("every", true, "Determines how many sites are selected. A value of 3 will select every third site starting from <b>from</b>, default is 1 (every site)"), new ElementRule("taxonList", new XMLSyntaxRule[]{new ElementRule(TaxonList.class)}, true), new ElementRule(Alignment.class), AttributeRule.newBooleanRule("strip", true, "Strip out completely ambiguous sites"), AttributeRule.newBooleanRule("unique", true, "Return a weight list of unique patterns")};

    @Override
    public String getParserName() {
        return PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        TaxonList taxonList = null;
        int n = 0;
        int n2 = -1;
        int n3 = xMLObject.getAttribute(EVERY, 1);
        boolean bl = xMLObject.getAttribute(STRIP, true);
        boolean bl2 = xMLObject.getAttribute(UNIQUE, true);
        if (xMLObject.hasAttribute(FROM) && (n = xMLObject.getIntegerAttribute(FROM) - 1) < 0) {
            throw new XMLParseException("illegal 'from' attribute in patterns element");
        }
        if (xMLObject.hasAttribute(TO) && ((n2 = xMLObject.getIntegerAttribute(TO) - 1) < 0 || n2 < n)) {
            throw new XMLParseException("illegal 'to' attribute in patterns element");
        }
        if (n3 <= 0) {
            throw new XMLParseException("illegal 'every' attribute in patterns element");
        }
        if (xMLObject.hasChildNamed(TAXON_LIST)) {
            taxonList = (TaxonList)xMLObject.getElementFirstChild(TAXON_LIST);
        }
        if (n > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'from' attribute in patterns element");
        }
        if (n2 > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'to' attribute in patterns element");
        }
        LineageSitePatterns lineageSitePatterns = new LineageSitePatterns(alignment, taxonList, n, n2, n3, bl, bl2);
        int n4 = n + 1;
        int n5 = n2 + 1;
        if (n2 == -1) {
            n5 = alignment.getSiteCount();
        }
        if (xMLObject.hasAttribute("id")) {
            Logger logger = Logger.getLogger("dr.evoxml");
            logger.info("Site patterns '" + xMLObject.getId() + "' created from positions " + Integer.toString(n4) + "-" + Integer.toString(n5) + " of alignment '" + alignment.getId() + "'");
            if (n3 > 1) {
                logger.info("  only using every " + n3 + " site");
            }
            logger.info("  pattern count = " + lineageSitePatterns.getPatternCount());
        }
        return lineageSitePatterns;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

