/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.AbstractLKJDistribution;
import dr.math.matrixAlgebra.WrappedMatrix;

public class LKJCholeskyCorrelationDistribution
extends AbstractLKJDistribution {
    public static final String TYPE = "LKJCholeskyCorrelation";

    public LKJCholeskyCorrelationDistribution(int n, double d) {
        super(n, d);
    }

    public LKJCholeskyCorrelationDistribution(int n) {
        super(n);
    }

    @Override
    public double logPdf(double[] dArray) {
        assert (dArray.length == LKJCholeskyCorrelationDistribution.upperTriangularSize(this.dim));
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(dArray, this.dim);
        return this.logPdf(wrappedUpperTriangularMatrix);
    }

    private double logPdf(WrappedMatrix wrappedMatrix) {
        double d = 2.0 * this.shape - 2.0;
        double d2 = 0.0;
        for (int i = 1; i < this.dim; ++i) {
            d2 += ((double)(this.dim - i - 1) + d) * Math.log(wrappedMatrix.get(i, i));
        }
        return d2 += this.logNormalizationConstant;
    }

    private double[] gradLogPdf(double[] dArray) {
        assert (dArray.length == LKJCholeskyCorrelationDistribution.upperTriangularSize(this.dim));
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(dArray, this.dim);
        return LKJCholeskyCorrelationDistribution.gradLogPdf(wrappedUpperTriangularMatrix, this.shape);
    }

    private static double[] gradLogPdf(WrappedMatrix wrappedMatrix, double d) {
        int n = wrappedMatrix.getMajorDim();
        double d2 = 2.0 * d - 2.0;
        double[] dArray = new double[n * (n - 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[n2] = -((double)(n - j - 1) + d2) * wrappedMatrix.get(i, j) / Math.pow(wrappedMatrix.get(j, j), 2.0);
                ++n2;
            }
        }
        return dArray;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }
}

