/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.distributions.MultivariateDistribution;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class ConstrainedDeterminantDistributionModel
implements MultivariateDistribution,
GradientProvider {
    private final int dim;
    private final double shape;

    public ConstrainedDeterminantDistributionModel(double d, int n) {
        this.dim = n;
        this.shape = d;
    }

    @Override
    public int getDimension() {
        return this.dim * this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }

    private double[] gradLogPdf(double[] dArray) {
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.dim, this.dim, dArray);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        CommonOps.scale(this.shape, denseMatrix64F2);
        CommonOps.transpose(denseMatrix64F2);
        return denseMatrix64F2.getData();
    }

    @Override
    public double logPdf(double[] dArray) {
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.dim, this.dim, dArray);
        double d = CommonOps.det(denseMatrix64F);
        return this.shape * Math.log(Math.abs(d));
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getType() {
        return "ConstrainedDeterminant";
    }
}

